<?php
/** Performs all actions pertaining to Constant Contact Campaigns
 *
 * @package Services
 * @author Constant Contact
*/
namespace Ctct\Services;
use Ctct\Util\RestClient;
use Ctct\Util\Config;
use Ctct\Components\EmailMarketing\Campaign;
use Ctct\Components\ResultSet;
class EmailMarketingService extends BaseService
{
public function addCampaign($accessToken, Campaign $campaign)
{
$baseUrl = Config::get('endpoints.base_url') . Config::get('endpoints.campaigns');
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->post($url, parent::getHeaders($accessToken), $campaign->toJson());
return Campaign::create(json_decode($response->body, true));
}
public function getCampaigns($accessToken, Array $params = null)
{
$baseUrl = Config::get('endpoints.base_url') . Config::get('endpoints.campaigns');
$url = $this->buildUrl($baseUrl, $params);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
$body = json_decode($response->body, true);
$campaigns = array();
foreach ($body['results'] as $contact){
$campaigns[] = Campaign::createSummary($contact);
}
return new ResultSet($campaigns, $body['meta']);
}
public function getCampaign($accessToken, $campaign_id)
{
$baseUrl = Config::get('endpoints.base_url') . sprintf(Config::get('endpoints.campaign'), $campaign_id);
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
return Campaign::create(json_decode($response->body, true));
}
public function deleteCampaign($accessToken, $campaign_id)
{
$baseUrl = Config::get('endpoints.base_url') . sprintf(Config::get('endpoints.campaign'), $campaign_id);
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->delete($url, parent::getHeaders($accessToken));
return ($response->info['http_code'] == 204) ? true : false;
}
public function updateCampaign($accessToken, Campaign $campaign)
{
$baseUrl = Config::get('endpoints.base_url') . sprintf(Config::get('endpoints.campaign'), $campaign->id);
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->put($url, parent::getHeaders($accessToken), $campaign->toJson());
return Campaign::create(json_decode($response->body, true));
}
}
