<?php
/** Performs all actions pertaining to Constant Contact Lists
 *
 * @package	 Services
 * @author		 Constant Contact
*/
namespace Ctct\Services;
use Ctct\Util\RestClient;
use Ctct\Util\Config;
use Ctct\Components\Contacts\ContactList;
use Ctct\Components\Contacts\Contact;
use Ctct\Components\ResultSet;
class ListService extends BaseService
{
public function getLists($accessToken, array $params = array())
{
$baseUrl = Config::get('endpoints.base_url') . Config::get('endpoints.lists');
$url = $this->buildUrl($baseUrl, $params);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
$lists = array();
foreach (json_decode($response->body, true) as $contact){
$lists[] = ContactList::create($contact);
}
return $lists;
}
public function addList($accessToken, ContactList $list)
{
$baseUrl = Config::get('endpoints.base_url') . Config::get('endpoints.lists');
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->post($url, parent::getHeaders($accessToken), $list->toJson());
return ContactList::create(json_decode($response->body, true));
}
public function updateList($accessToken, ContactList $list)
{
$baseUrl = Config::get('endpoints.base_url') . sprintf(Config::get('endpoints.list'), $list->id);
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->put($url, parent::getHeaders($accessToken), $list->toJson());
return ContactList::create(json_decode($response->body, true));
}
public function getList($accessToken, $list_id)
{
$baseUrl = Config::get('endpoints.base_url') . sprintf(Config::get('endpoints.list'), $list_id);
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
return ContactList::create(json_decode($response->body, true));
}
public function getContactsFromList($accessToken, $list_id, $params = null)
{
$baseUrl = Config::get('endpoints.base_url') . sprintf(Config::get('endpoints.list_contacts'), $list_id);
$url = $this->buildUrl($baseUrl, $params);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
$body = json_decode($response->body, true);
$contacts = array();
foreach ($body['results'] as $contact){
$contacts[] = Contact::create($contact);
}
return new ResultSet($contacts, $body['meta']);
}
}
