<?php
/** SplClassLoader implementation that implements the technical interoperability
 * standards for PHP 5.3 namespaces and class names.
 *
 * http://groups.google.com/group/php-standards/web/final-proposal
 *
 *	 // Example which loads classes for the Doctrine Common package in the
 *	 // Doctrine\Common namespace.
 *	 $classLoader = new SplClassLoader('Doctrine\Common', '/path/to/doctrine');
 *	 $classLoader->register();
 *
 * @author Jonathan H. Wage <jonwage@gmail.com>
 * @author Roman S. Borschel <roman@code-factory.org>
 * @author Matthew Weier O'Phinney <matthew@zend.com>
 * @author Kris Wallsmith <kris.wallsmith@gmail.com>
 * @author Fabien Potencier <fabien.potencier@symfony-project.org>
*/
namespace Ctct;
class SplClassLoader
{
private $fileExtension = '.php';
private $namespace;
private $includePath;
private $namespaceSeparator = '\\';
public function __construct($ns = null, $includePath = null)
{
$this->namespace = $ns;
$this->includePath = $includePath;
}
public function setNamespaceSeparator($sep)
{
$this->namespaceSeparator = $sep;
}
public function getNamespaceSeparator()
{
return $this->namespaceSeparator;
}
public function setIncludePath($includePath)
{
$this->includePath = $includePath;
}
public function getIncludePath()
{
return $this->includePath;
}
public function setFileExtension($fileExtension)
{
$this->fileExtension = $fileExtension;
}
public function getFileExtension()
{
return $this->fileExtension;
}
public function register()
{
spl_autoload_register(array($this, 'loadClass'));
}
public function unregister()
{
spl_autoload_unregister(array($this, 'loadClass'));
}
public function loadClass($className)
{
if (null === $this->namespace || $this->namespace . $this->namespaceSeparator ===
substr($className, 0, strlen($this->namespace . $this->namespaceSeparator))
){
$fileName = '';
$namespace = '';
if (false !== ($lastNsPos = strripos($className, $this->namespaceSeparator))){
$namespace = substr($className, 0, $lastNsPos);
$className = substr($className, $lastNsPos + 1);
$fileName = str_replace($this->namespaceSeparator, DIRECTORY_SEPARATOR, $namespace)
. DIRECTORY_SEPARATOR;
}
$fileName .= str_replace('_', DIRECTORY_SEPARATOR, $className) . $this->fileExtension;
require ($this->includePath !== null ? $this->includePath . DIRECTORY_SEPARATOR : '') . $fileName;
}
}
}
