<?php
/*
GNU General Public License for more details.
@author geoPlugin (gp_support@geoplugin.com)
@copyright Copyright geoPlugin (gp_support@geoplugin.com)
$version 1.01
See http://www.geoplugin.com/webservices/php for more specific details of this free service
*/

class geoPlugin {
var $host='http://www.geoplugin.net/php.gp?ip={IP}&base_currency={CURRENCY}';
var $currency='USD';
var $ip=null;
var $city=null;
var $region=null;
var $areaCode=null;
var $dmaCode=null;
var $countryCode=null;
var $countryName=null;
var $continentCode=null;
var $latitude=null;
var $longitude=null;
var $currencyCode=null;
var $currencySymbol=null;
var $currencyConverter=null;
function geoPlugin(){}
function locate($ip=null){
global $_SERVER;
if(is_null( $ip)){
$ip=$_SERVER['REMOTE_ADDR'];
}

$host=str_replace( '{IP}', $ip, $this->host );
$host=str_replace( '{CURRENCY}', $this->currency, $host );
$data=array();
$response=$this->fetch($host);
if($response){
$data=unserialize($response);
}else{
$data=array();
}
$this->ip=$ip;
$this->city=isset($data['geoplugin_city']) ? $data['geoplugin_city'] :false;
$this->region=isset($data['geoplugin_region']) ? $data['geoplugin_region'] :false;
$this->areaCode=isset($data['geoplugin_areaCode'])? $data['geoplugin_areaCode'] :false;
$this->dmaCode=isset($data['geoplugin_dmaCode']) ? $data['geoplugin_dmaCode'] :false;
$this->countryCode=isset($data['geoplugin_countryCode']) ? $data['geoplugin_countryCode'] :false;
$this->countryName=isset($data['geoplugin_countryName']) ? $data['geoplugin_countryName'] :false;
$this->continentCode= isset($data['geoplugin_continentCode']) ? $data['geoplugin_continentCode'] :false;
$this->latitude=isset($data['geoplugin_latitude']) ? $data['geoplugin_latitude'] :false;
$this->longitude=isset($data['geoplugin_longitude']) ? $data['geoplugin_longitude'] :false;
$this->currencyCode=isset($data['geoplugin_currencyCode'])? $data['geoplugin_currencyCode'] :false;
$this->currencySymbol=isset($data['geoplugin_currencySymbol']) ? $data['geoplugin_currencySymbol'] :false;
$this->currencyConverter= isset($data['geoplugin_currencyConverter']) ? $data['geoplugin_currencyConverter'] :false;
}
function fetch($host){
if(function_exists('curl_init')){
$ch=curl_init();
curl_setopt($ch, CURLOPT_URL, $host);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_USERAGENT, 'geoPlugin PHP Class v1.0');
$response=curl_exec($ch);
curl_close ($ch);
}else if(ini_get('allow_url_fopen')){
$response=file_get_contents($host, 'r');
}else{
trigger_error ('geoPlugin class Error:Cannot retrieve data. Either compile PHP with cURL support or enable allow_url_fopen in php.ini ', E_USER_ERROR);
return;
}
return $response;
}
function convert($amount, $float=2, $symbol=true){
if(!is_numeric($this->currencyConverter) || $this->currencyConverter == 0){
trigger_error('geoPlugin class Notice:currencyConverter has no value.', E_USER_NOTICE);
return $amount;
}
if(!is_numeric($amount)){
trigger_error ('geoPlugin class Warning:The amount passed to geoPlugin::convert is not numeric.', E_USER_WARNING);
return $amount;
}
if($symbol === true){
return $this->currencySymbol . round( ($amount * $this->currencyConverter), $float );
}else{
return round( ($amount * $this->currencyConverter), $float );
}
}
function nearby($radius=10, $limit=null){
if(!is_numeric($this->latitude) || !is_numeric($this->longitude)){
trigger_error ('geoPlugin class Warning:Incorrect latitude or longitude values.', E_USER_NOTICE);
return array( array() );
}
$host="http://www.geoplugin.net/extras/nearby.gp?lat=" . $this->latitude . "&long=" . $this->longitude . "&radius={$radius}";
if(is_numeric($limit) )
$host .= "&limit={$limit}";
return unserialize( $this->fetch($host) );
}}