<?php
/**
 * @version		2.5.0
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

/**
 * Contact Enhanced Component HTML Helper
 *
 * @static
 * @package		com_contactenhanced
 * @since 2.5
 */
class JHTMLCeicon
{

	/**
	 * Display an edit icon for the article.
	 *
	 * This icon will not display in a popup window, nor if the contact is trashed.
	 * Edit access checks must be performed in the calling code.
	 *
	 * @param	object	$contact	The article in question.
	 * @param	object	$params		The article parameters
	 * @param	array	$attribs	Not used??
	 *
	 * @return	string	The HTML for the article edit icon.
	 * @since	2.5
	 */
	public static function edit(&$contact, &$params, $attribs = array(), $legacy = false)
	{
		$user = JFactory::getUser();
		$userId	= $user->get('id');
		$uri  = JUri::getInstance();
		JFactory::getLanguage()->load('com_content');

		// Ignore if the state is negative (trashed).
		if($contact->published < 0) {
			return;
		}

		// Ignore if in a popup window.
		if($params && $params->get('popup'))
		{
			return;
		}

		// Ignore if the state is negative (trashed).
		if($contact->state < 0)
		{
			return;
		}


		// Show checked_out icon if the article is checked out by a different user
		if (property_exists($contact, 'checked_out')
				&& property_exists($contact, 'checked_out_time')
				&& $contact->checked_out > 0
				&& $contact->checked_out != $user->get('id'))
		{
			$checkoutUser = JFactory::getUser($contact->checked_out);
			$button       = JHtml::_('image', 'system/checked_out.png', null, null, true);
			$date         = JHtml::_('date', $contact->checked_out_time);
			$tooltip      = JText::_('JLIB_HTML_CHECKED_OUT') . ' :: ' . JText::sprintf('COM_CONTACTENHANCED_CHECKED_OUT_BY', $checkoutUser->name) . ' <br /> ' . $date;

			return '<span class="hasTooltip" title="' . JHtml::tooltipText($tooltip. '', 0) . '">' . $button . '</span>';
		}

		$url	= ContactenchancedHelperRoute::getContactEditRoute($contact->slug, $contact->catid);

		if($contact->published == 0)
		{
			$overlib = JText::_('JUNPUBLISHED');
		}
		else
		{
			$overlib = JText::_('JPUBLISHED');
		}

		$date   = JHtml::_('date', $contact->created);
		$author = $contact->created_by_alias ? $contact->created_by_alias : JFactory::getUser($contact->user_id)->get('name');

		$overlib .= '&lt;br /&gt;';
		$overlib .= $date;
		$overlib .= '&lt;br /&gt;';
		$overlib .= JText::sprintf('COM_CONTACTENHANCED_LINKED_USER', htmlspecialchars($author, ENT_COMPAT, 'UTF-8'));

		if($legacy)
		{
			$icon = $contact->published ? 'edit.png' : 'edit_unpublished.png';
			if (strtotime($contact->publish_up) > strtotime(JFactory::getDate())
			|| ((strtotime($contact->publish_down) < strtotime(JFactory::getDate())) && $contact->publish_down != '0000-00-00 00:00:00'))
			{
				$icon = 'edit_unpublished.png';
			}
			$text = JHtml::_('image', 'system/' . $icon, JText::_('JGLOBAL_EDIT'), null, true);
		}
		else
		{
			$icon = $contact->published ? 'edit' : 'eye-close';
			if (strtotime($contact->publish_up) > strtotime(JFactory::getDate())
			|| ((strtotime($contact->publish_down) < strtotime(JFactory::getDate())) && $contact->publish_down != '0000-00-00 00:00:00'))
			{
				$icon = 'eye-close';
			}
			$text = '<span class="hasTooltip icon-' . $icon . ' tip" title="' . JHtml::tooltipText(JText::_('JGLOBAL_EDIT'), $overlib, 0) . '"></span>&#160;' . JText::_('JGLOBAL_EDIT') . '&#160;';
		}

		$output = JHtml::_('link', JRoute::_($url), $text, $attribs);

		return $output;
	}
}
