<?php
/**
* simpleGMapGeocoder | simpleGMapGeocoder is part of simpleGMapAPI
*					  Heiko Holtkamp, 2010
* simpleGMapGeocoder
* is used for geocoding and is part of simpleGMapAPI
*
* @class		simpleGMapGeocoder
* @author	   Heiko Holtkamp <heiko@rvs.uni-bielefeld.de>
* @version	  0.1.3
* @copyright	2010 HH
*/

class simpleGMapGeocoder {
function getGeoCoords($address)
{
	$coords = array();
	$address = utf8_encode($address);
	// call geoencoding api with param json for output
	$geoCodeURL = "http://maps.google.com/maps/api/geocode/json?address=".
				  urlencode($address)."&sensor=false";
	$result = json_decode(file_get_contents($geoCodeURL), true);
	$coords['status'] = $result["status"];
	$coords['lat'] = $result["results"][0]["geometry"]["location"]["lat"];
	$coords['lng'] = $result["results"][0]["geometry"]["location"]["lng"];
	return $coords;
}
function reverseGeoCode($lat,$lng)
{
	$address = array();
	$geoCodeURL = "http://maps.google.com/maps/api/geocode/json?address=$lat,$lng&sensor=false";
	$result = json_decode(file_get_contents($geoCodeURL), true);
	$address['status'] = $result["status"];
	echo $geoCodeURL."<br />";
	print_r($result);
	return $address;
}
function getOSMGeoCoords($address)
{
	$coords = array();
	$address = utf8_encode($address);
	$geoCodeURL = "http://nominatim.openstreetmap.org/search?format=json&limit=1&addressdetails=0&q=".
				  urlencode($address);
	$result = json_decode(file_get_contents($geoCodeURL), true);
	$coords['lat'] = $result[0]["lat"];
	$coords['lng'] = $result[0]["lon"];
	return $coords;
}
}