<?php
/**
 * @package	 com_contactenhanced
 * @author	 Douglas Machado {@link http://idealextensions.com}
 * @author	 Created on 28-Jul-09
 * @license		GNU/GPL, see license.txt
 */

defined( '_JEXEC' ) or die( 'Restricted access' );

/**
 *
 * helper class.
 *
 */
class ceUserHelper extends JObject {
	static function createUser($data) {
		$app		= JFactory::getApplication();
		$lang		= JFactory::getLanguage();
		$user		= JFactory::getUser();
		$canCreate	= $user->authorise('core.create', 'com_contactenhanced');
		$lang->load('com_users');
		$lang->load('com_users', JPATH_ADMINISTRATOR);
		jimport('joomla.user.helper');

		$email	= $data['email_to'];
		$name	= $data['name'];
		// Initialize some variables
		$authorize	= JFactory::getACL();
		$db			= JFactory::getDBO();
		$MailFrom 	= $app->getCfg('mailfrom');
		$FromName 	= $app->getCfg('fromname');
		$SiteName	= $app->getCfg('sitename');

		// Remove the domain from the email
		$username	= preg_replace( "/^([^@]+)(@.*)$/", "$1", $email);

		if(($userID = self::userExists('id',array('email'=>$email)))){ // Same email, assume the user already exists
			return $userID;
		}elseif(self::userExists('id',array('username'=>$username))){ // username already exists, find a new one
			$username = JApplication::stringURLSafe($name);
			if(self::userExists('id',array('username'=>$username))){ // username already exists, find a new one
				$username = $email;
				if(self::userExists('id',array('username'=>$username))){ // username already exists, find a new one
					$app->enqueueMessage(JText::sprintf('CE_REGISTRATION_USER_REGISTERED_OR_USERNAME_NOT_AVAILABLE',$email,$username),'notice');
					return false;
				}
			}
		}

		$password 		= ceHelper::generateToken(8);

		$info	= array();
		$info['email']		= $email;
		$info['email1']		= $email;
		$info['name']		= $name;
		$info['username']	= $username;
		$info['password']	= $password;
		$info['password1']	= $password;
		$info['password2']	= $password;

		jimport('joomla.application.component.model');
		JModelLegacy::addIncludePath(JPATH_SITE.'/components/com_contactenhanced/models');


		if($canCreate) {
			require_once JPATH_ROOT.'/administrator/components/com_users/models/user.php';
			$uModel = JModelLegacy::getInstance('User', 'UsersModel', array('ignore_request' => true));
			$info['groups']	= array(2);
			$return	= $uModel->save($info);
			$return = $uModel->getState('user.id');
		}else{
			require_once JPATH_ROOT.'/components/com_users/models/registration.php';
			$uModel = JModelLegacy::getInstance('Registration', 'UsersModel', array('ignore_request' => true));
			$return	= $uModel->register($info);
		}


		// Check for errors.
		if($return === false) {
			// Save the data in the session.
			$app->setUserState('com_users.registration.data', $info);
			// Redirect back to the edit screen.
			$app->enqueueMessage(JText::sprintf('COM_USERS_REGISTRATION_SAVE_FAILED', $uModel->getError()), 'warning');

			return false;
		}

		// Flush the data from the session.
		$app->setUserState('com_users.registration.data', null);

		// Redirect to the profile screen.
		if($return === 'adminactivate'){
			$app->enqueueMessage(JText::_('COM_USERS_REGISTRATION_COMPLETE_VERIFY'));
			return self::userExists('id',array('username'=>$username));
		} else if($return === 'useractivate') {
			$app->enqueueMessage(JText::_('COM_USERS_REGISTRATION_COMPLETE_ACTIVATE'));
			return self::userExists('id',array('username'=>$username));
		}else{
			$app->enqueueMessage(JText::_('COM_USERS_USER_SAVE_SUCCESS'));
			return $return;
		}
	}

	static function userExists($selectField = 'id',$search = array()) {
		$db		= JFactory::getDBO();
		$query	= $db->getQuery(true);
		$query->select($selectField);
		$query->from('#__users');
		foreach ($search as $field => $value){
			if($value){
				$query->where($field.' = '.$db->Quote($value));
			}
		}
		$db->setQuery( $query,0,1); // Limit 1;
		return $db->loadResult();

	}
}
