<?php
/**
 * @version		3.3
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modelitem');

/**
 * @package		com_contactenhanced
* @since 1.5
 */
class ContactenhancedModelMessage extends JModelItem
{
	/**
	 * Model context string.
	 *
	 * @var		string
	 */
	protected $_context = 'com_contactenhanced.message';

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @since	1.6
	 */
	protected function populateState()
	{
		$app = JFactory::getApplication('site');

		// Load state from the request.
		$pk = JRequest::getInt('id');
		$this->setState('message.id', $pk);

		// Load the parameters.
		$params = $app->getParams();
		$this->setState('params', $params);

	}

	/**
	 * Gets a list of contacts
	 * @param array
	 * @return mixed Object or null
	 */
	public function &getItem($pk = null)
	{
		// Initialise variables.
		$pk = (!empty($pk)) ? $pk : (int) $this->getState('message.id');

		if($this->_item === null) {
			$this->_item = array();
		}

		if (!isset($this->_item[$pk])) {
			try
			{
				$db = $this->getDbo();
				$query = $db->getQuery(true);

				$query->select($this->getState('list.select', 'msg.*') );
				$query->from('#__ce_messages AS msg');

				// Join over the Contact
				$query->select('con.name AS contact_name, con.id AS contact_id, con.alias AS contact_alias, con.image AS contact_image');
				$query->join('LEFT', '#__ce_details AS con ON con.id = msg.contact_id');

				// Join on category table.
				$query->select('c.title AS category_title, c.alias AS category_alias, c.access AS category_access');
				$query->join('LEFT', '#__categories AS c on c.id = msg.catid');

				$query->where('msg.id = ' . (int) $pk);
				$query->where('msg.id = ' . (int) $pk);

				// Filter by published state.
				$query->where('msg.published = ' . 1);

				$db->setQuery($query);

				$data = $db->loadObject();

				if($error = $db->getErrorMsg()) {
					throw new Exception($error);
				}

				if (empty($data)) {
					throw new InvalidArgumentException(JText::_('COM_CONTACTENHANCED_MESSAGES_NO_MESSAGE_FOUND'),404);
				}

				$this->_item[$pk] = $data;
			}
			catch (RuntimeException $e)
			{
				$this->setError($e->getMessage());
				$this->_item[$pk] = false;
			}

		}
  		return $this->_item[$pk];
	}

	function getAttachments($id=null){
		if (empty($id)) {
			$id		= JRequest::getVar('id');
		}
		$query	= $this->_db->getQuery(true);
		$query->select('*');
		$query->from('#__ce_message_fields');
		$query->where('message_id ='.$this->_db->Quote($id));
		$query->where('field_type = '.$this->_db->Quote('multiplefiles'));
		return $this->_getList($query);
	}

	function getReplies($id=null){
		if (empty($id)) {
			$id		= JRequest::getVar('id');
		}
		$query	= $this->_db->getQuery(true);
		$query->select('*');
		$query->from('#__ce_messages');
		$query->where('parent ='.$this->_db->Quote($id));
		$query->order('date');
		return $this->_getList($query);
	}
}

