<?php
/**
 * @version		3.3
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @license		GNU GPL2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

jimport('joomla.application.categories');

/**
 * Build the route for the com_contact component
 *
 * @param	array	An array of URL arguments
 * @return	array	The URL arguments to use to assemble the subsequent URL.
 */
function ContactenhancedBuildRoute(&$query){
	$segments = array();

	// get a menu item based on Itemid or currently active
	$app	= JFactory::getApplication();
	$menu	= $app->getMenu();
	$params	= JComponentHelper::getParams('com_contactenhanced');
	$advanced = $params->get('sef_advanced_link', 0);

	if (empty($query['Itemid'])) {
		$menuItem = $menu->getActive();
	}else{
		$menuItem = $menu->getItem($query['Itemid']);
	}

	$mView	= (empty($menuItem->query['view'])) ? null : $menuItem->query['view'];
	$mCatid	= (empty($menuItem->query['catid'])) ? null : $menuItem->query['catid'];
	$mId	= (empty($menuItem->query['id'])) ? null : $menuItem->query['id'];

	if (isset($query['view']))
	{
		$view = $query['view'];
		if (empty($query['Itemid'])) {
			$segments[] = $query['view'];
		}
		unset($query['view']);
	};
	if (isset($view) AND $view == 'edit') {
		$query['view'] = 'edit';
	}
	// are we dealing with a contact that is attached to a menu item?
	if (isset($view) && ($mView == $view) and (isset($query['id'])) and ($mId == intval($query['id']))) {
		unset($query['view']);
		unset($query['catid']);
		unset($query['id']);
		return $segments;
	}
	if (isset($view) AND ($view == 'message')) {
		$segments[] = JText::_('COM_CONTACTENHANCED_MESSAGE_SEF_URL');
		$segments[] = str_replace(':', '-',$query['id']);
		unset($query['id']);
	}elseif (isset($view) AND ($view == 'category' OR $view == 'contact' OR $view == 'edit')) {
		// The categories/contact model adds category_id variable
		if(!isset($query['id'])){
			$query['id']	= JRequest::getVar('category_id');
		}

		if($mId != intval($query['id']) || $mView != $view) {
			if(($view == 'contact' OR $view == 'edit') && isset($query['catid']))
			{
				$catid = $query['catid'];
			}elseif(isset($query['id'])) {
				$catid = $query['id'];
			}else{
				$catid = 'ROOT'; // under review: added because of error in edit page..
			}
			$menuCatid = $mId;
			$categories = JCategories::getInstance('Contactenhanced');
			$category = $categories->get($catid);
			if($category)
			{
				//TODO Throw error that the category either not exists or is unpublished
				$path = array_reverse($category->getPath());

				$array = array();
				foreach($path as $id)
				{
					if((int) $id == (int)$menuCatid)
					{
						break;
					}
					if($advanced)
					{
						list($tmp, $id) = explode(':', $id, 2);
					}
					$array[] = $id;
				}
				$segments = array_merge($segments, array_reverse($array));
			}
			if($view == 'contact' OR $view == 'edit')
			{
				if($advanced)
				{
					list($tmp, $id) = explode(':', $query['id'], 2);
				}else{
					$id = $query['id'];
				}
				$segments[] = $id;
			}
		}
		unset($query['id']);
		unset($query['catid']);
	}

	if (isset($query['layout']))
	{
		if (!empty($query['Itemid']) && isset($menuItem->query['layout']))
		{
			if($query['layout'] == $menuItem->query['layout']) {

				unset($query['layout']);
			}
		}
		else
		{
			if($query['layout'] == 'default') {
				unset($query['layout']);
			}
		}
	};

	return $segments;
}
/**
 * Parse the segments of a URL.
 *
 * @param	array	The segments of the URL to parse.
 *
 * @return	array	The URL attributes to be used by the application.
 */
function ContactenhancedParseRoute($segments)
{
	$vars = array();

	//Get the active menu item.
	$app	= JFactory::getApplication();
	$menu	= $app->getMenu();
	$item	= $menu->getActive();
	$params = JComponentHelper::getParams('com_contactenhanced');
	$advanced = $params->get('sef_advanced_link', 0);
	JFactory::getLanguage()->load('com_contactenhanced', JPATH_ROOT.'/components/com_contactenhanced');

	// Count route segments
	$count = count($segments);

	// Standard routing.
	/* if (!isset($item))
	{
		$vars['view']	= $segments[0];
		$vars['id']		= $segments[$count - 1];
		return $vars;
	}*/

	if($segments[0] == JText::_('COM_CONTACTENHANCED_MESSAGE_SEF_URL')){
		$vars['view']	= 'message';
		list($id, $tmp) = explode(':', $segments[$count - 1], 2);
		$vars['id']		= $id;
	}else{
		// From the categories view, we can only jump to a category.
		$id = (isset($item->query['id']) && $item->query['id'] > 1) ? $item->query['id'] : 'root';

		//$categories = JCategories::getInstance('contactenhanced')->get($id)->getChildren();
		$categories = JCategories::getInstance('Contactenhanced')->get($id);
		if(is_object($categories)){
			$categories = $categories->getChildren();
		}else{
			$categories = JCategories::getInstance('Contactenhanced')->get('root');
			if(is_object($categories)){
				$categories = $categories->getChildren();
			}else{
				$categories = array();
			}
		}
		$vars['catid'] = $id;
		$vars['id'] = $id;
		$found = 0;
		foreach($segments as $segment)
		{
			$segment = $advanced ? str_replace(':', '-',$segment) : $segment;
			foreach($categories as $category)
			{
				if($category->slug == $segment || $category->alias == $segment)
				{
					$vars['id'] = $category->id;
					$vars['catid'] = $category->id;
					$vars['view'] = 'category';
					$categories = $category->getChildren();
					$found = 1;
					break;
				}
			}
			if($found == 0)
			{
				if($advanced)
				{
					$db = JFactory::getDBO();
					$query	= $db->getQuery(true);
					$query->select('id');
					$query->from('#__ce_details');
					$query->where(' catid = '.$db->Quote($vars['catid']).' AND alias = '.$db->Quote($segment));
					$db->setQuery($query);
					$nid = $db->loadResult();
				}else{
					$nid = $segment;
				}
				$vars['id'] = $nid;
				$vars['view'] = 'contact';
			}
			$found = 0;
		}
	}
	return $vars;
}

