<?php
/**
 * @version		3.3.4
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

require_once (JPATH_COMPONENT.'/helpers/image.php');
?>
<?php if (empty($this->items)) : ?>
	<p> <?php echo JText::_('COM_CONTACTENHANCED_NO_ARTICLES'); ?>	 </p>
<?php else:

$images = array();
$columns = intval($this->params->get('thumbnail_width',4));
// Fix for old versions upgrading without saving the parameters again;
if ($columns > 12 OR $columns < 1) {
	$columns = 4;
}
$bs2class= 'span'.intval(12/$columns); // Bootstrap2 class
$bs3class= 'col-xs-12 col-sm-'.intval(12/($columns >1 ? $columns-1: $columns)) .' col-md-'.intval(12/$columns); // Bootstrap3 class for Phone (xs), tablet (sm) and medium displays and greater (md)

if($this->params->get('fixBlockHeight',0) AND !defined('CE_THUMBNAIL_FIX_HEIGHT')){
	define('CE_THUMBNAIL_FIX_HEIGHT',1);
	JFactory::getDocument()->addScriptDeclaration("
	jQuery(document).ready(function($){
		var maxheight=0;
		jQuery('.ce-thumbnail').each(function(){
			height=jQuery('.ce-thumbnail').height();
			if(height>maxheight){
				maxheight=height;
			}
			jQuery('.ce-thumbnail').data('orgHeight',height);}
		).css('min-height',maxheight+30)
	});
	");
}
?>
<div id="ce-thumbnails" class="container-fluid">
	<div class="row row-fluid">
		<?php foreach($this->items as $i => $item) : ?>
			<div  class="<?php echo $bs2class.' '.$bs3class.' ce-contact-id-'.$item->id; ?> contact-thumbnail-block">
				<?php
				if (!$item->image){
					$item->image	= 'components/com_contactenhanced/assets/images/no-contact-image.png';
				}
				$images[]	= JURI::root().$item->image;
				$item->link = JRoute::_(ContactenchancedHelperRoute::getContactRoute($item->slug, $item->catid));

				$imgAttr	= array(
									'class'		=> 'img-polaroid img-thumbnail',
									'title'		=> strip_tags($item->name)
								);
				$image = JHtml::_('image', $item->image, strip_tags($item->name),$imgAttr);

				$item->params->merge($this->params);
				$ceObj			= new stdClass();
				$ceObj->params	= &$item->params;
				$ceObj->contact	= &$item;
				$ceObj->item	= &$ceObj->contact;

				$details		= ceHelper::getContactDetails($ceObj, 'html');

				?>
				<div class="ce-thumbnail">
				<?php
					if($this->params->get('link_thumbnails',1)){
						echo JHtml::_('link', $item->link, $image);
					}else{
						echo $image;
					}

					echo $details;
				?>
				</div>
			</div>
		<?php endforeach; ?>
	</div>
</div>
<?php endif; ?>

<div class="clearfix"></div>

<?php if($this->params->get('show_pagination')) : ?>
<div class="pagination">
	<?php if($this->params->def('show_pagination_results', 1)) : ?>
	<p class="counter">
		<?php echo $this->pagination->getPagesCounter(); ?>
	</p>
	<?php endif; ?>
	<?php echo $this->pagination->getPagesLinks(); ?>
</div>
<?php endif; ?>