<?php
 /**
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @license		GNU GPL2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

$canDo		= CEHelper::getActions();
$jversion	= new JVersion();
$user		= JFactory::getUser();
$session 	= JFactory::getSession();
$cparams 	= JComponentHelper::getParams ('com_media');

JFactory::getDocument()->addStyleSheet(JUri::root(true).'/components/com_contactenhanced/assets/css/ce-messages.css');

?>
<div id="ce-message-<?php echo $this->item->id; ?>"
	class="ce-container recorded-message<?php echo $this->params->get('pageclass_sfx'); ?>">
<?php echo ceHelper::loadModulePosition('ce-before-title');  ?>
<?php if($this->params->get('page_heading')): // class="title" was added in order to try add compaibility with Gantry based templates?>
	<h1 class="title ">
		<?php echo $this->escape($this->params->get('page_heading')); ?>
	</h1>
<?php endif; ?>

	<?php if($this->params->def('show_description_message', 1) AND $this->params->get('description_message')) : ?>
		<div class="category-desc">
			<?php echo JHtml::_('content.prepare', $this->params->get('description_message')); ?>
		<div class="clr"></div>
		</div>
	<?php endif; ?>

	<?php if($this->item->subject && $this->params->get('show_subject',1)) : ?>
	<div class="page-header">
		<h2>
			<span class="ce-subject"><?php echo $this->item->subject; ?></span>
		</h2>
	</div>
	<?php endif; ?>

	<?php echo ceHelper::loadModulePosition('ce-after-title');  ?>

	<?php if($this->params->get('show_contact_category_message') == 'show_no_link') : ?>
		<h3>
			<span class="contact-category"><?php echo $this->item->category_title; ?></span>
		</h3>
	<?php elseif($this->params->get('show_contact_category_message','hide') == 'show_with_link') : ?>
		<?php $contactLink = ContactenchancedHelperRoute::getCategoryRoute($this->item->catid);?>
		<h3>
			<span class="contact-category"><a href="<?php echo $contactLink; ?>">
				<?php echo ($this->item->category_title); ?></a>
			</span>
		</h3>
	<?php endif; ?>

	<?php if($this->params->get('presentation_style') == 'sliders') : ?>
		<?php echo JHtml::_('bootstrap.startAccordion', 'slide-messages', array('active' => 'basic-details')); ?>
	<?php endif; ?>
	<?php if($this->params->get('presentation_style') == 'tabs') : ?>
		<?php echo JHtml::_('bootstrap.startTabSet', 'tab-messages', array('active' => 'basic-details')); ?>
	<?php endif; ?>

	<?php echo $this->loadTemplate('messages'); ?>
	<?php echo $this->loadTemplate('reply'); ?>

</div>
