<?php
/**
* @package      EasySocial
* @copyright    Copyright (C) 2010 - 2015 Stack Ideas Sdn Bhd. All rights reserved.
* @license      GNU/GPL, see LICENSE.php
* EasySocial is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined( '_JEXEC' ) or die( 'Unauthorized Access' );
?>
<div class="es-story-broadcast-form" data-story-broadcast-form>
    <div class="form-group">
        <input type="text" name="title" class="form-control input-sm" data-broadcast-title placeholder="<?php echo JText::_('APP_BROADCAST_STORY_FORM_SET_TITLE_PLACEHOLDER');?>" />
    </div>

    <div class="form-group">
        <input type="text" name="broadcast_link" class="form-control input-sm" data-broadcast-link placeholder="<?php echo JText::_('APP_BROADCAST_STORY_FORM_SET_LINK_PLACEHOLDER');?>" />
    </div>

    <div class="form-group">
        <textarea autocomplete="off" class="form-control input-sm" placeholder="<?php echo JText::_('APP_BROADCAST_STORY_FORM_SET_CONTENT_PLACEHOLDER'); ?>" data-broadcast-message></textarea>
    </div>

    <div class="form-group row">
        <div class="col-xs-6">
            <select name="broadcast_type" class="form-control input-sm" data-broadcast-type>
                <option value="popup"><?php echo JText::_('APP_BROADCAST_STORY_FORM_SET_TYPE_TOAST'); ?></option>
                <option value="notification"><?php echo JText::_('APP_BROADCAST_STORY_FORM_SET_TYPE_NOTIFICATION'); ?></option>
            </select>
        </div>
        <div class="col-xs-6">
            <select name="broadcast_profile" class="form-control input-sm" data-broadcast-profile>
                <option value="0"><?php echo JText::_('APP_BROADCAST_STORY_FORM_SET_PROFILES_ALL'); ?></option>
                <?php foreach ($profiles as $profile) { ?>
                <option value="<?php echo $profile->id;?>"><?php echo $profile->get('title');?></option>
                <?php } ?>
            </select>
        </div>
    </div>
</div>
