FD40.installer("EasySocial", "definitions", function($){
$.module(["easysocial/admin","easysocial/admin/sidebar/sidebar","easysocial/admin/access/discover","easysocial/progress/progress","easysocial/admin/alerts/discover","easysocial/admin/badges/discover","easysocial/admin/events/approveRecurring","easysocial/admin/events/store","easysocial/admin/events/users","easysocial/admin/grid/grid","easysocial/admin/grid/sort","easysocial/admin/grid/publishing","easysocial/admin/grid/ordering","easysocial/admin/groups/groups","easysocial/admin/groups/users","easysocial/admin/indexer/indexer","easysocial/admin/mailer/mailer","easysocial/admin/maintenance/database","easysocial/admin/maintenance/maintenance","easysocial/admin/migrators/migrator","easysocial/admin/points/discover","easysocial/admin/privacy/discover","easysocial/admin/profiles/avatar","easysocial/uploader/uploader","easysocial/uploader/queue","easysocial/admin/profiles/fields","easysocial/field","easysocial/admin/profiles/members","easysocial/admin/profiles/profile","easysocial/utilities/alias","easysocial/admin/profiles/profiles","easysocial/admin/regions/form","easysocial/admin/regions/init","easysocial/admin/reports/reporters","easysocial/admin/reports/reports","easysocial/admin/themes/compiler","easysocial/admin/users/form","easysocial/admin/users/privacy","easysocial/admin/users/users","easysocial/admin/widgets/news","easysocial/albums/album","easysocial/albums/browser","easysocial/albums/editor","easysocial/albums/editor/sortable","easysocial/albums/editor/uploader","easysocial/albums/uploader","easysocial/albums/uploader.item","easysocial/albums/item","easysocial/apps/event/discussions","easysocial/apps/event/guests","easysocial/apps/event/tasks","easysocial/apps/fields/event/permalink/content","easysocial/apps/fields/event/permalink/sample_content","easysocial/apps/fields/event/recurring/content","easysocial/apps/fields/event/startend/content","easysocial/apps/fields/event/startend/display","easysocial/apps/fields/group/permalink/content","easysocial/apps/fields/group/permalink/sample_content","easysocial/apps/fields/user/address/content","easysocial/apps/fields/user/address/display_content","easysocial/apps/fields/user/address/maps","easysocial/apps/fields/user/avatar/content","easysocial/apps/fields/user/avatar/sample_content","easysocial/apps/fields/user/checkbox/content","easysocial/apps/fields/user/checkbox/sample_content","easysocial/apps/fields/user/country/content","easysocial/apps/fields/user/country/sample_content","easysocial/apps/fields/user/cover/content","easysocial/apps/fields/user/currency/sample_content","easysocial/apps/fields/user/datetime/content","easysocial/apps/fields/user/datetime/display_content","easysocial/apps/fields/user/datetime/dropdown","easysocial/apps/fields/user/datetime/sample_content","easysocial/apps/fields/user/dropdown/content","easysocial/apps/fields/user/email/content","easysocial/apps/fields/user/file/content","easysocial/apps/fields/user/file/sample_content","easysocial/apps/fields/user/gender/content","easysocial/apps/fields/user/joomla_email/content","easysocial/apps/fields/user/joomla_email/registermini_content","easysocial/apps/fields/user/joomla_email/sample_content","easysocial/apps/fields/user/joomla_fullname/content","easysocial/apps/fields/user/joomla_fullname/sample_content","easysocial/apps/fields/user/joomla_password/content","easysocial/apps/fields/user/joomla_password/registermini_content","easysocial/apps/fields/user/joomla_password/sample_content","easysocial/apps/fields/user/joomla_timezone/content","easysocial/apps/fields/user/joomla_username/content","easysocial/apps/fields/user/joomla_username/registermini_content","easysocial/apps/fields/user/joomla_username/sample_content","easysocial/apps/fields/user/multidropdown/content","easysocial/apps/fields/user/multilist/content","easysocial/apps/fields/user/multitextbox/content","easysocial/apps/fields/user/permalink/content","easysocial/apps/fields/user/permalink/sample_content","easysocial/apps/fields/user/relationship/content","easysocial/site/friends/suggest","easysocial/apps/fields/user/separator/sample","easysocial/apps/fields/user/terms/content","easysocial/apps/fields/user/textarea/content","easysocial/apps/fields/user/textbox/content","easysocial/apps/fields/user/textbox/sample_content","easysocial/apps/fields/user/url/content","easysocial/apps/fields/user/url/sample_content","easysocial/apps/group/feeds","easysocial/apps/group/tasks","easysocial/avatar","easysocial/cover","easysocial/easysocial","easysocial/site/likes/likes","easysocial/site/reports/reports","easysocial/site/blocks/blocks","easysocial/site/repost/repost","easysocial/site/share/share","easysocial/site/layout/dialog","easysocial/site/layout/responsive","easysocial/site/layout/elements","easysocial/site/photos/photos","easysocial/site/photos/popup","easysocial/site/photos/dialog","easysocial/site/photos/avatar","easysocial/site/users/login","easysocial/site/dashboard/dashboard.guest.login","easysocial/validate","easysocial/site/profile/popbox","easysocial/site/conversations/composer","easysocial/site/privacy/privacy","easysocial/site/locations/popbox","easysocial/site/sidebar/sidebar","easysocial/site/friends/api","easysocial/site/popbox/popbox","easysocial/site/conversations/api","easysocial/site/groups/api","easysocial/site/followers/api","easysocial/site/stream/video","easysocial/oauth/facebook","easysocial/groups/suggest","easysocial/locations","easysocial/pagination","easysocial/photos/avatar","easysocial/photos/browser","easysocial/photos/editor","easysocial/photos/item","easysocial/photos/tags","easysocial/photos/tagger","easysocial/photos/navigation","easysocial/prism","easysocial/privacy","easysocial/sharing","easysocial/site/activities/activities","easysocial/site/activities/sidebar","easysocial/site/activities/sidebar.item","easysocial/site/activities/apps","easysocial/site/activities/item","easysocial/site/activities/list","easysocial/site/albums/all","easysocial/site/apps/apps","easysocial/site/badges/badge","easysocial/site/comments/control","easysocial/site/comments/frame","easysocial/site/comments/item","easysocial/site/conversations/conversations","easysocial/site/conversations/mailbox","easysocial/site/conversations/item","easysocial/site/conversations/filter","easysocial/site/conversations/read","easysocial/site/dashboard/apps","easysocial/site/dashboard/dashboard","easysocial/site/dashboard/feeds","easysocial/site/dashboard/sidebar","easysocial/site/stream/filter","easysocial/site/stream/sidebar","easysocial/site/dashboard/groups","easysocial/site/dashboard/events","easysocial/site/events/browser","easysocial/site/events/guestState","easysocial/site/events/create","easysocial/site/events/createRecurring","easysocial/site/events/edit","easysocial/site/events/item","easysocial/site/events/update","easysocial/site/explorer","easysocial/site/explorer/uploader","easysocial/site/explorer/popup","easysocial/site/followers/followers","easysocial/site/friends/friends","easysocial/site/friends/list","easysocial/site/friends/item","easysocial/site/groups/groups","easysocial/site/groups/item","easysocial/site/notifications/list","easysocial/site/points/history","easysocial/site/profile/about","easysocial/site/profile/edit","easysocial/site/profile/feeds","easysocial/site/profile/friends","easysocial/site/profile/header","easysocial/site/profile/subscriptions","easysocial/site/profile/miniheader","easysocial/site/profile/notifications","easysocial/site/profile/privacy","easysocial/site/profile/profile","easysocial/site/registrations/registrations","easysocial/site/search/advanced.criteria","easysocial/site/search/map","easysocial/site/search/advanced","easysocial/site/search/advanced.list","easysocial/site/search/item","easysocial/site/search/dating","easysocial/site/search/list","easysocial/site/search/search","easysocial/site/search/sidebar","easysocial/site/search/toolbar","easysocial/site/stream/item","easysocial/site/stream/stream","easysocial/site/subscriptions/follow","easysocial/site/system/broadcast","easysocial/site/toolbar/conversations","easysocial/site/toolbar/friends","easysocial/site/toolbar/login","easysocial/site/toolbar/notifications","easysocial/site/toolbar/story","easysocial/site/toolbar/system","easysocial/site/toolbar/profile","easysocial/site/users/popbox","easysocial/site/users/users","easysocial/story","easysocial/story/blog","easysocial/story/broadcast","easysocial/story/event","easysocial/story/files","easysocial/story/friends","easysocial/story/links","easysocial/story/locations","easysocial/story/mood","easysocial/story/photos","easysocial/story/tasks","easysocial/stream","easysocial/comment","easysocial/tab","easysocial/toggle","easysocial/uploader/item"]);
$.require.template.loader(["easysocial/site/loading/small","easysocial/site/uploader/queue.item","easysocial/admin/profiles/form.fields.editorItem","easysocial/admin/profiles/form.fields.stepItem","easysocial/admin/profiles/form.fields.editorPage","easysocial/admin/profiles/form.fields.config","easysocial/admin/profiles/dialog.move.field","easysocial/admin/profiles/dialog.delete.profileavatar","easysocial/site/albums/browser.list.item","easysocial/site/albums/upload.item","easysocial/fields/user/checkbox/item","easysocial/site/friends/suggest.item","easysocial/site/friends/suggest.hint.search","easysocial/site/friends/suggest.hint.empty","easysocial/site/hashtags/suggest.item","easysocial/site/hashtags/suggest.hint.search","easysocial/site/hashtags/suggest.hint.empty","easysocial/site/dialog/default","easysocial/site/photos/popup","easysocial/site/groups/suggest.item","easysocial/site/location/story.suggestion","easysocial/site/photos/tags.item","easysocial/site/photos/tags.menu.item","easysocial/admin/profiles/form.privacy.custom.item","easysocial/site/activities/loadbutton","easysocial/site/explorer/popup","easysocial/site/friends/default.empty","easysocial/site/friends/list.assign","easysocial/site/registration/dialog.error","easysocial/site/search/loadbutton","easysocial/site/stream/loadbutton","easysocial/site/notifications/system.empty","easysocial/site/users/button.following","easysocial/apps/user/links/story/attachment.item","easysocial/apps/user/files/story/attachment.item","easysocial/apps/user/files/story/progress","easysocial/apps/group/tasks/story/attachment.item","easysocial/site/likes/item","easysocial/site/uploader/preview"]);
$.require.language.loader(["COM_EASYSOCIAL_SCAN_COMPLETED","JLIB_HTML_PLEASE_MAKE_A_SELECTION_FROM_THE_LIST","COM_EASYSOCIAL_INDEXER_REINDEX_PROCESSING","COM_EASYSOCIAL_INDEXER_REINDEX_FINISHED","COM_EASYSOCIAL_INDEXER_REINDEX_RESTART","COM_EASYSOCIAL_PROFILES_FORM_FIELDS_ITEM_CONFIG_LOADING","COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_PAGE_DIALOG_TITLE","COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_PAGE_DIALOG_CONFIRMATION","COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_PAGE_DIALOG_CONFIRM","COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_PAGE_DIALOG_CANCEL","COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_PAGE_DIALOG_DELETING","COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_ITEM_DIALOG_TITLE","COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_ITEM_DIALOG_CONFIRMATION","COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_ITEM_DIALOG_CONFIRM","COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_ITEM_DIALOG_CANCEL","COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_ITEM_DIALOG_DELETING","COM_EASYSOCIAL_PROFILES_FORM_FIELDS_PARAMS_CORE_UNIQUE_KEY_SAVE_FIRST","COM_EASYSOCIAL_PROFILES_FORM_FIELDS_CONFIGURE_PAGE","COM_EASYSOCIAL_PROFILES_FORM_FIELDS_CONFIGURE_FIELD","COM_EASYSOCIAL_FIELDS_REQUIRE_MANDATORY_FIELDS","COM_EASYSOCIAL_FIELDS_UNSAVED_CHANGES","COM_EASYSOCIAL_FIELDS_INVALID_VALUES","COM_EASYSOCIAL_CANCEL_BUTTON","COM_EASYSOCIAL_ASSIGN_BUTTON","COM_EASYSOCIAL_PROFILES_ASSIGN_USER_DIALOG_TITLE","COM_EASYSOCIAL_PROFILES_FORM_CLEAR_AVATAR","COM_EASYSOCIAL_REGIONS_FORM_INCOMPLETE","COM_EASYSOCIAL_CLOSE_BUTTON","COM_EASYSOCIAL_REPORTS_VIEW_REPORTS_DIALOG_TITLE","COM_EASYSOCIAL_REPORTS_ACTIONS_DIALOG_TITLE","FIELDS_EVENT_PERMALINK_EXCEEDED_MAX_LENGTH","FIELDS_EVENT_PERMALINK_REQUIRED","FIELDS_EVENT_STARTEND_VALIDATION_DATETIME_START_REQUIRED","FIELDS_EVENT_STARTEND_VALIDATION_DATETIME_END_REQUIRED","FIELDS_USER_DATETIME_LOCAL_TIMEZONE","FIELDS_USER_DATETIME_TIMEZONE_CHECKING","PLG_FIELDS_GROUP_PERMALINK_EXCEEDED_MAX_LENGTH","PLG_FIELDS_GROUP_PERMALINK_REQUIRED","PLG_FIELDS_ADDRESS_PLEASE_ENTER_ADDRESS1","PLG_FIELDS_ADDRESS_PLEASE_ENTER_ADDRESS2","PLG_FIELDS_ADDRESS_PLEASE_ENTER_CITY","PLG_FIELDS_ADDRESS_PLEASE_ENTER_STATE","PLG_FIELDS_ADDRESS_PLEASE_ENTER_ZIP","PLG_FIELDS_ADDRESS_PLEASE_ENTER_COUNTRY","COM_EASYSOCIAL_LOCATION_PERMISSION_ERROR","COM_EASYSOCIAL_LOCATION_TIMEOUT_ERROR","COM_EASYSOCIAL_LOCATION_UNAVAILABLE_ERROR","COM_EASYSOCIAL_STREAM_AT","PLG_FIELDS_AVATAR_VALIDATION_EMPTY_PROFILE_PICTURE","PLG_FIELDS_CHECKBOX_CHECK_AT_LEAST_ONE_ITEM","PLG_FIELDS_COUNTRY_VALIDATION_REQUIRED","PLG_FIELDS_COUNTRY_VALIDATION_MINIMUM_ERROR","PLG_FIELDS_COUNTRY_VALIDATION_MAXIMUM_ERROR","PLG_FIELDS_COVER_VALIDATION_REQUIRED","PLG_FIELDS_DATETIME_VALIDATION_INVALID_DATETIME_FORMAT","PLG_FIELDS_DATETIME_VALIDATION_PLEASE_SELECT_DATETIME","PLG_FIELDS_DATETIME_DAY","PLG_FIELDS_DROPDOWN_VALIDATION_PLEASE_SELECT_A_VALUE","PLG_FIELDS_EMAIL_VALIDATION_REQUIRED","PLG_FIELDS_EMAIL_VALIDATION_INVALID_FORMAT","PLG_FIELDS_FILE_ERROR_UNKNOWN_ERROR_OCCURED","COM_EASYSOCIAL_WORKING","PLG_FIELDS_GENDER_VALIDATION_GENDER_REQUIRED","PLG_FIELDS_JOOMLA_EMAIL_VALIDATION_REQUIRED","PLG_FIELDS_JOOMLA_EMAIL_VALIDATION_RECONFIRM_REQUIRED","PLG_FIELDS_JOOMLA_EMAIL_VALIDATION_NOT_MATCHING","PLG_FIELDS_JOOMLA_EMAIL_CHECKING","PLG_FIELDS_JOOMLA_EMAIL_VALIDATION_INVALID_FORMAT","PLG_FIELDS_JOOMLA_FULLNAME_VALIDATION_EMPTY_NAME","PLG_FIELDS_JOOMLA_PASSWORD_EMPTY_PASSWORD","PLG_FIELDS_JOOMLA_PASSWORD_EMPTY_RECONFIRM_PASSWORD","PLG_FIELDS_JOOMLA_PASSWORD_NOT_MATCHING","PLG_FIELDS_JOOMLA_PASSWORD_MINIMUM_CHAR","PLG_FIELDS_JOOMLA_PASSWORD_MAXIMUM_CHAR","PLG_FIELDS_JOOMLA_PASSWORD_STRENGTH_VERY_WEAK","PLG_FIELDS_JOOMLA_PASSWORD_STRENGTH_WEAK","PLG_FIELDS_JOOMLA_PASSWORD_STRENGTH_NORMAL","PLG_FIELDS_JOOMLA_PASSWORD_STRENGTH_STRONG","PLG_FIELDS_JOOMLA_PASSWORD_STRENGTH_VERY_STRONG","PLG_FIELDS_JOOMLA_PASSWORD_EMPTY_ORIGINAL_PASSWORD","PLG_FIELDS_JOOMLA_PASSWORD_TOO_SHORT","PLG_FIELDS_JOOMLA_PASSWORD_TOO_LONG","PLG_FIELDS_JOOMLA_TIMEZONE_VALIDATION_SELECT_TIMEZONE","PLG_FIELDS_JOOMLA_USERNAME_CHECKING","PLG_FIELDS_JOOMLA_USERNAME_EMPTY_USERNAME","PLG_FIELDS_MULTIDROPDOWN_VALIDATION_REQUIRED_FIELD","PLG_FIELDS_MULTILIST_VALIDATION_PLEASE_SELECT_A_VALUE","PLG_FIELDS_MULTITEXTBOX_VALIDATION_REQUIRED_FIELD","PLG_FIELDS_PERMALINK_EXCEEDED_MAX_LENGTH","PLG_FIELDS_PERMALINK_REQUIRED","COM_EASYSOCIAL_FRIENDS_REQUEST_SENT","PLG_FIELDS_RELATIONSHIP_APPROVE_CONFIRM","PLG_FIELDS_RELATIONSHIP_ACTION_APPROVE","PLG_FIELDS_TERMS_VALIDATION_REQUIRED","PLG_FIELDS_TEXTAREA_VALIDATION_INPUT_REQUIRED","PLG_FIELDS_TEXTAREA_VALIDATION_INPUT_TOO_SHORT","PLG_FIELDS_TEXTAREA_VALIDATION_INPUT_TOO_LONG","PLG_FIELDS_TEXTBOX_VALIDATION_INPUT_REQUIRED","PLG_FIELDS_TEXTBOX_VALIDATION_INPUT_TOO_SHORT","PLG_FIELDS_TEXTBOX_VALIDATION_INPUT_TOO_LONG","PLG_FIELDS_TEXTBOX_VALIDATION_INPUT_INVALID_FORMAT","PLG_FIELDS_URL_VALIDATION_EMPTY_URL","COM_EASYSOCIAL_CONVERSATIONS_ERROR_EMPTY_RECIPIENTS","COM_EASYSOCIAL_CONVERSATIONS_ERROR_EMPTY_MESSAGE","COM_EASYSOCIAL_PRIVACY_TOOLTIPS_SHARED_WITH_PUBLIC","COM_EASYSOCIAL_PRIVACY_TOOLTIPS_SHARED_WITH_MEMBER","COM_EASYSOCIAL_PRIVACY_TOOLTIPS_SHARED_WITH_FRIENDS_OF_FRIEND","COM_EASYSOCIAL_PRIVACY_TOOLTIPS_SHARED_WITH_FRIEND","COM_EASYSOCIAL_PRIVACY_TOOLTIPS_SHARED_WITH_ONLY_ME","COM_EASYSOCIAL_PRIVACY_TOOLTIPS_SHARED_WITH_CUSTOM","COM_EASYSOCIAL_AT_LOCATION","COM_EASYSOCIAL_ACTIVITY_APPS_UNHIDE_SUCCESSFULLY","COM_EASYSOCIAL_ACTIVITY_USERS_UNHIDE_SUCCESSFULLY","COM_EASYSOCIAL_ACTIVITY_LOG_LOAD_PREVIOUS_STREAM_ITEMS","COM_EASYSOCIAL_COMMENTS_STATUS_SAVE_ERROR","COM_EASYSOCIAL_COMMENTS_STATUS_LOADING","COM_EASYSOCIAL_COMMENTS_STATUS_LOAD_ERROR","COM_EASYSOCIAL_COMMENTS_STATUS_DELETING","COM_EASYSOCIAL_COMMENTS_STATUS_DELETE_ERROR","COM_EASYSOCIAL_LIKES_LIKE","COM_EASYSOCIAL_LIKES_UNLIKE","COM_EASYSOCIAL_COMMENTS_LOADED_OF_TOTAL","COM_EASYSOCIAL_COMMENTS_STATUS_SAVING","COM_EASYSOCIAL_COMMENTS_STATUS_SAVED","COM_EASYSOCIAL_NO_BUTTON","COM_EASYSOCIAL_CONVERSATION_REPLY_POSTED_SUCCESSFULLY","COM_EASYSOCIAL_CONVERSATION_REPLY_FORM_EMPTY","COM_EASYSOCIAL_STREAM_FILTER_WARNING_TITLE_EMPTY","COM_EASYSOCIAL_STREAM_FILTER_WARNING_HASHTAG_EMPTY","COM_EASYSOCIAL_EVENTS_GUEST_PENDING","COM_EASYSOCIAL_EVENTS_DETECTING_LOCATION","COM_EASYSOCIAL_EXPLORER_ENTER_FOLDER_NAME","COM_EASYSOCIAL_EXPLORER_INVALID_FOLDER_NAME","COM_EASYSOCIAL_FRIENDS_REQUEST_SENT_PENDING_APPROVAL","COM_EASYSOCIAL_FRIENDS_REQUEST_DIALOG_TITLE","COM_EASYSOCIAL_FRIENDS_CANCEL_REQUEST_DIALOG_CANCELLED","COM_EASYSOCIAL_FRIENDS_DIALOG_CANCEL_REQUEST","COM_EASYSOCIAL_YES_CANCEL_MY_REQUEST_BUTTON","COM_EASYSOCIAL_REGISTRATION_ERROR_DIALOG_TITLE","COM_EASYSOCIAL_ADVANCED_SEARCH_ADDRESS_DISTANCE_NOTICE","COM_EASYSOCIAL_STREAM_LOAD_PREVIOUS_STREAM_ITEMS","COM_EASYSOCIAL_FRIENDS_REQUEST_SENT_NOTICE","COM_EASYSOCIAL_SEARCH_LOAD_MORE_ITEMS","COM_EASYSOCIAL_SUBSCRIPTION_INFO","COM_EASYSOCIAL_FRIENDS_REQUEST_REJECTED","COM_EASYSOCIAL_STREAM_META_JOINER","COM_EASYSOCIAL_STORY_SUBMIT_ERROR","COM_EASYSOCIAL_STORY_CONTENT_EMPTY","COM_EASYSOCIAL_STORY_NOT_ON_STREAM_FILTER","COM_EASYSOCIAL_STORY_EVENT_INSUFFICIENT_DATA","COM_EASYSOCIAL_STORY_EVENT_INVALID_START_END_DATETIME","COM_EASYSOCIAL_STREAM_STORY_WITH","COM_EASYSOCIAL_STREAM_STORY_WITH_JOINER","COM_EASYSOCIAL_STREAM_STORY_WITH_LAST_JOINER","COM_EASYSOCIAL_AND","COM_EASYSOCIAL_MOOD_FEELING_CUSTOM","COM_EASYSOCIAL_SUBSCRIPTION_DIALOG_UNSUBSCRIBE","COM_EASYSOCIAL_SUBSCRIPTION_DIALOG_SUBSCRIBE","COM_EASYSOCIAL_SUBSCRIPTION_BUTTON_OK","COM_EASYSOCIAL_SUBSCRIPTION_BUTTON_SUBMIT","COM_EASYSOCIAL_SUBSCRIPTION_BUTTON_CANCEL","COM_EASYSOCIAL_SUBSCRIPTION_BUTTON_UNSUBSCRIBE","COM_EASYSOCIAL_SUBSCRIPTION_ARE_YOU_SURE_UNSUBSCRIBE","COM_EASYSOCIAL_SUBSCRIPTION_BUTTON_SUBSCRIBE","COM_EASYSOCIAL_STREAM_DIALOG_FEED","COM_EASYSOCIAL_STREAM_BUTTON_CLOSE"]);
(function(){
var stylesheetNames = ["easysocial/imgareaselect/default"];
var state = ($.stylesheet({"content":""})) ? "resolve" : "reject";
$.each(stylesheetNames, function(i, stylesheet){ $.require.stylesheet.loader(stylesheet)[state](); });
})();
});
FD40.installer("EasySocial", "scripts", function($){
EasySocial.module("admin", function($){

	var module = this;

	EasySocial.require()
		.library(
			"uniform",
			"chosen",
			"flot"
		)
		.script( 
			"admin/sidebar/sidebar"
		)
		.done(function($){

			// Once uniform.js is implemented, we want to apply uniform to the elements.
			$(".uniform, .check :checkbox, .radio :radio, input:file[data-uniform], .usergroups :checkbox").uniform();

			// Apply chosen
			$( '[data-chosen]' ).chosen(
			{
				disable_search 	: true
			});

			$( '[data-chosen-search]' ).chosen(
			{
				disable_search 	: false
			});

			// Ajax checks for pending users.
			$('[data-sidebar]' ).implement( EasySocial.Controller.Sidebar.Sidebar );


			$( '[data-sidebar-menu-toggle]' ).on( 'click' , function()
			{
				var parent 		= $( this ).parent( 'li' ),
					child 		= parent.find( 'ul' ),
					isActive 	= $( this ).parent( 'li' ).hasClass( 'active' );

				if( isActive )
				{
					parent.removeClass( 'active' );
					child.removeClass( 'in' );
				}
				else
				{
					parent.addClass( 'active' );
					child.addClass( 'in' );
				}
			});

			module.resolve();
		});
});

EasySocial.module( 'admin/sidebar/sidebar' , function($) {

	var module = this;

	EasySocial.require()
	.done(function($){

		EasySocial.Controller(
				'Sidebar.Sidebar', {
					defaultOptions: {
						intervalPendingUsers 	: 5000,
						"{versionNotice}"		: "[data-easysocial-version]",
						"{usersBadge}"			: ".menu-user > a .badge",
						"{pendingUsersBadge}"	: ".menu-user .menu-ies-vcard > .badge"
					}
				}, function(self) {

					return {

						init: function() {

							// Perform version checking
							self.versionChecks();

							// Check for pending users.
							self.checkPendingUsers();
						},

						versionChecks: function() {
							EasySocial.ajax('admin/controllers/easysocial/versionChecks')
							.done(function(contents, outdated, local, latest) {
								
								if (outdated) {

									// Show sidebar menu to be outdated
									$( '[data-es-version-header]' )
										.removeClass( 'latest' )
										.addClass( 'outdated' );

									$( '[data-es-version-header]' )
										.find( '[data-es-outdated]' )
										.data( 'local-version' , local )
										.data( 'online-version' , latest );
								}

								// Update the version notice
								self.versionNotice().html(contents).show();
							});
						},

						monitorPendingUsers: function() {
							self.options.state	= setTimeout(self.checkPendingUsers, self.options.intervalPendingUsers);
						},

						checkPendingUsers: function() {

							// Stop monitoring so that there wont be double calls at once.
							self.stopMonitorPendingUsers();

							// Needs to run in a loop since we need to keep checking for new notification items.
							setTimeout( function(){

								EasySocial.ajax('admin/controllers/users/getTotalPending')
								.done(function(total) {

									if (total > 0) {
										self.usersBadge().html(total);
										self.pendingUsersBadge().html(total);
									} else {
										self.usersBadge().html('');
									}

									// Continue monitoring.
									self.monitorPendingUsers();
								});

							}, self.options.intervalPendingUsers );

						},

						stopMonitorPendingUsers: function() {
							clearTimeout(self.options.state);
						},
					}
				}
		);

		module.resolve();
	});

});

EasySocial.module('admin/access/discover', function($) {
	var module = this;

	EasySocial
		.require()
		.script('progress/progress')
		.language('COM_EASYSOCIAL_SCAN_COMPLETED')
		.done(function($) {
			EasySocial.Controller('Access.Discover', {
				defaultOptions: {
					files: [],

					progressController: null,

					'{startButton}': '[data-access-discovery-start]',

					'{progressBar}': '.discoverProgress',

					'{results}': '[data-access-discovery-result]'
				}
			}, function(self) {
				return {
					init: function() {
						self.options.progressController = self.progressBar().addController(EasySocial.Controller.Progress);
					},

					reset: function() {
						self.results().html('');

						self.options.progressController.reset();
					},

					addLog: function(msg) {
						$('<tr></tr>').append($('<td></td>').html(msg)).appendTo(self.results());
					},

					'{startButton} click' : function(element) {
						self.reset();

						// Disable start button.
						self.startButton().attr('disabled', 'disabled');

						// Discover the list of files.
						EasySocial.ajax('admin/controllers/access/scanFiles').done(function(files, message) {
							self.reset();

							// Set the files to the properties.
							self.options.files 	= files;

							if (self.options.files.length > 0) {
								// Begin progress.
								self.options.progressController.begin(self.options.files.length);

								// Add logging
								self.addLog(message);

								// Begin to loop through each files.
								self.startIterating();
							} else {
								// Update once.
								self.options.progressController.begin(1);
								self.options.progressController.completed('Discover Completed');

								// Append message to the result list.
								self.addLog($.language('COM_EASYSOCIAL_SCAN_COMPLETED'));

								// Make the scan button work again.
								self.startButton().removeAttr('disabled');
							}
						});
					},

					startIterating: function() {
						// Get the file from the shelf
						var file = self.options.files.shift();

						EasySocial.ajax('admin/controllers/access/installFile',
						{
							"file": file
						})
						.always(function(message){

							// As long as the files list are not empty yet, we still need to process it.
							if (self.options.files.length > 0) {
								// Update once.
								self.options.progressController.touch('...');

								// Append message to the result list.
								self.addLog(message);

								// Run this again.
								self.startIterating();
							} else {
								// Update once.
								self.options.progressController.touch('...');

								// Append message to the result list.
								self.addLog(message);

								// Append message to the result list.
								self.addLog($.language('COM_EASYSOCIAL_SCAN_COMPLETED'));

								// Make the scan button work again.
								self.startButton().removeAttr('disabled');
							}
						});
					}
				}
			});

			module.resolve();
		});
});

EasySocial.module( 'progress/progress' , function($) {

	var module = this;

	EasySocial.Controller(
		'Progress',
		{
			// A list of selectors we define
			// and expect template makers to follow.
			defaultOptions:
			{
				// Controller Properties.
				current 		: 0,
				eachWidth 		: null,
				total	 		: null,

				progressClass	: "progress progress-info progress-striped",

				// Controller Elements
				"{progressBar}"		: ".bar",
				"{progressResult}"	: ".progress-result",

				// View items.
				view			:
				{
				}
			}
		},
		function(self){

			return {

				init: function()
				{
				},

				reset: function()
				{
					self.options.current 	= 0;
					self.eachWidth 			= null;
					self.total 				= null;

					self.progressBar().css( 'width' , '0%' ).html( '' );
				},

				begin: function( total )
				{
					// Set the total number of items
					self.options.total 	= total;

					// Set the width of each item.
					self.options.eachWidth	= 100 / total;


					// Only show progress bar when the there's more than 1 item.
					if( total > 0 )
					{
						self.element
							.addClass( self.options.progressClass )
							.show();
					}
				},

				touch : function( message )
				{
					self.options.current 	+= self.options.eachWidth;

					//ensure the progress bar do not exceed 100%
					if( self.options.current > 100 )
					{
						self.options.current = 100;
					}

					self.progressBar().css( 'width' , self.options.current + '%' );
					self.progressResult().html( Math.round( self.options.current ) + '%' );
				},

				completed: function( message )
				{
					self.options.current 	= 100;

					self.progressBar().css( 'width' , self.options.current + '%' );
					self.progressResult().html( Math.round( self.options.current ) + '%' );
				}
			}

		}
	);

	module.resolve();

});

EasySocial.module( 'admin/alerts/discover' , function($) {

	var module = this;

	EasySocial.require()
	.script( 'progress/progress' )
	.language( 'COM_EASYSOCIAL_SCAN_COMPLETED' )
	.done(function($){

		EasySocial.Controller(
			'Alerts.Discover',
			{
				// A list of selectors we define
				// and expect template makers to follow.
				defaultOptions:
				{
					// Controller Properties.
					files 			: [],

					// Progress bar controller
					progressController : null,

					// Start button
					"{startButton}"	: "[data-alerts-discovery-start]",

					// Progress Bar
					"{progressBar}" : "[data-alerts-discovery-progress]",

					// Logging results
					"{results}"		: "[data-alerts-discovery-result]"
				}
			},
			function(self){

				return {

					init: function()
					{
						// Initialize progress bar.
						self.initProgressBar();
					},

					// Resets the scan.
					reset: function()
					{
						// Reset the logs
						self.results().html('');

						// Reset progress bar.
						self.options.progressController.reset();
					},

					initProgressBar: function()
					{
						// Implement progressbar
						self.progressBar().implement( EasySocial.Controller.Progress );

						// Set this to the options so that we can easily access the controller.
						self.options.progressController	= self.progressBar().controller();
					},

					addLog: function( message )
					{
						$( '<tr>' ).append( $( '<td>' ).html( message ) ).appendTo( self.results() );
					},

					startIterating: function()
					{
						// Get the file from the shelf
						var file 	= self.options.files.shift();

						EasySocial.ajax( 'admin/controllers/alerts/scan' ,
						{
							"file"	: file
						})
						.always(function( data , message , completeMessage ){

							// As long as the files list are not empty yet, we still need to process it.
							if( self.options.files.length > 0 )
							{
								// Update once.
								self.options.progressController.touch( '...' );

								// Append message to the result list.
								self.addLog( message );

								// Run this again.
								self.startIterating();
							}
							else
							{
								// Update once.
								self.options.progressController.touch( '...' );

								// Append message to the result list.
								self.addLog( $.language( 'COM_EASYSOCIAL_SCAN_COMPLETED' ) );

								// Make the scan button work again.
								self.startButton().removeAttr( 'disabled' );
							}
						});
					},

					"{startButton} click" : function( element )
					{
						self.reset();

						// Disable start button.
						self.startButton().attr( 'disabled' , 'disabled' );

						// Discover the list of files.
						EasySocial.ajax( 'admin/controllers/alerts/discoverFiles' , {})
						.done(function( files , message )
						{
							self.reset();

							// Set the files to the properties.
							self.options.files 	= files;

							if( self.options.files.length > 0 )
							{
								// Begin progress.
								self.options.progressController.begin( self.options.files.length );

								// Add logging
								self.addLog( message );

								// Begin to loop through each files.
								self.startIterating();
							}
						});
					}
				}

			}
		);

		module.resolve();
	});

});

EasySocial.module( 'admin/badges/discover' , function($) {

	var module = this;

	EasySocial.require()
	.script( 'progress/progress' )
	.language( 'COM_EASYSOCIAL_SCAN_COMPLETED' )
	.done(function($){

		EasySocial.Controller(
			'Badges.Discover',
			{
				// A list of selectors we define
				// and expect template makers to follow.
				defaultOptions:
				{
					// Controller Properties.
					files 			: [],

					// Progress bar controller
					progressController : null,

					// Start button
					"{startButton}"	: "[data-badgesDiscover-start]",

					// Progress Bar
					"{progressBar}" : "[data-badgesDiscover-progress]",

					// Logging results
					"{results}"		: "[data-badgesDiscover-result]",

					// View logs button.
					"{viewLog}"		: "[data-badgesDiscover-viewLog]"
				}
			},
			function(self){

				return {

					init: function()
					{
						// Initialize progress bar.
						self.initProgressBar();

						// Initialize the logging area.
						self.initLogging();
					},

					// Resets the scan.
					reset: function()
					{
						// Reset the logs
						self.results().html('');

						// Hide the viewlog button
						self.initLogging();

						// Reset progress bar.
						self.options.progressController.reset();
					},

					initLogging: function()
					{
						// Ensure view log button is always hidden.
						self.viewLog().hide();
					},

					initProgressBar: function()
					{
						// Implement progressbar
						self.progressBar().implement( EasySocial.Controller.Progress );

						// Set this to the options so that we can easily access the controller.
						self.options.progressController	= self.progressBar().controller();
					},

					addLog: function( message )
					{
						$( '<tr>' ).append( $( '<td>' ).html( message ) ).appendTo( self.results() );
					},

					startIterating: function()
					{
						// Get the file from the shelf
						var file 	= self.options.files.shift();

						EasySocial.ajax( 'admin/controllers/badges/scan' ,
						{
							"file"	: file
						})
						.always(function( data , message )
						{

							// As long as the files list are not empty yet, we still need to process it.
							if( self.options.files.length > 0 )
							{
								// Update once.
								self.options.progressController.touch( '...' );

								// Append message to the result list.
								self.addLog( message );

								// Run this again.
								self.startIterating();
							}
							else
							{
								// Update once.
								self.options.progressController.touch( '...' );

								// Append message to the result list.
								self.addLog( message );

								// Append completed message to the result list since we know this is the last item.
								self.addLog( $.language( 'COM_EASYSOCIAL_SCAN_COMPLETED' ) );

								// Show view log button.
								self.viewLog().show();

								// Make the scan button work again.
								self.startButton().removeAttr( 'disabled' );
							}
						});
					},

					"{startButton} click" : function( element )
					{
						self.reset();

						// Disable start button.
						self.startButton().attr( 'disabled' , 'disabled' );

						// Discover the list of files.
						EasySocial.ajax( 'admin/controllers/badges/discoverFiles' , {})
						.done(function( files , message )
						{
							// Set the files to the properties.
							self.options.files 	= files;

							if( self.options.files.length > 0 )
							{
								// Begin progress.
								self.options.progressController.begin( self.options.files.length );

								// Add logging
								self.addLog( message );

								// Begin to loop through each files.
								self.startIterating();
							}
							else
							{
								// Update once.
								self.options.progressController.begin( 1 );
								self.options.progressController.completed( 'Discover Completed' );

								// Append message to the result list.
								self.addLog( $.language( 'COM_EASYSOCIAL_SCAN_COMPLETED' ) );

								// Make the scan button work again.
								self.startButton().removeAttr( 'disabled' );
							}

						});
					},

					"{viewLog} click" : function()
					{
						self.results().toggle();
					}
				}

			}
		);

		module.resolve();
	});

});

EasySocial.module('admin/events/approveRecurring', function($) {
    var module = this;

    EasySocial.Controller('Events.ApproveRecurring', {
        defaultOptions: {
            postdatas: {},
            schedules: {},
            eventids: [],

            '{progress}': '[data-progress-bar]',

            '{form}': '[data-form]'
        }
    }, function(self) {
        return {
            init: function() {
                // Calculate the total things to do
                var length = 0;

                $.each(self.options.schedules, function(i, s) {
                    length += s.length;
                });

                self.total = length;

                self.startCreate();
            },

            total: 0,
            doneCounter: 0,
            eventCounter: 0,
            createCounter: 0,

            updateProgressBar: function() {
                var percentage = Math.ceil((self.doneCounter / self.total) * 100);

                self.progress().css({
                    width: percentage + '%'
                });
            },

            startCreate: function() {
                if (self.options.eventids[self.eventCounter] === undefined) {
                    return self.completed();
                }

                self.create()
                    .done(function() {
                        self.doneCounter++;

                        self.createCounter++;

                        if (self.options.schedules[self.options.eventids[self.eventCounter]][self.createCounter] === undefined) {
                            self.eventCounter++;
                            self.createCounter = 0;
                        }

                        self.updateProgressBar();

                        self.startCreate();
                    })
                    .fail(function(msg, errors) {
                        console.log(msg, errors);
                    });
            },

            create: function() {
                var eventId = self.options.eventids[self.eventCounter],
                    datetime = self.options.schedules[eventId][self.createCounter],
                    postdata = self.options.postdatas[eventId];

                return EasySocial.ajax('admin/controllers/events/createRecurring', {
                    eventId: eventId,
                    datetime: datetime,
                    postdata: postdata
                });
            },

            completed: function() {
                self.progress().parent().removeClass('progress-info').addClass('progress-success');
                self.form().submit();
            }
        }
    });

    module.resolve();
});

EasySocial.module('admin/events/store', function($) {
    var module = this;

    EasySocial.Controller('Events.Update', {
        defaultOptions: {
            postdata: {},
            updateids: [],
            schedule: [],
            eventId: null,

            '{progress}': '[data-progress-bar]',

            '{form}': '[data-form]'
        }
    }, function(self) {
        return {
            init: function() {
                self.startUpdate();
            },

            updateCounter: 0,
            createCounter: 0,

            updateProgressBar: function() {
                var percentage = Math.ceil(((self.updateCounter + self.createCounter) / (self.options.updateids.length + self.options.schedule.length)) * 100);

                self.progress().css({
                    width: percentage + '%'
                });
            },

            startUpdate: function() {
                if (self.options.updateids[self.updateCounter] === undefined) {
                    return self.startCreate();
                }

                self.update(self.options.updateids[self.updateCounter])
                    .done(function() {
                        self.updateCounter++;

                        self.updateProgressBar();

                        self.startUpdate();
                    })
                    .fail(function(msg, errors) {
                        console.log(msg, errors);
                    });
            },

            update: function(id) {
                var post = $.extend({}, self.options.postdata, {
                    id: id,
                    applyRecurring: 1
                });

                return EasySocial.ajax('admin/controllers/events/store', post);
            },

            startCreate: function() {
                if (self.options.schedule[self.createCounter] === undefined) {
                    return self.completed();
                }

                self.create(self.options.schedule[self.createCounter])
                    .done(function() {
                        self.createCounter++;

                        self.updateProgressBar();

                        self.startCreate();
                    })
                    .fail(function(msg, errors) {
                        console.log(msg, errors);
                    });
            },

            create: function(datetime) {
                return EasySocial.ajax('admin/controllers/events/createRecurring', {
                    eventId: self.options.eventId,
                    datetime: datetime,
                    postdata: self.options.postdata
                });
            },

            completed: function() {
                self.progress().parent().removeClass('progress-info').addClass('progress-success');
                self.form().submit();
            }
        }
    });

    module.resolve();
});

EasySocial.module('admin/events/users', function($) {
    var module = this;

    EasySocial
        .require()
        .language('JLIB_HTML_PLEASE_MAKE_A_SELECTION_FROM_THE_LIST')
        .done(function($) {
            EasySocial.Controller('Events.Users', {
                defaultOptions: {
                    eventid: null,

                    '{inviteGuest}': '[data-event-invite-guest]',
                    '{removeGuest}': '[data-event-remove-guest]',
                    '{approveGuest}': '[data-event-approve-guest]',
                    '{promoteGuest}': '[data-event-promote-guest]',
                    '{demoteGuest}': '[data-event-demote-guest]'
                }
            }, function(self) {
                return {
                    init: function() {
                    },

                    '{inviteGuest} click': function(el, ev) {
                        var guests = {};

                        window.inviteGuests = function(guest) {
                            if (guest.state) {
                                guests[guest.id] = guest
                            } else {
                                delete guests[guest.id];
                            }
                        };

                        var confirmInviteGuests = function() {
                            EasySocial.dialog({
                                content: EasySocial.ajax('admin/views/events/confirmInviteGuests', {
                                    guests: guests,
                                    eventid: self.options.eventid
                                }),
                                bindings: {
                                    '{submitButton} click': function() {
                                        this.inviteGuestsForm().submit();
                                    }
                                }
                            });
                        };

                        EasySocial.dialog({
                            content: EasySocial.ajax('admin/views/events/inviteGuests'),
                            bindings: {
                                '{submitButton} click': function() {
                                    confirmInviteGuests();
                                }
                            }
                        });
                    },

                    '{removeGuest} click': function(el, ev) {
                        if(document.adminForm.boxchecked.value == 0) {
                            alert($.language('JLIB_HTML_PLEASE_MAKE_A_SELECTION_FROM_THE_LIST'));
                        } else {
                            $.Joomla('submitform', ['removeGuests']);
                        }
                    },

                    '{approveGuest} click': function(el, ev) {
                        if(document.adminForm.boxchecked.value == 0) {
                            alert($.language('JLIB_HTML_PLEASE_MAKE_A_SELECTION_FROM_THE_LIST'));
                        } else {
                            $.Joomla('submitform', ['approveGuests']);
                        }
                    },

                    '{promoteGuest} click': function(el, ev) {
                        if(document.adminForm.boxchecked.value == 0) {
                            alert($.language('JLIB_HTML_PLEASE_MAKE_A_SELECTION_FROM_THE_LIST'));
                        } else {
                            $.Joomla('submitform', ['promoteGuests']);
                        }
                    },

                    '{demoteGuest} click': function(el, ev) {
                        if(document.adminForm.boxchecked.value == 0) {
                            alert($.language('JLIB_HTML_PLEASE_MAKE_A_SELECTION_FROM_THE_LIST'));
                        } else {
                            $.Joomla('submitform', ['demoteGuests']);
                        }
                    }
                }
            });

            module.resolve();
        });
});

EasySocial.module( 'admin/grid/grid' , function($) {

	var module = this;

	EasySocial.require()
	.script( 'admin/grid/sort' , 'admin/grid/publishing')
	.done(function($)
	{
		EasySocial.Controller(
			'Grid',
			{
				defaultOptions : 
				{
					"{sortColumns}"		: "[data-table-grid-sort]",
					"{ordering}"		: "[data-table-grid-ordering]",
					"{direction}"		: "[data-table-grid-direction]",

					"{task}"			: "[data-table-grid-task]",
					
					"{searchInput}"		: "[data-table-grid-search-input]",
					"{search}"			: "[data-table-grid-search]",
					"{resetSearch}"		: "[data-table-grid-search-reset]",

					"{checkAll}"		: "[data-table-grid-checkall]",
					"{checkboxes}"		: "[data-table-grid-id]",

					"{publishItems}"	: "[data-table-grid-publishing]",

					"{itemRow}"			: "tr",

					"{boxChecked}"		: "[data-table-grid-box-checked]",
					"{filters}"			: "[data-table-grid-filter]"
				}
			},
			function( self )
			{
				return {

					init : function()
					{
						// Implement sortable items.
						self.implementSortable();

						// Implement publish / unpublish
						self.implementPublishing();
					},

					"{filters} change" : function()
					{
						// Always reset the task before submitting.
						self.setTask( '' );

						self.submitForm();
					},

					"{search} click" : function()
					{
						self.submitForm();
					},

					"{resetSearch} click" : function()
					{
						self.searchInput().val( '' );
						self.submitForm();
					},

					submitForm: function()
					{
						self.element.submit();
					},

					setTask: function( task )
					{
						self.task().val( task );
					},

					setOrdering: function( ordering )
					{
						self.ordering().val( ordering );
					},

					setDirection: function( direction )
					{
						self.direction().val( direction );
					},

					setTotalChecked: function( total )
					{
						self.boxChecked().val( total );
					},

					toggleSelectRow: function( row )
					{
						var checkbox 	= row.find( 'input[name=cid\\[\\]]' );

						if( $( checkbox ).prop( 'checked' ) == true )
						{
							$( checkbox ).prop( 'checked' , false );	
						}
						else
						{
							$( checkbox ).prop( 'checked' , true );
						}
						
					},
					selectRow: function( row )
					{
						var checkbox 	= row.find( 'input[name=cid\\[\\]]' );

						$( checkbox ).prop( 'checked' , true );
					},

					implementSortable: function()
					{
						self.sortColumns().implement( EasySocial.Controller.Grid.Sort ,
						{
							"{parent}" 	: self
						});
					},

					implementPublishing: function()
					{
						self.publishItems().implement( EasySocial.Controller.Grid.Publishing,
						{
							"{parent}"	: self
						});
					},

					"{checkAll} change": function( element , event )
					{
						// Find all checkboxes in the grid.
						self.checkboxes().prop( 'checked' , $( element ).is( ':checked' ) );

						// Update the total number of checkboxes checked.
						var total 	= $( element ).is( ':checked' ) ? self.checkboxes().length : 0;


						self.setTotalChecked( total );
					}
				}
			}
		);
			
		module.resolve();
	});


});
EasySocial.module( 'admin/grid/sort' , function($) {

	var module = this;

	EasySocial.Controller(
		'Grid.Sort',
		{
			defaultOptions : 
			{
				items 	: "[data-grid-sort-item]"
			}
		},
		function( self )
		{
			return {

				init : function()
				{
				},

				"{self} click": function()
				{
					var direction 	= self.element.data( 'direction' ),
						column 		= self.element.data( 'sort' );

					// Set the ordering
					self.parent.setOrdering( column );

					// Set the direction
					self.parent.setDirection( direction );

					// Remove any task associated to the form.
					self.parent.setTask( '' );
					
					// Submit the form.
					self.parent.submitForm();
				}
			}
		}
	);
		
	module.resolve();

});
EasySocial.module( 'admin/grid/publishing' , function($) {

	var module = this;

	EasySocial.Controller(
		'Grid.Publishing',
		{
			defaultOptions : 
			{
			}
		},
		function( self )
		{
			return {

				init : function()
				{
				},

				"{self} click": function( el )
				{
					var row 	= self.element.parents( 'tr' ),
						task 	= self.element.data( 'task' );

					self.parent.selectRow( row );

					self.parent.setTask( task );

					self.parent.submitForm();
				}
			}
		}
	);
		
	module.resolve();

});
EasySocial.module( 'admin/grid/ordering' , function($) {

	var module = this;

	EasySocial.Controller('Grid.Ordering', {
		
		defaultOptions: {
			"{moveUp}": "[data-grid-order-up]",
			"{moveDown}": "[data-grid-order-down]",
			row: null
		}
	}, function(self) {
		return {

			init : function() {
				// Get the parent row
				self.options.row = self.element.parents( 'tr' );
			},

			selectRow : function() {
				var checkbox = self.options.row.find('input[name=cid\\[\\]]' );

				// Ensure that the checkbox is checked
				$(checkbox).prop('checked', true);
			},

			"{moveUp} click" : function() {
				self.selectRow();

				$.Joomla('submitform', ['moveUp']);
			},

			"{moveDown} click" : function() {
				self.selectRow();

				$.Joomla('submitform', ['moveDown']);
			}
		}
	});
		
	module.resolve();

});
EasySocial.module( 'admin/groups/groups' , function($) {

	var module = this;

	EasySocial
	.require()
	.library( 'expanding' )
	.done( function($)
	{
		EasySocial.Controller(
			'Groups.Pending.Item',
			{
				defaultOptions:
				{
					"{approve}" : "[data-pending-approve]",
					"{reject}"	: "[data-pending-reject]"
				}
			},
			function(self) {
				return {
					init: function()
					{
						self.options.id 	= self.element.data('id');
					},

					"{approve} click" : function()
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'admin/views/groups/approveGroup' , { "ids" : self.options.id } )
						});
					},

					"{reject} click" : function()
					{
						EasySocial.dialog(
						{
							content		: EasySocial.ajax( 'admin/views/groups/rejectGroup' , { "ids" : self.options.id } )
						});
					}
				}
			});

		module.resolve();
	});

});
EasySocial.module('admin/groups/users', function($) {
    var module = this;

    EasySocial
        .require()
        .language('JLIB_HTML_PLEASE_MAKE_A_SELECTION_FROM_THE_LIST')
        .done(function($) {
            EasySocial.Controller('Groups.Users', {
                defaultOptions: {
                    groupid: null,

                    '{addMember}': '[data-group-add-member]',
                    '{removeMember}': '[data-group-remove-member]',
                    '{approveMember}': '[data-group-approve-member]',
                    '{promoteMember}': '[data-group-promote-member]',
                    '{demoteMember}': '[data-group-demote-member]'
                }
            }, function(self) {
                return {
                    init: function() {

                    },

                    '{addMember} click': function(el, ev) {
                        var members = {};

                        window.addMembers = function(obj) {
                            if (obj.state) {
                                members[obj.id] = obj;
                            } else {
                                delete members[obj.id];
                            }
                        };

                        var confirmAddMembers = function() {
                            EasySocial.dialog({
                                content: EasySocial.ajax('admin/views/groups/confirmAddMembers', {
                                    members: members,
                                    groupid: self.options.groupid
                                }),
                                bindings: {
                                    '{submitButton} click': function() {
                                        this.addMembersForm().submit();
                                    }
                                }
                            });
                        };

                        EasySocial.dialog({
                            content: EasySocial.ajax('admin/views/groups/addMembers'),
                            bindings: {
                                '{submitButton} click': function() {
                                    confirmAddMembers();
                                }
                            }
                        });
                    },

                    '{removeMember} click': function(el, ev) {
                        if(document.adminForm.boxchecked.value == 0) {
                            alert($.language('JLIB_HTML_PLEASE_MAKE_A_SELECTION_FROM_THE_LIST'));
                        } else {
                            $.Joomla('submitform', ['removeMembers']);
                        }
                    },

                    '{approveMember} click': function(el, ev) {
                        if(document.adminForm.boxchecked.value == 0) {
                            alert($.language('JLIB_HTML_PLEASE_MAKE_A_SELECTION_FROM_THE_LIST'));
                        } else {
                            $.Joomla('submitform', ['publishUser']);
                        }
                    },

                    '{promoteMember} click': function(el, ev) {
                        if(document.adminForm.boxchecked.value == 0) {
                            alert($.language('JLIB_HTML_PLEASE_MAKE_A_SELECTION_FROM_THE_LIST'));
                        } else {
                            $.Joomla('submitform', ['promoteMembers']);
                        }
                    },

                    '{demoteMember} click': function(el, ev) {
                        if(document.adminForm.boxchecked.value == 0) {
                            alert($.language('JLIB_HTML_PLEASE_MAKE_A_SELECTION_FROM_THE_LIST'));
                        } else {
                            $.Joomla('submitform', ['demoteMembers']);
                        }
                    }
                }
            });

            module.resolve();
        });
});

EasySocial.module( 'admin/indexer/indexer' , function($){

	var module	= this;

	EasySocial.require()
	.language(
		'COM_EASYSOCIAL_INDEXER_REINDEX_PROCESSING',
		'COM_EASYSOCIAL_INDEXER_REINDEX_FINISHED',
		'COM_EASYSOCIAL_INDEXER_REINDEX_RESTART'
		)
	.view( 'site/loading/small' )
	.done(function($){

		EasySocial.Controller(
		'Indexer',
		{
			defaultOptions:
			{
				// Elements
				"{startButton}"	: "[data-start-button]",
				"{indexerBar}" : "[data-indexer-bar]",
				"{indexerResult}" : "[data-indexer-result]",
				"{indexerMessage}" : "[data-indexer-message]",
				"{resultsButton}"	: "[data-results-button]",

				view :
				{
					loadingContent 	: "site/loading/small"
				}
			}
		},
		function( self ){
			return {

				init : function(){},

				"{startButton} click" : function()
				{
					self.runIndex( 0 );
					self.indexerMessage().html( $.language('COM_EASYSOCIAL_INDEXER_REINDEX_PROCESSING') );
					self.indexerMessage().show();
					self.startButton().hide();
				},

				runIndex : function( max ){

					//ajax call here.
					EasySocial.ajax( 'admin/controllers/indexer/indexing',
					{
						"max" 		: max,

					},
					{
						beforeSend: function()
						{
							// self.startButton().html( self.view.loadingContent() );
						}
					})
					.done(function( max, progress )
					{
						if( max < 0 )
						{
							progress = '100';
						}

						self.updateProgress( progress );

						if( max >= 0)
						{
							self.runIndex( max );
						}

					})
					.fail(function( message ){
						self.setMessage( message );
					})
					.always(function(){

					});


				},

				updateProgress: function( progress )
				{
					self.indexerBar().css( 'width', progress + '%')
					self.indexerResult().html( progress + '%' );

					if( progress == 100 )
					{
						self.indexerMessage().html( $.language( 'COM_EASYSOCIAL_INDEXER_REINDEX_FINISHED' ) );
						self.startButton().html( $.language( 'COM_EASYSOCIAL_INDEXER_REINDEX_RESTART' ) );
						self.startButton().show();

						self.resultsButton().removeClass('hide');
					}
				},



			}
		});

		module.resolve();
	});

});

EasySocial.module( 'admin/mailer/mailer' , function($) {

	var module = this;

	EasySocial.Controller(
		'Mailer',
		{
			defaultOptions :
			{
				"{item}"	: "[data-mailer-item]"
			}
		},
		function( self )
		{
			return {
				init : function()
				{
					self.item().implement( EasySocial.Controller.Mailer.Item );
				}
			}
		});

	EasySocial.Controller(
		'Mailer.Item',
		{
			defaultOptions :
			{
				"{preview}"	: "[data-mailer-item-preview]"
			}
		},
		function( self )
		{
			return {
				init : function()
				{
					self.options.id 	= self.element.data( 'id' );
				},

				"{preview} click" : function( el , event )
				{
					EasySocial.dialog(
					{
						content 	: EasySocial.ajax( 'admin/views/mailer/preview' , { 'id' : self.options.id } )
					})

				}
			}
		});

	module.resolve();

});
EasySocial.module('admin/maintenance/database', function($) {
    var module = this;

    EasySocial.Controller('Maintenance.Database', {
        defaultOptions: {
            '{start}': '[data-start]',

            '{progress}': '[data-progress]',

            '{progressBox}': '[data-progress-box]',

            '{progressBar}': '[data-progress-bar]',

            '{progressPercentage}': '[data-progress-percentage]'
        }
    }, function(self) {
        return {
            init: function() {

            },

            '{start} click': function(el) {
                el.hide();

                self.progress().show();

                self.process();
            },

            counter: 0,

            versions: [],

            process: function() {
                self.getStats().done(function(versions) {
                    self.versions = versions;

                    self.execute();
                });
            },

            getStats: function() {
                return EasySocial.ajax('admin/controllers/maintenance/getDatabaseStats');
            },

            execute: function() {
                if (self.versions[self.counter] === undefined) {
                    return self.completed();
                }

                EasySocial.ajax('admin/controllers/maintenance/synchronizeDatabase', {
                    version: self.versions[self.counter]
                }).done(function() {
                    self.counter++;

                    var percentage = Math.floor((self.counter/self.versions.length) * 100) + '%';

                    self.progressBar().css('width', percentage);

                    self.progressPercentage().text(percentage);

                    self.execute();
                });
            },

            completed: function() {
                self.progressBar().css('width', '100%');

                self.progressPercentage().text('100%');

                self.progressBox()
                    .removeClass('progress-info')
                    .addClass('progress-success');
            }
        }
    });

    $('[data-base]').addController('EasySocial.Controller.Maintenance.Database');

    module.resolve();
});

EasySocial.module('admin/maintenance/maintenance', function($) {
    var module = this;

    EasySocial.Controller('Maintenance.Execute', {
        defaultOptions: {
            '{row}': '[data-row]'
        }
    }, function(self) {
        return {
            init: function() {
                self.runscript();
            },

            counter: 0,

            success: 0,

            fail: 0,

            runscript: function() {
                var row = self.row().eq(self.counter);

                if (row.length === 0) {
                    return self.completed();
                }

                var key = row.data('key');

                EasySocial.ajax('admin/controllers/maintenance/runscript', {
                    key: key
                }).done(function() {
                    self.setStatus(row, 1);
                    self.success++;
                }).fail(function() {
                    self.setStatus(row, 0);
                    self.fail++;
                }).always(function() {
                    self.counter++;
                    self.runscript();
                });
            },

            completed: function() {
                if (self.fail < 1) {
                    window.location = 'index.php?option=com_easysocial&view=maintenance&success=' + self.success;
                }
            },

            setStatus: function(row, state) {
                var status = row.find('[data-status]'),
                    icon = row.find('[data-icon]'),
                    statuses = ['label-danger', 'label-success', 'label-warning'],
                    icons = ['ies-warning-2', 'ies-checkmark', 'ies-wrench-3'];

                for (i = 0; i < 3; i++) {
                    status.toggleClass(statuses[i], state == i);
                    icon.toggleClass(icons[i], state == i);
                }
            }
        }
    });

    module.resolve();
});

EasySocial.module( 'admin/migrators/migrator' , function($) {

	var module = this;

	EasySocial.require()
	.script( 'progress/progress' )
	.done(function($){

		EasySocial.Controller(
			'Migrators.Migrator',
			{
				// A list of selectors we define
				// and expect template makers to follow.
				defaultOptions:
				{
					// Controller Properties.
					component 			: null,

					processState 		: 0,

					// Progress bar controller
					progressController : null,

					mapping 			: null,

					updateconfig 		: 0,


					"{initiateButton}"	: "[data-initiate-migration]",
					"{progressBar}" 	: ".discoverProgress",
					"{results}"			: ".scannedResult",
					"{viewLog}"			: ".viewLog",
					"{customFieldsMap}" : "[data-custom-fields-map]",

					"{resultForm}"		: "[data-migration-result]",

					"{startWidget}"		: "[data-start-widget]",
					"{fieldItem}"		: "[data-field-item]",

					"{startMigrationButton}" : "[data-start-migration]",

					"{rows}"			: "[data-row-item]",
					"{selection}"		: "[data-field-item]",

					"{jomsocialBackButton}" : "[data-jomsocial-back-button]"
				}
			},
			function(self){

				return {

					init: function()
					{
						// Initialize progress bar.
						self.initProgressBar();

						// Initialize the logging area.
						self.initLogging();
					},

					showCustomFields: function()
					{
						// Hide the initial section
						self.startWidget().slideUp();

						//Show the custom fields map.
						self.customFieldsMap().slideDown();
					},

					showResultForm: function()
					{
						self.customFieldsMap().slideUp();

						if( self.options.component != 'com_community' )
						{
							self.startWidget().slideUp();
						}

						self.resultForm().slideDown();
					},

					startMigration: function()
					{
						// Disable start button.
						// self.startButton().attr( 'disabled' , 'disabled' );

						self.showResultForm();

						// to prevent user click multiple times.
						if( self.options.processState == 1 )
						{
							return;
						}
						else
						{
							self.options.processState = 1;
						}

						self.reset();


						// Discover the list of files.
						EasySocial.ajax( 'admin/controllers/migrators/check' ,
						{
							'component' : self.options.component
						})
						.done(function( data )
						{

							if( data.isvalid )
							{
								// Begin progress.
								self.options.progressController.begin( data.count );

								// Begin to loop through each files.
								self.startIterating('');
							}
							else
							{
								// Ensure results is always hidden.
								self.results().show();

								// Add logging
								self.addLog( 'Error: ' + data.message );

								// reopen the process state.
								self.options.processState = 0;
							}

						});
					},

					// Resets the scan.
					reset: function()
					{
						// Reset the logs
						self.results().html('');

						// Hide the viewlog button
						self.initLogging();

						// Reset progress bar.
						self.options.progressController.reset();
					},

					initLogging: function()
					{
						// Ensure view log button is always hidden.
						self.viewLog().hide();
					},

					initProgressBar: function()
					{
						// Implement progressbar
						self.progressBar().implement( EasySocial.Controller.Progress );

						// Set this to the options so that we can easily access the controller.
						self.options.progressController	= self.progressBar().controller();
					},

					addLog: function( message )
					{
						$( '<li>' ).html( message )
							.appendTo( self.results() );
					},

					startIterating: function( item )
					{

						if( self.options.mapping == null )
						{
							if( self.selection().length > 0 )
							{
								self.options.mapping = $('#adminForm').serializeArray();
							}
						}

						EasySocial.ajax( 'admin/controllers/migrators/process' ,
						{
							"component"	: self.options.component,
							"item" 		: item,
							"mapping"	: self.options.mapping,
							"updateconfig"	: self.options.updateconfig,
						})
						.always(function( data, updateConfig )
						{

							self.options.updateconfig = updateConfig;

							// As long as the files list are not empty yet, we still need to process it.
							if( data["continue"] )
							{
								// Update once.
								self.options.progressController.touch( 'Discovering...' );

								// Append message to the result list.
								self.addLog( data.message );

								// Run this again.
								self.startIterating( data.item );
							}
							else
							{
								// Update once.
								self.options.progressController.touch( 'Discover Completed' );

								// Append message to the result list.
								self.addLog( data.message );

								// Append completed message to the result list since we know this is the last item.
								self.addLog( 'migration process completed.' );

								// Show view log button.
								self.viewLog().show();

								// Make the scan button work again.
								self.jomsocialBackButton().show();

								// reopen the process state.
								self.options.processState = 0;
							}
						});
					},

					"{fieldItem} change" : function( el )
					{
						var value 	= $( el ).val();

						// Add error class on row
						if( value == '' )
						{
							$( el ).parents( '[data-row-item]' ).removeClass( 'success' ).addClass( 'error' );
						}
						else
						{
							$( el ).parents( '[data-row-item]' ).removeClass( 'error' ).addClass( 'success' );
						}
					},

					"{startMigrationButton} click" : function()
					{
						// If there's error, show dialog and confirm that the user doesn't want to migrate
						// selected fields.
						if( self.selection().length > 0 )
						{
							self.selection().each( function( i, el ) {

								if( $( el ).val() == "" )
								{
									$( el ).parents( '[data-row-item]' ).removeClass( 'success' ).addClass( 'error' );
								}
								else
								{
									$( el ).parents( '[data-row-item]' ).removeClass( 'error' ).addClass( 'success' );
								}
							});
						}

						var hasError = self.rows().hasClass( 'error' );

						if( hasError )
						{
							EasySocial.dialog(
							{
								content 	: EasySocial.ajax( 'admin/views/migrators/confirmMigration' ),
								bindings 	:
								{
									"{submitButton} click" : function()
									{
										self.startMigration();

										EasySocial.dialog().close();
									}
								}
							});
						}
						else
						{
							// do lets this.
							self.startMigration();

						}

					},

					"{initiateButton} click" : function( element )
					{
						self.showCustomFields();
					},

					"{viewLog} click" : function()
					{
						self.results().toggle();
					}
				}

			}
		);

		module.resolve();
	});

});

EasySocial.module( 'admin/points/discover' , function($) {

	var module = this;

	EasySocial.require()
	.script( 'progress/progress' )
	.language( 'COM_EASYSOCIAL_SCAN_COMPLETED' )
	.done(function($){

		EasySocial.Controller(
			'Points.Discover',
			{
				// A list of selectors we define
				// and expect template makers to follow.
				defaultOptions:
				{
					// Controller Properties.
					files 			: [],

					// Progress bar controller
					progressController : null,

					// Start button
					"{startButton}"	: "[data-points-discovery-start]",

					// Progress Bar
					"{progressBar}" : ".discoverProgress",

					// Logging results
					"{results}"		: "[data-points-discovery-result]"
				}
			},
			function(self){

				return {

					init: function()
					{
						// Initialize progress bar.
						self.initProgressBar();
					},

					// Resets the scan.
					reset: function()
					{
						// Reset the logs
						self.results().html('');

						// Reset progress bar.
						self.options.progressController.reset();
					},

					initProgressBar: function()
					{
						// Implement progressbar
						self.progressBar().implement( EasySocial.Controller.Progress );

						// Set this to the options so that we can easily access the controller.
						self.options.progressController	= self.progressBar().controller();
					},

					addLog: function( message )
					{
						$( '<tr>' ).append( $( '<td>' ).html( message ) ).appendTo( self.results() );
					},

					startIterating: function()
					{
						// Get the file from the shelf
						var file 	= self.options.files.shift();

						EasySocial.ajax( 'admin/controllers/points/scan' ,
						{
							"file"	: file
						})
						.always(function( data , message , completeMessage ){

							// As long as the files list are not empty yet, we still need to process it.
							if( self.options.files.length > 0 )
							{
								// Update once.
								self.options.progressController.touch( '...' );

								// Append message to the result list.
								self.addLog( message );

								// Run this again.
								self.startIterating();
							}
							else
							{
								// Update once.
								self.options.progressController.touch( '...' );

								// Append message to the result list.
								self.addLog( message );

								// Append message to the result list.
								self.addLog( $.language( 'COM_EASYSOCIAL_SCAN_COMPLETED' ) );

								// Make the scan button work again.
								self.startButton().removeAttr( 'disabled' );
							}
						});
					},

					"{startButton} click" : function( element )
					{
						self.reset();

						// Disable start button.
						self.startButton().attr( 'disabled' , 'disabled' );

						// Discover the list of files.
						EasySocial.ajax( 'admin/controllers/points/discoverFiles' , {})
						.done(function( files , message )
						{
							self.reset();

							// Set the files to the properties.
							self.options.files 	= files;

							if( self.options.files.length > 0 )
							{
								// Begin progress.
								self.options.progressController.begin( self.options.files.length );

								// Add logging
								self.addLog( message );

								// Begin to loop through each files.
								self.startIterating();
							}
							else
							{
								// Update once.
								self.options.progressController.begin( 1 );
								self.options.progressController.completed( 'Discover Completed' );

								// Append message to the result list.
								self.addLog( $.language( 'COM_EASYSOCIAL_SCAN_COMPLETED' ) );

								// Make the scan button work again.
								self.startButton().removeAttr( 'disabled' );
							}


						});
					}
				}

			}
		);

		module.resolve();
	});

});

EasySocial.module( 'admin/privacy/discover' , function($) {

	var module = this;

	EasySocial.require()
	.script( 'progress/progress' )
	.done(function($){

		EasySocial.Controller(
			'Privacy.Discover',
			{
				// A list of selectors we define
				// and expect template makers to follow.
				defaultOptions:
				{
					// Controller Properties.
					files 			: [],

					// Progress bar controller
					progressController : null,

					// Start button
					"{startButton}"	: ".scanRules",

					// Progress Bar
					"{progressBar}" : ".discoverProgress",

					// Logging results
					"{results}"		: ".scannedResult",

					// View logs button.
					"{viewLog}"		: ".viewLog",

					// View items.
					view			:
					{
					}
				}
			},
			function(self){

				return {

					init: function()
					{
						// Initialize progress bar.
						self.initProgressBar();

						// Initialize the logging area.
						self.initLogging();
					},

					// Resets the scan.
					reset: function()
					{
						// Reset the logs
						self.results().html('');

						// Hide the viewlog button
						self.initLogging();

						// Reset progress bar.
						self.options.progressController.reset();
					},

					initLogging: function()
					{
						// Ensure view log button is always hidden.
						self.viewLog().hide();
					},

					initProgressBar: function()
					{
						// Implement progressbar
						self.progressBar().implement( EasySocial.Controller.Progress );

						// Set this to the options so that we can easily access the controller.
						self.options.progressController	= self.progressBar().controller();
					},

					addLog: function( message )
					{
						$( '<li>' ).html( message )
							.appendTo( self.results() );
					},

					startIterating: function()
					{
						// Get the file from the shelf
						var file 	= self.options.files.shift();

						EasySocial.ajax( 'admin/controllers/privacy/scan' ,
						{
							"file"	: file
						})
						.always(function( data ){

							// As long as the files list are not empty yet, we still need to process it.
							if( self.options.files.length > 0 )
							{
								// Update once.
								self.options.progressController.touch( 'Discovering...' );

								// Append message to the result list.
								self.addLog( 'Scanned ' + data.file + ' : ' + data.rules.length + ' rules installed.' );

								// Run this again.
								self.startIterating();
							}
							else
							{
								// Update once.
								self.options.progressController.touch( 'Discover Completed' );

								// Append message to the result list.
								self.addLog( 'Scanned ' + data.file + ' : ' + data.rules.length + ' rules installed.' );

								// Append completed message to the result list since we know this is the last item.
								self.addLog( 'Scanning completed.' );

								// Show view log button.
								self.viewLog().show();

								// Make the scan button work again.
								self.startButton().removeAttr( 'disabled' );
							}
						});
					},

					"{startButton} click" : function( element )
					{
						self.reset();

						// Disable start button.
						self.startButton().attr( 'disabled' , 'disabled' );

						// Discover the list of files.
						EasySocial.ajax( 'admin/controllers/privacy/discoverFiles' , {})
						.done(function( files ){

							// Set the files to the properties.
							self.options.files 	= files;

							if( self.options.files.length > 0 )
							{
								// Begin progress.
								self.options.progressController.begin( self.options.files.length );

								// Ensure results is always hidden.
								self.results().hide();

								// Add logging
								self.addLog( 'Found a total of ' + files.length + ' rules file in the site.' );

								// Begin to loop through each files.
								self.startIterating();
							}
							else
							{
								// Update once.
								self.options.progressController.begin( 1 );
								self.options.progressController.completed( 'Discover Completed' );

								// Append message to the result list.
								self.addLog( $.language( 'COM_EASYSOCIAL_SCAN_COMPLETED' ) );

								// Make the scan button work again.
								self.startButton().removeAttr( 'disabled' );
							}

						});
					},

					"{viewLog} click" : function()
					{
						self.results().toggle();
					}
				}

			}
		);

		module.resolve();
	});

});

EasySocial.module( 'admin/profiles/avatar' , function($){

	var module	= this;

	EasySocial.require()
	.script( 'uploader/uploader' )
	.done( function(){

		EasySocial.Controller(
			'Profiles.Avatar',
			{
				defaultOptions:
				{
					// Properties
					token 				: null,

					// Elements
					"{fileUploader}"		: "[data-profile-avatars-uploader]",
					"{startUploadButton}"	: "[data-profile-avatars-startupload]",
					"{avatarList}"			: "[data-profile-avatars-list]",
					"{avatarEmpty}"			: "[data-profile-avatars-empty]",
					"{avatarItem}"			: "[data-profile-avatars-item]",
					"{messagePlaceholder}"	: "[data-profile-avatars-message]",
					"{removeFile}"			: ".removeFile",
					"{clearUploadedItems}"	: "[data-uploader-clear]"
				}
			},
			function(self)
			{
				return {

					init: function()
					{
						// Get the current profile id
						self.options.id 	= self.element.data( 'id' );

						// Initialize upload controller
						self.initUploader();

						// Initialize avatar controller
						self.initAvatar();
					},

					initUploader: function()
					{
						// Apply uploader controller on the file uploader.
						self.fileUploader().implement( EasySocial.Controller.Uploader,
							{
								url : $.indexUrl + '?option=com_easysocial&namespace=admin/controllers/profiles/uploadDefaultAvatars&' + self.options.token + '=1&tmpl=component&format=ajax&uid=' + self.options.id
							});
					},

					initAvatar: function()
					{
						// Apply controller to avatar items.
						self.avatarItem().implement( 'EasySocial.Controller.Profiles.Avatar.Item',
						{
							"{parent}"	: self,
							items		: self.avatarItem
						});
					},

					addMessage: function( message )
					{
						// Clear previous messages first
						self.clearMessage();

						self.setMessage( message );
					},
					/**
					 * Override the file removal click event.
					 */
					"{removeFile} click" : function( el , event )
					{
						var id 	= $(el).parents( 'li' ).attr( 'id' );

						self.fileUploader().controller().removeItem( id );
					},

					/**
					 * Bind the click event on the start upload button.
					 */
					"{startUploadButton} click" : function()
					{
						var controller	= self.fileUploader().controller();

						controller.startUpload();
					},

					/**
					 * Track the progress of the uploaded item.
					 */
					"{fileUploader} UploadProgress" : function( el , event , file )
					{
						// Get the upload progress.
						var progress	= file.percent,
							elementId	= '#' + file.id,
							progressBar	= $( elementId ).find( '.progressBar' );

						// Show the progress bar.
						progressBar.show();

						// Update the width of the progress bar.
						progressBar.find( '.bar' ).css( 'width' , progress + '%' );
					},

					// Bind the UploadComplete method provided by uploader
					"{fileUploader} FileUploaded" : function( el, event, file, response )
					{
						if( response[ 0 ] != undefined )
						{
							var contents 	= response[0].data[ 0 ];

							// Hide empty if any
							self.avatarEmpty().hide();

							// Prepend the item
							self.avatarList().prepend( contents );

							self.clearUploadedItems().show();

							// Apply the controller
							self.initAvatar();
						}
					},

					"{clearUploadedItems} click" : function()
					{
						var controller 	= self.fileUploader().controller();

						// Reset the queue
						controller.reset();

						// Hide itself since there's no history now.
						self.clearUploadedItems().hide();
					}
				}
			}
		);

		/**
		 * Avatar item controller.
		 */
		EasySocial.Controller(
			'Profiles.Avatar.Item',
			{
				defaultOptions:
				{
					// Properties.
					id 		: null,

					"{deleteLink}"			: "[data-avatar-delete]",
					"{setDefaultAvatar}"	: "[data-avatar-default]"
				}
			},
			function( self )
			{
				return {

					init : function()
					{
						self.options.id 	= self.element.data( 'id' );
					},

					/**
					 * Sets an avatar as the default avatar.
					 */
					"{setDefaultAvatar} click" : function(el , event )
					{
						EasySocial.ajax(
						'admin/controllers/avatars/setDefault',
						{
							"id" : self.options.id
						})
						.done(function( message )
						{
							// Remove all default class
							self.parent.avatarItem().removeClass( 'default' );

							// Add a default class to itself
							self.element.addClass( 'default' );

							self.parent.addMessage( message );
						});
					},

					"{deleteLink} click": function()
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'admin/views/profiles/confirmDeleteAvatar' ),
							bindings	: 
							{
								"{deleteButton} click" : function( el , event )
								{
									$( el ).addClass( 'btn-loading' );
									
									EasySocial.ajax( 'admin/controllers/avatars/delete' , 
									{
										"id" : self.options.id
									})
									.done(function( message )
									{										
										// Remove the element
										self.element.remove();

										if( self.parent.avatarList().children().length == 0 )
										{
											self.parent.avatarEmpty().show();
										}

										self.parent.addMessage( message );

										// Hide the dialog
										EasySocial.dialog().close();										
									});
								}
							}
						})
					}
				}
			});

		module.resolve();

	});

});



EasySocial.module( 'uploader/uploader' , function($){

	var module 	= this;

	EasySocial.require()
	.library( 'plupload' )
	.view( 'site/uploader/queue.item' )
	.script( 'uploader/queue' )
	.done( function(){

		EasySocial.Controller(
			'Uploader',
			{
				defaults:
				{
					url				: $.indexUrl + '?option=com_easysocial&controller=uploader&task=uploadTemporary&format=json&tmpl=component&' + EasySocial.token() + '=1',
					uploaded		: [],

					// Allows caller to define their custom query.
					query				: "",

					plupload 			: '',
					dropArea			: 'uploaderDragDrop',
					extensionsAllowed 		: 'jpg,jpeg,png,gif',

					temporaryUpload 	: false,

					// Contains a list of files in the queue so others can manipulate this.
					files 			: [],

					'{uploaderForm}' 	: '[data-uploader-form]',
					'{uploadButton}'	: '[data-uploader-browse]',
					'{uploadArea}'		: '.uploadArea',

					// This contains the file list queue.
					'{queue}'			: '[data-uploaderQueue]',

					// The queue item.
					'{queueItem}'		: '[data-uploaderQueue-item]',

					// When the queue doesn't have any item, this is the container.
					'{emptyFiles}'			: '[data-uploader-empty]',

					// This is the file removal link.
					'{removeFile}'			: '[data-uploaderQueue-remove]',
					'{uploadCounter}'		: '.uploadCounter',

					view :
					{
						queueItem : "site/uploader/queue.item"
					}
				}
			},
			function( self ){ return {

				init: function(){

					// Implement the uploader queue.
					self.queue().implement( EasySocial.Controller.Uploader.Queue );

					if( self.options.temporaryUpload )
					{
						self.options.url 	= $.indexUrl + '?option=com_easysocial&controller=uploader&task=uploadTemporary&format=json&tmpl=component&' + EasySocial.token() + '=1';
					}

					if( self.options.query != '' )
					{
						self.options.url 	= self.options.url + '&' + self.options.query;
					}

					// Initialize the uploader element
					self.uploaderForm().implement(
						'plupload',
						{
							settings:
							{
								url				: self.options.url,
								drop_element	: self.options.dropArea,
								filters			: [{
									title		: 'Allowed File Type',
									extensions	: self.options.extensionsAllowed
								}]
							},
							'{uploader}'		: '[data-uploader-form]',
							'{uploadButton}'	: '[data-uploader-browse]'
						},
						function()
						{
							// Get the plupload options
							self.options.plupload = this.plupload;
						}
					);
				},

				"{uploaderForm} FilesAdded": function(el, event, uploader, files )
				{
					// Add a file to the queue when files are selected.
					self.addFiles( files );

					// Begin the upload immediately if needed
					if( self.options.temporaryUpload )
					{
						self.startUpload();
					}

				},

				"{uploaderForm} UploadProgress" : function( el , event , uploader , file ){

					// Trigger upload progress on the queue item.
					self.queueItem( '#' + file.id ).trigger( 'UploadProgress' , file );

				},

				'{uploaderForm} FileUploaded' : function( el , event, uploader, file , response ){

					// console.log( 'here' );

					// Trigger upload progress on the queue item.
					self.queueItem( '#' + file.id ).trigger( 'FileUploaded' , [file , response] );
				},

				"{uploaderForm} UploadComplete" : function( el , event , uploader , files )
				{
					self.options.uploading 	= false;
				},

				/**
				 * Error handling should come here
				 */
				'{uploaderForm} Error': function(el, event, uploader, error)
				{
					// Clear previous message
					self.clearMessage();

					var obj = { 'message' : error.message , 'type' : 'error' };

					self.setMessage( obj );
				},

				'{uploaderForm} FileError': function(el, event, uploader, file, response)
				{
					var obj = { 'message' : response.message , 'type' : 'error' };

					self.setMessage(obj);

					self.queueItem( '#' + file.id ).trigger('FileError', [file, response]);

					// queueItem.find('[data-uploaderqueue-progress]')
					// self.removeItem(file.id);
				},

				/**
				 * Adds an item into the upload queue.
				 */
				addFiles: function( files )
				{
					// Go through each of the files.
					$.each( files , function( index , file )
					{
						// Get the file size.
						file.size 		= self.formatSize( file.size );

						// Get the upload queue content.
						var content 	= self.view.queueItem(
											{
												"file"	: file,
												"temporaryUpload" : self.options.temporaryUpload
											});

						// Implement the queue item controller.
						$( content ).implement( EasySocial.Controller.Uploader.Queue.Item ,
						{
							"{uploader}"	: self
						});

						// Add this item into our own queue.
						self.options.files.push( file );

						// Hide the "No files" value
						self.emptyFiles().hide();

						// Append the queue item into the queue
						self.queue().append( content );
					});
				},

				/**
				 * Formats the size in bytes into kilobytes.
				 */
				formatSize: function( bytes )
				{
					// @TODO: Currently this only converts bytes to kilobytes.
					var val = parseInt( bytes / 1024 );

					return val;
				},

				/**
				 * Clears the list of upload items in the queue.
				 */
				reset: function()
				{
					// Remove the item from the list.
					self.queueItem().remove();
				},

				/**
				 * Removes an item from the upload queue.
				 */
				removeItem: function( id )
				{
					var element 	= $( '#' + id );

					// When an item is removed, we need to send an ajax call to the server to delete this record
					var uploaderId	= $( element ).find( 'input[name=upload-id\\[\\]]' ).val();

					EasySocial.ajax( 'site/controllers/uploader/delete' , { "id" : uploaderId } )
					.done(function()
					{
						// Remove the item from the attachment list.
						$( '#' + id ).remove();

						// Now remove the item from the plupload queue.
						self.options.plupload.removeFile( self.options.plupload.getFile( id ) );
					});
				},

				/**
				 * Begins the upload process.
				 */
				startUpload: function()
				{
					self.upload();
				},

				upload: function()
				{
					if(self.options.plupload.files.length > 0)
					{
						self.options.uploading 	= true;
						self.options.plupload.start();
					}
				},

				/**
				 * Determines if there's any files in the queue currently.
				 */
				 hasFiles: function(){
				 	return self.options.files.length > 0;
				 }

			} }
		);

		module.resolve();
	});


});

EasySocial.module( 'uploader/queue' , function($){

	var module 	= this;

	EasySocial.require()
	.view( 'site/uploader/queue.item' )
	.done( function($){

		EasySocial.Controller(
			'Uploader.Queue',
			{
				defaults:
				{
					"{item}"	: "[data-uploaderQueue-item]"
				}
			},
			function( self ){

				return {

					init: function()
					{
						self.item().implement( EasySocial.Controller.Uploader.Queue.Item );
					}
				}
			}
		);

		EasySocial.Controller( 
			'Uploader.Queue.Item',
			{
				defaultOptions:
				{
					"{delete}"	: "[data-uploaderQueue-remove]",
					"{progress}": "[data-uploaderQueue-progress]",
					"{progressBar}" : "[data-uploaderQueue-progressBar]",
					"{status}"		: "[data-uploaderQueue-status]",
					"{id}"			: "[data-uploaderQueue-id]"
				}
			},
			function( self ){
				return {
					init : function()
					{

						if( self.uploader.options.temporaryUpload )
						{						
							// Store it as template and remove it
							self.idTemplate = self.id().toHTML();
							self.id().remove();
						}
					},

					"{delete} click" : function()
					{
						self.uploader.removeItem( self.element.attr( 'id' ) );
					},

					"{self} FileUploaded" : function( el , event , file , response )
					{
						// var response	= response[0];

						if( self.uploader.options.temporaryUpload )
						{
							// Create a hidden input containing the id
							$.buildHTML(self.idTemplate)
								.val(response.id)
								.appendTo(self.element);
						}

						if( file.status == 5 )
						{
							self.element.addClass( 'is-done' );
							self.status().html( 'Done' );
						}
					},

					"{self} UploadProgress" : function( el , event , progress )
					{
						// Set the progress.
						self.status().html( progress.percent + '%' );

						self.progressBar().css( 'width' , progress.percent + '%');
					},

					"{self} FileError": function()
					{
						self.element.removeClass("is-done is-queue").addClass("is-error");

						self.progress()
							.removeClass("progress-danger progress-success progress-info progress-warning")
							.addClass("progress-danger");

						self.status().html( 'Error' );
					}
				}
			}
		);

		module.resolve();
	});
});

EasySocial.module('admin/profiles/fields', function($) {
	var module = this;

	EasySocial.require()
	.library(
		'ui/draggable',
		'ui/sortable',
		'ui/droppable'
	)
	.script(
		'field'
	)
	.view(
		'admin/profiles/form.fields.editorItem',
		'admin/profiles/form.fields.stepItem',
		'admin/profiles/form.fields.editorPage',
		'admin/profiles/form.fields.config',
		'admin/profiles/dialog.move.field'
	)
	.language(
		'COM_EASYSOCIAL_PROFILES_FORM_FIELDS_ITEM_CONFIG_LOADING',
		'COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_PAGE_DIALOG_TITLE',
		'COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_PAGE_DIALOG_CONFIRMATION',
		'COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_PAGE_DIALOG_CONFIRM',
		'COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_PAGE_DIALOG_CANCEL',
		'COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_PAGE_DIALOG_DELETING',
		'COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_ITEM_DIALOG_TITLE',
		'COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_ITEM_DIALOG_CONFIRMATION',
		'COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_ITEM_DIALOG_CONFIRM',
		'COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_ITEM_DIALOG_CANCEL',
		'COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_ITEM_DIALOG_DELETING',
		'COM_EASYSOCIAL_PROFILES_FORM_FIELDS_PARAMS_CORE_UNIQUE_KEY_SAVE_FIRST',
		'COM_EASYSOCIAL_PROFILES_FORM_FIELDS_CONFIGURE_PAGE',
		'COM_EASYSOCIAL_PROFILES_FORM_FIELDS_CONFIGURE_FIELD',
		'COM_EASYSOCIAL_FIELDS_REQUIRE_MANDATORY_FIELDS',
		'COM_EASYSOCIAL_FIELDS_UNSAVED_CHANGES',
		'COM_EASYSOCIAL_FIELDS_INVALID_VALUES'
	)
	.done(function() {

		// Controller instance
		var $Parent, $Browser, $Editor, $Steps, $Config;

		// Data registry
		var $Apps = {}, $Core = {}, $Check = {}, $Fields = {}, $Pages = {};

		// Delete registry
		var $Deleted = {
			pages: [],
			fields: []
		}

		EasySocial.Controller('Fields', {
			defaultOptions: {
				id: 0,

				group: null,

				'{wrap}'		: '[data-fields-wrap]',

				'{browser}'		: '[data-fields-browser]',
				'{editor}'		: '[data-fields-editor]',
				'{steps}'		: '[data-fields-steps]',
				'{config}'		: '[data-fields-config]',
				'{saveForm}'	: '[data-fields-save]',

				view: {
					config: 'admin/profiles/form.fields.config'
				}
			}
		}, function(self) {
			return {

				init: function()
				{
					$Parent = self;

					// The id's are bound in data-id
					self.options.id = self.element.data('id');

					// Get the controller for field browser.
					$Browser	= self.addPlugin('browser');

					// Get the controller for field editor.
					$Editor		= self.addPlugin('editor');

					// Get the controller for steps.
					$Steps		= self.addPlugin('steps');

					var controllers = [$Browser.state, $Editor.state, $Steps.state];

					// Only trigger when all of the states is resolved
					$.when.apply(null, controllers).done(function() {
						$Parent.trigger('controllersReady');
					});

					// Listen to save event on profileForm to perform the save
					$('.profileForm').on('save', function(ev, task, result) {
						var data = self.save(task);
						result.push(data);
					});
				},

				changed: false,

				customFieldChanged: function() {
					self.changed = true;
				},

				'{window} beforeunload': function(el, ev) {
					if(self.changed) {
						return $.language('COM_EASYSOCIAL_FIELDS_UNSAVED_CHANGES');
					}
				},

				/**
				 * When save form is called, call each page's export function to get the data
				 */
				'{saveForm} click': function()
				{
					self.save();
				},

				/**
				 * Send the data to the controller to process the fields.
				 */
				save: function(task)
				{
					var dfd = $.Deferred();

					// Disable all input and select within this form to prevent them from getting through POST
					self.element.find('input,select').not(self.saveForm()).prop('disabled', true);

					// Reset saveform value first
					self.saveForm().val('');

					if( task === 'savecopy' )
					{
						self.changed = true;
					}

					// If no changes, then skip this saving
					if( !self.changed )
					{
						dfd.resolve();

						return dfd;
					}

					// Trigger saving event
					$Parent.trigger('saving');

					// If config is open, we run a internal populate first on the config
					if($Config && $Config.state) {
						if(!$Config.checkConfig()) {

							EasySocial.dialog({
								content: $.language('COM_EASYSOCIAL_FIELDS_INVALID_VALUES')
							});

							dfd.reject();

							return dfd;
						}
					}

					// Clone a non-referenced $Core object into $Check
					$Check = $.extend(true, {}, $Core);

					var data = [];

					// Loop through each step
					$.each($Steps.step(), function(i, step) {
						step = $(step);

						// Get the step's page controller
						var page = $Editor.getPage(step.data('id'));

						// Call the page's export function to get the data of the page
						data.push(page._export());
					});

					// Check if all core apps has been used
					if($._.keys($Check).length > 0) {
						// Trigger saved event and pass in false to indicate error
						$Parent.trigger('saved', [false]);

						EasySocial.dialog({
							content: $.language('COM_EASYSOCIAL_FIELDS_REQUIRE_MANDATORY_FIELDS')
						});

						dfd.reject();

						return dfd;
					}

					$Parent.changed = false;

					var saveData = {
						data: data,
						deleted: $Deleted
					};

					self.injectSaveData(saveData);

					dfd.resolve();

					return dfd;
				},

				/**
				 * Responsible to inject the data object into the hidden input for POST processing
				 */
				injectSaveData: function(data) {
					data = JSON.stringify(data);

					self.saveForm().val(data);
				},

				/**
				 * Update the form based on the returned data
				 */
				updateResult: function(data)
				{
					// It has the same format as the data
					$.each(data, function(i, dataStep) {
						// Get the step based on index (sequence)
						var step = $Steps.step().eq(i);

						// Assign step id first
						var stepid = step.data('id');

						// Get the page
						var page = $Editor.getPage(stepid);

						// Update the step id
						$Steps.updateResult(i, dataStep.id);

						// Update the page id
						page.updateResult(stepid, dataStep);
					});
				},

				'{self} doneConfiguring': function() {
					self.element.removeClass('editting');
				},

				loadConfiguration: function(item, type) {
					self.element.addClass('editting');

					// var config = self.config().clone();
					var config = $(self.view.config());

					$Config = config.addController('EasySocial.Controller.Fields.Config', {
						controller: {
							item: item
						}
					});

					if(type === 'page')
					{
						item.pageHeader().append(config);
					}
					else
					{
						item.element.append(config);
					}

					// $('body').append(config);

					self.element.trigger('loadingConfig', [type]);
				}
			}
		});

		/* Browser Controller */
		EasySocial.Controller('Fields.Browser', {
			defaultOptions: {
				'{browser}'		: '[data-fields-browser]',

				'{mandatory}'	: '[data-fields-browser-group-mandatory]',
				'{unique}'		: '[data-fields-browser-group-unique]',
				'{standard}'	: '[data-fields-browser-group-standard]',

				'{list}'		: '[data-fields-browser-list]',
				'{item}'		: '[data-fields-browser-item]',

				'affixClass'	: 'es-browser-affix'
			}
		}, function(self) {
			return {
				state: $.Deferred(),

				init: function() {
					// Things to do before resolving self
					self.registerApps();

					self.ready();

					self.affixHandler();

					self.initAffix();
				},

				ready: function() {
					self.state.resolve();
				},

				'{parent} controllersReady': function() {
					var id = $Steps.getCurrentStep().data('id');

					self.initDraggable(id);
				},

				'{parent} pageChanged': function(el, ev, page, uid) {
					self.item().draggable('destroy');

					self.initDraggable(uid);
				},

				'{parent} pageAdded': function(el, ev, page, uid) {
					self.item().draggable('destroy');

					self.initDraggable(uid);
				},

				initDraggable: function(id) {
					self.item().draggable({
						revert: 'invalid',
						helper: 'clone',
						connectToSortable: '[data-fields-editor-page-items-' + id + ']'
					});
				},

				affixHandler: function() {
					var parent = $(window),
						wrap = self.parent.wrap(),
						height = wrap.offset().top,
						scroll = parent.scrollTop();

					if(scroll > height && !self.browser().hasClass(self.options.affixClass)) {
						self.browser().addClass(self.options.affixClass);
					}

					if(scroll <= height && self.browser().hasClass(self.options.affixClass)) {
						self.browser().removeClass(self.options.affixClass);
					}
				},

				initAffix: function() {
					$(window).scroll(self.affixHandler);
				},

				registerApps: function() {
					// Register all available apps into an object
					$.each(self.item(), function(index, item) {
						item = $(item);

						var id = item.data('id');

						$Apps[id] = {
							id: id,
							element: item.data('element'),
							title: item.data('title'),
							params: item.data('params'),
							core: item.data('core'),
							unique: item.data('unique'),
							item: item
						};

						// Keep a list of core apps id in $Core
						if(item.data('core')) {
							$Core[id] = $Apps[id];
						}
					});
				},

				/**
				 * Used to check if core apps has been used in saving. Core apps have to be completely used to saved.
				 */
				checkout: function(id) {
					if($Check[id] !== undefined) {
						delete $Check[id];
					}
				},

				/**
				 * This is the event handler for the field items selection.
				 */
				'{item} click': function(el) {
					// Get the current page.
					var currentPage = $Editor.currentPage();

					// Get the app id of the item clicked
					var appid = el.data('id');

					// Add new item to the page
					currentPage.addNewField(appid);
				},

				/**
				 * Carry out any necessary actions when app is added as a field
				 */
				'{parent} fieldAdded': function(el, event, appid) {
					var app = $Apps[appid];

					if(app && app.core) {
						app.item.hide();

						// If core app is added, check if there are any remaining core app left to hide the core group
						var items = self.mandatory().find(self.item.selector).filter(':visible');

						self.mandatory().toggle((items.length > 0));
					}

					if(app && app.unique) {
						app.item.hide();

						// If unique app is added, check if there are any remaining unique app left to hide the unique group
						var items = self.unique().find(self.item.selector).filter(':visible');

						self.unique().toggle((items.length > 0));
					}
				},

				/**
				 * Carry out any necessary actions when field is removed
				 */
				'{parent} fieldDeleted': function(el, event, appid, fieldid) {
					var app = $Apps[appid];

					if(app && app.core) {
						app.item.show();

						// If core app is deleted, then the browser group for core fields have to definitely show
						self.mandatory().show();

						return;
					}

					if(app && app.unique) {
						app.item.show();

						// If unique app is deleted, then the browser group for unique fields have to definitely show
						self.unique().show();

						return;
					}
				}
			}
		});

		/* Config Controller */
		EasySocial.Controller('Fields.Config', {
			defaultOptions: {
				'{config}'		: '[data-fields-config]',

				'{header}'		: '[data-fields-config-header]',

				'{close}'		: '[data-fields-config-close]',

				'{form}'		: '[data-fields-config-form]',

				'{param}'		: '[data-fields-config-param]',

				'{tabnav}'		: '[data-fields-config-tab-nav]',
				'{tabcontent}'	: '[data-fields-config-tab-content]',

				'{done}'		: '[data-fields-config-done]'
			}
		}, function(self) {
			return {
				init: function() {
				},

				state: false,

				load: function(config) {
					// Set state to true to indicate editting mode
					self.state = true;

					// Apply multi choices
					config.find('[data-fields-config-param-choices]').addController('EasySocial.Controller.Config.Choices', {
						controller: {
							item: self.item
						}
					});

					// Hide the field title
					config.find( 'h4' ).hide();

					// Update the header
					self.header().html( config.find( 'h4' ).html() );

					// Inject the html into the form
					self.form().html(config);

					// Carry out necessary actions after config has been loaded if this is a new field
					if(self.item.options.newfield) {

						// Disable the unique key field if it is a new field
						self.param('[data-fields-config-param-field-unique_key]')
							.attr('disabled', true)
							.val($.language('COM_EASYSOCIAL_PROFILES_FORM_FIELDS_PARAMS_CORE_UNIQUE_KEY_SAVE_FIRST'));
					}

					// Load the first tab as active
					if(self.tabnav().length > 0) {
						var coreTab = self.tabnav().find('a[data-tabname="core"]');

						if(coreTab.length > 0) {
							coreTab.tab('show');
						} else {
							self.tabnav().find('a:first').tab('show');
						}
					}

					self.populateConfig();

					// Get the config height for css fix
					var configHeight = self.element.height();

					$Parent.wrap().css('padding-bottom', configHeight + 'px');

					$Parent.trigger('configLoaded');
				},

				'{close} click': function(el, ev) {
					self.closeConfig();
				},

				'{done} click': function(el, ev) {
					self.closeConfig();
				},

				closeConfig: function() {
					var values = self.populateConfig();

					// Check through the values
					var state = self.checkConfig(values);

					if(state) {
						self.item.updateHtml(self.form().html());

						self.item.content().trigger('onConfigSave', [values]);

						self.element.remove();

						$Config = null;

						$Parent.trigger('doneConfiguring');
					} else {
						EasySocial.dialog({
							content: $.language('COM_EASYSOCIAL_PROFILES_FORM_FIELDS_INVALID_VALUES'),
							width: 400,
							height: 100
						});
					}
				},

				'{parent} loadingConfig': function(el, ev, header) {

					// Set the config header
					if(header !== undefined && header != 'field' )
					{
						var headerText = $.language('COM_EASYSOCIAL_PROFILES_FORM_FIELDS_CONFIGURE_' + header.toUpperCase());
						self.header().html(headerText);
					}

					// Show the config panel
					self.config().show();

					// Hide the close button first
					self.close().hide();

					// Set the loading state
					self.form().html($.language('COM_EASYSOCIAL_PROFILES_FORM_FIELDS_ITEM_CONFIG_LOADING'));
				},

				'{parent} configLoaded': function(el, ev) {
					self.close().show();
				},

				'{param} change': function(el) {
					self.paramChanged(el);
				},

				'{param} keyup': function(el) {
					self.paramChanged(el);
				},

				paramChanged: function(el) {
					var name = el.data('name'),
						value = self.getConfigValue(name);

					var field = self.item.appParams[name];

					// Manually convert boolean field into boolean value for toggle to work properly
					if(field.type === 'boolean') {
						value = !!value;
					}

					self.item.fieldItem().trigger('onConfigChange', [name, value]);

					$Parent.customFieldChanged();
				},

				getConfigValue: function(name) {
					var field = self.item.appParams[name],
						// element = self.param('[data-fields-config-param-field-' + name +']');
						element = self.param().filterBy('name', name);

					if(element.length === 0) {
						return undefined;
					}

					var values = '';

					switch(field.type) {
						case 'choices':
							values = [];

							$.each(element.find('li'), function(i, choice) {
								choice = $(choice);

								var titleField = choice.find('[data-fields-config-param-choice-title]'),
									valueField = choice.find('[data-fields-config-param-choice-value]'),
									defaultField = choice.find('[data-fields-config-param-choice-default]');

								values.push({
									'id': choice.data('id'),
									'title': titleField.val(),
									'value': valueField.val(),
									'default': defaultField.val()
								});

								titleField.attr('value', titleField.val());
								valueField.attr('value', valueField.val());
								defaultField.attr('value', defaultField.val());
							});
						break;

						case 'boolean':
							var tmp = element.val();

							values = (tmp === 'true' || tmp === '1' || tmp === 1) ? 1 : 0;

							element.attr('value', values);
						break;

						case 'checkbox':
							values = [];
							$.each(field.option, function(k, option) {
								var checkbox = element.filter('[data-fields-config-param-option-' + option.value + ']');

								if(checkbox.length > 0 && checkbox.is(':checked')) {
									values.push(option.value);

									checkbox.attr('checked', 'checked');
								} else {
									checkbox.removeAttr('checked');
								}
							});
						break;

						case 'list':
						case 'select':
						case 'dropdown':
							values = element.length > 0 ? element.val() : field["default"] || '';

							element.find('option').prop('selected', false);

							element.find('option[value="' + values + '"]').prop('selected', true);
						break;

						case 'input':
					case 'text':
						default:
							values = element.length > 0 ? element.val() : field["default"] || '';

							element.attr('value', values);
						break;
					}

					return values;
				},

				populateConfig: function() {
					var data = {};

					$.each(self.item.appParams, function(name, field) {
						var value = self.getConfigValue(name);

						if(value === undefined) {
							// If getConfigValue returns undefined, means this field is not found, then skip to the next field
							return false;
						}

						data[name] = value;
					});

					self.item.trigger('onPopulateConfig', [data]);

					return data;
				},

				checkConfig: function(values) {
					if(values === undefined) {
						values = self.populateConfig();
					}

					// Perform custom checks here
					var state = true;

					$.each(values, function(name, value) {
						var field = self.item.appParams[name];

						switch(field.type) {
							// custom check for choices
							case 'choices':
								// Get all the values first
								var choiceValues = [];

								$.each(value, function(i, choice) {
									if($.isEmpty(choice.value) && !$.isEmpty(choice.title)) {
										choice.value = choice.title.toLowerCase().replace(' ', '');
									}

									if(!$.isEmpty(choice.value) && $.inArray(choice.value, choiceValues) > -1) {
										state = false;
										return false;
									}

									choiceValues.push(choice.value);

									// if((!$.isEmpty(choice.title) && $.isEmpty(choice.value)) || ($.isEmpty(choice.title) && !$.isEmpty(choice.value))) {
									// 	state = false;
									// 	return false;
									// }
								});
							break;
						}

						if(state === false) {
							return false;
						}
					});

					return state;
				},

				'{parent} fieldDeleted': function() {
					if(self.state) {
						$Parent.trigger('doneConfiguring');
					}
				},

				'{parent} pageDeleted': function() {
					if(self.state) {
						$Parent.trigger('doneConfiguring');
					}
				},

				'{parent} pageAdded': function() {
					if(self.state) {
						$Parent.trigger('doneConfiguring');
					}
				},

				'{parent} pageChanged': function() {
					if(self.state) {
						$Parent.trigger('doneConfiguring');
					}
				}
			}
		});

		/* Steps Controller */
		EasySocial.Controller('Fields.Steps', {
			defaultOptions: {
				'{steps}'	: '[data-fields-step]',

				// The step item.
				'{step}'	: '[data-fields-step-item]',

				// The link of each step.
				'{stepLink}': '[data-fields-step-item-link]',

				// The add step button
				'{add}'		: '[data-fields-step-add]',

				view: {
					stepItem: 'admin/profiles/form.fields.stepItem'
				}
			}
		}, function(self) {

			return {
				state: $.Deferred(),

				init: function() {
					self.ready();
				},

				ready: function() {
					self.state.resolve();
				},

				// Delayed init
				'{parent} controllersReady': function() {
					self.initSort();
				},

				initSort: function() {
					self.steps().sortable({
						items: self.step.selector,
						placeholder: 'ui-state-highlight',
						cursor: 'move',
						helper: 'clone',
						forceHelperSize: true,
						stop: function() {
							// Manually remove all the freezing tooltip due to conflict between bootstrap tooltip and jquery sortable
							$('.tooltip-es').remove();

							// Mark as changed
							$Parent.customFieldChanged();
						}
					});
				},

				'{parent} pageDeleted': function(el, event, uid) {
					self.deleteStep(uid);

					// Load the first step as the active page
					if($Steps.step().length > 0) {
						$Steps.stepLink(':first').tab('show');
					}
				},

				'{step} click': function(el, ev) {
					if(!el.hasClass('active')) {
						var id = el.data('id');
						$Parent.trigger('pageChanged', [$Editor.getPage(id), id]);
					}
				},

				/**
				 * Creates a new step.
				 */
				'{add} click': function() {
					// Generate an unique id to link between step and page
					var stepuid = $.uid('step');

					// Add a new step progress at the progress list.
					self.addStep(stepuid);

					// Add a new page form.
					$Editor.addPage(stepuid);

					// Go to the last page automatically since the last page would be the item that is created.
					self.stepLink(':last').tab('show');
				},

				addStep: function(uid) {
					// Always add new step before before the add button
					self.add().before(self.view.stepItem({
						uid: uid
					}));

				},

				getStep: function(uid) {
					return self.step().filterBy('id', uid);
				},

				getStepLink: function(uid) {
					return self.stepLink().filterBy('id', uid);
				},

				deleteStep: function(uid) {
					self.getStep(uid).remove();
				},

				getCurrentStep: function() {
					return self.step('.active');
				},

				currentStepIndex: function() {
					return self.step().index(self.step('.active')) + 1;
				},

				updateResult: function(sequence, newid) {
					var step = self.step(':eq(' + sequence + ')');

					if(step.data('id') != newid) {
						var oldid = step.data('id');

						step.removeAttr('data-fields-step-item-' + oldid);

						step.attr('data-fields-step-item-' + newid, true);

						step.data('id', newid);

						step.attr('data-id', newid);

						var stepLink = self.stepLink().eq(sequence);

						stepLink.removeAttr('data-fields-step-item-link-' + oldid);

						stepLink.attr('data-fields-step-item-link-' + newid, true);

						stepLink.attr('href', '#formStep_' + newid);
					}
				},

				toObject: function() {
					var data = [];

					$.each(self.stepLink(), function(i, step) {
						step = $(step);

						data.push({
							uid: step.data('id'),
							title: step.text(),
							description: step.attr('data-original-title')
						});
					});

					return data;
				}
			}
		});

		/* Editor Controller */
		EasySocial.Controller('Fields.Editor', {
			defaultOptions: {
				'{editor}'	: '[data-fields-editor]',

				'{page}'	: '[data-fields-editor-page]',

				'{items}'	: '[data-fields-editor-page-items]',
				'{item}'	: '[data-fields-editor-page-item]',

				view: {
					editorPage: 'admin/profiles/form.fields.editorPage'
				}
			}
		}, function(self) {
			return {
				state: $.Deferred(),

				init: function() {
					self.ready();
				},

				ready: function() {
					self.state.resolve();
				},

				'{parent} controllersReady': function() {
					// Implements page controller to all pages
					self.page().addController('EasySocial.Controller.Fields.Editor.Page');
				},

				/**
				 * Returns the current page's controller
				 */
				currentPage: function() {
					return self.page('.active').controller();
				},

				/**
				 * Creates a new page container.
				 */
				addPage: function(uid) {
					// Create a new page item
					var newPage = self.view.editorPage({
						uid: uid
					});

					// Initialize the page controller
					newPage.addController('EasySocial.Controller.Fields.Editor.Page', {
						uid: uid,
						newpage: true,
					});

					// Append the new page
					// self.pages().append(newPage.element);
					self.editor().append(newPage);

					// Trigger pageAdded event on all the pages
					self.page().trigger('pageAdded', [newPage, uid]);

					$Parent.customFieldChanged();
				},

				/**
				 * Returns a page controller container based on uid
				 */
				getPage: function(uid) {
					return self.page().filterBy('id', uid).controller();
				},

				/**
				 * Carry out the necessary action when form is saving
				 */
				'{parent} saving': function(el, event) {
					self.element.addClass('saving');
				},

				/**
				 * Carry out the necessary action when form is saved
				 */
				'{parent} saved': function(el, event, state) {
					// If state is false, this means error during saving
					if(state === false) {
						// TODO: Dialog box needed
					}

					self.element.removeClass('saving');
				}
			}
		});

		/* Editor Page Controller */
		EasySocial.Controller('Fields.Editor.Page', {
			defaultOptions: {
				// This is the stepid stored in the db
				pageid						: 0,

				// This is the unique id generated if the page is a new page
				uid							: 0,

				newpage						: false,

				'{items}'					: '[data-fields-editor-page-items]',
				'{item}'					: '[data-fields-editor-page-item]',

				'{pageHeader}'				: '[data-fields-editor-page-header]',

				// $Config compatibility
				'{content}'					: '[data-fields-editor-page-header]',
				'{fieldItem}'					: '[data-fields-editor-page-header]',

				'{pageTitle}'				: '[data-fields-editor-page-title]',
				'{pageDescription}'			: '[data-fields-editor-page-description]',

				'{inputTitle}'				: '[data-fields-editor-page-title-input]',
				'{inputDescription}'		: '[data-fields-editor-page-description-input]',

				'{pageVisibleRegistration}'	: '[data-fields-editor-page-visible-registration]',
				'{pageVisibleEdit}'			: '[data-fields-editor-page-visible-edit]',
				'{pageVisibleView}'			: '[data-fields-editor-page-visible-view]',
				'{pageDelete}'				: '[data-fields-editor-page-delete]',
				'{pageEdit}'				: '[data-fields-editor-page-edit]',
				'{pageInfo}'				: '[data-fields-editor-page-info]',
				'{pageInfoDone}'			: '[data-fields-editor-page-done]',

				view: {
					editorItem: 'admin/profiles/form.fields.editorItem'
				}
			}
		}, function(self) {

			return {
				init: function() {

					// Assign uid as pageid if this is not a new page
					if(!self.options.newpage)
					{
						self.options.uid = self.options.pageid = self.element.data('id');
					}

					// Register self into Pages registry
					self.registerPage();

					self.item().addController('EasySocial.Controller.Fields.Editor.Item', {
						pageid: self.options.uid
					});

					// Check for delete button state
					self.checkPageDeleteButton();

					// Init the sorting
					self.initSort();
				},

				// Keep a registry of current page's fields
				fields: {},

				getStep: function() {
					return $Steps.getStep(self.options.uid);
				},

				registerPage: function() {
					$Pages[self.options.uid] = self;
				},

				initSort: function() {
					self.items().sortable({
						items: self.item.selector,
						handle: '[data-fields-editor-page-item-handle]',
						placeholder: 'ui-state-highlight',
						cursor: 'move',
						helper: 'clone',
						forceHelperSize: true,
						stop: function(event, ui) {
							if(ui.item.is($Browser.item.selector)) {
								var appid = ui.item.data('id');

								// Create a placeholder first
								var placeholder = self.createPlaceholder();
								ui.item.replaceWith(placeholder);

								// Create new field and let it replace the placeholder
								self.createNewField(appid, placeholder);
							}

							// Mark change
							$Parent.customFieldChanged();
						}
					});
				},

				addNewField: function(appid) {
					// Append a placeholder first
					var placeholder = self.createPlaceholder();
					self.items().append(placeholder);

					$.scrollTo(placeholder, 200);

					// Create new field and let new field replace the placeholder
					self.createNewField(appid, placeholder);

					$Parent.customFieldChanged();
				},

				createPlaceholder: function() {
					// Generate a uid first
					var uid = $.uid('newfield');

					// Generate a placeholder
					var placeholder = self.view.editorItem({
						uid: uid
					});

					return placeholder;
				},

				createNewField: function(appid, placeholder) {
					// Trigger fieldAdded event
					$Parent.trigger('fieldAdded', [appid]);

					// get the html asyncly
					self.getFieldHtml(appid)
						.done(function(html) {
							// Third parameter set to true to preserve script tags
							html = $.parseHTML(html, document, true);

							// Wrap the whole parsed html as jquery object
							html = $(html);

							// Replace the original loading placeholder with the html object
							placeholder.replaceWith(html);

							// Retrieve the main div to implement item controller
							var div = html.filter('[data-appid="' + appid + '"]');

							// Implement the item controller
							div.addController('EasySocial.Controller.Fields.Editor.Item', {
								controller: {
									page: self
								},

								appid: appid,
								pageid: self.options.uid,
								newfield: true,
							});
						}).fail(function(msg) {
							placeholder.html(msg);
						});
				},

				getFieldHtml: function(appid) {
					var state = $.Deferred();

					if($Apps[appid].html === undefined) {
						EasySocial.ajax('admin/controllers/fields/renderSample', {
							appid: appid,
							profileid: $Parent.options.id,
							group: $Parent.options.group
						}).done(function(html) {
							$Apps[appid].html = html;

							state.resolve(html);
						}).fail(function(msg) {
							state.reject(msg);
						});
					} else {
						state.resolve($Apps[appid].html);
					}

					return state;
				},

				'{pageHeader} click': function(el, event) {
					var clickedTarget = $(event.target);

					if(clickedTarget.not('[data-fields-editor-page-delete]') && !el.hasClass('editting')) {

						if($Config && $Config.state) {

							var state = $Config.checkConfig();

							// Remove itself from other field
							if(state) {
								$Config.closeConfig();
							} else {
								EasySocial.dialog({
									content: $.language('COM_EASYSOCIAL_PROFILES_FORM_FIELDS_INVALID_VALUES'),
									width: 400,
									height: 100
								});

								return;
							}
						}

						self.loadConfiguration();
					}
				},

				loadConfiguration: function() {
					$Parent.loadConfiguration(self, 'page');

					self.pageHeader().addClass('editting');

					self.getPageConfig()
						.done(function() {
							var pageConfig = $(self.html);

							$Config.load(pageConfig);
						})
						.fail(function(msg) {
							$Config.load(msg);
						});
				},

				updateHtml: function(html) {
					self.html = html;
				},

				getPageConfig: function() {
					var state = $.Deferred();

					if(!$.isEmptyObject(self.params)) {
						state.resolve();
					} else {
						EasySocial.ajax('admin/controllers/profiles/getPageConfig', {
							pageid: self.options.pageid
						})
						.done(function(params, values, html) {
							self.params = params;
							self.values = values;
							self.html = html;

							// Compatibility with $Config
							self.appParams = params;

							state.resolve();
						})
						.fail(function(msg) {
							state.reject(msg);
						});
					}

					return state;
				},

				getConfigValues: function() {
					return self.values;
				},

				'{fieldItem} onConfigChange': function(el, ev, name, value) {

					self.values[name] = value;

					var step = $Steps.getStepLink(self.options.uid);


					if(name === 'title') {

						step.text(value);

						self.pageTitle().html(value);
					}

					if(name === 'description') {
						// Used attr('data-original-title') instead of data('original-title') because the tooltip reads the attribute directly while data() adds the value back as a jQuery data on to the element
						step.attr('data-original-title', value);

						self.pageDescription().html(value);
					}

					$Parent.customFieldChanged();
				},

				'{pageDelete} click': function(el) {
					if(el.enabled()) {
						el.disabled(true);

						// If it is the last page, then it shouldn't delete.
						if($Editor.page().length == 1) {
							el.enabled(true);

							// @TODO: error box needed

							return false;
						}

						EasySocial.dialog({
							width: 400,
							height: 150,
							title: $.language('COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_PAGE_DIALOG_TITLE'),
							content: $.language('COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_PAGE_DIALOG_CONFIRMATION'),
							showOverlay: false,
							buttons: [
								{
									// CANCEL button
									name: $.language('COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_PAGE_DIALOG_CANCEL'),
									classNames: 'btn btn-es',
									click: function() {
										el.enabled(true);
										EasySocial.dialog().close();
									}
								},
								{
									// DELETE button
									name: $.language('COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_PAGE_DIALOG_CONFIRM'),
									classNames: 'btn btn-es-danger',
									click: function() {
										// Update the dialog content first
										EasySocial.dialog().update({
											content: $.language('COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_PAGE_DIALOG_DELETING')
										});

										// Start deleting the page
										self.deletePage();

										// Close the dialog
										EasySocial.dialog().close();
									}
								}
							]
						});
					}
				},

				deletePage: function() {
					// Trigger pageDeleted event
					self.item().trigger('pageDeleted');
					$Parent.trigger('pageDeleted', [self.options.uid]);

					// Remove self from $Pages registry
					delete $Pages[self.options.uid];

					// Add self into $DeletedPages registry
					if(!self.options.newpage) {
						$Deleted.pages.push(self.options.uid);
					}

					// Removed current page
					self.element.remove();

					// Check for delete button
					$.each($Editor.page(), function(i, page) {
						$(page).controller().checkPageDeleteButton();
					});

					$Parent.customFieldChanged();
				},

				_export: function() {
					var fields = [];

					$.each(self.item(), function(j, item) {
						item = $(item).controller();

						if(item !== undefined)
						{
							fields.push(item._export());
						}
					});

					var data = {
						fields: fields,
						newpage: self.options.newpage,
						id: self.options.uid
					}

					if(self.values !== undefined) {
						var data = $.extend(data, self.values);
					}

					return data;
				},

				updateResult: function(oldid, data) {
					if(self.options.newpage) {

						// Update the page element id attribute (to correspond with the step tab structure)
						self.element.attr('id', 'formStep_' + data.id);

						// Remove the old selector and add in the new selector
						self.element.removeAttr('data-fields-editor-page-' + oldid);
						self.element.attr('data-fields-editor-page-' + data.id, true);

						// Assign pageid to self.options
						self.options.pageid = self.options.uid = data.id;

						// Update the $Pages registry
						$Pages[data.id] = $.extend(true, {}, $Pages[oldid]);
						delete $Pages[oldid];

						// Since the page has been saved, then it should not be a new page anymore
						self.options.newpage = false;
					}

					if(data.fields !== undefined) {
						$.each(data.fields, function(i, field) {
							// Go by sequence
							var item = self.item().eq(i).controller();

							item.updateResult(field);
						});
					}
				},

				/**
				 * Carry out necessary action when a new page is added
				 */
				'{self} pageAdded': function(el, event, page) {
					self.checkPageDeleteButton();

					$Parent.customFieldChanged();
				},

				checkPageDeleteButton: function() {
					if($Editor.page().length > 1) {
						self.pageDelete().show();
					} else {
						self.pageDelete().hide();
					}
				},

				'{parent} loadingConfig': function() {
					self.pageHeader().removeClass('editting');
					self.item().removeClass('editting');
				},

				'{parent} doneConfiguring': function() {
					self.pageHeader().removeClass('editting');
					self.item().removeClass('editting');
				}
			}
		});

		/* Editor Item Controller */
		EasySocial.Controller('Fields.Editor.Item', {
			defaultOptions: {
				appid			: 0,
				fieldid			: 0,
				pageid			: 0,

				newfield		: false,

				'{edit}'		: '[data-fields-editor-page-item-edit]',
				'{deleteButton}': '[data-fields-editor-page-item-delete]',
				'{moveButton}'	: '[data-fields-editor-page-item-move]',
				'{content}'		: '[data-fields-editor-page-item-content]',
				'{fieldItem}'	: '[data-field]',

				'{config}'		: '[data-fields-config]',

				'{closeConfig}'	: '[data-fields-config-close]',

				view: {
					moveDialog: 'admin/profiles/dialog.move.field'
				}
			}
		}, function(self) {

			return {
				app: {},

				field: {
					id: 0,
					appid: 0,
					params: {}
				},

				state: $.Deferred(),

				appParams: {},

				init: function() {

					// Check if it has a valid appid or not
					if(self.options.appid == 0 && self.element.data('appid') !== undefined) {
						self.options.appid = self.element.data('appid');
					}

					// Check if this field's app is a valid app or not
					if($Apps[self.options.appid] !== undefined) {

						// Link the reference copy to self.app from $Apps registry
						self.app = $Apps[self.options.appid];
					}

					// Check if it has fieldid or not
					if(self.options.fieldid == 0 && self.element.data('id') !== undefined) {
						self.options.fieldid = self.element.data('id');
					}

					// Register $Fields
					self.registerFields();

					// Generate a unique id to identify configuration tabs
					self.uniqueid = $.uid(self.app.id + '_');

					self.loadedInit();
				},

				registerFields: function() {
					if(self.options.fieldid != 0) {
						$Fields[self.options.fieldid] = {
							id: self.options.fieldid,
							appid: self.options.appid,
							params: self.field.params || {}
						}

						// Link the reference copy to self.field if this is an existing field
						self.field = $Fields[self.options.fieldid];
					}
				},

				loadedInit: function() {

					// Implement field base controller
					self.element.addController('EasySocial.Controller.Field.Base', {
						mode: 'sample',
						element: self.app.element
					});

					// Implement a common config controller on the item
					self.content().addController('EasySocial.Controller.Fields.Editor.Item.Config');
				},

				// export data during save
				_export: function() {
					// Call checkout function from browser to check if all core apps has been used
					$Browser.checkout(self.options.appid);

					// Initialise export data with appid and fieldid
					// If fieldid == 0, means it is a new field
					// If appid == 0, means it is a non valid application
					var exportData 	= {
						"fieldid"	: self.options.fieldid,
						"appid"		: self.options.appid,
						"newfield"	: self.options.newfield
					};

					// Add in parameter values into export data
					exportData = $.extend(exportData, self.expandConfig(self.field.params));

					return exportData;
				},

				'{self} click': function(el, event) {
					var clickedElement = $(event.target);

					// Click on anywhere of the element except the delete button to load the configuration panel
					if(!clickedElement.is(self.deleteButton.selector) && !clickedElement.is(self.moveButton.selector) && !clickedElement.is(self.config.selector) && !clickedElement.is(self.closeConfig.selector) && !el.hasClass('editting')) {

						// If config state is true, means it is editting other field
						if($Config && $Config.state) {

							var state = $Config.checkConfig();

							// Remove itself from other field
							if(state) {
								$Config.closeConfig();
							} else {
								EasySocial.dialog({
									content: $.language('COM_EASYSOCIAL_PROFILES_FORM_FIELDS_INVALID_VALUES'),
									width: 400,
									height: 100
								});

								return;
							}
						}

						self.loadConfiguration();
					}
				},

				loadConfiguration: function() {
					// $Parent.trigger('loadingConfig', ['field']);
					$Parent.loadConfiguration(self, 'field');

					self.element.addClass('editting');

					self.getAppParams()
						.done(function() {

							var html = $(self.field.html);

							// Pass objects to config panel
							$Config.load(html);
						})
						.fail(function() {

						});
				},

				updateHtml: function(html) {
					self.field.html = html;
				},

				/**
				 * Get field parameters from the server.
				 */
				getAppParams: function() {
					var state = $.Deferred();

					if(self.field.html) {
						state.resolve();
					} else {
						EasySocial.ajax('admin/controllers/fields/renderConfiguration', {
							// Send the application id
							appid		: self.options.appid,

							// Send the field id.
							fieldid		: self.options.fieldid
						})
						.done(function(params, values, html) {

							self.app.params = params;

							self.field.params = values;

							self.field.html = html;

							// This will keep a flat list of the available parameters
							self.populateAppParams();

							state.resolve();
						})
						.fail(function(msg) {
							state.reject(msg);
						});
					}

					return state;
				},

				/**
				 * Populate parameters data
				 */
				populateAppParams: function() {
					$.each(self.app.params, function(i, paramProperties) {
						$.each(paramProperties.fields, function(name, field) {

							if(field.subfields) {
								$.each(field.subfields, function(subname, subfield) {
									self.appParams[name + '_' + subname] = subfield;
								});
							} else {
								self.appParams[name] = field;
							}
						});
					});
				},

				/**
				 * To return the field parameters value
				 */
				getConfigValues: function() {
					return self.field.params;
				},

				/**
				 * Converts flatten config data to expanded data for saving purposes
				 */
				expandConfig: function() {
					var newData = {
						params: {},
						choices: {}
					};

					$.each(self.field.params, function(name, value) {

						var field = self.appParams[name];

						if(!field) {
							return false;
						}

						var type = field.type == 'choices' ? 'choices' : 'params';

						newData[type][name] = value;
					});

					if(self.options.newfield) {
						newData.params.unique_key = '';
					}

					return newData;
				},

				'{moveButton} click': function(el) {
					var pages = $Steps.toObject(),
						currentPageId = el.parents($Editor.page.selector).data('id'),
						newPages = [];

					$.each(pages, function(i, page) {
						if(page.uid != currentPageId) {
							newPages.push(page);
						}
					});

					EasySocial.dialog({
						content: self.view.moveDialog(true, {
							pages: newPages
						}),
						selectors: {
							"{selection}"		: "[data-move-selection]",
							"{confirmButton}"	: "[data-move-confirm]",
							"{cancelButton}"	: "[data-move-cancel]"
						},
						bindings: {
							"{cancelButton} click" : function()
							{
								// Close the dialog
								EasySocial.dialog().close();
							},

							"{confirmButton} click": function() {
								var id = this.selection().val(),
									page = $Editor.getPage(id);

								page.items().append(self.element);

								$Parent.customFieldChanged();

								EasySocial.dialog().close();
							}
						}
					});
				},

				'{deleteButton} click': function(el) {

					if(el.enabled()) {
						el.disabled(true);

						EasySocial.dialog(
						{
							width: 400,
							height: 150,
							title: $.language('COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_ITEM_DIALOG_TITLE'),
							content: $.language('COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_ITEM_DIALOG_CONFIRMATION'),
							showOverlay: false,
							buttons: [
								{
									// CANCEL button
									name: $.language('COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_ITEM_DIALOG_CANCEL'),
									classNames: 'btn btn-es btn-sm',
									click: function() {
										el.enabled(true);
										EasySocial.dialog().close();
									}
								},
								{
									// DELETE button
									name: $.language('COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_PAGE_DIALOG_CONFIRM'),
									classNames: 'btn btn-es-danger btn-sm',
									click: function() {

										// Update the dialog content first
										EasySocial.dialog().update({
											content: $.language('COM_EASYSOCIAL_PROFILES_FORM_FIELDS_DELETE_ITEM_DIALOG_DELETING')
										});

										// Start deleting the field
										self.deleteField();

										// Close the dialog
										EasySocial.dialog().close();
									}
								}
							]
						});
					}
				},

				deleteField: function() {
					// Trigger fieldDeleted event
					$Parent.trigger('fieldDeleted', [self.options.appid, self.options.fieldid]);

					if(!self.options.newfield) {

						// Delete fields in registry
						delete $Fields[self.options.fieldid];

						// Add this field into the deleted registry
						$Deleted.fields.push(self.options.fieldid);
					}

					// Remove field element
					self.element.remove();

					$Parent.customFieldChanged();
				},

				'{self} pageDeleted': function() {
					self.deleteField();
				},

				'{content} onConfigChange': function(el, event, name, value) {
					self.field.params[name] = value;
				},

				'{self} onPopulateConfig': function(el, event, values) {
					self.field.params = values;
				},

				// Unused
				updateResult: function(data) {
					// Update the unique key
					self.field.params.unique_key = data.unique_key;
					self.itemParam('[data-fields-config-param-field-unique_key]').val(data.unique_key);

					// If this is a new field, the some things need to be updated
					if(self.options.newfield) {
						// Set newfield to false because post-save, this will no longer be a new field
						self.options.newfield = false;

						// Set the fieldid
						self.options.fieldid = data.fieldid;
						self.element.data('id', data.fieldid);

						// Enable the unique key field
						self.itemParam('[data-fields-editor-page-item-param-field-unique_key]').removeAttr('disabled');

						// Register into $Fields registry
						self.registerFields();
					}

					if(data.choices !== undefined) {
						$.each(data.choices, function(name, choices) {
							var element = self.itemParam('[data-fields-config-param-field-' + name + ']');

							$.each(choices, function(i, choice) {
								// Go by sequence
								var item = element.find('li').eq(i);

								if(!item.data('id')) {
									item.attr('data-id', choice.id);
									item.data('id', choice.id);
								}
							});
						});
					}
				}
			}
		});

		/* Config Choices Controller */
		EasySocial.Controller( 'Config.Choices', {
			defaultOptions: {
				'{choiceItems}'	: '[data-fields-config-param-choice]',

				unique			: 1
			}
		}, function(self) {

			return {
				init: function() {
					self.options.unique = self.element.data('unique') !== undefined ? self.element.data('unique') : 1;

					self.choiceItems().implement( EasySocial.Controller.Config.Choices.Choice, {
						controller: {
							'item': self.item,
							'choices': self
						}
					});

					self.initSortable();
				},

				initSortable: function() {
					self.element.sortable({
						items: self.choiceItems.selector,
						placeholder: 'ui-state-highlight',
						cursor: 'move',
						forceHelperSize: true,
						handle: '[data-fields-config-param-choice-drag]',
						stop: function() {
							// Manually remove all the freezing tooltip due to conflict between bootstrap tooltip and jquery sortable
							$('.tooltip-es').remove();

							// Mark change
							$Parent.customFieldChanged();
						}
					});
				}
			}
		});

		/* Config Choices Choice Controller */
		EasySocial.Controller( 'Config.Choices.Choice', {
			defaultOptions: {
				'{choiceValue}'		: '[data-fields-config-param-choice-value]',
				'{choiceTitle}'		: '[data-fields-config-param-choice-title]',
				'{choiceDefault}'	: '[data-fields-config-param-choice-default]',
				'{addChoice}'		: '[data-fields-config-param-choice-add]',
				'{removeChoice}'	: '[data-fields-config-param-choice-remove]',
				'{setDefault}'		: '[data-fields-config-param-choice-setdefault]',

				'{defaultIcon}'		: '[data-fields-config-param-choice-defaulticon]'
			}
		}, function(self) {

			return {

				init: function() {
				},

				'{choiceTitle} keyup': $._.debounce(function(el, event) {
					var index = self.element.index();

					self.item.fieldItem().trigger('onChoiceTitleChanged', [index, el.val()]);

					$Parent.customFieldChanged();
				}, 500),

				'{choiceValue} keyup': $._.debounce(function(el, event) {
					var index = self.element.index();

					self.item.fieldItem().trigger('onChoiceValueChanged', [index, el.val()]);

					$Parent.customFieldChanged();
				}, 500),

				'{addChoice} click' : function() {
					// Clone a new item from current clicked element
					var newItem = self.element.clone();

					// Let's leave the value blank by default.
					var inputElement = newItem.find('input[type="text"]');

					inputElement.attr('value', '');

					inputElement.val('');

					// Set the default as 0 and the icon to unfeatured
					var inputDefault = newItem.find('input[type="hidden"]');

					inputDefault.attr('value', 0);

					inputDefault.val(0);

					var defaultLabel = newItem.find('[data-fields-config-param-choice-defaulticon]');

					defaultLabel.removeClass('es-state-featured').addClass('es-state-default');

					// set id = 0
					newItem.attr('data-id', 0);
					newItem.data('id', 0);

					// Implement the controller for this choice
					newItem.implement(EasySocial.Controller.Config.Choices.Choice, {
						controller: {
							'item': self.item,
							'choices': self.choices
						}
					});

					// Append this item
					self.element.after(newItem);

					// Get the index of the new item
					var index = newItem.index();

					self.item.fieldItem().trigger('onChoiceAdded', [index]);

					$Parent.customFieldChanged();
				},

				'{removeChoice} click' : function() {
					// We need to minus one because we're trying to remove ourself also.
					var remaining = self.choices.choiceItems().length - 1;

					// If this is the last item, we wouldn't want to allow the last item to be removed.
					if( remaining >= 1 ) {
						// Get the index of the new item
						var index = self.element.index();

						self.item.fieldItem().trigger('onChoiceRemoved', [index]);

						self.element.remove();

						// Manually remove the tooltip generated on the remove button
						$('.tooltip-es').remove();
					}

					$Parent.customFieldChanged();
				},

				'{setDefault} click': function() {
					var index = self.element.index(),
						title = self.choiceTitle().val(),
						value = self.choiceValue().val();

					self.choices.choiceItems().trigger( 'toggleDefault', [index] );

					self.item.fieldItem().trigger('onChoiceToggleDefault', [index, parseInt(self.choiceDefault().val())]);

					$Parent.customFieldChanged();
				},

				'{self} toggleDefault': function(el, ev, i) {
					var index = self.element.index(),
						value = parseInt(self.choiceDefault().val());

					if(index === i) {
						if(value) {
							self.defaultIcon()
								.removeClass('es-state-featured')
								.addClass('es-state-default');

							self.choiceDefault().val(0);
						} else {
							self.defaultIcon()
								.removeClass('es-state-default')
								.addClass('es-state-featured');

							self.choiceDefault().val(1);
						}
					} else {
						if(self.choices.options.unique) {
							self.defaultIcon()
								.removeClass('es-state-featured')
								.addClass('es-state-default');

							self.choiceDefault().val(0);
						}
					}
				}
			}
		});

		/* Editor Item Common Controller */
		// This is the common item config controller to implement on item
		EasySocial.Controller('Fields.Editor.Item.Config', {
			defaultOptions: {
				'{required}'			: '[data-required]',

				'{title}'				: '[data-title]',
				'{description}'			: '[data-description]',

				'{displayTitle}'		: '[data-display-title]',
				'{displayDescription}'	: '[data-display-description]'
			}
		}, function(self) {
			return {
				init: function() {

				},

				'{self} onConfigChange': function(el, event, name, value) {
					switch(name) {
						case 'display_title':
							self.displayTitle().toggle(!!value);
						break;

						case 'title':
							self.title().text(value);
						break;

						case 'display_description':
							self.displayDescription().toggle(!!value);
						break;

						case 'description':
							self.description().text(value);
						break;

						case 'required':
							self.required().toggle(!!value);
						break;
					}
				}
			}
		});

		module.resolve();
	}); // require end

}); // module end

EasySocial.module('field', function($) {
    var module = this;

    EasySocial.Controller('Field.Base', {
        defaultOptions: {
            regPrefix   : 'easysocial/',

            modPrefix   : 'field.',

            ctrlPrefix  : 'EasySocial.Controller.Field.',

            fieldname   : '',

            element     : null,

            id          : null,

            required    : false,

            mode        : 'edit',

            '{field}'   : '[data-field]',

            '{content}' : '[data-content]',

            '{notice}'  : '[data-check-notice]'
        }
    }, function(self) {
        return {
            init: function() {

                self.options.fieldname = self.element.data('fieldname');

                self.options.element = self.options.element || self.element.data('element');

                self.options.id = self.element.data('id');

                self.options.required = !!self.element.data('required');

                self.initMode();

                // Check if there are errors

                if (self.notice().text().trim().length > 0) {
                    self.content().popover({
                        animation: false,
                        content: self.notice().text().trim(),
                        html: true,
                        placement: 'left-top',
                        trigger: 'manual',
                        container: 'body',
                        template: '<div id="fd" class="fd-popover es es-field-error"><div class="arrow"></div><h3 class="fd-popover-title"></h3><div class="fd-popover-content"></div></div>'
                    });

                    self.content().popover('show');
                }
            },

            initMode: function() {
                // Trigger the necessary mode here for field to do necessary init
                switch(self.options.mode)
                {
                    case 'registermini':
                        self.field().trigger('onRegisterMini');
                        break;
                    case 'register':
                        self.field().trigger('onRegister');
                        break;
                    case 'edit':
                        self.field().trigger('onEdit');
                        break;
                    case 'adminedit':
                        self.field().trigger('onAdminEdit');
                        break;
                    case 'sample':
                        self.field().trigger('onSample');
                        break;
                    case 'display':
                        self.field().trigger('onDisplay');
                        break;
                }
            },

            // Some base triggers/functions
            '{field} error': function(el, ev, state, msg) {
                state = state !== undefined ? state : true;

                if($.isString(state)) {
                    msg = state;
                    state = true;
                }

                if($.isBoolean(state)) {
                    self.field().toggleClass('has-error', state);
                }

                if(msg !== undefined) {
                    self.content().popover({
                        animation: false,
                        content: msg,
                        html: true,
                        placement: 'left-top',
                        trigger: 'manual',
                        container: 'body',
                        template: '<div id="fd" class="fd-popover es es-field-error"><div class="arrow"></div><h3 class="fd-popover-title"></h3><div class="fd-popover-content"></div></div>'
                    });

                    self.content().popover('show');
                }
            },

            '{field} clear': function(el, ev) {
                self.field().removeClass('has-error');
                self.field().removeClass('is-loading');

                self.content().popover('destroy');
            },

            '{self} show': function() {
                self.field().trigger('onShow');
            },

            '{field} loading': function(el, ev, msg) {
                self.field().addClass('is-loading');

                self.notice().html(msg);
            },

            '{field} loaded': function(el, ev) {
                self.field().removeClass('is-loading');
            }
        }
    });

    module.resolve();
});

EasySocial.module( 'admin/profiles/members' , function($) {

	var module = this;

	EasySocial
	.require()
	.language( 
		'COM_EASYSOCIAL_CANCEL_BUTTON',
		'COM_EASYSOCIAL_ASSIGN_BUTTON',
		'COM_EASYSOCIAL_PROFILES_ASSIGN_USER_DIALOG_TITLE'
	)
	.done( function($)
	{
		EasySocial.Controller(
			'Profiles.Members',
			{
				defaultOptions :
				{
					"{addUser}"	: "[data-profiles-addUser]",
					"{row}"		: "[data-profiles-members-row]"
				}
			},
			function(self)
			{
				return {

					init : function()
					{
						self.options.id 	= self.element.data( 'id' );
					},

					"{memberList} userSelected": function( el , event , id , name )
					{
						EasySocial.ajax( 'admin/controllers/profiles/insertMember', 
						{
							"id"			: id,
							"profile_id"	: self.options.id
						})
						.done( function( row )
						{
							self.row().append( row );

							// Close the dialog.
							EasySocial.dialog().close();
						});
					},

					"{addUser} click" : function()
					{
						var callbackId 	= $.callback( function(memberList){
							self.addPlugin( 'memberList' , memberList );
						});

						var url 		= $.indexUrl + "?option=com_easysocial&view=users&tmpl=component&callback=" + callbackId;

						EasySocial.dialog({
							title 		: $.language( 'COM_EASYSOCIAL_PROFILES_ASSIGN_USER_DIALOG_TITLE' ),
							content		: url,
							showOverlay	: false,
							width 		: 700,
							height 		: 600,
							buttons		:
							[
								{
									"name"			: $.language( "COM_EASYSOCIAL_CANCEL_BUTTON" ),
									"classNames"	: "btn btn-es",
									"click"			: function()
									{
										EasySocial.dialog().close();
									}
								}
							]
						});
					}

				}
			});

		module.resolve();

	});

});
EasySocial.module('admin/profiles/profile', function($) {
	var module = this;

	EasySocial.require()
	.script('utilities/alias')
	.view('admin/profiles/dialog.delete.profileavatar')
	.language('COM_EASYSOCIAL_PROFILES_FORM_CLEAR_AVATAR')
	.done(function($) {
		EasySocial.Controller('Profiles.Profile', {
			defaultOptions: {
				id: null,

				// Profile avatar
				hasAvatar: false,
				defaultAvatar: null,
				'{profileAvatar}': '[data-profile-avatar]',
				'{profileAvatarImage}': '[data-profile-avatar-image]',
				'{profileAvatarRemoveWrap}': '[data-profile-avatar-remove-wrap]',
				'{profileAvatarRemoveButton}': '[data-profile-avatar-remove-button]',
				'{profileAvatarUpload}': '[data-profile-avatar-upload]',

				view: {
					deleteProfileAvatar: 'admin/profiles/dialog.delete.profileavatar'
				}
			}
		}, function(self) {
			return {
				init: function() {
					self.element.addController('EasySocial.Controller.Utilities.Alias', {
						"{source}"	: "#title",
						"{target}"	: "#alias"
					});

					self.options.hasAvatar = self.profileAvatar().data('hasavatar');
					self.options.defaultAvatar = self.profileAvatar().data('defaultavatar');
				},

				'{profileAvatarUpload} change': function(el) {
					var value = el.val();

					if(!$.isEmpty(value)) {
						self.profileAvatarRemoveWrap().show();
					} else {
						if(!self.options.hasAvatar) {
							self.profileAvatarRemoveWrap().hide();
						}
					}
				},

				'{profileAvatarRemoveButton} click': function(el) {
					if(self.options.hasAvatar) {
						EasySocial.dialog({
							content: self.view.deleteProfileAvatar(true),
							bindings: {
								'{deleteButton} click': function() {
									var dialog = this.parent;

									dialog.loading(true);

									EasySocial.ajax('admin/controllers/profiles/deleteProfileAvatar', {
										id: self.options.id
									}).done(function() {
										dialog.loading(false);

										dialog.close();

										self.profileAvatarImage().attr('src', self.options.defaultAvatar);

										self.profileAvatarRemoveWrap().hide();

										self.profileAvatarRemoveButton().text($.language('COM_EASYSOCIAL_PROFILES_FORM_CLEAR_AVATAR'));

										self.options.hasAvatar = false;
									});
								}
							}
						});
					} else {
						self.profileAvatarUpload().val('').trigger('change');
					}
				}
			}
		});

		module.resolve();
	});
});


EasySocial.module('utilities/alias', function($) {

	var module = this;

	EasySocial.Controller(
		'Utilities.Alias',
		{
			defaultOptions:
			{
				// Should be overriden by the caller.
				"{target}"	: "",
				"{source}"	: ""
			}
		},function( self ){ 
			return {

				init: function()
				{
				},

				convertToPermalink: function( title )
				{
					return title.replace(/\s/g, '-').replace(/[^\w/-]/g, '').toLowerCase();
				},

				"{source} keyup" : function()
				{
					// Update the target when the source is change.
					self.target().val( self.convertToPermalink( self.source().val() ) );
				},

				"{target} keyup" : function()
				{
					self.target().val( self.convertToPermalink( self.target().val() ) );
				}
			}
		});

	module.resolve();
});

EasySocial.module( 'admin/profiles/profiles' , function($) {

	var module = this;

	EasySocial
	.require()
	.done( function($)
	{

		EasySocial.Controller(
			'Profiles',
			{
				defaultOptions :
				{
					"{updateOrdering}"	: "[data-profiles-update-ordering]",
					"{item}"	: "[data-profiles-item]",

					view :
					{
						deleteConfirmation : 'admin/profiles/dialog.delete.confirm'
					}
				}
			},
			function(self)
			{
				return {

					init : function()
					{
						// Implement controller on each row.
						self.item().implement( EasySocial.Controller.Profiles.Item );
					},

					"{updateOrdering} click" : function()
					{
						// Check in all items
						$( '[data-table-checkall]' ).prop( 'checked' , true ).trigger( 'change' );

						$.Joomla( 'submitform' , [ 'updateOrdering' ] );
					}
				}
			});

		EasySocial.Controller(
		'Profiles.Item',
		{
			defaultOptions : 
			{
				"{insertLink}"		: "[data-profile-insert]"
			}
		},
		function( self )
		{
			return {
				init : function()
				{
					self.options.title 	= self.element.data( 'title' );
					self.options.id 	= self.element.data( 'id' );
				},

				"{insertLink} click" : function()
				{
					self.trigger( 'profileSelected' , [ self.options.id , self.options.title ] );
				}
			}
		});

		module.resolve();

	});

});
EasySocial.module('admin/regions/form', function($) {
    var module = this;

    EasySocial.require().language('COM_EASYSOCIAL_REGIONS_FORM_INCOMPLETE').done(function() {

        $.template('easysocial/parents.select', '<select name="parent_uid" data-parent-uid></select>');
        $.template('easysocial/parents.option', '<option value="[%= uid %]">[%= name %]</option>');

        EasySocial.Controller('Regions.Form', {
            defaultOptions: {
                '{type}': '[data-type]',
                '{parentBase}': '[data-parent-base]',
                '{parentContent}': '[data-parent-content]',
                '{parentUid}': '[data-parent-uid]',
                '{parentType}': '[data-parent-type]',

                view: {
                    parentsSelect: 'parents.select',
                    parentsOption: 'parents.option'
                }
            }
        }, function(self) {
            return {
                init: function() {
                    self.element.find('input[type="text"]').prop('disabled', !self.type().val());

                    self.element.find('[data-bs-toggle="radio-buttons"]').toggleClass('disabled', !self.type().val());

                    $.Joomla('submitbutton', function(task) {

                        if (task == 'cancel') {
                            window.location = 'index.php?option=com_easysocial&view=regions';
                            return false;
                        }

                        if (self.validate()) {
                            $.Joomla('submitform', [task]);
                        } else {
                            alert($.language('COM_EASYSOCIAL_REGIONS_FORM_INCOMPLETE'));
                        }
                    });
                },

                '{type} change': function(el) {
                    var parentType = el.find(':selected').data('parent');

                    self.parentType().val(parentType);

                    self.element.find('input[type="text"]').prop('disabled', !el.val());

                    self.element.find('[data-bs-toggle="radio-buttons"]').toggleClass('disabled', !el.val());

                    if (parentType) {
                        self.parentBase().show();

                        !self.parentContent().data('loaded') &&
                        self.getParents(parentType)
                            .done(function(parents) {
                                var base = $(self.view.parentsSelect());

                                $.each(parents, function(i, parent) {
                                    self.view.parentsOption({
                                        uid: parent.uid,
                                        name: parent.name
                                    }).appendTo(base);
                                });

                                self.parentContent().html(base);
                            });
                    } else {
                        self.parentBase().hide();
                    }
                },

                getParents: $.memoize(function(key) {
                    return EasySocial.ajax('admin/controllers/regions/getParents', {
                        type: key
                    });
                }),

                validate: function() {
                    return self.type().val() && self.element.find('input[name="name"]').val() && self.element.find('input[name="code"]').val();
                }
            }
        });

        module.resolve();
    });
});

EasySocial.module('admin/regions/init', function($) {
    var module = this;

    EasySocial.Controller('Region.Init', {
        defaultOptions: {
            callback: function() {},

            '{startButton}': '[data-start]',
            '{table}': '[data-table]',
            '{tableBody}': '[data-table-body]',
            '{row}': '[data-table-row]'
        }
    }, function(self) {
        return {
            init: function() {
                self.row().addController('EasySocial.Controller.Region.Init.Row');
            },

            '{startButton} click': function(el, ev) {
                el.hide();

                self.table().show();

                self.counter = 0;
                self.progress = $.Deferred()
                    .done(function() {
                        self.options.callback();
                    });

                self.process();
            },

            process: function() {
                var row = self.row().eq(self.counter);

                if (row.length === 0) {
                    return self.progress.resolve();
                }

                row.show();

                EasySocial.ajax('admin/controllers/regions/initialise', {
                    key: row.data('key')
                }).done(function() {
                    row.trigger('updateStatus', [1]);

                    self.counter++;

                    self.process();
                });
            }
        }
    });

    EasySocial.Controller('Region.Init.Row', {
        defaultOptions: {
            '{title}': '[data-row-title]',
            '{status}': '[data-row-status]',
            '{icon}': '[data-row-icon]'
        }
    }, function(self) {
        return {
            init: function() {

            },

            statuses: ['label-danger', 'label-success', 'label-warning'],
            icons: ['ies-warning-2', 'ies-checkmark', 'ies-wrench-3'],

            '{self} updateStatus': function(el, ev, state) {
                var status = self.status(),
                    icon = self.icon();

                for (i = 0; i < 3; i++) {
                    status.toggleClass(self.statuses[i], state == i);
                    icon.toggleClass(self.icons[i], state == i);
                }
            }
        }
    });

    module.resolve();
});

EasySocial.module( 'admin/reports/reporters' , function($) {

	var module = this;

	EasySocial.Controller(
		'Reports.Reporters',
		{
			defaultOptions : 
			{
				"{item}"		: "[data-reporters-item]"
			}
		},
		function( self )
		{
			return {
				init : function()
				{
					self.item().implement( EasySocial.Controller.Reports.Reporters.Item ,
						{
							"{parent}"	: self
						});
				}
			}
		}
	);

	EasySocial.Controller(
		'Reports.Reporters.Item',
		{
			defaultOptions :
			{
				"{removeItem}"	: "[data-remove-item]"			
			}
		},
		function( self )
		{
			return {
				init : function()
				{
					self.options.id 	= self.element.data( 'id' );
				},

				"{removeItem} click" : function()
				{
					// Remove any messages.
					self.parent.clearMessage();

					EasySocial.ajax( 'admin/controllers/reports/removeItem' ,
					{
						"id"	: self.options.id
					})
					.done(function( result )
					{
						self.parent.setMessage( result.message , result.type );

						self.element.remove();
					});
					
				}
			}
		}
	);

	module.resolve();

});
EasySocial.module( 'admin/reports/reports' , function($) {

	var module = this;

	EasySocial
	.require()
	.language( 
		'COM_EASYSOCIAL_CANCEL_BUTTON',
		'COM_EASYSOCIAL_CLOSE_BUTTON',
		'COM_EASYSOCIAL_REPORTS_VIEW_REPORTS_DIALOG_TITLE',
		'COM_EASYSOCIAL_REPORTS_ACTIONS_DIALOG_TITLE'
	)
	.done( function($)
	{

		EasySocial.Controller(
			'Reports',
			{
				defaultOptions : 
				{
					"{item}"		: "[data-reports-item]"
				}
			},
			function( self )
			{
				return {
					init : function()
					{
						self.item().implement( EasySocial.Controller.Reports.Item )
					}
				}
			});

		EasySocial.Controller(
			'Reports.Item',
			{
				defaultOptions :
				{
					"{action}"		: "[data-reports-item-view-actions]",
					"{viewReports}"	: "[data-reports-item-view-reports]"
				}
			},
			function( self )
			{
				return {
					init : function()
					{
						self.options.id 		= self.element.data( 'id' );
						self.options.extension	= self.element.data( 'extension' );
						self.options.uid 		= self.element.data( 'uid' );
						self.options.type 		= self.element.data( 'type' );
					},

					"{viewReports} click" : function()
					{

						EasySocial.dialog(
						{
							title 		: $.language( 'COM_EASYSOCIAL_REPORTS_VIEW_REPORTS_DIALOG_TITLE' ),
							content 	: EasySocial.ajax( 'admin/controllers/reports/getReporters' , 
											{ 
												id 			: self.options.id
											}),
							width 		: 600,
							height 		: 450
						});

					},

					"{action} click" : function()
					{
						EasySocial.dialog( 
						{
							title 		: $.language( 'COM_EASYSOCIAL_REPORTS_ACTIONS_DIALOG_TITLE' ),
							content		: '<div>Perform some actions on the item</div>',
							width 		: 500,
							height 		: 250,
							buttons 	: 
							[
								{
									name 		: $.language( 'COM_EASYSOCIAL_CLOSE_BUTTON' ),
									classNames	: "btn btn-es",
									click 		: function()
									{
										EasySocial.dialog().close();
									}
								}
							]
						})
					}
				}
			})

		module.resolve();
	});

});
EasySocial.module("admin/themes/compiler", function($){

var module = this;

// TODO: Move this away
$.fn.at = function(key) {
	return this.find("[data-" + key.replace(/([a-z])([A-Z])/g, '$1-$2').toLowerCase() + "]");
}

$.template("easysocial/compiler/detail", '<tr class="[%= type %]"><td>[%= timestamp %]</td><td width="100%">[%= message %]</td></tr>');

EasySocial.Controller("Themes.Compiler", {

	defaultOptions: {

		view: {
			detail: "compiler/detail"
		},

		"{section}": "[data-section]",

		"{compileButton}"     : "[data-compile-button]",
		"{minifyButton}"      : "[data-minify-button]",
		"{buildButton}"       : "[data-build-button]",
		"{filesButton}"       : "[data-files-button]",
		"{purgeButton}"       : "[data-purge-button]",
		"{resetButton}"       : "[data-reset-button]",
		"{forceCompileButton}": "[data-force-compile-button]",
		"{clearLogButton}"    : "[data-clear-log-button]",
		"{toggleLogButton}"   : "[data-toggle-log-button]",

		"{refreshButton}": "[data-refresh-button]",
		"{refreshSectionButton}": "[data-refresh-section-button]",
		"{buildWithoutMinifyButton}": "[data-build-without-minify-button]",

		"{log}"        : "[data-log]",
		"{details}"    : "[data-details]",
		"{status}"     : "[data-status]",
		"{imports}"    : "[data-imports]",

		"{progress}"      : "[data-progress]",
		"{progressBar}"   : "[data-progress-bar]",
		"{progressStatus}": "[data-progress-status]",

		"{tabItem}": ".tab-item"
	}
},
function(self, opts, base) { return {

	init: function() {

		self.location = base.data("location");
		self.name     = base.data("name");
		self.override = base.data("override");
	},

	sections: function() {

		var sections =
			$.map(self.section(), function(section) {

				var name = $(section).data("sectionName"),
					id   = self.sectionId(name);

				return {id: id, name: name};
			});

		return sections;
	},

	sectionId: function(sectionName) {

		return self.location + '-' + self.name + '-' + sectionName;
	},

	sectionTab: function(sectionName) {

		return self.tabItem({"sectionId": self.sectionId(sectionName)}).find("> a");
	},

	sectionNameOf: function(el) {

		var section = self.section.of(el),
			sectionName = section.data("sectionName");

		return sectionName;
	},

	getLog: function(sectionName) {

		if (sectionName) return self.section({"sectionName": sectionName}).at("log");
		return self.log(":first");
	},

	addLog: function(detail, sectionName) {

		var log = self.getLog(sectionName),
			body = log.find("tbody");

		// Normalize arguments
		if ($.isString(detail)) {
			detail = {
				timestamp: new Date(),
				message: detail,
				type: "info"
			}
		}

		// Type
		var type = detail.type;
		if (/warning|warn/.test(type)) type = 'warning';
		if (/danger|error|failed|fail/.test(type)) type = 'danger';
		if (/pending|default|primary/.test(type)) type = '';

		// Timestamp
		var timestamp = detail.timestamp,
			date = (timestamp instanceof Date) ? timestamp : new Date(parseFloat(timestamp));

		// Convert timestamp to h:i:s
		timestamp = date.getHours() + ':' + date.getMinutes() + ":" + date.getSeconds();

		// Message
		var message = detail.message;

		self.view.detail({
				type: type,
				timestamp: timestamp,
				message: message
			})
			.appendTo(body);

		body[0].scrollTop = body[0].scrollHeight;
	},

	appendLog: function(details, sectionName) {

		$.each(details, function(key, detail){
			self.addLog(detail, sectionName);
		});
	},

	clearLog: function(sectionName) {

		var log = self.getLog(sectionName),
			body = log.find("tbody");

		body.empty();

		log.at("timeTotal").data("value", 0).html("0s");
		log.at("memoryUsage").data("value", 0).html("0mb");
	},

	generateLog: function(task, sectionName) {

		self.clearLog(sectionName);

		self.appendLog(task.details, sectionName);

		var log = self.getLog(sectionName),
			timeTotalValue = parseFloat(task.time_total),
			timeTotalText  = timeTotalValue.toFixed(2) + 's',
			memoryUsageValue = parseInt(task.mem_peak),
			memoryUsageText  = (memoryUsageValue / 1024 / 1024).toFixed(2) + 'mb';

		log.at("timeTotal")
			.data("value", timeTotalValue)
			.html(timeTotalText);

		log.at("memoryUsage")
			.data("value", memoryUsageValue)
			.html(memoryUsageText);

		self.addLog({
			type: (task.failed) ? "danger" : "success",
			timestamp: task.time_end,
			message: (task.failed) ? "Task failed." : "Task completed.",
		}, sectionName);
	},

	updateLog: function(task, sectionName) {

		var log = self.getLog(sectionName),
			timeTotal = log.at("timeTotal"),
			memoryUsage = log.at("memoryUsage");

		// Append log
		self.appendLog(task.details, sectionName);

		// Refactor this. Copied code from above.
		var timeTotalValue = timeTotal.data("value") + parseFloat(task.time_total),
			timeTotalText  = timeTotalValue.toFixed(2) + 's',
			memoryUsageValue = Math.max(memoryUsage.data("value"), parseInt(task.mem_peak)),
			memoryUsageText  = (memoryUsageValue / 1024 / 1024).toFixed(2) + 'mb';

		timeTotal
			.data("value", timeTotalValue)
			.html(timeTotalText);

		memoryUsage
			.data("value", memoryUsageValue)
			.html(memoryUsageText);
	},

	perform: function(task, options) {

		return EasySocial.ajax(
				"admin/controllers/themes/" + task,
				$.extend({
					location: self.location,
					name: self.name,
					override: self.override
				}, options));
	},

	build: function(preset) {

		var sections = self.sections(),

			preset = preset || 'cache',

			minify = (preset=='cache'),

			// To determine when to stop running tasks
			i = 0,
			length = sections.length - 1,

			// To determine progress bar width
			current = i + 1,
			total = ((length + 1) * (minify ? 2 : 1)) + 1, // one more for building
			max = 100,

			// To determine if there was a failure
			failed = false,

			log = self.log(":first"),

			progress       = self.progress(":first"),
			progressBar    = self.progressBar(":first"),
			progressStatus = self.progressStatus(":first"),

			updateProgress = function() {

				current++;

				// Update progress bar
				progressValue = current / total * max;
				progressBar.show().width(progressValue + "%");
			},

			run = function() {

				var section     = sections[i],
					sectionId   = section.id,
					sectionName = section.name,
					sectionTab  = self.sectionTab(sectionName);

				// Message
				var message = "Compiling section '" + sectionName + "'.";

				// Update progress bar
				updateProgress();

				// Update compile status
				progressStatus.html(message);

				// Show section tab content
				sectionTab.tab("show");

				self.compile(sectionName, {force: true})
					.done(function(data){
						self.updateLog(data.task);
					})
					.fail(function(data){
						self.updateLog(data.task);
						failed = true;
					})
					.always(function(){

						if (!minify) {
							nextSection();
						} else {

							// Message
							var message = "Minifying section '" + sectionName + "'.";

							// Update progress bar
							updateProgress();

							// Update compile status
							progressStatus.html(message);

							self.minify(sectionName)
								.done(function(data){
									self.updateLog(data.task);
								})
								.fail(function(data){
									self.updateLog(data.task);
									failed = true;
								})
								.always(function(){
									nextSection();
								});
						}
					});
			},

			nextSection = function() {

				// Compile next section
				if (length > i++) return run();

				// If all sections have been compiled, build.
				build();
			},

			build = function() {

				progressStatus.html("Building stylesheets.");
				updateProgress();

				var task;

				self.perform("build", {preset: preset})
					.done(function(data){
						self.status(":first").replaceWith(data.status);
						task = data.task;
					})
					.fail(function(data){
						task = data.task;
					})
					.always(function(){

						// Fallback pseudo task object.
						if (!task) {
							task = {
								failed: true,
								details: [],
								time_end: new Date()
							};
						}

						// Update log
						self.updateLog(task);

						self.addLog({
							type: (task.failed) ? "danger" : "success",
							timestamp: task.time_end,
							message: (task.failed) ? "Build failed." : "Build completed.",
						});

						progressStatus.html("Build completed!");
						progressBar.width("100%");

						// Hide compiler progress
						base.removeClass("is-busy");
					});
			};

		// Reset progress bar
		progressBar.hide().width("0%");

		// Show compiler progress
		base.addClass("is-busy");

		// Log
		self.clearLog();

		if (sections.length > 0) {
			self.addLog("Compiling all sections.");
			// Compile section
			run();
		} else {
			build();
		}
	},

	minify: function(sectionName, options) {

		var task = self.perform("minify", $.extend({section: sectionName}, options));

		self.trigger("minify", [sectionName, task]);

		return task;
	},

	"{self} minify": function(base, event, sectionName, task) {

		var section = self.section({"sectionName": sectionName}),
			progressStatus = section.at("progressStatus"),
			progressBar = section.at("progressBar"),
			message = "Minifying section '" + sectionName + "'.";

		// Progress bar
		section.addClass("is-busy");
		progressStatus.html(message);
		progressBar.hide().width("0%").show().width("100%");

		// Log
		// self.clearLog(sectionName);
		// self.addLog(message, sectionName);

		task
			.done(function(data){

				// Update imports & status html
				section.at("imports").replaceWith(data.imports);
				section.at("status").replaceWith(data.status);

				// Generate log
				self.appendLog(data.task.details, sectionName);

				self.addLog({
					type: (task.failed) ? "danger" : "success",
					timestamp: data.task.time_end,
					message: (task.failed) ? "Task failed." : "Task completed.",
				}, sectionName);
			})
			.always(function(){
				section.removeClass("is-busy");
			});
	},

	compile: function(sectionName, options) {

		var task = self.perform("compile", $.extend({section: sectionName}, options));

		self.trigger("compile", [sectionName, task]);

		return task;
	},

	"{self} compile": function(base, event, sectionName, task) {

		var section = self.section({"sectionName": sectionName}),
			progressStatus = section.at("progressStatus"),
			progressBar = section.at("progressBar"),
			message = "Compiling section '" + sectionName + "'.";

		// Progress bar
		section.addClass("is-busy");
		progressStatus.html(message);
		progressBar.hide().width("0%").show().width("100%");

		// Log
		self.clearLog(sectionName);
		self.addLog(message, sectionName);

		task
			.done(function(data){

				// Update imports & status html
				section.at("imports").replaceWith(data.imports);
				section.at("status").replaceWith(data.status);

				// Generate log
				self.generateLog(data.task, sectionName);
			})
			.fail(function(data){

				// Generate log
				self.generateLog(data.task, sectionName);
			})
			.always(function(){

				section.removeClass("is-busy");
			});
	},

	purge: function() {

		var progress       = self.progress(":first"),
			progressBar    = self.progressBar(":first"),
			progressStatus = self.progressStatus(":first");

		base.addClass("is-busy");

		self.clearLog();

		progressBar.hide().width("0%").show().width("100%");
		progressStatus.html("Purging cache and log files.");

		self.perform("purge")
			.done(function(task){

				self.generateLog(task);
			})
			.fail(function(task){

			})
			.always(function(){
				base.removeClass("is-busy");
			});
	},

	"{buildButton} click": function(buildButton) {

		self.build('cache');
	},

	"{buildWithoutMinifyButton} click": function() {

		self.build('development');
	},

	"{compileAllButton} click": function(compilceAllButton) {

		// self.compileAllSections();
	},

	"{compileButton} click": function(compileButton) {

		var sectionName = self.sectionNameOf(compileButton);
		return self.compile(sectionName);
	},

	"{forceCompileButton} click": function(forceCompileButton) {

		var sectionName = self.sectionNameOf(forceCompileButton);
		return self.compile(sectionName, {force: true});
	},

	"{minifyButton} click": function(minifyButton) {

		var sectionName = self.sectionNameOf(minifyButton);
		return self.minify(sectionName);
	},

	"{refreshButton} click": function() {

		// Show loading indicator
		base.addClass("is-busy");

		// Show indefinite progress bar
		self.progressBar(":first").show().width("100%");

		// Update status text
		self.progressStatus(":first").html("Refreshing");

		EasySocial.ajax("admin/views/themes/compiler",
		{
			location: self.location,
			name: self.name,
			override: self.override
		})
		.done(function(html){

			base.replaceWith(html);
		})
		.fail(function(){
			alert("Unable to refresh section.");
		})
		.always(function(){
			base.removeClass("is-busy");
		});
	},

	"{refreshSectionButton} click": function(refreshSectionButton) {

		var sectionName = self.sectionNameOf(refreshSectionButton),
			section = self.section({"sectionName": sectionName});

		// Show loading indicator
		section.addClass("is-busy");

		// Update status text
		section.at("progressStatus").html("Refreshing");

		EasySocial.ajax("admin/views/themes/section",
		{
			location: self.location,
			name: self.name,
			override: self.override,
			section: sectionName
		})
		.done(function(html){
			section.html(html);
		})
		.fail(function(){
			// TODO: Nicer alert.
			alert("Unable to refresh section.");
		})
		.always(function(){
			section.removeClass("is-busy");
		});
	},

	"{resetButton} click": function() {

		alert("TODO: Restore to factory default.");
	},

	"{purgeButton} click": function() {

		self.purge();
	}
}});

module.resolve();

});
EasySocial.module( 'admin/users/form' , function($) {

	var module = this;

	EasySocial.require()
	.script('field')
	.done(function($)
	{
		EasySocial.Controller(
		'Users.Form',
		{
			defaultOptions:
			{
				userid				: null,

				mode				: 'adminedit',

				"{selectProfile}"	: "[data-user-select-profile]",
				"{content}"			: "[data-user-new-content]",
				"{profileTitle}"	: "[data-profile-title]",

				"{fieldItem}"		: "[data-profile-adminedit-fields-item]",

				"{tabnav}"			: "[data-tabnav]",
				"{tabcontent}"		: "[data-tabcontent]",

				"{stepnav}"			: "[data-stepnav]",
				"{stepcontent}"		: "[data-stepcontent]",

				view:
				{
					loading : "site/loading/large"
				}
			}
		},
		function( self )
		{
			return {

				init : function()
				{
					window.selectedProfile 	= self.selectedProfile;

					self.fieldItem().addController('EasySocial.Controller.Field.Base', {
						userid: self.options.userid,
						mode: self.options.mode
					});
				},

				selectedProfile : function( profileId )
				{
					EasySocial.dialog().close();

					window.location.href	= 'index.php?option=com_easysocial&view=users&layout=form&profileId=' + profileId;
				},

				"{selectProfile} click" : function()
				{
					EasySocial.dialog(
					{
						content 	: EasySocial.ajax( 'admin/views/profiles/browse' )
					});
				},

				errorFields: [],

				'{fieldItem} error': function(el, ev) {
					var id = el.data('id');

					if($.inArray(id, self.errorFields) < 0) {
						self.errorFields.push(id);
					}

					var stepid = el.parents(self.stepcontent.selector).data('for');

					self.stepnav().filterBy('for', stepid).trigger('error');

					var tabid = el.parents(self.tabcontent.selector).data('for');

					self.tabnav().filterBy('for', tabid).trigger('error');
				},

				'{fieldItem} clear': function(el, ev) {
					var fieldid = el.data('id');

					self.errorFields = $.without(self.errorFields, fieldid);

					var stepid = el.parents(self.stepcontent.selector).data('for');

					self.stepnav().filterBy('for', stepid).trigger('clear');

					var tabid = el.parents(self.tabcontent.selector).data('for');

					self.tabnav().filterBy('for', tabid).trigger('clear');
				},

				'{stepnav} error': function(el) {
					el.addClass('error');
				},

				'{tabnav} error': function(el) {
					el.addClass('error');
				},

				'{stepnav} clear': function(el) {
					if(self.errorFields.length < 1) {
						el.removeClass('error');
					}
				},

				'{tabnav} clear': function(el) {
					if(self.errorFields.length < 1) {
						el.removeClass('error');
					}
				},

				'{stepnav} click': function(el) {
					var id = el.data('for');

					self.stepcontent().filterBy('for', id).find(self.fieldItem.selector).trigger('show');
				}
			}
		});

		module.resolve();
	});

});

EasySocial.module( 'admin/users/privacy' , function($){

	var module 	= this;

	EasySocial.require()
	.library( 'textboxlist' )
	.view( 'site/loading/small' )
	.done(function($){

		EasySocial.Controller(
			'Profile.Privacy',
			{
				defaultOptions:
				{
					userId	: '',

					"{privacyItem}" : "[data-privacy-item]",

					//input form
					"{privacyForm}" : "[data-profile-privacy-form]",

					view :
					{
						loading : "site/loading/small"
					}
				}
			},
			function( self )
			{
				return {

					init : function()
					{
						self.privacyItem().implement( EasySocial.Controller.Profile.Privacy.Item ,
						{
							"{parent}"	: self
						});
					}
				}
			}
		);


		EasySocial.Controller(
			'Profile.Privacy.Item',
			{
				defaultOptions :
				{
					"{selection}"		: "[data-privacy-select]",
					"{hiddenCustom}" 	: "[data-hidden-custom]",
					"{customForm}" 		: "[data-privacy-custom-form]",

					"{customTextInput}" : "[data-textfield]",
					"{customItems}"		: "input[]",
					"{customHideBtn}"	: "[data-privacy-custom-hide-button]",
					"{customInputItem}"	: "[data-textboxlist-item]",
					"{customEditBtn}"   : "[data-privacy-custom-edit-button]"
				}
			},
			function( self )
			{
				return {
					init : function()
					{
						self.customTextInput().textboxlist(
							{
								component: 'es',
								unique: true,

								plugin: {
									autocomplete: {
										exclusive: true,
										minLength: 2,
										cache: false,
										query: function( keyword ) {

											var users = self.getTaggedUsers();

											var ajax = EasySocial.ajax("site/views/privacy/getfriends",
												{
													q: keyword,
													userid: self.parent.options.userId,
													exclude: users
												});
											return ajax;
										}
									}
								}
							}
						);

						self.textboxlistLib = self.customTextInput().textboxlist("controller");
					},

					getTaggedUsers: function()
					{
						var users = [];
						var items = self.customInputItem();

						if( items.length > 0 )
						{
							$.each( items, function( idx, element ) {
								users.push( $( element ).data('id') );
							});
						}

						return users;
					},

					// event listener for adding new name
					"{customTextInput} addItem": function(el, event, data) {

						// lets get the exiting ids string
						var ids    = self.hiddenCustom().val();
						var values = '';

						if( ids == '')
						{
							values = data.id;
						}
						else
						{
							var idsArr = ids.split(',');
							idsArr.push( data.id );

							values = idsArr.join(',');
						}

						//now update the customhidden value.
						self.hiddenCustom().val( values );
					},

					// event listener for removing name
					"{customTextInput} removeItem": function(el, event, data ) {
						// lets get the exiting ids string
						var ids    = self.hiddenCustom().val();
						var values = '';
						var newIds = [];

						var idsArr = ids.split(',');

						for( var i = 0; i < idsArr.length; i++ )
						{
							if( idsArr[i] != data.id )
							{
								newIds.push( idsArr[i] );
							}
						}

						if( newIds.length <= 0 )
						{
							values = '';
						}
						else
						{
							values = newIds.join(',');
						}

						//now update the customhidden value.
						self.hiddenCustom().val( values );
					},

					"{customEditBtn} click" : function( el )
					{
						self.customForm().toggle();
					},

					"{selection} change" : function( el )
					{
						var selected = el.val();

						if( selected == 'custom' )
						{
							self.customForm().show();
							self.customEditBtn().show();
						}
						else
						{
							self.customForm().hide();
							self.customEditBtn().hide();
						}

						return;
					},

					"{customHideBtn} click" : function()
					{
						self.customForm().hide();
						self.customEditBtn().show();

						self.textboxlistLib.autocomplete.hide();

						return;
					}
				}
			});


		module.resolve();
	});

});

EasySocial.module( 'admin/users/users' , function($) {

	var module = this;

	EasySocial
	.require()
	.library( 'expanding' )
	.done( function($)
	{

		EasySocial.Controller(
			'Users',
			{
				defaultOptions : 
				{
					"{item}"	: "[data-user-item]"
				}
			},
			function( self )
			{
				return {
					init : function()
					{
						self.item().implement( EasySocial.Controller.Users.Item );
					}
				}
			});

		EasySocial.Controller(
			'Users.Item',
			{
				defaultOptions : 
				{
					"{insertLink}"	: "[data-user-item-insertLink]"
				}
			},
			function( self )
			{
				return {
					init : function()
					{
						self.options.name 	= self.element.data( 'name' );
						self.options.avatar	= self.element.data( 'avatar' );
						self.options.email	= self.element.data( 'email' );
						self.options.id 	= self.element.data( 'id' );
					},

					"{insertLink} click" : function()
					{
						self.trigger( 'userSelected' , [ self.options.id , self.options.name , self.options.avatar , self.options.email ] );
					}
				}
			});


		EasySocial.Controller(
			'Users.Pending',
			{
				defaultOptions : 
				{
					"{item}"	: "[data-pending-item]"
				}
			},
			function( self )
			{
				return {
					init : function()
					{
						self.item().implement( EasySocial.Controller.Users.Pending.Item );
					}
				}
			});


		EasySocial.Controller(
			'Users.Pending.Item',
			{
				defaultOptions : 
				{
					"{approve}" : "[data-pending-approve]",
					"{reject}"	: "[data-pending-reject]"
				}
			},
			function( self )
			{
				return {
					init : function()
					{
						self.options.id 	= self.element.data( 'id' );
					},

					"{approve} click" : function()
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'admin/views/users/confirmApprove' , { "id" : self.options.id } ),
							bindings 	:
							{
								"{approveButton} click" : function()
								{
									$( '[data-users-approve-form]' ).submit();
								}
							}
						});
					},

					"{reject} click" : function()
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'admin/views/users/confirmReject' , { "id" : self.options.id } )
						});

					}
				}
			})		
		module.resolve();

	});

});
EasySocial.module( 'admin/widgets/news' , function($) {

	var module = this;

	EasySocial.require()
	.done(function($){

		EasySocial.Controller(
				'News',
				{
					defaultOptions: 
					{
						
						// Properties
						loadOnInit 	: true,

						// Elements
						"{news}"		: "[data-widget-news] > [data-widget-news-items]",
						"{appNews}"		: "[data-widget-app-news] > [data-widget-news-items]",
						"{placeholder}"	: "[data-widget-news-placeholder]"
					}
				},
				function( self ){

					return {

						init: function()
						{
							// When page loads, obtain the news
							if( self.options.loadOnInit )
							{
								self.getNews();
							}
						},

						/**
						 * Gets the news items from the server.
						 */
						getNews: function()
						{
							EasySocial.ajax( 'admin/controllers/news/getnews' )
							.done(function( content , appsContent )
							{
								// Append the news.
								self.news().append( content );

								// Append the app news
								self.appNews().append( appsContent );

								// Hide placeholder
								self.placeholder().remove();
							});
						}
					}
				}
		);
	
		module.resolve();
	});

});

EasySocial.module("albums/album", function($){

	var module = this;

	EasySocial.require()
		.library(
			"tinyscrollbar"
		)
		.done(function(){

			EasySocial.Controller("Albums.Album",
			{
				defaultOptions: {
					"{title}"        : "[data-album-title]",
					"{count}"        : "[data-album-count]",
					"{privacy}"      : "[data-album-privacy]",
					"{cover}"        : "[data-album-cover]",
					"{coverImage}"   : "[data-album-cover-image]",
					"{link}"         : "[data-album-link]",
					"{menu}"         : "[data-album-menu]",
					"{menuActions}"  : "[data-album-menu-actions]",
					"{shareButton}"  : "[data-album-share-button]",
					"{shareContent}" : "[data-sharing]",
					"{followButton}" : "[data-album-follow-button]",
					"{reportButton}" : "[data-album-report-button]",
					"{deleteButton}" : "[data-album-delete-button]",

					"{likeButton}"        : "[data-album-like-button]",
					"{commentButton}"     : "[data-album-comment-button]",

					"{countsButton}"      : "[data-album-counts-button]",
					"{commentCount}"      : "[data-album-comment-count]",
					"{likeCount}"         : "[data-album-like-count]",

					"{actions}"           : "[data-item-actions]",
					"{actionContent}"     : "[data-item-action-content]",
					"{actionCloseButton}" : "[data-item-action-close-button]",
					"{actionsMenu}"       : "[data-item-actions-menu]",

					"{likesHolder}"       : "[data-album-likes-holder]",
					"{commentsHolder}"    : "[data-album-comments-holder]",
					"{responseHolder}"    : "[data-album-response-holder]",

					"{comments}": "[data-comments]"
				}
			},
			function(self) { return {

				init: function()
				{
					self.id = self.element.data("album-id");

					self.actionContent()
						.tinyscrollbar();

					if (self.actions().hasClass("open")) {
						self.loadResponse();
						self.element.addClass("show-all");
					}
				},

				remove: function()
				{
					self.element.remove();
				},

				"{coverImage} click": function() {

					window.location = self.link().attr("href");
				},

				"{shareButton} click": function()
				{
					self.shareContent().show();
				},

				"{deleteButton} click": function()
				{
					EasySocial.dialog(
					{
						content: EasySocial.ajax( "site/views/albums/confirmDelete", { id: self.id })
					});
				},

				like: function() {

					EasySocial.ajax(
						"site/controllers/albums/like",
						{
							id: self.id
						}
					)
					.done(function(like) {

						// TODO: Update like count
						self.likeCount().html( like.count );

						// TODO: Change like text
						if( like.state )
						{
							self.likeButton().addClass( "liked" );
						}
						else
						{
							self.likeButton().removeClass("liked");
						}

						// TODO: Update like summary
						self.likesHolder().html( like.html );

						// To determine whether or not to like or unlike
						// self.likeButton().hasClass("liked")
					});
				},

				loadResponse: function() {

					var loader = self.loadResponse.loader;

					if (!loader || loader.state()=="rejected") {

						self.loadResponse.loader =
							EasySocial.ajax(
								"site/views/albums/response",
								{
									id: self.id
								}
							)
							.done(function(html) {

								self.responseHolder().html(html);

								self.actionContent()
									.removeClass("loading")
									.tinyscrollbar_update();
							});
					}
				},

				getButton: function(toggle) {

					var toggle = $(toggle),
						countsButton = self.countsButton(),
						commentButton = self.commentButton();

						if (toggle.is(countsButton) ||
							toggle.parents().filter(countsButton).length > 0) {
							return countsButton;
						}

						if (toggle.is(commentButton) ||
							toggle.parents().filter(commentButton).length > 0)
							return commentButton;

						return $();
				},

				lastButton: $(),

				"{actions} shown.bs.dropdown": function(actions, event, toggle) {

					// Show likes & comments
					self.loadResponse();

					// Make dropdown persistent even when hovered away
					self.element
						.addClass("show-all");

					var actionContent = self.actionContent(),
						button = self.lastButton = self.getButton(toggle),
						offset = (button.position().left + (button.width() / 2)) - (actionContent.width() / 2);

						actionContent
							.css("margin-left", offset)
							.tinyscrollbar_update();
				},

				"{actions} hide.bs.dropdown": function(actions, event, toggle) {

					self.element.removeClass("show-all");

					var button = self.getButton(toggle),
						lastButton = self.lastButton;

					if (!button.is(lastButton)) {
						setTimeout(function(){button.trigger("click")}, 0);
					}
				},

				"{actionCloseButton} click": function(el) {

					self.hideActionContent();
				},

				"{likeButton} click": function() {
					self.like();
				},

				"{comments} newCommentSaved": function() {

					var stat = self.comments().controller("EasySocial.Controller.Comments.Stat");
					self.commentCount().html(stat.total());

					self.actionContent()
						.tinyscrollbar_update("bottom");
				},

				"{comments} commentDeleted": function() {

					var stat = self.comments().controller("EasySocial.Controller.Comments.Stat");
					self.commentCount().html(stat.total());

					self.actionContent()
						.tinyscrollbar_update();
				},

				"{actionsMenu} shown.bs.dropdown": function() {
					self.element.addClass("show-all");
				},

				"{actionsMenu} hidden.bs.dropdown": function() {
					self.element.removeClass("show-all");
				}

			}});

			module.resolve();

		});
});


EasySocial.module("albums/browser", function($){

	var module = this;

	EasySocial.require()
		.library(
			"history"
		)
		.view(
			"site/albums/browser.list.item"
		)
		.done(function(){

			EasySocial.Controller("Albums.Browser",
			{
				hostname: "browser",

				defaultOptions: {

					view: {
						listItem: "site/albums/browser.list.item"
					},

					itemRenderOptions: {},

					"{sidebar}": "[data-album-browser-sidebar]",
					"{content}": "[data-album-browser-content]",

					"{createAlbumButton}"    : "[data-album-create-button]",
					"{createAlbumButtonLink}": "[data-album-create-button] > a",

					"{listItemGroup}": "[data-album-list-item-group]",
					"{listItemRegularGroup}": "[data-album-list-item-group=regular]",
					"{listItemCoreGroup}": "[data-album-list-item-group=core]",

					"{listItem}"     : "[data-album-list-item]",
					"{listItemLink}" : "[data-album-list-item] > a",
					"{listItemTitle}": "[data-album-list-item-title]",
					"{listItemCover}": "[data-album-list-item-cover]",
					"{listItemCount}": "[data-album-list-item-count]",

					"{albumItem}": "[data-album-item]",

					"{photoBrowser}": "[data-photo-browser]"
				}
			},
			function(self) { return {

				init: function() {

					// Attach existing album items as subscriber
					self.albumItem().each(function(){
						self.addSubscriber($(this).controller("EasySocial.Controller.Albums.Item"));
					})
				},

				setLayout: function(layout) {

					// Don't switch layout on dialog.
					if (self.element.hasClass("layout-dialog")) return;

					self.element
						.data("layout", layout)
						.switchClass("layout-" + layout);
				},

				open: function(view) {

					var args = $.makeArray(arguments);

					self.trigger("contentload", args);

					var method = "view" + $.String.capitalize(view),
						loader = self[method].apply(self, args.slice(1));

					loader
						.done(self.displayContent(function(){
							self.trigger("contentdisplay", args);
							return arguments;
						}))
						.fail(function(){
							self.trigger("contentfail", args);
						})
						.always(function(){
							self.trigger("contentcomplete", args);
						});

					return loader;
				},

				"{self} contentdisplay": function(el, event, view) {

					if (/album|albumform/gi.test(view)) {
						self.setLayout("album");
					}

					if (/photo/gi.test(view)) {
						self.setLayout("photo");
					}
				},

				displayContent: $.Enqueue(function(html){

					var scripts = [],
						content = $($.buildFragment([html], document, scripts));

					// Insert content
					self.content().html(content);

					// Remove scripts
					$(scripts).remove();
				}),

				viewAlbum: function(albumId) {

					// Remove loading indicator from any existing ones
					self.listItem().removeClass("active loading");

					var listItem =
						self.getListItem(albumId)
							.addClass("active loading");

					// Don't route if we're on dialog layout
					if (self.element.data("layout")!=="dialog") {
						listItem.find("> a").route();
					}

					var loader =
						EasySocial.ajax(
							"site/views/albums/item",
							{
								id: albumId,
								renderOptions: self.options.itemRenderOptions
							})
							.fail(function(){

							})
							.always(function(){

								listItem.removeClass("loading");
							});

					return loader;
				},

				viewAlbumForm: function()
				{

					// Remove loading indicator from any existing ones
					var listItems = self.listItem().removeClass("active loading"),
						listItem =
							self.view.listItem({})
								.addClass("active loading new")
								.prependTo(self.listItemRegularGroup());


					var loader = EasySocial.ajax( "site/views/albums/form" ,
									{
										"uid"	: self.options.uid,
										"type"	: self.options.type
									})
									.fail(function(){

									})
									.always(function(){

										listItem.removeClass("loading");
									});

					return loader;
				},

				viewPhoto: function(photoId) {

					var loader =
						EasySocial.ajax(
							"site/views/photos/item",
							{
								id: photoId,
								browser: 1
							})
							.fail(function(){
							})
							.always(function(){
							});

					return loader;
				},

				"{listItem} click": function(listItem) {

					// Don't do anything on new album item
					if (listItem.hasClass("new")) return;

					var albumId = listItem.data("albumId");

					// Load album
					self.open("Album", albumId);
				},

				"{listItemLink} click": function(listItemLink, event) {

					// Progressive enhancement, no longer refresh the page.
					event.preventDefault();

					// Prevent item from getting into :focus state
					listItemLink.blur();
				},

				"{createAlbumButton} click": function() {

					self.open("AlbumForm");

					// Don't route if we're on dialog layout
					if (self.element.data("layout")!=="dialog") {

						self.createAlbumButtonLink().route();
					}
				},

				"{createAlbumButtonLink} click": function(el, event) {

					event.preventDefault();
				},

				"{albumItem} init.albums.item": function(el, event, albumItem) {

					self.addSubscriber(albumItem);
				},

				getListItem: function(albumId, context) {

					var listItem =
						(!albumId) ?
							self.listItem(".new") :
							self.listItem().filterBy("albumId", albumId);

					if (!context) return listItem;

					return listItem.find(self["listItem" + $.String.capitalize(context)].selector);
				},

				updateListItemCount: function(albumId, val, append) {

					var stat = self.getListItem(albumId, "count");

					// If no stat element found, stop.
					if (stat.length < 0) return;

					// Get current stat count
					var statCount;

					if (append) {
						statCount = (parseInt(stat.text()) || 0) + (parseInt(val) || 0);
					} else {
						statCount = val;
					}

					// Always stays at 0 if less than that
					if (statCount < 0) statCount = 0;

					// Update stat count
					stat.text(statCount);
				},

				"{albumItem} albumSave": function(el, event, task)
				{
					task.done(function(album)
					{
						// For new albums
						// Remove item link's new state
						self.getListItem()
							.attr("data-album-id", album.id)
							.removeClass("new")

						// Update item link & route url
						self.getListItem(album.id)
							.find("> a")
							.attr({
								href : album.permalink,
								title: album.title
							})
							.route();

						// For existing albums
						self.getListItem(album.id, "title")
							.html(album.title);
					});
				},

				"{albumItem} titleChange": function(el, event, title, album) {

					self.getListItem(album.id, "title")
						.html($.trim(title) || "&nbsp;");
				},

				"{albumItem} coverChange": function(el, event, photo, album) {

					self.getListItem(album.id, "cover")
						.css("backgroundImage", $.cssUrl(photo.sizes.thumbnail.url));
				},

				"{albumItem} coverRemove": function(el, event, album) {

					self.getListItem(album.id, "cover")
						.css("backgroundImage", "");
				},

				"{albumItem} photoAdd": function(el, event, photoItem, photoData, album) {

					self.updateListItemCount(album.id, 1, true);
				},

				"{albumItem} photoMove": function(el, event, task, photo) {

					task
						.done(function(){
							self.updateListItemCount(photo.album.id, -1, true);
						});
				},

				"{albumItem} photoDelete": function(el, event, task, photo) {

					task
						.done(function(){
							self.updateListItemCount(photo.album.id, -1, true);
						});
				},

				"{photoBrowser} init.photos.browser": function(el, event, photoBrowser) {

					// Attach browser to photo browser
					self.addSubscriber(photoBrowser);
				},

				"{self} contentload": function() {

					// Remove any new item because there can only be one
					self.listItem(".new").remove();
				}

			}});

			module.resolve();

		});
});
EasySocial.module("albums/editor", function($){

	var module = this;

	// Constants
	var photoEditorController = "EasySocial.Controller.Photos.Editor"

	// Non-essential dependencies
	EasySocial.require()
		.script(
			"albums/editor/sortable",
			"albums/editor/uploader"
		)
		.done();

	// Essential dependencies
	var Controller =

	EasySocial.Controller("Albums.Editor",
	{
		hostname: "editor",

		defaultOptions: {

			view: {
		        uploadItem: "site/albums/upload.item"
			},

			canReorder: false,
			canUpload: true,

			"{titleField}"        : "[data-album-title-field]",
			"{captionField}"      : "[data-album-caption-field]",
			"{coverField}"        : "[data-album-cover-field]",

			"{type}"			  : "[data-album-type]",
			"{uid}"				  : "[data-album-uid]",

			"{location}"          : "[data-album-location]",
			"{locationCaption}"   : "[data-album-location-caption]",
			"{addLocationButton}" : "[data-album-addLocation-button]",
			"{date}"              : "[data-album-date]",
			"{dateCaption}"       : "[data-album-date-caption]",
			"{addDateCaption}"    : "[data-album-addDate-button]",
			"{privacy}"           : "[data-album-privacy]",

			"{uploadButton}"      : "[data-album-upload-button]",
			"{deleteButton}"      : "[data-album-delete-button]",
			"{moreButton}"        : "[data-album-more-button]",

			"{privacy}"			  : "[data-privacy-hidden]",
			"{privacycustom}"	  : "[data-privacy-custom-hidden]",

			"{uploadItem}"        : "[data-photo-upload-item]",

			"{dateDay}"		    : "[data-date-day]",
			"{dateMonth}"		: "[data-date-month]",
			"{dateYear}"		: "[data-date-year]",

			"{editButton}"     : "[data-album-edit-button]",
			"{editButtonLink}" : "[data-album-edit-button] > a",
			"{doneButton}"     : "[data-album-done-button]",
			"{doneButtonLink}" : "[data-album-done-button] > a",
			"{cancelButton}"   : "[data-album-cancel-button]",
			"{cancelButtonLink}"   : "[data-album-cancel-button] > a",

			"{locationWidget}"  : ".es-album-location-form .es-location",
			"{latitude}"        : "[data-location-lat]",
			"{longitude}"       : "[data-location-lng]"
		}
	},
	function(self) { return {

		init: function() {

			self.id = self.element.data("album-id");

			var options = self.options;

			// If we can sort photos, load & implement sortable.
			if (options.canReorder) {
				EasySocial.module("albums/sortable")
					.done(function(SortableController){
						self.addPlugin("sortable", SortableController);
					});
			}

			// If we can upload photos, load & implement uploader.
			if (options.canUpload) {

				EasySocial.module("albums/editor/uploader")
					.done(function(UploaderController){
						self.uploader = self.addPlugin("uploader", UploaderController);
					});
			}

			// If this is an existing album, there's no need to create album
			if (self.id) {
				self.createAlbum.task = $.Deferred().resolve();
				self.createStream = 0;
			} else {
				self.createStream = 1;
			}
		},

		data: function() {

			var title         	= self.titleField().val(),
				caption       	= self.captionField().val(),
				date          	= self.formatDate(),
				address       	= self.locationCaption().html(),
				latitude      	= self.latitude().val(),
				longitude     	= self.longitude().val(),
				privacy       	= self.privacy().val(),
				privacycustom 	= self.privacycustom().val();
				uid 			= self.element.data( 'album-uid' );
				type 			= self.element.data( 'album-type' );

			return {
				id           : self.id,
				uid 		 : uid,
				type 		 : type,
				title        : title,
				caption      : caption,
				date         : date,
				address      : address,
				latitude     : latitude,
				longitude    : longitude,
				privacy      : privacy,
				privacycustom: privacycustom,
				createStream : self.createStream
			}
		},

		createAlbum: function() {

			var task = self.createAlbum.task;

			if (!task) {

				task = self.createAlbum.task =

					self.save({
							createStream: 0
						})
						.done(function(album){
							self.deleteButton().disabled(false);
							self.element.attr("data-album-id", self.id = album.id);
						})
						.fail(function(message, type){
							self.setMessage(message, type);
						});
			}

			return task;
		},

		save: function(options) {

			self.trigger("beforeAlbumSave", [self]);

			// Build save data
			var data = $.extend(self.data(), options);

				data.photos =
					$.map(
						self.album.photoItem(),
						function(photoItem, i){
							var editor = $(photoItem).controller("EasySocial.Controller.Photos.Editor");
							return (editor) ? editor.data() : null;
						});

				// TODO: Get photo ordering
				// data.ordering = self.getPhotoOrdering();

			// Clear any messages
			self.clearMessage();

			// Save album
			var task = EasySocial.ajax( "site/controllers/albums/store" , data );

			// Trigger albumSave event
			self.trigger("albumSave", [task, self]);

			// Return task
			return task;
		},

		"{self} photoAdd": function(el, event, photoItem, photoData) {

			// Set cover if this is the first photo
			if (self.album.photoItem().length <= 1) {
				self.changeCover(photoData);
			}
		},

		setCover: function(photoId) {

			var task =
				EasySocial.ajax(
					"site/controllers/albums/setCover",
					{
						albumId: self.id,
						coverId: photoId
					}
				)
				.done(function(photo){
					self.changeCover(photo);
				})
				.fail(function(){

				});

			return task;
		},

		removeCover: function() {

			self.trigger("coverRemove", [self.album]);
		},

		changeCover: function(photo) {

			self.trigger("coverChange", [photo, self]);
		},

		"{self} coverChange": function(el, event, photo) {

			self.coverField()
				.removeClass("no-cover")
				.css("backgroundImage", $.cssUrl(photo.sizes.thumbnail.url));
		},

		"{self} coverRemove": function() {

			self.coverField()
				.addClass("no-cover")
				.css("backgroundImage", "");
		},

		"{editButton} click": function() {

			// Change viewer layout
			self.album.setLayout("form");

			// Change address bar url
			self.editButtonLink().route();
		},

		"{editButtonLink} click": function(editButtonLink, event) {

			event.preventDefault();
		},

		"{cancelButton} click": function() {

			// Change viewer layout
			self.album.setLayout("item");

			// Change address bar url
			self.cancelButtonLink().route();
		},

		"{cancelButtonLink} click": function(editButtonLink, event) {

			event.preventDefault();
		},

		"{doneButton} click": function(el, event) {

			// Add a loading indicator here
			self.doneButtonLink().addClass('btn-loading');

			self.save()
				.done(function(album, html){

					// Replace the done link again
					self.doneButtonLink().removeClass('btn-loading');

					$.buildHTML(html).replaceAll(self.element);
				})
				.progress(function(message, type){
					self.setMessage(message, type);
				});
		},

		"{doneButtonLink} click": function(doneButtonLink, event) {
			event.preventDefault();
		},

		"{deleteButton} click": function(deleteButton) {

			if (deleteButton.disabled()) return;

			EasySocial.dialog({
				content: EasySocial.ajax("site/views/albums/confirmDelete", {id: self.id})
			});
		},

		formatDate: function() {
			var day = self.dateDay().val() || self.dateDay().data('date-default'),
				month = self.dateMonth().val() || self.dateMonth().data('date-default'),
				year = self.dateYear().val() || self.dateYear().data('date-default');

			return year + '-' + month + '-' + day;
			},

		updateDate: function() {

			self.date().addClass("has-data");
			var dateCaption = self.dateDay().val() + ' ' + $.trim(self.dateMonth().find(":selected").html()) + ' ' + self.dateYear().val();
			self.dateCaption().html(dateCaption);
		},

		"{dateDay} keyup": function() {
			self.updateDate();
		},

		"{dateMonth} change": function() {
			self.updateDate();
		},

		"{dateYear} keyup": function() {
			self.updateDate();
		},

		"{titleField} keyup": function(titleField) {

			self.trigger("titleChange", [titleField.val(), self]);
		},

		"{locationWidget} locationChange": function(el, event, location) {
			var address = location.address || location.fulladdress || location.formatted_address;

			// Set the address in the caption
			self.locationCaption().html(address);
			self.location().addClass("has-data");
		}

	}});

	module.resolve(Controller);
});

EasySocial.module("albums/editor/sortable", function($){

	var module = this;

	EasySocial.require()
		.library(
			"ui/sortable"
		)
		.done(function(){

			var Controller = 

			EasySocial.Controller("Albums.Editor.Sortable",
			{
				defaultOptions: {

				}
			},
			function(self) { return {

				init: function() {

					return;

					self.photoItemGroup()
						.sortable({
							forcePlaceholderSize: true,
							items: self.photoItem.selector,
							placeholder: 'es-photo-item placeholder',
							tolerance: 'pointer',
							delay: 150
						});
				},

				getPhotoOrdering: function() {

					var ordering = {};

					self.photoItem().each(function(i){
						var id = $(this).data("photoId");
						ordering[id] = i;
					});

					return ordering;
				},				

				"{parent.photoItemGroup} sortstart": function(el, event, ui) {

					ui.item.addClass("dragging");
					el.addClass("ordering");
					self.setLayout();
				},

				"{parent.photoItemGroup} sortchange": function(el, event, ui) {
					self.setLayout();
				},

				"{parent.photoItemGroup} sortstop": function(el, event, ui) {
					ui.item.removeClass("dragging");
					el.removeClass("ordering");
					self.setLayout();

					EasySocial.ajax(
						"site/controllers/photos/reorder",
						{
							id: ui.item.controller().id,
							order: ui.item.index()
						});					
				}
				
			}});

			module.resolve(Controller);

		});
});

EasySocial.module("albums/editor/uploader", function($){

	var module = this;

	EasySocial.require()
		.script(
			"albums/uploader"
		)
		.view(
			"site/albums/upload.item"
		)		
		.done(function(){

			var Controller = 

			EasySocial.Controller("Albums.Editor.Uploader",
			{
				defaultOptions: {

				}
			},
			function(self) { return {

				init: function() {

					// Shortcuts
					self.album = self.editor.album;

					// Get upload settings
					var settings = self.album.options.uploader;

					// Implement uploader
					self.uploader =
						self.addPlugin(
							"uploader",
							EasySocial.Controller.Albums.Uploader,
							{
								settings: settings,
								"{uploadButton}"   : self.editor.uploadButton.selector,
								"{uploadItemGroup}": self.album.photoItemGroup.selector,
								"{uploadDropsite}" : self.album.content.selector
							}
						);
				},

				setLayout: function() {

					self.album.setLayout_();
				},

				"{self} beforeAlbumSave": function() {

					// Stop existing upload process.
					self.uploader.stop();
				},

				"{self} albumSave": function(el, event, task) {

					task.done(function(album){

						var url = 
							$.uri(self.uploader.settings("url"))
								.replaceQueryParam("albumId", album.id)
								.toString();

						self.uploader.settings("url", url);							
					});
				},

				"{self} layoutChange": function(el, event, layoutName) {

					// Stop any running upload process
					// and clear upload items.
					self.uploader.stop();
					self.uploader.clear();

					var url = 
						$.uri(self.uploader.settings("url"))
							.replaceQueryParam("createStream", layoutName=="form" ? 0 : 1)
							.replaceQueryParam("layout", layoutName)
							.toString();

					self.uploader.settings("url", url);
				},

				"{self} QueueCreated": function(el, event, uploadItem) {
					
					// Give upload item a layout when we're under editor
					if (self.album.currentLayout()=="form") {
						uploadItem.element.addClass("layout-form");
					}

					self.setLayout();
				},
				
				startUpload: $.Enqueue(),

				"{uploader} FilesAdded": function(el, event, uploader, files) {

					// If this is a new album
					if (!self.id) {

						// Create the album first
						self.editor.createAlbum()
							.done(
								// Before we start uploading
								self.startUpload(function(){
									self.uploader.start();
								})
							);

					// Else start uploading straightaway
					} else {
						self.uploader.start();
					}

					self.setLayout();
				},

				"{uploader} FilesRemoved": function() {

					self.setLayout();
				},

				"{uploader} FileUploaded": function(el, event, uploader, file, response) {

					var uploadItem = self.uploader.getItem(file),

						photoItem = $.buildHTML(response.html),

						photoData = response.data;

						// Initialize photo item
						photoItem
							.addClass("new-item")
							.insertAfter(uploadItem.element);

						setTimeout(function(){
							photoItem.removeClass("new-item");
						}, 1);

						self.uploader.removeItem(file.id);

						self.trigger("photoAdd", [photoItem, photoData, self.album]);

						self.setLayout();
				}

			}});

			module.resolve(Controller);

		});
});

// module: start
EasySocial.module("albums/uploader", function($) {

    var module = this;

    // require: start
    EasySocial.require()
    .library(
        "plupload"
    )
    .script(
        "albums/uploader.item"
    )
    .view(
    	"site/albums/upload.item"
    )
    .done(function(){

        // controller: start
        EasySocial.Controller("Albums.Uploader",

        	{
        		defaultOptions: {

                    view: {
                        uploadItem: "site/albums/upload.item"
                    },

                    direction: 'prepend',

                    "{uploadButton}"   : "[data-upload-button]",
                    "{uploadItemGroup}": "[data-upload-item-group]",
                    "{uploadItem}"     : "[data-upload-item]",
                    "{uploadDropsite}" : "[data-upload-dropsite]"
        		}
        	},

            function(self, opts, base) { return {

                init: function() {

                    var uploader = self.element;

                    // Plupload controller
                    self.pluploadController =
                        self.element
                            .addController(
                                "plupload",
                                $.extend({
                                    "{uploadButton}" : self.uploadButton.selector,
                                    "{uploadDropsite}": self.uploadDropsite.selector
                                },
                                self.options.settings)
                            );

                    // Plupload
                    self.plupload = self.pluploadController.plupload;

                    // Indicate uploader supports drag & drop
                    if (!$.IE && self.plupload.runtime=="html5") {

                        uploader.addClass("can-drop-file");
                    }

                    // Indicate uploader is ready
                    uploader.addClass("can-upload");
        		},

        		setLayout: function() {

                    self.uploadItemGroup().toggleClass("no-upload-items", self.uploadItem().length < 1);
        		},

                items: {},

                getItem: function(file) {

                    var id;

                    // By id
                    if ($.isString(file)) id = file;

                    // By file object
                    if (file && file.id) id = file.id;

                    return self.items[id];
                },

                createItem: function(file) {

                    // Create item controller
                    var item =
                        self.view.uploadItem({file: file})
                            .switchClass("layout-" + (base.data("albumLayout") || "form"))
                            .addController(
                                "EasySocial.Controller.Albums.Uploader.Item",
                                {
                                    "{uploader}": self,
                                    file: file
                                }
                            );

                    // Add to item group
                    item.element[opts.direction=='append' ? 'appendTo' : 'prependTo'](self.uploadItemGroup());

                    // Keep a copy of the item in our registry
                    self.items[file.id] = item;

                    self.setLayout();

                    self.trigger("QueueCreated", [item]);

                    return item;
                },

                settings: function(key, val) {

                    var settings = self.plupload.settings;

                    // Setter
                    if (val!==undefined) {
                        settings[key] = val;
                    }

                    // Getter
                    return (key) ? settings[key] : settings;
                },

                start: function() {

                    return self.plupload.start();
                },

                stop: function() {

                    return self.plupload.stop();
                },

                "{self} FilesAdded": function(el, event, uploader, files) {

                    // Wrap the entire body in a try...catch scope to prevent
                    // browser from trying to redirect and load the file if anything goes wrong here.
                    try {

                        // Reverse upload ordering as we are prepending.
                        files.reverse();

                        $.each(files, function(i, file) {

                            // The item may have been created before, e.g.
                            // when plupload error event gets triggered first.
                            if (self.getItem(file)) return;

                            self.createItem(file);
                        });

                    } catch (e) {

                        console.error(e);
                    };
                },

                "{self} BeforeUpload": function(el, event, uploader, file) {

                    var item = self.getItem(file);
                    if (!item) return;

                    item.setState("preparing");
                },

                "{self} UploadFile": function(el, event, uploader, file) {

                    var item = self.getItem(file);
                    if (!item) return;

                    item.setState("uploading");
                },

                "{self} UploadProgress": function(el, event, uploader, file) {

                    var item = self.getItem(file);
                    if (!item) return;

                    item.setState("uploading");
                    item.setProgress();
                },

                "{self} FileUploaded": function(el, event, uploader, file, response) {

                    var item = self.getItem(file);
                    if (!item) return;

                    // If the response is not a valid object
                    if (!$.isPlainObject(response)) {

                        // Set upload item state to failed.
                        item.setState("failed");
                        return;
                    }

                    item.setState("done");
                },

                "{self} FileError": function(el, event, uploader, file, response) {

                    var item = self.getItem(file);

                    // If the item hasn't been created, create first.
                    if (!item) item = self.createItem(file);

                    item.setState("failed");
                    item.setMessage(response.message);
                },

                "{self} Error": function(el, event, uploader, error) {

                    // If the returned error object also returns a file object
                    if (error.file) {

                        // Check if the upload item has been created
                        var file = error.file,
                            item = self.getItem(file);

                        // If the upload item doesn't exist
                        if (!item) item = self.createItem(file);

                        item.setState("failed");
                        item.setMessage(error.message);
                    }
                },

                removeItem: function(id) {

                    var item = self.getItem(id);
                    if (!item) return;

                    // Remove item
                    self.plupload.removeFile(item.file());
                    item.element.remove();
                    delete self.items[id];

                    self.setLayout();
                },

                clear: function(id) {

                    $.each(self.items, function(id, item){

                        // Remove item
                        self.plupload.removeFile(item.file());
                        item.element.remove();
                        delete self.items[id];
                    });

                    self.items = {};
                }

        	}}

        );
        // controller: end

    module.resolve();

    });
    // require: end

});
// module: end

EasySocial.module("albums/uploader.item", function($) {

	var module = this;

	EasySocial.Controller("Albums.Uploader.Item",

	    {
	        defaultOptions: {
	        	"{status}"       : ".upload-status",
	            "{filename}"     : ".upload-filename",
	            "{progressBar}"  : ".upload-progress-bar",
	            "{percentage}"   : ".upload-percentage",
	            "{filesizeTotal}": ".upload-filesize-total",
	            "{filesizeLeft}" : ".upload-filesize-left",
	            "{details}"      : ".upload-details",
	            "{detailsButton}": ".upload-details-button",
	            "{removeButton}" : ".upload-remove-button",
	            "{message}"      : ".upload-message"
	        }
	    },

		// Instance properties
		function(self) { return {

			init: function() {

				self.id = self.element.attr("id");

				var file = self.file();

				// Set filename
				self.filename().html(file.name);

				// Set state
				self.setState("pending");

				// Set progress & filesize
				self.setProgress();

				var html4 = self.uploader.plupload.runtime=="html4";

				if ($.IE < 10 || html4) {
					// So upload item will display with indefinite progressbar
					self.element.addClass("indefinite-progress");
				}

				if (html4) {
					self.element.addClass("no-filesize");
				}
			},

	        file: function() {

	            var file = self.uploader.plupload.getFile(self.id) || self.options.file;

	            if (file) {
	            	var noFilesize = (file.size===undefined || file.size=="N/A");
	            	file.percentage = file.percent + "%";
	                file.filesize   = (noFilesize) ? "" : $.plupload.formatSize(file.size);
	                file.remaining  = (noFilesize) ? "" : $.plupload.formatSize(file.size - (file.loaded || 0));
	            }

	            return file;
	        },

	        setProgress: function() {

				var file = self.file(),
					percentage = file.percentage;

				// Never use 100% because users might think
				// the photo is completely uploaded when it might
				// still be working.
				// - Thanks Alex Heil.
				if (percentage=="100%") percentage = "99%";
				if (percentage=="0%") percentage = "1%";

				// Progress bar width
				self.progressBar()
					.width(percentage);

				// Progress bar percentage
				self.percentage()
					.html(percentage);

				// Total filesize
				self.filesizeTotal()
					.html(file.filesize);

				// Remaining filesize
				self.filesizeLeft()
					.html(file.remaining);
	        },

	        setState: function(state) {

				self.element
					.removeClass("pending preparing uploading failed done")
					.addClass(state);

				self.state = state;
	        },

			setMessage: function(message) {

			   	self.detailsButton()
			   		.attr("data-popbox", message);
			},

			"{removeButton} click": function(el, event) {

			    self.uploader.removeItem(self.id);
			}

	    }}
	);

	module.resolve();

});

EasySocial.module("albums/item", function($){

	var module = this;

	// Non-essential dependencies
	EasySocial.require()
		.script("albums/editor")
		.done();

	// Essential dependencies
	EasySocial.require()
		.library(
			"masonry"
		)
		.done(function(){

			EasySocial.Controller("Albums.Item",
			{
				hostname: "album",

				defaultOptions: {

					tilesPerRow: 4,
					editable: false,
					multipleSelection: false,

					"{header}": "[data-album-header]",
					"{content}": "[data-album-content]",
					"{footer}": "[data-album-footer]",

					"{info}": "[data-album-info]",

					"{title}": "[data-album-title]",
					"{caption}"       : "[data-album-caption]",
					"{location}"      : "[data-album-location]",
					"{date}"          : "[data-album-date]",
					"{cover}"         : "[data-album-cover]",

					"{photoItemGroup}": "[data-photo-item-group]",
					"{photoItem}"     : "[data-photo-item]",
					"{photoImage}"    : "[data-photo-image]",
					"{photoImageCss}" : "[data-photo-image-css]",
					"{featuredItem}"  : "[data-photo-item].featured",
					"{featuredImage}" : "[data-photo-item].featured [data-photo-image]",
					"{featuredImageCss}" : "[data-photo-item].featured [data-photo-image-css]",
					"{uploadItem}"    : "[data-photo-upload-item]",

					"{moreButton}"    : "[data-album-more-button]",
					"{viewButton}"    : "[data-album-view-button]",

					"{share}"			  : "[data-repost-action]",
					"{likes}"			  : "[data-likes-action]",
					"{likeContent}" 	  : "[data-likes-content]",
					"{repostContent}" 	  : "[data-repost-content]",
					"{counterBar}"	  	  : "[data-stream-counter]"
				}
			},
			function(self, opts, base) { return {

				init: function()
				{
					self.id = base.data("album-id");

					self.nextStart = base.data("album-nextstart") || -1;

					// If this viewer is editable, load & implement editor.
					if (self.options.editable) {
						EasySocial.module("albums/editor")
							.done(function(EditorController)
							{
								self.editor = self.addPlugin("editor", EditorController);
							});
					}

					// Set layout when window is resized
					self.setLayout();

					// Show load more button
					// Quick monkey fix for load more button showing
					// on the right corner before layout is set.
					self.moreButton().show();

					// Attach existing photo items as subscribers
					self.addSubscriber(
						self.photoItem()
							.controllers("EasySocial.Controller.Photos.Item")
					);
				},

				"{window} resize": $.debounce(function(){
					self.setLayout();
				}, 250),

				currentLayout: function() {

					return base.data("albumLayout");
				},

				setLayout_: $.debounce(function(){

					self.setLayout();
				}, 100),

				setLayout: function(layoutName) {

					var photoItemGroup = self.photoItemGroup(),

						// Build layout state
						currentLayout = self.currentLayout(),
						layoutName    = layoutName || currentLayout,
						seed          = self.setLayout.seed,
						intact        = (seed == photoItemGroup.width() && currentLayout==layoutName)
						hasPhotoItem  = self.photoItem().length > 0,
						hasUploadItem = self.uploadItem().length > 0,
						hasItem       = hasPhotoItem || hasUploadItem,
						masonry       = $.data(photoItemGroup[0], "masonry"),

						// Put them in an object
						layout = {
							currentLayout: currentLayout,
							seed         : seed,
							intact       : intact,
							hasPhotoItem : hasPhotoItem,
							hasUploadItem: hasUploadItem,
							hasItem      : hasItem,
							masonry      : masonry
						};

					// Determine if we need to switch layout
					if (!intact) {

						// Switch layout
						base
							.data("albumLayout", layoutName)
							.switchClass("layout-" + layoutName);

						// Switch all photo item's layout
						self.photoItem()
							.switchClass("layout-" + layoutName);

						// Reset viewport width to force layout redraw
						self.setLayout.seed = layout.seed = null;

						// Only trigger layout change when layout has really changed.
						if (currentLayout !== layoutName) {
							// Trigger layout change event
							self.trigger("layoutChange", [layoutName, layout]);
						}
					}

					// Show upload hint when content is empty
					base.toggleClass("has-photos", hasItem);

					// If there's no item from the list
					if (!hasItem) {

						// If this is coming from deleting the last item
						// from the list, we need to keep the container
						// on zero height.
						photoItemGroup.css("opacity", 1);
					}

					// Execute layout handler
					var layoutHandler = "set" + $.String.capitalize(layoutName) + "Layout";
					self[layoutHandler](layout);

					// Save current layout
					self.setLayout.seed = photoItemGroup.width();
				},

				setItemLayout: function(layout) {

					self.photoItem().attr("data-es-photo-disabled", 0);

					// Get photoItemGroup
					var tilesPerRow = 4,
						photoItemGroup = self.photoItemGroup(),
						viewportWidth  = base.width(),
						containerWidth = Math.floor(viewportWidth / tilesPerRow) * tilesPerRow;

					self.photoItemGroup()
						.width(containerWidth);

					if (layout.masonry) {

						photoItemGroup.masonry("reloadItems").masonry("layout");
					} else {

						photoItemGroup
							.masonry({
								columnWidth: ".es-photo-item.grid-sizer",
								itemSelector: self.photoItem.selector + ", " + self.uploadItem.selector,
								isOriginLeft: !self.options.rtl
							});
					}
				},

				setFormLayout: function(layout) {

					self.photoItem().attr("data-es-photo-disabled", 1);

					// Destroy masonry if we are on form layout
					layout.masonry && layout.masonry.destroy();

					// Reset layout
					self.clearLayout();
				},

				setDialogLayout: function() {

					self.photoItem().attr("data-es-photo-disabled", 1);

					// Destroy masonry if we are on form layout
					layout.masonry && layout.masonry.destroy();

					// Reset layout
					self.clearLayout();
				},

				setThumbnailLayout: function() {

				},

				setRowLayout: function() {

					self.photoItem().attr("data-es-photo-disabled", 0);

					self.clearLayout();
				},

				clearLayout: function() {

					self.photoItemGroup()
						.addClass("no-transition");

					self.photoItem
						.css().remove();

					self.photoImage
						.css().remove();

					self.photoImageCss
						.css().remove();

					self.featuredItem
						.css().remove();

					self.featuredImage
						.css().remove();

					self.featuredImageCss
						.css().remove();

					self.uploadItem
						.css().remove();

					self.setLayout.seed = null;
				},

				getSelectedItems: function() {

					var selectedPhotos = self.photoItem(".selected");

					var data = [];

					selectedPhotos.each(function(i, photo){
						data.push($(photo).controller("EasySocial.Controller.Photos.Item").data());
					});

					return data;
				},

				"{photoItem} init.photos.item": function(el, event, photoItem) {

					self.addSubscriber(photoItem);
				},

				"{photoItem} destroyed": function() {

					self.setLayout();
				},

				"{photoItem} activate": function(photoItem, event, photo) {

					// Activate is a non-standard IE event,
					// if photo is undefined then it is coming
					// from the browser not photo item controller.
					if (!photo) return;

					var currentLayout = self.currentLayout();

					switch (currentLayout) {

						case "item":
						case "row":

							// Show loading indicator
							photoItem.addClass("loading");

							// If browser is available, ask browser
							// to load photo view via ajax.
							if (self.browser) {

								// View photo
								self.browser
									.open("photo", photo.id)
									.always(function(){

										// Remove loading indicator
										photoItem.removeClass("loading");
									});

								// Change address bar url
								photo.imageLink().route();

							// If browser is not available,
							// just load the photo view normally.
							} else {
								window.location = photo.imageLink().attr("href");
							}
							break;

						case "form":
							// photo.editor && photo.editor.enable();
							break;

						case "dialog":

							var selectedPhotos = self.photoItem(".selected");

							if (!self.options.multipleSelection) {

								var selected = photoItem.hasClass("selected");

								// In case it came from multiple selection
								selectedPhotos.removeClass("selected");

								photoItem.toggleClass("selected", !selected);

							} else {

								photoItem.toggleClass("selected");
							}
							break;
					}
				},

				"{photoItem} photoFeature": function(el, event, task, photo, featured) {

					// Set layout to accomodate double size photo item
					self.setLayout();

					// When a photo fail to be featured, it shrinks
					task
						.fail(function(){

							// So we're resetting layout again
							self.setLayout();
						});
				},

				"{photoItem} photoMove": function(el, event, task, photo, targetAlbumId) {

					self.clearMessage();

					task
						.done(function(){

							// Remove photo
							photo.element.remove();

							// Set layout
							self.setLayout();

							// If there are no more photos, remove cover
							if (self.photoItem().length < 1) {
								self.trigger("coverRemove", [self]);
							}
						})
						.fail(function(message, type){
							self.setMessage(message, type);
						});
				},

				"{photoItem} photoDelete": function(el, event, task, photo) {

					self.clearMessage();

					task
						.done(function(){

							// Remove photo
							photo.element.remove();

							// Set layout
							self.setLayout();

							// If there are no more photos, remove cover
							if (self.photoItem().length < 1) {
								self.trigger("coverRemove", [self]);
							}
						})
						.fail(function(message, type){
							self.setMessage(message, type);
						});
				},

				// These are coming from album editor
				"{self} albumSave": function(el, event, task) {

					task.done(function(album){
						self.id = album.id;
					});
				},

				"{self} coverChange": function(el, event, photo, album) {

					self.cover()
						.css("backgroundImage", $.cssUrl(photo.sizes.thumbnail.url));
				},

				"{self} coverRemove": function() {

					self.cover()
						.css("backgroundImage", "");
				},

				"{viewButton} click": function(viewButton, event) {
					if (self.browser)
					{
						event.preventDefault();
						base.addClass("loading");
						self.browser.open("Album", self.id);
					}
				},

				"{moreButton} click": function(moreButton) {

					// If nextStart is -1, means no more photos
					if (self.nextStart == -1) {
						return;
					}

					if (moreButton.disabled()) {
						return;
					}

					// Disable this button
					moreButton.toggleClass('loading');
					moreButton.disabled(true);

					// Set the button into loading state
					// moreButton.addClass('loading');

					// Get the new photos content
					EasySocial.ajax(
						"site/controllers/albums/loadMore",
						{
							albumId: self.id,
							start: self.nextStart,
							layout: self.currentLayout()
						})
						.done(function(htmls, nextStart) {

							self.nextStart = nextStart;

							var photoItemGroup = self.photoItemGroup();

							$.each(htmls, function(i, html){
								$.buildHTML(html).appendTo(photoItemGroup);
							});

							moreButton.toggleClass('loading');

							// If there is no more photos to load, hide the button
							if (nextStart < 0) {
								moreButton.hide();
							}

							self.setLayout();
						})
						.always(function(){

							moreButton.disabled(false);
						});
				},

                "{share} create": function(el, event, itemHTML) {
                	self.counterBar().removeClass('hide');
                },

 				"{likes} onLiked": function(el, event, data) {

					//need to make the data-stream-counter visible
					self.counterBar().removeClass( 'hide' );
				},

				"{likes} onUnliked": function(el, event, data) {

					var isLikeHide 		= self.likeContent().hasClass('hide');
					var isRepostHide 	= self.repostContent().hasClass('hide');

					if( isLikeHide && isRepostHide )
					{
						self.counterBar().addClass( 'hide' );
					}
				}

			}});

			module.resolve();
		});
});

EasySocial.module('apps/event/discussions', function($) {

    var module  = this;

    EasySocial.Controller(
        'Events.Item.Discussions',
        {
            defaultOptions:
            {
                "{filter}"  : "[data-event-discussions-filter]",
                "{contents}": "[data-event-discussion-contents]"
            }
        },
        function(self)
        {
            return {
                init: function()
                {
                    self.options.id     = self.element.data( 'id' );
                },

                setContent: function( html )
                {
                    // Remove loading class since we already have the content.
                    self.contents().removeClass( 'is-loading' );

                    self.contents().html( html );
                },

                setActiveFilter: function( el )
                {
                    // Remove active class.
                    self.filter().removeClass( 'active' );

                    // Add active class to the current element
                    el.addClass( 'active' );
                },

                "{filter} click" : function( el , event )
                {
                    var filter = el.data( 'filter' );

                    // Add loader for the contents area
                    self.contents().html( '&nbsp;' ).addClass( 'is-loading' );

                    // Set active filter
                    self.setActiveFilter( el );

                    // Run the ajax call now
                    EasySocial.ajax( 'apps/event/discussions/controllers/discussion/getDiscussions' ,
                    {
                        "id"        : self.options.id,
                        "filter"    : filter
                    })
                    .done(function( contents , empty )
                    {
                        if( empty )
                        {
                            self.contents().addClass( 'is-empty' );
                        }
                        else
                        {
                            self.contents().removeClass( 'is-empty' );
                        }
                        // Set the contents
                        self.setContent( contents );
                    });
                }
            }
        }
    );
    EasySocial.Controller(
        'Events.Item.Discussion',
        {
            defaultOptions:
            {
                "{form}"        : "[data-reply-form]",
                "{list}"        : "[data-reply-list]",
                "{replies}"     : "[data-reply-item]",
                "{repliesWrap}" : "[data-replies-wrapper]",

                "{replyCounter}": "[data-reply-count]",

                "{lock}"        : "[data-discussion-lock]",
                "{unlock}"      : "[data-discussion-unlock]",
                "{delete}"      : "[data-discussion-delete]"
            }
        },
        function( self )
        {
            return {
                init: function()
                {
                    self.options.id = self.element.data('id');
                    self.options.eventId = self.element.data('eventid');

                    self.implementReply(self.replies());

                    self.form().implement(EasySocial.Controller.Events.Item.Discussion.Form,{
                        "{parent}": self
                    });
                },

                implementReply: function()
                {
                    self.replies().implement(EasySocial.Controller.Events.Item.Discussion.Reply, {
                        "{parent}": self
                    });
                },

                insertReply: function(html)
                {
                    // Since we know that we need to append the reply item, we need to remove is-unanswered
                    self.element.removeClass( 'is-unanswered' );

                    // Since an item is added, we want to remove the empty class.
                    self.repliesWrap().removeClass( 'is-empty' );

                    // Append the new item
                    self.list().append( html );

                    // Implement the controller again
                    self.implementReply();
                },

                updateReplyCounter: function( total )
                {
                    if( total == 0 )
                    {
                        self.repliesWrap().addClass( 'is-empty' );
                    }
                    self.replyCounter().html( total );
                },

                setResolved: function()
                {
                    self.element.addClass( 'is-resolved' );
                },

                "{unlock} click" : function( el , event )
                {
                    EasySocial.ajax('apps/event/discussions/controllers/discussion/unlock', {
                        "id" : self.options.id
                    }).done(function() {
                        // Add lock element
                        self.element.removeClass('is-locked');
                    });
                },

                "{delete} click" : function(el, event)
                {
                    EasySocial.dialog({
                        content : EasySocial.ajax( 'apps/event/discussions/controllers/discussion/confirmDelete' , { "id" : self.options.id , "eventId" : self.options.eventId })
                    });
                },

                "{lock} click" : function( el , event )
                {
                    EasySocial.dialog(
                    {
                        content : EasySocial.ajax( 'apps/event/discussions/controllers/discussion/confirmLock' ),
                        bindings:
                        {
                            "{lockButton} click" : function()
                            {
                                EasySocial.ajax( 'apps/event/discussions/controllers/discussion/lock' ,
                                {
                                    "id" : self.options.id
                                })
                                .done(function()
                                {
                                    // Hide the dialog
                                    EasySocial.dialog().close();

                                    // Add lock element
                                    self.element.addClass( 'is-locked' );
                                });
                            }
                        }
                    });
                }
            }
        }
    );

    EasySocial.Controller(
        'Events.Item.Discussion.Reply',
        {
            defaultOptions:
            {
                "{acceptAnswer}"    : "[data-reply-accept-answer]",
                "{delete}"          : "[data-reply-delete]",
                "{edit}"            : "[data-reply-edit]",
                "{cancelEdit}"      : "[data-reply-edit-cancel]",
                "{update}"          : "[data-reply-edit-update]",
                "{textarea}"        : "[data-reply-content]",
                "{content}"         : "[data-reply-display-content]",
                "{alertDiv}"        : "div.alert-error"
            }
        },
        function( self )
        {
            return {
                init: function()
                {
                    console.log(self.element)
                    self.options.id     = self.element.data( 'id' );
                },
                "{acceptAnswer} click" : function()
                {
                    EasySocial.ajax( 'apps/event/discussions/controllers/reply/accept' ,
                    {
                        "id" : self.options.id
                    })
                    .done(function() {
                        self.parent.setResolved();
                    });
                },

                cancelEditing : function()
                {
                    self.element.removeClass( 'is-editing' );
                },

                "{cancelEdit} click" : function()
                {
                    self.cancelEditing();
                },

                "{edit} click" : function()
                {
                    self.element.addClass( 'is-editing' );
                },

                "{update} click" : function()
                {
                    var content     = self.textarea().val();

                    // console.log( self.element);

                    // If content is empty, throw some errors
                    if (content == '') {
                        self.element.addClass('is-empty');
                        self.alertDiv().show();
                        return false;
                    }

                    EasySocial.ajax( 'apps/event/discussions/controllers/reply/update' , {
                        "id": self.options.id,
                        "eventId": self.parent.options.eventId,
                        "content": content
                    })
                    .done(function(content) {
                        // Update the content
                        self.content().html( content );

                        self.element.removeClass('is-empty');
                        self.alertDiv().hide();


                        // Hide the textarea
                        self.cancelEditing();
                    });
                },

                "{delete} click" : function()
                {
                    EasySocial.dialog(
                    {
                        content     : EasySocial.ajax( 'apps/event/discussions/controllers/reply/confirmDelete' , { "id"    : self.options.id } ),
                        bindings    :
                        {
                            "{deleteButton} click" : function()
                            {
                                EasySocial.ajax( 'apps/event/discussions/controllers/reply/delete',
                                {
                                    "id"    : self.options.id
                                })
                                .done(function(discussion) {

                                    // Update the counter
                                    self.parent.updateReplyCounter( discussion.total_replies );

                                    // Hide the dialog
                                    EasySocial.dialog().close();

                                    // Remove the element
                                    self.element.remove();
                                });
                            }
                        }
                    });
                }
            }
        }
    );

    EasySocial.Controller(
        'Events.Item.Discussion.Form',
        {
            defaultOptions:
            {
                "{textarea}"    : "[data-reply-content]",
                "{submitReply}" : "[data-reply-submit]"
            }
        },
        function( self )
        {
            return {
                init: function()
                {
                },

                "{submitReply} click" : function( el , event )
                {
                    var content     = self.textarea().val();

                    // If content is empty, throw some errors
                    if ( content == '' ) {
                        self.element.addClass( 'is-empty' );
                        return false;
                    }

                    EasySocial.ajax('apps/event/discussions/controllers/reply/submit', {
                        "id"        : self.parent.options.id,
                        "eventId"   : self.parent.options.eventId,
                        "content"   : content
                    })
                    .done(function(html) {
                        // Inser the new node back.
                        self.parent.insertReply(html);

                        // Update the textarea
                        self.textarea().val('');
                    });

                }
            }
        }
    );

    module.resolve();
});


EasySocial.module('apps/event/guests', function($) {

    var module  = this;


    EasySocial.Controller('Events.Item.Guests', {
        defaultOptions: {
            '{filters}': '[data-event-guests-filter]',
            '{content}': '[data-event-guests-content]'
        }
    }, function(self) {
        return {
            init : function()
            {
                self.options.id = self.element.data('id');

                self.items = self.addPlugin('Item');
            },

            '{filters} click': function(el, event)
            {
                event.preventDefault();

                el.route();

                // Remove active
                self.filters().removeClass('active');

                // Set current to active
                el.addClass('active');

                // Get the filter
                var filter  = el.data('filter');

                // Set the loading class
                self.content().html('&nbsp;');
                self.content().addClass('is-loading');

                EasySocial.ajax('apps/event/guests/controllers/events/filterGuests', {
                    'id': self.options.id,
                    'filter': filter
                }).done(function(contents, total) {
                    self.content().removeClass('is-loading');

                    if (total == 0) {
                        self.content().addClass('is-empty');
                    } else {
                        self.content().removeClass('is-empty');
                    }
                    self.content().html(contents);
                });
            },

            '{self} emptyGuest': function() {
                self.content().addClass('is-empty');
            }
        }
    });

    EasySocial.Controller(
        'Events.Item.Guests.Item',
        {
            defaultOptions:
            {
                '{item}': '[data-event-guest-item]',
                '{promote}': '[data-guest-promote]',
                '{demote}': '[data-guest-demote]',
                '{approve}': '[data-guest-approve]',
                '{reject}': '[data-guest-reject]',
                '{remove}': '[data-guest-remove]'
            }
        },
        function( self )
        {
            return {
                init : function()
                {
                },

                getItem: function(el)
                {
                    var item = self.item.of(el);

                    return item;
                },

                '{approve} click' : function(el)
                {
                    var item = self.getItem(el),
                        guestId = item.data('guestId');

                    EasySocial.dialog({
                        content: EasySocial.ajax('site/views/events/confirmApproveGuest', {
                            'id': guestId
                        }),
                        bindings: {
                            '{approveButton} click': function() {
                                EasySocial.ajax('site/controllers/events/approveGuest', {
                                    'id': guestId
                                })
                                .done(function() {
                                    EasySocial.dialog().close();

                                    // Remove guest from the pending list
                                    item.remove();

                                    self.item().length === 0 && self.element.trigger('emptyGuest');
                                });
                            }
                        }
                    });
                },

                '{reject} click' : function(el)
                {
                    var item = self.getItem(el),
                        guestId = item.data('guestId');

                    EasySocial.dialog({
                        content: EasySocial.ajax('site/views/events/confirmRejectGuest', {
                            'id': guestId
                        }),
                        bindings: {
                            '{rejectButton} click': function() {
                                EasySocial.ajax('site/controllers/events/rejectGuest', {
                                    'id': guestId
                                })
                                .done(function() {
                                    EasySocial.dialog().close();

                                    // Remove guest from the pending list
                                    item.remove();

                                    self.item().length === 0 && self.element.trigger('emptyGuest');
                                });
                            }
                        }
                    });
                },

                '{promote} click' : function(el)
                {
                    var item = self.getItem(el),
                        guestId = item.data('guestId');


                    EasySocial.dialog({
                        content: EasySocial.ajax('site/views/events/confirmPromoteGuest', {
                            'id': guestId
                        }),
                        bindings: {
                            '{promoteButton} click': function() {
                                EasySocial.ajax('site/controllers/events/promoteGuest', {
                                    'id': guestId
                                }).done(function() {
                                    EasySocial.dialog().close();

                                    // Add the admin label
                                    item.removeClass('is-member')
                                        .addClass('is-admin');
                                });
                            }
                        }
                    })
                },

                '{demote} click' : function(el)
                {
                    var item = self.getItem(el),
                        guestId = item.data('guestId');

                    EasySocial.dialog({
                        content: EasySocial.ajax('site/views/events/confirmDemoteGuest', {
                            'id': guestId
                        }),
                        bindings: {
                            '{demoteButton} click' : function() {
                                EasySocial.ajax('site/controllers/events/demoteGuest', {
                                    'id': guestId
                                })
                                .done(function() {
                                    EasySocial.dialog().close();

                                    // If the current tab is admin, then we remove instead
                                    if (self.parent.filters('.active').data('filter') == 'admin') {
                                        item.remove();

                                        self.item().length === 0 && self.element.trigger('emptyGuest');
                                    } else {
                                        // Remove the admin label
                                        item.removeClass('is-admin').addClass('is-member');
                                    }
                                });

                            }
                        }
                    });
                },

                '{remove} click' : function(el, event)
                {
                    var item = self.getItem(el),
                        guestId = item.data('guestId');

                    EasySocial.dialog({
                        content: EasySocial.ajax('site/views/events/confirmRemoveGuest', {
                            'id': guestId
                        }),
                        bindings: {
                            '{removeButton} click': function() {
                                EasySocial.ajax('site/controllers.events/removeGuest', {
                                    'id': guestId
                                })
                                .done(function() {
                                    EasySocial.dialog().close();

                                    // Remove guest from the list
                                    item.remove();

                                    self.item().length === 0 && self.element.trigger('emptyGuest');
                                });
                            }
                        }
                    });
                }
            }
        }
    );


    module.resolve();
});


EasySocial.module('apps/event/tasks', function($)
{
    var module = this;

    EasySocial.Controller('Events.Apps.Tasks.Milestones.Browse', {
        defaultOptions: {
            eventId: null,

            "{milestone}": "[data-tasks-milestone-item]"
        }
    }, function(self) {
        return {
            init: function()
            {
                self.options.eventId = self.element.data('eventid');

                self.milestone().addController(EasySocial.Controller.Events.Apps.Tasks.Milestones.Item, {
                    "{parent}"  : self
                });
            }
        }
    });

    EasySocial.Controller('Events.Apps.Tasks.Milestones.Item', {
        defaultOptions: {
            "{complete}": "[data-milestone-mark-complete]",
            "{incomplete}": "[data-milestone-mark-incomplete]",
            "{delete}": "[data-milestone-delete]",
            "{milestone}": "[data-event-tasks-milestone-item]"
        }
    }, function(self) {
        return {
            init: function()
            {
                self.options.id = self.element.data('id');
            },

            "{incomplete} click" : function(el)
            {
                EasySocial.ajax('apps/event/tasks/controllers/milestone/unresolve',
                {
                    id: self.options.id,
                    eventId: self.parent.options.eventId
                })
                .done(function() {
                    self.element.removeClass('is-due').removeClass('is-completed');

                    el.hide();

                    self.complete().show();
                });
            },

            "{complete} click" : function(el)
            {
                EasySocial.ajax('apps/event/tasks/controllers/milestone/resolve', {
                    id: self.options.id,
                    eventId: self.parent.options.eventId
                })
                .done(function() {
                    self.element.removeClass('is-due').addClass('is-completed');

                    el.hide();

                    self.incomplete().show();
                });
            },

            "{delete} click" : function()
            {
                EasySocial.dialog( {
                    content : EasySocial.ajax('apps/event/tasks/controllers/milestone/confirmDelete', {
                        id: self.options.id,
                        eventId: self.parent.options.eventId
                    }),
                    bindings: {
                        '{deleteButton} click' : function() {
                            EasySocial.ajax('apps/event/tasks/controllers/milestone/delete', {
                                id: self.options.id,
                                eventId: self.parent.options.eventId
                            })
                            .done(function() {
                                EasySocial.dialog().close();

                                self.element.remove();
                            });
                        }
                    }
                });
            }
        }
    });

    EasySocial.Controller('Events.Apps.Tasks', {
        defaultOptions: {
            '{form}': '[data-tasks-form]',
            '{formWrapper}': '[data-tasks-form-wrapper]',
            '{taskList}': '[data-tasks-list]',
            '{item}': '[data-tasks-list-item]',
            '{completedList}': '[data-tasks-completed]',
            '{openCounter}': '[data-tasks-open-counter]',
            '{closedCounter}': '[data-tasks-closed-counter]',
            "{completeMilestone}": "[data-milestone-mark-complete]",
            "{incompleteMilestone}": "[data-milestone-mark-incomplete]",
            "{deleteMilestone}": "[data-milestone-delete]",
            "{wrapper}": "[data-tasks-wrapper]"
        }
    }, function(self) {
        return {
            init: function()
            {
                self.options.id = self.element.data('id');
                self.options.eventId = self.element.data('eventid');
                self.options.milestoneId = self.element.data('milestoneid');

                // Implement form controller
                self.form().addController(EasySocial.Controller.Events.Apps.Tasks.Form, {
                    "{parent}": self
                });

                self.implementItemController();
            },
            implementItemController: function()
            {
                // Implement task item controller
                self.item().addController(EasySocial.Controller.Events.Apps.Tasks.Item, {
                    "{parent}": self
                });
            },
            updateOpenCounter: function(total)
            {
                self.openCounter().html(total);
            },
            updateClosedCounter: function(total)
            {
                self.closedCounter().html(total);
            },
            insertCompleted: function(taskItem)
            {
                $(taskItem).appendTo(self.completedList());
            },
            insertTask: function(taskItem)
            {
                self.formWrapper().after(taskItem);

                // Implement item controller on the tasks
                self.implementItemController();
            },
            "{uncompleteMilestone} click" : function()
            {
                EasySocial.ajax('apps/event/tasks/controllers/milestone/unresolve',
                {
                    id: self.options.milestoneId,
                    eventId: self.options.eventId
                })
                .done(function()
                {
                    self.wrapper().removeClass('is-due').removeClass('is-completed');
                });
            },
            "{completeMilestone} click" : function()
            {
                EasySocial.ajax('apps/event/tasks/controllers/milestone/resolve', {
                    id: self.options.milestoneId,
                    eventId: self.options.eventId
                })
                .done(function() {
                    self.wrapper().removeClass('is-due').addClass('is-completed');
                });
            },

            "{deleteMilestone} click" : function()
            {
                EasySocial.dialog( {
                    content : EasySocial.ajax('apps/event/tasks/controllers/milestone/confirmDelete', {
                        id: self.options.milestoneId,
                        eventId: self.options.eventId
                    }),
                    bindings: {
                        '{deleteButton} click' : function() {
                            EasySocial.ajax('apps/event/tasks/controllers/milestone/delete', {
                                id: self.options.id,
                                eventId: self.options.eventId
                            })
                            .done(function() {
                                EasySocial.dialog().close();

                                window.location = self.options.redirect;
                            });
                        }
                    }
                });
            }
        }
    });

    EasySocial.Controller('Events.Apps.Tasks.Item', {
        defaultOptions: {
            '{checkbox}': '[data-item-checkbox]',
            '{delete}': '[data-tasks-item-remove]'
        }
    }, function(self) {
        return {
            init: function()
            {
                self.options.id = self.element.data('id');
            },
            '{delete} click' : function()
            {
                EasySocial.dialog({
                    content: EasySocial.ajax('apps/event/tasks/controllers/tasks/confirmDelete', {
                        'eventId': self.parent.options.eventId
                    }),
                    bindings: {
                        '{deleteButton} click' : function() {
                            EasySocial.ajax('apps/event/tasks/controllers/tasks/delete', {
                                id: self.options.id,
                                eventId: self.parent.options.eventId
                            })
                            .done(function() {
                                EasySocial.dialog().close();

                                var total = parseInt(self.parent.openCounter().html());

                                self.parent.updateOpenCounter(total - 1);

                                self.element.remove();
                            });
                        }
                    }
                });
            },
            '{checkbox} change': function(el, event)
            {
                var checked = $(el).is(':checked');

                if (checked) {
                    EasySocial.ajax('apps/event/tasks/controllers/tasks/resolve', {
                        id: self.options.id,
                        eventId: self.parent.options.eventId
                    })
                    .done(function() {
                        // Decrease the open counter
                        var total = parseInt(self.parent.openCounter().html());

                        self.parent.updateOpenCounter(total - 1);

                        var total = parseInt(self.parent.closedCounter().html());

                        self.parent.updateClosedCounter(total + 1);

                        self.parent.insertCompleted(self.element);
                    });

                } else {
                    EasySocial.ajax('apps/event/tasks/controllers/tasks/unresolve', {
                        id: self.options.id,
                        eventId: self.parent.options.eventId
                    })
                    .done(function($) {
                        // Decrease the open counter
                        var total = parseInt(self.parent.openCounter().html());

                        self.parent.updateOpenCounter(total + 1);

                        var total = parseInt(self.parent.closedCounter().html());

                        self.parent.updateClosedCounter(total - 1);

                        self.parent.insertTask(self.element);
                    });
                }
            }
        }
    });

    EasySocial.Controller('Events.Apps.Tasks.Form', {
        defaultOptions: {
            '{title}': "[data-form-tasks-title]",
            '{create}': "[data-form-tasks-create]",
            '{assignee}': "[data-form-tasks-assignee]",
            '{due}': "[data-form-tasks-due]",
            '{error}': "[data-tasks-form-error]"
        }
    }, function(self) {
        return {
            init: function()
            {

            },

            resetForm: function()
            {
                self.element[0].reset();
            },

            "{title} keyup" : function(el, event)
            {
                // Enter key
                if(event.keyCode == 13) {
                    self.create().click();
                }
            },

            "{create} click" : function()
            {
                if(self.title().val() == '') {
                    self.error().removeClass('hide');

                    return false;
                }

                self.error().addClass('hide');

                EasySocial.ajax('apps/event/tasks/controllers/tasks/save', {
                    title: self.title().val(),
                    assignee: self.assignee().val(),
                    due: self.due().val(),
                    eventId: self.parent.options.eventId,
                    milestoneId: self.parent.options.milestoneId
                })
                .done(function(content) {

                    // Reset the form
                    self.resetForm();

                    // Increment the counter
                    var total = parseInt(self.parent.openCounter().html());

                    self.parent.updateOpenCounter(total + 1);

                    self.parent.insertTask(content);
                });
            }
        }
    });

    module.resolve();
});


EasySocial.module('apps/fields/event/permalink/content', function($) {
    var module = this;

    EasySocial
        .require()
        .language(
            'FIELDS_EVENT_PERMALINK_EXCEEDED_MAX_LENGTH',
            'FIELDS_EVENT_PERMALINK_REQUIRED')
        .done(function($) {

            EasySocial.Controller(
                'Field.Event.Permalink',
                {
                    defaultOptions:
                    {
                        required: false,

                        max     : 0,

                        id      : null,
                        clusterid   : null,
                        userid  : null,

                        '{field}'           : '[data-field-permalink]',

                        '{checkButton}'     : '[data-permalink-check]',
                        '{input}'           : '[data-permalink-input]',
                        '{available}'       : '[data-permalink-available]'
                    }
                },
                function(self)
                {
                    return {
                        state: false,

                        init: function()
                        {
                            self.options.max = self.field().data('max');
                        },

                        "{checkButton} click" : function()
                        {
                            self.delayedCheck();
                        },

                        "{input} keyup" : function()
                        {
                            self.delayedCheck();
                        },

                        delayedCheck: $.debounce(function()
                        {
                            self.checkPermalink();
                        }, 250),

                        checkPermalink: function()
                        {
                            self.clearError();

                            var permalink   = self.input().val();

                            self.available().hide();

                            if (self.options.max > 0 && permalink.length > self.options.max) {
                                self.raiseError($.language('FIELDS_EVENT_PERMALINK_EXCEEDED_MAX_LENGTH'));
                                return false;
                            }

                            if (!$.isEmpty(permalink)) {
                                self.checkButton().addClass('btn-loading');

                                var state = $.Deferred();

                                EasySocial.ajax('fields/event/permalink/isValid', {
                                    "id"        : self.options.id,
                                    "clusterid" : self.options.clusterid,
                                    "permalink" : permalink
                                })
                                .done(function(msg) {
                                    self.clearError();

                                    self.checkButton().removeClass('btn-loading');

                                    self.available().show();

                                    state.resolve();
                                })
                                .fail(function(msg) {
                                    self.raiseError(msg);

                                    self.checkButton().removeClass('btn-loading');

                                    self.available().hide();

                                    state.reject();
                                });

                                return state;
                            }

                            if (self.options.required && $.isEmpty(permalink)) {
                                self.available().hide();

                                self.raiseError($.language('FIELDS_EVENT_PERMALINK_REQUIRED'));
                                return false;
                            }

                            return true;
                        },

                        raiseError: function(msg)
                        {
                            self.trigger('error', [msg]);
                        },

                        clearError: function()
                        {
                            self.trigger('clear');
                        },

                        '{self} onSubmit': function(el, ev, register)
                        {
                            register.push(self.checkPermalink());
                        }
                    }
                }
            );

            module.resolve();
        });
});

EasySocial.module('apps/fields/event/permalink/sample_content', function($) {
    var module = this;

    EasySocial.Controller('Field.Permalink.Sample', {
        defaultOptions: {
            '{checkPermalink}'      : '[data-check-permalink]'
        }
    }, function(self) {
        return {
            init: function() {

            },

            '{self} onConfigChange': function(el, event, name, value) {
                switch(name) {
                    case 'check_permalink':
                        self.checkPermalink().toggle(!!value);
                    break;
                }
            }
        }
    });

    module.resolve();
});

EasySocial.module('apps/fields/event/recurring/content', function($) {
    var module = this;

    EasySocial.require().library('datetimepicker').done(function() {

        EasySocial.Controller('Field.Event.Recurring', {
            defaultOptions: {
                id: null,

                value: {},

                allday: 0,

                showWarningMessages: 0,

                eventId: null,

                '{type}': '[data-recurring-type]',

                '{endBlock}': '[data-recurring-end-block]',

                '{picker}': '[data-recurring-end-picker]',

                '{toggle}': '[data-recurring-end-toggle]',

                '{result}': '[data-recurring-end-result]',

                '{dailyBlock}': '[data-recurring-daily-block]',

                '{dailyInput}': '[data-recurring-daily-block] input',

                '{summaryBlock}': '[data-recurring-summary-block]',

                '{scheduleToggle}': '[data-recurring-schedule-toggle]',

                '{scheduleBlock}': '[data-recurring-schedule-block]',

                '{scheduleLoadingBlock}': '[data-recurring-schedule-loading-block]',

                '{deleteRecurringButton}': '[data-recurring-delete]'
            }
        }, function(self) {
            return {
                init: function() {
                    self.picker()._datetimepicker({
                        pickTime: false,
                        component: "es",
                        useCurrent: false
                    });

                    var value = self.result().val();

                    if (!$.isEmpty(value)) {
                        var dateObj = $.moment(value);

                        self.datetimepicker('setDate', dateObj);
                    }

                    self.calculateTotalRecur();
                },

                changed: 0,

                '{window} easysocial.fields.allday.change': function(el, ev, value) {
                    self.options.allday = value;

                    self.calculateTotalRecur();
                },

                '{window} easysocial.fields.startend.start.change': function(el, ev, date) {
                    self.calculateTotalRecur();
                },

                '{toggle} click': function() {
                    self.picker().focus();
                },

                '{picker} dp.change': function(el, ev) {
                    self.setDateValue(ev.date.toDate());

                    self.detectChanges();

                    self.calculateTotalRecur();
                },

                '{type} change': function(el, ev) {
                    var value = el.val();

                    self.endBlock()[value === 'none' ? 'hide' : 'show']();

                    self.dailyBlock()[value === 'daily' ? 'show': 'hide']();

                    self.detectChanges();

                    self.calculateTotalRecur();
                },

                '{dailyInput} change': function(el, ev) {
                    self.detectChanges();

                    self.calculateTotalRecur();
                },

                calculateTotalRecur: function() {
                    self.summaryBlock().hide();

                    self.clearError();

                    var start = $('[data-event-start]').find('[data-datetime]').val(),
                        timezone = $('[data-event-timezone]').val(),
                        end = self.result().val(),
                        type = self.type().val(),
                        daily = [];

                    if (type == 'none' && !self.options.showWarningMessages) {
                        return;
                    }

                    if ($.isEmpty(start) || $.isEmpty(end) || $.isEmpty(type)) {
                        return;
                    }

                    $.each(self.dailyBlock().find('input'), function(i, input) {
                        el = $(input);
                        if (el.is(':checked')) {
                            daily.push(el.val());
                        }
                    });

                    self.scheduleLoadingBlock().show();

                    self.getTotalRecur({
                        start: start,
                        timezone: timezone,
                        end: end,
                        type: type,
                        daily: daily
                    });
                },

                getTotalRecur: $.debounce(function(options) {
                    self.clearError();

                    EasySocial.ajax('fields/event/recurring/calculateTotalRecur', {
                        id: self.options.id,
                        start: options.start,
                        timezone: options.timezone,
                        allday: self.options.allday,
                        end: options.end,
                        type: options.type,
                        daily: options.daily,
                        eventId: self.options.eventId,
                        changed: self.changed,
                        showWarningMessages: self.options.showWarningMessages
                    }).done(function(html) {
                        self.summaryBlock().html(html).show();
                    }).fail(function(msg) {
                        self.raiseError(msg);
                    }).always(function() {
                        self.scheduleLoadingBlock().hide();
                    });
                }, 500),

                detectChanges: function() {
                    var end = self.result().val(),
                        type = self.type().val(),
                        daily = [],
                        changed = false;

                    $.each(self.dailyBlock().find('input'), function(i, input) {
                        el = $(input);
                        if (el.is(':checked')) {
                            daily.push(el.val());
                        }
                    });

                    if (type != self.options.value.type || end != self.options.value.end || daily.length != self.options.value.daily.length) {
                        changed = true;
                    }

                    $.each(daily, function(i, d) {
                        if ($.inArray(d, self.options.value.daily) == -1) {
                            changed = true;
                            return false;
                        }
                    });

                    $.each(self.options.value.daily, function(i, d) {
                        if ($.inArray(d, daily) == -1) {
                            changed = true;
                            return false;
                        }
                    });

                    self.changed = changed ? 1 : 0;

                    $(window).trigger('easysocial.fields.recurring.changed', [changed]);
                },

                '{scheduleToggle} click': function(el, ev) {
                    self.scheduleBlock().toggle();
                },

                '{deleteRecurringButton} click': function(el, ev) {
                    EasySocial.dialog({
                        content: EasySocial.ajax('site/views/events/deleteRecurringDialog', {
                            id: self.options.eventId
                        }),
                        bindings: {
                            "{submitButton} click": function()
                            {
                                var dialog = this.parent;

                                dialog.loading(true);

                                self.deleteRecurring()
                                    .done(function() {
                                        dialog.loading(false);

                                        dialog.close();

                                        self.calculateTotalRecur();
                                    });
                            }
                        }
                    })
                },

                deleteRecurring: function() {
                    return EasySocial.ajax('site/controllers/events/deleteRecurring', {
                        eventId: self.options.eventId
                    })
                },

                datetimepicker: function(name, value) {
                    return self.picker().data('DateTimePicker')[name](value);
                },

                setDateValue: function(date) {
                    // Convert the date object into sql format and set it into the input
                    self.result().val(date.getFullYear() + '-' +
                                        ('00' + (date.getMonth()+1)).slice(-2) + '-' +
                                        ('00' + date.getDate()).slice(-2) + ' ' +
                                        ('00' + date.getHours()).slice(-2) + ':' +
                                        ('00' + date.getMinutes()).slice(-2) + ':' +
                                        ('00' + date.getSeconds()).slice(-2));
                },

                '{self} onSubmit': function(el, ev, register) {
                    register.push(true);
                },

                raiseError: function(msg) {
                    self.trigger('error', [msg]);
                },

                clearError: function() {
                    self.trigger('clear');
                }
            }
        });

        module.resolve();
    });
});

EasySocial.module('apps/fields/event/startend/content', function($) {
    
    var module = this;
    var lang = EasySocial.options.momentLang;

    EasySocial
    .require()
    .library('datetimepicker', 'moment/' + lang)
    .language('FIELDS_EVENT_STARTEND_VALIDATION_DATETIME_START_REQUIRED', 'FIELDS_EVENT_STARTEND_VALIDATION_DATETIME_END_REQUIRED')
    .done(function($) {

        EasySocial.Controller('Field.Event.Startend', {
            defaultOptions: {
                dateFormat: '',
                allowTime: true,
                allowTimezone: true,
                disallowPast: false,
                minuteStepping: 15,
                yearfrom: '',
                yearto: '',
                requiredEnd: false,
                allday: false,
                calendarLanguage: 'english',
                dow: 0,

                '{startForm}': '[data-event-start]',
                '{endForm}': '[data-event-end]',

                '{timezone}': '[data-event-timezone]'
            }
        }, function(self) {
            return {
                init: function() {

                    // There is an issue with yearto where if I set yearto = 2014, I won't be able to select 2014 dates. 
                    // This is a bug in datetimepicker. Currently, temporarily, we manually add 1 to the value if there are value set.
                    if (!$.isEmpty(self.options.yearto)) {
                        self.options.yearto = parseInt(self.options.yearto) + 1;
                    } else {
                        self.options.yearto = new Date().getFullYear() + 100
                    }

                    self.options.yearfrom = self.options.yearfrom || 1930;

                    // Add controller on the start date
                    self.startDatetime = self.startForm().addController('EasySocial.Controller.Field.Event.Startend.Form', {
                        '{parent}': self,
                        "type": 'start'
                    });

                    // Add controller on the end date
                    self.endDatetime = self.endForm().addController('EasySocial.Controller.Field.Event.Startend.Form', {
                        '{parent}': self,
                        "type": 'end'
                    });
                },

                '{self} onSubmit': function(el, ev, register) {
                    register.push(self.validateInput());
                },

                validateInput: function() {
                    self.clearError();

                    if ($.isEmpty(self.startDatetime.datetime().val())) {
                        self.raiseError($.language('FIELDS_EVENT_STARTEND_VALIDATION_DATETIME_START_REQUIRED'));

                        return false;
                    }

                    if (self.options.requireEnd && $.isEmpty(self.endDatetime.datetime().val())) {
                        self.raiseError($.language('FIELDS_EVENT_STARTEND_VALIDATION_DATETIME_END_REQUIRED'));

                        return false;
                    }

                    return true;
                },

                raiseError: function(msg) {
                    self.trigger('error', [msg]);
                },

                clearError: function() {
                    self.trigger('clear');
                }
            }
        });

        EasySocial.Controller('Field.Event.Startend.Form', {
            defaultOptions: {
                type: null,

                '{picker}': '[data-picker]',
                '{toggle}': '[data-picker-toggle]',
                '{datetime}': '[data-datetime]'
            }
        }, function(self, options) {

            return {
                init: function() {
                    self.load();
                },

                "{window} easysocial.fields.startend.start.change": function() {

                    // When the start date is changed, set the minimum date on the end date
                    if (options.type == 'start' && self.parent.endDatetime) {
                        self.parent.endDatetime.datetimepicker('destroy');

                        self.parent.endDatetime.load();
                    }
                },


                '{window} easysocial.fields.allday.change': function(el, ev, value) {
                    self.datetimepicker('destroy');

                    self.parent.options.allday = value == 1 ? true : false;

                    self.load();
                },

                // We move this here because there is a possibility that we want to "reinit"
                load: function() {

                    // Generate a minimum date from momentjs
                    var minDate = new $.moment();

                    // If configured to disallow past dates, we need to minus 1 on the date as we need to allow today.
                    if (self.parent.options.disallowPast) {
                        minDate.date(minDate.date() - 1);
                    } else {
                        minDate.year(self.parent.options.yearfrom);
                    }

                    // If this type is end date, we need to set the minimum date based on the start date
                    if (options.type == 'end') {
                        var startDatetimeValue = self.parent.startDatetime.datetime().val();

                        if (startDatetimeValue) {
                            var minDate = $.moment(startDatetimeValue);
                            
                            // minus 1 on the date as we need to allow today.
                            var minDate = minDate.date(minDate.date() - 1);
                        }
                    }

                    var allowTime = self.parent.options.allowTime && !self.parent.options.allday;
                    var dateFormat = self.parent.options.dateFormat;

                    // If time is not allowed, then we remove the time part
                    // Since the format is always (10 chars) (remaining chars)
                    // We just substr by 10 chars
                    if (!allowTime) {
                        dateFormat = dateFormat.substr(0, 10);
                    }

                    self.picker()._datetimepicker({
                        component: "es",
                        useCurrent: false,
                        format: dateFormat,
                        minDate: minDate,
                        maxDate: new $.moment({y: self.parent.options.yearto}),
                        icons: {
                            time: 'glyphicon glyphicon-time',
                            date: 'glyphicon glyphicon-calendar',
                            up: 'glyphicon glyphicon-chevron-up',
                            down: 'glyphicon glyphicon-chevron-down'
                        },
                        sideBySide: false,
                        pickTime: allowTime,
                        minuteStepping: parseInt(self.parent.options.minuteStepping),
                        language: self.parent.options.calendarLanguage == 'english' ? 'en-gb' : lang,
                        dow: self.parent.options.dow
                    });

                    var date = self.datetime().val();

                    // Datetimepicker is using moment.js, hence here we manually create a moment object to pass in instead of passing in date time string
                    // This is because datetimepicker.setDate function passes along the format from self.options.calendarDateFormat to generate the date object, which will render moment.js to generate an invalid dateobject
                    // self.options.calendarDateFormat is only for display purposes
                    // Raw date object is always in SQL format
                    if (!$.isEmpty(date)) {
                        var dateObj = $.moment(date);

                        self.datetimepicker('setDate', dateObj);
                    }
                },

                datetimepicker: function(name, value) {
                    return self.picker().data('DateTimePicker')[name](value);
                },

                '{toggle} click': function() {
                    self.picker().focus();
                },

                '{picker} dp.change': function(el, ev) {

                    self.setDateValue(ev.date.toDate());

                    // easysocial.fields.startend.start.change
                    // easysocial.fields.startend.end.change
                    $(window).trigger('easysocial.fields.startend.' + options.type + '.change', [ev.date]);
                },

                '{picker} change': function(el, ev) {
                    if ($.isEmpty(el.val())) {
                        self.datetime().val('');
                    }
                },

                setDateValue: function(date) {
                    // Convert the date object into sql format and set it into the input
                    self.datetime().val(date.getFullYear() + '-' +
                                        ('00' + (date.getMonth()+1)).slice(-2) + '-' +
                                        ('00' + date.getDate()).slice(-2) + ' ' +
                                        ('00' + date.getHours()).slice(-2) + ':' +
                                        ('00' + date.getMinutes()).slice(-2) + ':' +
                                        ('00' + date.getSeconds()).slice(-2));
                }

                /*'{clear} click': function(el, ev) {
                    // Brute force way to clear the datetimepicker
                    self.datetimepicker('setValue', new $.moment());

                    self.picker().val('');

                    self.datetime().val('');

                    el.hide();

                    self.parent.element.trigger('event' + $.String.capitalize(self.options.type), [null]);
                },*/
            }
        });

        module.resolve();
    });
});

EasySocial.module('apps/fields/event/startend/display', function($) {
    var module = this;

    EasySocial
    .require()
    .library('chosen', 'popbox')
    .language('FIELDS_USER_DATETIME_LOCAL_TIMEZONE', 'FIELDS_USER_DATETIME_TIMEZONE_CHECKING')
    .done(function($) {
        EasySocial.Controller('Field.Event.Startend.Display', {
            defaultOptions: {
                id: null,

                userid: null,

                '{box}': '[data-startend-box]'
            }
        }, function(self) {
            return {
                init: function() {
                    self.box().addController('EasySocial.Controller.Field.Event.Startend.Display.Box', {
                        '{parent}': self
                    });
                }
            }
        });

        EasySocial.Controller('Field.Event.Startend.Display.Box', {
            defaultOptions: {
                date: null,

                timezone: null,

                local: null,

                '{toggle}': '[data-popbox]',

                '{content}': '[data-popbox-content]',

                '{date}': '[data-date]',

                '{timezone}': '[data-timezone]',

                '{loading}': '[data-loading]'
            }
        }, function(self) {
            return {
                init: function() {
                    self.options.timezone = self.timezone().data('timezone');

                    self.options.date = self.date().data('date-utc');

                    // Get the local timezone first through client browser
                    self.options.local = -new Date().getTimezoneOffset()/60;

                    var content = self.content().html(),
                        position = self.toggle().data('popbox-position');

                    self.toggle().popbox({
                        content: content,
                        id: 'fd',
                        component: 'es',
                        type: 'timezone',
                        toggle: 'click',
                        position: position
                    }).attr('data-popbox', '');
                },

                '{toggle} popboxActivate': function(el, event, popbox) {
                    popbox.tooltip.addController('EasySocial.Controller.Field.Event.Startend.Display.Timezone', {
                        '{parent}': self
                    });
                },

                datetime: $.memoize(function(tz) {
                    return EasySocial.ajax('fields/event/startend/getDatetime', {
                        id: self.parent.options.id,
                        userid: self.parent.options.userid,
                        tz: tz,
                        local: self.options.local,
                        datetime: self.options.date
                    });
                })
            }
        });

        EasySocial.Controller('Field.Event.Startend.Display.Timezone', {
            defaultOptions: {
                '{timezones}': '[data-timezone-select]',
                '{reset}': '[data-timezone-reset]',
                '{local}': '[data-timezone-local]'
            }
        }, function(self) {
            return {
                init: function() {
                    self.timezones().chosen({
                        search_contains: true
                    });
                },

                '{timezones} change': function(el, event) {
                    var key = el.val();

                    self.parent.date().html($.language('FIELDS_USER_DATETIME_TIMEZONE_CHECKING'));
                    self.parent.timezone().html(key === 'local' ? $.language('FIELDS_USER_DATETIME_LOCAL_TIMEZONE') : key);

                    self.parent.datetime(key).done(function(value) {
                        self.parent.date().html(value);
                    });
                },

                '{reset} click': function() {
                    self.setTimezone(self.parent.options.timezone);
                },

                '{local} click': function() {
                    self.setTimezone('local')
                },

                setTimezone: function(tz) {
                    self.timezones()
                        .val(tz)
                        .trigger('liszt:updated')
                        .trigger('change');
                }
            }
        });

        module.resolve();
    });
});

EasySocial.module('apps/fields/group/permalink/content', function($) {
    var module = this;

    EasySocial
        .require()
        .language(
            'PLG_FIELDS_GROUP_PERMALINK_EXCEEDED_MAX_LENGTH',
            'PLG_FIELDS_GROUP_PERMALINK_REQUIRED')
        .done(function($) {

            EasySocial.Controller(
                'Field.Group.Permalink',
                {
                    defaultOptions:
                    {
                        required: false,

                        max     : 0,

                        id      : null,
                        groupid : null,
                        userid  : null,

                        '{field}'           : '[data-field-permalink]',

                        '{checkButton}'     : '[data-permalink-check]',
                        '{input}'           : '[data-permalink-input]',
                        '{available}'       : '[data-permalink-available]'
                    }
                },
                function(self)
                {
                    return {
                        state: false,

                        init: function()
                        {
                            self.options.max = self.field().data('max');
                        },

                        "{checkButton} click" : function()
                        {
                            self.delayedCheck();
                        },

                        "{input} keyup" : function()
                        {
                            self.delayedCheck();
                        },

                        delayedCheck: $.debounce(function()
                        {
                            self.checkPermalink();
                        }, 250),

                        checkPermalink: function()
                        {
                            self.clearError();

                            var permalink   = self.input().val();

                            self.available().hide();

                            if (self.options.max > 0 && permalink.length > self.options.max) {
                                self.raiseError($.language('PLG_FIELDS_GROUP_PERMALINK_EXCEEDED_MAX_LENGTH'));
                                return false;
                            }

                            if (!$.isEmpty(permalink)) {
                                self.checkButton().addClass('btn-loading');

                                var state = $.Deferred();

                                EasySocial.ajax('fields/group/permalink/isValid', {
                                    "id"        : self.options.id,
                                    "groupid"   : self.options.groupid,
                                    "permalink" : permalink
                                })
                                .done(function(msg) {
                                    self.clearError();

                                    self.checkButton().removeClass('btn-loading');

                                    self.available().show();

                                    state.resolve();
                                })
                                .fail(function(msg) {
                                    self.raiseError(msg);

                                    self.checkButton().removeClass('btn-loading');

                                    self.available().hide();

                                    state.reject();
                                });

                                return state;
                            }

                            if (self.options.required && $.isEmpty(permalink)) {
                                self.available().hide();

                                self.raiseError($.language('PLG_FIELDS_GROUP_PERMALINK_REQUIRED'));
                                return false;
                            }

                            return true;
                        },

                        raiseError: function(msg)
                        {
                            self.trigger('error', [msg]);
                        },

                        clearError: function()
                        {
                            self.trigger('clear');
                        },

                        '{self} onSubmit': function(el, ev, register)
                        {
                            register.push(self.checkPermalink());
                        }
                    }
                }
            );

            module.resolve();
        });
});

EasySocial.module('apps/fields/group/permalink/sample_content', function($) {
    var module = this;

    EasySocial.Controller('Field.Permalink.Sample', {
        defaultOptions: {
            '{checkPermalink}'      : '[data-check-permalink]'
        }
    }, function(self) {
        return {
            init: function() {

            },

            '{self} onConfigChange': function(el, event, name, value) {
                switch(name) {
                    case 'check_permalink':
                        self.checkPermalink().toggle(!!value);
                    break;
                }
            }
        }
    });

    module.resolve();
});

EasySocial.module('apps/fields/user/address/content', function($) {
    var module = this;

    EasySocial.require()
        .library('gmaps')
        .language(
            'PLG_FIELDS_ADDRESS_PLEASE_ENTER_ADDRESS1',
            'PLG_FIELDS_ADDRESS_PLEASE_ENTER_ADDRESS2',
            'PLG_FIELDS_ADDRESS_PLEASE_ENTER_CITY',
            'PLG_FIELDS_ADDRESS_PLEASE_ENTER_STATE',
            'PLG_FIELDS_ADDRESS_PLEASE_ENTER_ZIP',
            'PLG_FIELDS_ADDRESS_PLEASE_ENTER_COUNTRY')
        .done(function() {
            EasySocial.Controller('Field.Address', {
                defaultOptions: {
                    required        : {},
                    show            : {},

                    "{field}"       : "[data-field-address]",

                    "{address1}"    : "[data-field-address-address1]",
                    "{address2}"    : "[data-field-address-address2]",
                    "{city}"        : "[data-field-address-city]",
                    "{state}"       : "[data-field-address-state]",
                    "{country}"     : "[data-field-address-country]",
                    "{zip}"         : "[data-field-address-zip]",

                    '{required}'    : '[data-required]',

                    '{notice}'      : '[data-check-notice]'
                }
            }, function(self) {
                return {
                    init : function() {
                    },

                    fields: [
                        'address1',
                        'address2',
                        'city',
                        'state',
                        'zip',
                        'country'
                    ],

                    validateInput : function() {
                        self.clearError();

                        var errorRaised = false;

                        self.clearError();

                        $.each(self.fields, function(i, field) {
                            var el = self[field]();

                            el.removeClass('has-error');

                            var val = el.val();

                            if($.isEmpty(val) && self.options.required[field] && self.options.show[field])
                            {
                                el.addClass('has-error');

                                if(!errorRaised) {
                                    self.raiseError($.language('PLG_FIELDS_ADDRESS_PLEASE_ENTER_' + field.toUpperCase()));

                                    errorRaised = true;
                                }

                            }
                        });

                        return true;
                    },

                    '{address1}, {address2}, {zip}, {city}, {state} blur': function() {
                        self.validateInput();
                    },

                    '{country} change': function(el) {
                        self.validateInput();

                        if (self.state().is('select')) {
                            EasySocial.ajax('fields/user/address/getStates', {
                                id: self.options.id,
                                country: el.val()
                            }).done(function(states) {
                                self.state().html('');

                                $.each(states, function(code, name) {
                                    var option = $('<option></option>').html(name).val(name).appendTo(self.state());
                                });
                            });
                        }
                    },

                    raiseError: function(msg) {
                        // self.trigger('error', [msg]);

                        self.notice()
                            .css('color', '#a94442')
                            .text(msg)
                            .parent('.controls-error')
                            .show();
                    },

                    clearError: function() {
                        self.notice()
                            .parent('.controls-error')
                            .hide();
                    },

                    "{self} onSubmit" : function(el, event, register) {
                        register.push(self.validateInput());
                    },

                    "{self} onConfigChange": function(el, event, name, value) {
                        var requires = ['address1', 'address2', 'city', 'zip', 'state', 'country'];

                        if($.inArray(name, requires) >= 0) {
                            self.options.required[name] = !!value;
                        }

                        self.required().hide();

                        $.each(requires, function(i, t) {
                            if(self.options[t]) {
                                self.required().show();
                                return false;
                            }
                        });
                    }
                }
            });

            module.resolve();
        });
});

EasySocial.module('apps/fields/user/address/display_content', function($) {
    var module = this;

    EasySocial
    .require()
    .library('gmaps')
    .done(function() {
        EasySocial.Controller('Field.Address.Display', {
            defaultOptions: {
                latitude: null,
                longitude: null,
                ratio: 1,

                '{base}': '[data-location-base]',

                '{map}': '[data-location-map]',
                '{mapImage}': '[data-location-map-image]'
            }
        }, function(self) {
            return {
                init: function() {
                    // Init params
                    var map = self.map();

                    self.options.latitude = map.data('latitude');
                    self.options.longitude = map.data('longitude');

                    self.setLayout();
                },

                '{window} resize': $.debounce(function() {
                    self.setLayout();
                }, 250),

                navigate: function(lat, lng) {
                    var mapImage = self.mapImage(),
                        width = Math.floor(mapImage.width()),
                        height = Math.floor(mapImage.height()),
                        url = $.GMaps.staticMapURL({
                            size: [1280, 1280],
                            lat: lat,
                            lng: lng,
                            sensor: true,
                            scale: 2,
                            markers: [
                                {lat: lat, lng: lng}
                            ]
                        });

                    var url = url.replace(/http\:|https\:/, '');
                    
                    // When map is loaded, fade in.
                    $.Image.get(url)
                        .done(function(){
                            mapImage.css({
                                "backgroundImage": $.cssUrl(url),
                                "backgroundSize": "cover",
                                "backgroundPosition": "center center"
                            });
                            self.base().addClass("has-location");
                        })
                        .always(function(){
                            self.base().removeClass("is-loading");
                        });
                },

                setLayout: function() {
                    setTimeout(function() {
                        if (self.options.latitude && self.options.longitude) {
                            self.navigate(self.options.latitude, self.options.longitude);
                        }
                    }, 1);
                },

                '{self} onShow': function() {
                    self.setLayout();
                }
            }
        });

        module.resolve();
    });
});

EasySocial.module('apps/fields/user/address/maps', function($) {
    var module = this;

    // Create search template first
    $.template('easysocial/maps.suggestion', '<div class="es-story-location-suggestion" data-location-suggestion><span class="formatted_address">[%= location.formatted_address %]</span></div>');

    EasySocial
    .require()
    .library('gmaps', 'placeholder', 'image')
    .language(
        "COM_EASYSOCIAL_LOCATION_PERMISSION_ERROR",
        "COM_EASYSOCIAL_LOCATION_TIMEOUT_ERROR",
        "COM_EASYSOCIAL_LOCATION_UNAVAILABLE_ERROR",
        "COM_EASYSOCIAL_STREAM_AT"
    )
    .done(function() {

        // Constants
        var KEYCODE = {
            BACKSPACE: 8,
            COMMA: 188,
            DELETE: 46,
            DOWN: 40,
            ENTER: 13,
            ESCAPE: 27,
            LEFT: 37,
            RIGHT: 39,
            SPACE: 32,
            TAB: 9,
            UP: 38
        };

        EasySocial.Controller('Field.Address.Maps', {
            defaultOptions: {
                required            : null,

                zoom                : 2,

                latitude            : null,
                longitude           : null,
                address             : null,

                singleLocation      : true,

                required            : false,

                ratio               : 3,

                '{field}'           : '[data-field-address]',

                '{base}'            : '[data-location-base]',

                '{map}'             : '[data-location-map]',
                '{mapImage}'        : '[data-location-map-image]',

                '{detectButton}'    : '[data-location-detect]',
                '{removeButton}'    : '[data-location-remove]',

                '{form}'            : '[data-location-form]',
                '{textbox}'         : '[data-location-textbox]',
                '{textField}'       : '[data-location-textfield]',

                '{autocomplete}'    : '[data-location-autocomplete]',
                '{suggestions}'     : '[data-location-suggestions]',
                '{suggestion}'      : '[data-location-suggestion]',

                '{source}'          : '[data-location-source]',

                view: {
                    suggestion: 'maps.suggestion'
                }
            }
        }, function(self) {
            return {
                init: function() {
                    if (navigator.geolocation) {
                        self.base().addClass("is-detectable");
                        // self.detectButton().show();
                    }

                    // Add placeholder support for IE9
                    self.textField().placeholder();

                    // Allow textField input only when controller is implemented
                    self.textField().removeAttr("disabled");

                    if (!$.isEmpty(self.source().val())) {
                        var data = JSON.parse(self.source().val());

                        if (data.latitude && data.longitude) {
                            self.navigate(data.latitude, data.longitude);

                            self.base().addClass("has-location");
                        }
                    }
                },

                "{window} resize": $.debounce(function() {

                    var data = JSON.parse(self.source().val());

                    if (!data.latitude || !data.longitude) {
                        return;
                    }

                    var mapImage = self.mapImage();

                    if (mapImage.data("width") !== mapImage.width()) {
                        self.navigate(data.latitude, data.longitude);
                    }

                }, 250),

                '{self} onShow': function() {

                    var data = JSON.parse(self.source().val());

                    if (!data.latitude || !data.longitude) {
                        return;
                    }

                    var mapImage = self.mapImage();

                    if (mapImage.data("width") !== mapImage.width()) {
                        self.navigate(data.latitude, data.longitude);
                    }
                },

                navigate: function(lat, lng) {
                    self.field().css({
                        "max-width": "none"
                    });

                    var mapImage = self.mapImage(),
                        width = Math.floor(mapImage.width()),
                        height = Math.floor(mapImage.height()),
                        url = $.GMaps.staticMapURL({
                            size: [1280, 1280],
                            lat: lat,
                            lng: lng,
                            sensor: true,
                            scale: 2,
                            markers: [
                                {lat: lat, lng: lng}
                            ]
                        });

                    // When map is loaded, fade in.
                    $.Image.get(url)
                        .done(function(){
                            mapImage.css({
                                "backgroundImage": $.cssUrl(url),
                                "backgroundSize": "cover",
                                "backgroundPosition": "center center"
                            });
                            self.base().addClass("has-location");
                        })
                        .always(function(){
                            self.base().removeClass("is-loading");
                        });
                },

                locations: {},

                lastQueryAddress: null,

                results: [],

                result: null,

                "{textField} keypress": function(textField, event) {

                    switch (event.keyCode)
                    {
                        case KEYCODE.UP:

                            var prevSuggestion = $(
                                self.suggestion(".active").prev(self.suggestion.selector)[0] ||
                                self.suggestion(":last")[0]
                            );

                            // Remove all active class
                            self.suggestion().removeClass("active");

                            prevSuggestion
                                .addClass("active")
                                .trigger("activate");

                            self.suggestions()
                                .scrollTo(prevSuggestion, {
                                    offset: prevSuggestion.height() * -1
                                });

                            event.preventDefault();

                            break;

                        case KEYCODE.DOWN:

                            var nextSuggestion = $(
                                self.suggestion(".active").next(self.suggestion.selector)[0] ||
                                self.suggestion(":first")[0]
                            );

                            // Remove all active class
                            self.suggestion().removeClass("active");

                            nextSuggestion
                                .addClass("active")
                                .trigger("activate");

                            self.suggestions()
                                .scrollTo(nextSuggestion, {
                                    offset: nextSuggestion.height() * -1
                                });

                            event.preventDefault();

                            break;

                        case KEYCODE.ENTER:

                            var activeSuggestion = self.suggestion(".active"),
                                location = activeSuggestion.data("location");
                                self.set(location);

                            self.hideSuggestions();
                            break;

                        case KEYCODE.ESCAPE:
                            self.hideSuggestions();
                            break;
                    }

                },

                "{textField} keyup": function(textField, event) {

                    switch (event.keyCode) {

                        case KEYCODE.UP:
                        case KEYCODE.DOWN:
                        case KEYCODE.LEFT:
                        case KEYCODE.RIGHT:
                        case KEYCODE.ENTER:
                        case KEYCODE.ESCAPE:
                            // Don't repopulate if these keys were pressed.
                            break;

                        default:
                            var address = $.trim(textField.val());

                            if (address==="") {
                                self.base().removeClass("has-location");
                                self.hideSuggestions();
                            }

                            // if (address==self.lastQueryAddress) return;

                            var locations = self.locations[address];

                            // If this location has been searched before
                            if (locations) {

                                // And set our last queried address to this address
                                // so that it won't repopulate the suggestion again.
                                self.lastQueryAddress = address;

                                // Just use cached results
                                self.suggest(locations);

                            // Else ask google to find it out for us
                            } else {

                                self.lookup(address);
                            }
                            break;
                    }
                },

                lookup: $.debounce(function(address) {

                    self.base().addClass("is-busy");

                    $.GMaps.geocode({
                        address: address,
                        callback: function(locations, status) {

                            self.base().removeClass("is-busy");

                            if (status=="OK") {

                                // Store a copy of the results
                                self.locations[address] = locations;

                                // Suggestion locations
                                self.suggest(locations);

                                self.lastQueryAddress = address;
                            }
                        }
                    });

                }, 250),

                suggest: function(locations) {

                    var suggestions = self.suggestions();

                    // Clear location suggestions
                    suggestions
                        .empty();

                    if (locations.length < 0) return;

                    self.results = locations;

                    $.each(locations, function(i, location){
                        // Create suggestion and append to list
                        self.view.suggestion({
                                location: location
                            })
                            .data("location", location)
                            .appendTo(suggestions);
                    });

                    self.showSuggestions();
                },

                showSuggestions: function() {

                    self.focusSuggestion = true;

                    self.element.find(".es-story-footer")
                        .addClass("swap-zindex");

                    setTimeout(function(){

                        self.autocomplete().addClass("active");

                        var doc = $(document),
                            hideOnClick = "click.es.story.location";

                        doc
                            .off(hideOnClick)
                            .on(hideOnClick, function(event){

                                // Collect list of bubbled elements
                                var targets = $(event.target).parents().andSelf();

                                if (targets.filter(self.element).length > 0) return;

                                doc.off(hideOnClick);

                                self.hideSuggestions();
                            });

                    }, 500);
                },

                hideSuggestions: function() {

                    self.focusSuggestion = false;

                    self.autocomplete().removeClass("active");

                    $(document).off("click.es.story.location");

                    setTimeout(function(){

                        if (self.focusSuggestion) return;

                        self.element.find(".es-story-footer")
                            .removeClass("swap-zindex");

                    }, 500);
                },

                "{suggestion} activate": function(suggestion, event) {

                    var location = suggestion.data("location");

                    self.navigate(
                        location.geometry.location.lat(),
                        location.geometry.location.lng()
                    );
                },

                "{suggestion} mouseover": function(suggestion) {

                    // Remove all active class
                    self.suggestion().removeClass("active");

                    suggestion
                        .addClass("active")
                        .trigger("activate");
                },

                "{suggestion} click": function(suggestion, event) {

                    var location = suggestion.data("location");

                    self.set(location);

                    self.hideSuggestions();
                },

                set: function(location) {

                    self.currentLocation = location;

                    var lat = location.geometry.location.lat(),
                        lng = location.geometry.location.lng();

                    self.navigate(lat, lng);

                    var address = location.formatted_address;

                    self.textField().val(address);

                    self.lastQueryAddress = address;

                    self.base().addClass("has-location");

                    // Set the source here
                    self.result = location;
                    var data = self.getResult('source');
                    self.source().val(JSON.stringify(data));
                },

                unset: function() {

                    self.currentLocation = null;

                    self.textField().val('');

                    self.mapImage().attr("src", "");

                    self.base().removeClass("has-location");

                    self.source().val('');
                },

                detectTimer: null,

                "{detectButton} click": function() {

                    var textbox = self.textbox();

                    self.base().addClass("is-busy");

                    clearTimeout(self.detectTimer);

                    self.detectTimer = setTimeout(function() {
                        self.base().removeClass("is-busy");
                    }, 8000);

                    $.GMaps.geolocate({
                        success: function(position) {
                            $.GMaps.geocode({
                                lat: position.coords.latitude,
                                lng: position.coords.longitude,
                                callback: function(locations, status) {
                                    if (status=="OK") {
                                        self.suggest(locations);
                                        self.textField().focus();
                                    }
                                }
                            });
                        },
                        error: function(error) {
                            var message = "";

                            switch (error.code) {

                                case 1:
                                    message = $.language("COM_EASYSOCIAL_LOCATION_PERMISSION_ERROR");
                                    break;

                                case 2:
                                    message = $.language("COM_EASYSOCIAL_LOCATION_TIMEOUT_ERROR");
                                    break;

                                case 3:
                                default:
                                    message = $.language("COM_EASYSOCIAL_LOCATION_UNAVAILABLE_ERROR");
                                    break;
                            }

                            // story.setMessage(message);
                        },
                        always: function() {
                            clearTimeout(self.detectTimer);
                            self.base().removeClass("is-busy");
                        }
                    });
                },

                "{removeButton} click": function() {
                    self.unset();
                    self.hideSuggestions();
                },

                getResult: function(type) {
                    if(!self.result) {
                        if(self.results.length === 0) {
                            return false;
                        }

                        self.result = self.results[0];
                    }

                    var r = self.result;

                    if(type === undefined) {
                        return r;
                    }

                    switch(type) {
                        case 'coords':
                            return {
                                lat: r.geometry.location.lat(),
                                lng: r.geometry.location.lng()
                            }
                        break;

                        case 'lat':
                        case 'latitude':
                            return r.geometry.location.lat();
                        break;

                        case 'lng':
                        case 'longitude':
                            return r.geometry.location.lng();
                        break;

                        case 'address':
                            return r.formatted_address;
                        break;

                        case 'viewport':
                            return r.geometry.viewport;
                        break;

                        case 'bounds':
                            return r.geometry.bounds || r.geometry.viewport;
                        break;

                        case 'source':
                            var components = {};

                            $.each(r.address_components, function(index, component) {
                                if(component.types[0]) {
                                    components[component.types[0]] = component.long_name;
                                }
                            });

                            var mapping = {
                                'address1': ['street_address', 'route'],
                                'address2': ['intersection', 'colloquial_area', 'neighborhood', 'premise', 'subpremise'],
                                'city': ['locality', 'sublocality', 'sublocality_level_1', 'sublocality_level_2', 'sublocality_level_3', 'sublocality_level_4', 'sublocality_level_5'],
                                'state': ['administrative_area_level_1', 'administrative_area_level_2', 'administrative_area_level_3'],
                                'zip': 'postal_code',
                                'country': 'country'
                            };

                            // Based on the mapping we build the legacy data
                            var legacy = {};

                            $.each(mapping, function(key, value) {

                                // Init with empty data
                                legacy[key] = '';

                                if ($.isArray(value)) {
                                    $.each(value, function(i, v) {

                                        // Search if components[v] exists
                                        if (components[v] !== undefined) {

                                            // Use it if it exists
                                            legacy[key] = components[v];

                                            // Break out and ignore other possible keys
                                            return false;
                                        } else {

                                            // Continue finding
                                            return true;
                                        }
                                    });

                                    // Continue on to the next key
                                    return true;
                                }

                                if (components[value] !== undefined) {
                                    legacy[key] = components[value];
                                }
                            });

                            var data = $.extend(legacy, {
                                components: components,
                                address: r.formatted_address,
                                latitude: r.geometry.location.lat(),
                                longitude: r.geometry.location.lng()
                            });

                            return data;
                        break;
                    }
                }
            }
        });

        module.resolve();
    });
});

EasySocial.module('apps/fields/user/avatar/content', function($) {
    var module = this;

    EasySocial
        .require()
        .library('image', 'imgareaselect')
        .stylesheet('imgareaselect/default')
        .language('PLG_FIELDS_AVATAR_VALIDATION_EMPTY_PROFILE_PICTURE')
        .done(function(){

            EasySocial.Controller('Field.Avatar', {
                defaultOptions: {
                    required        : false,

                    id              : 0,

                    group           : null,

                    origSource      : null,

                    defaultAvatar   : null,

                    hasAvatar       : null,

                    '{field}'       : '[data-field-avatar]',

                    '{gallery}'     : '[data-field-avatar-gallery]',
                    '{galleryList}' : '[data-field-avatar-gallery-items]',
                    '{galleryItem}' : '[data-field-avatar-gallery-item]',

                    '{frame}'       : '[data-field-avatar-frame]',
                    '{viewport}'    : '[data-field-avatar-viewport]',

                    '{avatarSource}': '[data-field-avatar-source]',
                    '{avatarData}'  : '[data-field-avatar-data]',
                    '{avatarPath}'  : '[data-field-avatar-path]',
                    '{avatarType}'  : '[data-field-avatar-type]',
                    '{avatarName}'  : '[data-field-avatar-name]',

                    '{file}'        : '[data-field-avatar-file]',
                    '{image}'       : '[data-field-avatar-selected]',

                    '{note}'        : '[data-field-avatar-note]',

                    '{actions}'     : '[data-field-avatar-actions]',

                    '{cancel}'      : '[data-field-avatar-actions-cancel]',
                    '{crop}'        : '[data-field-avatar-actions-crop]',

                    '{removeFrame}' : '[data-field-avatar-remove]',
                    '{remove}'      : '[data-field-avatar-remove-button]',
                    '{revertFrame}' : '[data-field-avatar-revert]',
                    '{revert}'      : '[data-field-avatar-revert-button]',

                    '{loader}'      : '[data-field-avatar-loader]'
                }
            }, function(self) {
                return {
                    init: function() {
                        // Store the original photo first
                        // self.options.origSource = $.uri(self.frame().css('backgroundImage')).extract(0);

                        self.state = !!self.options.hasAvatar;
                    },

                    state: true,

                    "{file} change": function(el, event) {

                        if($.isEmpty(el.val())) {
                            return;
                        }

                        // Compatibility with input-group
                        var label = el.val().replace(/\\/g, '/').replace(/.*\//, '');
                        el.parents('.input-group').find(':text').val(label);

                        // Set state to false
                        self.state = false;

                        // Show the loader
                        self.loader().show();

                        // Hide the previous picture
                        self.frame().hide();

                        // Hide the file upload field
                        self.file().hide();

                        // Hide the error frame
                        self.clearError();

                        EasySocial.ajax('fields/' + self.options.group + '/avatar/upload', {
                            id: self.options.id,
                            files: el
                        }, {
                            type: "iframe"
                        })
                        .done(function(raw, uri, path) {

                            // Set the name of the image
                            self.avatarName().val(raw.name);

                            // Set the source of the image
                            self.avatarSource().val(uri);

                            // Set the path of the image
                            self.avatarPath().val(path);

                            // Set the type as upload
                            self.avatarType().val('upload');

                            // Load the imgareaselect for cropping
                            self.setLayout(uri);

                            // Unset all gallery item
                            self.galleryItem().removeClass('active');

                            // Hide the remove button
                            self.removeFrame().hide();

                            // Hide the revert button
                            self.revertFrame().hide();

                            // Set state to true
                            self.state = true;
                        })
                        .fail(function(msg) {
                            self.loader().hide();

                            self.raiseError(msg);

                            self.file().show().val('');

                            self.frame().show();
                        });
                    },

                    setLayout: function(img) {
                        var loader = $.Image.get(img),
                            frame = self.frame();

                        loader.done(function(el, image) {
                            frame.css('background-image', $.cssUrl(img));

                            frame.addClass('avatar-frame-crop');

                            frame.show();

                            self.loader().hide();

                            self.actions().show();

                            self.note().show();

                            self.viewport().imgAreaSelect({remove: true});

                            self.viewport().show();

                            var size = $.Image.resizeWithin(
                                    image.width,
                                    image.height,
                                    frame.width(),
                                    frame.height()
                                ),
                                min = Math.min(size.width, size.height),
                                x1  = Math.floor((size.width  - min) / 2),
                                y1  = Math.floor((size.height - min) / 2),
                                x2  = x1 + min,
                                y2  = y1 + min;

                            self.viewport()
                                .css(size)
                                // .css('position', 'absolute')
                                .imgAreaSelect({
                                    handles: true,
                                    aspectRatio: '1:1',
                                    parent: frame,
                                    x1: x1,
                                    y1: y1,
                                    x2: x2,
                                    y2: y2,
                                    onSelectEnd: function(viewport, selection) {
                                        var hasSelection = !(selection.width=="0" && selection.height=="0");
                                        if(hasSelection) {
                                            var string = JSON.stringify(self.data());

                                            self.avatarData().val(string);
                                        }
                                    }
                                })
                        });
                    },

                    '{cancel} click': function() {
                        self.actions().hide();

                        self.note().hide();

                        self.frame().hide();

                        self.file().show();

                        self.file().val('');

                        self.file().parents('.input-group').find(':text').val('');

                        self.avatarSource().val('');

                        self.avatarPath().val('');

                        self.avatarData().val('');

                        self.avatarType().val('');

                        self.viewport()
                            .hide()
                            .imgAreaSelect({remove: true});

                        if(!$.isEmpty(self.options.origSource)) {
                            self.frame()
                                .css('background-image', $.cssUrl(self.options.origSource))
                                .removeClass('avatar-frame-crop')
                                .show();
                        }

                        if(self.options.hasAvatar) {
                            self.removeFrame().show();
                        }
                    },

                    data: function() {
                        var viewport = self.viewport(),

                            width  = viewport.width(),

                            height = viewport.height(),

                            selection =
                                viewport
                                    .imgAreaSelect({instance: true})
                                    .getSelection(),

                            data = {
                                // id    : self.photoId().val(),
                                // uid   : self.userId().val(),
                                top   : selection.y1 / height,
                                left  : selection.x1 / width,
                                width : selection.width / width,
                                height: selection.height / height
                            };

                        return data;
                    },

                    '{gallery} click': function() {
                        self.galleryList().toggle();
                    },

                    '{galleryItem} click': function(el, event) {
                        // If this item is not previously selected then only we proceed
                        if(!el.hasClass('active')) {


                            // Get the id
                            var id = el.data('id');

                            // Remove all other item selected state
                            self.galleryItem().removeClass('active');

                            // Set this item as selected
                            el.addClass('active');

                            // Set state to false
                            self.state = false;

                            // Show the loader
                            self.loader().show();

                            // Hide the previous picture
                            self.frame().hide();

                            // Hide the file upload field
                            self.file().hide();

                            // Clear the file input
                            self.file().val('');
                            self.file().parents('.input-group').find(':text').val('');

                            // Hide the error frame
                            self.clearError();

                            // Set the type as gallery
                            self.avatarType().val('gallery');

                            // Set the source id
                            self.avatarSource().val(id);

                            // Get the avatar source
                            EasySocial.ajax('fields/user/avatar/loadDefault', {
                                "avatarId": id
                            }).done(function(uri) {

                                // Set the image preview
                                self.frame().css('background-image', 'url(' + uri + ')');

                                // Show the image
                                self.frame().show();

                                // Remove crop class
                                self.frame().removeClass('avatar-frame-crop');

                                // Hide the loader
                                self.loader().hide();

                                // Hide the viewport
                                self.viewport().hide();

                                // Remove the imgareaselect from viewport
                                self.viewport().imgAreaSelect({remove: true});

                                // Hide the actions
                                self.actions().hide();

                                // Hide the note
                                self.note().hide();

                                // Show the file upload field
                                self.file().show();

                                // Show the revert button
                                self.revertFrame().show();

                                // Hide the remove button
                                self.removeFrame().hide();

                                // Set state to true
                                self.state = true;
                            });
                        }
                    },

                    '{remove} click': function() {
                        self.avatarType().val('remove');

                        self.frame().css('background-image', $.cssUrl(self.options.defaultAvatar));

                        self.removeFrame().hide();

                        if(self.options.hasAvatar) {
                            self.revertFrame().show();
                        }

                        self.state = false;
                    },

                    '{revert} click': function() {
                        self.avatarType().val('');

                        self.frame().css('background-image', $.cssUrl(self.options.origSource));

                        if(self.options.hasAvatar) {
                            self.removeFrame().show();
                        }

                        self.revertFrame().hide();

                        self.galleryItem().removeClass('active');

                        self.state = true;
                    },

                    '{self} onSubmit': function(el, event, register) {
                        if(self.options.required) {
                            if(!self.state) {
                                self.raiseError($.language('PLG_FIELDS_AVATAR_VALIDATION_EMPTY_PROFILE_PICTURE'));
                            }

                            register.push(self.state);
                        }
                    },

                    raiseError: function(msg) {
                        self.trigger('error', [msg]);
                    },

                    clearError: function() {
                        self.trigger('clear');
                    }
                }
            });

            module.resolve();
    });
});

EasySocial.module('apps/fields/user/avatar/sample_content', function($) {
    var module = this;

    EasySocial.Controller('Field.Avatar.Sample', {
        defaultOptions: {
            '{upload}': '[data-avatar-upload]',

            '{gallery}': '[data-avatar-gallery]',

            '{galleryTitle}': '[data-avatar-gallery-title]',

            '{galleryButton}': '[data-avatar-gallery-button]',

            '{gallerySelection}': '[data-avatar-gallery-selection]'
        }
    }, function(self) {
        return {
            '{self} onConfigChange': function(el, event, name, value) {
                switch(name) {
                    case 'upload':
                        self.upload().toggle(value);
                    break;

                    case 'gallery':
                        self.gallery().toggle(value);
                    break;

                    case 'use_gallery_button':
                        self.galleryButton().toggle(value);

                        self.gallerySelection().toggle(!value);

                        self.galleryTitle().toggle(!value);
                    break;
                }
            }
        }
    });

    module.resolve();
});

EasySocial.module('apps/fields/user/checkbox/content', function($) {
    var module = this;

    EasySocial
        .require()
        .language('PLG_FIELDS_CHECKBOX_CHECK_AT_LEAST_ONE_ITEM')
        .done(function() {
            EasySocial.Controller(
                'Field.Checkbox',
                {
                    defaultOptions:
                    {
                        required        : false,
                        "{item}"        : "[data-field-checkbox-item]"
                    }
                },
                function( self )
                {
                    return {
                        init : function() {
                        },

                        validateInput : function() {
                            self.clearError();

                            if(self.options.required && self.item(':checked').length == 0) {
                                self.raiseError();
                                return false;
                            }

                            return true;
                        },

                        raiseError: function() {
                            self.trigger('error', [$.language('PLG_FIELDS_CHECKBOX_CHECK_AT_LEAST_ONE_ITEM')]);
                        },

                        clearError: function() {
                            self.trigger('clear');
                        },

                        "{self} onSubmit": function(el, event, register) {
                            register.push(self.validateInput());
                            return;
                        }
                    }
                });

            module.resolve();
        });
});

EasySocial.module('apps/fields/user/checkbox/sample_content', function($) {
    var module  = this;

    EasySocial.require()
    .view('fields/user/checkbox/item')
    .done(function($){

        EasySocial.Controller('Field.Checkbox.Sample', {
            defaultOptions: {
                '{checkboxes}'      : '[data-checkboxes]',
                '{checkbox}'        : '[data-checkbox]',
                '{checkboxInput}'   : '[data-checkbox-input]',
                '{checkboxTitle}'   : '[data-checkbox-title]',

                view: {
                    sample  : 'fields/user/checkbox/item'
                }
            }
        }, function(self) {
            return {
                init: function() {
                },

                '{self} onChoiceTitleChanged': function(el, event, index, data) {
                    self.checkboxTitle().eq(index).text(data);
                },

                '{self} onChoiceValueChanged': function(el, event, index, data) {
                    self.checkboxInput().eq(index).val(data);
                },

                '{self} onChoiceAdded': function(el, event, index, data) {
                    if(self.checkbox().eq(index).length > 0) {
                        self.checkbox().eq(index).before(self.view.sample());
                    } else {
                        self.checkboxes().append(self.view.sample());
                    }
                },

                '{self} onChoiceRemoved': function(el, event, index) {
                    self.checkbox().eq(index).remove();
                },

                '{self} onChoiceToggleDefault': function(el, event, index, value) {
                    var element = self.checkboxInput().eq(index);

                    if(value) {
                        element.prop('checked', true);
                    } else {
                        element.prop('checked', false);
                    }
                }
            }
        });

        module.resolve();
    });
});

EasySocial.module('apps/fields/user/country/content', function($) {
    var module = this;

    EasySocial
        .require()
        .library('textboxlist')
        .language(
            'PLG_FIELDS_COUNTRY_VALIDATION_REQUIRED',
            'PLG_FIELDS_COUNTRY_VALIDATION_MINIMUM_ERROR',
            'PLG_FIELDS_COUNTRY_VALIDATION_MAXIMUM_ERROR'
        )
        .done(function() {
            EasySocial.Controller('Field.Country', {
                defaultOptions: {
                    fieldname       : '',

                    required        : false,

                    id              : null,

                    min             : null,

                    max             : null,

                    selecttype      : 'textboxlist',

                    '{field}'       : '[data-field-country]',

                    '{inputTextboxlist}'    : '[data-country-select-textboxlist]',

                    '{inputMultilist}'      : '[data-country-select-multilist]',

                    '{inputCheckbox}'       : '[data-country-select-checkbox]',

                    '{inputCheckboxes}'     : '[data-country-select-checkbox] input',

                    '{inputDropdown}'       : '[data-country-select-dropdown]'
                }
            }, function(self) {
                return {
                    init: function() {

                        self.options.max = self.field().data('max');
                        self.options.min = self.field().data('min');

                        self.options.selecttype = self.field().data('select-type');

                        if(self.options.selecttype === 'textboxlist') {
                            EasySocial.module('field.country/' + self.options.id).done(function(data) {
                                self.inputTextboxlist().textboxlist({
                                    component: 'es',
                                    name: self.options.fieldname + '[]',
                                    max: self.options.max < 1 ? null : self.options.max,
                                    plugin: {
                                        autocomplete: {
                                            exclusive: true,
                                            query: data
                                        }
                                    }
                                });
                            });
                        }
                    },

                    '{inputMultilist} change': function(el, ev) {
                        if(self.options.max > 0 && el.val().length > self.options.max) {
                            el.val(self.lastValidSelection ? self.lastValidSelection : '');

                            return false;
                        }

                        self.lastValidSelection = el.val();
                    },

                    '{inputCheckboxes} change': function(el, ev) {
                        var count = self.inputCheckboxes(':checked').length;

                        if(self.options.max > 0 && count > self.options.max) {
                            el.removeAttr('checked');
                            return false;
                        }
                    },

                    validateInput: function() {
                        var items = null;

                        if(self.options.selecttype === 'textboxlist') {
                            items = self.inputTextboxlist().controller('textboxlist').getAddedItems();
                        }

                        if(self.options.selecttype === 'multilist') {
                            items = self.inputMultilist().val();
                        }

                        if(self.options.selecttype === 'checkbox') {
                            items = self.inputCheckboxes(':checked');
                        }

                        if(self.options.selecttype === 'dropdown') {
                            var value = self.inputDropdown().val();

                            if(!$.isEmpty(value)) {
                                items = [value];
                            }
                        }

                        var count = items ? items.length : 0;

                        // If it is not required and no selection is made, then we pass this check.
                        // If there is selection made, then we have to check against the minimum and maximum count
                        if (!self.options.required && count === 0) {
                            return true;
                        }

                        if(self.options.required && count < 1) {
                            self.raiseError($.language('PLG_FIELDS_COUNTRY_VALIDATION_REQUIRED'));
                            return false;
                        }

                        if(self.options.min > 0 && count < self.options.min) {
                            self.raiseError($.language('PLG_FIELDS_COUNTRY_VALIDATION_MINIMUM_ERROR'));
                            return false;
                        }

                        if(self.options.max > 0 && count > self.options.max) {
                            self.raiseError($.language('PLG_FIELDS_COUNTRY_VALIDATION_MAXIMUM_ERROR'));
                            return false;
                        }

                        return true;
                    },

                    raiseError: function(msg) {
                        self.trigger('error', [msg]);
                    },

                    '{self} onSubmit': function(el, ev, register) {
                        register.push(self.validateInput());
                    }
                }
            });

            module.resolve();
        });
});

EasySocial.module('apps/fields/user/country/sample_content', function($) {
    var module = this;

    EasySocial.Controller('Field.Country.Sample', {
        defaultOptions: {
            '{inputGeneral}'        : '[data-country-select]',

            '{inputTextboxlist}'    : '[data-country-select-textboxlist]',

            '{inputMultilist}'      : '[data-country-select-multilist]',

            '{inputCheckbox}'       : '[data-country-select-checkbox]',

            '{inputDropdown}'       : '[data-country-select-dropdown]',

            '{maxMessage}'          : '[data-country-max-message]',

            '{maxCount}'            : '[data-country-max-count]'
        }
    }, function(self) {
        return {
            init: function() {

            },

            '{self} onConfigChange': function(el, ev, name, value) {
                switch(name) {
                    case 'select_type':
                        self.inputGeneral().hide();

                        if(value === 'textboxlist') {
                            self.inputTextboxlist().show();
                        }

                        if(value === 'multilist') {
                            self.inputMultilist().show();
                        }

                        if(value === 'checkbox') {
                            self.inputCheckbox().show();
                        }

                        if(value === 'dropdown') {
                            self.inputDropdown().show();
                        }
                        break;

                    case 'multilist_size':
                        self.inputMultilist().attr('size', value);
                        break;

                    case 'show_max_message':
                        self.maxMessage().toggle(!!value);
                        break;

                    case 'max':
                        self.maxCount().text(value);
                        break;
                }
            }
        }
    });

    module.resolve();
});

EasySocial.module('apps/fields/user/cover/content', function($) {
    var module = this;

    EasySocial
        .require()
        .library('image')
        .language('PLG_FIELDS_COVER_VALIDATION_REQUIRED')
        .done(function() {
            EasySocial.Controller('Field.Cover', {
                defaultOptions: {
                    id              : 0,
                    group           : null,
                    required        : false,
                    hasCover        : true,
                    defaultCover    : null,

                    ratio           : 3,

                    '{image}'       : '[data-field-cover-image]',

                    '{data}'        : '[data-field-cover-data]',
                    '{position}'    : '[data-field-cover-position]',
                    '{file}'        : '[data-field-cover-file]',

                    '{note}'        : '[data-field-cover-note]',

                    '{loader}'      : '[data-field-cover-loader]',
                    '{error}'       : '[data-field-cover-error]',

                    '{removeButton}': '[data-field-cover-remove-button]',

                    '{revertFrame}' : '[data-field-cover-revert]',
                    '{revertButton}': '[data-field-cover-revert-button]'
                }
            },
            function(self) {
                return {
                    init : function() {
                        self.setFrame();

                        self.setLayout();

                        self.origCover = self.options.hasCover ? $.uri(self.image().css('backgroundImage')).extract(0) : null;

                        self.origPosition = self.options.hasCover ? self.image().css('backgroundPosition') : null;
                    },

                    '{self} onShow': function() {
                        setTimeout(function() {
                            self.setLayout();
                        }, 1);
                    },

                    setFrame: function() {
                        var frameWidth = self.image().width(),
                            frameHeight = frameWidth / self.options.ratio;

                        self.image().css('height', frameHeight);
                    },

                    '{window} resize': $.debounce(function() {
                        self.setFrame();
                    }, 250),

                    imageLoaders: {},

                    '{file} change' : function( el , event ) {
                        if($.isEmpty(el.val())) {
                            return;
                        }

                        var label = el.val().replace(/\\/g, '/').replace(/.*\//, '');

                        el.parents('.input-group').find(':text').val(label);

                        self.loader().show();

                        self.error().hide();

                        self.image().hide();

                        self.note().hide();

                        self.file().hide();

                        EasySocial.ajax( 'fields/' + self.options.group + '/cover/upload' , {
                            id: self.options.id,
                            files   : el
                        }, {
                            type    : 'iframe'
                        }).done(function(result){

                            var resultString    = JSON.stringify(result);

                            // Set the result in a string format
                            self.data().val(resultString);

                            var positionString = JSON.stringify({
                                x: 0.5,
                                y: 0.5
                            });

                            // Set the position in string format defaulting to 50 50
                            self.position().val(positionString);

                            // Set the position to 50 50 by default
                            self.position().val()

                            var url = result.large.uri,
                                imageLoaders = self.imageLoaders,
                                imageLoader = (imageLoaders[url] || (imageLoaders[url] = $.Image.get(url))).done(function(image) {
                                    self.setLayout.image = image;

                                    self.file().show();

                                    self.image().show();

                                    self.note().show();

                                    self.loader().hide();

                                    self.revertFrame().hide();

                                    self.removeButton().show();

                                    self.setCover(result.large.uri);
                                });

                        }).fail(function(msg) {

                            self.loader().hide();

                            self.file().show();

                            self.error().show().html(msg);
                        });
                    },

                    setLayout: function() {
                        var cover = self.image(),
                            image = self.setLayout.image;

                        if(!image) {
                            var url = $.uri(cover.css('backgroundImage')).extract(0);

                            if(!url) return;

                            var imageLoaders = self.imageLoaders,
                                imageLoader =
                                    (imageLoaders[url] || (imageLoaders[url] = $.Image.get(url)))
                                        .done(function(image) {

                                            // Set it as current image
                                            self.setLayout.image = image;

                                            // Then set layout again
                                            self.setLayout();
                                        });

                                return;
                        }

                        var imageWidth  = image.data("width"),
                            imageHeight = image.data("height"),
                            coverWidth  = cover.width(),
                            coverHeight = cover.height(),
                            size = $.Image.resizeProportionate(
                                imageWidth, imageHeight,
                                coverWidth, coverHeight,
                                "outer"
                            );

                        self.availableWidth  = coverWidth  - size.width;
                        self.availableHeight = coverHeight - size.height;

                        self.setFrame();
                    },

                    setCover: function(url, position) {
                        position = position || '50% 50%';

                        self.image()
                            .css({
                                backgroundImage: $.cssUrl(url),
                                backgroundPosition: position
                            });

                        self.setLayout();

                        self.image().addClass('cover-move');

                        self.note().show();
                    },

                    x: 0.5,
                    y: 0.5,

                    moveCover: function(dx, dy, image) {

                        if (!image) {
                            image = self.image();
                        }

                        var w = self.availableWidth,
                            h = self.availableHeight,
                            x = (w==0) ? 0 : self.x + ((dx / w) || 0),
                            y = (h==0) ? 0 : self.y + ((dy / h) || 0);

                        // Always stay within 0 to 1.
                        if (x < 0) x = 0; if (x > 1) x = 1;
                        if (y < 0) y = 0; if (y > 1) y = 1;

                        // Set position on cover
                        image.css("backgroundPosition",
                            ((self.x = x) * 100) + "% " +
                            ((self.y = y) * 100) + "% "
                        );

                        var position = {
                            x: self.x,
                            y: self.y
                        }

                        self.position().val(JSON.stringify(position));
                    },

                    '{image} mousedown': function(selection, event) {
                        if (event.target === self.image()[0]) {
                            event.preventDefault();
                        }

                        // Initial cover position
                        var image = self.image(),
                            position = image.css("backgroundPosition").split(" ");
                            self.x = parseInt(position[0]) / 100;
                            self.y = parseInt(position[1]) / 100;

                        // Initial cursor position
                        var x = event.pageX,
                            y = event.pageY;

                        $(document)
                            .on("mousemove.movingCover mouseup.movingCover", function(event) {

                                self.moveCover(
                                    (x - (x = event.pageX)) * -1,
                                    (y - (y = event.pageY)) * -1,
                                    image
                                );
                            })
                            .on("mouseup.movingCover", function() {

                                $(document).off("mousemove.movingCover mouseup.movingCover");
                            });
                    },

                    '{removeButton} click': function(el) {
                        var data = self.data().val();

                        if($.isEmpty(data)) {
                            if(self.options.hasCover) {
                                self.setCover(self.options.defaultCover);

                                // Mark the data as delete

                                self.data().val('delete');

                                el.hide();

                                self.revertFrame().show();
                            }
                        } else {
                            // Backup the data first
                            self.origData = data;
                            self.origPosition = self.position().val();

                            self.data().val('');
                            self.position().val('');
                            self.file().val('');
                            self.file().parents('.input-group').find(':text').val('');

                            if(self.options.hasCover) {
                                self.setCover(self.origCover);
                            } else {
                                self.setCover(self.options.defaultCover);

                                // Mark the data as delete
                                self.data().val('delete');

                                el.hide();
                            }
                        }
                    },

                    '{revertButton} click': function() {
                        self.setCover(self.origCover, self.origPosition);

                        self.revertFrame().hide();

                        self.removeButton().show();

                        self.data().val('');

                        self.position().val('');

                        self.file().val('');
                        self.file().parents('.input-group').find(':text').val('');
                    },

                    '{self} onSubmit': function(el, ev, register) {
                        if(self.options.required && !self.options.hasCover && $.isEmpty(self.data().val()))
                        {
                            self.raiseError($.language('PLG_FIELDS_COVER_VALIDATION_REQUIRED'));
                            register.push(false);
                        }
                    },

                    raiseError: function(msg) {
                        self.trigger('error', [msg]);
                    }
                }
            });

            module.resolve();
        });
});

EasySocial.module('apps/fields/user/currency/sample_content', function($) {
    var module = this;

    EasySocial.Controller('Field.Currency.Sample', {
        defaultOptions: {

        }
    }, function(self) {
        return {
            init: function() {

            },

            '{self} onConfigChange': function(el, event, name, value) {
                switch(name) {
                    case 'format':
                    break;
                }
            }
        }
    });

    module.resolve();
});

EasySocial.module('apps/fields/user/datetime/content', function($) {
    var module = this;

    EasySocial.require()
    .library('datetimepicker', 'chosen', 'moment/' + EasySocial.options.momentLang)
    .language(
        'PLG_FIELDS_DATETIME_VALIDATION_INVALID_DATETIME_FORMAT',
        'PLG_FIELDS_DATETIME_VALIDATION_PLEASE_SELECT_DATETIME'
        )
    .done(function($){

        EasySocial.Controller(
            'Field.Datetime',
            {
                defaultOptions:
                {
                    required: false,

                    calendarDateFormat: null,

                    yearfrom: null,

                    yearto: null,

                    date: null,

                    lang: null,

                    allowTime: false,
                    allowTimezone: false,

                    calendarLanguage: 'english',

                    '{field}': '[data-field-datetime]',

                    '{date}': '[data-field-datetime-select]',

                    '{dateValue}': '[data-field-datetime-value]',

                    '{timezone}': '[date-field-datetime-timezone]',

                    '{form}': '[data-field-datetime-form]',

                    '{icon}': '[data-field-datetime-icon]',

                    '{clearButton}': '[data-clear]',
                }
            },
            function( self )
            {
                return {
                    init : function() {
                        // self.legacyInit();

                        self.options.yearfrom = self.options.yearfrom || 1930;

                        // There is an issue with yearto where if I set yearto = 2014, I won't be able to select 2014 dates. This is a bug in datetimepicker. Currently, temporarily, we manually add 1 to the value if there are value set.
                        if (!$.isEmpty(self.options.yearto)) {
                            self.options.yearto = parseInt(self.options.yearto) + 1;
                        } else {
                            self.options.yearto = new Date().getFullYear() + 100
                        }

                        self.date()._datetimepicker({
                            component: "es",
                            format: self.options.calendarDateFormat,
                            minDate: self.options.yearfrom + '-01-01',
                            maxDate: self.options.yearto + '-12-31',
                            icons: {
                                time: 'glyphicon glyphicon-time',
                                date: 'glyphicon glyphicon-calendar',
                                up: 'glyphicon glyphicon-chevron-up',
                                down: 'glyphicon glyphicon-chevron-down'
                            },
                            sideBySide: true,
                            pickTime: self.options.allowTime,
                            useCurrent: false,
                            language: self.options.calendarLanguage == 'english' ? 'en-gb' : EasySocial.options.momentLang
                        });

                        // date value should always be in mysql datetime format
                        // YYYY-MM-DD HH:MM:SS
                        self.options.date = self.dateValue().val();

                        // If there is a date value, then we set it into the datetimepicker
                        if (!$.isEmpty(self.options.date)) {
                            // Datetimepicker is using moment.js, hence here we manually create a moment object to pass in instead of passing in date time string
                            // This is because datetimepicker.setDate function passes along the format from self.options.calendarDateFormat to generate the date object, which will render moment.js to generate an invalid dateobject
                            // self.options.calendarDateFormat is only for display purposes
                            // Raw date object is always in SQL format
                            var dateObj = $.moment(self.options.date);

                            self.datetimepicker('setDate', dateObj);
                            // self.setDateValue(dateObj);
                        }

                        if (self.options.allowTimezone) {
                            self.timezone().chosen({
                                search_contains: true
                            });
                        }
                    },

                    '{icon} click': function() {
                        self.datetimepicker('show');
                    },

                    '{date} dp.change': function(el, ev) {
                        self.setDateValue(ev.date.toDate());

                        self.form().addClass('has-datetime');

                        // Custom hack to ensure that the input box is really blurred
                        if (!self.options.allowTime) {
                            self.date().blur();
                        }
                    },

                    // Alias method to call the datetimepicker instance
                    datetimepicker: function(method, value) {
                        return self.date().data('DateTimePicker')[method](value);
                    },

                    setDateValue: function(date) {
                        // Convert the date object into sql format and set it into the input
                        self.dateValue().val(date.getFullYear() + '-' +
                                            ('00' + (date.getMonth()+1)).slice(-2) + '-' +
                                            ('00' + date.getDate()).slice(-2) + ' ' +
                                            ('00' + date.getHours()).slice(-2) + ':' +
                                            ('00' + date.getMinutes()).slice(-2) + ':' +
                                            ('00' + date.getSeconds()).slice(-2));
                    },

                    '{date} blur': function() {
                        self.validateCalendar();
                    },

                    validateCalendar: function() {
                        self.clearError();

                        if(self.options.required && $.isEmpty(self.dateValue().val())) {
                            self.raiseError($.language('PLG_FIELDS_DATETIME_VALIDATION_PLEASE_SELECT_DATETIME'));
                            return false;
                        }

                        return true;
                    },

                    raiseError: function(msg) {
                        self.trigger('error', [msg]);
                    },

                    clearError: function() {
                        self.trigger('clear');
                    },

                    "{self} onSubmit" : function(el, event, register) {
                        register.push(self.validateCalendar());
                        return;

                    },

                    '{clearButton} click': function(el, ev) {
                        self.form().removeClass('has-datetime');

                        self.datetimepicker('setValue', new $.moment());

                        self.date().val('');

                        self.dateValue().val('');
                    }
                }
            });

        module.resolve();
    });
});

EasySocial.module('apps/fields/user/datetime/display_content', function($) {
    var module = this;

    EasySocial.require().library('popbox', 'chosen').language('FIELDS_USER_DATETIME_LOCAL_TIMEZONE').done(function($) {

        EasySocial.Controller('Field.Datetime.Display', {
            defaultOptions: {
                userid: null,

                date: null,

                timezone: null,

                local: null,

                '{toggle}': '[data-popbox]',

                '{content}': '[data-popbox-content]',

                '{date}': '[data-date]',

                '{timezone}': '[data-timezone]',

                '{loading}': '[data-loading]'
            }
        }, function(self) {
            return {
                init: function() {
                    self.options.timezone = self.timezone().data('timezone');

                    self.options.date = self.date().data('date-utc');

                    // Set the selected timezone with the displayed date
                    self.datetime(self.options.timezone, self.date().html());

                    // Get the local timezone first through client browser
                    self.options.local = -new Date().getTimezoneOffset()/60;

                    var content = self.content().html(),
                        position = self.toggle().data('popbox-position');

                    self.toggle().popbox({
                        content: content,
                        id: 'fd',
                        component: 'es',
                        type: 'timezone',
                        toggle: 'click',
                        position: position
                    }).attr('data-popbox', '');
                },

                '{toggle} popboxActivate': function(el, event, popbox) {
                    $(popbox.tooltip).addController('EasySocial.Controller.Field.Datetime.Display.Timezone', {
                        '{parent}': self
                    });
                },

                data: {},

                datetime: function(tz, value) {
                    // Getter
                    if (value === undefined) {
                        var dfd = $.Deferred();

                        if (self.data[tz] === undefined) {
                            self.loading().show();

                            EasySocial.ajax('fields/user/datetime/getDatetime', {
                                id: self.options.id,
                                userid: self.options.userid,
                                tz: tz,
                                local: self.options.local,
                                datetime: self.options.date
                            }).done(function(datetime) {

                                self.loading().hide();

                                dfd.resolve(self.datetime(tz, datetime));
                            });
                        } else {
                            dfd.resolve(self.data[tz]);
                        }

                        return dfd;
                    }

                    // Setter
                    self.data[tz] = value;
                    return value;
                },

                showDatetime: function(tz, datetime) {
                    if (tz === 'local') {
                        tz = $.language('FIELDS_USER_DATETIME_LOCAL_TIMEZONE');
                    }

                    self.timezone().html(tz);
                    self.date().html(datetime);
                }
            }
        });

        EasySocial.Controller('Field.Datetime.Display.Timezone', {
            defaultOptions: {
                '{timezones}': '[data-timezone-select]',
                '{reset}': '[data-timezone-reset]',
                '{local}': '[data-timezone-local]'
            }
        }, function(self) {
            return {
                init: function() {
                    self.timezones().chosen({
                        search_contains: true
                    });
                },

                '{timezones} change': function(el, event) {
                    var key = el.val();

                    self.parent.date().hide();
                    self.parent.timezone().hide();

                    self.parent.datetime(key).done(function(value) {
                        self.parent.showDatetime(key, value);

                        self.parent.date().show();
                        self.parent.timezone().show();
                    });
                },

                '{reset} click': function() {
                    self.setTimezone(self.parent.options.timezone);
                },

                '{local} click': function() {
                    self.setTimezone('local')
                },

                setTimezone: function(tz) {
                    self.timezones()
                        .val(tz)
                        .trigger('liszt:updated')
                        .trigger('change');
                }
            }
        });
        module.resolve();
    });
});

EasySocial.module('apps/fields/user/datetime/dropdown', function($) {
    var module = this;

    EasySocial.require().language('PLG_FIELDS_DATETIME_DAY').done(function() {
        EasySocial.Controller('Field.Datetime.Dropdown', {
            defaultOptions: {
                required: false,
                allowTime: false,
                allowTimezone: false,
                yearfrom: null,
                yearto: null,

                '{dateValue}': '[data-field-datetime-value]',

                '{year}': '[data-field-datetime-year]',
                '{month}': '[data-field-datetime-month]',
                '{day}': '[data-field-datetime-day]',

                '{hour}': '[data-field-datetime-hour]',
                '{minute}': '[data-field-datetime-minute]',
                '{ampm}': '[data-field-datetime-ampm]'
            }
        }, function(self) {
            return {
                init: function()
                {

                },

                '{year} change': function(el, ev)
                {
                    self.setValue();
                },

                '{month} change': function(el, ev)
                {
                    // If year and month is provided, then we need to find the max day
                    var year = self.year().val(),
                        month = self.month().val();

                    if (year !== '' && month !== '') {
                        var maxDay = new Date(year, month, 0).getDate();

                        // See if there are days originally selected
                        var day = self.day().val();

                        if (day !== '') {
                            // If day value is more than current month maxday, then we use maxday
                            day = Math.min(day, maxDay);
                        }

                        self.day().empty();

                        self.day().append($('<option value="">' + $.language('PLG_FIELDS_DATETIME_DAY') + '</option>'));

                        for (i = 1; i <= maxDay; i++) {
                            $('<option value="' + i + '">' + i + '</option>').appendTo(self.day());
                        }

                        // Set back the original value
                        if (day !== '') {
                            self.day().val(day);
                        }
                    }

                    self.setValue();
                },

                '{day} change': function(el, ev)
                {
                    self.setValue();
                },

                '{hour} change': function(el, ev)
                {
                    self.setValue();
                },

                '{minute} change': function(el, ev)
                {
                    self.setValue();
                },

                '{ampm} change': function(el, ev)
                {
                    self.setValue();
                },

                setValue: function()
                {
                    var string;

                    var year = self.year().val(),
                        month = self.month().val(),
                        day = self.day().val();

                    if (year !== '' && month !== '' && day !== '') {
                        string = year + '-' + month + '-' + day;

                        if (self.options.allowTime) {
                            var hour = self.hour().val(),
                                minute = self.minute().val();

                            // If there is ampm, then we need to readjust the time a little bit
                            if (hour !== '' && self.ampm().length > 0 && self.ampm().val() == 'pm') {
                                hour = (parseInt(hour) + 12).toString();

                                if (hour === '24') {
                                    hour = '0';
                                }
                            }

                            if (minute === '') {
                                minute = '00';
                            }

                            string += ' ' + ('00' + hour).slice(-2) + ':' + ('00' + minute).slice(-2) + ':00';
                        }

                        self.dateValue().val(string);
                    }
                }
            }
        });

        module.resolve();
    });
});

EasySocial.module('apps/fields/user/datetime/sample_content', function($) {
    var module = this;

    EasySocial.require().library('ui/datepicker').done(function() {
        EasySocial.Controller('Field.Datetime.Sample', {
            defaultOptions: {
                '{yearPrivacy}'     : '[data-yearprivacy]',

                '{input}'           : '[data-field-datetime-select]',

                '{timezone}'        : '[data-field-datetime-timezone]'
            }
        }, function(self) {
            return {
                init: function() {
                },

                '{self} onConfigChange': function(el, event, name, value) {
                    switch(name) {
                        case 'year_privacy':
                            self.yearPrivacy().toggle(value);
                        break;

                        case 'allow_timezone':
                            self.timezone().toggle(value);
                        break;

                        case 'placeholder':
                            self.input().attr('placeholder', value);
                        break;
                    }
                }
            }
        });

        module.resolve();
    });
});

EasySocial.module('apps/fields/user/dropdown/content', function($) {
    var module = this;

    EasySocial
        .require()
        .language('PLG_FIELDS_DROPDOWN_VALIDATION_PLEASE_SELECT_A_VALUE')
        .done(function($) {
            EasySocial.Controller(
                'Field.Dropdown',
                {
                    defaultOptions:
                    {
                        required        : null,

                        "{field}"       : "[data-field-dropdown]",

                        "{item}"        : "[data-field-dropdown-item]",

                        "{option}"      : "[data-field-dropdown-item] option"
                    }
                },
                function( self )
                {
                    return {
                        init : function()
                        {
                        },

                        validateInput : function()
                        {
                            self.clearError();

                            if(self.options.required && $.isEmpty(self.item().val())) {
                                self.raiseError();
                                return false;
                            }

                            return true;
                        },

                        raiseError: function() {
                            self.trigger('error', [$.language('PLG_FIELDS_DROPDOWN_VALIDATION_PLEASE_SELECT_A_VALUE')]);
                        },

                        clearError: function() {
                            self.trigger('clear');
                        },

                        "{self} onSubmit": function(el, event, register) {
                            // If field is not required, skip the checks.

                            if(!self.options.required)
                            {
                                register.push(true);
                                return;
                            }

                            register.push(self.validateInput());

                            return;
                        },

                        '{self} onSample': function() {
                            if(self.option().length < 1) {
                                self.item().append($('<option></option>'));
                            }
                        },

                        '{self} onChoiceAdded': function(el, event, index) {
                            if(self.option().eq(index).length > 0) {
                                self.option().eq(index).before($('<option></option>'));
                            } else {
                                self.item().append($('<option></option>'));
                            }
                        },

                        '{self} onChoiceValueChanged': function(el, event, index, value) {
                            self.option().eq(index).val(value);
                        },

                        '{self} onChoiceTitleChanged': function(el, event, index, value) {
                            self.option().eq(index).text(value);
                        },

                        '{self} onChoiceRemoved': function(el, event, index) {
                            self.option().eq(index).remove();
                        },

                        '{self} onChoiceToggleDefault': function(el, event, index, value) {
                            self.option().removeAttr('selected');

                            if(value) {
                                self.option().eq(index).attr('selected', 'selected');
                            }
                        }
                    }
                });

            module.resolve();
        });
});

EasySocial.module('apps/fields/user/email/content', function($) {
    var module = this;

    EasySocial
        .require()
        .language('PLG_FIELDS_EMAIL_VALIDATION_REQUIRED', 'PLG_FIELDS_EMAIL_VALIDATION_INVALID_FORMAT')
        .done(function($) {
            EasySocial.Controller(
                'Field.Email',
                {
                    defaultOptions:
                    {
                        required        : false,

                        regex           : 0,

                        regexFormat     : '',

                        regexModifier   : '',

                        "{field}"       : "[data-field-email]",

                        "{input}"       : "[data-field-email-input]"
                    }
                },
                function( self )
                {
                    return {
                        init: function() {
                        },

                        validateInput: function() {
                            var value   = self.input().val();

                            if(self.options.required && $.isEmpty(value)) {
                                self.raiseError($.language('PLG_FIELDS_EMAIL_VALIDATION_REQUIRED'));
                                return false;
                            }

                            if(!$.isEmpty(value) && self.options.regex) {
                                var regex = new RegExp(self.options.regexFormat, self.options.regexModifier);

                                if(!regex.test(value)) {
                                    self.raiseError($.language('PLG_FIELDS_EMAIL_VALIDATION_INVALID_FORMAT'));
                                    return false;
                                }
                            }

                            return true;
                        },

                        raiseError: function(msg) {
                            self.trigger('error', [msg]);
                        },

                        clearError: function() {
                            self.trigger('clear');
                        },

                        "{self} onSubmit": function(el, event, register) {

                            register.push(self.validateInput());

                            return;
                        }
                    }
                });

            module.resolve();
        });
});

EasySocial.module('apps/fields/user/file/content', function($) {
    var module = this;

    EasySocial.require().library('ui/sortable').language('PLG_FIELDS_FILE_ERROR_UNKNOWN_ERROR_OCCURED', 'COM_EASYSOCIAL_WORKING').done(function($) {
        EasySocial.Controller('Field.File', {
            defaultOptions: {
                required: false,

                id: null,

                inputName: '',

                maxFile: 0,

                '{field}': '[data-field-file]',

                '{list}': '[data-field-file-list]',

                '{item}': '[data-field-file-item]',

                '{add}': '[data-field-file-add]',

                // file items
                '{dragPlaceholder}': '.data-field-file-item-drag',
                '{moveHandle}': '[data-field-file-move]'

            }
        }, function(self) {
            return {
                init: function() {
                    self.options.maxFile = self.field().data('maxfile');

                    self.item().addController('EasySocial.Controller.Field.File.Item', {
                        controller: {
                            parent: self
                        }
                    });

                    self.initSortable();
                },

                initSortable: function() {
                    self.list().sortable({
                        items: self.item.selector,
                        placeholder: 'data-field-file-item-drag',
                        handle: self.moveHandle.selector,
                        forcePlaceholderSize: true,
                        start: function(event, ui) {
                            self.dragPlaceholder().width(ui.item.find('.file-wrap').width());
                        }
                    })
                },

                '{add} click': function(el, ev) {
                    if(self.options.maxFile < 1 || (self.item().length < self.options.maxFile)) {
                        var key = self.item().length;

                        var item = $('<div class="data-field-file-item" data-field-file-item></div>');

                        item.data('key', key);

                        item.html($.language('COM_EASYSOCIAL_WORKING'));

                        item.addController('EasySocial.Controller.Field.File.Item', {
                            controller: {
                                parent: self
                            }
                        });

                        self.list().append(item);

                        EasySocial.ajax('fields/user/file/getUploadHtml', {
                            id: self.options.id,
                            key: key
                        }).done(function(html) {
                            item.html(html);
                        });

                        if(self.options.maxFile > 1 && self.item().length >= self.options.maxFile) {
                            el.hide();
                        }
                    }
                },

                '{item} uploadDone': function() {
                    self.add().click();
                }
            }
        });

        EasySocial.Controller('Field.File.Item', {
            defaultOptions: {
                required: false,

                key: null,

                '{upload}'      : '[data-field-file-upload]',

                '{progress}'    : '[data-field-file-progress]',

                '{delete}'      : '[data-field-file-delete]',

                '{clear}'       : '[data-field-file-clear]',

                '{id}'          : '[data-field-file-id]',

                '{tmp}'         : '[data-field-file-tmp]'
            }
        }, function(self) {
            return {
                init: function() {
                    self.options.key = self.element.data('key');
                },

                '{upload} change': function(el, ev) {
                    self.element.html($.language('COM_EASYSOCIAL_WORKING'));

                    EasySocial.ajax('fields/user/file/upload', {
                        id: self.parent.options.id,
                        files: el,
                        key: self.options.key
                    }, {
                        type: 'iframe'
                    }).done(function(html) {
                        self.element.html(html);

                        self.trigger('uploadDone');
                    }).fail(function(msg) {
                        self.element.html(msg || self.getErrorMsg());
                    });
                },

                '{delete} click': function(el, ev) {
                    var tmp = self.tmp().val();
                    var id = self.id().val();

                    self.element.html($.language('COM_EASYSOCIAL_WORKING'));

                    EasySocial.ajax('fields/user/file/delete', {
                        id: self.parent.options.id,
                        key: self.options.key,
                        tmp: tmp,
                        fileid: id
                    }).done(function(html) {
                        self.element.html(html);

                        self.trigger('fileDeleted');
                    }).fail(function(msg) {
                        self.element.html(msg || self.getErrorMsg());
                    });
                },

                '{clear} click': function(el, ev) {
                    self.element.html($.language('COM_EASYSOCIAL_WORKING'));

                    EasySocial.ajax('fields/user/file/getUploadHtml', {
                        id: self.parent.options.id,
                        key: self.options.key
                    }).done(function(html) {
                        self.element.html(html);
                    });
                },

                getErrorMsg: function() {
                    msg = $('<span class="alert field-file-error">' + $.language('PLG_FIELDS_FILE_ERROR_UNKNOWN_ERROR_OCCURED') + '<button class="close" type="button" data-field-file-clear>×</button></span>');

                    return msg;
                }
            }
        });

        module.resolve();
    });
});

EasySocial.module('apps/fields/user/file/sample_content', function($) {
    var module = this;

    EasySocial.Controller('Field.File', {
        defaultOptions: {
            '{sizeText}': '[data-field-file-size-text]',

            '{size}': '[data-field-file-size]',

            '{add}': '[data-field-file-add]'
        }
    }, function(self) {
        return {
            init: function() {

            },

            '{self} onConfigChange': function(el, ev, name, value) {
                switch(name) {
                    case 'size_limit':
                        self.size().text(value);
                        break;

                    case 'show_size_limit':
                        self.sizeText().toggle(!!value);
                        break;

                    case 'file_limit':
                        self.add().toggle((value < 1 || value > 1));
                        break;
                }
            }
        }
    });

    module.resolve();
});

EasySocial.module('apps/fields/user/gender/content', function($) {
    var module = this;

    EasySocial
        .require()
        .language('PLG_FIELDS_GENDER_VALIDATION_GENDER_REQUIRED')
        .done(function($) {
            EasySocial.Controller(
                'Field.Gender',
                {
                    defaultOptions:
                    {
                        required        : false,

                        '{field}'       : '[data-field-gender]',

                        '{selection}'   : '[data-field-gender-select]'
                    }
                },
                function( self )
                {
                    return {
                        init : function()
                        {
                        },

                        validateInput: function() {
                            if(!self.options.required) {
                                return true;
                            }

                            self.clearError();

                            var value = self.selection(':checked').val();

                            if($.isEmpty(value))
                            {
                                self.raiseError();
                                return false;
                            }

                            return true;
                        },

                        raiseError: function() {
                            self.trigger('error', [$.language('PLG_FIELDS_GENDER_VALIDATION_GENDER_REQUIRED')]);
                        },

                        clearError: function() {
                            self.trigger('clear');
                        },

                        '{self} onSubmit': function(el, event, register) {
                            register.push(self.validateInput());
                        },

                        '{selection} click': function() {
                            self.validateInput();
                        }
                    }
                });

            module.resolve();
        });
});

EasySocial.module('apps/fields/user/joomla_email/content', function($) {
    var module = this;

    EasySocial
        .require()
        .language(
            'PLG_FIELDS_JOOMLA_EMAIL_VALIDATION_REQUIRED',
            'PLG_FIELDS_JOOMLA_EMAIL_VALIDATION_RECONFIRM_REQUIRED',
            'PLG_FIELDS_JOOMLA_EMAIL_VALIDATION_NOT_MATCHING')
        .done(function($) {
            EasySocial.Controller('Field.Joomla_email', {
                defaultOptions: {
                    required    : true,

                    id          : null,

                    userid      : null,

                    reconfirm   : false,

                    event       : null,

                    '{input}'   : '[data-field-email-input]',

                    '{confirm}' : '[data-field-email-reconfirm-input]',

                    '{confirmFrame}'    : '[data-field-email-reconfirm-frame]'
                }
            }, function(self) {
                return {
                    init: function() {
                        self.origEmail = self.input().val();
                    },

                    '{input} blur': function(el, ev) {
                        var value = self.input().val();

                        if(self.options.reconfirm && value !== self.origEmail)
                        {
                            self.confirmFrame().show();
                        }

                        if(self.options.reconfirm && value === self.origEmail && (self.options.event === 'onEdit' || self.options.event === 'onAdminEdit'))
                        {
                            self.confirmFrame().hide();
                        }

                        self.validateInput();
                    },

                    '{confirm} blur': function(el, ev) {
                        self.validateInput();
                    },

                    validateInput: function() {
                        self.clearError();

                        var value = self.input().val();

                        if($.isEmpty(value)) {
                            if(!self.options.required) {
                                return true;
                            }

                            self.raiseError($.language('PLG_FIELDS_JOOMLA_EMAIL_VALIDATION_REQUIRED'));
                            return false;
                        }

                        if(self.options.reconfirm)
                        {
                            var reconfirm = self.confirm().val();

                            if(value !== self.origEmail && $.isEmpty(reconfirm))
                            {
                                self.raiseError($.language('PLG_FIELDS_JOOMLA_EMAIL_VALIDATION_RECONFIRM_REQUIRED'));
                                return false;
                            }

                            if(!$.isEmpty(reconfirm) && value !== reconfirm)
                            {
                                self.raiseError($.language('PLG_FIELDS_JOOMLA_EMAIL_VALIDATION_NOT_MATCHING'));
                                return false;
                            }
                        }

                        return self.checkInput()
                            .done(function() {
                                self.clearError();
                            })
                            .fail(function(msg) {
                                self.raiseError(msg);
                            });
                    },

                    checkInput: function() {
                        return EasySocial.ajax('fields/user/joomla_email/isValid', {
                            id: self.options.id,
                            userid: self.options.userid,
                            email: self.input().val()
                        });
                    },

                    raiseError: function(msg) {
                        self.trigger('error', [msg]);
                    },

                    clearError: function() {
                        self.trigger('clear');
                    },

                    '{self} onSubmit': function(el, ev, register, mode) {
                        if (mode === 'onRegisterMini') {
                            return;
                        }

                        register.push(self.validateInput());
                    }
                }
            });

            module.resolve();
        });
});

EasySocial.module('apps/fields/user/joomla_email/registermini_content', function($) {
    var module = this;

    EasySocial.require()
    .language(
        'PLG_FIELDS_JOOMLA_EMAIL_VALIDATION_REQUIRED',
        'PLG_FIELDS_JOOMLA_EMAIL_CHECKING',
        'PLG_FIELDS_JOOMLA_EMAIL_VALIDATION_INVALID_FORMAT')
    .done(function() {
        EasySocial.Controller('Field.Joomla_email.Mini', {
            defaultOptions: {
                require: true,
                id: null,

                '{input}': '#email'
            }
        }, function(self) {
            return {
                init: function() {

                },

                '{input} keyup': function(el) {
                    if(el.val().length > 0) {
                        self.delayedCheck();
                    }
                },

                state: false,

                delayedCheck: $.debounce(function() {
                    self.checkEmail();
                }, 250),

                checkEmail: function() {

                    self.clearError();

                    var email = self.input().val();

                    if(self.options.required && email.length == 0) {
                        self.raiseError($.language('PLG_FIELDS_JOOMLA_EMAIL_VALIDATION_REQUIRED'));
                        return false;
                    }

                    if(!$.isEmpty(email) && self.options.regex) {
                        var regex = new RegExp(self.options.regexFormat, self.options.regexModifier);

                        if(!regex.test(email)) {
                            self.raiseError($.language('PLG_FIELDS_JOOMLA_EMAIL_VALIDATION_INVALID_FORMAT'));
                            return false;
                        }
                    }

                    if(email.length > 0) {
                        var state = $.Deferred();

                        self.setLoading($.language('PLG_FIELDS_JOOMLA_EMAIL_CHECKING'));

                        var email = self.input().val();

                        EasySocial.ajax('fields/user/joomla_email/isValid', {
                            id: self.options.id,
                            userid: 0,
                            email: email
                        }).done(function(msg) {

                            self.setLoaded();

                            state.resolve();

                        }).fail(function(msg) {

                            self.setLoaded();

                            self.raiseError(msg);

                            state.reject();
                        });

                        return state;
                    }

                    return true;
                },

                raiseError: function(msg) {
                    self.trigger('error', [msg]);
                },

                clearError: function() {
                    self.trigger('clear');
                },

                '{self} onSubmit': function(el, ev, register, mode) {
                    if (mode !== 'onRegisterMini') {
                        return;
                    }

                    if(self.options.required || self.input().val().length > 0) {
                        register.push(self.checkEmail());
                    }
                },

                setLoading: function(msg) {
                    self.trigger('loading', [msg]);
                },

                setLoaded: function() {
                    self.trigger('loaded');
                }
            }
        });

        module.resolve();
    });
});

EasySocial.module('apps/fields/user/joomla_email/sample_content', function($) {
    var module = this;

    EasySocial.Controller('Field.Joomla_email.Sample', {
        defaultOptions: {
            '{confirmEmail}'        : '[data-field-email-reconfirm-frame]'
        }
    }, function(self) {
        return {
            init: function() {

            },

            '{self} onConfigChange': function(el, event, name, value) {
                switch(name) {
                    case 'reconfirm_email':
                        self.confirmEmail().toggle(value);
                    break;
                }
            }
        }
    });

    module.resolve();
});

EasySocial.module('apps/fields/user/joomla_fullname/content', function($) {
    var module = this;

    EasySocial
        .require()
        .language('PLG_FIELDS_JOOMLA_FULLNAME_VALIDATION_EMPTY_NAME')
        .done(function($) {
            EasySocial.Controller('Field.Joomla_fullname', {
                defaultOptions: {
                    nameFormat      : 1,

                    max             : 0,

                    required        : true,

                    '{field}'       : '[data-field-joomla_fullname]',

                    '{firstName}'   : '[data-field-jname-first]',
                    '{middleName}'  : '[data-field-jname-middle]',
                    '{lastName}'    : '[data-field-jname-last]',
                    '{name}'        : '[data-field-jname-name]'
                }
            }, function(self) {
                return {
                    init : function()
                    {
                        self.options.nameFormat = self.field().data('name-format');
                        self.options.max = self.field().data('max');
                    },

                    validateInput : function()
                    {
                        self.clearError();

                        if(!self.options.required) {
                            return true;
                        }

                        // Name format
                        // 1 - first, middle, last
                        // 2 - last, middle, first
                        // 3 - single name
                        // 4 - first, last
                        // 5 - last, first

                        if(self.options.nameFormat == 3) {
                            if($.isEmpty(self.name().val())) {
                                self.raiseError();
                                return false;
                            }

                            return true;
                        }

                        if($.isEmpty(self.firstName().val())) {
                            self.raiseError();
                            return false;
                        }

                        return true;
                    },

                    raiseError: function() {
                        self.trigger('error', [$.language('PLG_FIELDS_JOOMLA_FULLNAME_VALIDATION_EMPTY_NAME')]);
                    },

                    clearError: function() {
                        self.trigger('clear');
                    },

                    "{firstName} blur" : function(el, event) {
                        self.validateInput();
                    },

                    "{name} blur": function(el, event) {
                        self.validateInput();
                    },

                    "{self} onError": function(el, event, type, field) {
                        self.raiseError();
                    },

                    "{self} onSubmit" : function(el, event, register) {
                        register.push(self.validateInput());

                        return;
                    }
                }
            });

            module.resolve();
        });
});

EasySocial.module('apps/fields/user/joomla_fullname/sample_content', function($) {
    var module = this;

    EasySocial.Controller('Field.Joomla_fullname.Sample', {
        defaultOptions: {
            '{fullnameFormat}'      : '[data-fullname-format]'
        }
    }, function(self) {
        return {
            init: function() {

            },

            '{self} onConfigChange': function(el, event, name, value) {
                switch(name) {
                    case 'format':
                        self.switchFormat(value);
                    break;
                }
            },

            switchFormat: function(value) {
                self.fullnameFormat().hide();

                self.fullnameFormat().eq(value - 1).show();
            }
        }
    });

    module.resolve();
});

EasySocial.module('apps/fields/user/joomla_password/content', function($) {
    var module = this;

    EasySocial.require()
        .library( 'passwordstrength' )
        .language(
            'PLG_FIELDS_JOOMLA_PASSWORD_EMPTY_PASSWORD',
            'PLG_FIELDS_JOOMLA_PASSWORD_EMPTY_RECONFIRM_PASSWORD',
            'PLG_FIELDS_JOOMLA_PASSWORD_NOT_MATCHING',
            'PLG_FIELDS_JOOMLA_PASSWORD_MINIMUM_CHAR',
            'PLG_FIELDS_JOOMLA_PASSWORD_MAXIMUM_CHAR',
            'PLG_FIELDS_JOOMLA_PASSWORD_STRENGTH_VERY_WEAK',
            'PLG_FIELDS_JOOMLA_PASSWORD_STRENGTH_WEAK',
            'PLG_FIELDS_JOOMLA_PASSWORD_STRENGTH_NORMAL',
            'PLG_FIELDS_JOOMLA_PASSWORD_STRENGTH_STRONG',
            'PLG_FIELDS_JOOMLA_PASSWORD_STRENGTH_VERY_STRONG',
            'PLG_FIELDS_JOOMLA_PASSWORD_EMPTY_ORIGINAL_PASSWORD'
        )
        .done(function(){

            EasySocial.Controller(
                'Field.Joomla_password',
                {
                    defaultOptions:
                    {
                        event               : null,

                        required            : false,
                        passwordStrength    : false,
                        reconfirmPassword   : false,
                        requireOriginal     : false,

                        min : 4,

                        max : 0,

                        '{field}'       : '[data-field-joomla_password]',

                        '{original}'    : '[data-field-password-orig]',
                        '{input}'       : '[data-field-password-input]',
                        '{reconfirm}'   : '[data-field-password-confirm]',

                        '{strength}'    : '[data-field-password-strength]',

                        '{reconfirmNotice}' : '[data-reconfirmPassword-failed]'
                    }
                },
                function( self )
                {
                    return {
                        init : function()
                        {
                            if(self.options.passwordStrength) {
                                self.initPasswordStrength();
                            }
                        },

                        '{input} keyup': function() {
                            self.validatePassword();
                        },

                        '{input} blur': function() {
                            self.validatePassword();
                        },

                        '{reconfirm} keyup': function() {
                            self.validatePassword();
                        },

                        '{reconfirm} blur': function() {
                            self.validatePassword();
                        },

                        validatePassword: function()
                        {
                            self.clearError();

                            var input = self.input().val(),
                                reconfirm = self.reconfirm().val();

                            if(self.options.event === 'onRegister' && !self.validatePasswordInput() ) {
                                return false;
                            }

                            if(self.options.event === 'onEdit' && !self.validatePasswordEdit()) {
                                return false;
                            }

                            if(self.options.reconfirmPassword && !self.validatePasswordConfirm()) {
                                return false;
                            }

                            return true;
                        },

                        validatePasswordInput: function() {
                            var input = self.input().val();

                            if($.isEmpty(input)) {
                                self.raiseError($.language('PLG_FIELDS_JOOMLA_PASSWORD_EMPTY_PASSWORD'));
                                return false;
                            }

                            if(self.options.min > 0 && input.length < self.options.min) {
                                self.raiseError($.language('PLG_FIELDS_JOOMLA_PASSWORD_MINIMUM_CHAR', self.options.min));
                                return false;
                            }

                            if(self.options.max > 0 && input.length > self.options.max) {
                                self.raiseError($.language('PLG_FIELDS_JOOMLA_PASSWORD_MAXIMUM_CHAR', self.options.max));
                                return false;
                            }

                            return true;
                        },

                        validatePasswordEdit: function() {
                            var orig = self.original().val(),
                                input = self.input().val();

                            // If both original and input is empty, then we return true as it is not mandatory in edit
                            if($.isEmpty(input) && $.isEmpty(orig)) {
                                return true;
                            }

                            // Only original is empty
                            if($.isEmpty(orig) && self.options.requireOriginal) {
                                self.raiseError($.language('PLG_FIELDS_JOOMLA_PASSWORD_EMPTY_ORIGINAL_PASSWORD'));
                                return false;
                            }

                            // Original is not empty, then we validate the new password
                            return self.validatePasswordInput();
                        },

                        validatePasswordConfirm: function() {
                            var input = self.input().val(),
                                reconfirm = self.reconfirm().val();

                            // Check if either input or reconfirm is not empty
                            if(!$.isEmpty(input) || !$.isEmpty(reconfirm)) {
                                if($.isEmpty(input)) {
                                    self.raiseError($.language('PLG_FIELDS_JOOMLA_PASSWORD_EMPTY_PASSWORD'));
                                    return false;
                                }

                                if($.isEmpty(reconfirm)) {
                                    self.raiseError($.language('PLG_FIELDS_JOOMLA_PASSWORD_EMPTY_RECONFIRM_PASSWORD'));
                                    return false;
                                }

                                if(input !== reconfirm) {
                                    self.raiseError($.language('PLG_FIELDS_JOOMLA_PASSWORD_NOT_MATCHING'));
                                    return false;
                                }
                            }

                            return true;
                        },

                        initPasswordStrength: function() {
                            self.input().password_strength({
                                container: self.strength.selector,
                                minLength: self.options.min,
                                texts: {
                                    1: $.language('PLG_FIELDS_JOOMLA_PASSWORD_STRENGTH_VERY_WEAK'),
                                    2: $.language('PLG_FIELDS_JOOMLA_PASSWORD_STRENGTH_WEAK'),
                                    3: $.language('PLG_FIELDS_JOOMLA_PASSWORD_STRENGTH_NORMAL'),
                                    4: $.language('PLG_FIELDS_JOOMLA_PASSWORD_STRENGTH_STRONG'),
                                    5: $.language('PLG_FIELDS_JOOMLA_PASSWORD_STRENGTH_VERY_STRONG')
                                },
                                onCheck: function(level) {
                                    if(level <= 1) {
                                        self.strength()
                                            .removeClass('text-warning')
                                            .removeClass('text-success')
                                            .addClass('text-error small help-inline');
                                    }

                                    if(level > 1 && level <= 3) {
                                        self.strength()
                                            .removeClass('text-error')
                                            .removeClass('text-success')
                                            .addClass('text-warning small help-inline');
                                    }

                                    if(level >= 4) {
                                        self.strength()
                                            .removeClass('text-error')
                                            .removeClass('text-warning')
                                            .addClass('text-success small help-inline');
                                    }
                                }
                            })
                        },

                        raiseError: function(msg) {
                            self.trigger('error', [msg]);
                        },

                        clearError: function() {
                            self.trigger('clear');
                        },

                        "{self} onSubmit": function(el, event, register, mode) {
                            if (mode === 'onRegisterMini') {
                                return;
                            }

                            register.push(self.validatePassword());
                        }
                    }
                });

            module.resolve();

        });
});

EasySocial.module('apps/fields/user/joomla_password/registermini_content', function($) {
    var module = this;

    EasySocial.require()
    .language(
        'PLG_FIELDS_JOOMLA_PASSWORD_TOO_SHORT',
        'PLG_FIELDS_JOOMLA_PASSWORD_TOO_LONG',
        'PLG_FIELDS_JOOMLA_PASSWORD_EMPTY_PASSWORD')
    .done(function() {
        EasySocial.Controller('Field.Joomla_password.Mini', {
            defaultOptions: {
                required: false,
                min: 4,
                max: 0,

                '{input}': '[data-password]'
            }
        }, function(self) {
            return {
                init: function() {

                },

                '{input} keyup': function() {
                    self.checkPassword();
                },

                checkPassword: function() {
                    self.clearError();

                    var value = self.input().val();

                    if(self.options.min > 0 && value.length < self.options.min) {
                        self.raiseError($.language('PLG_FIELDS_JOOMLA_PASSWORD_TOO_SHORT'));
                        return false;
                    }

                    if(self.options.max > 0 && value.length > self.options.max) {
                        self.raiseError($.language('PLG_FIELDS_JOOMLA_PASSWORD_TOO_LONG'));
                        return false;
                    }

                    if(self.options.required && value.length == 0) {
                        self.raiseError($.language('PLG_FIELDS_JOOMLA_PASSWORD_EMPTY_PASSWORD'));
                        return false;
                    }

                    return true;
                },

                '{self} onSubmit': function(el, event, register, mode) {
                    if (mode !== 'onRegisterMini') {
                        return;
                    }

                    register.push(self.checkPassword());
                },

                clearError: function() {
                    self.trigger('clear');
                },

                raiseError: function(msg) {
                    self.trigger('error', [msg]);
                }
            }
        });

        module.resolve();
    });
})

EasySocial.module('apps/fields/user/joomla_password/sample_content', function($) {
    var module = this;

    EasySocial.Controller('Field.Joomla_password.Sample', {
        defaultOptions: {
            '{confirmPassword}'     : '[data-password-confirm]'
        }
    }, function(self) {
        return {
            init: function() {

            },

            '{self} onConfigChange': function(el, event, name, value) {
                switch(name) {
                    case 'reconfirm_password':
                        self.confirmPassword().toggle(value);
                    break;
                }
            }
        }
    });

    module.resolve();
});

EasySocial.module('apps/fields/user/joomla_timezone/content', function($) {
    var module = this;

    EasySocial
        .require()
        .library('chosen')
        .language('PLG_FIELDS_JOOMLA_TIMEZONE_VALIDATION_SELECT_TIMEZONE')
        .done(function($) {
            EasySocial.Controller('Field.Joomla_timezone', {
                defaultOptions: {
                    required        : false,

                    '{field}'       : '[data-field-joomla_timezone]',

                    '{input}'       : '[data-field-joomla_timezone-input]'
                }
            }, function(self) {
                return {
                    init : function() {
                        self.input().chosen({
                            allow_single_deselect: true,
                            search_contains: true
                        });
                    },

                    validateInput: function() {
                        if(!self.options.required) {
                            return true;
                        }

                        self.clearError();

                        var value = self.input().val();

                        if(value === 'null' || $.isEmpty(value)) {
                            self.raiseError();
                            return false;
                        }

                        return true;
                    },

                    raiseError: function() {
                        self.trigger('error', [$.language('PLG_FIELDS_JOOMLA_TIMEZONE_VALIDATION_SELECT_TIMEZONE')]);
                    },

                    clearError: function() {
                        self.trigger('clear');
                    },

                    '{input} change': function() {
                        self.validateInput();
                    },

                    "{self} onSubmit": function(el, event, register) {
                        register.push(self.validateInput());
                    }
                }
            });

            module.resolve();
        });
});

EasySocial.module('apps/fields/user/joomla_username/content', function($) {
    var module = this;

    EasySocial.Controller('Field.Joomla_username', {
        defaultOptions: {
            event: null,

            id: null,

            userid: null,

            '{checkUsernameButton}': '[data-username-check]',

            '{input}': '[data-username-input]',

            '{available}': '[data-username-available]'
        }
    }, function(self) {
        return {
            state: false,

            init: function() {
            },

            '{checkUsernameButton} click': function() {
                self.delayedCheck();
            },

            '{input} keyup': function() {
                self.delayedCheck();
            },

            delayedCheck: $.debounce(function() {
                self.checkUsername();
            }, 250),

            checkUsername: function() {
                self.clearError();

                var state = $.Deferred();

                self.checkUsernameButton().addClass('btn-loading');

                var username = self.input().val();

                EasySocial.ajax('fields/user/joomla_username/isValid', {
                    id: self.options.id,
                    userid: self.options.userid,
                    username: username,
                    event: self.options.event
                }).done(function(msg) {

                    self.checkUsernameButton().removeClass('btn-loading');

                    self.available().show();

                    state.resolve();
                }).fail(function(msg) {

                    self.raiseError(msg);

                    self.checkUsernameButton().removeClass('btn-loading');

                    self.available().hide();

                    state.reject();
                });

                return state;
            },

            raiseError: function(msg) {
                self.trigger('error', [msg]);
            },

            clearError: function() {
                self.trigger('clear');
            },

            '{self} onSubmit': function(el, ev, register, mode) {
                if (mode === 'onRegisterMini') {
                    return;
                }

                register.push(self.checkUsername());
            }
        }
    });

    module.resolve();
});

EasySocial.module('apps/fields/user/joomla_username/registermini_content', function($) {
    var module = this;

    EasySocial.require()
    .language(
        'PLG_FIELDS_JOOMLA_USERNAME_CHECKING',
        'PLG_FIELDS_JOOMLA_USERNAME_EMPTY_USERNAME')
    .done(function() {

        EasySocial.Controller('Field.Joomla_username.Mini', {
            defaultOptions: {
                id: null,

                required: false,

                '{input}': '#joomla_username'
            }
        }, function(self) {
            return {
                init: function() {

                },

                '{input} keyup': function(el) {
                    if(el.val().length > 0) {
                        self.delayedCheck();
                    }
                },

                state: false,

                delayedCheck: $.debounce(function() {
                    self.checkUsername();
                }, 250),

                checkUsername: function() {

                    var username = self.input().val();

                    if(self.options.required && username.length == 0) {
                        self.raiseError($.language('PLG_FIELDS_JOOMLA_USERNAME_EMPTY_USERNAME'));
                        return false;
                    }

                    if(username.length > 0) {
                        var state = $.Deferred();

                        self.clearError();

                        self.setLoading($.language('PLG_FIELDS_JOOMLA_USERNAME_CHECKING'));

                        EasySocial.ajax('fields/user/joomla_username/isValid', {
                            id: self.options.id,
                            userid: 0,
                            username: username
                        }).done(function(msg) {

                            self.setLoaded();

                            state.resolve();

                        }).fail(function(msg) {

                            self.setLoaded();

                            self.raiseError(msg);

                            state.reject();

                        });

                        return state;
                    }

                    return true;
                },

                raiseError: function(msg) {
                    self.trigger('error', [msg]);
                },

                clearError: function() {
                    self.trigger('clear');
                },

                '{self} onSubmit': function(el, ev, register, mode) {
                    if (mode !== 'onRegisterMini') {
                        return;
                    }

                    if(self.options.required || self.input().val().length > 0) {
                        register.push(self.checkUsername());
                    }
                },

                setLoading: function(msg) {
                    self.trigger('loading', [msg]);
                },

                setLoaded: function() {
                    self.trigger('loaded');
                }
            }
        });

        module.resolve();
    });
});

EasySocial.module('apps/fields/user/joomla_username/sample_content', function($) {
    var module = this;

    EasySocial.Controller('Field.Joomla_username.Sample', {
        defaultOptions: {
            '{checkUsername}'       : '[data-check-username]'
        }
    }, function(self) {
        return {
            init: function() {

            },

            '{self} onConfigChange': function(el, event, name, value) {
                switch(name) {
                    case 'check_username':
                        self.checkUsername().toggle(!!value);
                    break;
                }
            }
        }
    });

    module.resolve();
});

EasySocial.module('apps/fields/user/multidropdown/content', function($) {
    var module = this;

    EasySocial.require().library('ui/sortable').language('PLG_FIELDS_MULTIDROPDOWN_VALIDATION_REQUIRED_FIELD').done(function() {
            EasySocial.Controller('Field.Multidropdown', {
                defaultOptions: {
                    required: false,

                    id: null,

                    inputName: '',

                    max: 0,

                    '{field}': '[data-field-multidropdown]',

                    '{list}': '[data-field-multidropdown-list]',

                    '{item}': '[data-field-multidropdown-item]',

                    '{input}': '[data-field-multidropdown-input]',

                    '{add}': '[data-field-multidropdown-add]',

                    '{delete}': '[data-field-multidropdown-delete]',

                    '{move}': '[data-field-multidropdown-move]'
                }
            }, function(self) {
                return {
                    init: function() {
                        self.options.max = self.field().data('max');

                        self.initSortable();
                    },

                    initSortable: function() {
                        self.list().sortable({
                            items: self.item.selector,
                            handle: self.move.selector
                        });
                    },

                    '{add} click': function(el) {
                        if (self.options.max < 1 || self.item().length < self.options.max)
                        {
                            var item = self.item().eq(0).clone();

                            item.find(self.input.selector)
                                .attr('value', '')
                                .val('');

                            self.list().append(item);
                        }

                        if(self.options.max > 0 && self.item().length >= self.options.max)
                        {
                            el.hide();
                        }
                    },

                    '{delete} click': function(el) {
                        var item = el.parents(self.item.selector);

                        if (self.item().length > 1) {
                            item.remove();
                        } else {
                            item.find(self.input.selector).val('');
                        }

                        if (self.options.max > 0 && self.item().length < self.options.max) {
                            self.add().show();
                        }
                    },

                    '{self} onConfigChange': function(el, ev, name, value) {
                        switch (name) {
                            case 'add_button_text':
                                self.add().text(value);
                            break;
                        }
                    },

                    raiseError: function() {
                        self.trigger('error', [$.language('PLG_FIELDS_MULTIDROPDOWN_VALIDATION_REQUIRED_FIELD')]);
                    },

                    '{self} onSubmit': function(el, ev, register) {
                        if (!self.options.required) {
                            register.push(true);
                            return;
                        }

                        var state = false;

                        $.each(self.input(), function(i, element) {
                            if (!$.isEmpty($(element).val())) {
                                state = true;

                                return false;
                            }
                        });

                        if (!state) {
                            self.raiseError();
                        }

                        register.push(state);
                    }
                }
            });

            module.resolve();
        });
});

EasySocial.module('apps/fields/user/multilist/content', function($) {
    var module = this;

    EasySocial
        .require()
        .language('PLG_FIELDS_MULTILIST_VALIDATION_PLEASE_SELECT_A_VALUE')
        .done(function($) {
            EasySocial.Controller(
                'Field.Multilist',
                {
                    defaultOptions:
                    {
                        required        : null,
                        multiple        : null,

                        "{field}"       : "[data-field-multilist]",

                        "{item}"        : "[data-field-multilist-item]",

                        "{option}"      : "[data-field-multilist-item] option"
                    }
                },
                function( self )
                {
                    return {
                        init : function()
                        {
                        },

                        validateInput : function()
                        {
                            self.clearError();

                            if(self.options.multiple && self.item().children(':selected').length <= 0) {
                                self.raiseError();
                                return false;
                            }

                            // The only way to test for an empty value is when the value is empty and it's required.
                            if(self.item().children(':selected' ).val() == '') {
                                self.raiseError();
                                return false;
                            }

                            return true;
                        },

                        raiseError: function() {
                            self.trigger('error', [$.language('PLG_FIELDS_MULTILIST_VALIDATION_PLEASE_SELECT_A_VALUE')]);
                        },

                        clearError: function() {
                            self.trigger('clear');
                        },

                        "{self} onSubmit": function(el, event, register) {
                            // If field is not required, skip the checks.

                            if(!self.options.required)
                            {
                                register.push(true);
                                return;
                            }

                            register.push(self.validateInput());

                            return;
                        },

                        '{self} onSample': function() {
                            if(self.option().length < 1) {
                                self.item().append($('<option></option>'));
                            }
                        },

                        '{self} onChoiceAdded': function(el, event, index) {
                            if(self.option().eq(index).length > 0) {
                                self.option().eq(index).before($('<option></option>'));
                            } else {
                                self.item().append($('<option></option>'));
                            }
                        },

                        '{self} onChoiceValueChanged': function(el, event, index, value) {
                            self.option().eq(index).val(value);
                        },

                        '{self} onChoiceTitleChanged': function(el, event, index, value) {
                            self.option().eq(index).text(value);
                        },

                        '{self} onChoiceRemoved': function(el, event, index) {
                            self.option().eq(index).remove();
                        },

                        '{self} onChoiceToggleDefault': function(el, event, index, value) {
                            if(value) {
                                self.option().eq(index).attr('selected', 'selected');
                            } else {
                                self.option().eq(index).removeAttr('selected');
                            }
                        }
                    }
                });

            module.resolve();
        });
});

EasySocial.module('apps/fields/user/multitextbox/content', function($) {
    var module = this;

    EasySocial
        .require()
        .library('ui/sortable')
        .language('PLG_FIELDS_MULTITEXTBOX_VALIDATION_REQUIRED_FIELD')
        .done(function() {
            EasySocial.Controller('Field.Multitextbox', {
                defaultOptions: {
                    required: false,

                    id: null,

                    inputName: '',

                    max: 0,

                    '{field}': '[data-field-multitextbox]',

                    '{list}': '[data-field-multitextbox-list]',

                    '{item}': '[data-field-multitextbox-item]',

                    '{input}': '[data-field-multitextbox-input]',

                    '{add}': '[data-field-multitextbox-add]',

                    '{delete}': '[data-field-multitextbox-delete]',

                    '{move}': '[data-field-multitextbox-move]'
                }
            }, function(self) {
                return {
                    init: function() {
                        self.options.max = self.field().data('max');

                        self.initSortable();
                    },

                    initSortable: function() {
                        self.list().sortable({
                            items: self.item.selector,
                            handle: self.move.selector
                        });
                    },

                    '{add} click': function(el) {
                        if (self.options.max < 1 || self.item().length < self.options.max)
                        {
                            var item = self.item().eq(0).clone();

                            item.find(self.input.selector)
                                .attr('value', '')
                                .val('');

                            self.list().append(item);
                        }

                        if(self.options.max > 0 && self.item().length >= self.options.max)
                        {
                            el.hide();
                        }
                    },

                    '{delete} click': function(el) {
                        var item = el.parents(self.item.selector);

                        if (self.item().length > 1) {
                            item.remove();
                        } else {
                            item.find(self.input.selector).val('');
                        }

                        if (self.options.max > 0 && self.item().length < self.options.max) {
                            self.add().show();
                        }
                    },

                    '{self} onConfigChange': function(el, ev, name, value) {
                        switch (name) {
                            case 'add_button_text':
                                self.add().text(value);
                            break;
                        }
                    },

                    raiseError: function() {
                        self.trigger('error', [$.language('PLG_FIELDS_MULTITEXTBOX_VALIDATION_REQUIRED_FIELD')]);
                    },

                    '{self} onSubmit': function(el, ev, register) {
                        if(!self.options.required) {
                            register.push(true);
                            return;
                        }

                        var state = false;

                        $.each(self.input(), function(i, element) {
                            if(!$.isEmpty($(element).val())) {
                                state = true;

                                return false;
                            }
                        });

                        if (!state) {
                            self.raiseError();
                        }

                        register.push(state);
                    }
                }
            });

            module.resolve();
        });
});

EasySocial.module('apps/fields/user/permalink/content', function($) {
    var module = this;

    EasySocial
        .require()
        .language(
            'PLG_FIELDS_PERMALINK_EXCEEDED_MAX_LENGTH',
            'PLG_FIELDS_PERMALINK_REQUIRED')
        .done(function($) {
            EasySocial.Controller('Field.Permalink', {
                defaultOptions:
                {
                    required: false,

                    max     : 0,

                    id      : null,
                    userid  : null,

                    '{field}'           : '[data-field-permalink]',

                    '{checkButton}'     : '[data-permalink-check]',
                    '{input}'           : '[data-permalink-input]',
                    '{available}'       : '[data-permalink-available]'
                }
            },
            function(self)
            {
                return {
                    state: false,

                    init: function()
                    {
                        self.options.max = self.field().data('max');
                    },

                    "{checkButton} click" : function()
                    {
                        self.delayedCheck();
                    },

                    "{input} keyup" : function()
                    {
                        self.delayedCheck();
                    },

                    delayedCheck: $.debounce(function() {
                        self.checkPermalink();
                    }, 250),

                    checkPermalink: function()
                    {
                        self.clearError();

                        var permalink   = self.input().val();

                        self.available().hide();

                        if(self.options.max > 0 && permalink.length > self.options.max) {
                            self.raiseError($.language('PLG_FIELDS_PERMALINK_EXCEEDED_MAX_LENGTH'));
                            return false;
                        }

                        if(!$.isEmpty(permalink))
                        {
                            self.checkButton().addClass('btn-loading');

                            var state = $.Deferred();

                            EasySocial.ajax('fields/user/permalink/isValid',
                            {
                                "id"        : self.options.id,
                                "userid"    : self.options.userid,
                                "permalink" : permalink
                            })
                            .done(function(msg)
                            {
                                self.checkButton().removeClass( 'btn-loading' );

                                self.available().show();

                                state.resolve();
                            })
                            .fail(function(msg)
                            {
                                self.raiseError(msg);

                                self.checkButton().removeClass('btn-loading');

                                self.available().hide();

                                state.reject();
                            });

                            return state;
                        }

                        if(self.options.required && $.isEmpty(permalink))
                        {
                            self.available().hide();

                            self.raiseError($.language('PLG_FIELDS_PERMALINK_REQUIRED'));
                            return false;
                        }

                        return true;
                    },

                    raiseError: function(msg)
                    {
                        self.trigger('error', [msg]);
                    },

                    clearError: function()
                    {
                        self.trigger('clear');
                    },

                    '{self} onSubmit': function(el, ev, register)
                    {
                        register.push(self.checkPermalink());
                    }
                }
            });

            module.resolve();
        });
});

EasySocial.module('apps/fields/user/permalink/sample_content', function($) {
    var module = this;

    EasySocial.Controller('Field.Permalink.Sample', {
        defaultOptions: {
            '{checkPermalink}'      : '[data-check-permalink]'
        }
    }, function(self) {
        return {
            init: function() {

            },

            '{self} onConfigChange': function(el, event, name, value) {
                switch(name) {
                    case 'check_permalink':
                        self.checkPermalink().toggle(!!value);
                    break;
                }
            }
        }
    });

    module.resolve();
});

EasySocial.module('apps/fields/user/relationship/content', function($) {
    var module = this;

    EasySocial
        .require()
        .script( 'site/friends/suggest' )
        .language(
            'PLG_FIELDS_RELATIONSHIP_APPROVE_CONFIRM',
            'PLG_FIELDS_RELATIONSHIP_ACTION_APPROVE',
            'COM_EASYSOCIAL_CANCEL_BUTTON')
        .done(function($) {

            EasySocial.Controller('Field.Relationship', {
                defaultOptions: {
                    required: false,

                    id: null,

                    types: null,

                    fieldname: null,

                    actor: null,
                    target: null,

                    '{field}'   : '[data-field-relationship]',

                    '{display}' : '[data-relationship-display]',
                    '{form}'    : '[data-relationship-form]',

                    '{confirm}' : '[data-relationship-display-confirm]',
                    '{pending}' : '[data-relationship-display-pending]',

                    '{actions}' : '[data-relationship-display-actions]',

                    '{pendingTitle}'    : '[data-relationship-pending-title]'
                }
            }, function(self) {
                return {
                    init: function() {
                        EasySocial.module('field.relationship/' + self.options.id).done(function(types) {
                            self.options.types = types;
                        });

                        self.display().addController('EasySocial.Controller.Field.Relationship.Display', {
                            controller: {
                                parent: self
                            }
                        });

                        self.addPlugin('form');
                    },

                    '{self} relationshipDeleted': function() {
                        self.confirm().hide();

                        self.form().show();
                    }
                }
            });

            EasySocial.Controller('Field.Relationship.Form', {
                defaultOptions: {
                    origType            : null,
                    origTarget          : null,
                    origApproved        : null,

                    '{form}'            : '[data-relationship-form]',

                    '{type}'            : '[data-relationship-form-type]',
                    '{connectWord}'     : '[data-relationship-form-connectwords]',
                    '{connectWords}'    : '[data-relationship-form-connectwords] span',

                    '{input}'           : '[data-relationship-form-input]',

                    '{target}'          : '[data-relationship-form-target]',

                    '{targetAvatar}'    : '[data-relationship-form-target-avatar]',
                    '{targetName}'      : '[data-relationship-form-target-name]',

                    '{targetPending}'   : '[data-relationship-form-target-pending]',

                    '{targetDelete}'    : '[data-relationship-form-target-delete]',

                    '{textboxlistDelete}': '[data-textboxlist-itemRemoveButton]'
                }
            }, function(self) {
                return {
                    init: function() {
                        self.input().addController(EasySocial.Controller.Friends.Suggest, {
                            max: 1,
                            name: self.parent.options.fieldname + '[target][]'
                        });

                        self.options.origType = self.form().data('orig-type');
                        self.options.origTarget = self.form().data('orig-target');
                        self.options.origApproved = self.form().data('orig-approved');
                    },

                    '{type} change': function(el) {
                        var name = el.val();

                        var isConnect = self.parent.options.types[name].connect;

                        var items = self.input().controller('Textboxlist').getAddedItems();

                        var isSelected = items.length > 0;

                        var element = isSelected ? self.target() : self.input();

                        var selected = isSelected ? items[0] : false;

                        if(isConnect) {
                            element.show();

                            if(isSelected && self.options.origApproved && selected.id == self.options.origTarget && name == self.options.origType) {
                                self.targetPending().hide();
                            } else {
                                self.targetPending().show();
                            }
                        } else {
                            element.hide();
                        }

                        self.connectWords().hide();

                        self.connectWords().filterBy('relationship-form-connectword', name).show();
                    },

                    '{input} addItem': function(el, ev, item) {
                        if(item.avatar) {
                            self.targetAvatar().attr('src', item.avatar);
                        }

                        if(item.screenName) {
                            self.targetName().text(item.screenName);
                        }

                        if(item.id) {
                            self.targetDelete().data('id', item.id);
                        }

                        self.input().hide();

                        self.target().show();

                        if(self.options.origApproved && item.id == self.options.origTarget && self.type().val() == self.options.origType) {
                            self.targetPending().hide();
                        } else {
                            self.targetPending().show();
                        }
                    },

                    '{targetDelete} click': function(el, ev) {
                        var id = el.data('id');

                        self.input().controller('Textboxlist').removeItem(id);

                        self.input().show();

                        self.target().hide();
                    },

                    '{parent} relationshipApproved': function(el, ev, target) {

                        self.type().val(target.type);

                        var item = {
                            avatar: target.avatar,
                            html: target.name + '<input type="hidden" name="' + self.parent.options.fieldname + '[target][]" value="' + target.id + '"/>',
                            id: target.id,
                            key: target.name,
                            menuHtml: undefined,
                            name: self.parent.options.fieldname + '[target]',
                            screenName: target.name,
                            title: target.name
                        }

                        self.input().controller('Textboxlist').addItem(item);

                        self.connectWords().hide();

                        self.connectWords().filterBy('relationshipFormConnectword', target.type);
                    }
                }
            });

            EasySocial.Controller('Field.Relationship.Display', {
                defaultOptions: {
                    id                  : null,

                    '{pendingFrame}'    : '[data-relationship-display-pending-text]',
                    '{loadingFrame}'    : '[data-relationship-display-loading]',
                    '{errorFrame}'      : '[data-relationship-display-error]',

                    '{actionsFrame}'    : '[data-relationship-display-actions]',

                    '{deleteButton}'    : '[data-relationship-display-actions-delete]',

                    '{approveButton}'   : '[data-relationship-display-actions-approve]',
                    '{rejectButton}'    : '[data-relationship-display-actions-reject]'
                }
            }, function(self) {
                return {
                    init: function() {

                        self.options.id = self.element.data('id');

                    },

                    '{deleteButton} click': function() {

                        self.parent.trigger('relationshipDeleted');

                        self.element.hide();
                    },

                    '{approveButton} click': function() {
                        EasySocial.dialog({
                            width: 500,
                            content: $.language('PLG_FIELDS_RELATIONSHIP_APPROVE_CONFIRM'),
                            selectors: {
                                '{approveButton}': '[data-approve-button]',
                                '{cancelButton}': '[data-cancel-button]'
                            },
                            bindings: {
                                '{approveButton} click': function() {
                                    this.parent.close();

                                    self.approveRelationship();
                                },

                                '{cancelButton} click': function() {
                                    this.parent.close();
                                }
                            },
                            buttons: '<button data-cancel-button type="button" class="btn btn-es">' + $.language('COM_EASYSOCIAL_CANCEL_BUTTON') + '</button><button data-approve-button type="button" class="btn btn-es-primary">' + $.language('PLG_FIELDS_RELATIONSHIP_ACTION_APPROVE') + '</button>'
                        })
                    },

                    approveRelationship: function() {
                        self.actionsFrame().hide();

                        self.loadingFrame().show();

                        EasySocial.ajax('fields/user/relationship/approve', {
                            id: self.parent.options.id,
                            relid: self.options.id
                        })
                            .done(function(target) {
                                self.parent.display().hide();

                                self.element.show();

                                self.element.removeAttr('data-relationship-display-pending');
                                self.element.attr('data-relationship-display-confirm', '');

                                self.parent.form().before(self.element);

                                self.parent.form().hide();

                                if(self.parent.pending().length < 1) {
                                    self.parent.pendingTitle().hide();
                                }

                                self.loadingFrame().remove();

                                self.pendingFrame().remove();

                                self.approveButton().remove();

                                self.rejectButton().remove();

                                self.actionsFrame().show();

                                self.deleteButton().show();

                                self.parent.trigger('relationshipApproved', [target]);
                            })
                            .fail(function(msg) {
                                self.loadingFrame().hide();

                                self.errorFrame().show().find('span').text(msg);
                            });
                    },

                    '{rejectButton} click': function() {
                        self.actionsFrame().hide();

                        self.loadingFrame().show();

                        EasySocial.ajax('fields/user/relationship/reject', {
                            id: self.parent.options.id,
                            relid: self.options.id
                        })
                            .done(function() {
                                // self.parent.trigger('relationshipRejected');

                                self.element.remove();

                                if(self.parent.pending().length < 1) {
                                    self.parent.pendingTitle().hide();
                                }
                            })
                            .fail(function(msg) {
                                self.parent.trigger('relationshipActionError', [msg]);
                            });
                    }
                }
            });

            module.resolve();

        });
});

EasySocial.module( 'site/friends/suggest' , function($){

	var module 	= this;

	EasySocial.require()
	.view( 'site/friends/suggest.item' )
	.library( 'textboxlist' )
	.language( 'COM_EASYSOCIAL_FRIENDS_REQUEST_SENT' )
	.done(function($){


		EasySocial.Controller(
			'Friends.Suggest.User',
			{
				defaultOptions:
				{
					"{addButton}"		: "[data-friend-suggest-add]",
					"{button}"			: "[data-friend-suggest-button]"

				}
			},
			function( self )
			{
				return {
					init: function()
					{
					},

					"{addButton} click" : function( el ){

						// Implement controller on add friend.
						EasySocial.ajax( 'site/controllers/friends/request' ,
						{
							"id"	: self.element.data( 'uid' )
						}).done(function(friendId) {
							// replace the button with done message.
							self.button().html( $.language('COM_EASYSOCIAL_FRIENDS_REQUEST_SENT') );
						}).fail(function(obj) {


							EasySocial.dialog({
								width: 450,
								height: 180,
								content: obj.message
							});
						});
					}

				}

			}

		);

		EasySocial.Controller(
			'Friends.Suggest',
			{
				defaultOptions:
				{
					max			: null,
					exclusive	: true,
					exclusion	: [],
					minLength	: 1,
					highlight	: true,
					name		: "uid[]",
					type: "",

					// Search for friend list as well
					friendList		: false,
					friendListName	: "",

					view:
					{
						suggestItem: "site/friends/suggest.item"
					}
				}
			},
			function(self)
			{
				return {

					init: function()
					{
						var options = self.options;

						// Implement the textbox list on the implemented element.
						self.element
							.textboxlist(
							{
								component: 'es',
								name: options.name,
								max: options.max,
								plugin:
								{
									autocomplete:
									{
										exclusive		: options.exclusive,
										minLength		: options.minLength,
										highlight		: options.highlight,
										showLoadingHint	: true,
										showEmptyHint	: true,

										query: function(keyword)
										{
											if( !options.friendList )
											{
												return EasySocial.ajax("site/controllers/friends/suggest", {search: keyword, type: options.type});
											}

											return EasySocial.ajax("site/controllers/friends/suggestWithList", {search: keyword, "inputName" : options.name , "friendListName" : options.friendListName });
										}
									}
								}
							})
							.textboxlist("enable");
					},

					"{self} filterItem": function(el, event, item)
					{
						// If this suggest searches for friend list, we don't want to format the item result here.
						if( self.options.friendList )
						{
							return;
						}

						var html =
							self.view.suggestItem(true, {
								item: item,
								name: self.options.name
							});

						item.title    = item.screenName;
						item.menuHtml = html;
						item.html     = html;

						return item;
					},

					"{self} filterMenu": function(el, event, menu, menuItems, autocomplete, textboxlist)
					{
						// If this suggest searches for friend list, we don't want to format the item result here.
						if( self.options.friendList )
						{
							return;
						}

						// Get list of excluded users
						var items = textboxlist.getAddedItems(),
							users = $.pluck(items, "id"),
							users = users.concat(self.options.exclusion);

						menuItems.each(function(){

							var menuItem = $(this),
								item = menuItem.data("item");

							// If this user is excluded, hide the menu item
							menuItem.toggleClass("hidden", $.inArray(item.id.toString(), users) > -1);
						});
					}

			}
		});

		module.resolve();
	});

});


EasySocial.module('apps/fields/user/separator/sample', function($) {
    var module = this;

    EasySocial.Controller( 'Field.Separator.Sample',
    {
        defaultOptions:
        {
            "{items}"   : "[data-separator-type]"
        }
    },
    function( self )
    {
        return {
            "{self} onConfigChange" : function( el , event , name , value )
            {
                if( name == 'type' )
                {
                    var itemToShow  = $( '[data-separator-' + value + ']' );

                    // Hide all separators
                    self.items().hide();

                    // Only show the correct separator
                    itemToShow.show();
                }

            }
        }
    });

    module.resolve();
});

EasySocial.module('apps/fields/user/terms/content', function($) {
    var module = this;

    EasySocial
        .require()
        .language('PLG_FIELDS_TERMS_VALIDATION_REQUIRED')
        .done(function($) {
            EasySocial.Controller('Field.Terms',
            {
                defaultOptions:
                {
                    event           : null,

                    required        : false,

                    '{textbox}'     : '[data-field-terms-textbox]',
                    '{checkbox}'    : '[data-field-terms-checkbox]'
                }
            },
            function(self)
            {
                return {
                    init : function() {
                    },

                    validateInput: function() {
                        self.clearError();

                        if(self.options.event == 'onAdminEdit') {
                            return true;
                        }

                        if(self.options.required && !self.checkbox().is(':checked'))
                        {
                            self.raiseError();
                            return false;
                        }

                        return true;
                    },

                    '{checkbox} change': function() {
                        self.validateInput();
                    },

                    raiseError: function() {
                        self.trigger('error', [$.language('PLG_FIELDS_TERMS_VALIDATION_REQUIRED')]);
                    },

                    clearError: function() {
                        self.trigger('clear');
                    },

                    '{self} onSubmit': function(el, event, register) {
                        register.push(self.validateInput());
                    },

                    '{self} onConfigChange': function(el, event, name, value) {
                        switch(name) {
                            case 'message':
                                self.textbox().val(value);
                                break;
                        }
                    }
                }
            });

            module.resolve();
        });
});

EasySocial.module('apps/fields/user/textarea/content', function($) {
    var module = this;

    EasySocial
        .require()
        .language(
            'PLG_FIELDS_TEXTAREA_VALIDATION_INPUT_REQUIRED',
            'PLG_FIELDS_TEXTAREA_VALIDATION_INPUT_TOO_SHORT',
            'PLG_FIELDS_TEXTAREA_VALIDATION_INPUT_TOO_LONG')
        .done(function($) {
            EasySocial.Controller('Field.Textarea', {
                defaultOptions: {
                    required        : false,

                    min: 0,
                    max: 0,

                    '{field}'       : '[data-field-textarea]',

                    '{input}'       : '[data-field-textarea-input]'
                }
            }, function( self ) {
                return {
                    init : function() {
                        self.options.min = self.field().data('min');
                        self.options.max = self.field().data('max');
                    },

                    validateInput : function()
                    {
                        self.clearError();

                        var val     = self.input().val();

                        if(self.options.required && $.isEmpty(val)) {
                            self.raiseError($.language('PLG_FIELDS_TEXTAREA_VALIDATION_INPUT_REQUIRED'));
                            return false;
                        }

                        if(!$.isEmpty(val) && self.options.min > 0 && val.length < self.options.min) {
                            self.raiseError($.language('PLG_FIELDS_TEXTAREA_VALIDATION_INPUT_TOO_SHORT'));
                            return false;
                        }

                        if(self.options.max > 0 && val.length > self.options.max) {
                            self.raiseError($.language('PLG_FIELDS_TEXTAREA_VALIDATION_INPUT_TOO_LONG'));
                            return false;
                        }

                        return true;
                    },

                    raiseError: function(msg) {
                        self.trigger('error', [msg]);
                    },

                    clearError: function() {
                        self.trigger('clear');
                    },

                    '{self} onSubmit': function(el, event, register) {
                        register.push(self.validateInput());
                    },

                    '{self} onError': function(el, ev, type) {
                        if(type === 'required') {
                            self.raiseError($.language('PLG_FIELDS_TEXTAREA_VALIDATION_INPUT_REQUIRED'));
                        }
                    },

                    '{input} keyup': function() {
                        self.validateInput();
                    },

                    '{self} onConfigChange': function(el, event, name, value) {
                        switch(name) {
                            case 'default':
                                self.input().val(value);
                                break;

                            case 'placeholder':
                                self.input().attr('placeholder', value);
                                break;

                            case 'readonly':
                                if(value) {
                                    self.input().attr('readonly', 'readonly');
                                } else {
                                    self.input().removeAttr('readonly');
                                }
                                break;
                        }
                    }
                }
            });

            module.resolve();
        });
});

EasySocial.module('apps/fields/user/textbox/content', function($) {
    var module = this;

    EasySocial
        .require()
        .language(
            'PLG_FIELDS_TEXTBOX_VALIDATION_INPUT_REQUIRED',
            'PLG_FIELDS_TEXTBOX_VALIDATION_INPUT_TOO_SHORT',
            'PLG_FIELDS_TEXTBOX_VALIDATION_INPUT_TOO_LONG',
            'PLG_FIELDS_TEXTBOX_VALIDATION_INPUT_INVALID_FORMAT')
        .done(function($) {
            EasySocial.Controller('Field.Textbox', {
                defaultOptions: {
                    required: false,

                    min: 0,
                    max: 0,

                    '{field}': '[data-field-textbox]',

                    '{input}': '[data-field-textbox-input]',

                    '{notice}': '[data-check-notice]'
                }
            }, function(self) {
                return {
                    init: function() {
                        self.options.min = self.field().data('min');
                        self.options.max = self.field().data('max');
                    },

                    '{input} keyup': function()
                    {
                        self.validateInput();
                    },

                    '{input} blur': function()
                    {
                        self.validateInput();
                    },

                    validateInput: function()
                    {
                        self.clearError();

                        var value = self.input().val();

                        if(self.options.required && $.isEmpty(value)) {
                            self.raiseError($.language('PLG_FIELDS_TEXTBOX_VALIDATION_INPUT_REQUIRED'));
                            return false;
                        }

                        if(!$.isEmpty(value) && self.options.min > 0 && value.length < self.options.min) {
                            self.raiseError($.language('PLG_FIELDS_TEXTBOX_VALIDATION_INPUT_TOO_SHORT'));
                            return false;
                        }

                        if(self.options.max > 0 && value.length > self.options.max) {
                            self.raiseError($.language('PLG_FIELDS_TEXTBOX_VALIDATION_INPUT_TOO_LONG'));
                            return false;
                        }

                        return true;
                    },

                    raiseError: function(msg) {
                        self.trigger('error', [msg]);
                    },

                    clearError: function() {
                        self.trigger('clear');
                    },

                    '{self} onError': function(el, ev, type) {
                        if(type === 'required') {
                            self.raiseError($.language('PLG_FIELDS_TEXTBOX_VALIDATION_INPUT_REQUIRED'));
                        }

                        if(type === 'validate') {
                            self.raiseError($.language('PLG_FIELDS_TEXTBOX_VALIDATION_INPUT_INVALID_FORMAT'));
                        }
                    },

                    '{self} onSubmit': function(el, ev, register) {
                        register.push(self.validateInput());
                    }
                }
            });

            module.resolve();
        });
});

EasySocial.module('apps/fields/user/textbox/sample_content', function($) {
    var module = this;

    EasySocial.Controller('Field.Textbox.Sample', {
        defaultOptions: {
            '{input}'           : '[data-input]',

            'min'                   : '',
            'max'                   : '',
            'regex_validate'        : false,
            'regex_format'          : '',
            'regex_modifier'        : ''
        }
    }, function(self) {
        return {
            init: function() {

            },

            '{self} onConfigChange': function(el, event, name, value) {
                switch(name) {
                    case 'placeholder':
                        self.input().attr('placeholder', value);
                    break;

                    case 'default':
                        self.input().val(value);
                    break;

                    case 'readonly':
                        if(value) {
                            self.input().attr('disabled', 'disabled');
                        } else {
                            self.input().removeAttr('disabled');
                        }
                        break;
                    break;
                }
            }
        }
    });

    module.resolve();
});

EasySocial.module('apps/fields/user/url/content', function($) {
    var module = this;

    EasySocial
        .require()
        .language('PLG_FIELDS_URL_VALIDATION_EMPTY_URL')
        .done(function($) {
            EasySocial.Controller('Field.Url', {
                defaultOptions: {
                    required        : false,

                    '{input}'       : '[data-field-url-input]'
                }
            }, function( self ) {
                return {
                    init: function() {
                    },

                    '{input} blur': function() {
                        self.validateInput();
                    },

                    validateInput: function() {
                        self.clearError();

                        var value = self.input().val();

                        if(self.options.required && $.isEmpty(value)) {
                            self.raiseError($.language('PLG_FIELDS_URL_VALIDATION_EMPTY_URL'));
                            return false;
                        }

                        return true;
                    },

                    raiseError: function(msg) {
                        self.trigger('error', [msg]);
                    },

                    clearError: function() {
                        self.trigger('clear');
                    },

                    '{self} onError': function(el, event, type, field) {
                        self.raiseError($.language('PLG_FIELDS_URL_VALIDATION_EMPTY_URL'));
                    }
                }
            });

            module.resolve();
        });
});

EasySocial.module('apps/fields/user/url/sample_content', function($) {
    var module = this;

    EasySocial.Controller('Field.Url.Sample', {
        defaultOptions: {
            '{urlInput}': '[data-url-input]'
        }
    }, function(self) {
        return {
            '{self} onConfigChange': function(el, event, name, value) {
                switch(name) {
                    case 'placeholder':
                        self.urlInput().attr('placeholder', value);
                    break;

                    case 'default':
                        self.urlInput().val(value);
                    break;
                }
            }
        }
    });

    module.resolve();
});

EasySocial.module('apps/group/feeds', function($) {

    var module  = this;

    EasySocial.Controller('Groups.Apps.Feeds',
        {
            defaultOptions: {
                "{browser}": "[data-feeds-browser]",
                "{sources}": "[data-feeds-sources]",
                "{item}": "[data-feeds-list-item]",
                "{create}" : "[data-feeds-create]",
                "{list}": "[data-feeds-list]",
                "{remove}": "[data-feeds-remove]"
            }
        }, function(self) {

            return {

                init: function()
                {
                    self.options.id = self.element.data('groupid');
                    self.options.appId = self.element.data('appid');

                    self.list().implement(EasySocial.Controller.Groups.Apps.Feeds.List);
                },

                "{remove} click": function(el)
                {
                    var feedId = $(el).data('id'),
                        item = self.item.of(el);

                    EasySocial.dialog({
                        content: EasySocial.ajax('apps/group/feeds/controllers/feeds/confirmDelete', {"groupId" : self.options.id}),
                        bindings: {
                            "{deleteButton} click": function() {

                                EasySocial.ajax('apps/group/feeds/controllers/feeds/delete', {
                                    "appId": self.options.appId,
                                    "feedId": feedId,
                                    "groupId": self.options.id
                                })
                                .done(function(){

                                    // Remove the feed source
                                    item.remove();

                                    // Determine if there's no more item to be displayed
                                    if (self.sources().children().length == 0) {
                                        self.browser().addClass('is-empty');
                                    }

                                    EasySocial.dialog().close();
                                });
                            }
                        }
                    });
                },

                "{create} click": function()
                {
                    EasySocial.dialog({
                        content: EasySocial.ajax('apps/group/feeds/controllers/feeds/create', {"id" : self.options.id}),
                        bindings: {
                            "{saveButton} click": function() {


                                var title = this.title().val(),
                                    url = this.url().val();

                                var notice = $('[data-feeds-form-notice]');

                                // first remove all the alert styling.
                                notice.removeClass('alert alert-error');
                                notice.addClass('hide');


                                if (title.trim().length == 0) {
                                    notice.text( $.language('Please enter title.') );
                                    notice.addClass('alert alert-error');
                                    notice.removeClass('hide');
                                    return;
                                }

                                if (url.trim().length == 0) {
                                    notice.text( $.language('Please enter URL.') );
                                    notice.addClass('alert alert-error');
                                    notice.removeClass('hide');
                                    return;
                                }


                                EasySocial.ajax('apps/group/feeds/controllers/feeds/save', {
                                    "title": this.title().val(),
                                    "url": this.url().val(),
                                    "appId": self.options.appId,
                                    "groupId": self.options.id
                                })
                                .done(function(output){

                                    // Whenever a new feed item is created, it should never be empty.
                                    self.browser().removeClass('is-empty');

                                    // Append output to the list
                                    self.sources().append(output);

                                    EasySocial.dialog().close();
                                });
                            }
                        }
                    });
                }
            }
        });

    EasySocial.Controller('Groups.Apps.Feeds.List', {
        defaultOptions: {
            "{item}": "[data-feed-item]",
            "{openPreview}" : "[data-feed-open]",
            "{preview}": "[data-feed-preview]"
        }
    }, function(self) {
        return {
            init: function()
            {
            },

            "{openPreview} click": function(el)
            {
                var item = self.item.of(el),
                    preview = item.find(self.preview.selector);

                // If it's already open, hide it
                if (!preview.hasClass('hide')) {
                    preview.addClass('hide');
                } else {
                    // Hide all items first
                    self.preview().addClass('hide');

                    // Only display the clicked item
                    preview.removeClass('hide');
                }
            }
        }
    });
    module.resolve();
});


EasySocial.module( 'apps/group/tasks' , function($)
{
    var module  = this;

    EasySocial.Controller(
        'Groups.Apps.Tasks.Milestones.Browse',
        {
            defaultOptions:
            {
                "{milestone}"   : "[data-group-tasks-milestone-item]"
            }
        },
        function(self)
        {
            return {
                init: function()
                {
                    self.options.groupId    = self.element.data( 'groupid' );

                    self.milestone().implement( EasySocial.Controller.Groups.Apps.Tasks.Milestones.Item ,
                        {
                            "{parent}"  : self
                        });
                }
            }
        });

    EasySocial.Controller(
        'Groups.Apps.Tasks.Milestones.Item',
        {
            defaultOptions:
            {
                "{complete}"    : "[data-milestone-mark-complete]",
                "{uncomplete}"  : "[data-milestone-mark-uncomplete]",
                "{delete}"      : "[data-milestone-delete]",
                "{milestone}"   : "[data-group-tasks-milestone-item]"
            }
        },
        function(self)
        {
            return {
                init: function()
                {
                    self.options.id     = self.element.data( 'id' );
                },

                "{uncomplete} click" : function()
                {
                    EasySocial.ajax( 'apps/group/tasks/controllers/milestone/unresolve' ,
                    {
                        id      : self.options.id,
                        groupId : self.parent.options.groupId
                    })
                    .done(function()
                    {
                        self.element.removeClass( 'is-due' ).removeClass( 'is-completed' );
                    });
                },

                "{complete} click" : function()
                {
                    EasySocial.ajax( 'apps/group/tasks/controllers/milestone/resolve' ,
                    {
                        id      : self.options.id,
                        groupId : self.parent.options.groupId
                    })
                    .done(function()
                    {
                        self.element.removeClass( 'is-due' ).addClass( 'is-completed' );
                    });
                },

                "{delete} click" : function()
                {
                    EasySocial.dialog(
                    {
                        content : EasySocial.ajax( 'apps/group/tasks/controllers/milestone/confirmDelete' ,
                        {
                            id          : self.options.id,
                            groupId     : self.parent.options.groupId
                        }),
                        bindings:
                        {
                            '{deleteButton} click' : function()
                            {
                                EasySocial.ajax( 'apps/group/tasks/controllers/milestone/delete' ,
                                {
                                    id  : self.options.id,
                                    groupId : self.parent.options.groupId
                                })
                                .done(function()
                                {
                                    EasySocial.dialog().close();

                                    self.element.remove();
                                });
                            }
                        }
                    });
                }
            }
        });

    EasySocial.Controller(
        'Groups.Apps.Tasks',
        {
            defaultOptions:
            {
                '{form}'    : '[data-group-tasks-form]',
                '{formWrapper}' : '[data-group-tasks-form-wrapper]',
                '{taskList}': '[data-group-tasks-list]',
                '{item}'    : '[data-group-tasks-list-item]',
                '{completedList}'   : '[data-group-tasks-completed]',
                '{openCounter}'     : '[data-tasks-open-counter]',
                '{closedCounter}'   : '[data-tasks-closed-counter]',
                "{completeMilestone}"   : "[data-milestone-mark-complete]",
                "{uncompleteMilestone}" : "[data-milestone-mark-uncomplete]",
                "{deleteMilestone}"     : "[data-milestone-delete]",
                "{wrapper}"             : "[data-group-tasks-wrapper]"
            }
        },
        function( self )
        {
            return {
                init: function()
                {
                    self.options.id         = self.element.data( 'id' );
                    self.options.groupId    = self.element.data( 'groupid' );
                    self.options.milestoneId    = self.element.data( 'milestoneid' );

                    // Implement form controller
                    self.form().implement( EasySocial.Controller.Groups.Apps.Tasks.Form , { "{parent}" : self });

                    // Implement task item controller
                    self.implementItemController();
                },
                implementItemController: function()
                {
                    self.item().implement( EasySocial.Controller.Groups.Apps.Tasks.Item , { "{parent}" : self } );
                },
                updateOpenCounter: function( total )
                {
                    self.openCounter().html( total );
                },
                updateClosedCounter: function( total )
                {
                    self.closedCounter().html( total );
                },
                insertCompleted: function( taskItem )
                {
                    $( taskItem ).appendTo( self.completedList() );
                },
                insertTask: function( taskItem )
                {
                    self.formWrapper().after(taskItem);

                    self.implementItemController();
                },
                "{uncompleteMilestone} click" : function()
                {
                    EasySocial.ajax( 'apps/group/tasks/controllers/milestone/unresolve' ,
                    {
                        id      : self.options.milestoneId,
                        groupId : self.options.groupId
                    })
                    .done(function()
                    {
                        self.wrapper().removeClass( 'is-due' ).removeClass( 'is-completed' );
                    });
                },
                "{completeMilestone} click" : function()
                {
                    EasySocial.ajax( 'apps/group/tasks/controllers/milestone/resolve' ,
                    {
                        id      : self.options.milestoneId,
                        groupId : self.options.groupId
                    })
                    .done(function()
                    {
                        self.wrapper().removeClass( 'is-due' ).addClass( 'is-completed' );
                    });
                },

                "{deleteMilestone} click" : function()
                {
                    EasySocial.dialog(
                    {
                        content : EasySocial.ajax( 'apps/group/tasks/controllers/milestone/confirmDelete' ,
                        {
                            id          : self.options.milestoneId,
                            groupId     : self.options.groupId
                        }),
                        bindings:
                        {
                            '{deleteButton} click' : function()
                            {
                                EasySocial.ajax( 'apps/group/tasks/controllers/milestone/delete' ,
                                {
                                    id  : self.options.id,
                                    groupId : self.options.groupId
                                })
                                .done(function()
                                {
                                    EasySocial.dialog().close();

                                    window.location = self.options.redirect;
                                });
                            }
                        }
                    });
                }
            }
        }
    );

    EasySocial.Controller(
        'Groups.Apps.Tasks.Item',
        {
            defaultOptions:
            {
                '{checkbox}'    : '[data-item-checkbox]',
                '{delete}'      : '[data-tasks-item-remove]'
            }
        },
        function( self )
        {
            return {
                init: function()
                {
                    self.options.id     = self.element.data( 'id' );
                },
                '{delete} click' : function()
                {
                    EasySocial.dialog(
                    {
                        content     : EasySocial.ajax( 'apps/group/tasks/controllers/tasks/confirmDelete' , { 'groupId' : self.parent.options.groupId }),
                        bindings    :
                        {
                            '{deleteButton} click' : function()
                            {
                                EasySocial.ajax( 'apps/group/tasks/controllers/tasks/delete' ,
                                {
                                    id  : self.options.id,
                                    groupId : self.parent.options.groupId
                                })
                                .done(function()
                                {
                                    EasySocial.dialog().close();

                                    var total   = parseInt( self.parent.openCounter().html() );

                                    self.parent.updateOpenCounter( total - 1 );

                                    self.element.remove();
                                });
                            }
                        }
                    });

                },
                '{checkbox} change': function( el , event )
                {
                    var checked = $( el ).is( ':checked' );

                    if( checked )
                    {
                        EasySocial.ajax( 'apps/group/tasks/controllers/tasks/resolve' ,
                        {
                            id          : self.options.id,
                            groupId     : self.parent.options.groupId
                        })
                        .done(function()
                        {
                            // Decrease the open counter
                            var total   = parseInt( self.parent.openCounter().html() );

                            self.parent.updateOpenCounter( total - 1 );

                            var total   = parseInt( self.parent.closedCounter().html() );

                            self.parent.updateClosedCounter( total + 1 );

                            self.parent.insertCompleted( self.element );
                        });

                    }
                    else
                    {
                        EasySocial.ajax( 'apps/group/tasks/controllers/tasks/unresolve' ,
                        {
                            id          : self.options.id,
                            groupId     : self.parent.options.groupId
                        })
                        .done(function($)
                        {
                            // Decrease the open counter
                            var total   = parseInt( self.parent.openCounter().html() );

                            self.parent.updateOpenCounter( total + 1 );

                            var total   = parseInt( self.parent.closedCounter().html() );

                            self.parent.updateClosedCounter( total - 1 );

                            self.parent.insertTask( self.element );
                        });
                    }
                }
            }
        });

    EasySocial.Controller(
        'Groups.Apps.Tasks.Form',
        {
            defaultOptions:
            {
                '{title}'   : "[data-form-tasks-title]",
                '{create}'  : "[data-form-tasks-create]",
                '{assignee}': "[data-form-tasks-assignee]",
                '{due}'     : "[data-form-tasks-due]",
                '{error}'   : "[data-group-tasks-form-error]"
            }
        },
        function(self)
        {
            return {
                init: function()
                {

                },

                resetForm: function()
                {
                    self.element[0].reset();
                },

                "{title} keyup" : function( el , event )
                {
                    // Enter key
                    if(event.keyCode == 13)
                    {
                        self.create().click();
                    }
                },

                "{create} click" : function()
                {
                    if( self.title().val() == '' )
                    {
                        self.error().removeClass( 'hide' );

                        return false;
                    }

                    self.error().addClass( 'hide' );

                    EasySocial.ajax( 'apps/group/tasks/controllers/tasks/save' ,
                    {
                        title       : self.title().val(),
                        assignee    : self.assignee().val(),
                        due         : self.due().val(),
                        groupId     : self.parent.options.groupId,
                        milestoneId : self.parent.options.id
                    })
                    .done(function( content )
                    {
                        // Reset the form
                        self.resetForm();

                        // Increment the counter
                        var total   = parseInt( self.parent.openCounter().html() );

                        self.parent.updateOpenCounter( total + 1 );

                        self.parent.insertTask( content );
                    });
                }
            }
        });

    module.resolve();
});


EasySocial.module( 'avatar' , function($){

	var module = this;

	EasySocial.Controller( 'Avatar',
		{
			defaultOptions:
			{
				uid 			: null,
				type 			: null,
				redirectUrl 	: null,
				"{menu}"		: "[data-avatar-menu]",
				"{uploadButton}": "[data-avatar-upload-button]",
				"{selectButton}": "[data-avatar-select-button]",
				"{removeButton}": "[data-avatar-remove-button]"
			}
		},
		function( self )
		{
			return {

				init: function()
				{
				},

				"{uploadButton} click": function()
				{
					EasySocial.dialog(
					{
						content: EasySocial.ajax( 'site/views/avatar/upload' , { 'uid' : self.options.uid , 'type' : self.options.type })
					});
				},

				"{selectButton} click": function()
				{
					EasySocial.photos.selectPhoto(
					{
						uid		: self.options.uid,
						type 	: self.options.type,
						bindings:
						{
							"{self} photoSelected": function(el, event, photos)
							{

								// Photo selection dialog returns an array,
								// so just pick the first one.
								var photo = photos[0];

								// If no photo selected, stop.
								if (!photo)
								{
									return;
								}

								EasySocial.photos.createAvatar( photo.id , { "uid" : self.options.uid , "type" : self.options.type , "redirectUrl" : self.options.redirectUrl } );
							},

							"{cancelButton} click": function() {
								this.parent.close();
							}
						}
					});
				},

	            "{menu} shown.bs.dropdown": function()
	            {
	                 self.element.addClass("show-all");
	            },

	            "{menu} hidden.bs.dropdown": function()
	            {
	                 self.element.removeClass("show-all");
	            },

				"{removeButton} click": function()
				{

				}

			}
		}
	);

	module.resolve();
});

EasySocial.module('cover', function($) {

var module = this;

EasySocial.require()
    .library("image")
    .done(function(){

        EasySocial.Controller('Cover', {
            defaultOptions: {
                uid                 : null,
                type                : null,
                "{image}"           : "[data-cover-image]",
                "{editButton}"      : "[data-cover-edit-button]",
                "{doneButton}"      : "[data-cover-done-button]",
                "{cancelButton}"    : "[data-cover-cancel-button]",
                "{uploadButton}"    : "[data-cover-upload-button]",
                "{selectButton}"    : "[data-cover-select-button]",
                "{removeButton}"    : "[data-cover-remove-button]",
                "{menu}"            : "[data-cover-menu]",

                // Hack to disable click that causes photo popup on the flyout
                "{flyout}"          : ".es-flyout-content"
            }
        },
        function(self, opts, base) { return {

            init: function() {

                // Automatically enable cover editing if not manually disabled
                // if (!self.options.disabled) { self.start("url"); }

                self.setLayout();

                if (self.element.hasClass("editing")) {
                    self.enable();
                }
            },

            "{editButton} click": function() {
                self.enable();

                // Mark a flag as repositioning only
                self.reposition = true;

                // After enabling, manually get the position from self.element and apply it
                self.image().css('backgroundPosition', self.element.css('backgroundPosition'));
            },

            "{cancelButton} click": function(el, ev) {
                self.disable();
            },

            reposition: false,

            ready: false,

            disabled: true,

            toggle: function() {
                self[(self.disabled) ? "enable" : "disable"]();
            },

            enable: function() {
                self.setLayout();
                self.disabled = false;
                self.element.addClass("editing");
                base.attr("data-es-photo-disabled", 1);
            },

            disable: function() {
                self.reposition = false;
                self.disabled = true;
                self.element.removeClass("editing");

                // Allow some time before enabling photo popup
                setTimeout(function(){
                    base.attr("data-es-photo-disabled", 0);
                }, 1);

                var profileUrl =
                    $.uri(window.location.href)
                        .deleteQueryParam("cover_id")
                        .toString();

                History.pushState({state: 0}, window.title, profileUrl);
            },

            imageLoaders: {},

            setLayout: function() {

                var cover = self.image(),
                    image = self.setLayout.image;

                if (!image) {

                    // Extract image url from cover
                    var url = $.uri(cover.css("backgroundImage")).extract(0);

                    // If no url given, stop.
                    if (!url) return;

                    // Load image
                    var imageLoaders = self.imageLoaders,
                        imageLoader =
                            (imageLoaders[url] || (imageLoaders[url] = $.Image.get(url)))
                                .done(function(image) {

                                    // Set it as current image
                                    self.setLayout.image = image;

                                    // Then set layout again
                                    self.setLayout();
                                });

                        return;
                }

                // Get measurements
                var imageWidth  = image.data("width"),
                    imageHeight = image.data("height"),
                    coverWidth  = cover.width(),
                    coverHeight = cover.height(),
                    size = $.Image.resizeProportionate(
                        imageWidth, imageHeight,
                        coverWidth, coverHeight,
                        "outer"
                    );

                self.availableWidth  = coverWidth  - size.width;
                self.availableHeight = coverHeight - size.height;
            },

            setCover: function(id, url) {

                // Show loading indicator
                self.element.addClass("loading");

                // Make sure the image has been properly loading
                $.Image.get(url)
                    .done(function(){

                        self.image()
                            .data("photoId", id)
                            .css({
                                backgroundImage: $.cssUrl(url),
                                backgroundPosition: "50% 50%"
                            });

                        // Reset position
                        self.x = 0.5;
                        self.y = 0.5;

                        self.enable();
                    })
                    .fail(function(){
                        self.disable();
                    })
                    .always(function(){

                        self.element.removeClass("loading");
                    });
            },

            drawing: false,

            moveCover: function(dx, dy, image) {

                // Optimization: Pass in reference to image
                // so we don't have to query all the time.
                if (!image) { image = self.image(); }

                var w = self.availableWidth,
                    h = self.availableHeight,
                    x = (w==0) ? 0 : self.x + ((dx / w) || 0),
                    y = (h==0) ? 0 : self.y + ((dy / h) || 0);

                // Always stay within 0 to 1.
                if (x < 0) x = 0; if (x > 1) x = 1;
                if (y < 0) y = 0; if (y > 1) y = 1;

                // Set position on cover
                image.css("backgroundPosition",
                    ((self.x = x) * 100) + "% " +
                    ((self.y = y) * 100) + "% "
                );
            },

            x: 0.5,

            y: 0.5,

            "{image} click": function(el, event) {
                if (!self.disabled) {
                    event.stopPropagation();
                }
            },

            "{image} mousedown": function(selection, event) {

                if (self.disabled || self.drawing) return;

                if (event.target === self.image()[0]) {
                    event.preventDefault();
                }

                self.drawing = true;
                base.addClass("active");

                // Initial cover position
                var image = self.image(),
                    position = self.image().css("backgroundPosition").split(" ");
                    self.x = parseInt(position[0]) / 100;
                    self.y = parseInt(position[1]) / 100;

                // Initial cursor position
                var x = event.pageX,
                    y = event.pageY;

                $(document)
                    .on("mousemove.movingCover mouseup.movingCover", function(event) {

                        if (!self.drawing) return;

                        self.moveCover(
                            (x - (x = event.pageX)) * -1,
                            (y - (y = event.pageY)) * -1,
                            image
                        );
                    })
                    .on("mouseup.movingCover", function(event) {
                        $(document).off("mousemove.movingCover mouseup.movingCover");

                        base.removeClass("active");

                        self.drawing = false;
                    });
            },

            "{image} touchstart": function(selection, event) {

                if (self.disabled || self.drawing) return;

                self.drawing = true;
                base.addClass("active");

                // Initial cover position
                var image = self.image(),
                    position = self.image().css("backgroundPosition").split(" ");
                    self.x = parseInt(position[0]) / 100;
                    self.y = parseInt(position[1]) / 100;

                // Initial touch position
                var touch = event.originalEvent.targetTouches[0],
                    x = event.pageX,
                    y = event.pageY;

                $(document)
                    .on("touchmove.movingCover", function(event) {

                        if (!self.drawing) return;

                        var touch = event.originalEvent.targetTouches[0];

                        self.moveCover(
                            (x - (x = touch.pageX)) * -1,
                            (y - (y = touch.pageY)) * -1,
                            image
                        );

                        event.preventDefault();
                    })
                    .on("touchend.movingCover", function(){

                        $(document).off("touchstart.movingCover touchend.movingCover");

                        base.removeClass("active");

                        self.drawing = false;
                    });
            },

            save: function() {

                var photoId = self.image().data("photoId");

                var task =
                    EasySocial.ajax(
                        "site/controllers/cover/create",
                        {
                            uid: self.options.uid,
                            type: self.options.type,
                            id: photoId,
                            x: self.x,
                            y: self.y,
                            reposition: self.reposition ? 1 : 0
                        }
                    )
                    .done(function(cover)
                    {
                        // Set cover
                        base
                            .attr("data-es-photo", photoId)
                            .css({
                                backgroundImage: $.cssUrl(cover.url),
                                backgroundPosition: cover.position
                            })
                            .removeClass("no-cover");

                        // Disable editing
                        self.disable();
                    });

                return task;
            },

            "{doneButton} click": function(el, event) {
                self.save();
            },

            "{menu} shown.bs.dropdown": function() {
                 self.element.addClass("show-all");
            },

            "{menu} hidden.bs.dropdown": function() {
                 self.element.removeClass("show-all");
            },

            "{selectButton} click": function() {

                base.attr('data-es-photo-disabled', 1);

                EasySocial.photos.selectPhoto(
                {
                    uid     : self.options.uid,
                    type    : self.options.type,
                    bindings:
                    {
                        "{self} photoSelected": function(el, event, photos) {

                            // Photo selection dialog returns an array,
                            // so just pick the first one.
                            var photo = photos[0];

                            // If no photo selected, stop.
                            if (!photo) return;

                            // Set it as cover to reposition
                            self.setCover(photo.id, photo.sizes.large);

                            this.parent.close();

                            base.attr('data-es-photo-disabled', 0);
                        },

                        "{cancelButton} click": function(el, event) {
                            this.parent.close();

                            base.attr('data-es-photo-disabled', 0);
                        }
                    }
                });
            },

            "{uploadButton} click": function() {
                base.attr('data-es-photo-disabled', 1);

                EasySocial.dialog({
                    content: EasySocial.ajax("site/views/cover/uploadDialog", { "uid" : self.options.uid , "type" : self.options.type }),
                    bindings: {
                        "{self} upload": function(el, event, task, filename) {

                            task.done(function(photo){
                                // Set cover
                                self.setCover(photo.id, photo.sizes.large.url);
                            });
                        },

                        "{cancelButton} click": function() {
                            this.parent.close();

                            base.attr('data-es-photo-disabled', 0);
                        }
                    }
                });
            },

            "{removeButton} click": function() {
                // We should check if there's anything to delete.

                EasySocial.ajax("site/controllers/cover/remove", { "uid" : self.options.uid , "type" : self.options.type })
                    .done(function(defaultCoverUrl)
                    {
                        base.css({
                                backgroundImage: $.cssUrl(defaultCoverUrl),
                                backgroundPosition: "50% 50%"
                            })
                            .addClass("no-cover")
                            .removeAttr("data-es-photo");

                        self.disable();
                    });
            },

            "{flyout} click": function(el, ev) {
                if (el.is($(ev.target))) {
                    ev.stopPropagation();
                }
            }
        }});

        module.resolve();

    });
});

EasySocial.require()
	.script(
		"site/likes/likes",
		"site/reports/reports",
		"site/blocks/blocks",
		"site/repost/repost",
		"site/share/share",
		"site/layout/dialog",
		"site/layout/responsive",
		"site/layout/elements",
		"site/photos/photos",
		"site/users/login",
		"site/profile/popbox",
		"site/privacy/privacy",
		"site/locations/popbox",
		"site/sidebar/sidebar",
		"site/friends/api",
		"site/popbox/popbox",
		"site/conversations/api",
		"site/groups/api",
		"site/followers/api",
		"site/stream/video",
		"oauth/facebook"
	)
	.library("history")
	.done();

EasySocial.module('site/likes/likes', function($){

	var module = this;

	$(document)
		.on("click.es.likes.action", "[data-likes-action]", function(){

			var button = $(this),
				data = {
					id   : button.data("id"),
					type : button.data("type"),
					group: button.data("group"),
					verb: button.data("verb"),
					streamid : button.data("streamid")
				},
				key = data.type + "-" + data.group + "-" + data.id;

			EasySocial.ajax("site/controllers/likes/toggle", data)
				.done(function(content, label, showOrHide, actionVerb, count) {

					// Update like label
					button.text(label);

					//streamid
					id = button.data("streamid");

					// Update like content
					$("[data-likes-" + key + "]")
						.html(content)
						.toggleClass("hide", showOrHide)
						.toggle(!showOrHide);

					// Furnish data with like count
					data.uid   = data.id; // inconsistency
					data.count = count;

					// verb = like/unlike
					button.trigger((actionVerb=="like") ? "onLiked" : "onUnliked", [data]);

					if( actionVerb == 'like' && id != "" )
					{
						//update excludeids

						ids = $('[data-streams-wrapper]').data( 'excludeids' );

						newIds = '';
						if( ids != '' && ids != undefined )
						{
							newIds = ids + ',' + id;
						}
						else
						{
							newIds = id;
						}

						$('[data-streams-wrapper]').data( 'excludeids', newIds );
					}
				})
				.fail(function(message) {

					console.log(message);
				});
		})
		.on("click.es.likes.others", "[data-likes-others]", function(){

			var button = $(this),
				content = button.parents("[data-likes-content]"),
				data = {
					uid    : content.data("id"),
					type   : content.data("type"),
					verb   : content.data('verb'),
					group  : content.data('group'),
					exclude: button.data("authors")
				};

			EasySocial.dialog({
				content: EasySocial.ajax("site/controllers/likes/showOthers", data)
			});
		});

	module.resolve();
});

EasySocial.module("site/reports/reports", function($) {

	$(document).on("click.es.reports.link", "[data-reports-link]", function(){

		var button = $(this),
			props  = "url,extension,uid,type,object,title,description".split(","),
			data   = {};

		$.each(props, function(i, prop){
			data[prop] = button.data(prop);
		});
		
		EasySocial.dialog({

			content: EasySocial.ajax(
				"site/views/reports/confirmReport",
				{
					title: data.title,
					description: data.description
				}),

			selectors: {
				"{message}"     : "[data-reports-message]",
				"{reportButton}": "[data-report-button]",
				"{cancelButton}": "[data-cancel-button]"
			},

			bindings: {

				"{reportButton} click": function() {

					var message	= this.message().val();

					EasySocial.dialog({
						content: EasySocial.ajax(
							"site/controllers/reports/store",
							{
								url      : data.url,
								extension: data.extension,
								uid      : data.uid,
								type     : data.type,
								title    : data.object,
								message  : message
							})
					});
				},

				"{cancelButton} click": function() {
					EasySocial.dialog().close();
				}		
			}	
		});
	});

	this.resolve();

});

EasySocial.module("site/blocks/blocks", function($) {

	$(document).on("click.es.blocks.link", "[data-blocks-link]", function(){

		var target = $(this).data('target');

		EasySocial.dialog({

			content: EasySocial.ajax(
				"site/views/blocks/confirmBlock",
				{
					"target": target
				}),

				selectors: {
					"{reason}": "[data-block-reason]",
					"{blockButton}": "[data-block-button]",
					"{cancelButton}": "[data-cancel-button]"
				},

				bindings: {

					"{blockButton} click": function() {

						var reason = this.reason().val();

						EasySocial.dialog({
							content: EasySocial.ajax(
								"site/controllers/blocks/store",
								{
									"target": target,
									"reason": reason
								})
							});
					},

					"{cancelButton} click": function() {
						EasySocial.dialog().close();
					}
				}
		});
	});


	$(document).on("click.es.unblock.link", "[data-unblock-link]", function(){

		var target = $(this).data('target');

		EasySocial.dialog({

			content: EasySocial.ajax(
				"site/views/blocks/confirmUnblock",
				{
					"target": target
				}),

				selectors: {
					"{unblockButton}": "[data-unblock-button]",
					"{cancelButton}": "[data-cancel-button]"
				},

				bindings: {

					"{unblockButton} click": function() {

						EasySocial.dialog({
							content: EasySocial.ajax(
								"site/controllers/blocks/unblock",
								{
									"target": target
								})
								.done(function() {

									// remove the user from the listing page.
									$('[data-blocked-user-' + target + ']').remove();

								}),

							selectors: {
								"{cancelButton}": "[data-cancel-button]"
							},

							bindings: {
								"{cancelButton} click": function() {
									EasySocial.dialog().close();
								}
							}
						});
					},

					"{cancelButton} click": function() {
						EasySocial.dialog().close();
					}
				}
		});
	});

	this.resolve();

});

EasySocial.module("site/repost/repost", function($){

	var module 	= this;

	EasySocial.require()
	.view(
		"site/friends/suggest.item",
		"site/friends/suggest.hint.search",
		"site/friends/suggest.hint.empty",
		"site/hashtags/suggest.item",
		"site/hashtags/suggest.hint.search",
		"site/hashtags/suggest.hint.empty"
	)
	.library( 'mentions' )
	.done(function()
	{
		$(document)
			.on("click.es.repost.action", "[data-repost-action]", function(){

				var button = $(this),
					data = {
						id     : button.data('id'),
						element: button.data('element'),
						group  : button.data('group'),
						clusterId  : button.data('clusterid'),
						clusterType  : button.data('clustertype'),
					},
					key = data.element + '-' + data.group + '-' + data.id;


				EasySocial.dialog(
				{
					content	: EasySocial.ajax( 'site/views/repost/form' , data ),
					bindings:
					{
						init: function()
						{
							this.setMentionsLayout();
						},
						setMentionsLayout: function()
						{
							var textbox		= this.textbox(),
								mentions	= textbox.controller("mentions");

							if (mentions)
							{
								mentions.cloneLayout();
								return;
							}

							var header = this.header();

							textbox
								.mentions({
									triggers: {
									    "@": {
											type: "entity",
											wrap: false,
											stop: "",
											allowSpace: true,
											finalize: true,
											query: {
												loadingHint: true,
												searchHint: $.View("easysocial/site/friends/suggest.hint.search"),
												emptyHint: $.View("easysocial/site/friends/suggest.hint.empty"),
												data: function(keyword) {

													var task = $.Deferred();

													EasySocial.ajax("site/controllers/friends/suggest", {search: keyword})
														.done(function(items){

															if (!$.isArray(items)) task.reject();

															var items = $.map(items, function(item){
																item.title = item.screenName;
																item.type = "user";
																item.menuHtml = $.View( 'easysocial/site/friends/suggest.item' , true, { item: item, name: "uid[]" });
																return item;
															});

															task.resolve(items);
														})
														.fail(task.reject);

													return task;
												},
												use: function(item) {
													return item.type + ":" + item.id;
												}
										    }
										},
										"#": {
										    type: "hashtag",
										    wrap: true,
										    stop: " #",
										    allowSpace: false,
											query: {
												loadingHint: true,
												searchHint: $.View("easysocial/site/hashtags/suggest.hint.search"),
												emptyHint: $.View("easysocial/site/hashtags/suggest.hint.empty"),
												data: function(keyword) {

													var task = $.Deferred();

													EasySocial.ajax("site/controllers/hashtags/suggest", {search: keyword})
														.done(function(items){

															if (!$.isArray(items)) task.reject();

															var items = $.map(items, function(item){
																item.title = "#" + item.title;
																item.type = "hashtag";
																item.menuHtml = $.View( 'easysocial/site/hashtags/suggest.item' , true, { item: item, name: "uid[]" });
																return item;
															});

															task.resolve(items);
														})
														.fail(task.reject);

													return task;
												}
										    }
										}
									},
									plugin: {
										autocomplete: {
											id: "fd",
											component: "es",
											modifier: "es-story-mentions-autocomplete",
											sticky: true,
											shadow: true,
											position: {
												my: 'left top',
												at: 'left bottom',
												of: header,
												collision: 'none'
											},
											size: {
												width: function() {
													return header.outerWidth(true);
												}
											}
										}
									}
								});
						},
						"{sendButton} click": function(sendButton)
						{
							var dialog = this.parent,
								content = $.trim(this.repostContent().val());

							// Add data content
							data.content = content;

							var mentions = this.textbox().mentions("controller").toArray();

							data.mentions = $.map(mentions, function(mention){
								if (mention.type==="hashtag" && $.isPlainObject(mention.value)) {
									mention.value = mention.value.title.slice(1);
								}
								return JSON.stringify(mention);
							});

							dialog.loading( true );

							EasySocial.ajax("site/controllers/repost/share", data )
								.done(function(content, isHidden, count, streamHTML)
								{
									var content = $.buildHTML(content);

									actionContent =
										$('[data-repost-' + key + ']')
											.toggleClass("hide", isHidden)
											.toggle(!isHidden);

									actionContent.find("span.repost-counter")
										.html(content);

									button.trigger("create", [streamHTML]);
								})
								.fail(function(message)
								{
									dialog.clearMessage();
									dialog.setMessage( message );
								})
								.always(function()
								{
									dialog.loading( false );
									dialog.close();
								});
						}
					}
				});
			});

		EasySocial.module("repost/authors", function(){

			this.resolve(function(popbox){

				var repost = popbox.button.parents("[data-repost-content]")
					data = {
						id     : repost.data("id"),
						element: repost.data("element")
					};

				return {
					content: EasySocial.ajax('site/controllers/repost/getSharers', data),
					id: "fd",
					component: "es",
					type: "repost",
					position: "bottom-right"
				}
			});
		});

		module.resolve();
	});
});

EasySocial.module("site/share/share", function($){

	$(document)
		.on("click.es.share.button", "[data-es-share-button]", function(){

			var button = $(this);

			EasySocial.dialog({
				title: button.text(),
				width:500,
				content:
					EasySocial.ajax(
						"site/views/sharing/shareDialog",
						{
							url: button.data("url"),
							title: button.data("title")
						})
			});
		});

	this.resolve();
});

EasySocial.module( 'site/layout/dialog' , function($){

	var module = this;

	// Dialog
	EasySocial.require()
		.library('dialog')
		.view('site/dialog/default')
		.done(function($){

			EasySocial.dialog = function(options) {

				// TODO: Isolate this from global dialog
				if (window.parentDialog) {
					return window.parentDialog.update(options);
				}

				// Normalize arguments
				if (typeof options === "string" || $.isDeferred(options)) {
					var afterShow = arguments[1];
					options = {
						content: options,
						afterShow: ($.isFunction(afterShow)) ? afterShow : $.noop
					}
				}

				var dialogElement = $('[id=fd].es-dialog.global');

				if (dialogElement.length < 1) {

					dialogElement =
						$(EasySocial.View('site/dialog/default'))
							.addClass('global')
							.appendTo('body');
				};

				var defaultOptions = {
						showOverlay: false
					},
					options = $.extend(defaultOptions, options);

				var dialogController = dialogElement.controller("Dialog");

				if (!dialogController) {
					dialogController = dialogElement.addController("Dialog", options);
				} else {
					dialogController.update(options);
				}

				return dialogController;
			}

			module.resolve();
		});
});

EasySocial.module('site/layout/responsive', function($){

    var module = this;

    $(function(){

        $.responsive(".es-responsive", [
            {at: 2500, switchTo: 'extra-wide wide'}, // http://stackideas.com/forums/profile-layout-breaks-when-resizing-back-up
            {at: 1200, switchTo: 'wide'},
            {at: 960,  switchTo: 'wide w960'},
            {at: 818,  switchTo: 'wide w960 w768'},
            {at: 600,  switchTo: 'wide w960 w768 w600'},
            {at: 560,  switchTo: 'wide w960 w768 w600 w480'},
            {at: 480,  switchTo: 'wide w960 w768 w600 w480 w320'}
        ]);

        $(document).on("responsive", $.debounce(function(){
            ESImageRefresh();
        }, 500));
    });

    module.resolve();

});

EasySocial.module('site/layout/elements', function($){

	var module = this;

	// Initialize yes/no buttons.
	$(document).on( 'click.button.data-bs-api', '[data-bs-toggle-value]', function() {

		var button = $(this),
			siblings = button.siblings("[data-bs-toggle-value]"),
			parent = button.parents('[data-bs-toggle="radio-buttons"]');

		if(parent.hasClass('disabled')) {
			return;
		}

		// This means that this toggle value belongs to a radio button
		if (parent.length > 0) {

			// Get the current button that's clicked.
			var value = $(this).data('bs-toggle-value');

			button.addClass("active");
			siblings.removeClass("active");

			// Set the value here.
			// Have to manually trigger the change event on the input
			parent.find('input[type=hidden]').val(value).trigger('change');
			return;
		}
	});


	// Tooltips
	// TODO: Update to [data-es-provide=tooltip]
	$(document).on('mouseover.tooltip.data-es-api', '[data-es-provide=tooltip]', function() {

		$(this)
			.tooltip({
				delay: {
					show: 200,
					hide: 100
				},
				animation: false,
				template: '<div id="fd" class="es tooltip tooltip-es"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>',
				container: 'body'
			})
			.tooltip("show");
	});

	// Popovers
	// TODO: Update to [data-es-provide=popover]
	$(document).on('mouseover.popover.data-es-api', '[data-es-provide=popover]', function() {
		$(this)
			.popover({
				delay: {
					show: 200,
					hide: 100
				},
				animation: false,
				trigger: 'hover',
				container: 'body'
			})
			.popover("show");
	});


	var ly = function(yr) { return (yr%400)?((yr%100)?((yr%4)?false:true):false):true; };

	$(document).on("keyup", "[data-date-form] [data-date-day]", function(){

		if (!$.trim($(this).val())) return;

		var year   = parseInt($(this).siblings("[data-date-year]").val()  || $(this).siblings("[data-date-year]").data("dateDefault")),

		    month  = parseInt($(this).siblings("[data-date-month]").val() || $(this).siblings("[data-date-month]").data("dateDefault")),

		    day    = parseInt($(this).val() || $(this).data("dateDefault")),

			maxDay = /1|3|5|7|8|10|12/.test(month) ? 31 : 30;

			if (month==2) maxDay = ly(year) ? 29 : 28;

			if (day < 1) day = 1;

			if (day > maxDay) day = maxDay;

			if ($.isNumeric(day)) {
				$(this).val(day);
			} else {
				$(this).val("");
			}
	});

	$(document).on("keyup", "[data-date-form] [data-date-year]", function(){

		if (!$.trim($(this).val())) return;

		var year = parseInt($(this).val());
		if (year < 1) year = 1;

		if ($.isNumeric(year)) {
			$(this).val(year);
		} else {
			$(this).val("");
		}
	});

	module.resolve();

});

EasySocial.module("site/photos/photos", function($){

var module = this;

// Non-essential dependencies
EasySocial.require()
	.script(
		"site/photos/popup",
		"site/photos/dialog",
		"site/photos/avatar"
	)
	.done();

EasySocial.Controller("Photos",
{
	defaultOptions: {
	}
},
function(self) { return {

	init: function() {

		// Extend EasySocial object
		EasySocial.photos = self;

		// Popup plugin
		EasySocial.module("site/photos/popup")
			.done(function(PopupController){
				self.popup = self.addPlugin("popup", PopupController);
			});

		// Dialog plugin
		EasySocial.module("site/photos/dialog")
			.done(function(DialogController){
				self.dialog = self.addPlugin("dialog", DialogController);
			});

		// Avatar plugin
		EasySocial.module("site/photos/avatar")
			.done(function(AvatarController){
				self.avatar = self.addPlugin("avatar", AvatarController);
			});
	}

}});

// Add this controller to the html body;
$(function(){
	$("body").addController("EasySocial.Controller.Photos");
});

module.resolve();

});
EasySocial.module("site/photos/popup", function($){

var module = this;

// Album playlist
//
// <div data-es-photo-group="album:4">
//     <a data-es-photo="499">
// </div>

// Element-based playlist
//
// <div data-es-photo-group>
//     <a data-es-photo="1">
//     <a data-es-photo="2">
//     <a data-es-photo="3">
// </div>

// Custom playlist
// Ideal for large playlist where not all items are shown.
//
// <div data-es-photo-group="photos:400,401,402,403,405,406,407,408">
//     <a data-es-photo="400">
//     <a data-es-photo="401">
//     <a data-es-photo="402">
//     <a data-es-photo="403">
//     <a data-es-photo="404">
//     <!-- The rest of the thumbnails not shown, but the popup will have it. -->
// </div>

// TODO: Move this away
$.fn.at = function(key) {
	return this.find("[data-" + key.replace(/([a-z])([A-Z])/g, '$1-$2').toLowerCase() + "]");
}


EasySocial.require()
.view("site/photos/popup")
.done(function(){

	var controller =
	EasySocial.Controller("Photos.Popup",
	{
		defaultOptions: {

			view: {
				popup:  "site/photos/popup"
			},

			"{popup}"   : "[data-photo-popup]",
			"{viewport}": "[data-popup-viewport]",
			"{handle}"  : "[data-popup-handle]",

			"{photoGroup}": "[data-es-photo-group]",
			"{photo}"     : "[data-es-photo]",

			"{photoHeader}": "[data-photo-popup] [data-photo-header]",
			"{photoContent}": "[data-photo-popup] [data-photo-content]",

			"{navButton}" : ".es-photo-nav-button",
			"{closeButton}": "[data-popup-close-button]",

			"{photoItem}": "[data-photo-popup] [data-photo-item]",

			'{desTagItem}': '[data-photo-des-tag-item]'
		}
	},
	function(self, opts, base, body) { return {

		init: function() {

			body = $("body");

			self.bodyOverflow = {
				overflow: body.css("overflow"),
				overflowX: body.css("overflowX"),
				overflowY: body.css("overflowY")
			};
		},

		setLayout: function() {

			// Disable body scrollbar on narrow layout
			var popup = self.popup();

			if (popup.is(":visible")) {

				// Set image size again
				var image = self.viewport().find("img[data-photo-image]")[0];
				if (image) ESImage(image);

				body.css({
					overflow: "hidden",
					overflowX: "hidden",
					overflowY: "hidden"
				});

				var photoItem = self.photoItem();

				// Update tag position
				var tags = photoItem.controller("EasySocial.Controller.Photos.Tags");
				tags && tags.setLayout();

				// Disable navigation controller if there's only one photo or tagging is active
				var navigation = photoItem.controller("EasySocial.Controller.Photos.Navigation"),
					tagger = photoItem.controller("EasySocial.Controller.Photos.Tagger");

				navigation && navigation[
					(tagger && !tagger.disabled) || (self.playlist.length < 2) ? "disable" : "enable"]();

			} else {

				body.css(self.bodyOverflow);
			}
		},

		'{desTagItem} mouseover': function(el, ev) {
			var tags = self.photoItem().controller("EasySocial.Controller.Photos.Tags");

			tags && tags.getTagItem(el.data('photoDesTagId'))
				.addClass('focus');
		},

		'{desTagItem} mouseout': function(el, ev) {
			var tags = self.photoItem().controller("EasySocial.Controller.Photos.Tags");

			tags && tags.getTagItem(el.data('photoDesTagId'))
				.removeClass('focus');
		},

		"{window} resize": $.debounce(function() {

			self.setLayout();

		}, 250),

		"{self} responsive": function() {

			self.setLayout();
		},

		playlist: [],

		show: function() {

			var popup,
				node = self.popup.node;

			// Create node if not exists
			if (!node) {
				popup = self.view.popup();
				node  = self.popup.node = popup[0];
			}

			// Append node if detached
			if (!$.contains(base, node)) {
				popup = $(node).addClass("is-loading").appendTo(base);
			}

			if (!popup.is(":visible")) {

				// Show popup
				popup.show();

				// Trigger responsive event
				$(window).trigger("resize.responsive");

				// Trigger show event
				popup.trigger("show");
			}
		},

		hide: function() {

			self.popup()
				.hide()
				.trigger("hide")
				.detach();

			// Restore body layout
			body.css(self.bodyOverflow);
		},

		// open(photoId)
		// open(albumId, photoId)
		// open(type, id)
		// open([photoId, photoId, photoId], photoId)
		open: function() {

			// Normalize arguments
			var args = arguments, albumId, photoId, playlist = [];

			// open(photoId)
			if (args.length===1) {
				photoId = args[0];
				playlist = [photoId];
			}

			// open([photoId, photoId, photoId], photoId)
			// open([photoId, photoId, photoId])
			if ($.isArray(args[0])) {
				playlist = args[0];
				photoId = args[1] || playlist[0];

			// open(albumId, photoId)
			// open(type, id)
			} else if (args.length===2) {

				var type = args[0],
					autoplay = true,
					albumId;

				// open(albumId, photoId)
				if ($.isNumeric(type)) {
					type = "album";
					autoplay = false;
					albumId = args[0];
					photoId = args[1];
					playlist = [photoId];
				}

				// open("photo", 32)
				if (type=="photo") {
					photoId = args[1];
					playlist = [photoId];
				}

				// open("album", 64)
				if (type=="album") {

					// Get the playlist
					EasySocial.ajax("site/controllers/albums/playlist", {albumId: albumId || args[1]})
						.done(function(photos){

							// Update the playlist afterwards
							self.playlist = $.map(photos, function(photo){
								return photo.id;
							});

							// Play the first playlist
							if (autoplay) {
								self.display(playlist[0]);
							}

							// This ensure navigation is reenabled
							self.setLayout();
						})
						.fail(function(){
							// TODO: Make this nicer.
							alert("Error. Could not get album playlist.");
							self.hide();
						});
				}
			}

			self.playlist = playlist;

			// Show popup if hidden
			self.show();

			self.display(photoId);
		},

		handles: {},

		display: function(photoId) {

			if (!photoId) return;

			var previousId = self.currentPhotoId;

			self.currentPhotoId = photoId;

			var handle = self.handles[photoId];

			// Detach any existing views
			self.handle().detach();

			if (!handle) {

				var popup = self.popup();

				popup.addClass("is-loading");

				EasySocial.ajax(
					"site/views/photos/item",
					{
						id: photoId,
						browser: 0,
						popup: 1,
					})
					.done(function(html){

						var handle = $.buildHTML('<div class="es-popup-handle" data-popup-handle>' + html + "</div>");

						self.handles[photoId] = handle;

						self.display(photoId);
					})
					.fail(function(){
						alert("There was a problem loading this photo.");
						self.display(previousId);
					})
					.always(function(){
						popup.removeClass("is-loading");
					});

				return;
			} else {
				self.popup().removeClass("is-loading");
			}

			// Show current handle
			self.viewport().empty().append(handle);

			// Only store the node of the photo handle, discarding scripts.
			if (handle instanceof $) {
				self.handles[photoId] = handle.filter("[data-popup-handle]")[0];
			}

			// Set layout
			self.setLayout();
		},

		current: function() {

			var id = self.currentPhotoId,
				playlist = self.playlist,
				i = $.indexOf(playlist, id);

			// No matching item, revert to 0.
			if (i < 0) i = 0;

			return i;
		},

		next: function() {

			var playlist = self.playlist;

			if (playlist.length < 2) return;

			var i = self.current() + 1;

			// Cycle to the beginning
			if (i > playlist.length - 1) i = 0;

			self.display(playlist[i]);
		},

		prev: function() {

			var playlist = self.playlist;

			if (playlist.length < 2) return;

			var i = self.current() - 1;

			// Cycle to the end
			if (i < 0) i = playlist.length - 1;

			self.display(playlist[i]);
		},

		"{self} click": function(el, event) {

			if (event.target===self.popup()[0]) {
				self.hide();
			}
		},

		"{photo} click": function(photo, event) {
			// If this photo is disabled, stop.
			if (photo.attr("data-es-photo-disabled")=="1") return;

			var target = $(event.target),
				targetTree = target.parents().andSelf();

			// Quick fix
			if (target.filter("[data-es-photo]").length < 1 &&
				targetTree.filter("[data-photo-menu], [data-cover-menu]").length > 0) return;

			// Retrieve photo id and photo group
			var photoId = photo.attr("data-es-photo"),
				photoGroup = self.photoGroup.of(photo);

			// If this is not part of any photo group, don't show popup.
			if (photoGroup.length < 0) return;

			// Stop browser from loading full page photo
			event.preventDefault();

			// Retrieve playlist from photo group
			var data = (photoGroup.attr("data-es-photo-group") || "element").split(":"),
				type = data[0];

			switch (type) {

				// Album playlist
				case "album":
					var albumId = data[1];
					self.open(albumId, photoId);
					break;

				// Custom playlist
				case "photos":
					var list = data[1].split(",");
					self.open(list, photoId);
					break;

				// Element-based playlist
				case "element":
					var list = [];

					photoGroup.at("esPhoto").each(function(){
						list.push($(this).attr("data-es-photo"));
					});

					self.open(list, photoId);
					break;
			}
		},


		"{photoItem} directionmove": function(photoItem, event, offset, direction) {

			// Don't show navigation buttons when playlist still loading,
			// or when there's only a single photo in this playlist.
			if (self.playlist.length < 2) {
				self.navButton().removeClass("active");
			}
		},

		"{photoItem} directionstop": function() {

			// self.photoHeader().removeClass("active");
		},

		"{photoItem} photoNext": function() {

			self.next();
		},

		"{photoItem} photoPrev": function() {

			self.prev();
		},

		"{photoItem} photoDelete": function(el, event, photoItem) {

			if (self.playlist.length < 2) {
				self.hide();
			} else {
				self.next();

			}

			self.playlist = $.without(self.playlist, photoItem.id);
		},

		"{closeButton} click": function() {

			self.hide();
		}

	}});

	module.resolve(controller);
});

});

EasySocial.module("site/photos/dialog", function($){

var module = this;

var controller =
EasySocial.Controller("Photos.Dialog",
{
	defaultOptions: {
	}
},
function(self) { return {

	init: function() {

		// Legacy compatiblity
		// Old: EasySocial.photos.selectPhoto()
		// New: EasySocial.photos.dialog.show();
		EasySocial.photos.selectPhoto = self.show;
	},

	show: function(options) {

		var task	= $.Deferred(),
			dialog	= EasySocial.ajax( "site/views/albums/dialog" , { "uid" : options.uid , "type" : options.type }),
			browser = EasySocial.require().script( "albums/browser" ).done();

		// Show a loading indicator first
		EasySocial.dialog(
			$.extend({
			    content: task
			}, options)
		);

		$.when(browser, dialog)
			.done(function(){
				dialog.done(function(html){
					task.resolve(html);
				});
			});
	}

}});

module.resolve(controller);

});

EasySocial.module("site/photos/avatar", function($){

var module = this;

var controller =
EasySocial.Controller("Photos.Avatar",
{
	defaultOptions: {
	}
},
function(self) { return {

	init: function() {

		// Legacy compatiblity
		// Old: EasySocial.photos.createAvatar();
		// New: EasySocial.photos.avatar.crop();
		EasySocial.photos.createAvatar = self.crop;
	},

	crop: function(id, options) {

		if( id == undefined )
		{
			return;
		}

		if( !options )
		{
			options 	= {};
		}

		var avatarOptions = { "id" : id };

		if( options.uid )
		{
			avatarOptions.uid 	= options.uid;
			delete options.uid;
		}

		if( options.type )
		{
			avatarOptions.type 	= options.type;
			delete options.type;
		}

		if( options.redirect )
		{
			avatarOptions.redirect = options.redirect;
			delete options.redirect;
		}

		EasySocial.dialog(
			$.extend(
				{
					content: EasySocial.ajax( 'site/views/avatar/crop' , avatarOptions )
				},
				options
			)
		);
	}

}});

module.resolve(controller);

});

EasySocial.module('site/users/login', function($){

	var module = this;

	EasySocial.require()
		.library('dialog')
		.script('site/dashboard/dashboard.guest.login')
		.view('site/loading/small')
		.done(function(){

			EasySocial.login = function() {
				EasySocial.ajax('site/views/login/form')
					.done(function(content) {
						var dialog = EasySocial.dialog({
							content: content,
							afterShow: function() {
								this.element.find('[data-guest-login]').addController('EasySocial.Controller.Dashboard.Guest.Login');
							}
						});
					});
			}

			module.resolve();
		});
});

EasySocial.module('site/dashboard/dashboard.guest.login', function($) {
	var module = this;

	EasySocial.require().script('field', 'validate').done(function() {

		EasySocial.Controller('Dashboard.Guest.Login', {
			defaultOptions: {
				'{fieldItem}': '[data-registermini-fields-item]',

				'{submit}': '[data-registermini-submit]',

				'{form}': '[data-registermini-form]'
			}
		}, function(self) {
			return {
				init: function() {
					self.fieldItem().addController('EasySocial.Controller.Field.Base', {
						userid: 0,
						mode: 'registermini'
					});
				},

				'{submit} click': function(el) {

					if(el.enabled()) {
						el.disabled(true);

						self.form()
							.validate({mode: 'onRegisterMini'})
							.done(function() {
								el.enabled(true);
								self.form().submit();
							})
							.fail(function() {
								el.enabled(true);
							});
					}

				}
			}
		});

		module.resolve();
	});
});

EasySocial.module('validate', function ($) {
/*
<div data-check>
	<div>
		<label>Text</label>
		<input data-check-type="text" data-check-field />
	</div>
	<div data-check-notice></div>
</div>
<div data-check>
	<div>
		<label>Checkboxes</label>
		<div data-check-type="checkbox" data-check-field data-check-required>
			<input type="checkbox" name="group[]" value="1" />
			<input type="checkbox" name="group[]" value="1" />
		</div>
	</div>
</div>
<div data-check>
	<div>
		<label>Validate format</label>
		<input data-check-field data-check-validate="regex" />
	</div>
	<div data-check-notice></div>
</div>
*/

	var module = this;

	if(!$.isController('EasySocial.Controller.Validator')) {
		EasySocial.Controller('Validator', {
			defaultOptions: {
				mode			: null,

				checks			: ['required', 'validate'],

				typeAttr		: 'data-check-type',
				formatAttr		: 'data-check-format',
				modifierAttr	: 'data-check-modifier',

				errorTrigger	: 'onError',
				submitTrigger	: 'onSubmit',

				'{container}'	: '[data-check]',
				'{notice}'		: '[data-check-notice]',

				'{required}'	: '[data-check-required]',
				'{validate}'	: '[data-check-validate]',
			}
		}, function(self) {
			return {
				// temporary variables
				vars		: {},

				// register of elements returned by fields
				register	: [],

				// deferreds return by elements
				deferreds	: [],

				// errors return by elements
				errors		: [],

				// state of validator
				state		: $.Deferred(),

				init: function () {

				},

				reset: function() {
					self.vars		= {};

					self.register	= [];
					self.deferreds	= [];
					self.errors		= [];

					self.state		= $.Deferred();

					self.container().removeClass('error');
				},

				start: function() {
					self.reset();

					$.each(self.container(), function(i, container) {
						self.vars.container = container = $(container);

						container.trigger(self.options.submitTrigger, [self.register, self.options.mode]);

						$.each(self.getFields(), function(j, field) {
							self.vars.field = field = $(field);

							$.each(self.options.checks, function(i, check) {
								self.vars.check = check;

								self[check + 'Check']();
							});
						});
					});

					$.each(self.register, function(i, result) {
						if($.isDeferred(result)) {
							self.deferreds.push(result);
						} else if($.isPlainObject(result)) {
							$.each(result, function(key, value) {
								if(value === false) {
									self.errors.push(i);
									return true;
								}
							})
						} else {
							if(result === false) {
								self.errors.push(i);
								return true;
							}
						}
					});

					// If have static errors, then reject state
					if(self.errors.length > 0) {
						self.state.reject();
					} else {
						// If no static errors, then check if have deferreds
						if(self.deferreds.length > 0) {
							// This is because $.when accepts n amount of parameters instead of array, so we use .apply to pass in the array
							$.when.apply(null, self.deferreds)
								.done(function() {
									self.state.resolve();
								})
								.fail(function() {
									self.state.reject();
								});
						} else {
							// If no deferreds, then just resolve
							self.state.resolve();
						}
					}

					return self.state;
				},

				getFields: function() {
					return $.merge(self.vars.container.find(self.required.selector), self.vars.container.find(self.validate.selector));
				},

				requiredCheck: function() {
					if(self.vars.field.is(self.required.selector)) {
						var fieldType = self.vars.field.attr(self.options.typeAttr) || self.vars.field.attr('type') || 'text';

						if(fieldType === 'text' && $.trim(self.vars.field.val()) == '' ) {
							self.raiseError();
						}

						if(fieldType === 'checkbox' && self.vars.field.find('input[type="checkbox"]').filter(':checked').length < 1) {
							self.raiseError();
						}
					}
				},

				validateCheck: function() {
					if(self.vars.field.attr(self.options.formatAttr) !== undefined) {

						var value = self.vars.field.val();

						if($.isEmpty(value)) {
							return;
						}

						var format = self.vars.field.attr(self.options.formatAttr) || '';

						var modifier = self.vars.field.attr(self.options.modifierAttr) || '';

						var regex = new RegExp(format, modifier);

						if(!regex.test(value)) {
							self.raiseError();
						}
					}
				},

				raiseError: function () {
					self.vars.container.addClass('has-error');

					self.vars.container.trigger(self.options.errorTrigger, [self.vars.check, self.vars.field]);

					self.register.push(false);
				}
			};
		});
	}

	$.fn.validate = function(options){
		var element = this;

		if(element.length > 0) {
			var controller = this.addController("EasySocial.Controller.Validator", options);
			return controller.start();
		}

		return false;
	};

	module.resolve();
});

EasySocial.module("site/profile/popbox", function($) {

	var module = this;

	EasySocial.require()
		.library("popbox")
		.done(function(){

			// We should check if popbox should be initialized or not.
			var initPopbox = (EasySocial.options.lockdown && !EasySocial.options.guest) || !EasySocial.options.lockdown

			if (initPopbox) {
				EasySocial.module("profile/popbox", function($) {

					this.resolve(function(popbox){

						var id = popbox.button.data("userId");
						var position = popbox.button.attr('data-popbox-position') || 'top-left';

						return {
							content: EasySocial.ajax("site/views/profile/popbox", {id: id}),
							id: "fd",
							component: "es",
							type: "profile",
							position: position
						}
					})
				});
			}

		});

	// Non-essential dependency
	EasySocial.require()
		.script("site/conversations/composer")
		.done();

	EasySocial.Controller("Profile.Popbox", {
		defaultOptions: {
			// The current user being viewed
			id: null,

			"{addButton}"	    : "[data-popbox-friends-add]",
			"{friendsButton}"	: "[data-popbox-friends-friends]",
			"{respondButton}"	: "[data-popbox-friends-respond]",
			"{requestedButton}"	: "[data-popbox-friends-requested]",
			"{messageButton}"	: "[data-popbox-message]",
			"{friendsSubmenu}"	: "[data-friends-submenu]",

			"{cancelFriend}"	: "[data-popbox-friends-friends-cancel]",
			"{cancelFriendRequest}" : "[data-popbox-friends-requested-cancel]",
			"{approveFriend}"	: "[data-popbox-friends-respond-approve]",
			"{rejectFriend}"	: "[data-popbox-friends-respond-reject]"
		}
	},
	function(self) { return {

		init: function() {

			self.options.id = self.element.find("[data-user-id]").data("userId");

			EasySocial.module("site/conversations/composer")
				.done(function(){
					self.messageButton()
						.implement( EasySocial.Controller.Conversations.Composer.Dialog, { "recipient" : { "id" : self.options.id } } );
				});
		},

		"{self} popboxActivate": function() {

			self.friendsSubmenu().parent().removeClass("open");
		},

		"{addButton} click": function() {

			EasySocial.ajax("site/controllers/friends/request",
			{
				"id"	: self.options.id
			})
			.done(function()
			{
				// Add a loader
				// self.addButton().html( self.view.loader() );

				// Replace the button
				EasySocial.ajax( 'site/views/profile/getButton' , { "button" : "button.requested" , "id" : self.options.id } )
				.done(function( button )
				{
					// We know that the existing button is a request button
					self.addButton().replaceWith( button );
				});
				
			}).fail(function()
			{
				EasySocial.dialog(
				{
					content 	: EasySocial.ajax( 'site/views/friends/exceeded' )
				});
			});
		},

		"{cancelFriend} click": function(el, event) {

			var friendId = $( el ).data( 'friendid' );

			EasySocial.dialog(
			{
				content		: EasySocial.ajax( 'site/views/profile/confirmRemoveFriend' , { "id" : self.options.id } ),
				bindings	:
				{
					"{confirmButton} click" : function()
					{
						EasySocial.ajax( 'site/controllers/friends/unfriend' , { "id" : friendId } )
						.done(function()
						{
							// Display tot he user that they are no longer friends now.
							EasySocial.dialog(
							{
								content 	: EasySocial.ajax( 'site/views/profile/friendRemoved' , { "id" : self.options.id } )
							});

							// Replace the button
							EasySocial.ajax( 'site/views/profile/getButton' , { "button" : "button.add" } )
							.done(function( button )
							{
								self.friendsSubmenu().remove();

								self.friendsButton().replaceWith( button );
							});
						});
					}
				}
			});

		},

		"{cancelFriendRequest} click": function(el, event) {

			var friendId = $( el ).data( 'friendid' );

			EasySocial.dialog(
			{
				content: EasySocial.ajax( 'site/views/profile/confirmCancelRequest' ,
							{
								"id"	: friendId
							}),
				bindings:
				{
					"{confirmButton} click" : function()
					{
						// Close the dialog
						EasySocial.dialog().close();

						EasySocial.ajax( 'site/controllers/friends/cancelRequest' , { "id" : friendId } )
						.done(function()
						{
							// Replace the button
							EasySocial.ajax( 'site/views/profile/getButton' , { "button" : "button.add" } )
							.done(function( button )
							{
								// Hide the submenu
								self.friendsSubmenu().remove();

								// We know that the existing button is a request button
								self.requestedButton().replaceWith( button );
							});
						});
					}
				}
			});

		},

		"{approveFriend} click": function( el , event ) {

			var friendId = $( el ).data( 'friendid' );

			EasySocial.ajax( 'site/controllers/friends/approve' , { "id" : friendId } )
			.done(function()
			{
				EasySocial.dialog(
				{
					content: EasySocial.ajax( 'site/views/profile/confirmFriends' , { "id" : self.options.id } )
				});

				// Replace the button
				EasySocial.ajax( 'site/views/profile/getButton' , { "button" : "button.friends" } )
				.done(function( button )
				{
					// Hide the submenu
					self.friendsSubmenu().remove();

					// We know that the existing button is a request button
					self.respondButton().replaceWith( button );
				});
			});
		},

		"{rejectFriend} click" : function(el, event) {

			var friendId = $( el ).data( 'friendid' );

			EasySocial.ajax("site/controllers/friends/reject",
			{
				id: friendId
			})
			.done(function(){

				EasySocial.dialog({
					content: EasySocial.ajax("site/views/profile/rejected", { "id" : self.options.id } )
				});

				// Replace the button
				EasySocial.ajax("site/views/profile/getButton",
				{
					"button" : "button.add"
				})
				.done(function(button){

					// Hide the submenu
					self.friendsSubmenu().remove();

					// We know that the existing button is a request button
					self.respondButton().replaceWith( button );
				});
			});
		}

	}});

	// Popovers can implement themselves
	$(document).on("mouseover.es.profile.popbox", "[data-popbox-tooltip=profile]", function(){
		$(this).addController("EasySocial.Controller.Profile.Popbox");
	});

	module.resolve();

});

EasySocial.module( 'site/conversations/composer' , function($){

	var module 	= this;

	EasySocial.require()
	.library( 'mentions' )
	.script( 'site/friends/suggest' , 'uploader/uploader')
	.view(
		"site/friends/suggest.item",
		"site/friends/suggest.hint.search",
		"site/friends/suggest.hint.empty",
		"site/hashtags/suggest.item",
		"site/hashtags/suggest.hint.search",
		"site/hashtags/suggest.hint.empty"
	)
	.language(
		'COM_EASYSOCIAL_CONVERSATIONS_ERROR_EMPTY_RECIPIENTS',
		'COM_EASYSOCIAL_CONVERSATIONS_ERROR_EMPTY_MESSAGE'
	)
	.done(function($){

		EasySocial.Controller(
			'Conversations.Composer',
			{
				defaultOptions:
				{
					// Determines if these features should be enabled.
					attachments 		: true,
					location 			: true,

					// Uploader properties.
					extensionsAllowed	: "",

					// File uploads
					"{uploader}"		: "[data-composer-attachment]",

					// Location service.
					"{location}"		: "[data-composer-location]",

					// The text editor.
					"{editorHeader}"	: "[data-composer-editor-header]",
					"{editorArea}"		: "[data-composer-editor-area]",
					"{editor}"			: "[data-composer-editor]",

					// Wrapper for suggest to work.
					"{friendSuggest}"		: "[data-friends-suggest]",

					"{recipients}"		: "input[name=uid\\[\\]],input[name=list_id\\[\\]]",

					"{recipientRow}"	: "[data-composer-recipients]",
					"{messageRow}"		: "[data-composer-message]",

					// Submit button
					"{submit}"			: "[data-composer-submit]",

					view:
					{
						suggestItem: "site/friends/suggest.item",
						tagSuggestItem: "site/hashtags/suggest.item"
					}
				}
			},
			function( self ){
				return {

					init: function()
					{
						// Initialize the participants textbox.
						self.initSuggest();

						// Initialize editor.
						// self.initEditor();

						// Initialize uploader
						if( self.options.attachments )
						{
							self.initUploader();
						}

						// Initialize location
						// if( self.options.location )
						// {
						// 	self.initLocation();
						// }

						self.setMentionsLayout();
					},

					/**
					 * Initializes the location form.
					 */
					// initLocation: function()
					// {
					// 	self.location().implement( EasySocial.Controller.Location.Form );
					// },

					/**
					 * Resets the conversation form.
					 */
					resetForm: function()
					{
						self.editor().val('');
					},

					setMentionsLayout: function()
					{

						var editor		= self.editorArea(),
							mentions	= editor.controller("mentions");


						if (mentions)
						{
							mentions.cloneLayout();
							return;
						}

						var header = self.editorHeader();

						editor
							.mentions(
							{
								triggers:
								{
								    "@":
								    {
										type			: "entity",
										wrap			: false,
										stop			: "",
										allowSpace		: true,
										finalize		: true,
										query:
										{
											loadingHint	: true,
											searchHint	: $.View("easysocial/site/friends/suggest.hint.search"),
											emptyHint	: $.View("easysocial/site/friends/suggest.hint.empty"),

											data: function( keyword )
											{

												var task = $.Deferred();

												EasySocial.ajax( "site/controllers/friends/suggest" , { search: keyword })
												.done(function(items)
												{
													if (!$.isArray(items)) task.reject();

													var items = $.map(items, function(item)
													{
														item.title	= item.screenName;
														item.type	= "user";

														item.menuHtml = self.view.suggestItem(true, {
															item: item,
															name: "uid[]"
														});

														return item;
													});

													task.resolve(items);
												})
												.fail(task.reject);

												return task;
											},
											use: function(item) {
												return item.type + ":" + item.id;
											}
									    }
									},
									"#":
									{
									    type		: "hashtag",
									    wrap		: true,
									    stop		: " #",
									    allowSpace	: false,
										query:
										{
											loadingHint	: false,
											searchHint	: $.View("easysocial/site/hashtags/suggest.hint.search"),
											emptyHint	: $.View("easysocial/site/hashtags/suggest.hint.empty"),
											data: function(keyword)
											{

												var task = $.Deferred();

												EasySocial.ajax("site/controllers/hashtags/suggest", {search: keyword})
													.done(function(items)
													{
														if (!$.isArray(items)) task.reject();

														var items = $.map(items, function(item){
															item.title = "#" + item.title;
															item.type = "hashtag";
															item.menuHtml = self.view.tagSuggestItem(true, {
																item: item,
																name: "uid[]"
															});
															return item;
														});

														task.resolve(items);
													})
													.fail(task.reject);

												return task;
											}
									    }
									}
								},
								plugin:
								{
									autocomplete:
									{
										id			: "fd",
										component	: "es",
										position	:
										{
											my: 'left top',
											at: 'left bottom',
											of: header,
											collision: 'none'
										},
										size:
										{
											width: function()
											{
												return header.width();
											}
										}
									}
								}
							});
					},
					/**
					 * Initializes the uploader.
					 */
					initUploader: function()
					{
						// Implement uploader controller.
						self.uploader().implement( EasySocial.Controller.Uploader ,
						{
							// We want the uploader to upload automatically.
							temporaryUpload	: true,
							query 			: "type=conversations",
							type 				: 'conversations',
							extensionsAllowed : self.options.extensionsAllowed
						});

						if( EasySocial.environment == 'development' )
						{
							console.log( 'Extensions Allowed: ' + self.options.extensionsAllowed );
							console.log( 'Maximum individual file size: ' + self.options.maxSize );
						}
					},

					/**
					 * Initializes and converts the normal textbox into a suggest list.
					 */
					initSuggest: function()
					{
						self.friendSuggest()
							.addController(EasySocial.Controller.Friends.Suggest,
								{
									friendList		: true,
									friendListName	: "list_id[]"
								});
					},

					/**
					 * Initializes the editor
					 *
					 */
					initEditor : function()
					{
						self.editor().expandingTextarea();
					},

					/**
					 * Check for errors on the conversation form.
					 */
					checkErrors: function()
					{
						if( self.recipients().length <= 0 )
						{
							self.recipientRow().addClass( 'error' );
							self.clearMessage();
							self.setMessage( $.language( 'COM_EASYSOCIAL_CONVERSATIONS_ERROR_EMPTY_RECIPIENTS' ) , 'error' );

							return true;
						}
						else
						{
							self.recipientRow().removeClass( 'error' );
						}

						if( self.editor().val() == '' )
						{
							self.messageRow().addClass( 'error' );
							self.clearMessage();
							self.setMessage( $.language( 'COM_EASYSOCIAL_CONVERSATIONS_ERROR_EMPTY_MESSAGE' ) , 'error' );

							return true;
						}
						else
						{
							self.messageRow().removeClass( 'error' );
						}

						return false;
					},

					/**
					 * Submit button.
					 */
					"{submit} click" : function( el , event )
					{
						// Prevent form submission since this is a submit button.
						event.preventDefault();

						// Check for errors on this page.
						if( self.checkErrors() )
						{
							return false;
						}

						if( self.options.attachments )
						{
							var uploaderController 	= self.uploader().controller();

							// Do not allow user to submit this when the items are still being uploaded.
							if( uploaderController.options.uploading && uploaderController.hasFiles() )
							{
								return false;
							}
						}

						var mentions = self.editorArea().mentions("controller").toArray();

						// Reconstruct the inputs
						$( mentions ).each(function( i , item )
						{
							$( '<input>' )
								.attr( 'type' , 'hidden')
								.attr( 'name' , 'tags[]' )
								.attr( 'value' , JSON.stringify( item ) )
								.appendTo( self.element );
						});

						// Submit the form when we're ready.
						self.element.submit();
					}
				}
			}
		);

		EasySocial.Controller(
			'Conversations.Composer.Dialog',
			{
				defaultOptions:
				{
					// Default options
					recipient 		: {},
				}
			},
			function( self ){
				return {
					init: function()
					{

					},

					"{self} click" : function()
					{
						EasySocial.dialog(
						{
							"content"	: EasySocial.ajax( 'site/views/conversations/composer' , { "id" : self.options.recipient.id } ),
							"bindings"	:
							{
								"{sendButton} click" : function(el)
								{
									var dialog		= this.parent,
										recipient 	= $( '[data-composer-recipient]' ).val(),
										message 	= $( '[data-composer-message]' ).val();

									// disable the send button so that user cannot click again.
									el.disabled(true);

									EasySocial.ajax( 'site/controllers/conversations/store' ,
									{
										"uid"		: recipient,
										"message"	: message
									})
									.done(function( link )
									{
										EasySocial.dialog(
										{
											"content"	: EasySocial.ajax( 'site/views/conversations/sent' , { "id" : self.options.recipient.id }),
											"bindings"	:
											{
												"{viewButton} click" : function()
												{
													document.location 	= link;
												}
											}
										});
									})
									.fail( function( message )
									{
										dialog.setMessage(message);
										el.disabled(false);
									});
								}
							}
						});
					}
				}
		});

		module.resolve();
	});

});


EasySocial.module("site/privacy/privacy", function($){

	var module	= this;

	EasySocial.require()
	.library("textboxlist")
	.language(
		'COM_EASYSOCIAL_PRIVACY_TOOLTIPS_SHARED_WITH_PUBLIC',
		'COM_EASYSOCIAL_PRIVACY_TOOLTIPS_SHARED_WITH_MEMBER',
		'COM_EASYSOCIAL_PRIVACY_TOOLTIPS_SHARED_WITH_FRIENDS_OF_FRIEND',
		'COM_EASYSOCIAL_PRIVACY_TOOLTIPS_SHARED_WITH_FRIEND',
		'COM_EASYSOCIAL_PRIVACY_TOOLTIPS_SHARED_WITH_ONLY_ME',
		'COM_EASYSOCIAL_PRIVACY_TOOLTIPS_SHARED_WITH_CUSTOM'
	)
	.done(function($){


		EasySocial.Controller("Privacy",
		{
			defaultOptions: {

				"{menu}"  : "[data-privacy-menu]",
				"{item}"  : "[data-privacy-item]",
				"{icon}"  : "[data-privacy-icon]",
				"{button}": "[data-privacy-toggle]",
				"{tooltip}": "[data-original-title]",

				"{key}"   : "[data-privacy-hidden]"
			}
		},
		function(self){ return {

			init: function() {

				self.instanceId = $.uid();

				self.addPlugin("custom");
			},

			getData: function(item) {
				return $._.pick(item.data(), "uid", "utype", "value", "pid", "privacyicon", "streamid");
			},

			"{self} click" : function(el, event) {

				var target = $(event.target),
					button = self.button();

				// If the area being clicked is the toggle button,
				if (target.parents().andSelf().filter(button).length > 0) {

					// then we toggle privacy menu.
					self.toggle();
				}
			},

			"{item} click" : function(item) {

				// Retrieve data from this privacy item
				var data = self.getData(item);

				// Trigger privacy changed event
				self.trigger("privacyChange", [data]);

				if (!data.preventSave) {

					// Save new privacy settings
					self.save(data);

					// Deactivate menu
					self.deactivate();
				}
			},

			"{self} privacyChange": function(el, event, data) {

				// Deactivate other privacy item
				self.item()
					.removeClass("active")

					// and activate current privacy item.
					.filter("[data-value=" + data.value + "]")
					.addClass("active");
			},

			toggle: function() {
				var isActive = self.element.hasClass("active");
				self[(isActive) ? "deactivate" : "activate"]();
			},

			activate: function() {
				self.element.addClass("active");

				self.trigger("activate", [self]);
				$(window).trigger("activatePrivacy", [self]);

				var windowClick = "click.privacy." + self.instanceId;

				$(document).on(windowClick, function(event){

					var clickedTarget = $(event.target);

					// Don't do anything if we're clicking ourself
					if (clickedTarget.parents().andSelf().filter(self.element).length > 0
						|| clickedTarget.parents('[data-textboxlist-autocomplete]').length > 0
						|| clickedTarget.parents('[data-textboxlist-item]').length > 0 )
					{
						return;
					}

					$(document).off(windowClick);
					self.deactivate();
				});
			},

			deactivate: function() {
				self.element.removeClass("active");

				self.trigger("deactivate", [self]);
				$(window).trigger("deactivatePrivacy", [self]);
			},

			"{window} activatePrivacy": function(el, event, instance) {
				if (instance!==self) {
					self.deactivate();
				}
			},

			save: function( data ) {

				// Set privacy value
				self.key().val(data.value);

				// Set privacy icon
				self.icon().attr("class", data.privacyicon);

				// Trigger save event
				self.trigger("privacySave", [data]);

				// update tooltips
				self.element.attr('data-original-title', $.language( 'COM_EASYSOCIAL_PRIVACY_TOOLTIPS_SHARED_WITH_' + data.value.toUpperCase() ) );

				// If saving is done via ajax, save now.
				if (self.element.data("privacyMode")=="ajax") {

					EasySocial.ajax("site/controllers/privacy/update",
						{
							uid 	: data.uid,
							utype	: data.utype,
							value 	: data.value,
							pid 	: data.pid,
							custom 	: data.custom,
							streamid: data.streamid
						})
						.done(function(){

						})
						.fail(function(){
							// Unable to set privacy settings
						});
				}
			}
		}});


		EasySocial.Controller("Privacy.Custom",
			{
				defaultOptions: {
					"{textField}"   : "[data-textfield]",
					"{saveButton}" 	: "[data-save-button]",
					"{cancelButton}": "[data-cancel-button]",
					"{customItem}"  : "[data-privacy-item][data-value=custom]",
					"{customKey}"   : "[data-privacy-custom-hidden]"
				}
			},
			function(self) { return {

				init: function() {

					self.textField()
						.textboxlist({
							component: 'es',
							unique: true,
							plugin: {
								autocomplete: {
									exclusive: true,
									minLength: 1,
									cache: false,
									query: function(keyword) {

										var users = self.getIds();

										var ajax = EasySocial.ajax("site/views/privacy/getfriends",
											{
												q: keyword,
												exclude: users
											});
										return ajax;
									}
								}
							}
						});

					self.textboxlist = self.textField().controller("TextboxList");
				},

				getIds: function() {

					var items =
						self.textField()
							.textboxlist("controller")
							.getAddedItems();

					return $.map(items, function(item, idx) {
						return item.id;
					});
				},

				updateIds: function() {

					var ids = self.getIds();
					self.customKey().val(ids.join(","));
				},

				"{parent} privacyChange": function(el, event, data) {

					var isCustomPrivacy = (data.value=="custom");

					self.element.toggleClass("custom-privacy", isCustomPrivacy);

					// If user no longer selects custom privacy
					if (!isCustomPrivacy) {

						// Clear any existing custom privacy
						self.textField()
							.textboxlist("controller")
							.clearItems();
					} else {

						// Prevent privacy from saving
						data.preventSave = true;
					}
				},

				"{parent} privacySave": function(el, event, data) {
					// for now do nothing.
				},

				"{parent} deactivate": function() {
					self.textboxlist.autocomplete.hide();
				},

				"{cancelButton} click" : function(){
					self.element.removeClass("custom-privacy");
					self.textboxlist.autocomplete.hide();
				},

				"{saveButton} click" : function(){

					var parent = self.parent,
						customItem = self.customItem();

					var data = parent.getData(customItem);
					data.custom = self.customKey().val();

					self.parent.save(data );
					self.parent.deactivate();
				},

				// event listener for adding new name
				"{textField} addItem": function() {
					self.updateIds();
				},

				// event listener for removing name
				"{textField} removeItem": function() {
					self.updateIds();
				}
		}});

		$(document).on('click.es.privacy',  '[data-es-privacy-container]', function(){

			var privacyButton = $(this),
				privacyController = "EasySocial.Controller.Privacy";

			if (privacyButton.hasController(privacyController)) return;

			privacyButton.addController(privacyController).toggle();
		});

		module.resolve();
	});

});

EasySocial.module('site/locations/popbox', function($){

	EasySocial.module("locations/popbox", function($){

		this.resolve(function(popbox){

			var button = popbox.button,
				lat = button.data("lat"),
				lng = button.data("lng"),
				link = "//maps.google.com/?q=" + lat + "," + lng,
				language = $('meta[property="foundry:location:language"]').attr("content") || 'en',
				url = "//maps.googleapis.com/maps/api/staticmap?size=400x200&sensor=true&zoom=15&center=" + lat + "," + lng + "&markers=" + lat + "," + lng + "&language=" + language;

			return {
				id: "fd",
				component: "es",
				type: "location",
				content: '<a href="' + link + '" target="_blank"><img src="' + url + '" width="400" height="200" /></a>'
			}
		});

	});

	this.resolve();

});

EasySocial.module('site/sidebar/sidebar', function($) {

	var module = this;

	$(document).on("click.es.sidebar", "[data-sidebar-toggle]", function(){

		// Prefer sidebar from siblings
		var button = $(this),
			selector = "[data-sidebar]",
			sidebar = button.siblings(selector);

		// If not find closest sidebar
		if (sidebar.length < 1) {
			sidebar = button.closest(selector);
		}

		// If not find any sidebar
		if (sidebar.length < 1) {
			sidebar = $(selector);
		}

		sidebar
			.toggleClass("sidebar-open")
			.trigger("sidebarToggle");
	});

	module.resolve();
});

EasySocial.module('site/friends/api', function($){

	var module = this;

	EasySocial.require()
		.library('dialog', 'popbox' )
		.done(function(){

			$( document )
				.on( 'click.es.friends.cancel' , '[data-es-friends-cancel]', function()
				{
					var element 	= $(this),
						friendId 	= element.data( 'es-friends-id' );

						// Show confirmation dialog
						EasySocial.dialog({
							content: EasySocial.ajax( 'site/views/friends/confirmCancel' ),
							bindings:
							{
								"{confirmButton} click": function()
								{
									EasySocial.ajax( 'site/controllers/friends/cancelRequest' ,
									{
										"id"	: friendId
									})
									.done( function()
									{
										// Hide the dialog once the request has been cancelled.
										EasySocial.dialog().close();
									});
								}
							}
						});
				});

			// Data API
			$(document)
				.on('click.es.friends.add', '[data-es-friends-add]', function(){

					var element 	= $(this),
						userId 		= element.data( 'es-friends-id'),
						popboxContent 	= $.Deferred();

						element.popbox(
						{
							content	: popboxContent,
							id 		: "fd",
							component   : "es",
							type 	: "friends",
							toggle 	: "click"
						});

						element.popbox( 'show' );

						// Run an ajax call now to perform the add friend request.
						EasySocial.ajax( 'site/controllers/friends/request' ,
						{
							"viewCallback"	: "popboxRequest",
							"id"			: userId
						})
						.done(function( content )
						{
							popboxContent.resolve( content );
						});
				})

			module.resolve();
		});
});

EasySocial.module('site/popbox/popbox', function($) {
	var module = this;

	EasySocial.module("notifications/popbox", function($){

		this.resolve(function(popbox)
		{
			return {
				content: EasySocial.ajax( "site/controllers/notifications/getSystemItems",
				{
					layout	: "popbox.notifications"
				}),
				id: "fd",
				component: "es",
				type: "notifications",
				cache: false
			};
		});
	});

	EasySocial.module("conversations/popbox", function($){

		this.resolve(function(popbox)
		{
			return {
				content: EasySocial.ajax( "site/controllers/notifications/getConversationItems",
				{
					usemax 	: "1",
					layout	: "popbox.conversations"
				}),
				id: "fd",
				component: "es",
				type: "notifications",
				cache: false
			};
		});
	});

	EasySocial.module("friends/popbox", function($){

		this.resolve(function(popbox){

			return {
				content: EasySocial.ajax( "site/controllers/notifications/friendsRequests",
				{
					layout	: "popbox.friends"
				}),
				id: "fd",
				component: "es",
				type: "notifications",
				cache: false
			};
		});
	});

	module.resolve();
});

EasySocial.module('site/conversations/api', function($){

	var module = this;

	EasySocial.require()
		.library('dialog')
		.done(function(){

			// Data API
			$(document)
				.on('click.es.conversations.compose', '[data-es-conversations-compose]', function(){

					

					var element 	= $(this),
						userId 		= element.data( 'es-conversations-id'),
						listId 		= element.data( 'es-conversations-listid' );


					EasySocial.dialog(
					{
						"content"	: EasySocial.ajax( 'site/views/conversations/composer' , { "id" : userId , "listId" : listId } ),
						"bindings"	:
						{
							"{sendButton} click" : function()
							{
								var recipients 	= $( 'input[name=recipient\\[\\]]' ),
									message 	= $( '[data-composer-message]' ).val(),
									uids 		= new Array,
									dialog 		= this.parent;

								$( recipients ).each( function()
								{
									uids.push( $( this ).val() );
								});
								
								EasySocial.ajax( 'site/controllers/conversations/store' ,
								{
									"uid"		: uids,
									"message"	: message
								})
								.done(function( link )
								{
									if( userId )
									{
										EasySocial.dialog(
										{
											"content"	: EasySocial.ajax( 'site/views/conversations/sent' , { "id" : userId }),
											"bindings"	:
											{
												"{viewButton} click" : function()
												{
													document.location 	= link;
												}
											}
										});
									}

									if( listId )
									{
										EasySocial.dialog(
										{
											"content"	: EasySocial.ajax( 'site/views/conversations/sentList' , { "id" : listId }),
											"bindings"	:
											{
												"{viewButton} click" : function()
												{
													document.location 	= link;
												}
											}
										});
									}
								})
								.fail(function(message) {
									dialog.setMessage(message);
								});
							}
						}
					});
				});

			module.resolve();
		});
});
EasySocial.module('site/groups/api', function($){

	var module = this;

	EasySocial.require()
	.library('dialog')
	.done(function() {

		// Data API
		$(document)
			.on('click.es.groups.join', '[data-es-groups-join]', function() {

				var element = $(this);
				var groupId = element.data('id');

				EasySocial.dialog({
					"content": EasySocial.ajax('site/controllers/groups/joinGroup', {"api": 1, "id": groupId}),
					"bindings": {}
				});
			});

		module.resolve();
	});
});
EasySocial.module('site/followers/api', function($){

	var module = this;

	EasySocial.require()
		.library('dialog', 'popbox')
		.done(function(){


			// Data API
			$(document)
				.on('click.es.followers.follow', '[data-es-followers-follow]', function(){

					var element 		= $(this),
						userId 			= element.data('es-followers-id'),
						popboxContent 	= $.Deferred(),
						showPopbox 		= element.data('es-show-popbox') == undefined || element.data('es-show-popbox') == "true" ? true : false;


						if (showPopbox) {
							element.popbox(
							{
								content	: popboxContent,
								id 		: "fd",
								component   : "es",
								type 	: "followers",
								toggle 	: "click"
							});

							element.popbox( 'show' );
						}

						// Let's do an ajax call to follow the user.
						EasySocial.ajax( 'site/controllers/profile/follow' ,
						{
							"id"	: userId,
							"type"	: 'user'
						})
						.done(function( button )
						{
							$(element).trigger('following', button);

							if (showPopbox) {
								EasySocial.ajax( 'site/views/profile/popboxFollow' , { "id" : userId } )
								.done(function(content)
								{
									popboxContent.resolve( content );
								});
							}
						});
				})

			// Data API
			$(document)
				.on('click.es.followers.unfollow', '[data-es-followers-unfollow]', function(){

					var element 		= $(this),
						userId 			= element.data( 'es-followers-id'),
						popboxContent 	= $.Deferred();

						element.popbox(
						{
							content	: popboxContent,
							id 		: "fd",
							component   : "es",
							type 	: "followers",
							toggle 	: "click"
						});

						element.popbox( 'show' );

						// Let's do an ajax call to follow the user.
						EasySocial.ajax( 'site/controllers/profile/unfollow' ,
						{
							"id"	: userId,
							"type"	: 'user'
						})
						.done(function( button )
						{
							EasySocial.ajax( 'site/views/profile/popboxUnfollow' , { "id" : userId } )
							.done(function(content)
							{
								popboxContent.resolve( content );
							});

						});
				});

			module.resolve();
		});
});

EasySocial.module("site/stream/video", function($){

	$(document).on("click", "[data-es-links-embed-item]", function()
	{
		var button 	= $( this ),
			player 	= $( '<div>' ).html( button.data( 'es-stream-embed-player' ) );

		var embedCode 	= '<div class="video-container">' + player.html() + '</div>';

		button.replaceWith( embedCode );
	});

	this.resolve();
});

EasySocial.module( 'oauth/facebook', function($) {
	
	var module = this;

	$(document).on("click", "[data-oauth-facebook-login]", function(){

		var button = $(this),
			parent = button.parents("[data-oauth-facebook]"),
			controller = "EasySocial.Controller.OAuth.Facebook";

		if (parent.length < 1) return;
		if (parent.hasController(controller)) return;

		parent
			.addController(controller, {
				url: button.data("oauth-facebook-url"),
				appId: button.data("oauth-facebook-appid")
			})
			.openDialog();
	});


	EasySocial.Controller( 'OAuth.Facebook',
	{
		defaultOptions :
		{
			appId: null,
			url: "",
			"{login}"	: "[data-oauth-facebook-login]",
			"{revoke}"	: "[data-oauth-facebook-revoke]",

			"{pushInput}"	: "[data-oauth-facebook-push]"
		}
	},
	function( self )
	{
		return {
			init : function()
			{
			},

			openDialog : function()
			{
				var url = self.options.url,
					left	= (screen.width/2)-( 300 /2),
					top		= (screen.height/2)-( 300 /2);
					
				window.open( url , "" , 'scrollbars=no,resizable=no,width=300,height=300,left=' + left + ',top=' + top );
			},

			"{pushInput} change" : function( el )
			{
				var enabled 	= $(el).val();
				
				if( enabled == 1 && self.options.requestPush )
				{
					self.openDialog( self.options.addPublishURL )
				}

				if( enabled == 0 )
				{
					self.openDialog( self.options.revokePublishURL );
				}
			},

			"{login} click" : function()
			{
				self.openDialog();
			},

			"{revoke} click" : function()
			{
				var callback 	= self.element.data( 'callback' );
				
				EasySocial.dialog(
				{
					content 	: EasySocial.ajax( 'site/views/oauth/confirmRevoke' , { "client" : 'facebook' , "callbackUrl" : callback } )
				});
			}
		}
	});

	module.resolve();

}); // module end

EasySocial.module('groups/suggest', function($) {
	var module = this;


	EasySocial.require()
	.view('site/groups/suggest.item')
	.library('textboxlist')
	.done(function($) {

		EasySocial.Controller('Groups.Suggest', {
			defaultOptions: {
				max: null,
				exclusive: true,
				exclusion: [],
				minLength: 1,
				highlight: true,
				name: "uid[]",
				type: "",

				view: {
					suggestItem: "site/groups/suggest.item"
				}
			}
		}, function(self) { return {
			init: function() {

				var options = self.options;

				// Implement the textboxlist on the current element.
				self.element
					.textboxlist({
						component: 'es',
						name: options.name,
						max: options.max,
						plugin: {
							autocomplete: {
								exclusive: options.exclusive,
								minLength: options.minLength,
								highlight: options.highlight,
								showLoadingHint: true,
								showEmptyHint: true,

								query: function(keyword) {

									// Run an ajax call to retrieve suggested groups
									var result = EasySocial.ajax('site/controllers/groups/suggest', {
													"search": keyword,
													"exclusion": options.exclusion
												});

									return result;
								}
							}
						}
					})
					.textboxlist("enable");
			},

			"{self} filterItem": function(el, event, item) {

				var html =
					self.view.suggestItem(true, {
						item: item,
						name: self.options.name
					});

				item.menuHtml = html;
				item.html     = html;

				return item;
			},

			"{self} filterMenu": function(el, event, menu, menuItems, autocomplete, textboxlist) {
				// If this suggest searches for friend list, we don't want to format the item result here.
				if( self.options.friendList )
				{
					return;
				}

				// Get list of excluded users
				var items = textboxlist.getAddedItems(),
					users = $.pluck(items, "id"),
					users = users.concat(self.options.exclusion);

				menuItems.each(function(){

					var menuItem = $(this),
						item = menuItem.data("item");

					// If this user is excluded, hide the menu item
					menuItem.toggleClass("hidden", $.inArray(item.id.toString(), users) > -1);
				});
			}
		}});
		
		module.resolve();
	});

});
EasySocial.module("locations", function($){

	var module = this;

	EasySocial.require().library("gmaps").done();

	EasySocial
		.require()
		.library("scrollTo")
		.view("site/location/story.suggestion")
		.language("COM_EASYSOCIAL_AT_LOCATION")
		.done(function(){

			// Constants
			var KEYCODE = {
				BACKSPACE: 8,
				COMMA: 188,
				DELETE: 46,
				DOWN: 40,
				ENTER: 13,
				ESCAPE: 27,
				LEFT: 37,
				RIGHT: 39,
				SPACE: 32,
				TAB: 9,
				UP: 38
			};

			EasySocial.Controller("Locations",
				{
					defaultOptions: {

						view: {
							suggestion: "site/location/story.suggestion"
						},

						map: {
							lat: 0,
							lng: 0
						},

						"{textField}": "[data-location-textField]",
						"{detectLocationButton}": "[data-detect-location-button]",

						"{suggestions}": "[data-location-suggestions]",
						"{suggestion}": "[data-story-location-suggestion]",

						"{mapPreview}": "[data-location-map]",

						"{latitude}" : "[data-location-lat]",
						"{longitude}": "[data-location-lng]"
					}
				},
				function(self) { return {

					init: function() {

						// I have access to:
						// self.panelButton()
						// self.panelContent()

						// Only show auto-detect button if the browser supports geolocation
						if (navigator.geolocation) {
							self.detectLocationButton().show();
						}

						// Allow textfield input only when controller is implemented
						EasySocial.require().library("gmaps")
							.done(function(){
								self.textField().removeAttr("disabled");
							});

					},

					navigate: function(lat, lng) {

						var mapPreview = self.mapPreview(),
							map = self.map;

						// Initialize gmaps if not initialized
						if (map===undefined) {

							map = self.map =
								mapPreview
									.show()
									.gmaps(self.options.map);
						}

						map.setCenter(lat, lng);
						map.removeMarkers();
						map.addMarker({lat: lat, lng: lng});
					},

					// Memoized locations
					locations: {},

					lastQueryAddress: null,

					"{textField} keypress": function(textField, event) {

						switch (event.keyCode) {

							case KEYCODE.UP:

								var prevSuggestion = $(
									self.suggestion(".active").prev(self.suggestion.selector)[0] ||
									self.suggestion(":last")[0]
								);

								// Remove all active class
								self.suggestion().removeClass("active");

								prevSuggestion
									.addClass("active")
									.trigger("activate");

								self.suggestions()
									.scrollTo(prevSuggestion, {
										offset: prevSuggestion.height() * -1
									});

								event.preventDefault();

								break;

							case KEYCODE.DOWN:

								var nextSuggestion = $(
									self.suggestion(".active").next(self.suggestion.selector)[0] ||
									self.suggestion(":first")[0]
								);

								// Remove all active class
								self.suggestion().removeClass("active");

								nextSuggestion
									.addClass("active")
									.trigger("activate");

								self.suggestions()
									.scrollTo(nextSuggestion, {
										offset: nextSuggestion.height() * -1
									});

								event.preventDefault();

								break;

							case KEYCODE.ENTER:

								var activeSuggestion = self.suggestion(".active"),
									location = activeSuggestion.data("location");
									self.set(location);

								self.suggestions().hide();
								break;

							case KEYCODE.ESCAPE:
								break;
						}

					},

					"{textField} keyup": function(textField, event) {

						switch (event.keyCode) {

							case KEYCODE.UP:
							case KEYCODE.DOWN:
							case KEYCODE.ENTER:
							case KEYCODE.ESCAPE:
								// Don't repopulate if these keys were pressed.
								break;

							default:
								var address = $.trim(textField.val());

								if (address==="") {
									self.suggestions().hide();
								}

								if (address==self.lastQueryAddress) {
									return;
								}

								var locations = self.locations[address];

								// If this location has been searched before
								if (locations) {

									// Just use cached results
									self.suggest(locations);

									// And set our last queried address to this address
									// so that it won't repopulate the suggestion again.
									self.lastQueryAddress = address;

								// Else ask google to find it out for us
								} else {

									self.lookup(address);
								}
								break;
						}
					},

					lookup: $._.debounce(function(address){

						EasySocial.ajax('site/controllers/location/suggestLocations', {
							"address": address,
						}).done(function(locations) {

							// Store a copy of the results
							self.locations[address] = locations;

							self.suggest(locations);
							self.textField().focus();
						});

					}, 250),

					suggest: function(locations) {

						var suggestions = self.suggestions();
						
						// Clear location suggestions
						suggestions
							.hide()
							.empty();

						$.each(locations, function(i, location){

							// Create suggestion and append to list
							self.view.suggestion({
									location: location
								})
								.data("location", location)
								.appendTo(suggestions);
						});

						suggestions.show();
					},

					"{suggestion} activate": function(suggestion, event) {

						var location = suggestion.data("location");

						self.navigate(
							location.latitude,
							location.longitude
						);
					},

					"{suggestion} mouseover": function(suggestion) {

						// Remove all active class
						self.suggestion().removeClass("active");

						suggestion
							.addClass("active")
							.trigger("activate");
					},

					"{suggestion} click": function(suggestion, event) {

						var location = suggestion.data("location");

						self.set(location);

						self.suggestions().hide();
					},

					set: function(location) {

						self.currentLocation = location;

						var address = location.name;

						self.textField().val(address);

						// var caption = $.language("COM_EASYSOCIAL_AT_LOCATION", location.address_components[0].long_name);
						// self.story.addPanelCaption("locations", caption);

						self.latitude()
							.val(location.latitude);

						self.longitude()
							.val(location.longitude);

						self.trigger("locationChange", [location]);
					},

					"{detectLocationButton} click": function() {

						var map = self.map;

						$.GMaps.geolocate({
							success: function(position) {
								EasySocial.ajax('site/controllers/location/getLocations', {
									latitude: position.coords.latitude,
									longitude: position.coords.longitude
								}).done(function(locations) {
									self.suggest(locations);
									self.textField().focus();
								});
							},
							error: function(error) {
								// error.message
							},
							always: function() {

							}
						});
					},

					"{story} save": function(el, element, save) {

						var currentLocation = self.currentLocation;

						if (!currentLocation) return;

						save.addData(self, {
							short_address    : currentLocation.name,
							formatted_address: currentLocation.address,
							lat              : currentLocation.latitude,
							lng              : currentLocation.longitude
						});
					},

					"{story} clear": function() {

						self.unset();
					}

				}}
			);

			// Resolve module
			module.resolve();

		});

});

EasySocial.module( 'pagination' , function(){

var module	= this;


// Module begins here.
EasySocial.require()
.done(function($){

	EasySocial.Controller(
		'Pagination',
		{
			defaultOptions:
			{
				"{pages}"		: ".pageItem",
				"{limitstart}"	: "#limitstart",
				"{previousItem}": ".previousItem",
				"{nextItem}"	: ".nextItem"
			}
		},
		function(self)
		{
			return {
				init: function()
				{
					// Implement page item controller.
					self.pages().implement( EasySocial.Controller.Pagination.Page , {
						pagination : self
					});
				},

				"{previousItem} click" : function( elem )
				{
					var limitstart 	= $( elem ).data( 'limitstart' );

					if( $( elem ).hasClass( 'disabled' ) )
					{
						return;
					}
					
					self.submitForm( limitstart );
				},

				"{nextItem} click" : function( elem )
				{
					var limitstart 	= $( elem ).data( 'limitstart' );

					if( $( elem ).hasClass( 'disabled' ) )
					{
						return;
					}

					self.submitForm( limitstart );
				},

				submitForm: function( limitstart )
				{
					// Update the limitstart value in the page.
					self.limitstart().val( limitstart );

					// Send a submit for the form.
					$.Joomla( 'submitform' , [] );
				}
			} }

		);


	EasySocial.Controller(
		'Pagination.Page',
		{
			defaultOptions:
			{
				pagination	: null,
				limitstart	: 0
			}
		},
		function( self )
		{
			return {
				init: function()
				{
					self.options.limitstart 	= self.element.data( 'limitstart' );
				},

				"{self} click" : function()
				{
					// If the page is currently active, we can just ignore this.
					if( self.element.hasClass( 'active' ) )
					{
						return false;
					}

					// Submit the form.
					self.options.pagination.submitForm( self.options.limitstart );
				}
			}
		}
	);

	// Once require is done, we mark this module as resolved.
	module.resolve();

});


});

EasySocial.module("photos/avatar", function($){

	var module = this;

	EasySocial.require()
		.library(
			"imgareaselect"
		)
		.stylesheet(
			"imgareaselect/default"
		)
		.done(function(){

			EasySocial.Controller("Photos.Avatar",
			{
				defaultOptions:
				{
					view:
					{
						selection: "site/photos/avatar.selection"
					},

					uid 		: null,
					type 		: null,
					redirect	: true,
					redirectUrl	: "",
					"{image}"   : "[data-photo-image]",
					"{viewport}": "[data-photo-avatar-viewport]",
					"{photoId}" : "[data-photo-id]",
					"{userId}"  : "[data-user-id]",
					"{createButton}": "[data-create-button]",
					"{selection}"   : "[data-selection-box]",
					"{loadingIndicator}": "[data-photos-avatar-loading]"
				}
			},
			function(self) { return {

				init: function() {

					self.setLayout();
				},

				data: function()
				{

					var viewport = self.viewport(),

						width  = viewport.width(),

						height = viewport.height(),

						selection =
							viewport
								.imgAreaSelect({instance: true})
								.getSelection(),

						data = {
									id    	: self.photoId().val(),
									uid 	: self.options.uid,
									type 	: self.options.type,
									top   	: selection.y1 / height,
									left  	: selection.x1 / width,
									width 	: selection.width / width,
									height	: selection.height / height
								};

					return data;
				},

				imageLoaders: {},

				setLayout: function() {

					var imageHolder   = self.image(),
						// Using this instead of the other one above for urls that may have /*/ in it.
					    // imageUrl      = $.uri(imageHolder.css("backgroundImage")).extract(0),
					    imageUrl      = imageHolder.css("backgroundImage").replace(/^url\(['"]?/,'').replace(/['"]?\)$/,''),
					    imageLoaders  = self.imageLoaders,
					    imageLoader   = imageLoaders[imageUrl] || (self.imageLoaders[imageUrl] = $.Image.get(imageUrl));


					imageLoader
					    .done(function(imageEl, image){

							var size = $.Image.resizeWithin(
									image.width,
									image.height,
									imageHolder.width(),
									imageHolder.height()
								),
								min = Math.min(size.width, size.height),
								x1  = Math.floor((size.width  - min) / 2),
								y1  = Math.floor((size.height - min) / 2),
								x2  = x1 + min,
								y2  = y1 + min;

							self.createButton().enabled(true);

							self.viewport()
								.css(size)
								.imgAreaSelect({
									handles: true,
									aspectRatio: "1:1",
									parent: self.image(),
									x1: x1,
									y1: y1,
									x2: x2,
									y2: y2,
									onSelectEnd: function(viewport, selection) {
										var hasSelection = !(selection.width=="0" && selection.height=="0");
										self.createButton().enabled(hasSelection);
									}
								});
					    });
				},

				"{createButton} click": function( createButton )
				{
					var data = self.data(),

						task =
							EasySocial.ajax(
								"site/controllers/photos/createAvatar",
								data
								)
								.done(function( photo, user )
								{
									if (self.options.redirect)
									{
										window.location = self.options.redirectUrl;
									}
								})
								.fail(function(message, type)
								{
									self.setMessage(message, type);
								});

					self.trigger("avatarCreate", [task, data, self]);
				}

			}});

			module.resolve();

		});
});

EasySocial.module("photos/browser", function($){

	var module = this;

	EasySocial.require()
		.library(
			"history"
		)
		.done(function(){

			EasySocial.Controller("Photos.Browser",
			{
				defaultOptions: {

					// For masonry
					tilesPerRow: 4,

					"{sidebar}": "[data-photo-browser-sidebar]",
					"{content}": "[data-photo-browser-content]",

					"{backButton}"    : "[data-photo-back-button]",
					"{backButtonLink}": "[data-photo-back-button-link]",

					"{listItemGroup}" : "[data-photo-list-item-group]",
					"{listItem}"      : "[data-photo-list-item]",
					"{listItemLink}"  : "[data-photo-list-item] > a",
					"{listItemTitle}" : "[data-photo-list-item-title]",
					"{listItemCover}" : "[data-photo-list-item-cover]",
					"{listItemImage}" : "[data-photo-list-item-image]",

					"{featuredListItem}"      : "[data-photo-list-item].featured",
					"{featuredListItemImage}" : "[data-photo-list-item].featured [data-photo-list-item-image]",

					"{photoItem}": "[data-photo-item]"
				}
			},
			function(self) { return {

				init: function() {

					// Load masonry and set layout
					EasySocial.require()
						.library("masonry")
						.done(function(){
							self.setLayout();
						});
				},

				setLayout: function() {

					var listItemGroup = self.listItemGroup(),
						masonry = $.data(listItemGroup[0], "masonry");

					// Ensure group width is divisible by 4
					listItemGroup.width(Math.floor(listItemGroup.width() / 4) * 4);						

					if (masonry) {

						listItemGroup
							.masonry("reloadItems")
							.masonry("layout");

					// Else recalculate sizes
					} else {

						listItemGroup
							.masonry({
								columnWidth: ".es-thumb.grid-sizer",
								itemSelector: self.listItem.selector
							});
					}

					// Save current layout
					self.setLayout.seed = listItemGroup.width();
				},

				open: function(view) {

					var args = $.makeArray(arguments);

					self.trigger("contentLoad", args);

					var method = "view" + $.String.capitalize(view),
						loader = self[method].apply(self, args.slice(1));

					loader
						.done(self.displayContent(function(){
							self.trigger("contentDisplay", args);
							return arguments;
						}))
						.fail(function(){
							self.trigger("contentFail", args);
						})
						.always(function(){
							self.trigger("contentComplete", args);
						});

					return loader;
				},

				displayContent: $.Enqueue(function(html){

					var scripts = [],
						content = $($.buildFragment([html], document, scripts));

					// Insert content
					self.content().html(content);

					// Remove scripts
					$(scripts).remove();
				}),

				viewPhoto: function(photoId) {

					var state = "active loading",

						listItem =
							self.listItem()
								.removeClass(state)
								.filterBy("photoId", photoId)
								.addClass(state),

						loader =
							EasySocial.ajax(
								"site/views/photos/item",
								{
									id: photoId,
									browser: false
								})
								.fail(function(){
								})
								.always(function(){
									listItem.removeClass("loading");
								});

					return loader;
				},

				"{listItem} click": function(listItem) {

					var photoId = listItem.data("photoId");

					// Load album
					self.open("Photo", photoId);

					// Change address bar url
					listItem.find("> a").route();
				},

				"{listItemLink} click": function(listItemLink, event) {

					// Progressive enhancement, no longer refresh the page.
					event.preventDefault();

					// Prevent item from getting into :focus state
					listItemLink.blur();
				},

				"{backButtonLink} click": function(albumsButtonLink, event) {

					var browser = self.browser;

					// If albums browser exists, use it to load album
					if (browser) {

						var albumId = self.element.data("albumId");

						browser.open("album", albumId);

						event.preventDefault();

						albumsButtonLink.route();

						// To quickly change back to album
						browser.setLayout("album");

						self.element.remove();
					}
				},

				getListItem: function(photoId, context) {

					var listItem =
						(!photoId) ?
							self.listItem(".new") :
							self.listItem().filterBy("photoId", photoId);

					if (!context) return listItem;

					return listItem.find(self["listItem" + $.String.capitalize(context)].selector);
				},

				getNextListItem: function(photoId) {

					var listItem =
						self.getListItem(photoId)
							.next(self.listItem.selector);

					if (listItem.length < 1) {
						listItem = self.listItem(":first");
					}

					return listItem;
				},

				getPrevListItem: function(photoId) {

					var listItem =
						self.getListItem(photoId)
							.prev(self.listItem.selector);

					if (listItem.length < 1) {
						listItem = self.listItem(":last");
					}

					return listItem;
				},

				removeListItem: function(photoId, loadPreviousItem) {

					var listItem = self.getListItem(photoId),
						prevListItem = self.getPrevListItem(photoId);

					// Remove list item
					listItem.remove();

					// Reset list item masonry layout
					self.setLayout();

					// If there are no more items on the list
					if (self.listItem().length < 1) {

						self.element.addClass("loading");

						// Go back to albums
						return window.location = self.backButtonLink().attr("href");
					}

					// Else load previous item
					if (loadPreviousItem) {

						prevListItem.click();
					}
				},

				"{photoItem} init.photos.item": function(el, event, photoItem) {

					// Attach browser plugin to album
					self.addSubscriber(photoItem);
				},

				"{photoItem} photoSave": function(el, event, task) {

					// Update list item title when photo is updated.
					task.done(function(photo, html){

						self.getListItem(photo.id, "title")
							.html(photo.title);
					});
				},

				"{photoItem} photoNext": function(el, event, photo) {

					var listItem = self.getNextListItem(photo.id);
					listItem.click();
				},

				"{photoItem} photoPrev": function(el, event, photo) {

					var listItem = self.getPrevListItem(photo.id);
					listItem.click();
				},

				"{photoItem} photoMove": function(el, event, task, photo, targetAlbumId) {

					task
						.done(function(){
							self.removeListItem(photo.id, true);
						});
				},

				"{photoItem} photoDelete": function(el, event, task, photo) {

					task
						.done(function(){
							self.removeListItem(photo.id, true);
						});
				},

				"{photoItem} photoFeature": function(el, event, task, photo, featured) {

					var item = self.getListItem(photo.id);

					item.toggleClass("featured", featured);
					self.setLayout();

					task
						.fail(function(){
							item.toggleClass("featured", !featured);
							self.setLayout();
						});
				},

				"{sidebar} sidebarToggle": function() {

					self.setLayout();
				}

			}});

			module.resolve();

		});
});
EasySocial.module("photos/editor", function($){

	var module = this;

	EasySocial.require()
		.done(function(){

			var Controller =
			EasySocial.Controller("Photos.Editor",
			{
				defaultOptions: {

					view: {
						uploadItem: "upload.item",
						photoForm : "site/albums/photo.form"
					},

					"{titleField}"  : "[data-photo-title-field]",
					"{captionField}": "[data-photo-caption-field]",

					"{location}"          : "[data-photo-location]",
					"{locationCaption}"   : "[data-photo-location-caption]",
					"{addLocationButton}" : "[data-photo-addLocation-button]",
					"{date}"              : "[data-photo-date]",
					"{dateCaption}"       : "[data-photo-date-caption]",
					"{addDateCaption}"    : "[data-photo-adddate-button]",

					"{locationWidget}"  : ".es-photo-location-form .es-location",
					"{latitude}"        : "[data-location-lat]",
					"{longitude}"       : "[data-location-lng]",

					"{dateDay}"  : "[name=date-day]",
					"{dateMonth}": "[name=date-month]",
					"{dateYear}" : "[name=date-year]",

					"{actionsMenu}"  : "[data-item-actions-menu]",
					"{featureButton}": "[data-photo-feature-button]",
					"{coverButton}"  : "[data-photo-cover-button]",

					"{editButton}"    : "[data-photo-edit-button]",
					"{editButtonLink}": "[data-photo-edit-button] > a",

					"{cancelButton}"   : "[data-photo-cancel-button]",

					"{doneButton}"     : "[data-photo-done-button]",
					"{doneButtonLink}" : "[data-photo-done-button] > a",

					"{moveButton}"  : "[data-photo-move-button]",
					"{deleteButton}": "[data-photo-delete-button]",

					"{rotateLeftButton}": "[data-photo-rotateLeft-button]",
					"{rotateRightButton}": "[data-photo-rotateRight-button]",

					"{profileAvatarButton}": "[data-photo-profileAvatar-button]",
					"{profileCoverButton}": "[data-photo-profileCover-button]"
				}
			},
			function(self, opts, base) { return {

				init: function() {
				},

				data: function() {

					return {
						id        : self.photo.id,
						title     : self.titleField().val(),
						caption   : self.captionField().val(),
						date      : self.formatDate(),
						address   : self.locationCaption().html(),
						latitude  : self.latitude().val(),
						longitude : self.longitude().val()
					}
				},

				save: function() {

					var data = self.data();

					self.clearMessage();

					var task =
						EasySocial.ajax(
							"site/controllers/photos/update",
							data
						)
						.done(function(photo){

							self.photo.setLayout("item");
						})
						.fail(function(){

							self.setMessage(message, "error");
						})
						.progress(function(message, type){

							if (type=="success") {
								self.setMessage(message);
							}
						});

					self.trigger("photoSave", [task, self]);

					return task;
				},

				enable: function() {

					self.photo.setLayout("form");

					// If we are running under an album frame
					var album = self.photo.album;

					if (album) {
						base.addClass("active");
					}

					self.trigger("enabled", [self]);
				},

				disable: function() {

					self.photo.setLayout("item");

					// If we are running under an album frame
					var album = self.photo.album;

					if (album) {
						base.removeClass("active");
					}

					self.trigger("disabled", [self]);
				},

				imageLoader: {},

				setImage: function(type) {

					var image = self.photo.image(),
						imageCss = self.photo.imageCss(),
						imageSource = image.data(type + "Src"),
						imageLoader = self.imageLoader[imageSource];

					// If this image hasn't been loaded before
					if (!imageLoader) {

						// Create an image loader
						imageLoader = $.Image.get(imageSource);

						// Store a reference of the loader within the element
						self.imageLoader[imageSource] = imageLoader;
					}

					imageLoader
						.done(function(){
							image.attr("src", imageSource);
							imageCss.css({
								backgroundImage: $.cssUrl(imageSource)
							});
						});

					return imageLoader;
				},

				"{featureButton} click": function(featureButton, event) {

					event.stopPropagation();

					var isPopup =
						self.photo.element.parents("[data-photo-popup]").length > 0 ||
						self.photo.element.parents("[data-photo-browser-content]").length > 0;

					var isFeatured = base.hasClass("featured");

					base.toggleClass("featured", !isFeatured);

					!isPopup && self.setImage((isFeatured) ? "thumbnail" : "featured");

					// Perform an ajax call to mark the photo as featured
					var task =
						EasySocial.ajax(
							"site/controllers/photos/feature", {
								id: self.photo.id
							}
						)
						.done(function( message , isFeatured ) {

							// If this is not under album, show a message
							// if (!self.photo.album) {
							// 	self.clearMessage();
							// 	self.setMessage( message );
							// }

							featureButton.toggleClass('btn-es-primary', isFeatured);
						})
						.fail(function() {

							base.removeClass("featured");
							!isPopup && self.setImage((!isFeatured) ? "thumbnail" : "featured");
						});

					self.trigger("photoFeature", [task, self.photo, !isFeatured]);
				},

				"{coverButton} click": function() {

					var album = self.photo.album;

					// When viewing photos invidually,
					// there is no reference to album,
					// the button itself should't be visible anyway.
					if (!album) return;

					// If the editor is available, set cover.
					album.editor && album.editor.setCover(self.photo.id);
				},

				"{dateDay} keyup": function() {
					self.updateDate();
				},

				"{dateMonth} change": function() {
					self.updateDate();
				},

				"{dateYear} keyup": function() {
					self.updateDate();
				},

				updateDate: function() {

					setTimeout(function(){
						self.date().addClass("has-data");
						var dateCaption = self.dateDay().val() + ' ' + $.trim(self.dateMonth().find(":selected").text() + ' ' + self.dateYear().val());
						self.dateCaption().html(dateCaption);
					}, 1);
				},

				formatDate: function() {
					var day = self.dateDay().val() || self.dateDay().data('date-default'),
						month = self.dateMonth().val() || self.dateMonth().data('date-default'),
						year = self.dateYear().val() || self.dateYear().data('date-default');

					return year + '-' + month + '-' + day;
 				},

				"{locationWidget} locationChange": function(el, event, location) {

					var address = location.address || location.fulladdress || location.formatted_address;
					self.locationCaption().html(address);
					self.location().addClass("has-data");
				},

				rotate: function(angle) {

					var photo = self.photo;

					self.rotateLeftButton().disabled(true);
					self.rotateRightButton().disabled(true);

					// Show loading indicator
					photo.content().addClass("loading");

					var task =
						EasySocial.ajax(
							"site/controllers/photos/rotate",
							{
								id: photo.id,
								angle: angle
							}
						)
						.done(function(photoObj) {

							var url;

							if (self.photo.album) {
								url = photoObj.sizes.thumbnail.url;
							} else {
								url = photoObj.sizes.large.url;
							}

							// So that it actual loads a new one
							url += "?" + $.uid();

							// Replace image url
							photo.image()
								.attr("src", url);

							photo.imageCss()
								.css({
									backgroundImage: $.cssUrl(url)
								});

							base
								.addTransitionClass("rotating-ready", 150)
								.removeClass("rotating-right rotating-left");
						})
						.fail(function(message, type) {

							self.setMessage(message, type);
						})
						.always(function(){

							photo.content().removeClass("loading");
							self.rotateLeftButton().disabled(false);
							self.rotateRightButton().disabled(false);
						});

					self.trigger("photoRotate", [task, angle, photo])
				},

				"{rotateRightButton} click": function() {

					base.addClass("rotating-right");
					self.rotate(90);
				},

				"{rotateLeftButton} click": function() {

					base.addClass("rotating-left");
					self.rotate(-90);
				},

				"{moveButton} click": function() {

					var photo = self.photo;

					var dialog =
						EasySocial.dialog({
							content: EasySocial.ajax(
								"site/views/photos/moveToAnotherAlbum",
								{
									id: photo.id
								}
							),
							bindings: {
								"{moveButton} click": function() {

									var targetAlbumId = this.albumSelection().val();

									var task =
										EasySocial.ajax(
											"site/controllers/photos/move",
											{
												id: photo.id,
												albumId: targetAlbumId
											}
										)
										.always(function(){
											dialog.close();
										});

									self.trigger("photoMove", [task, photo, targetAlbumId]);
								}
							}
						});
				},

				"{deleteButton} click": function() {

					var photo = self.photo;

					EasySocial.dialog({
						content: EasySocial.ajax(
							"site/views/photos/confirmDelete",
							{
								id: photo.id
							}
						),
						bindings: {
							"{deleteButton} click": function(deleteButton) {

								var dialog = this.parent;

								deleteButton.disabled(true);

								var task =
									EasySocial.ajax(
										"site/controllers/photos/delete",
										{
											id: photo.id
										}
									)
									.always(function(){
										dialog.close();
									});

								self.trigger("photoDelete", [task, photo]);
							}
						}
					});
				},

				"{editButton} click": function() {

					// Change viewer layout
					self.photo.setLayout("form");

					// Change address bar url
					self.editButtonLink().route();
				},

				"{editButtonLink} click": function(editButtonLink, event) {

					event.preventDefault();
				},

				"{cancelButton} click": function()
				{
					// Change album layout
					self.photo.setLayout("item");

					// Change address bar url
					self.doneButtonLink().route();
				},

				"{doneButton} click": function() {

					self.save()
						.done(function(){

							// Change album layout
							self.photo.setLayout("item");

							// Change address bar url
							self.doneButtonLink().route();
						})
						.fail(function(){

						});
				},

				"{doneButtonLink} click": function(doneButtonLink, event) {
					event.preventDefault();
				},

				"{profileAvatarButton} click": function() {
					EasySocial.photos.createAvatar(self.photo.id);
				}
			}});

			module.resolve(Controller);

		});
});

EasySocial.module("photos/item", function($){

	var module = this;

	// Non-essential dependencies
	EasySocial.require()
		.script(
			"photos/tags",
			"photos/editor",
			"photos/tagger",
			"photos/navigation"
		)
		.done();

	// Essential dependencies
	EasySocial.require()
		.library(
			"image"
		)
		.done(function(){

			var Controller =
			EasySocial.Controller("Photos.Item",
			{
				hostname: "photo",

				defaultOptions: {

					editable: false,
					taggable: false,
					navigation: false,

					"{header}"            : "[data-photo-header]",
					"{content}"           : "[data-photo-content]",
					"{footer}"            : "[data-photo-footer]",
					"{viewport}"          : "[data-photo-viewport]",

					"{info}"              : "[data-photo-info]",
					"{title}"             : "[data-photo-title]",
					"{titleLink}"         : "[data-photo-title-link]",
					"{caption}"           : "[data-photo-caption]",

					"{image}"             : "[data-photo-image]",
					"{imageCss}"          : "[data-photo-image-css]",
					"{imageLink}"         : "[data-photo-image-link]",

					"{menu}"              : "[data-photo-menu]",
					"{actions}"           : "[data-item-actions]",
					"{actionsMenu}"       : "[data-item-actions-menu]",

					"{comments}"          : "[data-comments]",
					"{share}"			  : "[data-repost-action]",
					"{likes}"			  : "[data-likes-action]",
					"{likeContent}" 	  : "[data-likes-content]",
					"{repostContent}" 	  : "[data-repost-content]",
					"{counterBar}"	  	  : "[data-stream-counter]",

					"{privacy}"           : "[data-es-privacy-container]",

					"{likeCount}"    : "[data-photo-like-count]",
					"{commentCount}" : "[data-photo-comment-count]",
					"{tagCount}"     : "[data-photo-tag-count]"
				}
			},
			function(self) { return {

				init: function() {

					self.id = self.element.data("photoId");

					// Also implement tags when it is available
					EasySocial.module("photos/tags")
						.done(function(TagsController){
							self.tags = self.addPlugin("tags", TagsController);
						});

					// If this photos is editable, load & implement editor.
					if (self.options.editable) {
						EasySocial.module("photos/editor")
							.done(function(EditorController){
								self.editor = self.addPlugin("editor", EditorController);
							});
					}

					if (self.options.taggable) {
						EasySocial.module("photos/tagger")
							.done(function(TaggerController){
								self.tagger = self.addPlugin("tagger", TaggerController);
							});
					}

					if (self.options.navigation) {
						EasySocial.module("photos/navigation")
							.done(function(NavigationController){
								self.navigation = self.addPlugin("navigation", NavigationController);
							});
					}
				},

				data: function() {

					var image = self.image();

					return {
						id        : self.id,
						title     : $.trim(self.title().text()),
						caption   : $.trim(self.caption().text()),
						sizes: {
							thumbnail: image.data("thumbnailSrc"),
							featured : image.data("featuredSrc"),
							large    : image.data("largeSrc")
						}
					}
				},

				setLayout: function(layoutName) {

					// Switch layout
					self.element
						.data("photoLayout", layoutName)
						.switchClass("layout-" + layoutName);

					// Trigger layout change event
					self.trigger("layoutChange", [layoutName, self]);
				},

				"{self} click": function(el, event) {

					// If using photo popup, stop.
					if (!el.data("esPhotoDisabled")) return;

					var target = $(event.target),
						menu = self.menu();

					// If the area being click is the photo menu, stop.
					if (target.parents().andSelf().filter(menu).length > 0) return;

					// Activate item
					self.trigger("activate", [self]);
				},

				"{self} photoSave": function(el, event, task) {

					task
						.done(function(photo, html){
							self.info().replaceWith(html);
						});
				},

				"{self} photoDelete": function(el, event, task) {

					task
						.done(function(){
						})
						.fail(function(message, type){
							self.setMessage(message, type);
						});
				},

				"{imageLink} click": function(imageLink, event) {

					event.preventDefault();
				},

				"{titleLink} click": function(titleLink, event) {

					// event.preventDefault();
				},

                "{self} shown.bs.dropdown": function() {
                     self.element.addClass("show-all");
                },

                "{self} hidden.bs.dropdown": function() {
                     self.element.removeClass("show-all");
                },

                "{share} create": function(el, event, itemHTML) {
                	self.counterBar().removeClass('hide');
                },

 				"{likes} onLiked": function(el, event, data) {

					//need to make the data-stream-counter visible
					self.counterBar().removeClass( 'hide' );
					self.count("like", 1, true);
				},

				"{likes} onUnliked": function(el, event, data) {

					var isLikeHide 		= self.likeContent().hasClass('hide');
					var isRepostHide 	= self.repostContent().hasClass('hide');

					if( isLikeHide && isRepostHide )
					{
						self.counterBar().addClass( 'hide' );
					}

					self.count("like", -1, true);
				},

				"{self} tagAdd": function() {
					self.count("tag", 1, true);
				},

				"{self} tagRemove": function() {
					self.count("tag", -1, true);
				},

				"{comments} newCommentSaved": function() {
					self.count("comment", 1, true);
				},

				"{comments} commentDeleted": function() {
					self.count("comment", -1, true);
				},

				"{privacy} activate": function() {
					setTimeout(function(){
						self.element.addClass("show-all")
					}, 0);
				},

				"{privacy} deactivate": function() {
					self.element.removeClass("show-all");
				},

				count: function(subject, val, append) {

					var statSelector = self[subject + "Count"];

					if (!$.isFunction(statSelector)) return;

					// Get stat element
					var stat = statSelector();

					// If no stat element found, stop.
					if (stat.length < 0) return;

					// Get current stat count
					var statCount;

					if (append) {
						statCount = (parseInt(stat.text()) || 0) + (parseInt(val) || 0);
					} else {
						statCount = val;
					}

					// Always stays at 0 if less than that
					if (statCount < 0) statCount = 0;

					// Update stat count
					stat.text(statCount);
				}

			}});

			module.resolve(Controller);

		});
});

EasySocial.module("photos/tags", function($){

	var module = this;

	// Non essential dependencies
	EasySocial.require()
		.library("scrollTo")
		.done();

	EasySocial.require()
		.done(function(){

			var Controller =
			EasySocial.Controller("Photos.Tags",
			{
				hostname: "tags",

				defaultOptions: {

					"{viewport}"    : "[data-photo-tag-viewport]",
					"{tagItem}"     : "[data-photo-tag-item]",
					"{tagButton}"   : "[data-photo-tag-button]",
					"{tagLink}"     : "[data-photo-tag-link]",

					"{infoTagListItemGroup}": "[data-photoinfo-tag-list-item-group]",
					"{infoTagListItem}": "[data-photo-tags-user]",

					"{tagListItemGroup}": "[data-photo-tag-list-item-group]",
					"{tagListItem}"     : "[data-photo-tag-list-item]",

					"{descTagItem}": "[data-photo-tags-user]"
				}
			},
			function(self) { return {

				init: function() {
					self.setLayout();
				},

				imageLoaders: {},

				setLayout: function(callback) {

					var viewport     = self.photo.viewport(),
						image        = self.photo.image(),
						imageUrl     = image.attr("src"),
						imageLoaders = self.imageLoaders,
						imageLoader  = imageLoaders[imageUrl] || (self.imageLoaders[imageUrl] = $.Image.get(imageUrl));

					imageLoader
						.done(function(){

							var imageOffset = image.offset(),
								viewportOffset = viewport.offset();

							self.viewport()
								.css({
									top: imageOffset.top - viewportOffset.top,
									left: imageOffset.left - viewportOffset.left,
									width: image.width(),
									height: image.height()
								});

							callback && callback();
						});
				},

				"{window} resize": $.debounce(function(){

					self.setLayout();

				}, 1000),

				getTagItem: function(tagId) {
					return self.tagItem().filterBy("photoTagId", tagId);
				},

				getTagListItem: function(tagId) {
					return self.tagListItem().filterBy("photoTagId", tagId);
				},

				getInfoTagListItem: function(tagId) {
					return self.infoTagListItem().filterBy("photoTagId", tagId);
				},

				getTaggedUsers: function() {

					var users = [];

					self.tagListItem("[data-photo-tag-uid]")
						.each(function(){
							users.push($(this).data("photoTagUid"));
						});

					return $.uniq(users);
				},

				activateTag: function(tagId) {

					self.getTagItem(tagId)
						.addClass("active");

					self.getTagListItem(tagId)
						.addClass("active");
				},

				deactivateTag: function(tagId) {

					self.getTagItem(tagId)
						.removeClass("active");

					self.getTagListItem(tagId)
						.removeClass("active");
				},

				"{tagLink} click": function(el, event) {

					event.stopPropagation();
				},

				"{tagListItem} click": function(el) {

					var method = (el.hasClass('active') ? "deactivate" : "activate") + "Tag",
						tagId  = el.data("photoTagId");

					// Toggle tag
					self[method](tagId);
				},

				"{tagListItem} mouseover": function(el) {

					self.getTagItem(el.data("photoTagId"))
						.addClass("focus");
				},

				"{tagListItem} mouseout": function(el) {

					self.getTagItem(el.data("photoTagId"))
						.removeClass("focus");
				},

				"{descTagItem} mouseover": function(el) {
					self.getTagItem(el.data("photoTagId"))
						.addClass("focus");
				},

				"{descTagItem} mouseout": function(el) {
					self.getTagItem(el.data("photoTagId"))
						.removeClass("focus");
				},

				"{self} tagCreate": function(el, event, task) {

					task.done(function(){

					})
					.always(function(){
						setTimeout(function(){
							self.tagListItemGroup()
								.toggleClass("empty-tags", self.tagListItem().length < 1);
						}, 1);
					});
				},

				"{self} tagRemove": function(el, event, task, tagId) {

					task.done(function(){

						// Remove tag item
						self.getTagItem(tagId).remove();

						// Remove tag list item
						self.getTagListItem(tagId).remove();

						// Remove info's tag list item
						self.getInfoTagListItem(tagId).remove();

						// if length is zero, lets clear the html content.
						var taglen = self.infoTagListItemGroup().children().length;

						if (taglen == 0) {
							self.infoTagListItemGroup().html('');
						}

						if (taglen == 1) {
							var tag = self.infoTagListItemGroup().children().first();
							var tagcontent = tag.text();
							tagcontent = tagcontent.replace(',', '');

							tag.text(tagcontent);
						}

					})
					.always(function(){

						self.tagListItemGroup()
							.toggleClass("empty-tags", self.tagListItem().length < 1);
					});
				},

				"{self} photoRotate": function(el, event, task, angle, photo) {

					task.done(function(photoObj, tags){

						setTimeout(function(){

							self.setLayout(function(){

								var tagItems = self.tagItem();

								$.each(tags, function(i, tag){

									var tagItem = tagItems.filterBy("photoTagId", tag.id);

									tagItem
										.css({
											width : (tag.width  * 100) + "%",
											height: (tag.height * 100) + "%",
											top   : (tag.top    * 100) + "%",
											left  : (tag.left   * 100) + "%"
										});
								});

							});

						}, 1);

					});

				}
			}});

			module.resolve(Controller);

		});
});


EasySocial.module("photos/tagger", function($){

	var module = this;

	var KEYCODE = {
		BACKSPACE: 8,
		COMMA: 188,
		DELETE: 46,
		DOWN: 40,
		ENTER: 13,
		ESCAPE: 27,
		LEFT: 37,
		RIGHT: 39,
		SPACE: 32,
		TAB: 9,
		UP: 38
	};

	// Non essential dependencies
	EasySocial.require()
		.library("scrollTo")
		.done();

	EasySocial.require()
		.view(
			"site/photos/tags.item",
			"site/photos/tags.menu.item"
		)
		.done(function(){

			var Controller =
			EasySocial.Controller("Photos.Tagger",
			{
				hostname: "tagger",

				defaultOptions: {

					view: {
						tagItem: "site/photos/tags.item"
					},

					width: 100,
					height: 100,

					drawTolerance: 30,

					"{viewport}"    : "[data-photo-tag-viewport]",
					"{tagItem}"     : "[data-photo-tag-item]",
					"{tagSelection}": "[data-photo-tag-item].new",
					"{tagButton}"   : "[data-photo-tag-button]",

					"{infoTagListItemGroup}": "[data-photoinfo-tag-list-item-group]",
					"{tagListItemGroup}": "[data-photo-tag-list-item-group]",
					"{tagListItem}"     : "[data-photo-tag-list-item]",

					"{tagRemoveButton}" : "[data-photo-tag-remove-button]"
				}
			},
			function(self) { return {

				init: function() {
				},

				newTagItem: function() {

					// Use existing tag item if created
					var viewport = self.viewport(),
						newTagItem = self.tagItem(".new");

					// Else create one
					if (newTagItem.length < 1) {
						newTagItem =
							self.view.tagItem()
								.addClass("new")
								.appendTo(viewport);

						self.addSubscriber(
							newTagItem.addController("EasySocial.Controller.Photos.Tag")
						);
					}

					return newTagItem;
				},

				"{tagButton} click": function(tagButton) {

					self[tagButton.data("photoTagButton") || "toggle"]();
				},

				disabled: true,

				enable: function() {

					// This prevents image link from being clicked
					self.photo.imageLink()
						.on("click.tagger", function(event){
							event.preventDefault();
						});

					self.disabled = false;
					self.element.addClass("tagging");

					// If there is scrollTo
					if ($.scrollTo) {
						$.scrollTo(self.photo.content(), 250, {offset: {top: -100}});
					}

					self.trigger("tagEnter");
				},

				disable: function() {

					self.photo.imageLink()
						.off("click.tagger");

					// Remove tag selection
					self.tagSelection().remove();

					// Unfocus any tags which are in focus
					self.tagItem(".focus").removeClass("focus");

					self.disabled = true;
					self.element.removeClass("tagging");

					self.trigger("tagLeave");
				},

				toggle: function() {

					self[(self.disabled) ? "enable" : "disable"]();
				},

				area: {},

				calculateArea: function(collision, offset) {

					// Normalize arguments
					if (!collision) { collision = "clip" };
					if (!offset)    { offset = {x: 0, y: 0} };

					// Calculate image area
					var viewportEl   = self.viewport(),
						viewport        = viewportEl.offset();
						viewport.width  = viewportEl.width();
						viewport.height = viewportEl.height();
						viewport.right  = viewport.width  + viewport.left;
						viewport.bottom = viewport.height + viewport.top;

					// Calculate area relative to screen
					// top, left, width, height, right, bottom
					var area = self.area;
					area.top    = ((area.startY <= area.endY) ? area.startY : area.endY) + offset.y;
					area.left   = ((area.startX <= area.endX) ? area.startX : area.endX) + offset.x;
					area.width  = Math.abs(area.endX - area.startX);
					area.height = Math.abs(area.endY - area.startY);
					area.right  = area.width  + area.left;
					area.bottom = area.height + area.top;

					// Collision handling
					if (collision=="clip") {

						// Cap area within image boundaries
						if (area.top    <= viewport.top   ) {area.top    = viewport.top;   }
						if (area.bottom >= viewport.bottom) {area.bottom = viewport.bottom;}
						if (area.left   <= viewport.left  ) {area.left   = viewport.left;  }
						if (area.right  >= viewport.right ) {area.right  = viewport.right; }

						// Resize tag
						area.width  = area.right  - area.left;
						area.height = area.bottom - area.top;
					}

					// Reposition tag
					if (collision=="flip") {

						if (area.top <= viewport.top) {
							area.top = viewport.top;
						}

						if (area.left <= viewport.left) {
							area.left = viewport.left;
						}

						if (area.right >= viewport.right) {
							area.right = viewport.right;
							area.left  = area.right - area.width;
						}

						if (area.bottom >= viewport.bottom) {
							area.bottom = viewport.bottom;
							area.top    = area.bottom - area.height;
						}
					}

					// Pixel unit
					area.pixel = {
						top   : area.top  - viewport.top,
						left  : area.left - viewport.left,
						width : area.width,
						height: area.height
					};

					// Decimal unit
					area.decimal = {
						top   : area.pixel.top  / viewport.height,
						left  : area.pixel.left / viewport.width,
						width : area.width      / viewport.width,
						height: area.height     / viewport.height
					}

					// Percentage unit
					area.percentage = {
						top   : (area.decimal.top    * 100) + "%",
						left  : (area.decimal.left   * 100) + "%",
						width : (area.decimal.width  * 100) + "%",
						height: (area.decimal.height * 100) + "%"
					};

					// Decide whether tag should be on custom size
					var tolerance = self.options.drawTolerance;

					self.autodraw =
						(area.width  < tolerance &&
						 area.height < tolerance);

					return area;
				},

				setPivot: function(type, x, y) {

					var area = self.area;
						area[type + "X"] = x;
						area[type + "Y"] = y;
				},

				drawing: false,

				autodraw: false,

				drawTag: function() {

					var area = self.calculateArea();
						options = self.options;

					if (self.autodraw) {

						area.endX = area.startX + options.width;
						area.endY = area.startY + options.height;

						self.calculateArea("flip", {
							x: options.width / -2,
							y: options.height / -2
						});
					}

					self.newTagItem()
						.css(area.percentage)
						.trigger("focusInput");
				},

				"{viewport} mousedown": function(viewport, event) {

					if (self.disabled) return;

					if (event.target!==viewport[0]) return;

					event.preventDefault();

					// Hide last created tag item which are currently in focus
					self.tagItem(".focus").removeClass("focus");

					self.drawing = true;
					self.setPivot("start", event.pageX, event.pageY);

					$(document)
						.on("mousemove.tagger", function(event) {
							if (!self.drawing) return;
							self.setPivot("end", event.pageX, event.pageY);
							self.drawTag();
						})
						.on("mouseup.tagger", function(event) {
							self.setPivot("end", event.pageX, event.pageY);
							self.drawTag();
							$(document).off("mousemove.tagger mouseup.tagger");
						});
				},

				createTag: function(data) {

					var data = $.extend(
						{photo_id: self.photo.id}, data, self.area.decimal
					);

					var task = EasySocial.ajax("site/controllers/photos/createTag", data);

					self.trigger("tagCreate", [task, data, self]);

					return task;
				},

				removeTag: function(id) {

					var task = EasySocial.ajax("site/controllers/photos/removeTag", {id: id});

					self.trigger("tagRemove", [task, id, self]);

					return task;
				},

				addTag: function(data, tagItemHtml, tagListItemHtml, infoTagListItemHtml) {

					// Add tag to viewport and focus on tag
					var tagItem =
						$.buildHTML(tagItemHtml)
							.addClass("focus")
							.appendTo(self.viewport());

					// Add tag list item to tag list
					var tagListItem =
						$.buildHTML(tagListItemHtml)
							.appendTo(self.tagListItemGroup());

					//before we append the tag into info, we need to check if there is any tags or not. if not, we will apend a dash
					var taglen = self.infoTagListItemGroup().children().length;

					if (taglen == 0) {
						self.infoTagListItemGroup().append(' - ');
					}

					// Add tag list item to tag list at info section
					var infoTagListItem =
						$.buildHTML(infoTagListItemHtml)
							.appendTo(self.infoTagListItemGroup());

					self.trigger("tagAdd", [data, tagItem, tagListItem, self]);
				},

				"{self} avatarEnter": function() {

					// When entering avatar mode, hide all tags.
					self.tagItem().hide();

					// Disable tagging mode
					self.disable();
				},

				"{self} avatarLeave": function() {

					// When leaving avatar mode, display all tags.
					self.tagItem().show();
				},

				"{tagRemoveButton} click": function(button, event) {

					var tagId = button.data("photoTagId");

					self.removeTag(tagId);

					event.stopPropagation();
				},

				// Give priority to remove button,
				// make tag viewport appear above of
				// navigation buttons when they are hovered.
				"{tagRemoveButton} mouseover": function() {

					self.viewport().addClass("active");
				},

				"{tagRemoveButton} mouseout": function() {

					self.viewport().removeClass("active");
				}

			}});

			EasySocial.Controller("Photos.Tag",
			{
				defaultOptions: {

					view: {
						menuItem: "site/photos/tags.menu.item"
					},

					"{form}"        : "[data-photo-tag-form]",
					"{title}"       : "[data-photo-tag-title]",
					"{removeButton}": "[data-photo-tag-remove-button]",
					"{textField}"   : "[data-photo-tag-input]",
					"{menu}"        : "[data-photo-tag-menu]",
					"{menuItem}"    : "[data-photo-tag-menu-item]"
				}
			},
			function(self) { return {

				init: function() {

					self.data = self.options.data;
				},

				"{self} focusInput": function() {

					self.textField().focus();
				},

				"{textField} keyup": $._.debounce(function(el, event) {

					var keyword = $.trim(self.textField().val());

					switch (event.keyCode) {

						case KEYCODE.UP:
						case KEYCODE.DOWN:
						case KEYCODE.ENTER:
						case KEYCODE.ESCAPE:
							// Don't repopulate if these keys were pressed.
							break;

						default:
							// Build a list of users to exclude
							var users = self.tagger.photo.tags.getTaggedUsers();

							EasySocial.ajax(
							   "site/controllers/friends/suggestPhotoTagging",
							   {
							   	   search: keyword,
							   	   exclude: users,
							   	   includeme: '1'
							   })
								.done(self.render());
							break;
					}

				}, 250),

				"{textField} keypress": function(textField, event) {

					var keyword = $.trim(self.textField().val());

					// Get active menu item
					var activeMenuItem = self.menuItem(".active");

					switch (event.keyCode) {

						// If up key is pressed
						case KEYCODE.UP:

							// Deactivate all menu item
							self.menuItem().removeClass("active");

							// If no menu items are activated,
							if (activeMenuItem.length < 1) {

								// activate the last one.
								self.menuItem(":last").addClass("active");

							// Else find the menu item before it,
							} else {

								// and activate it.
								activeMenuItem.prev(self.menuItem.selector)
									.addClass("active");
							}

							event.preventDefault();
							break;

						// If down key is pressed
						case KEYCODE.DOWN:

							// Deactivate all menu item
							self.menuItem().removeClass("active");

							// If no menu items are activated,
							if (activeMenuItem.length < 1) {

								// activate the first one.
								self.menuItem(":first").addClass("active");

							// Else find the menu item after it,
							} else {

								// and activate it.
								activeMenuItem.next(self.menuItem.selector)
									.addClass("active");
							}

							event.preventDefault();
							break;

						// If enter is pressed
						case KEYCODE.ENTER:

							// Use menu item
							if (activeMenuItem.length > 0) {

 								activeMenuItem.trigger("click");

 							// Create custom label
 							} else {
								self.create({
									type: "label",
									label: keyword
								});
 							};

							self.menu().hide();
							break;

						// If escape is pressed,
						case KEYCODE.ESCAPE:

							// hide menu.
							self.menu().hide();
							break;
					}
				},

				"{menuItem} mouseover": function(menuItem) {

					self.menuItem().removeClass("active");

					menuItem.addClass("active");
				},

				"{menuItem} mouseout": function(menuItem) {

					self.menuItem().removeClass("active");
				},

				render: $.Enqueue(function(items) {

					var menu = self.menu();

					if (!items || items.length < 1) {
						menu.hide();
						return;
					}

					menu.empty();

					$.each(items, function(i, item) {

						self.view.menuItem({item: item})
							.data("item", item)
							.appendTo(menu);

						menu.show();
					});
				}),

				create: function(data) {

					var tag = self.element;

					// Store tag data
					self.data = data;

					// Update tag title
					self.title()
						.html(data.label);

					// Do not submit empty label
					if ($.trim(data.label)==="") return;

					// Create tag
					self.tagger.createTag(data)
						.done(function(tag, tagItemHtml, tagListItemHtml, infoTagListItemHtml){

							// Add new tag
							self.tagger.addTag(tag, tagItemHtml, tagListItemHtml, infoTagListItemHtml);

							// Destroy myself
							self.element.remove();
						})
						.fail(function(message){
							alert(message.message);
							tag.remove();
						});
				},

				remove: function() {

					var tag = self.element,
						tagId = (self.data || {}).id;

					// If this is a new tag, just remove element;
					if (!tagId) return tag.remove();

					// Remove tag
					self.tagger.removeTag(tagId)
						.done(function(){
							tag.remove();
						});
				},

				"{menuItem} click": function(menuItem) {

					var item = menuItem.data("item");

					self.create({
						uid  : item.id,
						type : "person",
						label: item.screenName,
					});
				},

				"{removeButton} click": function() {

					self.remove();
				}

			}});

			module.resolve(Controller);

		});
});

EasySocial.module("photos/navigation", function($){


	$.fn.intersectsWith = function(top, left, width, height) {

		var offset = this.offset(),

			reference = {
				top   : offset.top,
				left  : offset.left,
				bottom: offset.top  + (sourceHeight = this.height()),
				right : offset.left + (sourceWidth  = this.width()),
				width : sourceWidth,
				height: sourceHeight
			},

			subject = {
				top   : top,
				left  : left,
				bottom: top  + (height || (height = 0)),
				right : left + (width  || (width  = 0)),
				width : width,
				height: height
			},

			intersects = (
				reference.left <= subject.right    &&
				subject.left   <= reference.right  &&
	          	reference.top  <= subject.bottom   &&
	          	subject.top    <= reference.bottom
			);

		return (intersects) ? {reference: reference, subject: subject} : false;
	};

	var module = this;

	var Controller =

		EasySocial.Controller("Photos.Navigation",
		{
			hostname: "navigation",

			defaultOptions: {
				"{navButton}" : ".es-photo-nav-button",
				"{nextButton}": "[data-photo-next-button]",
				"{prevButton}": "[data-photo-prev-button]"
			}
		},
		function(self, opts, base) { return {

			init: function() {

				self.setDirection(window.esPhotosNavigationLastDirection);
			},

			disabled: false,

			disable: function() {
				self.disabled = true;
				self.navButton().addClass("disabled");
			},

			enable: function() {
				self.disabled = false;
				self.navButton().removeClass("disabled");
			},

			setDirection: function(direction) {

				self.navButton().removeClass("active");

				window.esPhotosNavigationLastDirection = self.currentDirection = direction;

				if (direction) {
					// Show button
					self[direction + "Button"]().addClass("active");
				}
			},

			"{window} mousemove": function(el, event) {

				// If navigation is disabled, don't do anything.
				if (self.disabled) return;

				self.setDirection(null);
				self.photo.trigger("directionstop");

				// If user is not moving within the photo content, stop.
				if ($(event.target).parents().filter(self.photo.content.selector).length < 1) return;

				var offset =
						self.photo.content()
							.intersectsWith(event.pageY, event.pageX);

				if (offset) {

					var direction =
						(offset.subject.left < (offset.reference.right - (offset.reference.width / 2))) ?
							"prev" : "next";

					self.setDirection(direction);

					self.photo.trigger("directionmove", [offset, direction]);
				}
			},

			"{self} tagEnter": function() {
				self.disable();
			},

			"{self} tagLeave": function() {
				self.enable();
			},

			"{self} click": function(el, event) {

				if (self.disabled) return;

				// If user is not clicking within the photo content, stop.
				if ($(event.target).parents().filter(self.photo.content.selector).length < 1) return;

				var direction = self.currentDirection;

				if (!direction) return;

				self.trigger("photo" + $.String.capitalize(direction), [self.photo]);
			},

			"{self} photoNext": function() {
				// Photo browser handles this
			},

			"{self} photoPrev": function() {
				// Photo browser handles this
			}

		}});

	module.resolve(Controller);

});

EasySocial.module( "prism", function($){

var module = this;

/**
 * Prism: Lightweight, robust, elegant syntax highlighting
 * MIT license http://www.opensource.org/licenses/mit-license.php/
 * @author Lea Verou http://lea.verou.me
 */(function(){var e=/\blang(?:uage)?-(?!\*)(\w+)\b/i,t=self.Prism={util:{type:function(e){return Object.prototype.toString.call(e).match(/\[object (\w+)\]/)[1]},clone:function(e){var n=t.util.type(e);switch(n){case"Object":var r={};for(var i in e)e.hasOwnProperty(i)&&(r[i]=t.util.clone(e[i]));return r;case"Array":return e.slice()}return e}},languages:{extend:function(e,n){var r=t.util.clone(t.languages[e]);for(var i in n)r[i]=n[i];return r},insertBefore:function(e,n,r,i){i=i||t.languages;var s=i[e],o={};for(var u in s)if(s.hasOwnProperty(u)){if(u==n)for(var a in r)r.hasOwnProperty(a)&&(o[a]=r[a]);o[u]=s[u]}return i[e]=o},DFS:function(e,n){for(var r in e){n.call(e,r,e[r]);t.util.type(e)==="Object"&&t.languages.DFS(e[r],n)}}},highlightAll:function(e,n){var r=document.querySelectorAll('code[class*="language-"], [class*="language-"] code, code[class*="lang-"], [class*="lang-"] code');for(var i=0,s;s=r[i++];)t.highlightElement(s,e===!0,n)},highlightElement:function(r,i,s){var o,u,a=r;while(a&&!e.test(a.className))a=a.parentNode;if(a){o=(a.className.match(e)||[,""])[1];u=t.languages[o]}if(!u)return;r.className=r.className.replace(e,"").replace(/\s+/g," ")+" language-"+o;a=r.parentNode;/pre/i.test(a.nodeName)&&(a.className=a.className.replace(e,"").replace(/\s+/g," ")+" language-"+o);var f=r.textContent;if(!f)return;f=f.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/\u00a0/g," ");var l={element:r,language:o,grammar:u,code:f};t.hooks.run("before-highlight",l);if(i&&self.Worker){var c=new Worker(t.filename);c.onmessage=function(e){l.highlightedCode=n.stringify(JSON.parse(e.data),o);t.hooks.run("before-insert",l);l.element.innerHTML=l.highlightedCode;s&&s.call(l.element);t.hooks.run("after-highlight",l)};c.postMessage(JSON.stringify({language:l.language,code:l.code}))}else{l.highlightedCode=t.highlight(l.code,l.grammar,l.language);t.hooks.run("before-insert",l);l.element.innerHTML=l.highlightedCode;s&&s.call(r);t.hooks.run("after-highlight",l)}},highlight:function(e,r,i){return n.stringify(t.tokenize(e,r),i)},tokenize:function(e,n,r){var i=t.Token,s=[e],o=n.rest;if(o){for(var u in o)n[u]=o[u];delete n.rest}e:for(var u in n){if(!n.hasOwnProperty(u)||!n[u])continue;var a=n[u],f=a.inside,l=!!a.lookbehind,c=0;a=a.pattern||a;for(var h=0;h<s.length;h++){var p=s[h];if(s.length>e.length)break e;if(p instanceof i)continue;a.lastIndex=0;var d=a.exec(p);if(d){l&&(c=d[1].length);var v=d.index-1+c,d=d[0].slice(c),m=d.length,g=v+m,y=p.slice(0,v+1),b=p.slice(g+1),w=[h,1];y&&w.push(y);var E=new i(u,f?t.tokenize(d,f):d);w.push(E);b&&w.push(b);Array.prototype.splice.apply(s,w)}}}return s},hooks:{all:{},add:function(e,n){var r=t.hooks.all;r[e]=r[e]||[];r[e].push(n)},run:function(e,n){var r=t.hooks.all[e];if(!r||!r.length)return;for(var i=0,s;s=r[i++];)s(n)}}},n=t.Token=function(e,t){this.type=e;this.content=t};n.stringify=function(e,r,i){if(typeof e=="string")return e;if(Object.prototype.toString.call(e)=="[object Array]")return e.map(function(t){return n.stringify(t,r,e)}).join("");var s={type:e.type,content:n.stringify(e.content,r,i),tag:"span",classes:["token",e.type],attributes:{},language:r,parent:i};s.type=="comment"&&(s.attributes.spellcheck="true");t.hooks.run("wrap",s);var o="";for(var u in s.attributes)o+=u+'="'+(s.attributes[u]||"")+'"';return"<"+s.tag+' class="'+s.classes.join(" ")+'" '+o+">"+s.content+"</"+s.tag+">"};if(!self.document){self.addEventListener("message",function(e){var n=JSON.parse(e.data),r=n.language,i=n.code;self.postMessage(JSON.stringify(t.tokenize(i,t.languages[r])));self.close()},!1);return}var r=document.getElementsByTagName("script");r=r[r.length-1];if(r){t.filename=r.src;document.addEventListener&&!r.hasAttribute("data-manual")&&document.addEventListener("DOMContentLoaded",t.highlightAll)}})();;
Prism.languages.markup={comment:/&lt;!--[\w\W]*?-->/g,prolog:/&lt;\?.+?\?>/,doctype:/&lt;!DOCTYPE.+?>/,cdata:/&lt;!\[CDATA\[[\w\W]*?]]>/i,tag:{pattern:/&lt;\/?[\w:-]+\s*(?:\s+[\w:-]+(?:=(?:("|')(\\?[\w\W])*?\1|\w+))?\s*)*\/?>/gi,inside:{tag:{pattern:/^&lt;\/?[\w:-]+/i,inside:{punctuation:/^&lt;\/?/,namespace:/^[\w-]+?:/}},"attr-value":{pattern:/=(?:('|")[\w\W]*?(\1)|[^\s>]+)/gi,inside:{punctuation:/=|>|"/g}},punctuation:/\/?>/g,"attr-name":{pattern:/[\w:-]+/g,inside:{namespace:/^[\w-]+?:/}}}},entity:/&amp;#?[\da-z]{1,8};/gi};Prism.hooks.add("wrap",function(e){e.type==="entity"&&(e.attributes.title=e.content.replace(/&amp;/,"&"))});;
Prism.languages.css={comment:/\/\*[\w\W]*?\*\//g,atrule:{pattern:/@[\w-]+?.*?(;|(?=\s*{))/gi,inside:{punctuation:/[;:]/g}},url:/url\((["']?).*?\1\)/gi,selector:/[^\{\}\s][^\{\};]*(?=\s*\{)/g,property:/(\b|\B)[\w-]+(?=\s*:)/ig,string:/("|')(\\?.)*?\1/g,important:/\B!important\b/gi,ignore:/&(lt|gt|amp);/gi,punctuation:/[\{\};:]/g};Prism.languages.markup&&Prism.languages.insertBefore("markup","tag",{style:{pattern:/(&lt;|<)style[\w\W]*?(>|&gt;)[\w\W]*?(&lt;|<)\/style(>|&gt;)/ig,inside:{tag:{pattern:/(&lt;|<)style[\w\W]*?(>|&gt;)|(&lt;|<)\/style(>|&gt;)/ig,inside:Prism.languages.markup.tag.inside},rest:Prism.languages.css}}});;
Prism.languages.css.selector={pattern:/[^\{\}\s][^\{\}]*(?=\s*\{)/g,inside:{"pseudo-element":/:(?:after|before|first-letter|first-line|selection)|::[-\w]+/g,"pseudo-class":/:[-\w]+(?:\(.*\))?/g,"class":/\.[-:\.\w]+/g,id:/#[-:\.\w]+/g}};Prism.languages.insertBefore("css","ignore",{hexcode:/#[\da-f]{3,6}/gi,entity:/\\[\da-f]{1,8}/gi,number:/[\d%\.]+/g,"function":/(attr|calc|cross-fade|cycle|element|hsla?|image|lang|linear-gradient|matrix3d|matrix|perspective|radial-gradient|repeating-linear-gradient|repeating-radial-gradient|rgba?|rotatex|rotatey|rotatez|rotate3d|rotate|scalex|scaley|scalez|scale3d|scale|skewx|skewy|skew|steps|translatex|translatey|translatez|translate3d|translate|url|var)/ig});;
Prism.languages.clike={comment:{pattern:/(^|[^\\])(\/\*[\w\W]*?\*\/|(^|[^:])\/\/.*?(\r?\n|$))/g,lookbehind:!0},string:/("|')(\\?.)*?\1/g,"class-name":{pattern:/((?:(?:class|interface|extends|implements|trait|instanceof|new)\s+)|(?:catch\s+\())[a-z0-9_\.\\]+/ig,lookbehind:!0,inside:{punctuation:/(\.|\\)/}},keyword:/\b(if|else|while|do|for|return|in|instanceof|function|new|try|throw|catch|finally|null|break|continue)\b/g,"boolean":/\b(true|false)\b/g,"function":{pattern:/[a-z0-9_]+\(/ig,inside:{punctuation:/\(/}}, number:/\b-?(0x[\dA-Fa-f]+|\d*\.?\d+([Ee]-?\d+)?)\b/g,operator:/[-+]{1,2}|!|&lt;=?|>=?|={1,3}|(&amp;){1,2}|\|?\||\?|\*|\/|\~|\^|\%/g,ignore:/&(lt|gt|amp);/gi,punctuation:/[{}[\];(),.:]/g};
;
Prism.languages.javascript=Prism.languages.extend("clike",{keyword:/\b(var|let|if|else|while|do|for|return|in|instanceof|function|new|with|typeof|try|throw|catch|finally|null|break|continue)\b/g,number:/\b-?(0x[\dA-Fa-f]+|\d*\.?\d+([Ee]-?\d+)?|NaN|-?Infinity)\b/g});Prism.languages.insertBefore("javascript","keyword",{regex:{pattern:/(^|[^/])\/(?!\/)(\[.+?]|\\.|[^/\r\n])+\/[gim]{0,3}(?=\s*($|[\r\n,.;})]))/g,lookbehind:!0}});Prism.languages.markup&&Prism.languages.insertBefore("markup","tag",{script:{pattern:/(&lt;|<)script[\w\W]*?(>|&gt;)[\w\W]*?(&lt;|<)\/script(>|&gt;)/ig,inside:{tag:{pattern:/(&lt;|<)script[\w\W]*?(>|&gt;)|(&lt;|<)\/script(>|&gt;)/ig,inside:Prism.languages.markup.tag.inside},rest:Prism.languages.javascript}}});
;
Prism.languages.php=Prism.languages.extend("clike",{keyword:/\b(and|or|xor|array|as|break|case|cfunction|class|const|continue|declare|default|die|do|else|elseif|enddeclare|endfor|endforeach|endif|endswitch|endwhile|extends|for|foreach|function|include|include_once|global|if|new|return|static|switch|use|require|require_once|var|while|abstract|interface|public|implements|extends|private|protected|parent|static|throw|null|echo|print|trait|namespace|use|final|yield|goto|instanceof|finally|try|catch)\b/ig, constant:/\b[A-Z0-9_]{2,}\b/g});Prism.languages.insertBefore("php","keyword",{delimiter:/(\?>|&lt;\?php|&lt;\?)/ig,variable:/(\$\w+)\b/ig,"package":{pattern:/(\\|namespace\s+|use\s+)[\w\\]+/g,lookbehind:!0,inside:{punctuation:/\\/}}});Prism.languages.insertBefore("php","operator",{property:{pattern:/(->)[\w]+/g,lookbehind:!0}}); Prism.languages.markup&&(Prism.hooks.add("before-highlight",function(a){"php"===a.language&&(a.tokenStack=[],a.code=a.code.replace(/(?:&lt;\?php|&lt;\?|<\?php|<\?)[\w\W]*?(?:\?&gt;|\?>)/ig,function(b){a.tokenStack.push(b);return"{{{PHP"+a.tokenStack.length+"}}}"}))}),Prism.hooks.add("after-highlight",function(a){if("php"===a.language){for(var b=0,c;c=a.tokenStack[b];b++)a.highlightedCode=a.highlightedCode.replace("{{{PHP"+(b+1)+"}}}",Prism.highlight(c,a.grammar,"php"));a.element.innerHTML=a.highlightedCode}}), Prism.hooks.add("wrap",function(a){"php"===a.language&&"markup"===a.type&&(a.content=a.content.replace(/(\{\{\{PHP[0-9]+\}\}\})/g,'<span class="token php">$1</span>'))}),Prism.languages.insertBefore("php","comment",{markup:{pattern:/(&lt;|<)[^?]\/?(.*?)(>|&gt;)/g,inside:Prism.languages.markup},php:/\{\{\{PHP[0-9]+\}\}\}/g}));;
Prism.languages.insertBefore("php","variable",{"this":/\$this/g,global:/\$_?(GLOBALS|SERVER|GET|POST|FILES|REQUEST|SESSION|ENV|COOKIE|HTTP_RAW_POST_DATA|argc|argv|php_errormsg|http_response_header)/g,scope:{pattern:/\b[\w\\]+::/g,inside:{keyword:/(static|self|parent)/,punctuation:/(::|\\)/}}});;
Prism.languages.coffeescript=Prism.languages.extend("javascript",{"block-comment":/([#]{3}\s*\r?\n(.*\s*\r*\n*)\s*?\r?\n[#]{3})/g,comment:/(\s|^)([#]{1}[^#^\r^\n]{2,}?(\r?\n|$))/g,keyword:/\b(this|window|delete|class|extends|namespace|extend|ar|let|if|else|while|do|for|each|of|return|in|instanceof|new|with|typeof|try|catch|finally|null|undefined|break|continue)\b/g});Prism.languages.insertBefore("coffeescript","keyword",{"function":{pattern:/[a-z|A-z]+\s*[:|=]\s*(\([.|a-z\s|,|:|{|}|\"|\'|=]*\))?\s*-&gt;/gi,inside:{"function-name":/[_?a-z-|A-Z-]+(\s*[:|=])| @[_?$?a-z-|A-Z-]+(\s*)| /g,operator:/[-+]{1,2}|!|=?&lt;|=?&gt;|={1,2}|(&amp;){1,2}|\|?\||\?|\*|\//g}},"attr-name":/[_?a-z-|A-Z-]+(\s*:)| @[_?$?a-z-|A-Z-]+(\s*)| /g});;
Prism.languages.scss=Prism.languages.extend("css",{comment:{pattern:/(^|[^\\])(\/\*[\w\W]*?\*\/|\/\/.*?(\r?\n|$))/g,lookbehind:!0},atrule:/@[\w-]+(?=\s+(\(|\{|;))/gi,url:/([-a-z]+-)*url(?=\()/gi,selector:/([^@;\{\}\(\)]?([^@;\{\}\(\)]|&amp;|\#\{\$[-_\w]+\})+)(?=\s*\{(\}|\s|[^\}]+(:|\{)[^\}]+))/gm});Prism.languages.insertBefore("scss","atrule",{keyword:/@(if|else if|else|for|each|while|import|extend|debug|warn|mixin|include|function|return)|(?=@for\s+\$[-_\w]+\s)+from/i});Prism.languages.insertBefore("scss","property",{variable:/((\$[-_\w]+)|(#\{\$[-_\w]+\}))/i});Prism.languages.insertBefore("scss","ignore",{placeholder:/%[-_\w]+/i,statement:/\B!(default|optional)\b/gi,"boolean":/\b(true|false)\b/g,"null":/\b(null)\b/g,operator:/\s+([-+]{1,2}|={1,2}|!=|\|?\||\?|\*|\/|\%)\s+/g});
;
Prism.languages.bash=Prism.languages.extend("clike",{comment:{pattern:/(^|[^"{\\])(#.*?(\r?\n|$))/g,lookbehind:!0},string:{pattern:/("|')(\\?[\s\S])*?\1/g,inside:{property:/\$([a-zA-Z0-9_#\?\-\*!@]+|\{[^\}]+\})/g}},keyword:/\b(if|then|else|elif|fi|for|break|continue|while|in|case|function|select|do|done|until|echo|exit|return|set|declare)\b/g});Prism.languages.insertBefore("bash","keyword",{property:/\$([a-zA-Z0-9_#\?\-\*!@]+|\{[^}]+\})/g});Prism.languages.insertBefore("bash","comment",{important:/(^#!\s*\/bin\/bash)|(^#!\s*\/bin\/sh)/g});
;
Prism.languages.c=Prism.languages.extend("clike",{keyword:/\b(asm|typeof|inline|auto|break|case|char|const|continue|default|do|double|else|enum|extern|float|for|goto|if|int|long|register|return|short|signed|sizeof|static|struct|switch|typedef|union|unsigned|void|volatile|while)\b/g,operator:/[-+]{1,2}|!=?|&lt;{1,2}=?|&gt;{1,2}=?|\-&gt;|={1,2}|\^|~|%|(&amp;){1,2}|\|?\||\?|\*|\//g});Prism.languages.insertBefore("c","keyword",{property:/#\s*[a-zA-Z]+/g});
;
Prism.languages.cpp=Prism.languages.extend("c",{keyword:/\b(alignas|alignof|asm|auto|bool|break|case|catch|char|char16_t|char32_t|class|compl|const|constexpr|const_cast|continue|decltype|default|delete|delete\[\]|do|double|dynamic_cast|else|enum|explicit|export|extern|float|for|friend|goto|if|inline|int|long|mutable|namespace|new|new\[\]|noexcept|nullptr|operator|private|protected|public|register|reinterpret_cast|return|short|signed|sizeof|static|static_assert|static_cast|struct|switch|template|this|thread_local|throw|try|typedef|typeid|typename|union|unsigned|using|virtual|void|volatile|wchar_t|while)\b/g,
operator:/[-+]{1,2}|!=?|&lt;{1,2}=?|&gt;{1,2}=?|\-&gt;|:{1,2}|={1,2}|\^|~|%|(&amp;){1,2}|\|?\||\?|\*|\/|\b(and|and_eq|bitand|bitor|not|not_eq|or|or_eq|xor|xor_eq)\b/g});
;
Prism.languages.sql={comment:{pattern:/(^|[^\\])(\/\*[\w\W]*?\*\/|((--)|(\/\/)).*?(\r?\n|$))/g,lookbehind:!0},string: /("|')(\\?.)*?\1/g,keyword:/\b(ACTION|ADD|AFTER|ALGORITHM|ALTER|ANALYZE|APPLY|AS|AS|ASC|AUTHORIZATION|BACKUP|BDB|BEGIN|BERKELEYDB|BIGINT|BINARY|BIT|BLOB|BOOL|BOOLEAN|BREAK|BROWSE|BTREE|BULK|BY|CALL|CASCADE|CASCADED|CASE|CHAIN|CHAR VARYING|CHARACTER VARYING|CHECK|CHECKPOINT|CLOSE|CLUSTERED|COALESCE|COLUMN|COLUMNS|COMMENT|COMMIT|COMMITTED|COMPUTE|CONNECT|CONSISTENT|CONSTRAINT|CONTAINS|CONTAINSTABLE|CONTINUE|CONVERT|CREATE|CROSS|CURRENT|CURRENT_DATE|CURRENT_TIME|CURRENT_TIMESTAMP|CURRENT_USER|CURSOR|DATA|DATABASE|DATABASES|DATETIME|DBCC|DEALLOCATE|DEC|DECIMAL|DECLARE|DEFAULT|DEFINER|DELAYED|DELETE|DENY|DESC|DESCRIBE|DETERMINISTIC|DISABLE|DISCARD|DISK|DISTINCT|DISTINCTROW|DISTRIBUTED|DO|DOUBLE|DOUBLE PRECISION|DROP|DUMMY|DUMP|DUMPFILE|DUPLICATE KEY|ELSE|ENABLE|ENCLOSED BY|END|ENGINE|ENUM|ERRLVL|ERRORS|ESCAPE|ESCAPED BY|EXCEPT|EXEC|EXECUTE|EXIT|EXPLAIN|EXTENDED|FETCH|FIELDS|FILE|FILLFACTOR|FIRST|FIXED|FLOAT|FOLLOWING|FOR|FOR EACH ROW|FORCE|FOREIGN|FREETEXT|FREETEXTTABLE|FROM|FULL|FUNCTION|GEOMETRY|GEOMETRYCOLLECTION|GLOBAL|GOTO|GRANT|GROUP|HANDLER|HASH|HAVING|HOLDLOCK|IDENTITY|IDENTITY_INSERT|IDENTITYCOL|IF|IGNORE|IMPORT|INDEX|INFILE|INNER|INNODB|INOUT|INSERT|INT|INTEGER|INTERSECT|INTO|INVOKER|ISOLATION LEVEL|JOIN|KEY|KEYS|KILL|LANGUAGE SQL|LAST|LEFT|LIMIT|LINENO|LINES|LINESTRING|LOAD|LOCAL|LOCK|LONGBLOB|LONGTEXT|MATCH|MATCHED|MEDIUMBLOB|MEDIUMINT|MEDIUMTEXT|MERGE|MIDDLEINT|MODIFIES SQL DATA|MODIFY|MULTILINESTRING|MULTIPOINT|MULTIPOLYGON|NATIONAL|NATIONAL CHAR VARYING|NATIONAL CHARACTER|NATIONAL CHARACTER VARYING|NATIONAL VARCHAR|NATURAL|NCHAR|NCHAR VARCHAR|NEXT|NO|NO SQL|NOCHECK|NOCYCLE|NONCLUSTERED|NULLIF|NUMERIC|OF|OFF|OFFSETS|ON|OPEN|OPENDATASOURCE|OPENQUERY|OPENROWSET|OPTIMIZE|OPTION|OPTIONALLY|ORDER|OUT|OUTER|OUTFILE|OVER|PARTIAL|PARTITION|PERCENT|PIVOT|PLAN|POINT|POLYGON|PRECEDING|PRECISION|PREV|PRIMARY|PRINT|PRIVILEGES|PROC|PROCEDURE|PUBLIC|PURGE|QUICK|RAISERROR|READ|READS SQL DATA|READTEXT|REAL|RECONFIGURE|REFERENCES|RELEASE|RENAME|REPEATABLE|REPLICATION|REQUIRE|RESTORE|RESTRICT|RETURN|RETURNS|REVOKE|RIGHT|ROLLBACK|ROUTINE|ROWCOUNT|ROWGUIDCOL|ROWS?|RTREE|RULE|SAVE|SAVEPOINT|SCHEMA|SELECT|SERIAL|SERIALIZABLE|SESSION|SESSION_USER|SET|SETUSER|SHARE MODE|SHOW|SHUTDOWN|SIMPLE|SMALLINT|SNAPSHOT|SOME|SONAME|START|STARTING BY|STATISTICS|STATUS|STRIPED|SYSTEM_USER|TABLE|TABLES|TABLESPACE|TEMPORARY|TEMPTABLE|TERMINATED BY|TEXT|TEXTSIZE|THEN|TIMESTAMP|TINYBLOB|TINYINT|TINYTEXT|TO|TOP|TRAN|TRANSACTION|TRANSACTIONS|TRIGGER|TRUNCATE|TSEQUAL|TYPE|TYPES|UNBOUNDED|UNCOMMITTED|UNDEFINED|UNION|UNPIVOT|UPDATE|UPDATETEXT|USAGE|USE|USER|USING|VALUE|VALUES|VARBINARY|VARCHAR|VARCHARACTER|VARYING|VIEW|WAITFOR|WARNINGS|WHEN|WHERE|WHILE|WITH|WITH ROLLUP|WITHIN|WORK|WRITE|WRITETEXT)\b/gi,boolean:/\b(TRUE|FALSE|NULL)\b/gi,number:/\b-?(0x)?\d*\.?[\da-f]+\b/g,operator:/\b(ALL|AND|ANY|BETWEEN|EXISTS|IN|LIKE|NOT|OR|IS|UNIQUE|CHARACTER SET|COLLATE|DIV|OFFSET|REGEXP|RLIKE|SOUNDS LIKE|XOR)\b|[-+]{1}|!|=?&lt;|=?&gt;|={1}|(&amp;){1,2}|\|?\||\?|\*|\//gi,ignore:/&(lt|gt|amp);/gi,punctuation:/[;[\]()`,.]/g};;
Prism.languages.http={"request-line":{pattern:/^(POST|GET|PUT|DELETE|OPTIONS|PATCH|TRACE|CONNECT)\b\shttps?:\/\/\S+\sHTTP\/[0-9.]+/g,inside:{property:/^\b(POST|GET|PUT|DELETE|OPTIONS|PATCH|TRACE|CONNECT)\b/g,"attr-name":/:\w+/g}},"response-status":{pattern:/^HTTP\/1.[01] [0-9]+.*/g,inside:{property:/[0-9]+[A-Z\s-]+$/g}},keyword:/^[\w-]+:(?=.+)/gm};var httpLanguages={"application/json":Prism.languages.javascript,"application/xml":Prism.languages.markup,"text/xml":Prism.languages.markup,"text/html":Prism.languages.markup};for(var contentType in httpLanguages){if(httpLanguages[contentType]){var options={};options[contentType]={pattern:new RegExp("(content-type:\\s*"+contentType+"[\\w\\W]*?)\\n\\n[\\w\\W]*","gi"),lookbehind:true,inside:{rest:httpLanguages[contentType]}};Prism.languages.insertBefore("http","keyword",options)}}
;
Prism.languages.ruby=Prism.languages.extend("clike",{comment:/#[^\r\n]*(\r?\n|$)/g,keyword:/\b(alias|and|BEGIN|begin|break|case|class|def|define_method|defined|do|each|else|elsif|END|end|ensure|false|for|if|in|module|new|next|nil|not|or|raise|redo|require|rescue|retry|return|self|super|then|throw|true|undef|unless|until|when|while|yield)\b/g,builtin:/\b(Array|Bignum|Binding|Class|Continuation|Dir|Exception|FalseClass|File|Stat|File|Fixnum|Fload|Hash|Integer|IO|MatchData|Method|Module|NilClass|Numeric|Object|Proc|Range|Regexp|String|Struct|TMS|Symbol|ThreadGroup|Thread|Time|TrueClass)\b/,constant:/\b[A-Z][a-zA-Z_0-9]*[?!]?\b/g});Prism.languages.insertBefore("ruby","keyword",{regex:{pattern:/(^|[^/])\/(?!\/)(\[.+?]|\\.|[^/\r\n])+\/[gim]{0,3}(?=\s*($|[\r\n,.;})]))/g,lookbehind:true},variable:/[@$&]+\b[a-zA-Z_][a-zA-Z_0-9]*[?!]?\b/g,symbol:/:\b[a-zA-Z_][a-zA-Z_0-9]*[?!]?\b/g})
;
Prism.languages.csharp=Prism.languages.extend("clike",{keyword:/\b(abstract|as|base|bool|break|byte|case|catch|char|checked|class|const|continue|decimal|default|delegate|do|double|else|enum|event|explicit|extern|false|finally|fixed|float|for|foreach|goto|if|implicit|in|int|interface|internal|is|lock|long|namespace|new|null|object|operator|out|override|params|private|protected|public|readonly|ref|return|sbyte|sealed|short|sizeof|stackalloc|static|string|struct|switch|this|throw|true|try|typeof|uint|ulong|unchecked|unsafe|ushort|using|virtual|void|volatile|while|add|alias|ascending|async|await|descending|dynamic|from|get|global|group|into|join|let|orderby|partial|remove|select|set|value|var|where|yield)\b/g,string:/@?("|')(\\?.)*?\1/g,preprocessor:/^\s*#.*/gm,number:/\b-?(0x)?\d*\.?\d+\b/g});
	
	Prism.highlightAll();
	
	module.resolve();
});
EasySocial.module( 'privacy' , function($) {

var module = this;

	EasySocial.require()
	.library( 'dialog' )
	.view( 'admin/profiles/form.privacy.custom.item' )
	.done(function($){

		EasySocial.Controller(
				'Profiles.Form.Privacy',
				{
					defaultOptions: {

						path: 'admin',

						// Elements
						"{selection}"			: ".privacySelection",
						"{browseButton}"    	: ".browseButton",
						"{userDeleteButton}"	: ".userDeleteButton",
						"{customContainer}"		: ".customContainer",

						view: {
							customItem : 'admin/profiles/form.privacy.custom.item'
						}

					}
				},
				function( self ){

					return {

						init: function()
						{

						},

						/**
						 * Binds the privacy's rule type select.
						 */
						"{selection} change" : function( el , event ){

							var selected	= $(el).val();
							var eleName		= $(el).attr( 'name' );

							if( selected == 'custom' )
							{
								self.customContainer().show();
							}
							else
							{
								self.customContainer().hide();
							}

						},

						"{userDeleteButton} click" : function( el, event ) {
							$(el).parents('li').remove();
						},

						"{browseButton} click" : function( el, event ) {


							var eleId		= $(el).attr( 'id' );
							var eleIndex 	= $(el).data('index');

							var userlistingpath = $.rootPath + 'administrator/index.php?option=com_easysocial&view=users&layout=listing&show=iframe';

							if( self.options.path == 'site' )
								userlistingpath = $.rootPath + 'index.php?option=com_easysocial&view=friends&layout=listing&show=iframe';

 							$.dialog({
 								title: 'Browse Users & Groups',
 								content: userlistingpath,
					            body: {
					                css: {
					                    width: 400,
					                    height: 300
					                }
					            },
								buttons: [
									{
										name : 'Assign',
										click : function(){

											var users = $('.foundryDialog').find('iframe').contents().find('input:checked');

											if( users.length > 0 )
											{
												for(var i = 0; i < users.length; i++)
												{
													var eleName = $(users[i]).attr('name');

													if( eleName == 'toggle')
														continue;

													var userId = $(users[i]).val();
													var userName = $('.foundryDialog').find('iframe').contents().find('input[name="user_' +userId+ '"]').val();

													var addedUsers = $('ul#privacy_ul' + eleIndex + ' input:hidden');
													var doAdd      = true;

													if( addedUsers.length > 0 )
													{
														for( var j=0; j < addedUsers.length; j++ )
														{
															if( $(addedUsers[j]).val() == userId )
															{
																doAdd = false;
																break;
															}
														}
													}

													if( doAdd )
													{
														html = self.view.customItem({
														 	userName : userName,
															eleName : eleId,
															userId  : userId
														});

														$('ul#privacy_ul' + eleIndex ).append( html );
													}
												}
											}

											//$("#google").contents().find("#hplogo").remove());

											$.dialog().close();
										}
									},
									{
										name : 'Close',
										click : function(){
											$.dialog().close();
										}
									}

								]
 							});



						}


					} //end return
				}//end function(self)
		);

		module.resolve();
	});

});

EasySocial.module('sharing', function($) {

	var module = this;

	EasySocial.require().library('textboxlist').done(function() {

		EasySocial.Controller('Sharing', {
			defaultOptions: {
				'{vendors}'		: '[data-sharing-vendor]',

				'{emailForm}'	: '[data-sharing-email]'
			}
		}, function(self) {
			return {
				init: function() {
					self.initLinks();

					self.initEmail();
				},

				initLinks: function() {
					$.each(self.vendors(), function(i, vendor) {

						vendor = $(vendor);

						if(!vendor.data('loaded')) {

							// Extract the href
							var link = vendor.attr('href');

							// Assign it to a data
							vendor.data('href', link);

							// Assign a void to the href
							vendor.attr('href', 'javascript:void(0);');

							// Assign loaded state
							vendor.attr('loaded', true);
						}
					});
				},

				initEmail: function() {
					$.each(self.emailForm(), function(i, form) {

						form = $(form);

						if(!form.data('loaded')) {

							// Implement email form controller
							self.addPlugin('email');

							// Assign loaded state
							form.attr('loaded', true);
						}
					});
				},

				'{vendors} click': function(el, ev) {
					var optionString = el.data('options') || '';

					window.open(el.data('href'), '', optionString);
				}
			}
		});

		$.template('sharing/recipientContent', '[%= title %]<input type="hidden" name="items" value="[%= title %]" />');

		EasySocial.Controller('Sharing.Email', {
			defaultOptions: {
				token			: '',

				'{container}'	: '[data-sharing-email]',

				'{frames}'		: '[data-sharing-email-frame]',

				'{recipients}'	: '[data-sharing-email-recipients]',

				'{input}'		: '[data-sharing-email-input]',

				'{content}'		: '[data-sharing-email-content]',

				'{send}'		: '[data-sharing-email-send]',

				// Frames
				'{frames}'		: '[data-sharing-email-frame]',

				'{frameForm}'	: '[data-sharing-email-form]',

				'{frameSending}': '[data-sharing-email-sending]',

				'{frameDone}'	: '[data-sharing-email-done]',

				'{frameFail}'	: '[data-sharing-email-fail]',

				'{failMsg}'		: '[data-sharing-email-fail-msg]'
			}
		}, function(self) {
			return {
				init: function() {

					self.options.token = self.container().data('token');

					// Initiate textboxlist plugin
					var test = self.recipients().textboxlist({
						component: 'es',
						view: {
							itemContent: 'sharing/recipientContent'
						}
					});

					self.originalPosition = self.container().css('position');
				},

				getRecipients: function() {
					var items = self.recipients().controller('textboxlist').getAddedItems();

					var recipients = [];

					$.each(items, function(i, item) {
						recipients.push(item.title);
					});

					var input = self.input().val();

					if(recipients.length < 1 && !$.isEmpty(input)) {
						recipients.push(input);
					}

					return recipients;
				},

				getContent: function() {
					return self.content().val();
				},

				'{send} click': function(el, ev) {
					if(el.enabled()) {
						el.disabled(true);

						// Control frames
						self.frames().hide();
						self.frameSending().show();

						// Get the data
						var token = self.options.token,
							recipients = self.getRecipients(),
							content = self.getContent();

						/// Make the ajax call
						self.submitForm(token, recipients, content)
							.done(function() {
								// Control frames
								self.frames().hide();
								self.frameDone().show();

								// Show the form after 1 second
								setTimeout(function() {
									// Clear recipients
									self.recipients().controller('textboxlist').clearItems();

									// Clear content
									self.content().val('');

									// Control frames
									self.frameDone().hide();
									self.frameForm().show();
								}, 1000);
							})
							.fail(function(msg) {
								// Control frames
								self.frames().hide();
								self.frameFail().show();
								self.frameForm().show();

								if(msg !== undefined) {
									self.failMsg().html(msg);
								}
							})
							.always(function() {
								el.enabled(true);
							});
					}

				},

				// Add email address in if comma is pressed
				'{input} keypress': function(el, ev) {
					if(ev.which === 44) {
						self.recipients().controller('textboxlist').addItem(el.val());
						el.val('');
						return false;
					}
				},

				submitForm: function(token, recipients, content) {
					return EasySocial.ajax('site/controllers/sharing/send', {
						token: token,
						recipients: recipients,
						content: content
					});
				}
			}
		});

		module.resolve();

	});
});

EasySocial.module( 'site/activities/activities' , function($){

	var module	= this;

	EasySocial.require()
	.script( 'site/activities/sidebar', 'site/activities/sidebar.item' )
	.view( 'site/loading/small' )
	.done(function($){

		EasySocial.Controller(
		'Activities',
		{
			defaultOptions:
			{
				// Properties
				items		: null,

				// Elements
				"{container}"	: "[data-activities]",

				"{contentTitle}": "[data-activities-content-title]",
				"{content}"		: "[data-activities-content]",
				"{sidebar}"		: "[data-activities-sidebar]",


				"{sidebarItem}"	: "[data-sidebar-item]",

				view :
				{
					loadingContent 	: "site/loading/small"
				}
			}
		},
		function( self ){
			return {

				init : function()
				{
					// Implement sidebar controller.
					self.sidebar().implement( EasySocial.Controller.Activities.Sidebar ,
					{
						"{parent}"	: self
					});

					self.sidebarItem().implement( EasySocial.Controller.Activities.Sidebar.Item ,
					{
						"{parent}"	: self
					});					
				},


				/**
				 * Add a loading icon on the content layer.
				 */
				updatingContents: function()
				{
					self.content().html( self.view.loadingContent() );
				},				

				updateContent: function( content, title )
				{
					self.content().html( content );
					self.contentTitle().html( title );
				}
							
			}
		});

		module.resolve();
	});

});
EasySocial.module( 'site/activities/sidebar' , function($){

	var module	= this;

	EasySocial.require()
	.done(function($){

		EasySocial.Controller(
			'Activities.Sidebar',
			{
				defaultOptions:
				{
					"{menuItem}"	: "[data-sidebar-menu]"
				}
			},
			function( self ){
				return {

					init: function()
					{
					},

					"{menuItem} click" : function( el , event )
					{
						// Remove all active class.
						self.menuItem().removeClass( 'active' );

						// Add active class on this item.
						$( el ).addClass( 'active' );
					}
				}
			});

		module.resolve();
	});

});
EasySocial.module( 'site/activities/sidebar.item' , function($){

	var module	= this;

	EasySocial.require()
	.library( 'history' )
	.done(function($){

		EasySocial.Controller(
			'Activities.Sidebar.Item',
			{
				defaultOptions:
				{
				}
			},
			function( self ){
				return {

					init: function()
					{
					},

					"{self} click" : function( el , event )
					{

						var type 	= self.element.data( 'type' ),
							url 	= self.element.data( 'url' ),
							title 	= self.element.data( 'title' ),
							desc 	= self.element.data( 'description' );

						// If this is an embedded layout, we need to play around with the push state.
						History.pushState( {state:1} , title , url );

						self.parent.updatingContents();

						//ajax call here.
						EasySocial.ajax( 'site/controllers/activities/getActivities',
						{
							"type"		: type
						})
						.done(function( html )
						{
							self.parent.updateContent( html, title );	
						})
						.fail(function( message ){
							console.log( message );
						});

						self.parent.updateContent();
					}
				}
			});

		module.resolve();
	});

});
EasySocial.module( 'site/activities/apps' , function($){

	var module	= this;

	EasySocial.require()
	.view( 'site/loading/small' )
	.language( 'COM_EASYSOCIAL_ACTIVITY_APPS_UNHIDE_SUCCESSFULLY', 'COM_EASYSOCIAL_ACTIVITY_USERS_UNHIDE_SUCCESSFULLY' )
	.done(function($){


		EasySocial.Controller(
			'Activities.Apps.List',
			{
				defaultOptions:
				{
					// Elements
					"{item}"	: "[data-hidden-app-item]",

					"{actorItem}"	: "[data-hidden-actor-item]",


					// loading gif
					view :
					{
						loadingContent 	: "site/loading/small"
					}

				}
			},
			function( self ){
				return {

					init : function()
					{
						self.item().implement( EasySocial.Controller.Activities.Apps.Item );
						self.actorItem().implement( EasySocial.Controller.Activities.Actors.Item );
					}

				}
			});

		EasySocial.Controller(
			'Activities.Actors.Item',
			{
				defaultOptions:
				{
					// Properties
					id 			: "",
					actor 	: "",

					"{unhideLink}" : "[data-hidden-actor-unhide]",

					"{content}" : "[data-hidden-actor-content]",

					// loading gif
					view :
					{
						loadingContent 	: "site/loading/small"
					}

				}
			},
			function( self ){
				return {

					init : function()
					{
						self.options.id 	= self.element.data( 'id' );
						self.options.actor 	= self.element.data( 'actor' );
					},

					"{unhideLink} click" : function(){

						EasySocial.ajax( 'site/controllers/activities/unhideactor',
						{
							"actor"		: self.options.actor,
							"id" 		: self.options.id
						})
						.done(function()
						{
							self.content().html( $.language( 'COM_EASYSOCIAL_ACTIVITY_USERS_UNHIDE_SUCCESSFULLY' ) );

						})
						.fail(function( message ){
							console.log( message );
						});

					}

				}
			});


		EasySocial.Controller(
			'Activities.Apps.Item',
			{
				defaultOptions:
				{
					// Properties
					id 			: "",
					context 	: "",

					"{unhideLink}" : "[data-hidden-app-unhide]",

					"{content}" : "[data-hidden-app-content]",

					// loading gif
					view :
					{
						loadingContent 	: "site/loading/small"
					}

				}
			},
			function( self ){
				return {

					init : function()
					{
						self.options.id 		= self.element.data( 'id' );
						self.options.context 	= self.element.data( 'context' );
					},

					"{unhideLink} click" : function(){

						EasySocial.ajax( 'site/controllers/activities/unhideapp',
						{
							"context"		: self.options.context,
							"id" 			: self.options.id
						})
						.done(function()
						{
							self.content().html( $.language( 'COM_EASYSOCIAL_ACTIVITY_APPS_UNHIDE_SUCCESSFULLY' ) );

						})
						.fail(function( message ){
							console.log( message );
						});

					}

				}
			});



		module.resolve();
	});

});

EasySocial.module( 'site/activities/item' , function($){

	var module	= this;

	EasySocial.require()
	.script()
	.done(function($){

		EasySocial.Controller(
			'Activities.Item',
			{
				defaultOptions:
				{
					// Elements
					"{toggle}"		: "[data-activity-toggle]",
					"{deleteBtn}"	: "[data-activity-delete]"

				}
			},
			function( self ){
				return {

					init : function()
					{
						// Implement sidebar controller.
					},

					"{toggle} click" : function( el , event )
					{
						EasySocial.ajax( 'site/controllers/activities/toggle',
						{
							"id"		: self.element.data('id'),
							"curState" 	: self.element.data('current-state')
						})
						.done(function( lbl, isHidden)
						{
							$( el ).text( lbl );
							self.element.data('current-state', isHidden);

							if( isHidden )
							{
								self.element.children( "div.es-stream" ).addClass( 'isHidden' );
							}
							else
							{
								self.element.children( "div.es-stream" ).removeClass( 'isHidden' );
							}
						})
						.fail(function( message ){

							console.log( message );
						});
					},

					"{deleteBtn} click" : function()
					{
						var uid = self.element.data('id');

						EasySocial.dialog({
							content		: EasySocial.ajax( 'site/views/activities/confirmDelete' ),
							bindings	:
							{
								"{deleteButton} click" : function()
								{
									EasySocial.ajax( 'site/controllers/activities/delete',
									{
										"id"		: uid,
									})
									.done(function( html )
									{
										self.element.fadeOut();

										// close dialog box.
										EasySocial.dialog().close();
									});
								}
							}
						});

					}


				}
			});

		module.resolve();
	});

});

EasySocial.module( 'site/activities/list' , function($){

	var module	= this;

	EasySocial.require()
	.view( 'site/loading/small', 'site/activities/loadbutton' )
	.language( 'COM_EASYSOCIAL_ACTIVITY_LOG_LOAD_PREVIOUS_STREAM_ITEMS' )
	.script('site/activities/item')
	.done(function($){

		EasySocial.Controller(
			'Activities.List',
			{
				defaultOptions:
				{
					// Elements
					"{item}"	: "[data-activity-item]",


					"{pagination}"  : "[data-activity-pagination]",

					// loading gif
					view :
					{
						loadingContent 	: "site/loading/small",
						loadmoreContent :"site/activities/loadbutton"
					}

				}
			},
			function( self ){
				return {

					init : function()
					{
						// self.item()
						// 	.addController(
						// 		"EasySocial.Controller.Activities.Item"
						// 	);

						self.item().implement( EasySocial.Controller.Activities.Item );

						self.on("scroll.activities", window, $._.debounce(function(){

							if (self.loading) return;

							if (self.pagination().visible()) {

								self.loadMore();
							}

						}, 250));
					},

					"{pagination} click" : function() {
						self.loadMore();
					},

					loadMore: function() {

						var type 		= $("[data-sidebar-menu].active").data( 'type' );
						var startlimit 	= self.pagination().data('startlimit');

						if( startlimit == '')
						{
							return;
						}

						self.loading = true;

						self.pagination().html( self.view.loadingContent({content: ""}) );

						EasySocial.ajax( 'site/controllers/activities/getActivities' ,
						{
							"limitstart" : startlimit,
							"loadmore" : '1',
							"type" : type
						})
						.done(function( contents, startlimit ) {
							// update next start date
							self.pagination().data('startlimit', startlimit );

							// append stream into list.
							self.pagination().before( contents );

							//re-implement controller on new items
							self.item().implement( EasySocial.Controller.Activities.Item );

							if (startlimit=="") {
								self.pagination().html('');
							} else {
								//append the anchor link.
								self.pagination().html( self.view.loadmoreContent() );
							}

						})
						.fail( function( messageObj ){
							return messageObj;
						})
						.always(function(){
							self.loading = false;
						});
					}




				}
			});

		module.resolve();
	});

});

EasySocial.module( 'site/albums/all' , function($){

	var module 				= this;

	EasySocial.require()
	.library( 'history' )
	.done(function($){

		EasySocial.Controller( 'Albums.All.Browser',
		{
			defaultOptions:
			{
				"{sort}"	: "[data-albums-sort]",
				"{contents}": "[data-albums-content]"
			}
		},
		function( self )
		{
			return{ 

				init: function()
				{
				},

				setActiveSort: function( el )
				{
					self.sort().removeClass( 'active' );

					$( el ).addClass( 'active' );
				},

				"{sort} click" : function( el , event )
				{
					event.preventDefault();
					
					self.setActiveSort( el );

					$( el ).route();

					// Set loading state for the content
					self.contents().addClass( 'is-loading' );
					self.contents().html( '&nbsp;' );

					// Run the ajax call now
					EasySocial.ajax( 'site/controllers/albums/getAlbums' )
					.done(function( contents )
					{
						self.contents().html( contents );
					});
				}
			}
		});

		module.resolve();
	
	});


});

EasySocial.module( 'site/apps/apps' , function($){

	var module 				= this;

	EasySocial.require()
	.library( 'history' )
	.view(
		'site/loading/small'
	)
	.done(function($){

		EasySocial.Controller(
			'Apps',
			{
				defaultOptions :
				{
					requireTerms	: true,
					"{content}"	: "[data-apps-listing]",
					"{sort}"	: "[data-apps-sort]",
					"{filter}"	: "[data-apps-filter]",
					"{filterLink}" : "[data-apps-filter-link]",
					"{item}"	: "[data-apps-item]",
					"{sorting}"	: "[data-apps-sorting]",
					"{title}"	: "[data-page-apps-title]",

					view :
					{
						loading 	: 'site/loading/small'
					}
				}
			},
			function( self )
			{
				return {

					init : function()
					{
						// Implement apps item controller.
						self.initAppItem();
					},

					initAppItem : function()
					{
						self.item().implement( EasySocial.Controller.Apps.Item ,
						{
							requireTerms 	: self.options.requireTerms
						});
					},

					"{filterLink} click": function( el , event )
					{
						event.preventDefault();
					},

					"{filter} click" : function( el , event )
					{
						// Remove all active classes on the left
						self.sort().removeClass('active');
						self.filter().removeClass('active');

						// Add active class to the current filter item.
						el.addClass( 'active' );

						el.find( 'a' ).route();

						// Get the sort type.
						var filter 	= el.data( 'apps-filter-type' );

						// Get the sort group
						var group = el.data( 'apps-filter-group' );

						// Set the title.
						var title 	= el.find( 'a' ).attr( 'title' );
						self.title().html( title );

						// Set the current active filter
						self.options.filter 	= filter;

						// If the filter is 'mine' , we don't want to show the sorting options
						if (filter == 'mine') {
							self.sorting().hide();
						} else {
							self.sorting().show();
						}

						EasySocial.ajax( 'site/controllers/apps/getApps', {
							"filter": filter,
							"group": group
						}, {
							
							beforeSend: function() {
								// Set the default sorting type to alphabetically ordered.
								self.sort('.alphabetical').addClass('active');

								self.content().html( self.view.loading() );
							}
						}).done(function(output) {

							// Set is-empty class on the content so the empty message will be displayed
							self.content().toggleClass("is-empty", $(output).hasClass("empty"));

							// Append the output back.
							self.content().html(output);

							// Reapply the item controller
							self.initAppItem();
						});
					},

					"{sort} click" : function( el , event )
					{
						// Get the sort type and filter type.
						var type = el.data('apps-sort-type'),
							url = el.data('apps-sort-url'),
							group = el.data('apps-sort-group');

						History.pushState({state:1}, '' , url);

						// Add the active state on the current element.
						self.sort().removeClass( 'active' );

						el.addClass( 'active' );

						EasySocial.ajax( 'site/controllers/apps/getApps',
						{
							"sort"	: type,
							"filter": self.options.filter,
							"group"	: group
						},
						{
							beforeSend: function()
							{
								self.content().html( self.view.loading() );
							}
						})
						.done( function( output )
						{

							// Append the output back.
							self.content().html( output );

							// Reapply the item controller
							self.initAppItem();
						});
					}
				}
			});

		EasySocial.Controller(
			'Apps.Item',
			{
				defaultOptions :
				{
					id				: null,
					requireTerms 	: true,

					"{install}"		: "[data-apps-item-install]",
					"{installed}"	: "[data-apps-item-installed]",
					"{settings}"	: "[data-apps-item-settings]",

					view :
					{
						installAppForm : "site/apps/dialog.install",
						uninstallAppForm: "site/apps/dialog.uninstall"
					}
				}
			},
			function( self ) {
				return {

					init : function() {
						if(self.element.data('id')) {
							self.options.id = self.element.data('id');
						}
					},

					"{install} click" : function( el )
					{
						EasySocial.dialog({
							content: EasySocial.ajax('site/views/apps/getTnc' ),
							bindings:
							{
								'{cancelButton} click': function() {
									EasySocial.dialog().close();
								},

								'{installButton} click': function(el)
								{
									var agreed = !self.options.requireTerms || this.agreeCheckbox().is(':checked');

									if( agreed )
									{
										this.termsError().hide();

										self.installApp();
									}
									else
									{
										this.termsError().show();
									}
								}
							}
						});
					},

					installApp: function()
					{

						var installing = EasySocial.ajax('site/controllers/apps/installApp', {
							id: self.options.id
						});

						EasySocial.dialog({
							content: installing,
							bindings:
							{
								"{closeButton} click" : function(){
									EasySocial.dialog().close();
								}
							}
						});

						installing.done(function()
						{
							self.install().enabled(true);

							self.install().hide();

							self.installed().show();

							self.settings().hide();
						});
					},

					"{settings} click" : function( el , event )
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( "site/views/apps/settings" , { "id" : self.options.id } ),
							bindings	:
							{
							}
						})
					},

					'{installed} click': function(el) {
						if(el.enabled()) {

							el.disabled(true);

							EasySocial.dialog({
								content		: EasySocial.ajax('site/views/apps/confirmUninstall'),
								bindings	:
								{
									'{parent.closeButton} click': function() {
										self.installed().enabled(true);
									},

									'{cancelButton} click': function() {
										self.installed().enabled(true);

										EasySocial.dialog().close();
									},

									'{uninstallButton} click': function()
									{
										self.uninstallApp();
									}
								}
							});
						}
					},

					uninstallApp: function() {
						var uninstalling = EasySocial.ajax('site/controllers/apps/uninstallApp', {
							id: self.options.id
						});

						EasySocial.dialog({
							content: uninstalling,
							bindings:
							{
								'{closeButton} click' : function()
								{
									EasySocial.dialog().close();
								}
							}
						});

						uninstalling.done(function()
						{
							self.installed().enabled(true);

							self.installed().hide();

							self.settings().hide();

							self.install().show();
						});
					}
				}
			});

		module.resolve();
	});


});

EasySocial.module('site/badges/badge', function($) {
	var module = this;

	EasySocial.Controller('Badges.Badge', {
		defaultOptions: {
			id					: 0,
			total				: 0,

			'{achieversList}'	: '[data-badge-achievers-list]',

			'{achiever}'		: '[data-badge-achievers-achiever]',

			'{loadIndicator}'	: '[data-badge-achievers-loading]',

			'{loadButton}'		: '[data-badge-achievers-load]',
		}
	}, function(self) {
		return {
			init: function() {
				self.options.id = self.element.data('id');
				self.options.total = self.element.data('total-achievers');
			},

			'{loadButton} click': function(el) {
				var current = self.achiever().length;

				if(el.enabled() && current < self.options.total) {
					el.disabled(true);

					el.hide();

					self.loadIndicator().show();

					EasySocial.ajax('site/controllers/badges/loadAchievers', {
						id: self.options.id,
						start: current
					}).done(function(html) {

						self.achieversList().append(html);

						el.enabled(true);

						self.loadIndicator().hide();

						if(self.achiever().length < self.options.total) {
							el.show();
						}

					}).fail(function(msg) {

					});
				}
			},

			loadAchievers: function() {

			}
		}
	});

	module.resolve();
});

EasySocial.module('site/comments/control', function($) {
	var module = this;

	/**
	 *	Comments update controller
	 *	Should only exist once on the page
	 *	Act as a data handler between server and client for comments update (add/delete/edit etc)
	 *	Global functions should be here as well
	 */

	EasySocial.Controller('CommentsControl', {
		defaultOptions: {
			interval: 30
		}
	}, function(self) { return {
		init: function() {
			self.startUpdate();
		},

		// Comments block registry
		$Blocks: {},

		startUpdate: function() {
			self.options.monitoring = true;
			self.updateBlocks();
		},

		stopUpdate: function() {
			self.options.monitoring = false;
		},

		updateBlocks: function(){

			(self.updateBlocks = $._.debounce(function() {

				var data = self.populate();

				if(!self.options.monitoring)
				{
					return false;
				}

				EasySocial.ajax('site/controllers/comments/getUpdates', {
					data: data
				}).done(function(result) {

					// Push updates to each comment block
					$.each(result, function(element, block) {
						$.each(block, function(uid, comments) {

							var comment = self.$Blocks[element][uid];

							if (comment._destroyed) return;

							comment.updateComment(comments);
						});
					});

				}).always(function() {

					self.updateBlocks();
				});
			}, self.options.interval * 1000))();
		},

		register: function(instance) {
			var group = instance.options.group,
				element = instance.options.element,
				streamid = instance.options.streamid,
				uid = instance.options.uid,
				verb = instance.options.verb;

			if (streamid == '') {
				streamid = '0';
			}

			var key = element + '.' + group + '.' + verb;

			if(self.$Blocks[key] === undefined) {
				self.$Blocks[key] = {};
			}

			// we need to use the stream id + uid so that for those aggregated items,
			// we can still get the comments correctly for each individual items. E.g. upload mulitple photos will create same stream id for each photo items.
			var blockkey = streamid + '.' + uid;

			self.$Blocks[key][blockkey] = instance;

			instance.trigger('commentBlockRegistered');
		},

		populate: function() {
			var data = {};

			$.each(self.$Blocks, function(key, block) {
				data[key] = {};

				$.each(block, function(blockkey, comments) {
					data[key][blockkey] = comments._export();
				});
			});

			return data;
		}
	} });


	EasySocial.ready(function(){

		// Implement this controller on to es-wrap
		EasySocial.Comments = $('body').addController('EasySocial.Controller.CommentsControl');

		module.resolve();
	});

});

EasySocial.module('site/comments/frame', function($) {
	var module = this;

	EasySocial
		.require()
		.library('mentions')
		.script('site/comments/item')
		.view(
			"site/friends/suggest.item",
			"site/friends/suggest.hint.search",
			"site/friends/suggest.hint.empty",
			"site/hashtags/suggest.item",
			"site/hashtags/suggest.hint.search",
			"site/hashtags/suggest.hint.empty"
		)
		.language(
			'COM_EASYSOCIAL_COMMENTS_LOADED_OF_TOTAL',
			'COM_EASYSOCIAL_COMMENTS_STATUS_SAVING',
			'COM_EASYSOCIAL_COMMENTS_STATUS_SAVED'
		)
		.done(function() {

			/**
			 *	Parent comments controller
			 */
			EasySocial.Controller('Comments', {
				defaultOptions: {
					'group'				: 'user',
					'element'			: 'stream',
					'verb'				: 'null',
					'uid'				: 0,

					'enterkey'			: 'submit',

					'url'				: '',

					'streamid' 			: '',

					'{actionContent}'	: '[data-action-contents-comments]',
					'{actionLink}'		: '[data-stream-action-comments]',

					'{stat}'			: '[data-comments-stat]',

					'{load}'			: '[data-comments-load]',

					'{list}'			: '[data-comments-list]',

					'{item}'			: '[data-comments-item]',

					'{form}'			: '[data-comments-form]'
				}
			}, function(self) { return {

				// List all the triggers here made to parent
				// newCommentSaving
				// newCommentSaved(comment)
				// newCommentSaveError(errormsg)
				// oldCommentsLoaded(comments)
				// oldCommentsLoadError(errormsg)
				// commentDeleted(id)

				// Item triggers
				// commentEditLoading(id)
				// commentEditLoaded(id, rawcomment)
				// commentEditLoadError(id, errormsg)
				// commentEditSaving(id, newcomment)
				// commentEditSaved(id, newcomment)
				// commentEditSaveError(id, errormsg)
				// commentDeleting(id)
				// commentDeleteError(id, errormsg)

				init: function() {
					// Initialise uid
					self.options.uid = self.element.data('uid') || self.options.uid;

					// Initialise element
					self.options.element = self.element.data('element') || self.options.element;

					// Initialise group
					self.options.group = self.element.data('group') || self.options.group;

					// Initialise verb
					self.options.verb = self.element.data('verb') || self.options.verb;

					// Initialise url
					self.options.url = self.element.data('url') || self.options.url;

					// Initialise streamid
					self.options.streamid = self.element.data('streamid') || self.options.streamid;

					self.$Stat = self.addPlugin('stat');
					self.$Load = self.addPlugin('load');
					self.$List = self.addPlugin('list');
					self.$Form = self.addPlugin('form');

					// Comment Control needs to be required once when there is a frame on the page
					EasySocial.require().script('site/comments/control').done(function() {

						// This block needs to be registered
						EasySocial.Comments.register(self);
					});

					// Trigger commentInit on self
					self.trigger('commentInit', [self]);
				},

				// Create a registry of items
				$Comments: {},

				registerComment: function(instance) {
					var id = instance.options.id;

					self.$Comments[id] = instance;
				},

				'{actionLink} click' : function(){
					self.actionContent().toggle();
				},

				_export: function() {
					var data = {
						total: self.$Stat.total(),
						count: self.$Stat.count(),
						ids: $._.keys(self.$Comments)
					};

					return data;
				},

				updateComment: function(comments) {
					var newComments = [];

					$.each(comments['ids'], function(commentid, state) {
						if(state !== true) {
							if(state === false) {

								// Trigger commentDeleted event on self (as parent)
								self.trigger('commentDeleted', [commentid]);

							} else {
								var appended = false;

								// Search for the next larger id as the node to insert before
								$.each(self.$Comments, function(id, comment) {
									if(id > commentid) {
										self.$List.addToList(state, id, false);

										appended = true;
										return false;
									}
								});

								// If no node found, then just append it to the list
								if(!appended) {
									self.$List.addToList(state, 'append', false);
								}

								// Add this comment into the list of new comments
								newComments.push(state);
							}
						}
					});

					// Update the new total count
					self.$Stat.total(comments['total']);

					// Trigger oldCommentsLoaded event
					self.trigger('oldCommentsLoaded', [newComments]);
				},

				'{self} show': function() {
					self.element.show();

					self.$Form.input().focus();
				}
			} });
			/**
			 *	List controller
			 */
			EasySocial.Controller('Comments.List', {
				defaultOptions: {
					'{list}': '[data-comments-list]',

					'{item}': '[data-comments-item]'
				}
			}, function(self) { return {
				init: function() {
					// Multiple instances of items
					self.initItemController(self.item(), false);
				},

				initItemController: function(item, isNew) {
					item.addController('EasySocial.Controller.Comments.Item', {
						controller: {
							parent: self.parent
						},

						isNew: isNew
					});

					return item;
				},

				'{parent} newCommentSaved': function(el, event, comment) {
					// Add the comment to the list
					self.addToList(comment);
				},

				addToList: function(comment, type, isNew) {
					// Set type to append by default
					type = type === undefined ? 'append' : type;

					// Set isNew to true by default
					isNew = isNew === undefined ? true : isNew;

					// Wrap comment in jQuery
					comment = $(comment);

					// Implement item controller on comment
					self.initItemController(comment, isNew);

					// Check if type is append/prepend
					if(type == 'append' || type == 'prepend') {

						// Prepare function values based on type (append/prepend)
						var filter = type == 'append' ? ':last' : ':first',
							action = type == 'append' ? 'after' : 'before';

						// Add the comment item into list
						if(self.item().length === 0) {
							// If no comments yet then add the html into the list
							self.list().html(comment);
						} else {
							// If there are existing comments, then append/prepend comment into the list
							self.item(filter)[action](comment);
						}
					} else {

						// If type is neither append or prepend, then type could be the comment id
						var item = self.parent.$Comments[type];

						// Check if type is a valid comment, if it is then by this means prepend on top
						if(item !== undefined) {
							item.element.before(comment);
						}
					}

					// Show the whole comment block because the block could be hidden
					self.parent.actionContent().show();
				},

				'{parent} commentDeleted': function(el, event, id) {
					// Remove this comment from comment registry
					if(self.parent.$Comments[id] !== undefined) {

						// Remove the element
						self.parent.$Comments[id].element.remove();

						// Remove the controller reference in the registry
						delete self.parent.$Comments[id];
					}
				}
			} });

			/**
			 *	Statistic controller
			 */
			EasySocial.Controller('Comments.Stat', {
				defaultOptions: {
					'{stats}'	: '[data-comments-stats]',

					count	: 0,
					total	: 0,

					limit	: 10
				}
			}, function(self) { return {
				init: function() {
					self.options.count = self.element.data('count');
					self.options.total = self.element.data('total');
				},

				// Get / set total comments
				total: function(count) {
					if(count !== undefined) {
						self.options.total = parseInt(count);
						self.stats().text($.language('COM_EASYSOCIAL_COMMENTS_LOADED_OF_TOTAL', self.count(), self.total()));
					}

					return self.options.total;
				},

				// Get / set current comments
				count: function(count) {
					if(count !== undefined) {
						self.options.count = parseInt(count);
						self.stats().text($.language('COM_EASYSOCIAL_COMMENTS_LOADED_OF_TOTAL', self.count(), self.total()));
					}

					return self.options.count;
				},

				getNextCycle: function() {
					var start = Math.max(self.total() - self.count() - self.options.limit, 0);

					var limit = self.total() - self.count() - start;

					return {
						start: start,
						limit: limit
					}
				},

				'{parent} oldCommentsLoaded': function(el, event, comments) {
					var count = comments.length;

					self.count(self.count() + count);
				},

				'{parent} newCommentSaved': function() {
					self.total(self.total() + 1);

					self.count(self.count() + 1);
				},

				'{parent} commentDeleted': function() {
					self.total(self.total() - 1);

					self.count(self.count() - 1);
				}
			} });

			/**
			 *	Load more controller
			 */
			EasySocial.Controller('Comments.Load', {
				defaultOptions: {
					'{load}'		: '[data-comments-load]',

					'{loadMore}'	: '[data-comments-load-loadMore]'
				}
			}, function(self) { return {
				init: function() {

				},

				'{loadMore} click': function(el, event) {
					if(el.enabled()) {

						// Disable the button
						el.disabled(true);

						// Get boundary details
						var cycle = self.parent.$Stat.getNextCycle();

						// If limit is 0, means no comment to load
						if(cycle.limit == 0) {
							return false;
						}

						// Send load comments command to the server
						self.loadComments(cycle.start, cycle.limit)
							.done(function(comments) {
								// Comments come in with chronological order array
								// Hence need to reverse comment and prepend from bottom

								// Create a copy of reverse comments to not affect the original array
								// Slice is to create a non reference copy of the array
								var reversedComments = comments.slice().reverse();

								$.each(reversedComments, function(index, comment) {
									self.parent.$List.addToList(comment, 'prepend', false);
								});

								// Trigger oldCommentsLoaded event
								self.parent.trigger('oldCommentsLoaded', [comments]);

								// Enable the button
								el.enabled(true);

								// If start is 0, means this is the last round of comments to load
								cycle.start == 0 && self.load().hide();
							})
							.fail(function(msg) {

								// Trigger oldCommentsLoadError event
								self.parent.trigger('oldCommentsLoadError', [msg]);
							});
					}
				},

				loadComments: function(start, limit) {
					limit = limit || 10;
					return EasySocial.ajax('site/controllers/comments/load', {
						uid: self.parent.options.uid,
						element: self.parent.options.element,
						group: self.parent.options.group,
						verb: self.parent.options.verb,
						start: start,
						length: limit
					});
				}
			} });

			/**
			 *	Form controller
			 */
			EasySocial.Controller('Comments.Form',
			{
				defaultOptions:
				{
					'{editorHeader}'	: '[data-comment-form-header]',
					'{editorArea}'		: '[data-comment-form-editor-area]',
					'{input}'			: '[data-comments-form-input]',
					'{submit}'			: '[data-comments-form-submit]',
					'{status}'			: '[data-comments-form-status]',
					view:
					{
						suggestItem: "site/friends/suggest.item",
						tagSuggestItem: "site/hashtags/suggest.item"
					}
				}
			}, function(self) { return {
				init: function()
				{
					self.setMentionsLayout();
				},

				'{input} keypress': function(el, event)
				{
					if (event.keyCode == 13) {
						if(self.parent.options.enterkey === 'submit' && !(event.shiftKey || event.altKey || event.ctrlKey || event.metaKey)) {
							self.submitComment();
						}

						if(self.parent.options.enterkey === 'newline' && (event.shiftKey || event.altKey || event.ctrlKey || event.metaKey)) {
							self.submitComment();
						}
					}
				},

				'{submit} click': function(el, event)
				{
					if (el.enabled()) {
						self.submitComment();
					}
				},

				setMentionsLayout: function()
				{
					var loader = $.Deferred();

					var editor		= self.editorArea(),
						mentions	= editor.controller("mentions");


					if (mentions) {
						mentions.cloneLayout();
						return;
					}

					var header = self.editorHeader();

					editor
						.mentions(
						{
							triggers:
							{
							    "@":
							    {
									type			: "entity",
									wrap			: false,
									stop			: "",
									allowSpace		: true,
									finalize		: true,
									query:
									{
										loadingHint	: true,
										searchHint	: $.View("easysocial/site/friends/suggest.hint.search"),
										emptyHint	: $.View("easysocial/site/friends/suggest.hint.empty"),

										data: function( keyword )
										{

											var task = $.Deferred();

											EasySocial.ajax( "site/controllers/friends/suggest" , { search: keyword })
											.done(function(items)
											{
												if (!$.isArray(items)) task.reject();

												var items = $.map(items, function(item)
												{
													item.title	= item.screenName;
													item.type	= "user";

													item.menuHtml = self.view.suggestItem(true, {
														item: item,
														name: "uid[]"
													});

													return item;
												});

												task.resolve(items);
											})
											.fail(task.reject);

											return task;
										},
										use: function(item) {
											return item.type + ":" + item.id;
										}
								    }
								},
								"#":
								{
								    type: "hashtag",
								    wrap: true,
								    stop: " #",
								    allowSpace: false,
									query: {
										loadingHint: true,
										searchHint: $.View("easysocial/site/hashtags/suggest.hint.search"),
										emptyHint: $.View("easysocial/site/hashtags/suggest.hint.empty"),
										data: function(keyword) {

											var task = $.Deferred();

											EasySocial.ajax("site/controllers/hashtags/suggest", {search: keyword})
												.done(function(items) {

													if (!$.isArray(items)) {
														task.reject();
													}

													var items = $.map(items, function(item){
														item.title = "#" + item.title;
														item.type = "hashtag";
														item.menuHtml = self.view.tagSuggestItem(true, {
															item: item,
															name: "uid[]"
														});
														return item;
													});

													task.resolve(items);
												})
												.fail(task.reject);

											return task;
										}
								    }
								}
							},
							plugin:
							{
								autocomplete:
								{
									id			: "fd",
									component	: "es",
									position	:
									{
										my: 'left top',
										at: 'left bottom',
										of: header,
										collision: 'none'
									},
									size:
									{
										width: function()
										{
											return header.width();
										}
									}
								}
							}
						});
				},

				submitComment: function()
				{
					var comment = self.input().val();

					// If comment value is empty, then don't proceed
					if($.trim(comment) == '')
					{
						return false;
					}

					// Trigger newCommentSaving event
					self.parent.trigger('newCommentSaving');

					// Execute save
					self.save()
						.done(function(comment) {
							// Rather than using commentItem ejs, let PHP return a full block of HTML codes
							// This is to unify 1 single theme file to use loading via static or ajax

							// trigger parent's commentSaved event
							self.parent.trigger('newCommentSaved', [comment]);

							// Enable the submit button
							self.submit().enabled(true);

							var editor		= self.editorArea(),
								mentions	= editor.controller("mentions");

							// Reset the mentions upon saving.
							mentions && mentions.reset();

							// update the stream exclude id if applicable
							if( self.parent.options.streamid != '' )
							{
								self.updateStreamExcludeIds( self.parent.options.streamid );
							}
						})
						.fail(function(msg) {
							self.parent.trigger('newCommentSaveError', [msg.message]);
						});
				},

				save: function()
				{
					var mentions = self.editorArea().controller("mentions");

					var data = {
						url			: self.parent.options.url,
						mentions	: mentions ? mentions.toArray() : []
					};

					data.mentions = $.map(data.mentions, function(mention){
						if (mention.type==="hashtag" && $.isPlainObject(mention.value)) {
							mention.value = mention.value.title.slice(1);
						}
						return JSON.stringify(mention);
					});

					return EasySocial.ajax('site/controllers/comments/save', {
						uid: self.parent.options.uid,
						element: self.parent.options.element,
						group: self.parent.options.group,
						verb: self.parent.options.verb,
						streamid: self.parent.options.streamid,
						input: self.input().val(),
						data: data
					});
				},

				updateStreamExcludeIds: function( id )
				{
					// ids = self.element.data('excludeids' );
					ids = $('[data-streams-wrapper]').data( 'excludeids' );

					newIds = '';
					if( ids != '' && ids != undefined )
					{
						newIds = ids + ',' + id;
					}
					else
					{
						newIds = id;
					}

					// self.element.data('excludeids', newIds );
					$('[data-streams-wrapper]').data( 'excludeids', newIds );
				},

				disableForm: function() {
					// Disable input
					self.input().attr('disabled', true);

					// Disable submit button
					self.submit().disabled(true);
				},

				enableForm: function()
				{
					// Enable and reset input
					self.input().removeAttr('disabled');

					// Enable submit button
					self.submit().enabled(true);
				},

				'{parent} newCommentSaving': function()
				{
					// Show the status as it could be hidden by other actions
					self.status().show();

					// Set the status as success
					self.status().removeClass('label-important label-success label-info');
					self.status().addClass('label-info');

					// Set the status
					self.status().text($.language('COM_EASYSOCIAL_COMMENTS_STATUS_SAVING'));

					// Disable comment form
					self.disableForm();
				},

				'{parent} newCommentSaved': function() {
					// Show the status bar of the form
					self.status().show();

					// Set the text of the status bar
					self.status().text($.language('COM_EASYSOCIAL_COMMENTS_STATUS_SAVED'));

					// Set the status as success
					self.status().removeClass('label-important label-success label-info');
					self.status().addClass('label-success');

					// Fade out the status bar after 2 second
					setTimeout(function() {
						self.status().fadeOut('fast');
					}, 2000);

					// Enable comment form
					self.enableForm();

					// Reset comment input
					self.input().val('');
				},

				'{parent} newCommentSaveError': function(el, event, msg) {
					// Show the status bar of the form
					self.status().show();

					// Set the status as error
					self.status().removeClass('label-important label-success label-info');
					self.status().addClass('label-important');

					// Add the error message
					self.status().text(msg);

					// Enable comment form
					self.enableForm();
				}
			} });

			module.resolve();
		});
})

EasySocial.module('site/comments/item', function($) {
	var module = this;

	EasySocial.require()
		.library('mentions')
		.view(
			"site/friends/suggest.item",
			"site/friends/suggest.hint.search",
			"site/friends/suggest.hint.empty",
			"site/hashtags/suggest.item",
			"site/hashtags/suggest.hint.search",
			"site/hashtags/suggest.hint.empty"
		)
		.language(
			'COM_EASYSOCIAL_COMMENTS_STATUS_SAVE_ERROR',
			'COM_EASYSOCIAL_COMMENTS_STATUS_LOADING',
			'COM_EASYSOCIAL_COMMENTS_STATUS_LOAD_ERROR',
			'COM_EASYSOCIAL_COMMENTS_STATUS_DELETING',
			'COM_EASYSOCIAL_COMMENTS_STATUS_DELETE_ERROR',
			'COM_EASYSOCIAL_LIKES_LIKE',
			'COM_EASYSOCIAL_LIKES_UNLIKE'
		)
		.done(function() {
			/**
			 *	Item controller
			 */
			EasySocial.Controller('Comments.Item', {
				defaultOptions: {
					'id'			: 0,

					'child'			: 0,

					'loadedChild'	: 0,

					'limit'			: 10,

					'isNew'			: false,

					'{frame}'		: '[data-comments-item-frame]',

					'{avatar}'		: '[data-comments-item-avatar]',

					'{commentFrame}': '[data-comments-item-commentFrame]',

					'{author}'		: '[data-comments-item-author]',

					'{action}'		: '[data-comments-item-actions]',
					'{edit}'		: '[data-comments-item-actions-edit]',
					'{delete}'		: '[data-comments-item-actions-delete]',
					'{spam}'		: '[data-comments-item-actions-spam]',

					'{comment}'		: '[data-comments-item-comment]',

					'{meta}'		: '[data-comments-item-meta]',

					'{date}'		: '[data-comments-item-date] a',

					'{like}'		: '[data-comments-item-like]',
					'{likeCount}'	: '[data-comments-item-likeCount]',

					'{editFrame}'	: '[data-comments-item-editFrame]',
					'{editInput}'	: '[data-comments-item-edit-input]',
					'{editCancel}'	: '[data-comments-item-edit-cancel]',
					'{editSubmit}'	: '[data-comments-item-edit-submit]',
					'{editStatus}'	: '[data-comments-item-edit-status]',

					'{statusFrame}'	: '[data-comments-item-statusFrame]',

					'{loadReplies}'	: '[data-comments-item-loadReplies]',

					'{readMore}'	: '[data-es-comment-readmore]',

					'{fullContent}'	: '[data-es-comment-full]',

					view: {
						suggestItem: "site/friends/suggest.item",
						tagSuggestItem: "site/hashtags/suggest.item"
					}
				}
			}, function(self) { return {
				init: function() {
					// Initialise comment id
					self.options.id = self.element.data('id');

					// Initialise child count
					self.options.child = self.element.data('child');

					// Register self into the registry of comments
					self.parent.registerComment(self);

					// Add the status plugin
					// self.status = self.addPlugin('status');

					// Using add Controller instead of addPlugin because the parent should reference the item's parent, not the item itself
					self.status = self.element.addController('EasySocial.Controller.Comments.Item.Status', {
						controller: {
							parent: self.parent,
							item: self
						}
					})
				},

				'{like} click': function(el) {
					if(el.enabled()) {
						// Disable the like button
						el.disabled(true);

						// Send the like to the server
						self.likeComment()
							.done(function(liked, count, string) {

								// Enable the button
								el.enabled(true);

								// Set the likes count
								self.likeCount().text(count);

								// Strip off tags from the like text
								string = $('<div></div>').html(string).text();

								// Set the like text
								self.likeCount().attr('data-original-title', string);

								// Set the like button text
								self.like().find('a').text($.language(liked ? 'COM_EASYSOCIAL_LIKES_UNLIKE' : 'COM_EASYSOCIAL_LIKES_LIKE'));
							})
							.fail(function() {

							});
					}
				},

				likeComment: function() {
					return EasySocial.ajax('site/controllers/comments/like', {
						id: self.options.id
					});
				},

				'{likeCount} click': function() {
					EasySocial.dialog({
						content: self.getLikedUsers()
					});
				},

				getLikedUsers: function() {
					return EasySocial.ajax('site/controllers/comments/likedUsers', {
						id: self.options.id
					});
				},

				'{edit} click': function(el) {
					if(el.enabled()) {

						var editor = self.editFrame(),
							mentions = editor.controller("mentions");

						// Manually clear out the html and destroy the mentions controller to prevent conflict of loading the editFrame again.
						editor.html('');
						if (mentions) {
							mentions.destroy();
						}

						// Disable the edit button
						el.disabled(true);

						// Trigger commentEditLoading event
						self.trigger('commentEditLoading', [self.options.id]);

						self.getEditComment()
							.done(function(html) {
								self.trigger('commentEditLoaded', [self.options.id, html]);

								self.editFrame().html(html).show();

								self.setMentionsLayout();
							})
							.fail(function(msg) {

								// Trigger commentEditLoadError event
								self.trigger('commentEditLoadError', [self.options.id, msg]);
							});;

						// self.getRawComment()
						// 	.done(function(comment) {

						// 		// Trigger commentEditLoaded event
						// 		self.trigger('commentEditLoaded', [self.options.id], comment);

						// 		// Set the edit input to the raw comment value
						// 		self.editInput().val(comment);

						// 		// Focus on the edit input
						// 		self.editInput().focus();
						// 	})
						// 	.fail(function(msg) {

						// 		// Trigger commentEditLoadError event
						// 		self.trigger('commentEditLoadError', [self.options.id, msg]);
						// 	});
					}
				},

				setMentionsLayout: function()
				{
					var editor		= self.editFrame(),
						mentions	= editor.controller("mentions");


					if (mentions)
					{
						mentions.cloneLayout();
						return;
					}

					var header = self.editFrame();

					editor
						.mentions(
						{
							triggers:
							{
								"@":
								{
									type			: "entity",
									wrap			: false,
									stop			: "",
									allowSpace		: true,
									finalize		: true,
									query:
									{
										loadingHint	: true,
										searchHint	: $.View("easysocial/site/friends/suggest.hint.search"),
										emptyHint	: $.View("easysocial/site/friends/suggest.hint.empty"),

										data: function( keyword )
										{

											var task = $.Deferred();

											EasySocial.ajax( "site/controllers/friends/suggest" , { search: keyword })
											.done(function(items)
											{
												if (!$.isArray(items)) task.reject();

												var items = $.map(items, function(item)
												{
													item.title	= item.screenName;
													item.type	= "user";

													item.menuHtml = self.view.suggestItem(true, {
														item: item,
														name: "uid[]"
													});

													return item;
												});

												task.resolve(items);
											})
											.fail(task.reject);

											return task;
										},
										use: function(item) {
											return item.type + ":" + item.id;
										}
									}
								},
								"#":
								{
									type		: "hashtag",
									wrap		: true,
									stop		: " #",
									allowSpace	: false,
									query:
									{
										loadingHint	: false,
										searchHint	: $.View("easysocial/site/hashtags/suggest.hint.search"),
										emptyHint	: $.View("easysocial/site/hashtags/suggest.hint.empty"),
										data: function(keyword)
										{

											var task = $.Deferred();

											EasySocial.ajax("site/controllers/hashtags/suggest", {search: keyword})
												.done(function(items)
												{
													if (!$.isArray(items)) task.reject();

													var items = $.map(items, function(item){
														item.title = "#" + item.title;
														item.type = "hashtag";
														item.menuHtml = self.view.tagSuggestItem(true, {
															item: item,
															name: "uid[]"
														});
														return item;
													});

													task.resolve(items);
												})
												.fail(task.reject);

											return task;
										}
									}
								}
							},
							plugin:
							{
								autocomplete:
								{
									id			: "fd",
									component	: "es",
									position	:
									{
										my: 'left top',
										at: 'left bottom',
										of: header,
										collision: 'none'
									},
									size:
									{
										width: function()
										{
											return header.width();
										}
									}
								}
							}
						});
				},

				getRawComment: function() {
					return EasySocial.ajax('site/controllers/comments/getRawComment', {
						id: self.options.id
					});
				},

				getEditComment: function() {
					return EasySocial.ajax('site/controllers/comments/getEditComment', {
						id: self.options.id
					});
				},

				'{editCancel} click': function() {
					self.trigger('commentEditCancel', [self.options.id]);

					self.edit().enabled(true);
				},

				'{editSubmit} click': function() {
					self.submitEdit();
				},

				submitEdit: function() {
					// Get and trim the edit value
					var input = self.editInput().val();

					// Do not proceed if value is empty
					if(input == '') {
						return false;
					}

					// Trigger commentEditSaving event
					self.trigger('commentEditSaving', [self.options.id, input]);

					// Send the edit to the server
					self.saveEdit()
						.done(function(comment) {

							// Trigger commentEdited event
							self.trigger('commentEditSaved', [self.options.id, comment]);

							// Update the comment content
							self.comment().html(comment);

							self.edit().enabled(true);
						})
						.fail(function(msg) {

							// Trigger commentEditError event
							self.trigger('commentEditSaveError', [self.options.id, msg]);
						});
				},

				saveEdit: function() {
					var mentions = self.editFrame().mentions("controller");

					return EasySocial.ajax('site/controllers/comments/update', {
						id: self.options.id,
						input: self.editInput().val(),
						mentions: mentions ? mentions.toArray() : []
					});
				},

				'{delete} click': function(el) {
					// Prepare the item properly first
					self.frame().hide();
					self.commentFrame().show();

					// Clone the whole item to place in the dialog
					// var comment = self.element.clone();

					EasySocial.dialog({
						content: EasySocial.ajax('site/views/comments/confirmDelete', {
							id: self.options.id
						}),
						selectors: {
							"{deleteButton}"  : "[data-delete-button]",
							"{cancelButton}"  : "[data-cancel-button]"
						},
						bindings: {
							"{deleteButton} click": function() {

								// Close the dialog
								EasySocial.dialog().close();

								// Trigger commentDeleting event on parent to announce to sibling frames
								self.parent.trigger('commentDeleting', [self.options.id]);

								// Trigger commentDeleting event on self to announce to child frames
								self.trigger('commentDeleting');

								// Send delete command to server
								self.deleteComment()
									.done(function() {

										// Trigger commentDeleted event on parent, since this element will be remove, no point triggering on self
										self.parent.trigger('commentDeleted', [self.options.id]);
									})
									.fail(function(msg) {

										// Trigger commentDeleteError event on parent to announce to sibling frames
										self.parent.trigger('commentDeleteError', [self.options.id, msg]);

										// Trigger commentDeleteError event on self to announce to child frames
										self.trigger('commentDeleteError', [self.options.id, msg]);
									});
							},

							"{cancelButton} click": function() {

								// Close the dialog
								EasySocial.dialog().close();
							}
						}
					});
				},

				deleteComment: function() {
					return EasySocial.ajax('site/controllers/comments/delete', {
						id: self.options.id
					});
				},

				'{loadReplies} click': function(el) {
					// Hide the loadReplies button
					el.hide();

					// Add a loader after this comment first

					// Calculate the start
					var start = Math.max(self.options.child - self.options.loadedChild - self.options.limit, 0);

					// Get the child comments
					EasySocial.ajax()
						.done(function(comments) {

							// Append the comments below the current comment item
							$.each(comments, function(index, comment) {
								self.parent.$List.addToList(comment, 'child', false);
							});

							// Trigger oldCommentsLoaded event
							self.parent.trigger('oldCommentsLoaded', [comments]);

							// Check if we need to show the load more replies button in the current item
							start > 0 && self.loadMoreReplies().show();
						});
				},

				'{readMore} click': function(el, ev) {
					self.comment().html(self.fullContent().html());
				}
			} });

			/**
			 *	Status frame controller
			 */
			EasySocial.Controller('Comments.Item.Status', {
				defaultOptions: {
					'{frame}'		: '[data-comments-item-frame]',

					'{statusFrame}'	: '[data-comments-item-statusFrame]',

					'{statusContent}': '[data-comments-item-statusFrame] div',

					'{commentFrame}': '[data-comments-item-commentFrame]',

					'{editFrame}'	: '[data-comments-item-editFrame]'
				}
			}, function(self) { return {

				// commentEditLoading(id)
				// commentEditLoaded(id, rawcomment)
				// commentEditLoadError(id, errormsg)
				// commentEditCancel(id)
				// commentEditSaving(id, newcomment)
				// commentEditSaved(id, newcomment)
				// commentEditSaveError(id, errormsg)
				// commentDeleting(id)
				// commentDeleted(id)
				// commentDeleteError(id, errormsg)

				init: function() {

				},

				setStatus: function(html) {
					self.frame().hide();

					if ($.isPlainObject(html) && html.message !== undefined) {
						html = html.message;
					}

					self.statusContent().html(html);

					self.statusFrame().show();
				},

				'{self} commentEditLoading': function() {
					self.setStatus($.language('COM_EASYSOCIAL_COMMENTS_STATUS_LOADING'));
				},

				'{self} commentEditLoaded': function() {
					self.frame().hide();

					self.editFrame().show();
				},

				'{self} commentEditLoadError': function() {
					self.setStatus($.language('COM_EASYSOCIAL_COMMENTS_STATUS_LOAD_ERROR'));
				},

				'{self} commentEditCancel': function() {
					self.frame().hide();

					self.commentFrame().show();
				},

				'{self} commentEditSaving': function() {
					self.setStatus($.language('COM_EASYSOCIAL_COMMENTS_STATUS_SAVING'));
				},

				'{self} commentEditSaved': function() {
					self.frame().hide();

					self.commentFrame().show();
				},

				'{self} commentEditSaveError': function() {
					self.setStatus($.language('COM_EASYSOCIAL_COMMENTS_STATUS_SAVE_ERROR'));
				},

				'{self} commentDeleting': function() {
					self.setStatus($.language('COM_EASYSOCIAL_COMMENTS_STATUS_DELETING'));
				},

				'{self} commentDeleteError': function(el, event, id, msg) {
					msg = msg || $.language('COM_EASYSOCIAL_COMMENTS_STATUS_DELETE_ERROR');
					self.setStatus(msg);
				}
			} });

			module.resolve();
		});
});

EasySocial.module( 'site/conversations/conversations' , function($){

	var module 	= this;


	EasySocial.require()
	.script( 'site/conversations/mailbox' , 'site/conversations/item' , 'site/conversations/filter' )
	.language( 'COM_EASYSOCIAL_NO_BUTTON' )
	.done( function($){

		EasySocial.Controller(
			'Conversations',
			{
				defaultOptions:
				{
					"{mailbox}"	: "[data-conversations-mailbox]",
					"{list}"	: "[data-conversations-list]",
					"{content}"	: "[data-conversations-content]",

					"{item}"		: "[data-conversations-item]",

					// Conversation actions
					"{actions}"		: "[data-conversations-actions]",

					// Conversations filter
					"{filterItem}"	: "[data-conversations-filter]",

					// Check All
					"{checkAll}"	: "[data-conversations-checkAll]",
					"{checkbox}"	: "[data-conversationItem-checkbox]",

					// Actions that can be performed on the conversations
					"{delete}"		: "[data-conversations-delete]",
					"{archive}"		: "[data-conversations-archive]",
					"{unarchive}"	: "[data-conversations-unarchive]",
					"{unread}"		: "[data-conversations-unread]",
					"{read}"		: "[data-conversations-read]"
				}
			},
			function( self ){

				return {

					init: function()
					{
						// Implement mailbox controller.
						self.mailbox().implement( EasySocial.Controller.Conversations.Mailbox ,
						{
							"{parent}"	: self
						});

						self.item().implement( EasySocial.Controller.Conversations.Item , {
							"{parent}"	: self
						});

						self.filterItem().implement( EasySocial.Controller.Conversations.Filter ,
						{
							"{parent}"	: self
						});
					},

					"{filterItem} click" : function( el )
					{
						// Remove all active classes on filter link.
						self.filterItem().removeClass( 'active' );

						// Add active class on active element.
						$( el ).addClass( 'active' );
					},

					"{checkbox} change" : function( el )
					{
						// See if there's any more checked items.
						if( self.checkbox( ':checked' ).length <= 0 && !el.is( ':checked' ) )
						{
							return self.actions().removeClass( 'is-checked' );
						}

						self.actions().addClass( 'is-checked' );
					},

					/**
					 * Checks all checkbox on the page.
					 */
					"{checkAll} click" : function( el )
					{
						// If there's nothing to check, we do not let them to check anything.
						if( self.checkbox().length <= 0 )
						{
							// Uncheck this.
							$( el ).prop( 'checked' , false );
							
							return false;
						}

						if( el.is( ':checked' ) )
						{
							// We don't want to trigger the checked items since they are already checked.
							self.checkbox( ':not(:checked)' ).click();
						}
						else
						{
							self.checkbox( ':checked' ).click();
						}
					},

					/**
					 * Allows caller to add an is-empty to the list.
					 */
					showEmpty: function()
					{
						self.content().addClass( 'is-empty' );
					},

					/**
					 * Allows caller to add an is-empty to the list.
					 */
					hideEmpty: function()
					{
						self.content().removeClass( 'is-empty' );
					},

					/**
					 * Toggles the loading class on the content.
					 */
					toggleLoading: function()
					{
						self.content().removeClass( 'is-empty' )
							.toggleClass( 'is-loading' );
					},

					/**
					 * Allows caller to trigger this method to update the conversations content.
					 */
					updateContent : function( content , mailbox )
					{
						if( mailbox != undefined )
						{
							self.content().addClass( 'layout-' + mailbox );
						}
						else
						{
							self.content().removeClass( 'layout-archives' );
						}
						// Whenever updateContent is called, we need to hide the actions
						self.actions().removeClass('is-checked');
						self.checkAll().removeAttr( 'checked' );
						
						self.list().html( content );
					},

					getSelectedConversations : function()
					{
						// Let's see if there's any checked items.
						if( self.checkbox(':checked').length <= 0 )
						{
							return false;
						}

						var selected	= new Array;
						self.checkbox(':checked').each( function( i , checkedItem ){
							selected.push( $( checkedItem ).val() );
						});

						return selected;
					},

					"{archive} click" : function()
					{
						var selected	= self.getSelectedConversations();

						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'site/views/conversations/confirmArchive' , { "ids" : selected } ),
							bindings 	:
							{
								"{confirmButton} click" : function()
								{
									$( '[data-conversation-archive-form]' ).submit();
								}
							}
						});
					},

					"{unarchive} click" : function()
					{
						var selected	= self.getSelectedConversations();

						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'site/views/conversations/confirmUnarchive' , { "ids" : selected } ),
							bindings 	:
							{
								"{confirmButton} click" : function()
								{
									$( '[data-conversation-archive-form]' ).submit();
								}
							}
						})
					},

					"{delete} click" : function()
					{
						var selected	= self.getSelectedConversations();

						EasySocial.dialog(
						{
							content		: EasySocial.ajax( 'site/views/conversations/confirmDelete' , { "ids" : selected }),
							bindings	:
							{
								"{deleteButton} click" : function()
								{
									$( '[data-conversation-delete-form]' ).submit();
								}
							}
						});

					},

					"{read} click" : function()
					{
						// If there's nothing to mark as unread, just ignore.
						if( self.checkbox( ':checked' ).length <= 0 )
						{
							return false;
						}
						
						var ids = new Array();

						// Loop through each checked items.
						self.checkbox( ':checked' ).each( function( i , checkedItem ){
							ids.push( $( checkedItem ).val() );
						});

						EasySocial.ajax( 'site/controllers/conversations/markRead' , 
						{
							"ids"	: ids
						})
						.done( function(){
							
							// Add unread class on the items.
							self.checkbox()
								.parents( '[data-conversations-item]' )
								.removeClass( 'unread' )
								.addClass( 'read' );

							// We need to tell the mailbox controller to update the count.
							self.mailbox().controller().updateCounters();
						})
						.fail(function( message )
						{
							self.setMessage( message );
						});

					},

					"{unread} click" : function()
					{
						// If there's nothing to mark as unread, just ignore.
						if( self.checkbox( ':checked' ).length <= 0 )
						{
							return false;
						}
						
						var ids = new Array();

						// Loop through each checked items.
						self.checkbox( ':checked' ).each( function( i , checkedItem ){
							ids.push( $( checkedItem ).val() );
						});

						EasySocial.ajax( 'site/controllers/conversations/markUnread' , 
						{
							"ids"	: ids
						})
						.done( function(){
							
							// Add unread class on the items.
							self.checkbox()
								.parents( '[data-conversations-item]' )
								.removeClass( 'read' )
								.addClass( 'unread' );

							// We need to tell the mailbox controller to update the count.
							self.mailbox().controller().updateCounters();

						})
						.fail(function( message ){
							console.log( message );
						});

					}
				}
			}
		);

		module.resolve();
	});

});


EasySocial.module( 'site/conversations/mailbox' , function($){

	var module 	= this;


	EasySocial.require()
	.library( 'history' )
	.done( function($){

		EasySocial.Controller(
			'Conversations.Mailbox',
			{
				defaultOptions:
				{
					"{item}"	: "[data-mailboxItem]"
				}
			},
			function( self ){

				return {

					init: function()
					{
						self.item().implement( EasySocial.Controller.Conversations.Mailbox.Item ,
						{
							"{parent}"	: self
						});
					},

					updateCounters: function()
					{
						self.item( '.active' ).controller().updateCounter();
					},

					updateContent : function( items , mailbox )
					{
						// Request the parent to update the contents.
						self.parent.updateContent( items , mailbox );
					},

					showEmpty: function()
					{
						self.parent.showEmpty();
					},

					hideEmpty: function()
					{
						self.parent.hideEmpty();
					},

					toggleLoading: function()
					{
						self.parent.toggleLoading();
					}
				}
			}
		);

		EasySocial.Controller(
			'Conversations.Mailbox.Item',
			{
				defaultOptions:
				{
					"{counter}"	: "[data-mailboxItem-counter]",

					view :
					{
						emptyTemplate : "site/conversations/default.item.empty"
					}
				}
			},
			function( self ){
				return {

					init: function()
					{

					},

					updateCounter: function()
					{
						EasySocial.ajax( 'site/controllers/conversations/getCount' ,
						{
							"mailbox"	: self.element.data( 'mailbox' )
						})
						.done(function( total ){

							// If there's no more new items, hide it.
							if( total <= 0 )
							{
								self.counter().html( '' );

								return;
							}

							self.counter().html( '(' + total + ')' );
						})
					},

					toggleLoading: function()
					{
						self.element.toggleClass( 'loading' );
					},

					"{self} click" : function()
					{
						var url 	= self.element.data( 'url' ),
							title 	= self.element.data( 'title' ),
							mailbox	= self.element.data( 'mailbox' );

						// Remove active class on all mailboxes.
						self.parent.item().removeClass( 'active' );

						// Add active class to this.
						self.element.addClass( 'active' );

						History.pushState( {state:1} , title , url );

						// Get contents via ajax.
						EasySocial.ajax( 'site/views/conversations/getItems' ,
						{
							"mailbox"	: mailbox,
							"limitstart" : 0
						},
						{
							beforeSend: function()
							{
								// Add loading indicator to the mailbox list.
								self.toggleLoading();

								// Add loading indicator.
								self.parent.toggleLoading();
							}
						})
						.done(function( content , empty ){

							// Remove loading class on the element.
							self.toggleLoading();

							// Remove loading class on the content.
							self.parent.toggleLoading();

							if( content.length <= 0 )
							{
								// Empty the contents too to maintain the integrity of the checkbox
								self.parent.updateContent( '' );
								return self.parent.showEmpty();
							}

							// Hide empty class if it has items.
							self.parent.hideEmpty();

							// Now we'd need to update the content.
							self.parent.updateContent( content , self.element.data( 'mailbox' ) );

						});
					}
				}
		});

		module.resolve();
	});


});


EasySocial.module( 'site/conversations/item' , function($){

	var module 	= this;


	EasySocial.require()
	.script( 'site/conversations/mailbox' )
	.done( function($){

		EasySocial.Controller(
			'Conversations.Item',
			{
				defaultOptions:
				{
					"{checkbox}"	: "[data-conversationItem-checkbox]"
				}
			},
			function( self ){

				return {

					init: function()
					{
					},

					"{checkbox} change": function( el ){

						var checked = $( el ).is( ':checked' );

						if( checked )
						{
							return self.element.addClass( 'selected' );
						}

						return self.element.removeClass( 'selected' );
					}
				}
			}
		);

		module.resolve();
	});

});


EasySocial.module( 'site/conversations/filter' , function($){

	var module 	= this;


	EasySocial.require()
	.done( function($){

		EasySocial.Controller(
			'Conversations.Filter',
			{
				defaultOptions:
				{
				}
			},
			function( self ){

				return {

					init: function()
					{
					},

					"{self} click" : function()
					{
						var type 		= self.element.data( 'filter' ),
							selector	= '.' + type,
							total 		= self.parent.item( selector ).length;

						if( $("[data-mailboxitem]").filter(".active").length == 1 )
						{
							var curActiveMenu = $("[data-mailboxitem]").filter(".active");

							var url 	= curActiveMenu.data( 'url' ),
								title 	= curActiveMenu.data( 'title' ),
								mailbox	= curActiveMenu.data( 'mailbox' );


							History.pushState( {state:1} , title , url );

							// Get contents via ajax.
							EasySocial.ajax( 'site/views/conversations/getItems' ,
							{
								"mailbox"	: mailbox,
								"filter" 	: type,
								"limitstart": 0
							},
							{
								beforeSend: function()
								{
									// Add loading indicator.
									self.parent.toggleLoading();
								}
							})
							.done(function( content , empty ){


								// Remove loading class on the content.
								self.parent.toggleLoading();

								if( content.length <= 0 )
								{
									// Empty the contents too to maintain the integrity of the checkbox
									self.parent.updateContent( '' );
									return self.parent.showEmpty();
								}

								// Hide empty class if it has items.
								self.parent.hideEmpty();

								// Now we'd need to update the content.
								self.parent.updateContent( content , mailbox );

							});



						}

						// if( type == 'all' )
						// {
						// 	if( self.parent.item().length == 0 )
						// 	{
						// 		self.parent.showEmpty();
						// 	}
						// 	else
						// 	{
						// 		self.parent.hideEmpty();
						// 	}

						// 	self.parent.item().show();
						// }
						// else
						// {

						// 	// Hide all conversations initially.
						// 	self.parent.item().hide();


						// 	if( total == 0 )
						// 	{
						// 		// Show empty.
						// 		self.parent.showEmpty();
						// 	}
						// 	else
						// 	{
						// 		// Always hide empty when there are items.
						// 		self.parent.hideEmpty();
						// 	}

						// 	// Only show the necessary item.
						// 	self.parent.item( "." + type ).show();
						// }
					}
				}
			}
		);

		module.resolve();
	});

});


EasySocial.module( 'site/conversations/read' , function($){

	var module 	= this;

	EasySocial.require()
	.library( 'dialog' )
	.script( 'site/conversations/composer' , 'site/friends/suggest' )
	.language(
		'COM_EASYSOCIAL_CONVERSATION_REPLY_POSTED_SUCCESSFULLY',
		'COM_EASYSOCIAL_CONVERSATION_REPLY_FORM_EMPTY'
	)
	.done(function($){

		EasySocial.Controller(
			'Conversations.Read',
			{
				defaultOptions:
				{
					// Conversation id.
					id 	: "",

					// Determines if these features should be enabled.
					attachments 		: true,
					location 			: false,
					maxSize 			: "3mb",

					extensionsAllowed	 : "",
					attachmentController : null,
					composerController	 : null,

					// Conversation items.
					"{item}"		: "[data-readConversation-item]",
					"{items}"		: "[data-readConversation-items]",

					// Form composer
					"{composer}"	: "[data-readConversation-composer]",

					// Buttons
					"{replyButton}"	: "[data-readConversation-replyButton]",

					// Add participant to a conversation.
					"{addParticipant}"	: "[data-readConversation-addParticipant]",

					// Leave conversation.
					"{leaveConversation}"	: "[data-readConversation-leaveConversation]",

					// Delete conversation.
					"{delete}"			: "[data-readConversation-delete]",

					// Attachments
					"{attachments}"		: "[data-uploaderQueue-id]",

					// Notice message on reply form.
					"{replyNotice}"		: "[data-readConversation-replyNotice]",

					// Load previous message button.
					"{readLoadMore}"		: "[data-readconversation-load-more]",


					// Views
					view	:
					{
						messageItem		: 'site/conversations/read.message'
					}
				}
			},
			function( self ){
				return {

					init: function()
					{
						// Implement the composer on the reply form
						self.composer().implement( EasySocial.Controller.Conversations.Composer ,
						{
							"{uploader}"		: "[data-readConversation-attachment]",
							"{location}"		: "[data-readConversation-location]",
							maxSize 			: self.options.maxSize,
							extensionsAllowed	: self.options.extensionsAllowed
						});

						// Get the composer controller.
						self.options.composerController 	= self.composer().controller();

						if( self.options.attachments )
						{
							// Get the uploader controller.
							self.options.attachmentController = self.options.composerController.uploader().controller();
						}

						if( self.options.location )
						{
							// Get the location controller.
							self.options.locationController = self.options.composerController.location().controller();
						}

						// Initialize message item.
						self.item().implement( EasySocial.Controller.Conversations.Read.Item );

						// Set the conversation id.
						self.options.id 	= self.element.data( 'id' );
					},

					resetForm: function()
					{
						// Reset the editor form.
						self.options.composerController.resetForm();

						var mentions = self.composer().controller().editorArea().mentions( 'controller' );

						mentions.reset();

						if( self.options.location )
						{
							// Reset the location.
							self.options.locationController.removeLocation();
						}

						if( self.options.attachments )
						{
							// Reset the uploader.
							self.options.attachmentController.reset();
						}
					},

					"{readLoadMore} click" : function( el )
					{
						var id = $( el ).data( 'id' ),
							limitstart = $(el).data( 'limitstart' );

						self.readLoadMore().hide();
						$( '.loading-indicator' ).show();

						var options 	=	{
												"id"			: id,
												"limitstart"	: limitstart
											};

						// Do an ajax call to submit the reply.
						EasySocial.ajax( 'site/controllers/conversations/loadPrevious' , options )
						.done(function( html, nextlimit )
						{
							$.buildHTML(html)
								.prependTo(self.items())
								.addController("EasySocial.Controller.Conversations.Read.Item");

							if( nextlimit == 0 )
							{
								self.readLoadMore().hide();
							}
							else
							{
								self.readLoadMore().show();
								$(el).data( 'limitstart', nextlimit );
							}

						})
						.always(function()
						{
							$( '.loading-indicator' ).hide();
						});


					},


					"{replyButton} click" : function( el , event )
					{
						// Stop bubbling up.
						event.preventDefault();

						var content 	= self.options.composerController.editor().val(),
							files 		= new Array;


						if( content.length <= 0 )
						{
							self.replyNotice().html( $.language( 'COM_EASYSOCIAL_CONVERSATION_REPLY_FORM_EMPTY' ) ).addClass( 'alert alert-error' ).removeClass( 'alert-success' );
							return false;
						}

						if( self.options.attachments )
						{
							// Get through each attachments.
							self.attachments().each( function( i , attachment ){
								files.push( $( attachment ).val() );
							});
						}

						var options 	=	{
												"id"		: self.options.id,
												"message"	: content
											};

						if( self.options.attachments )
						{
							options[ 'upload-id' ]	= files;
						}

						if( self.options.location )
						{
							options.address 	= self.options.locationController.locationInput().val();
							options.latitude	= self.options.locationController.locationLatitude().val();
							options.longitude	= self.options.locationController.locationLongitude().val();
						}

						options[ 'tags' ]	= self.composer().controller().editorArea().mentions( 'controller' ).toArray();

						// Disable submit button.
						self.replyButton().attr( 'disabled' , true );

						// Do an ajax call to submit the reply.
						EasySocial.ajax( 'site/controllers/conversations/reply' , options )
						.done(function( html )
						{
							self.replyNotice().html( $.language( 'COM_EASYSOCIAL_CONVERSATION_REPLY_POSTED_SUCCESSFULLY' ) ).addClass( 'alert alert-success' ).removeClass( 'alert-error' );

							// Apply controller on the appended item.
							var item 	= $( html );

							item.implement( EasySocial.Controller.Conversations.Read.Item );

							// Append the data back to the list.
							self.items().append( item );

							// Reset the composer form.
							self.resetForm();
						})
						.always(function()
						{
							// Re-activate button.
							self.replyButton().attr( 'disabled' , false );
						});


						return false;
					},

					"{leaveConversation} click" : function()
					{
						EasySocial.dialog({
							content : EasySocial.ajax( 'site/views/conversations/confirmLeave' , { id : self.options.id } )
						});
					},

					"{addParticipant} click" : function()
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'site/views/conversations/addParticipantsForm' , { "id" : self.options.id })
						});
					},

					"{delete} click" : function()
					{
						EasySocial.dialog(
						{
							content : EasySocial.ajax( 'site/views/conversations/confirmDelete' , { "ids" : [ self.options.id ] } ),
							bindings:
							{
								"{deleteButton} click" : function()
								{
									$( '[data-conversation-delete-form]' ).submit();
								}
							}
						});
					},

					/**
					 * Adds a new item into the reading list.
					 */
					addItem: function( obj ){
						// Append the message item into the list.
						self.messageList().append(
							self.view.messageItem({
								item: obj
							})
						);

						// Now we need to empty the message.
						self.textMessage().val( '' ).focus();
					}
				}
		});

		EasySocial.Controller(
			'Conversations.Read.Item',
			{
				defaultOptions :
				{
					id 	: null,

					"{attachmentsWrapper}" : "[data-conversation-attachment-wrapper]",
					"{attachments}"		: "[data-conversation-attachment]"
				}
			},
			function( self )
			{
				return {

					init : function()
					{
						// Get the message id.
						self.options.id 	= self.element.data( 'id' );

						// Implement attachment items.
						self.attachments().implement( EasySocial.Controller.Conversations.Read.Item.Attachment ,
							{
								"{parent}" : self
							});
					},

					removeAttachment : function( el , event )
					{
						// Remove the attachment item
						$( el ).remove();

						// Check to see if there are any more attachments.
						if( self.attachments().length == 0 )
						{
							self.attachmentsWrapper().hide();
						}
					}
				}
			});

		EasySocial.Controller(
			'Conversations.Read.Item.Attachment',
			{
				defaultOptions :
				{
					"{deleteAttachment}" 	: "[data-attachment-delete]"
				}
			},
			function( self )
			{
				return {
					init : function()
					{

					},

					"{deleteAttachment} click" : function( el , event )
					{
						var attachmentId 	= $( el ).data( 'id' );

						EasySocial.dialog(
						{
							content : EasySocial.ajax( 'site/views/conversations/confirmDeleteAttachment', { "id" : attachmentId } ),
							bindings :
							{
								"{deleteButton} click" : function()
								{
									EasySocial.ajax( 'site/controllers/conversations/deleteAttachment',
									{
										id 	: attachmentId
									})
									.done( function()
									{
										// Remove the attachment element.
										self.parent.removeAttachment( self.element );

										EasySocial.dialog(
										{
											content 	: EasySocial.ajax( 'site/views/conversations/attachmentDeleted' , {} )
										});
									})
									.fail( function( message )
									{
										self.setMessage( message );
									})
								}
							}
						});
					}
				}
			})
		module.resolve();
	});
});

EasySocial.module( 'site/dashboard/apps' , function($){

	var module 				= this;

	EasySocial.require()
	.library( 'history' )
	.done(function($){

		EasySocial.Controller(
			'Dashboard.Apps',
			{
				defaultOptions:
				{
					parent		: null,
					pageTitle	: null,
					"{item}"	: "[data-dashboardApps-item]"
				}
			},
			function(self){

				return{

					init : function()
					{
						self.item().implement( EasySocial.Controller.Dashboard.Apps.Item ,
						{
							"{parent}"		: self,
							"{dashboard}"	: self.parent,
							pageTitle 		: self.options.pageTitle
						});
					}
				}
			});

		EasySocial.Controller(
			'Dashboard.Apps.Item',
			{
				defaultOptions:
				{
				}
			}, function(self){

				return{

					init : function()
					{
					},

					"{self} click" : function( el , event )
					{
						// Prevent from bubbling up.
						event.preventDefault();

						// Get the layout meta.
						var layout 	= self.element.data( 'layout' ),
							url 	= self.element.data( layout + '-url' ),
							title 	= self.element.data( 'title' ),
							desc 	= self.element.data( 'description' ),
							appId 	= self.element.data( 'id' );

						// If this is a canvas layout, redirect the user to the canvas view.
						if( layout == 'canvas' )
						{
							window.location 	= url;
							return;
						}

						title 	= $._.isEmpty( self.options.pageTitle ) ? title : self.options.pageTitle;

						// If this is an embedded layout, we need to play around with the push state.
						History.pushState( {state:1} , title , url );

						// Notify the dashboard that it's starting to fetch the contents.
						self.dashboard.content().html("");
						self.dashboard.updatingContents();

						self.element.addClass( 'loading' );

						// Send a request to the dashboard to update the content from the specific app.
						EasySocial.ajax( 'site/controllers/dashboard/getAppContents' ,
						{
							"appId"		: appId
						})
						.done( function( contents )
						{
							self.dashboard.updateHeading( title , desc );

							self.dashboard.updateContents( contents );

						})
						.fail(function( messageObj ){

							return messageObj;

						})
						.always(function(){

							self.element.removeClass( 'loading' );

						});

					}


				}
			});
		module.resolve();
	});

});

EasySocial.module( 'site/dashboard/dashboard' , function($){

	var module = this;

	EasySocial.require()
	.script('site/dashboard/apps', 'site/dashboard/feeds', 'site/dashboard/sidebar', 'site/stream/filter', 'site/dashboard/groups', 'site/dashboard/events')
	.done(function($){

		EasySocial.Controller('Dashboard', {
			defaultOptions:
			{
				currentTitle 	: null,
				pageTitle 		: null,

				"{heading}"			: "[data-dashboard-heading]",
				"{sidebar}"			: "[data-dashboard-sidebar]",
				"{content}"			: "[data-dashboard-real-content]",

				// Feeds.
				"{feeds}"			: "[data-dashboard-feeds]",
				"{groups}"			: "[data-dashboard-groups]",
				"{events}": "[data-dashboard-events]",
				"{groupItems}"		: "[data-dashboard-group-item]",
				"{eventItems}"		: "[data-dashboard-event-item]",
				"{showAllFilters}"	: "[data-app-filters-showall]",
				"{showAllGroups}"	: "[data-groups-filters-showall]",
				"{showAllEvents}"	: "[data-events-filters-showall]",
				"{appFilters}"		: "[data-sidebar-app-filter]",

				// Applications.
				"{apps}"			: "[data-dashboard-apps]",

				// hashtag filter save
				"{saveHashTag}"		: "[data-hashtag-filter-save]"
			}
		}, function(self) {
			return{

				init: function()
				{
					// Implement sidebar controller.
					self.sidebar().implement(EasySocial.Controller.Dashboard.Sidebar, {
						"{parent}"	: self
					});

					// Implement app controller on all app items.
					self.feedsController = self.feeds().addController(EasySocial.Controller.Dashboard.Feeds, {
						"{parent}"	: self
					});

					// Implement app controller on all app items.
					self.apps().implement(EasySocial.Controller.Dashboard.Apps, {
						"{parent}"	: self,
						pageTitle	: self.options.pageTitle
					});

					// Implement groups navigation on dashboard
					self.groups().implement( EasySocial.Controller.Dashboard.Groups, {
						"{parent}"	: self
					});

					// Implement groups navigation on dashboard
					self.events().implement(EasySocial.Controller.Dashboard.Events, {
						"{parent}"	: self
					});
				},

				"{showAllGroups} click": function(el, event) {
					$(el).hide();

					self.groupItems().removeClass('hide');
				},

				"{showAllEvents} click": function(el, event) {
					$(el).hide();

					self.eventItems().removeClass('hide');
				},

				"{showAllFilters} click" : function( el , event )
				{
					$(el).hide();

					self.appFilters().removeClass( 'hide' );
				},

				/**
				 * Responsible to update the heading area in the dashboard.
				 */
				updateHeading: function( title , description )
				{
					self.heading().find( '[data-heading-title]' ).html( title );
					self.heading().find( '[data-heading-desc]' ).html( description );
				},

				/**
				 * Add a loading icon on the content layer.
				 */
				updatingContents: function()
				{
					self.element.addClass("loading");
				},

				/**
				 * Responsible to update the content area in the dashboard.
				 */
				updateContents : function( contents )
				{
					self.element.removeClass("loading");

					// Hide the content first.
					$.buildHTML( contents ).appendTo( self.content() );
				},



				"{saveHashTag} click": function( el )
				{
					var hashtag = el.data('tag');

					EasySocial.dialog({
						content		: EasySocial.ajax( 'site/views/stream/confirmSaveFilter', { "tag": hashtag } ),
						bindings	:
						{
							"{saveButton} click" : function()
							{
								this.inputWarning().hide();

								filterName = this.inputTitle().val();

								if( filterName == '' )
								{
									this.inputWarning().show();
									return;
								}

								EasySocial.ajax( 'site/controllers/stream/addFilter',
								{
									"title"		: filterName,
									"tag"		: hashtag,
								})
								.done(function( html, msg )
								{
									// self.feeds().append( html );

									var item = $.buildHTML( html );
									self.feedsController.addFilterItem( item );

									// show message
									EasySocial.dialog( msg );

									// auto close the dialog
									setTimeout(function() {
										EasySocial.dialog().close();
									}, 2000);

								});
							}
						}
					});
				}


			}
		});

		module.resolve();
	});

});

EasySocial.module('site/dashboard/feeds', function($){

	var module 				= this;

	EasySocial.require()
	.library( 'history' )
	.done(function($){

		EasySocial.Controller(
			'Dashboard.Feeds',
			{
				defaultOptions:
				{
					"{item}"	: "[data-dashboardFeeds-item]",
					"{filter}"	: "[data-dashboardFeeds-Filter-edit]"
				}
			},
			function(self){

				return{

					init : function()
					{
						// Implement each feed links.
						self.item().implement(EasySocial.Controller.Dashboard.Feeds.Item, {
							"{parent}"		: self,
							"{dashboard}"	: self.parent
						});
					},

					addFilterItem: function(feed)
					{
						feed.find('[data-dashboardFeeds-item]').implement(EasySocial.Controller.Dashboard.Feeds.Item, {
							"{parent}"		: self,
							"{dashboard}"	: self.parent
						});

						feed.appendTo(self.element);
					}
				}
			});

		EasySocial.Controller('Dashboard.Feeds.Item', {
			defaultOptions:
			{
			}
		}, function(self) {
			return{

				clicked: false,

				init : function()
				{
				},

				"{self} click" : function()
				{
					//remove no-stream class if any
					$('.es-streams').removeClass( 'no-stream' );

					var type = self.element.data( 'type' ),
						id = self.element.data( 'id' ),
						url = self.element.data( 'url' ),
						title = self.element.data( 'title' ),
						desc = self.element.data( 'description' );

					if (self.clicked) {
						return;
					}

					self.clicked	= true;

					// clear the new feed notification counter.
					var key = '[data-stream-counter-';
					
					if (type == 'list') {
						key = key + type + '-' + id;
					} else {
						key = key + type;
					}

					key = key + ']';
					
					$(key).html( '0' );

					// clear new feed counter
					self.element.removeClass('has-notice');

					// If this is an embedded layout, we need to play around with the push state.
					History.pushState( {state:1} , title , url );

					// Notify the dashboard that it's starting to fetch the contents.
					self.dashboard.content().html("");
					self.dashboard.updatingContents();

					self.element.addClass('loading');

					EasySocial.ajax( 'site/controllers/dashboard/getStream', {
						"type"	: type,
						"id"	: id,
						"view"  : 'dashboard',
					})
					.done(function(contents, count) {
						
						self.dashboard.updateHeading(title, desc);

						if (count == 0) {
							$('.es-streams').addClass( 'no-stream' );
						}

						// Trigger change for the stream
						self.trigger('onStreamUpdate', [type]);

						window.streamFilter = type;

						self.dashboard.updateContents(contents);

						// add support to kunena [tex] replacement.
						try { MathJax && MathJax.Hub.Queue(["Typeset",MathJax.Hub]); } catch( err ) {};

					}).fail(function(messageObj) {
						return messageObj;
					}).always(function() {
						self.clicked	= false;
						self.element.removeClass('loading');
					});


				}
			}
		});
		module.resolve();
	});

});

EasySocial.module( 'site/dashboard/sidebar' , function($){

	var module 				= this;

	EasySocial.require()
	.library( 'history' )
	.done(function($){

		EasySocial.Controller('Dashboard.Sidebar', {
			
			defaultOptions: {
				"{menuItem}"	: "[data-dashboardSidebar-menu]",
				"{filterBtn}"	: "[data-stream-filter-button]",
				"{editIcon}" 	: "[data-dashboardFeeds-Filter-edit]"
			}
		}, function(self) {

			return{

				init: function()
				{
				},
				
				"{menuItem} click" : function( el , event )
				{
					// Remove all active class.
					self.menuItem().removeClass( 'active' );

					// Add active class on this item.
					$( el ).addClass( 'active' );
				},

				"{editIcon} click" : function( el , event )
				{
					event.preventDefault();

					$(el).route();
					
					var id = el.data( 'id' );

					// Notify the dashboard that it's starting to fetch the contents.
					self.parent.content().html("");
					self.parent.updatingContents();

					EasySocial.ajax('site/controllers/stream/getFilter', {
						"id": id
					}).done(function(contents) {
						self.parent.updateContents(contents);
					}).fail(function(messageObj) {
						return messageObj;
					});
				},

				"{filterBtn} click" : function( el , event )
				{
					event.preventDefault();

					// Update the url
					$( el ).route();

					// Notify the dashboard that it's starting to fetch the contents.
					self.parent.content().html("");
					self.parent.updatingContents();

					EasySocial.ajax( 'site/controllers/stream/getFilter' ,
					{
						"id"	: 0
					})
					.done(function( contents )
					{
						// self.dashboard.updateHeading( title , desc );

						self.parent.updateContents( contents );
					})
					.fail( function( messageObj ){

						return messageObj;
					})
					.always(function(){

					});

				}
			}
		});

		module.resolve();
	});

});

EasySocial.module( 'site/stream/filter' , function($){

	var module 				= this;

	EasySocial.require()
	.script( 'site/stream/sidebar' )
	.language(
		'COM_EASYSOCIAL_STREAM_FILTER_WARNING_TITLE_EMPTY',
		'COM_EASYSOCIAL_STREAM_FILTER_WARNING_HASHTAG_EMPTY'
	)
	.done(function($){

		EasySocial.Controller(
			'Stream.Filter',
			{
				defaultOptions:
				{
					"{heading}"			: "[data-filter-heading]",
					"{sidebar}"			: "[data-sidebar-item]",
					"{content}"			: "[data-filter-real-content]"

				}
			},
			function(self){

				return{

					init: function()
					{
						// Implement sidebar controller.
						self.sidebar().implement(EasySocial.Controller.Stream.Filter.Sidebar, {
							"{parent}"	: self
						});

					},

					/**
					 * Responsible to update the heading area in the dashboard.
					 */
					updateHeading: function( title , description )
					{
						self.heading().find( '[data-heading-title]' ).html( title );
						self.heading().find( '[data-heading-desc]' ).html( description );
					},

					/**
					 * Add a loading icon on the content layer.
					 */
					updatingContents: function()
					{
						self.element.addClass("loading");
					},

					/**
					 * Responsible to update the content area in the dashboard.
					 */
					updateContents : function( contents )
					{
						self.element.removeClass("loading");

						// Hide the content first.
						self.content().html( contents );
					}
				}
			});

		EasySocial.Controller(
			'Stream.Filter.Item',
			{
				defaultOptions:
				{
					"{title}"	: "[data-filter-name]",
					"{hashtag}"	: "[data-filter-hashtag]",
					"{saveBtn}"	: "[data-stream-filter-save]",
					"{deleteBtn}"	: "[data-stream-filter-delete]",
					"{form}"	: "[data-filter-inputForm]",

					"{notice}"	: "[filter-form-notice]"
				}
			}, function(self) {

				return{
					init: function()
					{
					},

					"{deleteBtn} click" : function( el )
					{
						var fid = el.data('id');
						var uid = el.data('uid');
						var utype = el.data('utype');

						var controllerPath = 'site/controllers/stream/deleteFilter';

						if( uid )
						{
							var controllerPath = 'site/controllers/' + utype + 's/deleteFilter';
						}

						EasySocial.dialog({
							content		: EasySocial.ajax( 'site/views/stream/confirmFilterDelete' ),
							bindings	:
							{
								"{deleteButton} click" : function()
								{
									EasySocial.ajax( controllerPath,
									{
										"id"		: fid,
										"uid" 		: uid,
										"utype"		: utype
									})
									.done(function( html )
									{
										self.element.fadeOut();

										// close dialog box.
										EasySocial.dialog().close();
									});
								}
							}
						});
					},

					"{saveBtn} click" : function()
					{

						$('div.control-group').removeClass( 'error' );
						self.notice().html();
						self.notice().hide();

						if( self.title().val() == '' )
						{
							self.title().parents('div.control-group').addClass( 'error' );

							self.notice().html( $.language( 'COM_EASYSOCIAL_STREAM_FILTER_WARNING_TITLE_EMPTY' ) );
							self.notice().show();

							return false;
						}

						if( self.hashtag().val() == '' )
						{
							self.hashtag().parents('div.control-group').addClass( 'error' );

							self.notice().html( $.language( 'COM_EASYSOCIAL_STREAM_FILTER_WARNING_HASHTAG_EMPTY' ) );
							self.notice().show();

							return false;
						}

						self.form().submit();
					}


				}

			});

		module.resolve();
	});

});

EasySocial.module('site/stream/sidebar', function($) {

	var module = this;

	EasySocial.require()
	.done(function($){

		EasySocial.Controller('Stream.Filter.Sidebar', {
			defaultOptions: {
			}
		}, function(self) {

			return{

				init: function()
				{
				},
				"{self} click" : function()
				{
					$('[data-sidebar-item]').removeClass('active loading');
					self.element.addClass('active');

					var id = self.element.data('id'),
						url = self.element.data('url'),
						title = self.element.data('title');

					// If this is an embedded layout, we need to play around with the push state.
					History.pushState({state:1} , title , url);

					// Notify the dashboard that it's starting to fetch the contents.
					self.parent.content().html("");
					self.parent.updatingContents();

					self.element.addClass('loading');

					EasySocial.ajax('site/controllers/stream/getFilter', {
						"id": id
					})
					.done(function(contents) {
						self.parent.updateContents(contents);
					})
					.fail(function(messageObj) {
						return messageObj;
					})
					.always(function(){
						self.element.removeClass('loading');
					});
				}
			}
		});

		module.resolve();
	});

});

EasySocial.module( 'site/dashboard/groups' , function($){

	var module 				= this;

	EasySocial.require()
	.library( 'history' )
	.done(function($){

		EasySocial.Controller(
			'Dashboard.Groups',
			{
				defaultOptions:
				{
					"{item}"	: "[data-dashboard-group-item]",
					"{itemLink}": "[data-dashboard-group-item] > a"
				}
			},
			function(self)
			{

				return{

					init : function()
					{
						// console.log( 'here' , self.item() );
					},

					/**
					 * Fires when a feed link is clicked.
					 */
					"{item} click" : function( el , event )
					{
						event.preventDefault();

						$('.es-streams').removeClass( 'no-stream' );

						var type 	= $( el ).data( 'type' ),
							id		= $( el ).data( 'id' ),
							desc 	= $( el ).data( 'description' );

						// clear new feed counter
						self.element.removeClass( 'has-notice' );

						// If this is an embedded layout, we need to play around with the push state.
						$( el ).find( 'a' ).route();

						// Notify the dashboard that it's starting to fetch the contents.
						self.parent.content().html("");
						self.parent.updatingContents();

						self.element.addClass( 'loading' );

						EasySocial.ajax( 'site/controllers/dashboard/getStream' ,
						{
							"type"	: type,
							"id"	: id,
							"view" 	: "dashboard"
						})
						.done(function( contents )
						{
							self.parent.updateContents( contents );
						});
					}
				}
			});
		module.resolve();
	});

});

EasySocial.module('site/dashboard/events', function($){

	var module 				= this;

	EasySocial.require()
	.library('history')
	.done(function($){

		EasySocial.Controller(
			'Dashboard.Events',
			{
				defaultOptions:
				{
					"{item}"	: "[data-dashboard-event-item]",
					"{itemLink}": "[data-dashboard-event-item] > a"
				}
			},
			function(self)
			{

				return{

					init : function()
					{
					},

					/**
					 * Fires when a feed link is clicked.
					 */
					"{item} click" : function(el, event)
					{
						event.preventDefault();

						$('.es-streams').removeClass('no-stream');

						var type 	= $(el).data('type'),
							id		= $(el).data('id'),
							desc 	= $(el).data('description');

						// clear new feed counter
						self.element.removeClass('has-notice');

						// If this is an embedded layout, we need to play around with the push state.
						$( el ).find('a').route();

						// Notify the dashboard that it's starting to fetch the contents.
						self.parent.content().html("");
						self.parent.updatingContents();

						self.element.addClass('loading');

						EasySocial.ajax('site/controllers/dashboard/getStream',
						{
							"type"	: type,
							"id"	: id,
							"view" 	: "dashboard"
						})
						.done(function(contents) {
							self.parent.updateContents(contents);
						});
					}
				}
			});
		module.resolve();
	});

});

EasySocial.module('site/events/browser', function($) {
    var module = this;

    EasySocial
    .require()
    .library('popbox')
    .script('site/events/guestState')
    .language('COM_EASYSOCIAL_EVENTS_DETECTING_LOCATION')
    .view('site/loading/small')
    .done(function() {
        EasySocial.Controller('Events.Browser', {
            defaultOptions: {
                '{filters}': '[data-events-filters] > li',
                '{content}': '[data-events-content]',
                '{list}': '[data-events-list]',

                '{items}': '[data-events-item]',

                '{sort}': '[data-events-sorting] a',
                '{calendar}': '[data-events-calendar]',

                '{pastFilter}': '[data-events-past]',
                '{pastLink}': '[data-events-past-link]',

                '{prevDate}': '[data-events-nav-prevdate]',

                '{nextDate}': '[data-events-nav-nextdate]',

                '{radius}': '[data-events-radius]',

                '{nearbyTitle}': '[data-events-nearby-title]',

                filter: null,
                categoryid: 0,

                delayed: false,

                includePast: false,
                ordering: 'start',

                hasLocation: false,
                userLatitude: '',
                userLongitude: '',

                distance: 10,

                group: null,

                view: {
                    loadingContent: 'site/loading/small'
                }
            }
        }, function(self) {
            return {
                init: function() {
                    self.options.filter = self.element.data('filter');
                    self.options.categoryid = self.element.data('categoryid');

                    // Render the calendar
                    self.renderCalendar();

                    self.initItems();

                    if (self.options.delayed) {
                        self.delayedInit();
                    }
                },

                delayedInit: function() {
                    // It is possible that view is flagging it as "delayed" in order for javascript to make an ajax call to retrieve the data instead

                    // delayed init will have some preset parameter coming from url, hence we don't use the filterbynearby method

                    if (self.options.filter === 'nearby') {
                        var getEvents = function() {
                            EasySocial.ajax('site/controllers/events/getEvents', {
                                filter: self.options.filter,
                                latitude: self.options.userLatitude,
                                longitude: self.options.userLongitude,
                                distance: self.options.distance,
                                ordering: self.options.ordering,
                                includePast: self.options.includePast
                            }).done(function(contents) {
                                self.element.removeClass('loading');

                                self.content().html(contents);

                                self.initItems();
                            });
                        }

                        if (self.options.hasLocation && self.options.userLatitude && self.options.userLongitude) {
                            return getEvents();
                        }

                        // If no location, then we need to resolve a location first

                        // Show the image of "detecting location"

                        EasySocial.require().library('gmaps').done(function() {
                            $.GMaps.geolocate({
                                success: function(position) {
                                    self.options.userLatitude = position.coords.latitude;

                                    self.options.userLongitude = position.coords.longitude;

                                    return getEvents();
                                }
                            });
                        });
                    }
                },

                renderCalendar: function() {
                    EasySocial.ajax('site/views/events/renderCalendar', {})
                        .done(function(html) {
                            self.calendar()
                                .html(html)
                                .addController('EasySocial.Controller.Events.Browser.Calendar', {
                                    '{parent}': self
                                });

                            self.calendar().trigger('calendarLoaded');
                        });
                },

                initItems: function() {
                    self.items().addController('EasySocial.Controller.Events.Browser.Item', {
                        '{parent}': self
                    });
                },

                '{filters} click': function(el, event) {
                    event.preventDefault();

                    self.filters().removeClass('active');

                    el.addClass('active');

                    self.content().html('&nbsp;');

                    // Update the url in the address bar
                    el.find('a').route();

                    self.options.filter = el.data('events-filters-type'),
                    self.options.categoryid = el.data('events-filters-categoryid');

                    // Nearby requires separate processing
                    if (self.options.filter == 'nearby') {
                        return self.filterByNearby();
                    }

                    // Add loading class on container
                    self.element.addClass('loading');

                    EasySocial.ajax('site/controllers/events/getEvents', {
                        filter: self.options.filter,
                        categoryid: self.options.categoryid
                    }).done(function(contents) {

                        // Remove the loading from the container
                        self.element.removeClass('loading');

                        self.content().html(contents);

                        self.initItems();
                    });
                },

                filterByNearby: function() {
                    var getEvents = function() {
                        EasySocial.ajax('site/controllers/events/getEvents', {
                            filter: self.options.filter,
                            latitude: self.options.userLatitude,
                            longitude: self.options.userLongitude
                        }).done(function(contents) {
                            self.element.removeClass('loading');

                            self.content().html(contents);

                            self.initItems();
                        });
                    }

                    if (self.options.hasLocation && self.options.userLatitude && self.options.userLongitude) {
                        self.element.addClass('loading');

                        return getEvents();
                    }

                    // If no location, then we need to resolve a location first

                    // Show a detecting location
                    self.content().html('<div class="es-detecting-location"><i class="ies-earth es-muted"></i> ' + $.language('COM_EASYSOCIAL_EVENTS_DETECTING_LOCATION') + ' <i class="icon-loader"></i></div>');

                    // Show the image of "detecting location"

                    EasySocial.require().library('gmaps').done(function() {
                        $.GMaps.geolocate({
                            success: function(position) {
                                self.options.userLatitude = position.coords.latitude;

                                self.options.userLongitude = position.coords.longitude;

                                self.options.hasLocation = true;

                                return getEvents();
                            }
                        });
                    });
                },

                '{sort} click': function(el, event) {
                    event.preventDefault();

                    self.sort().removeClass('active');

                    el.addClass('active');

                    // self.element.addClass('loading');

                    self.list().html(self.view.loadingContent());

                    var ordering = el.data('ordering'),
                        filter = el.data('filter'),
                        categoryid = el.data('categoryid'),
                        includePast = self.pastFilter().is(':checked') ? 1 : 0;

                    self.setPastLink();

                    self.setSortLink();

                    el.route();

                    if (filter === 'nearby') {
                        EasySocial.ajax('site/controllers/events/getEvents', {
                            filter: self.options.filter,
                            latitude: self.options.userLatitude,
                            longitude: self.options.userLongitude,
                            distance: self.options.distance,
                            ordering: ordering,
                            sort: 1,
                            includePast: includePast
                        }).done(function(contents) {
                            self.list().html(contents);

                            self.initItems();
                        });

                        return;
                    }

                    EasySocial.ajax('site/controllers/events/getEvents', {
                        filter: filter,
                        categoryid: categoryid,
                        ordering: ordering,
                        sort: 1,
                        includePast: includePast,
                        group: self.options.group
                    }).done(function(contents) {
                        self.list().html(contents);

                        self.initItems();
                    });
                },

                '{pastFilter} change': function(el) {
                    var activeSort = self.sort('.active'),
                        includePast = el.is(':checked') ? 1 : 0,
                        ordering = activeSort.data('ordering'),
                        filter = activeSort.data('filter'),
                        categoryid = activeSort.data('categoryid');

                    self.list().html(self.view.loadingContent());

                    self.pastLink().route();

                    self.setPastLink();

                    self.setSortLink();

                    if (filter === 'nearby') {
                        EasySocial.ajax('site/controllers/events/getEvents', {
                            filter: self.options.filter,
                            latitude: self.options.userLatitude,
                            longitude: self.options.userLongitude,
                            distance: self.options.distance,
                            ordering: ordering,
                            sort: 1,
                            includePast: includePast
                        }).done(function(contents) {
                            self.list().html(contents);

                            self.initItems();
                        });

                        return;
                    }

                    EasySocial.ajax('site/controllers/events/getEvents', {
                        filter: filter,
                        categoryid: categoryid,
                        ordering: ordering,
                        sort: 1,
                        includePast: includePast,
                        group: self.options.group
                    }).done(function(contents) {
                        self.list().html(contents);

                        self.initItems();
                    });
                },

                '{pastLink} click': function(el, ev) {
                    ev.preventDefault();

                    self.pastFilter().trigger('click');
                },

                setPastLink: function() {
                    var pastLink = self.pastLink(),
                        includePast = self.pastFilter().is(':checked') ? 1 : 0,
                        ordering = self.sort('.active').data('ordering');

                    var link = pastLink.data(ordering + '-' + (includePast ? 'nopast' : 'past'));

                    pastLink.attr('href', link);
                },

                setSortLink: function() {
                    var includePast = self.pastFilter().is(':checked') ? 1 : 0;

                    $.each(self.sort(), function(i, el) {
                        var el = $(el);
                        el.attr('href', self.pastLink().data(el.data('ordering') + '-' + (includePast ? 'past' : 'nopast')));
                    });
                },

                '{prevDate} click': function(el, ev) {
                    ev.preventDefault();

                    el.route();

                    self.filters().removeClass('active');

                    self.element.addClass('loading');

                    self.content().html('&nbsp;');

                    EasySocial.ajax('site/controllers/events/getEvents', {
                        filter: 'date',
                        date: el.data('events-nav-prevdate')
                    }).done(function(contents, options) {

                        // Remove the loading from the container
                        self.element.removeClass('loading');

                        self.content().html(contents);

                        self.initItems();

                        if (options.isToday) {
                            self.filters().removeClass('active');

                            self.filters('[data-events-filters-type="date"]').addClass('active');
                        }

                        if (options.isTomorrow) {
                            self.filters().removeClass('active');

                            self.filters('[data-events-filters-type="tomorrow"]').addClass('active');
                        }

                        if (options.isCurrentMonth) {
                            self.filters().removeClass('active');

                            self.filters('[data-events-filters-type="month"]').addClass('active');
                        }

                        if (options.isCurrentYear) {
                            self.filters().removeClass('active');

                            self.filters('[data-events-filters-type="year"]').addClass('active');
                        }
                    });
                },

                '{nextDate} click': function(el, ev) {
                    ev.preventDefault();

                    el.route();

                    self.filters().removeClass('active');

                    self.element.addClass('loading');

                    self.content().html('&nbsp;');

                    EasySocial.ajax('site/controllers/events/getEvents', {
                        filter: 'date',
                        date: el.data('events-nav-nextdate')
                    }).done(function(contents, options) {

                        // Remove the loading from the container
                        self.element.removeClass('loading');

                        self.content().html(contents);

                        self.initItems();

                        if (options.isToday) {
                            self.filters().removeClass('active');

                            self.filters('[data-events-filters-type="date"]').addClass('active');
                        }

                        if (options.isTomorrow) {
                            self.filters().removeClass('active');

                            self.filters('[data-events-filters-type="tomorrow"]').addClass('active');
                        }

                        if (options.isCurrentMonth) {
                            self.filters().removeClass('active');

                            self.filters('[data-events-filters-type="month"]').addClass('active');
                        }

                        if (options.isCurrentYear) {
                            self.filters().removeClass('active');

                            self.filters('[data-events-filters-type="year"]').addClass('active');
                        }
                    });
                },

                '{radius} change': function(el, ev) {
                    var activeSort = self.sort('.active'),
                        includePast = self.pastFilter().is(':checked') ? 1 : 0,
                        ordering = activeSort.data('ordering'),
                        filter = activeSort.data('filter'),
                        categoryid = activeSort.data('categoryid'),
                        distance = el.val();

                    self.options.distance = distance;

                    self.list().html(self.view.loadingContent());

                    // self.pastLink().route();

                    // self.setPastLink();

                    // self.setSortLink();

                    EasySocial.ajax('site/controllers/events/getEvents', {
                        filter: 'nearby',
                        latitude: self.options.userLatitude,
                        longitude: self.options.userLongitude,
                        distance: self.options.distance,
                        ordering: ordering,
                        includePast: includePast,
                        sort: 1
                    }).done(function(contents, options) {
                        self.list().html(contents);

                        self.initItems();

                        History.pushState({state:1}, document.title, options.hrefs[ordering][includePast ? 'past' : 'nopast']);

                        self.pastLink().attr('href', options.hrefs[ordering][includePast ? 'nopast' : 'past']);

                        $.each(self.sort(), function(i, el) {
                            var el = $(el);
                            el.attr('href', options.hrefs[el.data('ordering')][includePast ? 'past' : 'nopast']);

                            self.pastLink().attr('data-' + el.data('ordering') + '-past', options.hrefs[el.data('ordering')]['past']);
                            self.pastLink().attr('data-' + el.data('ordering') + '-nopast', options.hrefs[el.data('ordering')]['nopast']);
                        });

                        self.nearbyTitle().text(options.title);
                    });
                }
            }
        });

        EasySocial.Controller('Events.Browser.Item', {
            defaultOptions: {
                id: null,

                '{action}': '[data-item-action]',

                '{unfeature}': '[data-item-unfeature]',
                '{feature}': '[data-item-feature]',
                '{unpublish}': '[data-item-unpublish]',
                '{delete}': '[data-item-delete]',

                '{guestStateWrap}': '[data-guest-state-wrap]'
            }
        }, function(self) {
            return {
                init: function() {
                    self.options.id = self.element.data('id');

                    self.initGuestStates();
                },

                initGuestStates: function() {
                    self.guestStateWrap().addController('EasySocial.Controller.Events.GuestState');
                },

                '{action} click': function(el) {
                    EasySocial.dialog({
                        content: EasySocial.ajax('site/views/events/itemActionDialog', {
                            id: self.options.id,
                            action: el.data('item-action'),
                            from: 'list'
                        })
                    });
                },

                '{delete} click': function() {
                    EasySocial.dialog({
                        content: EasySocial.ajax('site/views/events/deleteEventDialog', {
                            id: self.options.id
                        })
                    });
                }
            }
        });

        EasySocial.Controller('Events.Browser.Calendar', {
            defaultOptions: {
                '{nav}': '[data-calendar-nav]',

                '{day}': '.day',

                '{month}': '[data-month]',

                view: {
                    loading: 'site/loading/small'
                }
            }
        }, function(self) {
            return {
                init: function() {

                },

                '{self} calendarLoaded': function() {
                    self.day('.has-events').each(function(index, el) {
                        el = $(el);

                        var content = el.find('.event-details').html();

                        el.popbox({
                            content: content,
                            id: 'fd',
                            component: 'es',
                            type: 'events-calendar-filter',
                            position: 'bottom-left',
                            toggle: 'hover'
                        });
                    });

                    var month = self.month('.has-events');

                    if (month.length > 0) {
                        var content = month.find('.event-details').html();
                        month.popbox({
                            content: content,
                            id: 'fd',
                            component: 'es',
                            type: 'events-calendar-filter',
                            position: 'bottom-left',
                            toggle: 'hover'
                        });
                    }
                },

                '{nav} click': function(el, ev) {
                    var date = el.data('calendar-nav');

                    self.element.html(self.view.loading());

                    EasySocial.ajax('site/views/events/renderCalendar', {
                        date: date
                    }).done(function(html) {
                        self.element
                            .html(html)
                            .trigger('calendarLoaded');
                    });
                },

                '{day} click': function(el, ev) {
                    ev.preventDefault();

                    // Update the url in the address bar
                    el.find('a[data-route]:first').route();

                    self.loadEvents(el.data('date'));
                },

                '{day} popboxActivate': function(el, ev, popbox) {
                    popbox.tooltip.find('a[data-route]').on('click', function(event) {
                        event.preventDefault();

                        $(this).route();

                        self.loadEvents($(this).data('date'));
                    });
                },

                '{month} click': function(el, ev) {
                    ev.preventDefault();

                    // Update the url in the address bar
                    el.find('a[data-route]:first').route();

                    self.loadEvents(el.data('month'));
                },

                '{month} popboxActivate': function(el, ev, popbox) {
                    popbox.tooltip.find('a[data-route]').on('click', function(event) {
                        event.preventDefault();

                        $(this).route();

                        self.loadEvents($(this).data('month'));
                    });
                },

                loadEvents: function(date) {
                    self.parent.filters().removeClass('active');

                    // Add loading class on container
                    self.parent.element.addClass('loading');
                    self.parent.content().html('&nbsp;');

                    EasySocial.ajax('site/controllers/events/getEvents', {
                        filter: 'date',
                        date: date
                    }).done(function(contents, options) {

                        // Remove the loading from the container
                        self.parent.element.removeClass('loading');

                        self.parent.content().html(contents);

                        self.parent.initItems();

                        if (options.isToday) {
                            self.parent.filters().removeClass('active');

                            self.parent.filters('[data-events-filters-type="date"]').addClass('active');
                        }

                        if (options.isTomorrow) {
                            self.parent.filters().removeClass('active');

                            self.parent.filters('[data-events-filters-type="tomorrow"]').addClass('active');
                        }

                        if (options.isCurrentMonth) {
                            self.parent.filters().removeClass('active');

                            self.parent.filters('[data-events-filters-type="month"]').addClass('active');
                        }

                        if (options.isCurrentYear) {
                            self.parent.filters().removeClass('active');

                            self.parent.filters('[data-events-filters-type="year"]').addClass('active');
                        }
                    });
                }
            }
        });

        module.resolve();
    });
});

EasySocial.module('site/events/guestState', function($) {
    var module = this;

    EasySocial
    .require()
    .language('COM_EASYSOCIAL_EVENTS_GUEST_PENDING')
    .done(function($) {

        EasySocial.Controller('Events.GuestState', {
            defaultOptions: {
                id: null,

                allowMaybe: 1,

                allowNotGoingGuest: 1,

                hidetext: 1,

                refresh: false,

                '{guestAction}': '[data-guest-action]',

                '{guestState}': '[data-guest-state]',

                '{request}': '[data-guest-request]',

                '{withdraw}': '[data-guest-withdraw]',

                '{respond}': '[data-guest-respond]'
            }
        }, function(self) {
            return {
                init: function() {
                    self.options.id = self.element.data('id');

                    self.options.allowMaybe = self.element.data('allowmaybe');
                    self.options.allowNotGoingGuest = self.element.data('allownotgoingguest');
                    self.options.hidetext = self.element.data('hidetext');

                    // Determines if the page requires a refresh
                    // If this is a item page, then the element will have a data-refresh flag
                    // If this is a listing page, then no refresh is required
                    self.options.refresh = self.element.is('[data-refresh]');

                    // self.initPopbox();
                },

                showError: function(msg) {
                    EasySocial.dialog({
                        content: msg
                    });
                },

                stateClasses: {
                    'going': 'btn-es-success',
                    'maybe': 'btn-es-info',
                    'notgoing': 'btn-es-danger'
                },

                '{guestAction} click': function(el) {
                    // Depending on the action

                    var action = el.data('guestAction');

                    if (action === 'state') {
                        var state = el.data('guestState');

                        self.guestAction().removeClass('btn-es-success btn-es-info btn-es-danger');

                        el.addClass(self.stateClasses[state]);

                        if (state === 'notgoing' && !self.options.allowNotGoingGuest) {
                            EasySocial.dialog({
                                content: EasySocial.ajax('site/views/events/notGoingDialog', {
                                    id: self.options.id
                                }),
                                bindings: {
                                    '{closeButton} click': function() {
                                        EasySocial.ajax('site/views/events/refreshGuestState', {
                                            id: self.options.id,
                                            hidetext: self.options.hidetext
                                        }).done(function(html) {
                                            self.element.html(html);

                                            EasySocial.dialog().close();
                                        });
                                    },
                                    '{submitButton} click': function() {
                                        self.response('notgoing')
                                            .done(function() {
                                                if (self.options.refresh) {
                                                    return location.reload();
                                                }

                                                EasySocial.ajax('site/views/events/refreshGuestState', {
                                                    id: self.options.id,
                                                    hidetext: self.options.hidetext
                                                }).done(function(html) {
                                                    self.element.html(html);

                                                    EasySocial.dialog().close();
                                                });
                                            });
                                    }
                                }
                            });
                        } else {
                            self.response(state)
                                .done(function() {
                                    if (self.options.refresh) {
                                        return location.reload();
                                    }
                                })
                                .fail(function(msg) {
                                    el.removeClass(self.stateClasses[action]);

                                    self.showError(msg);
                                });
                        }
                    }

                    if (action === 'request') {
                        EasySocial.dialog({
                            content: EasySocial.ajax('site/views/events/requestDialog', {
                                id: self.options.id
                            }),
                            bindings: {
                                '{submitButton} click': function() {
                                    el
                                        .attr('data-guest-action', 'withdraw')
                                        .data('guestAction', 'withdraw')
                                        .removeAttr('data-guest-request')
                                        .attr('data-guest-withdraw', '')
                                        .text($.language('COM_EASYSOCIAL_EVENTS_GUEST_PENDING'));

                                    self.response(action);

                                    EasySocial.dialog().close();
                                }
                            }
                        });
                    }

                    if (action === 'withdraw') {
                        EasySocial.dialog({
                            content: EasySocial.ajax('site/views/events/withdrawDialog', {
                                id: self.options.id
                            }),
                            bindings: {
                                '{submitButton} click': function() {
                                    self.response('withdraw')
                                        .done(function() {
                                            EasySocial.ajax('site/views/events/refreshGuestState', {
                                                id: self.options.id,
                                                hidetext: self.options.hidetext
                                            }).done(function(html) {
                                                self.element.html(html);

                                                EasySocial.dialog().close();
                                            });
                                        });
                                }
                            }
                        });
                    }

                    if (action === 'attend') {
                        self.response('going').done(function() {
                            EasySocial.ajax('site/views/events/refreshGuestState', {
                                id: self.options.id,
                                hidetext: self.options.hidetext
                            }).done(function(html) {
                                if (self.options.refresh) {
                                    return location.reload();
                                }

                                if (html !== undefined) {
                                    self.element.html(html);

                                    EasySocial.dialog().close();
                                }
                            });
                        });
                    }
                },

                response: function(action) {
                    return EasySocial.ajax('site/controllers/events/guestResponse', {
                        id: self.options.id,
                        state: action
                    });
                }
            }
        });

        module.resolve();
    });
});

EasySocial.module('site/events/create', function($) {
    var module = this;

    EasySocial.require().script('validate', 'field').done(function() {
        EasySocial.Controller('Events.Create', {
            defaultOptions: {
                'previousLink': null,

                '{fields}': '[data-create-field]',

                '{previous}': '[data-create-previous]',

                '{next}': '[data-create-submit]'
            }
        }, function(self) {
            return {
                init: function() {
                    self.fields().addController('EasySocial.Controller.Field.Base');
                },

                '{previous} click': function() {
                    window.location = self.options.previousLink;
                },

                '{next} click': function(el) {
                    if (el.enabled()) {
                        el.disabled(true);

                        el.addClass('btn-loading');

                        self.element.validate()
                            .done(function() {
                                el.removeClass('btn-loading');
                                el.enabled(true);

                                self.element.submit();
                            })
                            .fail(function() {
                                el.removeClass('btn-loading');
                                el.enabled(true);

                                EasySocial.dialog({
                                    content: EasySocial.ajax('site/views/profile/showFormError')
                                });
                            });
                    }
                }
            }
        });

        module.resolve();
    });
});

EasySocial.module('site/events/createRecurring', function($) {
    var module = this;

    EasySocial.Controller('Events.CreateRecurring', {
        defaultOptions: {
            schedule: [],

            eventId: null,

            '{progress}': '[data-progress-bar]',

            '{form}': '[data-form]'
        }
    }, function(self) {
        return {
            init: function() {
                self.start();
            },

            counter: 0,

            start: function() {
                if (self.options.schedule[self.counter] === undefined) {
                    return self.completed();
                }

                self.create(self.options.schedule[self.counter])
                    .done(function() {
                        self.counter++;

                        var percentage = Math.ceil((self.counter / self.options.schedule.length) * 100);

                        self.progress().css({
                            width: percentage + '%'
                        });

                        self.start();
                    })
                    .fail(function(msg) {
                        console.log(msg);
                    });
            },

            create: function(datetime) {
                return EasySocial.ajax('site/controllers/events/createRecurring', {
                    eventId: self.options.eventId,
                    datetime: datetime
                });
            },

            completed: function() {
                self.progress().parent().removeClass('progress-info').addClass('progress-success');
                self.form().submit();
            }
        }
    })

    module.resolve();
});

EasySocial.module('site/events/edit', function($) {
    var module = this;

    EasySocial.require()
    .script('validate', 'field')
    .done(function() {
        EasySocial.Controller('Events.Edit', {
            defaultOptions: {
                id: null,

                isRecurring: 0,
                hasRecurring: 0,

                '{form}': '[data-form]',

                '{nav}': '[data-step-nav]',
                '{content}': '[data-step-content]',
                '{fields}': '[data-edit-field]',
                '{saveButton}': '[data-edit-save]',

                '{saveApply}': 'input[name="applyRecurring"]'
            }
        }, function(self) {
            return {
                init: function() {
                    self.fields().addController('EasySocial.Controller.Field.Base', {
                        mode: 'edit'
                    });
                },

                errorFields: [],

                '{nav} click': function(el, ev) {
                    var id = $(el).data('for');

                    self.content().hide();

                    self.nav().removeClass('active');

                    el.addClass('active');

                    self.content().filterBy('id', id)
                        .show()
                        .find(self.fields.selector).trigger('show');
                },

                '{nav} error': function(el) {
                    el.addClass('error');
                },

                '{nav} clear': function(el) {
                    if (self.errorFields.length < 1) {
                        el.removeClass('error');
                    }
                },

                '{fields} error': function(el, ev) {
                    self.triggerStepError(el);
                },

                '{fields} clear': function(el, ev) {
                    self.clearStepError(el);
                },

                '{fieldItem} onError': function(el, ev) {
                    self.triggerStepError(el);
                },

                triggerStepError: function(el) {
                    var fieldid = el.data('id'),
                        stepid = el.parents(self.content.selector).data('id');

                    if ($.inArray(fieldid, self.errorFields) < 0) {
                        self.errorFields.push(fieldid);
                    }

                    self.nav().filterBy('for', stepid).trigger('error');
                },

                clearStepError: function(el) {
                    var fieldid = el.data('id'),
                        stepid = el.parents(self.content.selector).data('id');

                    self.errorFields = $.without(self.errorFields, fieldid);

                    self.nav().filterBy('for', stepid).trigger('clear');
                },

                '{saveButton} click': function(el, ev) {
                    ev.preventDefault();

                    el.addClass('btn-loading');

                    self.form().validate()
                        .done(function() {
                            // Check if this buttons has a value for data-edit-save to indicate if recurring should save all
                            if (el.data('editSave') === 'all') {
                                self.saveApply().val(1);
                            }

                            self.form().submit();
                        })
                        .fail(function() {
                            el.removeClass('btn-loading');
                            EasySocial.dialog({
                                content: EasySocial.ajax('site/views/profile/showFormError')
                            });
                        });
                }
            }
        });

        module.resolve();
    });
});

EasySocial.module('site/events/item', function($) {
    var module = this;

    EasySocial.template('info/item', '<li data-sidebar-item><a class="ml-20" href="[%= url %]" title="[%= title %]" data-info-item data-info-index="[%= index %]"><i class="ies-info ies-small mr-5"></i> [%= title %]</a></li>');

    EasySocial
    .require()
    .script('site/friends/suggest', 'site/events/guestState')
    .view('site/loading/small')
    .library('history')
    .done(function($) {
        EasySocial.Controller('Events.Item', {
            defaultOptions: {
                id: null,

                '{filterStreamList}': '[data-filter-stream-list]',

                '{sidebarItem}': '[data-sidebar-item]',

                '{addFilter}': '[data-filter-add]',

                '{editFilter}': '[data-filter-edit]',

                '{filterStream}': '[data-filter-stream]',

                '{filterApp}': '[data-filter-app]',

                '{showAllFilters}': '[data-filter-showall]',

                '{apps}': '[data-app-item]',

                '{content}': '[data-content]',

                '{saveHashtag}': '[data-hashtag-filter-save]',

                '{invite}': '[data-action-invite]',

                '{unpublish}': '[data-action-unpublish]',

                '{delete}': '[data-action-delete]',

                '{guestStateWrap}': '[data-guest-state-wrap]',

                '{info}': '[data-info]',

                '{infoItem}': '[data-info-item]',

                "{menuItem}"    : "[data-dashboardSidebar-menu]",

                view: {
                    infoItem: 'info/item',
                    loading: 'site/loading/small'
                }
            }
        }, function(self) {
            return {
                init: function() {
                    self.initGuestStates();
                },

                initGuestStates: function() {
                    self.guestStateWrap().addController('EasySocial.Controller.Events.GuestState');
                },

                setActive: function(el) {
                    self.sidebarItem().removeClass('active');

                    el.parents(self.sidebarItem.selector).addClass('active');
                },

                setLoading: function(el) {
                    self.content().html('');

                    self.element.addClass('loading');
                },

                updateContents: function(html) {
                    self.element.removeClass('loading');

                    self.content().html(html);
                },

                '{showAllFilters} click': function(el, ev) {
                    el.hide();

                    self.sidebarItem().show();
                },

                '{editFilter} click': function(el, ev) {
                    ev.preventDefault();

                    el.route();

                    self.setLoading();

                    self.getFilter(el.data('id'));

                    self.setActive(el.parents('[data-sidebar-item]'));
                },

                '{addFilter} click': function(el, ev) {
                    ev.preventDefault();

                    el.route();

                    self.setActive(el);

                    self.setLoading();

                    self.getFilter(0);
                },

                getFilter: function(id) {
                    EasySocial.ajax('site/controllers/events/getFilter', {
                        filterId: id,
                        eventId: self.options.id
                    }).always(function(contents) {
                        self.updateContents(contents);
                    });
                },

                '{filterApp} click': function(el, ev) {
                    ev.preventDefault();

                    el.route();

                    self.setActive(el);

                    self.setLoading();

                    self.getStream(el.data('id'), 'apps');
                },

                '{filterStream} click': function(el, ev) {
                    ev.preventDefault();

                    el.route();

                    self.setActive(el);

                    self.setLoading();

                    self.getStream(el.data('id'), el.data('type'));
                },

                "{menuItem} click" : function( el , event )
                {
                    // Remove all active class.
                    self.menuItem().removeClass( 'active' );

                    // Add active class on this item.
                    $( el ).addClass( 'active' );
                },

                getStream: function(id, type) {
                    EasySocial.ajax('site/controllers/events/getStream', {
                        id: id,
                        type: type,
                        view: "events",
                        eventId: self.options.id
                    }).always(function(contents) {
                        self.updateContents(contents);
                    });
                },

                '{saveHashtag} click': function(el) {
                    var tag = el.data('tag');

                    EasySocial.dialog({
                        content: EasySocial.ajax('site/views/stream/confirmSaveFilter', {
                            tag: tag
                        }),
                        bindings: {
                            '{saveButton} click': function() {
                                this.inputWarning().hide();

                                var filterName = this.inputTitle().val();

                                if (filterName == '') {
                                    this.inputWarning().show();
                                    return;
                                }

                                EasySocial.ajax('site/controllers/events/addFilter', {
                                    title: filterName,
                                    tag: tag,
                                    id: self.options.id
                                }).done(function(html, msg) {
                                    var item = $.buildHTML(html);

                                    self.filterStreamList().append(item);

                                    EasySocial.dialog(msg);

                                    setTimeout(function() {
                                        EasySocial.dialog().close();
                                    }, 2000);
                                });
                            }
                        }
                    });
                },

                '{apps} click': function(el, ev) {
                    ev.preventDefault();

                    el.route();

                    self.setActive(el);

                    self.setLoading();

                    EasySocial.ajax('site/controllers/events/getAppContents', {
                        appId: el.data('app-id'),
                        eventId: self.options.id
                    }).always(function(contents) {
                        self.updateContents(contents);
                    });
                },

                '{info} click': function(el, ev) {
                    ev.preventDefault();

                    el.route();

                    self.setActive(el);

                    self.setLoading();

                    var loaded = el.data('loaded');

                    if (loaded) {
                        self.infoItem().eq(0).trigger('click');
                        return;
                    }

                    if (el.enabled()) {
                        el.disabled(true);

                        EasySocial.ajax('site/controllers/events/initInfo', {
                            eventId: self.options.id
                        }).done(function(steps) {
                            el.data('loaded', 1);

                            var parent = el.parent('[data-sidebar-item]');

                            // Append all the steps
                            $.each(steps.reverse(), function(index, step) {
                                if (!step.hide) {
                                    parent.after(self.view.infoItem({
                                        url: step.url,
                                        title: step.title,
                                        index: step.index
                                    }));
                                }

                                if (step.html) {
                                    self.updateContents(step.html);
                                    self.content().find('[data-field]').trigger('onShow');
                                }
                            });

                            var item = self.infoItem().eq(0);

                            self.setActive(item);

                            // Have to set the title
                            $(document).prop('title', item.attr('title'));

                            el.enabled(true);
                        }).fail(function(error) {
                            el.enabled(true);
                            self.updateContents(error.message);
                        });
                    }
                },

                '{infoItem} click': function(el, ev) {
                    ev.preventDefault();

                    el.route();

                    self.setActive(el);

                    self.setLoading();

                    var index = el.data('info-index');

                    EasySocial.ajax('site/controllers/events/getInfo', {
                        eventId: self.options.id,
                        index: index
                    }).done(function(contents) {
                        self.updateContents(contents);

                        self.content().find('[data-field]').trigger('onShow');
                    }).fail(function(error) {
                        self.updateContents(error.message);
                    });
                },

                '{invite} click': function(el, ev) {
                    EasySocial.dialog({
                        content: self.view.loading(),
                        width: 400,
                        heigth: 150
                    });

                    EasySocial.ajax('site/views/events/inviteFriendsDialog', {
                        'id' : self.options.id
                    }).done(function(content) {
                        EasySocial.dialog({
                            content: content
                        });
                    });
                },

                '{unpublish} click': function(el, ev) {
                    EasySocial.dialog({
                        content: EasySocial.ajax('site/views/events/unpublishEventDialog', {
                            id: self.options.id
                        })
                    });
                },

                '{delete} click': function(el, ev) {
                    EasySocial.dialog({
                        content: EasySocial.ajax('site/views/events/deleteEventDialog', {
                            id: self.options.id
                        })
                    });
                }
            }
        });

        module.resolve();
    });
});

EasySocial.module('site/events/update', function($) {
    var module = this;

    EasySocial.Controller('Events.Update', {
        defaultOptions: {
            postdata: {},
            updateids: [],
            schedule: [],

            eventId: null,

            '{progress}': '[data-progress-bar]',

            '{form}': '[data-form]'
        }
    }, function(self) {
        return {
            init: function() {
                self.startUpdate();
            },

            updateCounter: 0,
            createCounter: 0,

            updateProgressBar: function() {
                var percentage = Math.ceil(((self.updateCounter + self.createCounter) / (self.options.updateids.length + self.options.schedule.length)) * 100);

                self.progress().css({
                    width: percentage + '%'
                });
            },

            startUpdate: function() {
                if (self.options.updateids[self.updateCounter] === undefined) {
                    return self.startCreate();
                }

                self.update(self.options.updateids[self.updateCounter])
                    .done(function() {
                        self.updateCounter++;

                        self.updateProgressBar();

                        self.startUpdate();
                    })
                    .fail(function(msg, errors) {
                        console.log(msg, errors);
                    });
            },

            update: function(id) {
                var post = $.extend({}, self.options.postdata, {
                    id: id,
                    applyRecurring: 1
                });

                return EasySocial.ajax('site/controllers/events/update', post);
            },

            startCreate: function() {
                if (self.options.schedule[self.createCounter] === undefined) {
                    return self.completed();
                }

                self.create(self.options.schedule[self.createCounter])
                    .done(function() {
                        self.createCounter++;

                        self.updateProgressBar();

                        self.startCreate();
                    })
                    .fail(function(msg, errors) {
                        console.log(msg, errors);
                    });
            },

            create: function(datetime) {
                return EasySocial.ajax('site/controllers/events/createRecurring', {
                    eventId: self.options.eventId,
                    datetime: datetime
                });
            },

            completed: function() {
                self.progress().parent().removeClass('progress-info').addClass('progress-success');
                self.form().submit();
            }
        }
    });

    module.resolve();
});

EasySocial.module("site/explorer", function($) {

	var module = this;

	var CLASS_SELECTED = "is-selected",
		STATE_SELECTED = ".is-selected",
		CLASS_CHECKED = "is-checked",
		STATE_CHECKED = ".is-checked",
		STATE_NOT_SELECTED = ":not(.is-selected)",
		CLASS_ACTIVE = "is-active",
		STATE_ACTIVE = ".is-active",
		EVENT_FILE_SELECT = "fileSelect",
		EVENT_FILE_DESELECT = "fileDeselect",
		EVENT_FOLDER_ACTIVATE = "folderActivate",
		EVENT_FOLDER_DEACTIVATE = "folderDeactivate",
		EVENT_FILE_INSERT = "fileInsert",
		EVENT_FOLDER_INSERT = "folderInsert",
		EVENT_FILE_REMOVE = "fileRemove",
		EVENT_FOLDER_REMOVE = "folderRemove",
		EVENT_FILE_USE = "fileUse",
		EVENT_SERVICE_REQUEST = "serviceRequest";

	$.template("explorer/folder", '<div class="fd-explorer-folder" data-id="[%== data.id %]">[%== data.name %]<a href="javascript: void(0);" class="fd-folder-remove-button" data-fd-explorer-delete-folder-button><i class="ies-cancel-2"></i></a></div>');

	$.template("explorer/fileGroup", '<div class="fd-explorer-file-group" data-folder="[%== data.id %]" data-plupload-dropsite></div>');

	$.template("explorer/file", '<div class="fd-explorer-file" data-id="[%== data.id %]">[%== data.name %]</div>');

	// TODO: Move this to Foundry
	EasySocial.require()
		.script("site/explorer/uploader")
		.done();

	$.Controller("Explorer",
	{
		pluginName: "explorer",
		hostname: "explorer",

		defaultOptions: {
			view: {
				folder: "explorer/folder",
				fileGroup: "explorer/fileGroup",
				file: "explorer/file"
			},

			layout: {
				fileItemHeight: 52
			},

			uid: null,
			type: null,
			disableValidation: false,
			mockError: false,
			controllerName: null,
			
			"{browser}"    : ".fd-explorer-browser",
			"{viewport}"   : ".fd-explorer-viewport",
			"{folderGroup}": ".fd-explorer-folder-group",
			"{folder}"     : ".fd-explorer-folder",
			"{fileGroup}"  : ".fd-explorer-file-group",
			"{file}"       : ".fd-explorer-file",
			"{button}"     : "[data-fd-explorer-button]",

			"{mockError}"  : "[name=mock_error]",
			"{disableValidation}": "[name=disable_validation]",
			"{fileInput}"  : "[name=file]",
			"{logs}"       : "[data-alertlog]",
			"{togglefunky}": ".togglefunky",
			"{funky}": ".fd-explorer-funky",
			"{serviceState}": ".service-state",


			"{selectAllCheckbox}": "[data-fd-explorer-select-all]",
			"{selectCheckbox}"   : "[data-fd-explorer-select]",

			"{deleteButton}": "[data-fd-explorer-delete-button]",
			"{deleteFolderButton}": "[data-fd-explorer-delete-folder-button]"
		}
	},
	function(self, opts, base) { return {

		init: function() {

			// Set the type and uid
			self.options.type = self.element.data('type');
			self.options.uid  = self.element.data('uid');
			self.options.controllerName = self.element.data('controller-name');

			// Extend with uploader plugin
			// TODO: Move this to Foundry
			$.module("easysocial/site/explorer/uploader")
				.done(function(controller){
					self.addPlugin("uploader", controller);
				});

			// Get folder list
			self.services.getFolders()
				.done(function(data){

					// Generate folder list
					self.insertFolder(data);

					// Activate first folder
					self.folder(":first").click();
				});

			self.viewport().on("scroll", $.debounce(self.viewportScroll, 250));
		},

		baseParams: function() {

			return {
				uid: base.data("uid"),
				type: base.data("type")
			};
		},

		exception: function(ex) {

			var logs = self.logs();

			if (!$.isPlainObject(ex)) {
				ex = {
					message: ex,
					type: "error"
				};
			};

			switch (ex.type) {

				case "error":
					logs.switchClass("alert-error")
						.html(ex.message);
					EasySocial.debug && console.error(ex.message);
					break;

				case "warning":
					logs.switchClass("alert-warning")
						.html(ex.message);
					EasySocial.debug && console.warn(ex.message);
					break;

				case "success":
					logs.switchClass("alert-success")
						.html(ex.message);
					EasySocial.debug && console.log(ex.message);
					break;

				case "info":
				default:
					logs.switchClass("alert-info")
						.html(ex.message);
					EasySocial.debug && console.log(ex.message);
					break;
			}

			return ex;
		},

		library: {
			file: {},
			folder: {}
		},

		data: function(type, id) {

			return self.library[type][id];
		},

		addData: function(type, data) {

			// Normalize arguments
			if ($.isPlainObject(data)) data = [data];

			if (!$.isArray(data)) {
				return self.exception("Unable to add " + type + " to library due to invalid data given.");
			}

			$.each(data, function(i){

				if (!$.isPlainObject(this)) {
					self.exception("Skipping invalid " + type + " data at index " + i + ".");
				}

				// TODO: Server should return proper 0 value.
				if (this.id===null) this.id = 0;

				/*
				var existing = self.library[type][this.id];
				if (existing) {
					self.exception("Replacing existing " + type + " in library for id " + this.id + ".");
				}
				*/

				self.library[type][this.id] = this;
			});
		},

		removeData: function(type, id) {

			delete self.library[type][id];
		},

		// Navigation
		"{folder} click": function(folder) {

			self.activateFolder(folder.data("id"));
		},

		currentFolder: function() {

			return self.folder(STATE_ACTIVE).data("id");
		},

		activateFolder: function(id) {

			var folder = self.folder().filterBy("id", id),
				data = self.data("folder", id);

			if (folder.length < 1) return;

			// Deactivate currently active folder
			self.deactivateFolder(self.folder(STATE_ACTIVE).data("id"));

			// Activate this folder
			folder.addClass(CLASS_ACTIVE);
			self.trigger(EVENT_FOLDER_ACTIVATE, [id, folder, data]);
		},

		deactivateFolder: function(id) {

			var folder = self.folder().filterBy("id", id),
				data = folder.data("folder");

			if (folder.length < 1) return;

			folder.removeClass(CLASS_ACTIVE);
			self.trigger(EVENT_FOLDER_DEACTIVATE, [id, folder, data]);
		},

		selectedFolder: function() {

			return self.currentFolder();
		},

		"{file} click": function(file, event) {

			var multiple = event.metaKey || event.ctrlKey;

			// Deselect existing selection if we're not
			// selecting multiple selection.
			if (!multiple) self.deselectAllFiles();

			// Select or deselect file
			self.toggleFile(file.data("id"));
		},

		toggleFile: function(id) {

			var file = self.file().filterBy("id", id),
				method = file.hasClass(CLASS_SELECTED) ? "deselectFile" : "selectFile";

			if (file.length < 1) return;

			self[method](id);
		},

		selectFile: function(id) {

			var file = self.file().filterBy("id", id),
				data = self.data("file", id);

			if (file.length < 1) return;

			file.addClass(CLASS_SELECTED);
			// file.find(self.selectCheckbox.selector).prop("checked", true);

			self.trigger(EVENT_FILE_SELECT, [id, file, data]);
		},

		deselectFile: function(id) {

			var file = self.file().filterBy("id", id),
				data = file.data("file", id);

			if (file.length < 1) return;

			file.removeClass(CLASS_SELECTED);
			// file.find(self.selectCheckbox.selector).prop("checked", false);

			self.trigger(EVENT_FILE_DESELECT, [id, file, data]);
		},

		selectAllFiles: function() {

			self.file(STATE_NOT_SELECTED).each(function(){
				self.selectFile($(this).data("id"));
			});
		},

		deselectAllFiles: function() {

			self.file(STATE_SELECTED).each(function(){
				self.deselectFile($(this).data("id"));
			});
		},

		selectedFile: function() {

			return self.selectedFiles()[0];
		},

		selectedFiles: function() {

			var files = [],
				selectedFiles;

			// TODO: Need to rethink this.
			// Prefer checked files over selected files
			var selectedFiles = self.file(STATE_CHECKED);

			if (selectedFiles.length < 1) {
				selectedFiles = self.file(STATE_SELECTED);
			}

			selectedFiles
				.each(function(){
					var id = $(this).data("id");
					files.push(id);
				});

			return files;
		},

		insertFolder: function(data) {

			// Normalize arguments.
			if (!$.isArray(data)) data = [data];

			// Validate data.
			var sample = data[0];

			if (!$.isPlainObject(sample)) {
				return self.exception("Invalid folder data given to be inserted into the folder group.");

			}

			// Find folder group.
			var folderGroup = self.folderGroup();

			if (folderGroup.length < 1) {
				return self.exception("Could not locate folder group element.");
			}

			// Generate folders html in a bulk to speeed up DOM insertion.
			var folders = "";
			$.each(data, function(){

				// TODO: Server should return proper 0 value.
				if (this.id===null) this.id = 0;

				folders += self.view.folder(true, {data: this});
			});

			// Insert folders into folder group.
			folders = $.buildHTML(folders).appendTo(folderGroup);

			// Trigger folder insert event.
			self.trigger(EVENT_FOLDER_INSERT, [folders, data]);
		},

		prependFile: function(data) {

			if (!$.isPlainObject(data)) {
				return self.exception("Invalid file data given to be inserted.");
			}

			// Find file group
			var fileGroup = self.fileGroup().filterBy("folder", data.folder);

			if (fileGroup.length < 1) {
				return self.exception("Could not locate file group element for folder id " + data.folder + ".");
			}

			var html = data.html || self.view.file(true, {data: data});

			$.buildHTML(html)
				.data("finalized", true)
				.prependTo(fileGroup);
		},

		insertFile: function(data, id) {

			// Normalize arguments.
			if (!$.isArray(data)) data = [data];

			if (id===undefined) {

				// Validate data.
				var sample = data[0];

				if (!$.isPlainObject(sample)) {
					return self.exception("Invalid file data given to be inserted.");
				}

				id = sample.folder;
			}

			// Find file group
			var fileGroup = self.fileGroup().filterBy("folder", id);

			if (fileGroup.length < 1) {
				return self.exception("Could not locate file group element for folder id " + data.folder + ".");
			}

			var files = [];

			$.each(data, function(){

				var filedata = this;

				self.file().filterBy("id", this.id).each(function(){

					var file = $(this);

					if (file.data("finalized")) return;

					var html = $.buildHTML(filedata.html || self.view.file(true, {data: filedata})).data("finalized", true);

					file.replaceWith(html);

				});
			});

			// Generate files html in bulk to speed up DOM insertion.
			// var files = "";

			// $.each(data, function(){
			// 	files += self.view.file(true, {data: this});
			// });

			// Insert files into file group.
			// files = $.buildHTML(files).appendTo(fileGroup);

			// Trigger file insert event.
			self.trigger(EVENT_FILE_INSERT, [files, data]);
		},

		removeFolder: function(id) {

			// Remove folder.
			var folder = self.folder().filterBy("id", id), failed;

			if (folder.length < 1) {
				failed = self.exception("Could not locate to remove folder element for folder id " + id + ".");
			}

			folder.remove();

			// Remove file group of this folder.
			var fileGroup = self.fileGroup().filterBy("folder", id);

			if (fileGroup.length < 1) {
				failed = self.exception("Could not locate to remove file group element for folder id " + id + ".");
			}

			fileGroup.remove();

			self.trigger(EVENT_FOLDER_REMOVE, [id, failed]);
		},

		removeFile: function(id) {

			// Remove file.
			var file = self.file().filterBy("id", id), failed;

			if (file.length < 1) {
				failed = self.exception("Could not locate to remove file element for file id " + id + ".");
			}

			file.remove();

			self.trigger(EVENT_FILE_REMOVE, [id, failed]);
		},

		// Service
		service: function(hook, params, ajaxOptions) {

			self.serviceState().switchClass("state-busy");

			var task =
				EasySocial.ajax(
						base.data("url"),
						$.extend({
							hook: hook,
							error: opts.mockError
						}, params),
						ajaxOptions
					)
					.always(function(){
						// self.exception({
						// 	type: "info",
						// 	message: "Log message will show here."
						// })
						self.serviceState().switchClass("state-idle");
					})
					.fail(function(ex){
						self.exception(ex);
					});

			// Trigger an event for this service request
			self.trigger(EVENT_SERVICE_REQUEST, [hook, task, params]);

			return task;
		},

		"{button} click": function(button) {

			var hook = button.attr('data-fd-explorer-button'),
				method = self.services[hook];

			// Execute hook
			method && method();
		},

		services: {

			getFolders: function(params) {

				var defaultParams = {
					start: 0,
					limit: 100
				};

				var task =
					self.service("getFolders",
							$.extend(
								self.baseParams(),
								defaultParams,
								params
							)
						)
						.done(function(data){
							self.addData("folder", data);
						});

				return task;
			},

			addFolder: function(params) {

				if (!params) {
					params = {name: prompt($.language("COM_EASYSOCIAL_EXPLORER_ENTER_FOLDER_NAME"))};
				}

				var defaultParams = {
					name: ''
				};

				params = $.extend(self.baseParams() , defaultParams, params);

				if (!params.name && !opts.disableValidation) {
					self.exception({
						message: $.language("COM_EASYSOCIAL_EXPLORER_INVALID_FOLDER_NAME"),
						type: "error"
					});
					return;
				}

				var task =
					self.service("addFolder", params)
						.done(function(data){
							self.addData("folder", data);
							self.insertFolder(data);
						});

				return task;
			},

			removeFolder: function(params) {

				var defaultParams = {
					id: self.selectedFolder()
				};

				if (!opts.disableValidation && self.selectedFolder()===undefined) {
					self.exception("No folder selected");
					return;
				}

				var task =
					self.service("removeFolder", $.extend( self.baseParams() , defaultParams, params))
						.done(function(id){
							self.removeFolder(id);
						});

				return task;
			},

			getFiles: function(params) {

				var defaultParams = {
					start: 0,
					limit: 100
				};

				var task =
					self.service("getFiles", $.extend(self.baseParams() , defaultParams, params))
						.done(function(data){
							self.addData("file", data);
						});

				return task;
			},

			addFile: function(params) {

				// params: {id: id, file: file}
				var defaultParams = {
					id: self.currentFolder(),
					files: self.fileInput()
				};

				if (!opts.disableValidation && !self.fileInput().val()) {
					self.exception("No file chosen yet.");
					return;
				}

				var task =
					self.service("addFile", $.extend( self.baseParams(), defaultParams, params), {type: 'iframe'})
						.done(function(data){
							console.log("Upload returned data:", data);
							self.addData("file", data);
							self.prependFile(data);

							self.exception({
								message: "Added file " + data.name,
								type: "success"
							});
						});

				return task;
			},

			removeFile: function(params) {

				var defaultParams = {
					id: self.selectedFiles()
				};

				var params = $.extend(self.baseParams(), defaultParams, params);

				if (!opts.disableValidation && $.isArray(params.id) && params.length < 1) {
					self.exception("No file selected");
					return;
				}

				var task =
					self.service("removeFile", params)
						.done(function(id){

							if ($.isArray(id)) {
								$.each(id, function(){
									self.removeFile(this);
								});
							} else {
								self.removeFile(id);
							}

							self.selectAllCheckbox().prop("checked", false);
						});

				return task;
			},

			useFile: function() {

				var id = self.selectedFile(),
				 	file = self.file().filterBy("id", id),
					data = self.data("file", id);

				if (file.length < 1) return;

				self.trigger(EVENT_FILE_USE, [id, file, data]);
			},

			previewFile: function() {

				var id = self.selectedFile(),
				 	file = self.file().filterBy("id", id),
					data = self.data("file", id);

				var url = file.data("previewUri");
				if (!url) return;

				window.open(url, "_blank");
			}
		},

		// UI
		"{self} folderActivate": function(explorer, event, id, folder, data) {

			// Find file group.
			var fileGroups = self.fileGroup(),
				fileGroup = fileGroups.filterBy("folder", id);

			// Deactivate other groups
			fileGroups.removeClass(CLASS_ACTIVE);

			// If file group hasn't been created before
			if (fileGroup.length < 1) {

				// TODO: Server should return an empty map.
				if (!data.map) data.map = [];

				var map = '<div class="fd-explorer-file" data-id="' + data.map.join('">&nbsp;</div><div class="fd-explorer-file" data-id="') + '">&nbsp;</div>';

				// Create file group
				fileGroup =
					self.view.fileGroup({data: data})
						.html(map)
						.appendTo(self.viewport());

				// Get files from server
				self.services.getFiles({id: id})
					.done(function(data){

						// and insert file into file group
						self.insertFile(data, id);
					});
			}

			// Activate group
			fileGroup.addClass("is-active");
		},

		// "{viewport} scroll": function(viewport) {

			// TODO: Determine position of list

			// cosole.log("scrolling");
		// }

		viewportScroll: function() {

			var viewport = self.viewport()[0],
				viewportHeight = self.viewport().height(),
				scrollHeight = viewport.scrollHeight,
				scrollTop = viewport.scrollTop,
				top = scrollTop - viewportHeight,
				itemHeight = self.file(":nth(2)").outerHeight(true);

			// console.log(viewport.scrollHeight);

			var index = Math.floor(scrollTop / itemHeight),
				tolerance = 3,
				fileGroup = self.fileGroup(".is-active"),
				id = fileGroup.data("folder");

			// self.browser().addClass("is-loading");

			self.services.getFiles({id: id, start: index - tolerance})
				.done(function(data){
					self.insertFile(data, id);
				})
				.always(function(){
					// self.browser().removeClass("is-loading");
				});
		},

		"{togglefunky} click": function() {
			self.funky().toggle();
		},

		"{disableValidation} change": function(input) {

			opts.disableValidation = !!input.prop("checked");

			self.exception({
				message: "Client-side validation is " + ((!opts.disableValidation) ? "ON!" : "OFF!"),
				type: "info"
			});
		},

		"{mockError} change": function(input) {

			opts.mockError = !!input.prop("checked");
			self.exception({
				message: "Error mocking is " + ((opts.mockError) ? "ON!" : "OFF!"),
				type: "info"
			});
		},

		"{selectAllCheckbox} click": function(checkbox) {

			var checked = checkbox.prop("checked");

			self.fileGroup(STATE_ACTIVE)
				.find(self.selectCheckbox.selector)
				.prop("checked", checked)
				.trigger("change");
		},

		"{selectCheckbox} change": function(checkbox) {

			var file = self.file.of(checkbox),
				id = file.data("id"),
				checked = checkbox.prop("checked");

			file.toggleClass("is-checked", checked);
		},

		"{deleteButton} click": function(deleteButton) {

			var file = self.file.of(deleteButton),
				id   = file.data("id");

			// Request the user for confirmation before deleting
			EasySocial.dialog(
			{
				content : EasySocial.ajax( 'site/views/explorer/confirmDeleteFile' ,  { "id" : id } ),
				bindings:
				{
					"{deleteButton} click" : function()
					{
						EasySocial.dialog().close();
						self.services.removeFile({id: id});
					}
				}
			});

		},

		"{deleteFolderButton} click": function(deleteFolderButton , event ) {

			event.preventDefault();

			var folder = self.folder.of(deleteFolderButton),
				id = folder.data("id");

			// Core folder cannot be deleted
			if (id===0) return;

			// Request the user for confirmation before deleting
			EasySocial.dialog(
			{
				content : EasySocial.ajax( 'site/views/explorer/confirmDeleteFolder' ,  { "id" : id } ),
				bindings:
				{
					"{deleteButton} click" : function()
					{
						EasySocial.dialog().close();
						self.services.removeFolder({id: id});
					}
				}
			});

		}
	}});

	EasySocial.require()
		.language(
			"COM_EASYSOCIAL_EXPLORER_ENTER_FOLDER_NAME",
			"COM_EASYSOCIAL_EXPLORER_INVALID_FOLDER_NAME"
		)
		.done(function(){
			module.resolve();
		});
});

EasySocial.module('site/explorer/uploader', function($) {

var module = this;

$.require()
	.library("plupload")
	.done(function(){

		var Controller =
		$.Controller("Explorer/Uploader",
		{
			defaultOptions: {

				settings: {},

				"{uploadItemGroup}": "[data-fd-explorer-upload-item-group]",
				"{uploadItem}"     : "[data-fd-explorer-upload-item]"
			}
		},
		function(self, opts, base) { return {

			init: function() {

				base.plupload(opts.settings);

				// Set a reference to plupload
				self.plupload = base.plupload("controller").plupload;
			},

			settings: function(key, val) {

				var settings = self.plupload.settings;

				// Setter
				if (val!==undefined) {
					settings[key] = val;
				}

				// Getter
				return (key) ? settings[key] : settings;
			},

			"{self} folderActivate": function(explorer, event, id, folder, data) {


			},

			"{self} BeforeUpload": function(el, event, uploader, file) {

				var url =
					$.uri(EasySocial.ajaxUrl)
						.addQueryParam("controller", self.explorer.options.controllerName)
						.addQueryParam("task", "explorer")
						.addQueryParam("id", self.explorer.currentFolder())
						.addQueryParam("no_html", 1)
						.addQueryParam("format", "json")
						.addQueryParam("hook", "addFile")
						.addQueryParam("tmpl", "component")
						.addQueryParam("uid", base.data("uid"))
						.addQueryParam("type", base.data("type"))
						.addQueryParam(EasySocial.token(), 1)
						.toString();

				self.settings("url", url);
			},

			"{self} FilesAdded": function(el, event, uploader, file) {

				self.plupload.start();
			},

			"{self} UploadFile": function() {

				clearTimeout(self.loadTimer);
				base.addClass("is-loading");
			},

			"{self} FileUploaded": function(el, event, uploader, file, data) {

				self.loadTimer = setTimeout(function(){
					base.removeClass("is-loading");
				}, 1000);

				var explorer = self.explorer;

				// If the response is not a valid object
				if (!$.isPlainObject(data)) {
					self.setMessage("Server did not return proper data after uploading.", "error");
					return;
				}

				explorer.addData("file", data);
				explorer.prependFile(data);
			},

			"{self} FileError": function(el, event, uploader, file, response) {

				base.removeClass("is-loading");

				if ($.isPlainObject(response)) {
					self.setMessage(response.message, "error");
				}
			},

			"{self} Error": function(el, event, uploader, error) {

				base.removeClass("is-loading");

				self.setMessage(error.message, "error");
			}

		}});

		module.resolve(Controller);
	});

});

EasySocial.module('site/explorer/popup', function($) {

var module = this;

EasySocial.require()
.view("site/explorer/popup")
.done(function(){

	$.Controller("Explorer/Popup",
	{
		defaultOptions: {

			view: {
				popup: "easysocial/site/explorer/popup"
			},

			"{popup}"   : "[data-explorer-popup]",
			"{viewport}": "[data-popup-viewport]",
			"{explorer}": "[data-explorer-popup] .fd-explorer",
			"{closeButton}": ".fd-explorer .close-button"
		}
	},
	function(self, opts, base) { return {

		init: function() {

		},

		"{window} resize": $.debounce(function() {

		}, 100),

		show: function() {

			var popup,
				node = self.popup.node;

			// Create node if not exists
			if (!node) {
				popup = self.view.popup();
				node  = self.popup.node = popup[0];
			}

			// Append node if detached
			if (!$.contains(base, node)) {
				popup = $(node).appendTo(base);
			}

			if (!popup.is(":visible")) {
				popup.show().trigger("show");
			}
		},

		hide: function() {

			self.popup()
				.hide()
				.trigger("hide")
				.detach();
		},

		// options: uid, type, url
		open: function(options) {

			self.show();

			var task = $.Deferred();

			var existingExplorer = self.explorer();

			if (existingExplorer.length > 0 &&
				existingExplorer.data("uid")===options.uid &&
				existingExplorer.data("type")===options.type) {
				return task.resolve(existingExplorer.explorer("controller"), self);
			}

			EasySocial.ajax("site/views/explorer/browser", options)
				.done(function(html){

					var browser = $.buildHTML(html);

					self.viewport()
						.empty()
						.append(browser);

					var explorer = browser.filter(".fd-explorer").explorer("controller");

					task.resolve(explorer, self);
				})
				.fail(function(){

					task.reject();
				});

			return task;
		},

		"{self} click": function(el, event) {

			if (event.target===self.popup()[0]) {
				self.hide();
			}
		},

		"{closeButton} click": function() {
			self.hide();
		}

	}});

	var instance = EasySocial.explorer = $("body").addController("Explorer/Popup");

	module.resolve(instance);
});

});

EasySocial.module( 'site/followers/followers' , function($){

	var module 	= this;

	EasySocial.require()
	.view( 'site/loading/small' )
	.script( 'site/conversations/composer' )
	.done(function($){

		EasySocial.Controller(
			'Followers',
			{
				defaultOptions :
				{
					"{content}"	: "[data-followers-content]",
					"{filter}"	: "[data-followers-filter]",
					"{items}"	: "[data-followers-item]",
					"{followingCounter}" : "[data-following-count]",
					'{suggestionCounter}' : "[data-suggest-count]",
					view :
					{
						loader 				: "site/loading/small"
					}
				}
			},
			function( self )
			{
				return {

					init : function()
					{
						self.initItemController();
					},

					initItemController: function()
					{
						self.items().implement( EasySocial.Controller.Followers.Item ,
						{
							"{parent}"	: self
						});
					},

					updateFollowingCounter: function( value )
					{
						var current 	= self.followingCounter().html(),
							updated		= parseInt( current ) + value;

						self.followingCounter().html( updated );
					},

					updateSuggestionCounter: function( value )
					{
						var current 	= self.suggestionCounter().html(),
							updated		= parseInt( current ) + value;

						self.suggestionCounter().html( updated );
					},

					updateContents : function( contents )
					{
						self.content().replaceWith( contents );
					},

					updatePagination : function( pagination )
					{
						$('[data-followers-pagination]').html( pagination );
					},

					"{filter} click" : function(filter, event) {

						var type 	= filter.data( 'followers-filter-type' ),
							title 	= filter.data( 'followers-filter-title' ),
							id 		= filter.data( 'followers-filter-id' ),
							url 	= filter.data( 'followers-filter-url' );

						// Remove active class on all filters
						self.filter().removeClass("active");

						// Add active class to current filter
						filter.addClass("active");

						History.pushState({state:1}, title, url);

						EasySocial.ajax(
							"site/controllers/followers/filter",
							{
								id: id,
								type: type
							})
							.done(function(contents, pagination){

								self.updateContents(contents);
								self.updatePagination(pagination);
								self.initItemController();
							});
					}
				}
			});

			EasySocial.Controller(
				'Followers.Item',
				{
					defaultOptions :
					{
						"{unfollowButton}"	: "[data-followers-item-unfollow]",
						"{followButton}"	: "[data-followers-item-follow]",
						"{composer}"		: "[data-followers-item-compose]"
					}
				},
				function( self )
				{
					return {
						init : function()
						{
							self.options.id 			= self.element.data( 'id' );

							self.initComposer();
						},

						initComposer: function()
						{
							self.composer().implement( EasySocial.Controller.Conversations.Composer.Dialog,
							{
								"recipient"	:
								{
									"id"	: self.options.id
								}
							});
						},

						"{unfollowButton} click" : function()
						{
							EasySocial.dialog(
							{
								content 	: EasySocial.ajax( 'site/views/followers/confirmUnfollow' , { 'id' : self.options.id }),
								bindings 	:
								{
									"{unfollowButton} click" : function()
									{
										EasySocial.ajax( 'site/controllers/followers/unfollow' , { "id" : self.options.id} )
										.done(function()
										{
											// Update the counter
											self.parent.updateFollowingCounter( -1 );

											// Remove this item
											self.element.remove();

											EasySocial.dialog().close();
										});
									}
								}
							});
						},

						"{followButton} click" : function()
						{
							EasySocial.ajax( 'site/controllers/followers/follow' , { "id" : self.options.id} )
							.done(function(content)
							{
								// Update the suggestion counter
								self.parent.updateSuggestionCounter(-1);

								//update following counter
								self.parent.updateFollowingCounter(1);

								// Remove this item
								self.element.html(content);

							})
				            .fail(function(messageObject) {
				                EasySocial.dialog({
				                    content: messageObject.message
				                });
				            });
						}
					}
				});
		module.resolve();
	});
});

EasySocial.module( 'site/friends/friends' , function($){

	var module 	= this;

	EasySocial.require()
	.script(
		'site/friends/list' ,
		'site/friends/item' ,
		'site/friends/suggest',
		'site/conversations/composer'
	)
	.view(
		'site/loading/small' ,
		'site/friends/default.empty' ,
		'site/friends/list.assign'
	)
	.done(function($){

		EasySocial.Controller(
			'Friends.Birthday',
			{
				defaultOptions:
				{
					"{messageButton}"	: "[data-upcoming-birthday-message-button]"
				}
			},
			function( self ){
				return {
					init: function()
					{
						// Get the id of the current user.
						self.options.id 	= self.element.data( 'id' ),
						self.options.name 	= self.element.data( 'name' ),
						self.options.avatar	= self.element.data( 'avatar' );

						self.messageButton().implement( EasySocial.Controller.Conversations.Composer.Dialog,
						{
							"recipient"	:
							{
								"id"	: self.options.id,
								"name"	: self.options.name,
								"avatar": self.options.avatar
							}
						});
					}

				}
			}

		);


		EasySocial.Controller(
			'Friends',
			{
				defaultOptions:
				{
					// Get the default active list if there is any.
					activeList 		: null,

					// Left side friend's list.
					"{friendList}"	: "[data-friends-list]",

					// Content area.
					"{content}"		: "[data-friends-content]",

					// Result
					"{friendItems}"	: "[data-friends-items]",
					"{friendItem}"	: "[data-friends-item]",
					"{emptyList}"	: "[data-friends-emptyItems]",
					"{activeTitle}"	: "[data-friends-activeTitle]",

					// Friends filter
					"{filterItem}"	: "[data-friends-filter]",

					// Friend list actions
					"{friendListActions}"	: "[data-friendList-actions]",

					// Button to add a friend to the list.
					"{addFriendToList}"	: "[data-friends-add]",

					// Counters
					"{friendsCounter}"	: "[data-total-friends]",
					"{pendingCounter}"	: "[data-total-friends-pending]",
					"{suggestionCounter}": "[data-total-friends-suggestion]",
					"{requestCount}"	: "[data-frields-request-sent-count]",

					view :
					{
						loader 				: "site/loading/small",
						emptyFriendItems 	: "site/friends/default.empty",
						addUserForm			: "site/friends/list.assign"
					}

				}
			},
			function( self ){
				return {

					init: function()
					{
						// Implement friend list controller.
						self.friendList().implement( EasySocial.Controller.Friends.List ,
						{
							// parent : self,
							"{parent}" : self
						});

						//Initialize friend item controllers
						self.initFriendItems();
					},

					initFriendItems: function()
					{
						// Apply the friend list actions
						self.friendListActions().implement( EasySocial.Controller.Friends.List.Actions ,
						{
							"{parent}"	: self
						})

						// Implement friend item controller.
						self.friendItem().implement( EasySocial.Controller.Friends.Item ,
						{
							"{parent}"	: self
						});
					},

					updateFriendsCounter: function()
					{
						EasySocial.ajax( 'site/controllers/friends/getCounters' )
						.done(function( totalFriends , totalPending , totalRequests , totalSuggestion )
						{
							self.friendsCounter().html( totalFriends );

							self.pendingCounter().html( totalPending );

							self.requestCount().html( totalRequests );

							self.suggestionCounter().html( totalSuggestion );
						});
					},

					updateListCounters: function()
					{
						EasySocial.ajax( 'site/controllers/friends/getListCounts' ,
						{
						})
						.done( function( lists ){

							$( lists ).each( function( i , list){
								var listController = $( '[data-list-' + list.id + ']').controller();

								listController.updateCounter( list.count );
							});

						});
					},

					insertItem: function( item )
					{
						// Hide any empty notices.
						self.emptyList().hide();

						// Update the counter for the list items.
						self.updateListCounters();

						$( item ).implement( EasySocial.Controller.Friends.Item ,
						{
							"{parent}"	: self
						})
						.prependTo( self.friendItems() );

					},

					removeItem: function( id )
					{
						// Remove item from the list.
						self.friendItem( '[data-friendItem-' + id + ']' ).remove();

						if( self.friendItem().length <= 0 )
						{
							self.emptyList().show();
						}

						// Update the counter for the list items.
						self.updateListCounters();

					},

					updateFriendRequestCount: function( value )
					{
						curCount = parseInt( self.requestCount().text(), 10 );
						if( curCount != NaN )
						{
							curCount = curCount + value;
							self.requestCount().text( curCount );
						}
					},

					updateContent: function( html )
					{
						// Update the content on the friends list.
						self.content().replaceWith(html);

						self.initFriendItems();
					},

					removeActiveFilter: function()
					{
						self.filterItem().removeClass( 'active' );
					},

					"{filterItem} click" : function(filterItem, event )
					{
						var filterType 	= filterItem.data( 'filter' ),
							title 		= filterItem.data( 'title' ),
							userid 		= filterItem.data( 'userid' ),
							url 		= filterItem.data( 'url' );


						// Removes all active state from the friend lists
						if( self.friendList().length > 0)
						{
							self.friendList().controller().removeActiveList();
						}

						// Remove all active state on the filter links.
						self.filterItem().removeClass("active");

						// Add active class to this filter.
						filterItem.addClass( 'active' );

						History.pushState( {state:1} , title , url );

						filterItem.addClass( 'loading' );

						EasySocial.ajax(
							"site/controllers/friends/filter",
							{
								"filter"	: filterType,
								"userid"	: userid

							})
							.done(function(html){

								self.updateContent( html );
							})
							.always(function(){

								// Remove loading on the element.
								filterItem.removeClass("loading");
							});
					}
				}
			}
		);

		module.resolve();
	});
});

EasySocial.module( 'site/friends/list' , function($){

	var module 	= this;

	EasySocial.require()
	.view( 
		'site/loading/small'
	)
	.library( 'history' )
	.script( 'site/friends/suggest' )
	.done(function($){

		EasySocial.Controller(
			'Friends.List',
			{
				defaultOptions:
				{
					parent 		: null,

					"{item}"	: "[data-friends-listItem]",
					"{items}"	: "[data-friends-listItems]",

					"{loadMoreButton}"	: ".loadMoreButton",
					"{loadMore}"		: ".loadMore",

					view :
					{
						loader 		: "site/loading/small",
						items 		: "site/friends/default.lists"
					}
				}
			},
			function( self ){
				return {

					init: function()
					{
						self.item().implement( EasySocial.Controller.Friends.List.Item ,
						{
							"{parent}"	: self
						});
					},

					removeActiveList: function()
					{
						self.item().removeClass( 'active' );
					},

					setDefault : function( id )
					{
						// Remove all items with default class
						self.item().removeClass( 'default' );

						// Add default class on the item
						self.item( '.item-' + id ).addClass( 'default' );
					},

					"{item} click" : function( el )
					{
						var title 	= $(el).data( 'title' ),
							url 	= $(el).data( 'url' );

						History.pushState( {state:1} , title , url );

						// Remove all active class from filters.
						self.parent.removeActiveFilter();

						// Remove all active class from list
						self.item().removeClass( 'active' );

						// Add active class to this element.
						self.item( el ).addClass( 'active' );

						var id 	= $( el ).data( 'id' );

						// Set the active list.
						self.parent.options.activeList	= id;
						
						// Get list of friends.
						EasySocial.ajax( 'site/controllers/friends/getListFriends',
						{
							"id"	: id
						},
						{
							beforeSend: function()
							{
								$( el ).addClass( 'loading' );
							}
						})
						.done(function( html ){

							// Hide loading.
							$( el ).removeClass( 'loading' );

							// Trigger friends list to update with appropriate content.
							self.parent.updateContent( html );

						});
					},

					"{loadMoreButton} click" : function() {
						
						// Get current limit start.
						var limitstart	= self.loadMoreButton().data( 'limitstart' );

						self.loadMore().html( self.view.loader() );

						// Get list of friends.
						EasySocial.ajax(
							"site/controllers/friends/getLists",
							{
								limitstart: limitstart
							})
							.done(function( items ){

								// Hide load more button since nothing to load anymore.
								self.loadMore().hide();

								self.view.items({
									"items"	: items
								}).appendTo( self.items() );
							});
					}
				}
			}
		);

		EasySocial.Controller(
			'Friends.List.Item',
			{
				defaultOptions: 
				{
					id 			: null,

					"{counter}"	: "[data-list-counter]"
				}
			},
			function( self )
			{
				return {

					init: function()
					{
						self.options.id 	= self.element.data( 'id' );
					},

					updateCounter: function( total )
					{
						self.counter().html( total );
					}
				}
			});

		EasySocial.Controller(
			'Friends.List.Actions',
			{
				defaultOptions:
				{
					"{delete}"	: "[data-friendListActions-delete]",
					"{add}"		: "[data-friendListActions-add]",
					"{default}"	: "[data-friendListActions-default]"
				}
			},
			function( self )
			{
				return {

					init : function()
					{
						self.options.id 	= self.element.data( 'id' );
						self.options.title 	= self.element.data( 'title' );
						self.options.userId	= self.element.data( 'userid' );
					},

					"{default} click" : function()
					{
						EasySocial.ajax( 'site/controllers/friends/setDefault' ,
						{
							"id"	: self.options.id
						})
						.done(function()
						{
							// Set the default class on the list item
							self.parent.friendList().controller().setDefault( self.options.id );
						});
					},

					"{add} click" : function()
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'site/views/friends/assignList' , { "id" : self.options.id } ),
							bindings 	:
							{
								"{insertButton} click" : function()
								{
									var items = this.suggest().textboxlist("controller").getAddedItems();

									EasySocial.ajax( 'site/controllers/friends/assign' ,
									{
										"uid"		: $.pluck(items, "id"),
										"userId"	: self.options.userId,
										"listId"	: self.options.id
									})
									.done(function( contents ){

										// Hide any notice messages.
										$( '[data-assignFriends-notice]' ).hide();
										

										$( contents ).each(function( i , item ){

											// Pass the item to the parent so it gets inserted into the friends list.
											self.parent.insertItem( item );
											
											// Close the dialog
											EasySocial.dialog().close();
										});
									})
									.fail( function( message ){
										$( '[data-assignFriends-notice]' ).addClass( 'alert alert-error' )
											.html( message.message );
									});
								}
							}
						});
					},

					"{delete} click" : function()
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( "site/views/friends/confirmDeleteList" , { "id" : self.options.id } ),
							bindings	:
							{
								"{deleteButton} click" : function()
								{
									$( '[data-friends-list-delete-form]' ).submit();
								}
							}
						});
					}
				}
			}
		);

		module.resolve();
	});
});

EasySocial.module( 'site/friends/item' , function($){

	var module 	= this;

	EasySocial.require()
	.script( 'site/conversations/composer' )
	.language( 'COM_EASYSOCIAL_FRIENDS_REQUEST_SENT_PENDING_APPROVAL', 'COM_EASYSOCIAL_FRIENDS_REQUEST_DIALOG_TITLE', 'COM_EASYSOCIAL_FRIENDS_CANCEL_REQUEST_DIALOG_CANCELLED', 'COM_EASYSOCIAL_FRIENDS_REQUEST_SENT' )
	.done(function($){

		EasySocial.Controller(
			'Friends.Item',
			{
				defaultOptions:
				{
					id 					: null,
					name 				: null,
					friendId 			: null,

					"{removeFromList}"	: "[data-lists-removeFriend]",
					"{unfriend}"		: "[data-friends-unfriend]",
					"{addfriend}"		: "[data-friends-addfriend]",
					"{block}"			: "[data-friends-block]",
					"{message}"			: "[data-friendItem-message]",
					"{reject}"			: "[data-friendItem-reject]",
					"{approve}"			: "[data-friendItem-approve]",

					"{addContainer}" : "[data-friendItem-addbutton]",
					"{addButton}" : "[data-friendItem-add]",

					"{cancelRequest}"	: "[data-friendItem-cancel-request]"
				}
			},
			function( self ){
				return {

					init: function()
					{
						self.options.id 		= self.element.data( 'id' );
						self.options.name 		= self.element.data( 'name' );
						self.options.friendId	= self.element.data( 'friendid' );
						self.options.avatar 	= self.element.data( 'avatar' );

						// Initialize conversation links
						self.initConversation();
					},

					"{addButton} click" : function( el )
					{

						// Implement controller on add friend.
						EasySocial.ajax( 'site/controllers/friends/request' ,
						{
							"id"	: self.options.id
						}).done(function(friendId) {
							// replace the button with done message.
							self.addContainer().html( $.language('COM_EASYSOCIAL_FRIENDS_REQUEST_SENT') );
							self.addContainer().addClass('btn btn-es-success btn-sm mt-20');

						}).fail(function(obj) {


							EasySocial.dialog({
								width: 450,
								height: 180,
								content: obj.message
							});
						});
					},

					initConversation : function()
					{
						// Implement conversation controller on the message link.
						self.message().implement( EasySocial.Controller.Conversations.Composer.Dialog ,
						{
							"recipient"	:
							{
								"name"		: self.options.name,
								"id"		: self.options.id,
								"avatar"	: self.options.avatar
							}
						});

					},

					"{removeFromList} click" : function()
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'site/views/friends/confirmRemoveFromList' , { "id" : self.options.id }),
							bindings 	:
							{
								"{removeButton} click" : function()
								{
									EasySocial.ajax( 'site/controllers/friends/removeFromList' ,
									{
										"listId"	: self.parent.options.activeList,
										"userId"	: self.options.id
									})
									.done( function(){

										// Remove the item from the list.
										self.parent.removeItem( self.options.id );

										// Update the counter.

										// Update the dialog to notify the user that the user has been removed from the list.
										EasySocial.dialog(
										{
											"title"		: "User removed from list",
											"content"	: "The user has been removed from the list.",
											"buttons"	:
											[
												{
													"name"			: "Done",
													"classNames"	: "btn btn-es",
													"click"			: function()
													{
														EasySocial.dialog().close();
													}
												}
											]
										})
									})
									.fail( function(message){
										console.log( message );
									});
								}
							}
						});

					},

					"{reject} click" : function()
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'site/views/friends/confirmReject' , { "id" : self.options.id } ),
							bindings	:
							{
								// "{rejectButton} click" : function()
								// {
								// 	$( '[data-friends-reject-form]' ).submit();
								// }


								"{rejectButton} click" : function()
								{
									EasySocial.ajax( 'site/controllers/friends/reject' ,
									{
										"id"	: self.options.friendId
									})
									.done(function()
									{
										// Remove itself from the list.
										self.parent.removeItem( self.options.id );

										// Update the counter
										self.parent.updateFriendsCounter();

										EasySocial.dialog(
										{
											content 	: EasySocial.ajax( 'site/views/friends/friendRejected' )
										});
									});
								}



							}
						});
					},

					"{unfriend} click" : function()
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'site/views/friends/confirmUnfriend' , { "id" : self.options.id }),
							bindings 	:
							{
								"{unfriendButton} click" : function()
								{
									EasySocial.ajax( 'site/controllers/friends/unfriend' ,
									{
										"id"	: self.options.friendId
									})
									.done(function()
									{
										// Remove itself from the list.
										self.parent.removeItem( self.options.id );

										// Update the counter
										self.parent.updateFriendsCounter();

										EasySocial.dialog(
										{
											content 	: EasySocial.ajax( 'site/views/friends/friendRemoved' , { "id" : self.options.id } )
										});
									});
								}
							}
						});

					},

					"{cancelRequest} click" : function()
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'site/views/friends/confirmCancelRequest' , { "id" : self.options.id }),
							bindings 	:
							{
								"{cancelRequestButton} click" : function()
								{
									EasySocial.ajax( 'site/controllers/friends/cancelRequest' ,
									{
										"id"	: self.options.friendId
									})
									.done(function()
									{
										// Remove itself from the list.
										self.parent.removeItem( self.options.id );

										// update count.
										self.parent.updateFriendRequestCount( -1 );

										EasySocial.dialog(
										{
											content 	: EasySocial.ajax( 'site/views/friends/requestCancelled' , { "id" : self.options.id } )
										});
									});
								}
							}
						});

					},

					"{approve} click" : function( el )
					{
						EasySocial.ajax( 'site/controllers/friends/approve',
						{
							"id" : self.options.friendId
						})
						.done(function()
						{
							// Update the counter
							self.parent.updateFriendsCounter();

							// Remove this item from the pending list.
							self.element.remove();
						});
					},

					"{addfriend} click" : function( el )
					{

						// Implement controller on add friend.
						EasySocial.ajax( 'site/controllers/friends/request' ,
						{
							"id"	: self.options.id
						})
						.done( function( friendId )
						{
							// update count
							self.parent.updateFriendRequestCount( 1 );

							EasySocial.dialog({
								title: $.language('COM_EASYSOCIAL_FRIENDS_REQUEST_DIALOG_TITLE'),
								content: $.language('COM_EASYSOCIAL_FRIENDS_REQUEST_SENT_PENDING_APPROVAL', self.options.name )
							});

							// Remove itself from the list.
							self.parent.removeItem( self.options.id );
						})
						.fail(function( message )
						{
							EasySocial.dialog(
							{
								content 	: EasySocial.ajax( 'site/views/friends/exceeded' )
							});
						});
					},

					"{block} click" : function()
					{
						console.log( 'block' );
					}
				}
			}
		);

		module.resolve();
	});
});

EasySocial.module('site/groups/groups', function($)
{
	var module	= this;

	EasySocial.require()
	.view('site/loading/small')
	.script('validate', 'field')
	.done(function($) {
		EasySocial.Controller(
			'Groups.Browser', {
				
				defaultOptions: {
					"{filters}"		: "[data-es-groups-filters] > li",
					"{categories}"	: "[data-es-groups-categories] >li",
					"{content}"		: "[data-es-groups-content]",
					"{items}"		: "[data-groups-item]",
					"{featured}"	: "[data-groups-featured-item]",

					view: {
						loader: "site/loading/small"
					}
				}
			}, function(self) {
				return {

					init: function() {
						
						// Implement the filters
						self.filters().implement(EasySocial.Controller.Groups.Filter,{
							"{parent}" : self
						});

						// Implement category filters
						self.categories().implement(EasySocial.Controller.Groups.Filter.Category, {
							"{parent}": self
						});

						self.featured().implement(EasySocial.Controller.Groups.Browser.Item, {
							"{parent}": self
						});

						self.items().implement(EasySocial.Controller.Groups.Browser.Item, {
							"{parent}": self
						});
					},

					// Allows child items to set an active filter
					setActive: function(element) {
						// Remove all category filters
						self.categories().removeClass('active');

						// Remove all active items
						self.filters().removeClass('active');

						// Add active on the element
						$(element).addClass('active');

						// Add loading class
						self.content().html('&nbsp;');
						self.element.addClass('loading');
					},

					setContent: function(contents) {
						// When content is ready, we should remove the loading state.
						self.element.removeClass('loading');

						//Update the content
						self.content().html(contents);

						self.items().implement(EasySocial.Controller.Groups.Browser.Item,
						{
							"{parent}"	: self
						});
					}
				}
			}
		);


		EasySocial.Controller('Groups.Browser.Item', {
				defaultOptions: {
					"{joinGroup}": "[data-groups-item-join]",
					"{leaveGroup}": "[data-groups-leave]",
					"{respond}": "[data-groups-item-respond]",
					"{setFeatured}": "[data-groups-item-set-featured]",
					"{removeFeatured}": "[data-groups-item-remove-featured]",
					"{deleteGroup}": "[data-groups-item-delete]",
					"{unpublishGroup}": "[data-groups-item-unpublish]",
					"{footer}": "[data-groups-item-footer]"
				}
			}, function(self, options, base) {

				return {
					
					init : function() {
						options.id = self.element.data('id');
						options.type = self.element.data('type');
					},

					"{deleteGroup} click" : function(el, event) {
						EasySocial.dialog({
							content 	: EasySocial.ajax('site/views/groups/confirmDelete', { "id" : self.options.id })
						});
					},

					"{unpublishGroup} click" : function(el, event) {
						EasySocial.dialog({
							content: EasySocial.ajax('site/views/groups/confirmUnpublishGroup', { "id" : self.options.id })
						});
					},

					"{setFeatured} click" : function(el, event) {
						EasySocial.dialog({
							content	: EasySocial.ajax('site/views/groups/setFeatured', {"id" : self.options.id})
						});
					},

					"{removeFeatured} click" : function(el, event) {
						EasySocial.dialog({
							content : EasySocial.ajax('site/views/groups/removeFeatured', { "id" : self.options.id })
						})
					},

					"{respond} click" : function(el, event) {
						EasySocial.dialog({
							content: EasySocial.ajax('site/views/groups/confirmRespondInvitation', { "id" : self.options.id }),
							bindings: {
								"{rejectButton} click" : function() {

									// Add loading
									base.switchClass('is-loading');

									EasySocial.ajax('site/controllers/groups/respondInvitation', {
										"id": options.id,
										"action": "reject"
									}).done(function() {

										// Show join button
										base.switchClass('is-guest');

										EasySocial.dialog().close();
									});
								},

								"{acceptButton} click" : function() {

									// Add loading
									base.switchClass('is-loading');

									EasySocial.ajax('site/controllers/groups/respondInvitation', {
										"id": options.id,
										"action": "accept"
									}).done(function() {

										// Show leave button
										base.switchClass('is-member');

										EasySocial.dialog().close();
									});
								}
							}
						});
					},

					"{leaveGroup} click": function(leaveButton, event) {

						EasySocial.dialog({
							content: EasySocial.ajax('site/views/groups/confirmLeaveGroup', {"id": options.id}),
							bindings: {
								"{leaveButton} click" : function() {

									// Add loading
									base.switchClass('is-loading');

									// Perform an ajax call to really leave the group
									EasySocial.ajax('site/controllers/groups/leaveGroup', {
										"id": options.id
									}).done(function() {
										// Show the join group again
										base.switchClass('is-guest');

										// Hide the dialog
										EasySocial.dialog().close();
									});
								}
							}
						});
					},

					"{joinGroup} click" : function(joinButton, event) {

						// If this is an open group, hide the join button since the user is already a member of the group
						if (options.type == 'open') {

							// Add loading
							base.switchClass('is-loading');

							// Join the group and hide the footer
							EasySocial.ajax('site/controllers/groups/joingroup', {
								"id": options.id
							}).done(function() {
								base.switchClass('is-member');
							});

							return;
						}

						// If this is a private group, display the standard popup.
						EasySocial.dialog({
							content: EasySocial.ajax('site/controllers/groups/joinGroup', { "id" : options.id})
						});
					}
				}
			}
		);

		EasySocial.Controller(
			'Groups.Edit', {
				defaultOptions: {
					id: null,

					"{stepContent}": "[data-group-edit-fields-content]",
					"{stepItem}": "[data-group-edit-fields-step]",

					// Forms.
					"{profileForm}": "[data-group-fields-form]",

					// Content for profile editing
					"{profileContent}": "[data-group-edit-fields]",

					"{fieldItem}": "[data-group-edit-fields-item]",

					// Submit buttons
					"{save}"			: "[data-group-fields-save]"
				}
			}, function(self) {
				return {

					init: function()
					{
						self.fieldItem().addController('EasySocial.Controller.Field.Base', {
							mode: 'edit'
						});
					},

					errorFields: [],

					// Support field throwing error internally
					'{fieldItem} error': function(el, ev)
					{
						self.triggerStepError(el);
					},

					// Support for field resolving error internally
					'{fieldItem} clear': function(el, ev)
					{
						self.clearStepError(el);
					},

					// Support validate.js throwing error externally
					'{fieldItem} onError': function(el, ev)
					{
						self.triggerStepError(el);
					},

					triggerStepError: function(el)
					{
						var fieldid = el.data('id'),
							stepid = el.parents(self.stepContent.selector).data('id');

						if($.inArray(fieldid, self.errorFields) < 0)
						{
							self.errorFields.push(fieldid);
						}

						self.stepItem().filterBy('for', stepid).trigger('error');
					},

					clearStepError: function(el)
					{
						var fieldid = el.data('id'),
							stepid = el.parents(self.stepContent.selector).data('id');

						self.errorFields = $.without(self.errorFields, fieldid);

						self.stepItem().filterBy('for', stepid).trigger('clear');
					},

					"{stepItem} click" : function(el, event)
					{
						var id 	= $(el).data('for');

						// Profile form should be hidden
						self.profileContent().show();

						// Hide all profile steps.
						self.stepContent().hide();

						// Remove active class on step item
						self.stepItem().removeClass('active');

						// Add active class on the selected item.
						el.addClass('active');

						// Get the step content element
						var stepContent = self.stepContent('.step-' + id);

						// Show active profile step.
						stepContent.show();

						// Trigger onShow on the field item in the content
						stepContent.find(self.fieldItem.selector).trigger('show');
					},

					"{stepItem} error": function(el)
					{
						el.addClass('error');
					},

					"{stepItem} clear": function(el)
					{
						if(self.errorFields.length < 1)
						{
							el.removeClass('error');
						}
					},

					"{save} click" : function(el, event)
					{
						// Run some error checks here.
						event.preventDefault();

						el.addClass('btn-loading');

						self.profileForm()
							.validate()
							.fail(function()
							{
								el.removeClass('btn-loading');
								EasySocial.dialog(
								{
									content 	: EasySocial.ajax('site/views/profile/showFormError')
								});
							})
							.done(function()
							{
								self.profileForm().submit();
							});

						return false;
					}
				}
			}
		);

		EasySocial.Controller(
			'Groups.Filter',
			{
				defaultOptions:
				{
				}
			},
			function(self)
			{
				return {
					init : function()
					{
					},

					"{self} click" : function(el, event)
					{
						// Prevent default.
						event.preventDefault();

						// Add active class to itself.
						self.parent.setActive(el);

						// Update the URL on the browser
						$(el).find('a').route();

						EasySocial.ajax('site/controllers/groups/getGroups',
						{
							filter	: self.element.data('es-groups-filters-type')
						})
						.done(function(contents)
						{
							self.parent.setContent(contents);
						});
					}
				}
			}
		);

		EasySocial.Controller(
			'Groups.Filter.Category',
			{
				defaultOptions:
				{
					id 	: null
				}
			},
			function(self)
			{
				return {
					init : function()
					{
						self.options.id 	= self.element.data('es-groups-category-id');
					},

					"{self} click" : function(el, event)
					{
						// Prevent default.
						event.preventDefault();

						// Set active item
						self.parent.setActive(el);

						// Update the url
						$(el).find('a').route();

						// Perform ajax calls to update the content
						EasySocial.ajax('site/controllers/groups/getGroups',
						{
							categoryId 	: self.options.id
						})
						.done(function(contents)
						{
							self.parent.setContent(contents);
						});
					}
				}
			}
		);

		EasySocial.Controller('Groups.Create', {
			defaultOptions: {
				'previousLink': null,

				'{fieldItem}': '[data-groups-create-fields-item]',

				'{previousButton}': '[data-groups-create-previous]',

				'{nextButton}': '[data-groups-create-submit]'
			}
		}, function(self) {
			return {
				init: function() {
					self.fieldItem().addController('EasySocial.Controller.Field.Base');
				},

				'{previousButton} click': function() {
					window.location = self.options.previousLink;
				},

				'{nextButton} click': function(el) {
					if (el.enabled()) {
						el.disabled(true);

						el.addClass('btn-loading');

						self.element.validate()
							.done(function() {
								el.removeClass('btn-loading');
								el.enabled(true);

								self.element.submit();
							})
							.fail(function() {
								el.removeClass('btn-loading');
								el.enabled(true);

								EasySocial.dialog({
									content 	: EasySocial.ajax('site/views/profile/showFormError')
								});
							});
					}
				}
			}
		});

		module.resolve();
	});
});


EasySocial.module( 'site/groups/item' , function($)
{
	var module	= this;

	EasySocial.template('info/item', '<li data-es-group-filter><a class="ml-20" href="[%= url %]" title="[%= title %]" data-info-item data-info-index="[%= index %]"><i class="ies-info ies-small mr-5"></i> [%= title %]</a></li>');

	EasySocial.require()
	.script('site/friends/suggest')
	.library('history')
	.done(function($) {
		EasySocial.Controller('Groups.Item', {
			defaultOptions: {

				"{content}": "[data-es-group-item-content]",
				"{apps}": "[data-es-group-item-app]",
				"{filters}": "[data-es-group-filter]",
				"{filterStream}" : "[data-es-group-stream]",
				"{appFilter}"	: "[data-es-group-app-filter]",
				"{appFilterShowAll}" : "[data-app-filters-showall]",
				"{filterBtn}"	 : "[data-stream-filter-button]",
				"{filterEditBtn}": "[data-dashboardFeeds-Filter-edit]",

				"{filterModeration}": "[data-filter-moderation]",

				// hashtag filter save
				"{saveHashTag}"		: "[data-hashtag-filter-save]",

				"{filterUL}": "[data-es-group-ul]",

				"{joinGroup}": "[data-es-group-join]",
				"{leaveGroup}": "[data-es-group-leave]",
				"{invite}": "[data-es-group-invite]",
				"{respond}": "[data-es-group-respond]",
				"{withdraw}": "[data-es-group-withdraw]",

				'{info}': '[data-info]',
				'{infoItem}': '[data-info-item]',

				view: {
					infoItem: 'info/item'
				}
			}
		}, function(self, options, base) {
				return {
					init : function(){

						options.type = base.data('type');
						options.id = base.data('id');


						// Implement app controller
						self.apps().implement(EasySocial.Controller.Groups.Item.App, {
							"{parent}": self,
							"groupId": options.id
						});
					},

					setActive: function(el) {
						// Remove all active filters
						self.filters().removeClass('active');

						// Add active filter of the element
						el.parent().addClass('active');
					},

					setLoading: function(el) {
						// Empty the contents
						self.content().html('');

						// Add loading class
						self.element.addClass('loading');
					},

					updateContents: function(html) {
						// Once the content is updated, remove the loading class
						self.element.removeClass('loading');

						self.content().html(html);
					},

					"{appFilterShowAll} click" : function(el,event) {
						// Hide itself
						el.hide();

						self.filters().removeClass('hide');
					},

					"{filterEditBtn} click" : function(el, event) {
						event.preventDefault();

						// Update the url
						el.route();

						// Notify the dashboard that it's starting to fetch the contents.
						self.setLoading();

						self.setActive(el);

						EasySocial.ajax( 'site/controllers/groups/getFilter' ,
						{
							"id"			: el.data( 'id' ),
							"clusterId" 	: self.options.id
						})
						.done(function( contents )
						{
							// self.dashboard.updateHeading( title , desc );

							self.updateContents( contents );
						})
						.fail( function( messageObj ){

							return messageObj;
						})
						.always(function(){

						});

					},

					"{filterBtn} click" : function(el, event) {

						// Prevent bubbling up
						event.preventDefault();

						// Update the url
						el.route();

						self.setActive(el);

						// Notify the dashboard that it's starting to fetch the contents.
						self.setLoading();

						EasySocial.ajax( 'site/controllers/groups/getFilter' , {
							"id": 0,
							"clusterId": self.options.id
						}).done(function(contents) {
							self.updateContents(contents);
						}).fail(function(messageObj) {
							return messageObj;
						}).always(function(){
						});

					},

					"{appFilter} click" : function(el, event) {
						event.preventDefault();

						// Get the url and the title
						var url 	= el.data('url'),
							title 	= el.data('title');

						// Set the browser's url
						History.pushState( {state:1} , title , url);

						// Set active class
						self.setActive( el );

						// Set the loading screen
						self.setLoading();

						// Set active menu
						self.setActive(el);

						// Get the id of the app
						var id 	= el.data('id');

						// Perform an ajax to get the group's stream data
						EasySocial.ajax( 'site/controllers/groups/getStream',
						{
							"id" 	: self.options.id,
							"app"	: id,
							"view" 	: "groups"
						})
						.done(function( contents )
						{
							self.updateContents( contents );
						});
					},

					"{filterModeration} click": function(filterModeration, event) {
						event.preventDefault();

						// Update the browser's url
						filterModeration.route();

						// Set the active class to the current filter
						self.setActive(filterModeration);

						// Perform an ajax to get the group's stream data
						EasySocial.ajax('site/controllers/groups/getStream', {
							"id": options.id,
							"view": 'groups',
							"moderation": 1
						}).done(function(contents) {
							self.updateContents(contents);
						});
					},

					"{filterStream} click" : function(el, event) {
						event.preventDefault();

						// Set active class
						self.setActive( el );

						// Set the browser's url
						el.route();

						// Notify the dashboard that it's starting to fetch the contents.
						self.setLoading();

						var currentSidebarMenu = $("[data-dashboardSidebar-menu].active");
						var fid = currentSidebarMenu.data( 'fid' );

						// Perform an ajax to get the group's stream data
						EasySocial.ajax( 'site/controllers/groups/getStream', {
							"id": self.options.id,
							"filterId": fid,
							"view": 'groups',
							"layout": 'item'
						}).done(function(contents) {
							self.updateContents(contents);
						});
					},

					"{saveHashTag} click": function( el )
					{
						var hashtag = el.data('tag');
						var id 		= el.data('id');

						EasySocial.dialog({
							content		: EasySocial.ajax( 'site/views/stream/confirmSaveFilter', { "tag": hashtag } ),
							bindings	:
							{
								"{saveButton} click" : function()
								{
									this.inputWarning().hide();

									filterName = this.inputTitle().val();

									if( filterName == '' )
									{
										this.inputWarning().show();
										return;
									}

									EasySocial.ajax( 'site/controllers/groups/addFilter',
									{
										"title"		: filterName,
										"tag"		: hashtag,
										"id"		: id,
									})
									.done(function( html, msg )
									{
										// self.feeds().append( html );

										var item = $.buildHTML( html );

										self.filterUL().append( item );

										// show message
										EasySocial.dialog( msg );

										// auto close the dialog
										setTimeout(function() {
											EasySocial.dialog().close();
										}, 2000);

									});
								}
							}
						});
					},

					"{withdraw} click" : function( el , event )
					{
						EasySocial.dialog(
						{
							content	: EasySocial.ajax( 'site/views/groups/confirmWithdraw' , { "id" : self.options.id } )
						});
					},

					"{invite} click" : function( el , event )
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'site/views/groups/inviteFriends' , { "id" : self.options.id } )
						})
					},

					"{respond} click" : function( el , event )
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'site/views/groups/confirmRespondInvitation' , { "id" : self.options.id } ),
							bindings: {
								"{rejectButton} click" : function() {
									this.responseValue().val('reject');

									this.form().submit();
								},

								"{acceptButton} click" : function() {
									this.responseValue().val('accept');

									this.form().submit();
								}
							}
						})
					},

					"{joinGroup} click" : function(el, event) {

						// // If this is an open group, hide the join button since the user is already a member of the group
						// if (options.type == 'open') {

						// 	// Add loading
						// 	base.switchClass('is-loading');

						// 	// Join the group and hide the footer
						// 	EasySocial.ajax('site/controllers/groups/joingroup', {
						// 		"id": options.id
						// 	}).done(function() {
						// 		base.switchClass('is-member');
						// 	});

						// 	return;
						// }

						// // If this is a private group, display the standard popup.
						// EasySocial.dialog({
						// 	content: EasySocial.ajax('site/controllers/groups/joinGroup', { "id" : options.id})
						// });

						EasySocial.dialog({
							content: EasySocial.ajax('site/controllers/groups/joinGroup' , { "id" : self.options.id})
						});
					},

					"{leaveGroup} click" : function( el , event )
					{
						EasySocial.dialog({
							content: EasySocial.ajax( 'site/views/groups/confirmLeaveGroup' , { "id" : self.options.id } ),
							bindings: {
								"{leaveButton} click" : function() {
									this.leaveForm().submit();
								}
							}
						})
					},

					'{info} click': function(el, ev) {
						ev.preventDefault();

						el.route();

						self.setActive(el);

						self.setLoading();

						var loaded = el.data('loaded');

						if (loaded) {
							self.infoItem().eq(0).trigger('click');
							return;
						}

						if (el.enabled()) {
							el.disabled(true);

							EasySocial.ajax('site/controllers/groups/initInfo', {
								groupId: self.options.id
							}).done(function(steps) {
								el.data('loaded', 1);

								var parent = el.parent('[data-es-group-filter]');

								// Append all the steps
								$.each(steps.reverse(), function(index, step) {
									if (!step.hide) {
										parent.after(self.view.infoItem({
											url: step.url,
											title: step.title,
											index: step.index
										}));
									}

									if (step.html) {
										self.updateContents(step.html);
										self.content().find('[data-field]').trigger('onShow');
									}
								});

								var item = self.infoItem().eq(0);

								self.setActive(item);

								// Have to set the title
								$(document).prop('title', item.attr('title'));

								el.enabled(true);
							}).fail(function(error) {
								el.enabled(true);
								self.updateContents(error.message);
							});
						}
					},

					'{infoItem} click': function(el, ev) {
						ev.preventDefault();

						el.route();

						self.setActive(el);

						self.setLoading();

						var index = el.data('info-index');

						EasySocial.ajax('site/controllers/groups/getInfo', {
							groupId: self.options.id,
							index: index
						}).done(function(contents) {
							self.updateContents(contents);

							self.content().find('[data-field]').trigger('onShow');
						}).fail(function(error) {
							self.updateContents(error.message);
						});
					}
				}
			}
		);

		EasySocial.Controller(
			'Groups.Item.App',
			{
				defaultOptions:
				{

				}
			},
			function( self )
			{
				return {
					init : function()
					{
						self.options.id 	= self.element.data( 'app-id' );
					},

					"{self} click" : function( el , event )
					{
						// Prevent event from bubbling up
						event.preventDefault();

						// Update the url in the browser
						el.route();

						// Set active element
						self.parent.setActive( el );

						// Set loading class
						self.parent.setLoading();

						// Make an ajax call to get the app contents
						EasySocial.ajax( 'site/controllers/groups/getAppContents' ,
						{
							"appId"		: self.options.id,
							"groupId"	: self.options.groupId
						})
						.done( function( contents )
						{
							self.parent.updateContents( contents );
						})
						.fail(function( messageObj )
						{
							return messageObj;
						});
					}
				}
			}
		);

		EasySocial.Controller('Groups.Item.Members', {
				defaultOptions: {
					"{items}" 	: "[data-group-members-item]",
					"{filters}"	: "[data-group-members-filter]",
					"{content}"	: "[data-group-members-content]"
				}
			},
			function( self )
			{
				return {

					init : function()
					{
						self.options.id 	= self.element.data( 'id' );
						self.items().implement( EasySocial.Controller.Groups.Item.Members.Record );
					},

					"{filters} click" : function( el , event )
					{
						// Remove active
						self.filters().removeClass( 'active' );

						// Set current to active
						el.addClass( 'active' );

						// Get the filter
						var filter 	= el.data( 'filter' );

						// Set the loading class
						self.content().html( '&nbsp;' );
						self.content().addClass( 'is-loading' );

						EasySocial.ajax( 'apps/group/members/controllers/groups/filterMembers' ,
						{
							"id"		: self.options.id,
							"filter" 	: filter
						})
						.done(function( contents )
						{
							// Remove is-loading
							self.content().removeClass( 'is-loading' );

							self.content().html( contents );

							// Re-implement the members record
							self.items().implement(EasySocial.Controller.Groups.Item.Members.Record);
						});
					}
				}
			}
		);

		EasySocial.Controller(
			'Groups.Item.Members.Record',
			{
				defaultOptions:
				{
					"{makeAdmin}"		: "[data-members-make-admin]",
					"{revokeAdmin}"		: "[data-members-revoke-admin]",
					"{approve}"			: "[data-members-approve]",
					"{reject}"			: "[data-members-reject]",
					"{removeMember}"	: "[data-members-remove]",
					"{cancelInvitation}": "[data-members-cancel-invitation]"
				}
			},
			function( self )
			{
				return {
					init : function()
					{
						self.options.id			= self.element.data( 'id' );
						self.options.groupId	= self.element.data( 'groupid' );
					},

					"{approve} click" : function()
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'site/views/groups/confirmApprove' , { "id" : self.options.groupId , "userId" : self.options.id } )
						});
					},

					"{reject} click" : function()
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'site/views/groups/confirmReject' , { "id" : self.options.groupId , "userId" : self.options.id } )
						});
					},

					"{cancelInvitation} click" : function()
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'site/views/groups/confirmCancelInvitation' , { "id" : self.options.groupId , "userId" : self.options.id } )
						});
					},

					"{revokeAdmin} click" : function()
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'site/views/groups/confirmRevokeAdmin' , { "id" : self.options.groupId , "userId" : self.options.id } ),
							bindings:
							{
								"{revokeButton} click" : function()
								{
									EasySocial.ajax( 'site/controllers/groups/revokeAdmin' ,
									{
										"id"		: self.options.groupId,
										"userId"	: self.options.id
									})
									.done(function()
									{
										// Close the dialog once done.
										EasySocial.dialog().close();

										self.element.removeClass( 'is-admin' ).addClass( 'is-member' );
									});

								}
							}
						});
					},

					"{removeMember} click" : function()
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'site/views/groups/confirmRemoveMember' , { "id" : self.options.groupId , "userId" : self.options.id } )
						});
					},

					"{makeAdmin} click" : function()
					{
						EasySocial.dialog(
						{
							content	: EasySocial.ajax( 'site/views/groups/confirmMakeAdmin' , { "id" : self.options.id }),
							bindings:
							{
								"{makeAdminButton} click" : function()
								{
									EasySocial.ajax( 'site/controllers/groups/makeAdmin' ,
									{
										"id"		: self.options.groupId,
										"userId"	: self.options.id
									})
									.done(function()
									{
										// Close the dialog once done.
										EasySocial.dialog().close();

										self.element.removeClass( 'is-member' ).addClass( 'is-admin' );
									});

								}
							}
						})
					}
				}
			}
		);

		EasySocial.Controller(
			'Groups.Item.Discussions',
			{
				defaultOptions:
				{
					"{filter}" 	: "[data-group-discussions-filter]",
					"{contents}": "[data-group-discussion-contents]"
				}
			},
			function(self)
			{
				return {
					init: function()
					{
						self.options.id 	= self.element.data( 'id' );
					},

					setContent: function( html )
					{
						// Remove loading class since we already have the content.
						self.contents().removeClass( 'is-loading' );

						self.contents().html( html );
					},

					setActiveFilter: function( el )
					{
						// Remove active class.
						self.filter().removeClass( 'active' );

						// Add active class to the current element
						el.addClass( 'active' );
					},

					"{filter} click" : function( el , event )
					{
						var filter = el.data( 'filter' );

						// Add loader for the contents area
						self.contents().html( '&nbsp;' ).addClass( 'is-loading' );

						// Set active filter
						self.setActiveFilter( el );

						// Run the ajax call now
						EasySocial.ajax( 'apps/group/discussions/controllers/discussion/getDiscussions' ,
						{
							"id"		: self.options.id,
							"filter" 	: filter
						})
						.done(function( contents , empty )
						{
							if( empty )
							{
								self.contents().addClass( 'is-empty' );
							}
							else
							{
								self.contents().removeClass( 'is-empty' );
							}
							// Set the contents
							self.setContent( contents );
						});
					}
				}
			}
		);
		EasySocial.Controller(
			'Groups.Item.Discussion',
			{
				defaultOptions:
				{
					"{form}"		: "[data-reply-form]",
					"{list}"		: "[data-reply-list]",
					"{replies}"		: "[data-reply-item]",
					"{repliesWrap}"	: "[data-replies-wrapper]",

					"{replyCounter}": "[data-reply-count]",

					"{lock}"		: "[data-discussion-lock]",
					"{unlock}"		: "[data-discussion-unlock]",
					"{delete}"		: "[data-discussion-delete]"
				}
			},
			function( self )
			{
				return {
					init: function()
					{
						self.options.id 		= self.element.data( 'id' );
						self.options.groupId	= self.element.data( 'groupid' );

						self.implementReply( self.replies() );

						self.form().implement( EasySocial.Controller.Groups.Item.Discussion.Form ,
						{
							"{parent}"	: self
						});
					},

					implementReply: function()
					{
						self.replies().implement( EasySocial.Controller.Groups.Item.Discussion.Reply ,
						{
							"{parent}"	: self
						});
					},

					insertReply: function( html )
					{
						// Since we know that we need to append the reply item, we need to remove is-unanswered
						self.element.removeClass( 'is-unanswered' );

						// Since an item is added, we want to remove the empty class.
						self.repliesWrap().removeClass( 'is-empty' );

						// Append the new item
						self.list().append( html );

						// Implement the controller again
						self.implementReply();
					},

					updateReplyCounter: function( total )
					{
						if( total == 0 )
						{
							self.repliesWrap().addClass( 'is-empty' );
						}
						self.replyCounter().html( total );
					},

					setResolved: function()
					{
						self.element.addClass( 'is-resolved' );
					},

					"{unlock} click" : function( el , event )
					{
						EasySocial.ajax( 'apps/group/discussions/controllers/discussion/unlock' ,
						{
							"id" : self.options.id
						})
						.done(function()
						{
							// Add lock element
							self.element.removeClass( 'is-locked' );
						});
					},

					"{delete} click" : function( el , event )
					{
						EasySocial.dialog(
						{
							content : EasySocial.ajax( 'apps/group/discussions/controllers/discussion/confirmDelete' , { "id" : self.options.id , "groupId" : self.options.groupId })
						});
					},

					"{lock} click" : function( el , event )
					{
						EasySocial.dialog(
						{
							content : EasySocial.ajax( 'apps/group/discussions/controllers/discussion/confirmLock' ),
							bindings:
							{
								"{lockButton} click" : function()
								{
									EasySocial.ajax( 'apps/group/discussions/controllers/discussion/lock' ,
									{
										"id" : self.options.id
									})
									.done(function()
									{
										// Hide the dialog
										EasySocial.dialog().close();

										// Add lock element
										self.element.addClass( 'is-locked' );
									});
								}
							}
						});
					}
				}
			}
		);

		EasySocial.Controller(
			'Groups.Item.Discussion.Reply',
			{
				defaultOptions:
				{
					"{acceptAnswer}"	: "[data-reply-accept-answer]",
					"{delete}"			: "[data-reply-delete]",
					"{edit}"			: "[data-reply-edit]",
					"{cancelEdit}"		: "[data-reply-edit-cancel]",
					"{update}"			: "[data-reply-edit-update]",
					"{textarea}"		: "[data-reply-content]",
					"{content}"			: "[data-reply-display-content]",
					"{alertDiv}" 		: "div.alert-error"
				}
			},
			function( self )
			{
				return {
					init: function()
					{
						self.options.id 	= self.element.data( 'id' );
					},
					"{acceptAnswer} click" : function()
					{
						EasySocial.ajax( 'apps/group/discussions/controllers/reply/accept' ,
						{
							"id" : self.options.id
						})
						.done(function()
						{
							self.parent.setResolved();
						});
					},

					cancelEditing : function()
					{
						self.element.removeClass( 'is-editing' );
					},

					"{cancelEdit} click" : function()
					{
						self.cancelEditing();
					},

					"{edit} click" : function()
					{
						self.element.addClass( 'is-editing' );
					},

					"{update} click" : function()
					{
						var content 	= self.textarea().val();

						// console.log( self.element);

						// If content is empty, throw some errors
						if( content == '' )
						{
							self.element.addClass( 'is-empty' );
							self.alertDiv().show();
							return false;
						}

						EasySocial.ajax( 'apps/group/discussions/controllers/reply/update' ,
						{
							"id"		: self.options.id,
							"content"	: content
						})
						.done(function( content )
						{
							// Update the content
							self.content().html( content );

							self.element.removeClass( 'is-empty' );
							self.alertDiv().hide();


							// Hide the textarea
							self.cancelEditing();
						});
					},

					"{delete} click" : function()
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'apps/group/discussions/controllers/reply/confirmDelete' , { "id"	: self.options.id } ),
							bindings	:
							{
								"{deleteButton} click" : function()
								{
									EasySocial.ajax( 'apps/group/discussions/controllers/reply/delete',
									{
										"id"	: self.options.id
									})
									.done(function( discussion )
									{
										// Update the counter
										self.parent.updateReplyCounter( discussion.total_replies );

										// Hide the dialog
										EasySocial.dialog().close();

										// Remove the element
										self.element.remove();
									});
								}
							}
						});
					}
				}
			}
		);

		EasySocial.Controller(
			'Groups.Item.Discussion.Form',
			{
				defaultOptions:
				{
					"{textarea}"	: "[data-reply-content]",
					"{submitReply}" : "[data-reply-submit]"
				}
			},
			function( self )
			{
				return {
					init: function()
					{
					},
					"{submitReply} click" : function( el , event )
					{
						var content 	= self.textarea().val();

						// If content is empty, throw some errors
						if( content == '' )
						{
							self.element.addClass( 'is-empty' );
							return false;
						}

						EasySocial.ajax( 'apps/group/discussions/controllers/reply/submit' ,
						{
							"id"		: self.parent.options.id,
							"groupId"	: self.parent.options.groupId,
							"content"	: content
						})
						.done(function( html )
						{
							// Inser the new node back.
							self.parent.insertReply( html );

							// Update the textarea
							self.textarea().val( '' );
						});

					}
				}
			}
		);

		EasySocial.Controller('Groups.Item.News', {
				defaultOptions: {
					"{delete}" 			: "[data-news-delete]",
					"{likes}"			: "[data-likes-action]",
					"{counter}"			: "[data-news-counter]",
					"{likeContent}" 	: "[data-likes-content]",
				}
			}, function(self) {
				return {

					init : function()
					{
						self.options.id 	= self.element.data( 'id' );
						self.options.groupId = self.element.data( 'group-id' );
					},

					//need to make the data-stream-counter visible
					"{likes} onLiked": function(el, event, data) {
						self.counter().removeClass('hide');
					},

					"{likes} onUnliked": function(el, event, data) {
						var hideCounter 	= self.likeContent().hasClass( 'hide' );

						if( hideCounter )
						{
							self.counter().addClass( 'hide' );
						}
					},
					"{delete} click" : function( el , event )
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'apps/group/news/controllers/news/confirmDelete' , { "id" : self.options.id , "groupId" : self.options.groupId })
						});
					}
				}
			}
		);

		module.resolve();
	});
});



EasySocial.module( "site/notifications/list", function($){

	var module = this;


	EasySocial.require()
	.done( function($)
	{
		EasySocial.Controller( 'NotificationsList',
		{
			defaultOptions:
			{
				"{item}"		: "[data-notifications-list-item]",
				"{list}" 		: "[data-notifications-list]",
				"{allread}" 	: "[data-notification-all-read]",
				"{allclear}" 	: "[data-notification-all-clear]",

				"{notiLoadMoreBtn}" : "[data-notification-loadmore-btn]"
			}
		},
		function( self )
		{
			return {
				init : function()
				{
					self.item().implement( EasySocial.Controller.NotificationsList.Item ,
						{
							"{parent}"	: self
						});
				},

				"{allread} click" : function()
				{
					EasySocial.ajax( 'site/controllers/notifications/setAllState' ,
					{
						"state"	: "read"
					})
					.done(function()
					{
						self.item().removeClass( 'is-read is-hidden is-unread' ).addClass( 'is-read' );
					});
				},

				"{allclear} click" : function()
				{
					// show dialog to get confimation from user.
					var dialog =
						EasySocial.dialog({
							content: EasySocial.ajax(
								"site/views/notifications/clearAllConfirm"
							),
							bindings: {
								"{clearButton} click": function() {

									EasySocial.ajax( 'site/controllers/notifications/setAllState' ,
									{
										"state"	: "clear"
									})
									.done(function()
									{
										self.item().removeClass( 'is-read is-hidden is-unread is-read' ).addClass( 'is-remove' );
										EasySocial.dialog().close();
									});

								}
							}
						});
				},

				"{notiLoadMoreBtn} click" : function( el, event )
				{
					var startlimit 	= $(el).data( 'startlimit' );
					if( startlimit < 0 )
					{
						return;
					}

					EasySocial.ajax( 'site/controllers/notifications/loadmore' ,
					{
						"startlimit" : startlimit
					})
					.done(function( contents, nextlimit )
					{
						// update next limit
						$(el).data( 'startlimit', nextlimit );

						if( contents.length > 0 )
						{
							$.buildHTML(contents)
							 	.insertBefore( self.notiLoadMoreBtn() );
							 	// .addController("NotificationsList.Item");

							 //add controller
							 self.item().implement( EasySocial.Controller.NotificationsList.Item );
						}

						if( nextlimit < 0)
						{
							// no more item. let hide the loadmore button.
							self.notiLoadMoreBtn().hide();
						}

					})
					.fail( function( messageObj ){
						return messageObj;
					})
					.always(function(){

						// self.loading = false;
					});


				}



			}
		});

		EasySocial.Controller( 'NotificationsList.Item' ,
		{
			defaultOptions :
			{
				"{unread}"	: "[data-notifications-list-item-unread]",
				"{read}"	: "[data-notifications-list-item-read]",
				"{delete}"	: "[data-notifications-list-item-delete]"
			}
		},
		function(self)
		{
			return {
				init : function()
				{
					self.options.id 	= self.element.data( 'id' );

				},

				"{unread} click" : function()
				{
					EasySocial.ajax( 'site/controllers/notifications/setState' ,
					{
						"id"	: self.options.id,
						"state"	: "unread"
					})
					.done(function()
					{
						self.element.removeClass( 'is-read is-hidden is-unread' ).addClass( 'is-unread	' );
					});
				},

				"{read} click" : function()
				{
					EasySocial.ajax( 'site/controllers/notifications/setState' ,
					{
						"id"	: self.options.id,
						"state"	: "read"
					})
					.done(function()
					{
						self.element.removeClass( 'is-read is-hidden is-unread' ).addClass( 'is-read' );
					});
				},

				"{delete} click" : function()
				{


					var dialog =
						EasySocial.dialog({
							content: EasySocial.ajax(
								"site/views/notifications/clearConfirm"
							),
							bindings: {
								"{clearButton} click": function() {

									EasySocial.ajax( 'site/controllers/notifications/setState' ,
									{
										"id"	: self.options.id,
										"state"	: "clear"
									})
									.done(function()
									{
										self.element.removeClass( 'is-read is-hidden is-unread is-read' ).addClass( 'is-remove' );
										EasySocial.dialog().close();
									})
									.fail(function( msg )
									{
										EasySocial.dialog({
											content: msg.message
										});
									});
								}
							}
						});



					// EasySocial.ajax( 'site/controllers/notifications/setState' ,
					// {
					// 	"id"	: self.options.id,
					// 	"state"	: "hidden"
					// })
					// .done(function()
					// {
					// 	self.element.removeClass( 'is-read is-hidden is-unread' ).addClass( 'is-hidden' );
					// });


				}
			}
		});

		module.resolve();
	});

});

EasySocial.module( 'site/points/history' , function(){

	var module	= this;

	EasySocial.require()
	.done(function($)
	{
		EasySocial.Controller(
			'Points.History',
			{
				defaultOptions :
				{
					"{loadMore}"	: "[data-points-history-pagination]",
					"{timeline}"	: "[data-points-history-timeline]"
				}
			},
			function( self )
			{
				return {
					init : function()
					{
					},

					"{loadMore} click" : function( el , event )
					{
						var current 	= $( el ).data( 'current' );

						EasySocial.ajax( 'site/views/points/getHistory' , 
						{
							"limitstart"	: current,
							"id"			: self.options.id
						}).done(function( contents , nextLimit , done )
						{
							self.timeline().append( contents );

							$( el ).data( 'current' , nextLimit );

							if( done )
							{
								$( el ).hide();
								// $( el ).attr( 'disabled' , 'disabled' );
							}
						});
					}
				}
			});

		module.resolve();
	});
});

EasySocial.module( 'site/profile/about', function($){
	var module = this;

	EasySocial.require().script('field').library('history').done(function($) {
		EasySocial.Controller('Profile.About', {
			defaultOptions: {
				'{stepItem}'	: '[data-profile-about-step-item]',
				'{stepContent}'	: '[data-profile-about-step-content]',

				'{fieldItem}'	: '[data-field]'
			}
		}, function(self) {
			return {
				init: function() {
					self.fieldItem().addController('EasySocial.Controller.Field.Base', {
						mode: 'display'
					});
				},

				'{stepItem} click': function(el, ev) {
					ev.preventDefault();

					el.find('a').route();

					var target = el.data('for');

					self.stepItem().removeClass('active');

					el.addClass('active');

					self.stepContent().filterBy('id', target).trigger('activateTab');
				},

				'{stepContent} activateTab': function(el, ev) {
					self.stepContent().removeClass('active');

					el.addClass('active');

					el.find(self.fieldItem.selector).trigger('onShow');
				}
			}
		});

		module.resolve();
	});
});

EasySocial.module( 'site/profile/edit' , function($){

	var module 				= this;

	EasySocial.require()
	.script( 'validate', 'field', 'oauth/facebook' )
	.done(function($){

		EasySocial.Controller(
			'Profile.Edit',
			{
				defaultOptions:
				{
					userid				: null,

					"{stepContent}"		: "[data-profile-edit-fields-content]",
					"{stepItem}"		: "[data-profile-edit-fields-step]",

					// Forms.
					"{profileForm}"		: "[data-profile-fields-form]",

					// Content for profile editing
					"{profileContent}"	: "[data-profile-edit-fields]",

					"{fieldItem}"		: "[data-profile-edit-fields-item]",

					// Submit buttons
					"{save}"			: "[data-profile-fields-save]",
					"{saveClose}"		: "[data-profile-fields-save-close]",

					// Delete Profile
					"{deleteProfile}"	: "[data-profile-edit-delete]",

					'{taskInput}'		: 'input[name="task"]'
				}
			},
			function( self )
			{
				return {

					init: function()
					{
						self.fieldItem().addController('EasySocial.Controller.Field.Base', {
							userid: self.options.userid,
							mode: 'edit'
						});
					},

					errorFields: [],

					// Support field throwing error internally
					'{fieldItem} error': function(el, ev) {
						self.triggerStepError(el);
					},

					// Support for field resolving error internally
					'{fieldItem} clear': function(el, ev) {
						self.clearStepError(el);
					},

					// Support validate.js throwing error externally
					'{fieldItem} onError': function(el, ev) {
						self.triggerStepError(el);
					},

					triggerStepError: function(el) {
						var fieldid = el.data('id'),
							stepid = el.parents(self.stepContent.selector).data('id');

						if($.inArray(fieldid, self.errorFields) < 0 ) {
							self.errorFields.push(fieldid);
						}

						self.stepItem().filterBy('for', stepid).trigger('error');
					},

					clearStepError: function(el) {
						var fieldid = el.data('id'),
							stepid = el.parents(self.stepContent.selector).data('id');

						self.errorFields = $.without(self.errorFields, fieldid);

						self.stepItem().filterBy('for', stepid).trigger('clear');
					},

					"{stepItem} click" : function( el , event )
					{
						var id 	= $(el).data('for');

						// Profile form should be hidden
						self.profileContent().show();

						// Remove active class on step item
						self.stepItem().removeClass('active');

						// Add active class on the selected item.
						el.addClass('active');

						// Remove active class on step content
						self.stepContent().removeClass('active');

						// Get the step content element
						var stepContent = self.stepContent().filterBy('id', id);


						// Add active class on the selected content
						stepContent.addClass('active');

						// Trigger onShow on the field item in the content
						stepContent.find(self.fieldItem.selector).trigger('show');
					},

					"{stepItem} error": function(el) {
						el.addClass('error');
					},

					"{stepItem} clear": function(el) {
						if(self.errorFields.length < 1) {
							el.removeClass('error');
						}
					},

					"{save} click" : function( el , event )
					{
						// Run some error checks here.
						event.preventDefault();

						$( el ).addClass( 'btn-loading' );

						self.profileForm()
							.validate()
							.fail( function()
							{
								$( el ).removeClass( 'btn-loading' );
								EasySocial.dialog(
								{
									content 	: EasySocial.ajax( 'site/views/profile/showFormError' )
								});
							})
							.done( function()
							{
								self.taskInput().val('save');
								self.profileForm().submit();
							});

						return false;
					},

					"{saveClose} click": function(el, event)
					{
						// Run some error checks here.
						event.preventDefault();

						$(el).addClass('btn-loading');

						self.profileForm()
							.validate()
							.fail(function()
							{
								$(el).removeClass('btn-loading');
								EasySocial.dialog(
								{
									content: EasySocial.ajax('site/views/profile/showFormError')
								});
							})
							.done(function()
							{
								self.taskInput().val('saveclose');
								self.profileForm().submit();
							});

						return false;
					},

					"{deleteProfile} click" : function()
					{
						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'site/views/profile/confirmDelete' )
						});
					}
				}
		});

		module.resolve();
	});

});

EasySocial.module('site/profile/feeds', function($){

	var module 				= this;

	EasySocial.require()
	.library('history')
	.done(function($){

		EasySocial.Controller(
			'Profile.Feeds',
			{
				defaultOptions:
				{
					"{menuItem}"	: "[data-profileSidebar-menu]",
					"{item}"	: "[data-profileFeeds-item]",
					"{filter}"	: "[data-profileFeeds-Filter-edit]"
				}
			},
			function(self){

				return{

					init : function()
					{ 
						// Implement each feed links.
						self.item().implement(EasySocial.Controller.Profile.Feeds.Item, {
							"{parent}"	: self,
							"{profile}"	: self.parent
						});
					},

					"{menuItem} click" : function( el , event )
					{
						// Remove all active class.
						self.menuItem().removeClass( 'active' );

						// Add active class on this item.
						$( el ).addClass( 'active' );
					},

					addFilterItem: function(feed)
					{
						feed.find('[data-profileFeeds-item]').implement(EasySocial.Controller.Profile.Feeds.Item, {
							"{parent}"	: self,
							"{profile}"	: self.parent
						});

						feed.appendTo(self.element);
					}
				}
			});

		EasySocial.Controller('Profile.Feeds.Item', {
			defaultOptions:
			{
			}
		}, function(self) {
			return{

				clicked: false,

				init : function()
				{
				},

				"{self} click" : function()
				{ 
					//remove no-stream class if any
					$('.es-streams').removeClass( 'no-stream' );

					var type = self.element.data( 'type' ),
						id = self.element.data( 'id' ),
						url = self.element.data( 'url' ),
						title = self.element.data( 'title' ),
						desc = self.element.data( 'description' );

					if (self.clicked) {
						return;
					}

					self.clicked = true;

					// clear the new feed notification counter.
					var key = '[data-stream-counter-';
					
					if (type == 'list') {
						key = key + type + '-' + id;
					} else {
						key = key + type;
					}

					key = key + ']';
					
					$(key).html( '0' );

					// clear new feed counter
					self.element.removeClass('has-notice');

					// If this is an embedded layout, we need to play around with the push state.
					History.pushState( {state:1} , title , url );

					// Notify the profile that it's starting to fetch the contents.
					self.profile.contents().html("");
					self.profile.updatingContents();

					self.element.addClass('loading');

					EasySocial.ajax( 'site/controllers/profile/getStream', {
						"type"	: type,
						"id"	: id,
						"view"  : 'profile',
					})
					.done(function(contents, count) {
						
						if (count == 0) {
							$('.es-streams').addClass( 'no-stream' );
						}

						// Trigger change for the stream
						self.trigger('onStreamUpdate', [type]);

						window.streamFilter = type;

						self.profile.updateContent(contents);

						// add support to kunena [tex] replacement.
						try { MathJax && MathJax.Hub.Queue(["Typeset",MathJax.Hub]); } catch( err ) {};

					}).fail(function(messageObj) {
						return messageObj;
					}).always(function() {
						self.clicked	= false;
						self.element.removeClass('loading');
					});


				}
			}
		});
		module.resolve();
	});

});


EasySocial.module( 'site/profile/friends' , function($){

	var module 				= this;

	EasySocial.require()
	.view( 'site/loading/small')
	.language(
		'COM_EASYSOCIAL_FRIENDS_DIALOG_CANCEL_REQUEST',
		'COM_EASYSOCIAL_CANCEL_BUTTON',
		'COM_EASYSOCIAL_YES_CANCEL_MY_REQUEST_BUTTON'
	)
	.done(function($){

		EasySocial.Controller(
			'Profile.Friends.Request',
			{
				defaultOptions:
				{
					id 		: null,
					callback		: null,

					// Elements
					"{addButton}"		: "[data-profileFriends-add]",
					"{manageButton}"	: "[data-profileFriends-manage]",
					"{pendingButton}"	: "[data-profileFriends-pending]",
					"{respondButton}"	: "[data-profileFriends-respond]",
					"{cancelRequest}"	: "[data-profileFriends-cancelRequest]",

					"{unfriend}"		: "[data-profile-friends-unfriend]",
					"{approve}"			: "[data-friends-response-approve]",
					"{reject}"			: "[data-friends-response-reject]",

					// The current add friend / cancel friend btuton.
					"{button}"			: "[data-profileFriends-button]",

					// Dropdown
					"{dropdown}"		: "[data-profileFriends-dropdown]",

					view :
					{
						loader 			: "site/loading/small",
					}
				}
			},
			function(self)
			{
				return{

					init: function()
					{
						// Set the friend id.
						self.options.id 		= self.element.data( 'friend' );

						// Set the target id
						self.options.target 	= self.element.data( 'id' );

						// Set the callback url
						self.options.callback 	= self.element.data( 'callback' );
					},

					showDropDown : function()
					{
						self.element.addClass( 'open' );
					},

					hideDropDown : function()
					{
						self.element.removeClass( 'open' );
					},

					"{addButton} click" : function( el ) {

						var button = self.button();

						button.addClass("loading");

						EasySocial.ajax("site/controllers/friends/request", {
								id: self.options.target
							})
							.done(function(friendId, button) {

								// Remove any previous dropdown
								self.dropdown().remove();

								// After the request is complete, set the correct friend id.
								self.options.id = friendId;

								// Replace the button
								self.button().replaceWith(button);
							}).fail(function(obj){

								EasySocial.dialog({
									content: obj.message
								});

								button.removeClass("loading");
							});
					},

					"{cancelRequest} click" : function(el , event) {
						// If user can click on the cancel request, they should have a valid friend id by now.
						var friendId 	= self.options.id;

						// Hide any dropdown that's open
						self.hideDropDown();

						// Show confirmation dialog
						EasySocial.dialog({
							content: EasySocial.ajax( 'site/views/friends/confirmCancel' ),
							bindings:
							{
								"{confirmButton} click": function()
								{
									EasySocial.ajax( 'site/controllers/friends/cancelRequest' ,
									{
										"id"	: self.options.id
									})
									.done( function( button )
									{
										// Remove any previous dropdowns.
										self.dropdown().remove();

										// Update the button
										self.button().replaceWith( button );

										// Hide the dialog once the request has been cancelled.
										EasySocial.dialog().close();
									});
								}
							}
						});

					},

					"{unfriend} click" : function( el , event )
					{
						var userId 	= $( el ).data( 'id' );
						// Implement controller on add friend.
						EasySocial.dialog(
						{
							content		: EasySocial.ajax( 'site/views/friends/confirmUnfriend' , { "id"	: userId } ),
							bindings 	:
							{
								"{unfriendButton} click" : function()
								{
									EasySocial.ajax( 'site/controllers/friends/unfriend' ,
									{
										"id"	: self.options.id
									})
									.done(function( button )
									{
										// Remove any previous dropdowns.
										self.dropdown().remove();

										// Update the button
										self.button().replaceWith( button );

										// Close the dialog
										EasySocial.dialog().close();
									});
								}
							}
						});
					},

					"{approve} click" : function( el , event )
					{
						var friendId 	= self.options.id;

						// Hide dropdown
						self.hideDropDown();

						EasySocial.ajax( 'site/controllers/friends/approve' ,
						{
							"id"	: friendId
						})
						.done( function( button )
						{
							// Replace the button.
							self.button().replaceWith( button );
						});
					},

					"{reject} click" : function( el , event )
					{
						var friendId 	= self.options.id;

						// Hide dropdown
						self.hideDropDown();

						EasySocial.dialog(
						{
							content 	: EasySocial.ajax( 'site/views/friends/confirmReject' ),
							bindings :
							{
								"{rejectButton} click" : function()
								{
									EasySocial.ajax( 'site/controllers/friends/reject' ,
									{
										"id"	: friendId
									})
									.done( function( button )
									{
										// Update the button.
										self.button().replaceWith( button );

										EasySocial.dialog(
										{
											content 	: EasySocial.ajax( 'site/views/friends/friendRejected' ),
										});

									});


								}
							}
						});
					},

					"{dropdown} click" : function( el , event )
					{
						// Disallow clicking of events to trigger parent items.
						event.stopPropagation();
					},

					"{approveRequest} click" : function()
					{
						// Update the task
						self.respondForm().find( 'input[name=task]' ).val( 'approve' );

						// Update the friend id
						self.respondForm().find( 'input[name=id]' ).val( self.options.friendId );

						// Update the return url.
						self.respondForm().find( 'input[name=return]' ).val( self.options.callback );

						// Submit the form.
						self.respondForm().submit();
					}
				}
		});


		module.resolve();
	});

})

EasySocial.module( 'site/profile/header' , function($){

	var module 				= this;

	EasySocial.require()
	.script(
		'site/profile/friends' ,
		'site/profile/subscriptions' ,
		'site/conversations/composer'
	)
	.done(function($){

		EasySocial.Controller(
			'Profile.Header',
			{
				defaultOptions:
				{
					// Properties
					id			: null,

					// Elements
					"{friendRequest}"	: "[data-profile-friends]",
					"{subscribe}"		: "[data-profile-followers]",
					"{conversation}"	: "[data-profile-conversation]"
				}
			},
			function(self)
			{
				return {

					init: function()
					{
						// Get the id of the current user.
						self.options.id 	= self.element.data( 'id' ),
						self.options.name 	= self.element.data( 'name' ),
						self.options.avatar	= self.element.data( 'avatar' );

						// Implement friends controller on the friend request button.
						self.friendRequest().implement( EasySocial.Controller.Profile.Friends.Request,
						{
							"{parent}"	: self
						});

						// Implement subscription controller on the subscribe button.
						self.subscribe().implement( EasySocial.Controller.Profile.Subscriptions,
						{
							"{parent}"	: self
						});

						self.conversation().implement( EasySocial.Controller.Conversations.Composer.Dialog,
						{
							"recipient"	:
							{
								"id"	: self.options.id,
								"name"	: self.options.name,
								"avatar": self.options.avatar
							}
						});
					}
				}
			}
		);


		module.resolve();
	});


});

EasySocial.module( 'site/profile/subscriptions' , function($){

	var module 				= this;

	EasySocial.Controller(
		'Profile.Subscriptions',
		{
			defaultOptions:
			{
				// Properties
				id			: null,

				"{follow}"	: "[data-subscription-follow]",
				"{unfollow}": "[data-subscription-unfollow]",
				"{message}"	: "[data-subscription-message]",
				"{button}"	: "[data-subscription-button]"
			}
		},
		function(self)
		{
			return{

				init: function()
				{
					self.options.id 	= self.element.data( 'id' );
				},

				toggleDropDown : function()
				{
					self.element.toggleClass( 'open' );
				},

				"{unfollow} click" : function()
				{
					// Toggle dropdown.
					self.toggleDropDown();

					// Let's do an ajax call to follow the user.
					EasySocial.ajax( 'site/controllers/profile/unfollow' ,
					{
						"id"	: self.options.id,
						"type"	: 'user'
					})
					.done(function(button)
					{
						self.button().replaceWith( button );
					})
				},

				"{follow} click" : function()
				{
					// Toggle dropdown.
					self.toggleDropDown();

					// Let's do an ajax call to follow the user.
					EasySocial.ajax( 'site/controllers/profile/follow' ,
					{
						"id"	: self.options.id,
						"type"	: 'user'
					})
					.done(function( button )
					{
						self.button().replaceWith( button );
					});
				}
			}
		});

		module.resolve();

});

EasySocial.module( 'site/profile/miniheader' , function($){

	var module = this;

	EasySocial.require()
	.library(
		'scrollTo'
	)
	.done(function($){

		EasySocial.Controller(
			'Profile.MiniHeader',
			{
				defaultOptions: {

					"{viewport}": "[data-appscroll-viewport]",
					"{content}": "[data-appscroll-content]",
					"{apps}": "[data-appscroll-content] li",
					"{buttons}": "[data-appscroll-buttons]",
					"{nextButton}": "[data-appscroll-next-button]",
					"{prevButton}": "[data-appscroll-prev-button]"
				}
			},
			function(self){ return {

				init: function() {

					self.setLayout();

					// When page is refreshed, scroll value might be retained.
					self.viewport().scrollTo(0);
				},

				"{window} resize": $.debounce(function(){

					self.setLayout();

				}, 300),

				setLayout: function() {

					var viewport = self.viewport(),
						width = 5;

					if ($(".es-main").hasClass("w480")) {

						self.content().css({
							width: "auto"
						});

						self.enabled = false;

						return;
					}

					self.apps().each(function(){ width += $(this).outerWidth(true) });

					if (width > viewport.width()) {

						self.content()
							.css({
								width: width,
								float: "none"
							});

						self.buttons()
							.css("opacity", 1);

						self.enabled = true;
					}
				},

				enabled: false,

				"{nextButton} click": function() {

					if (!self.enabled) return;

					var viewport = self.viewport(),
						width = viewport.width() - 80; // 80 offset

					viewport.scrollTo('+=' + width + 'px', 800, {axis: 'x', easing: 'easeInOutCubic'});
				},

				"{prevButton} click": function() {

					if (!self.enabled) return;

					var viewport = self.viewport(),
						width = viewport.width() - 80; // 80 offset

					viewport.scrollTo('-=' + width + 'px', 800, {axis: 'x', easing: 'easeInOutCubic'});
				}

			}});


		module.resolve();
	});


});

EasySocial.module('site/profile/notifications', function($) {

	var module = this;

	EasySocial.require()
		.script('site/profile/header')
		.done(function() {
			EasySocial.Controller('Profile.Notifications', {
				defaultOptions: {
					// App item
					"{sidebarItem}"	: "[data-notification-item]",
					"{contentItem}"	: "[data-notification-content]",

					//input form
					"{notificationForm}" : "[data-notifications-form]"
				},
			}, function(self) {
				return {

					init : function() {
					},

					"{sidebarItem} click": function(el, event) {
						self.sidebarItem().removeClass('active');

						el.addClass('active');

						self.contentItem().hide();

						var element = el.data('alert-element');

						self.contentItem('[data-alert-element="' + element + '"]').show();
					}
				}
			});

			module.resolve();
		});
});

EasySocial.module( 'site/profile/privacy' , function($){

	var module 	= this;

	EasySocial.require()
	.script( 'site/profile/header' )
	.library( 'history', 'textboxlist' )
	.view( 'site/loading/small' )
	.done(function($){

		EasySocial.Controller(
			'Profile.Privacy',
			{
				defaultOptions:
				{
					// App item
					"{sidebarItem}"	: "[data-profile-privacy-item]",
					"{contentItem}"	: "[data-privacy-content]",

					"{privacyItem}" : "[data-privacy-item]",

					//input form
					"{privacyForm}" : "[data-profile-privacy-form]",

					"{formActions}": "[data-form-actions]",

					view :
					{
						loading : "site/loading/small"
					}
				}
			},
			function( self )
			{
				return {

					init : function()
					{
						// Implement profile header.
						self.sidebarItem().implement( EasySocial.Controller.Profile.Privacy.Sidebar ,
						{
							"{parent}"	: self
						});

						self.privacyItem().implement( EasySocial.Controller.Profile.Privacy.Item ,
						{
							"{parent}"	: self
						});
					},

					updateContent : function(group)
					{
						// Hide the contents first
						self.contentItem().hide();

						// Only display the appropriate group
						$('.privacy-content-' + group).show();

						if (group == 'blocked') {
							self.formActions().hide();
						} else {
							self.formActions().show();
						}
					}
				}
			}
		);

		EasySocial.Controller(
			'Profile.Privacy.Sidebar',
			{
				defaultOptions :
				{
					"{sidebarItem}"		: "[data-profile-privacy-item]",
				}
			},
			function( self )
			{
				return {
					init : function()
					{

					},

					"{self} click" : function( el )
					{
						// Prevent from bubbling up.
						// event.preventDefault();

						$('[data-profile-privacy-item]').removeClass( 'active' );
						$( el ).addClass( 'active' );

						var group = self.element.data( 'group' );
						self.parent.updateContent( group );
					}
				}
			});


		EasySocial.Controller(
			'Profile.Privacy.Item',
			{
				defaultOptions :
				{
					"{selection}"		: "[data-privacy-select]",
					"{hiddenCustom}" 	: "[data-hidden-custom]",
					"{customForm}" 		: "[data-privacy-custom-form]",

					"{customTextInput}" : "[data-textfield]",
					"{customItems}"		: "input[]",
					"{customHideBtn}"	: "[data-privacy-custom-hide-button]",
					"{customInputItem}"	: "[data-textboxlist-item]",
					"{customEditBtn}"   : "[data-privacy-custom-edit-button]"
				}
			},
			function( self )
			{
				return {
					init : function()
					{

						self.customTextInput().textboxlist(
							{
								component: 'es',
								unique: true,
								plugin: {
									autocomplete: {
										exclusive: true,
										minLength: 2,
										cache: false,
										query: function( keyword ) {

											var users = self.getTaggedUsers();

											var ajax = EasySocial.ajax("site/views/privacy/getfriends", {
												q: keyword,
												exclude: users
											});
											return ajax;
										}
									}
								}
							}
						);

						self.textboxlistLib = self.customTextInput().textboxlist("controller");
					},

					getTaggedUsers: function()
					{
						var users = [];
						var items = self.customInputItem();

						if( items.length > 0 )
						{
							$.each( items, function( idx, element ) {
								users.push( $( element ).data('id') );
							});
						}

						return users;
					},

					// event listener for adding new name
					"{customTextInput} addItem": function(el, event, data) {

						// lets get the exiting ids string
						var ids    = self.hiddenCustom().val();
						var values = '';

						if( ids == '')
						{
							values = data.id;
						}
						else
						{
							var idsArr = ids.split(',');
							idsArr.push( data.id );

							values = idsArr.join(',');
						}

						//now update the customhidden value.
						self.hiddenCustom().val( values );
					},

					// event listener for removing name
					"{customTextInput} removeItem": function(el, event, data ) {
						// lets get the exiting ids string
						var ids    = self.hiddenCustom().val();
						var values = '';
						var newIds = [];

						var idsArr = ids.split(',');

						for( var i = 0; i < idsArr.length; i++ )
						{
							if( idsArr[i] != data.id )
							{
								newIds.push( idsArr[i] );
							}
						}

						if( newIds.length <= 0 )
						{
							values = '';
						}
						else
						{
							values = newIds.join(',');
						}

						//now update the customhidden value.
						self.hiddenCustom().val( values );
					},

					"{customEditBtn} click" : function( el )
					{
						self.customForm().toggle();
					},

					"{selection} change" : function( el )
					{
						var selected = el.val();

						if( selected == 'custom' )
						{
							self.customForm().show();
							self.customEditBtn().show();
						}
						else
						{
							self.customForm().hide();
							self.customEditBtn().hide();
						}

						return;
					},

					"{customHideBtn} click" : function()
					{
						self.customForm().hide();

						self.customEditBtn().show();

						self.textboxlistLib.autocomplete.hide();

						return;
					}
				}
			});


		module.resolve();
	});

});

EasySocial.module( 'site/profile/profile' , function($){

	var module 	= this;

	EasySocial.template('info/item', '<li data-profile-apps-item data-layout="custom"><a class="ml-20" href="[%= url %]" title="[%= title %]" data-info-item data-info-index="[%= index %]"><i class="ies-info ies-small mr-5"></i> [%= title %]</a></li>');

	EasySocial.require()
	.script('site/profile/header', 'site/profile/feeds')
	.library('history')
	.done(function($){

		EasySocial.Controller(
			'Profile',
			{
				defaultOptions:
				{
					// The current user being viewed
					id 	: null,

					// Elements
					"{header}"	: "[data-profile-header]",

					// App item
					"{feeds}"	: "[data-profile-feeds]",
					"{app}"		: "[data-profile-apps-item]",
					"{action}"	: "[data-profile-apps-menu]",
					"{showAllFilters}"	: "[data-app-filters-showall]",
					"{appFilters}"		: "[data-sidebar-app-filter]",

					// Contents
					"{contents}"	: "[data-profile-real-content]",

					// Sidebar
					"{sidebar}"      : "[data-sidebar]",
					"{sidebarToggle}": "[data-sidebar-toggle]",

					'{info}': '[data-info]',
					'{infoItem}': '[data-info-item]',

					view: {
						infoItem: 'info/item'
					}
				}
			},
			function(self) { return {

					init : function() {

						// Get the user's id.
						self.options.id = self.element.data('id');

						// Implement profile header.
						self.header().implement(EasySocial.Controller.Profile.Header, {
							"{parent}"	: self
						});

						// Implement app controller on all app items.
						self.feedsController = self.feeds().addController(EasySocial.Controller.Profile.Feeds, {
							"{parent}"	: self
						});

						// Set layout on document ready
						$(function(){
							self.setLayout();
						});

						// Set layout on responsive event
						$(".es-responsive").on("responsive", function(){
							self.setLayout();
						});
					},

					setLayout: function() {

						var sidebar = self.sidebar(),
							sidebarToggle = self.sidebarToggle();

						if (sidebarToggle.is(":visible")) {

							var container =
								$('<div class="es-container responsive">')
									.append(sidebar)
									.insertAfter(sidebarToggle);
						} else {
							$(".es-profile .es-container:not(.responsive)").prepend(sidebar);
							$(".es-profile .es-container.responsive").remove();
						}
					},

					"{sidebarToggle} sidebarToggle": function(sidebarToggle) {

						self.setLayout();
					},

					"{app} click" : function( el , event )
					{
						// Remove active class.
						self.app().removeClass( 'active' );

						// Add active class to this current item.
						$( el ).addClass( 'active' );

						// Prevent from bubbling up
						event.preventDefault();

						var data = el.data();

						if(data.layout === 'canvas')
						{
							window.location = data[data.layout + 'Url'];
							return;
						}

						// Since 1.3
						// Added support for custom items
						if (data.layout === 'custom') {
							return;
						}

						History.pushState({state: 1}, data.title, data[data.layout + 'Url'] );

						if(self.sidebarToggle().is(':visible'))
						{
							$.scrollTo(self.contents());
						}

						EasySocial.ajax(data.namespace, {
							id: data.id,
							view: 'profile',
							appId: data.appId
						}, {
							beforeSend: function() {
								self.loading();
							}
						}).done(function(contents) {
							self.updateContent(contents);
						}).fail(function(messageObj) {
							return messageObj;
						});
					},


					"{showAllFilters} click" : function( el , event )
					{
						$(el).hide();

						self.appFilters().removeClass( 'hide' );
					},

					updateContent : function( content )
					{
						self.element.removeClass("loading");

						self.contents().html( content );
					},

					/**
					 * Add a loading icon on the content layer.
					 */
					updatingContents: function()
					{
						self.element.addClass("loading");
					},

					loading: function()
					{
						// self.contents().html( self.view.loading({}) );
						self.contents().html("");
						self.element.addClass("loading");
					},

					'{info} click': function(el, ev) {
						ev.preventDefault();

						el.route();

						self.loading();

						var loaded = el.data('loaded');

						if (loaded) {
							self.infoItem().eq(0).trigger('click');

							return;
						}

						EasySocial.ajax('site/controllers/profile/initInfo', {
							id: self.options.id
						}).done(function(steps) {
							el.data('loaded', 1);

							var parent = el.parent('[data-profile-apps-item]');

							// Append all the steps
							$.each(steps.reverse(), function(index, step) {
								if (!step.hide) {
									parent.after(self.view.infoItem({
										url: step.url,
										title: step.title,
										index: step.index
									}));
								}

								if (step.html) {
									self.updateContent(step.html);
									self.contents().find('[data-field]').trigger('onShow');
								}
							});

							var item = self.infoItem().eq(0).parent('[data-profile-apps-item]');

							self.app().removeClass('active');

							item.addClass('active');

							// Have to set the title
							$(document).prop('title', self.infoItem().eq(0).attr('title'));
						});
					},

					'{infoItem} click': function(el, ev) {
						ev.preventDefault();

						el.route();

						self.loading();

						var index = el.data('info-index');

						EasySocial.ajax('site/controllers/profile/getInfo', {
							id: self.options.id,
							index: index
						}).done(function(contents) {
							self.updateContent(contents);

							self.contents().find('[data-field]').trigger('onShow');

							self.app().removeClass('active');

							el.parent('[data-profile-apps-item]').addClass('active');
						}).fail(function(error) {
							self.updateContent(error.message);
						});
					}
				}
			}
		);

		module.resolve();
	});

});

EasySocial.module( 'site/registrations/registrations' , function($){

	var module 				= this;

	EasySocial.require()
	.script( 'validate', 'field' )
	.view( 'site/registration/dialog.error' )
	.language( 'COM_EASYSOCIAL_CLOSE_BUTTON' , 'COM_EASYSOCIAL_REGISTRATION_ERROR_DIALOG_TITLE' )
	.done(function($){

		EasySocial.Controller(
			'Registrations.Form',
			{
				defaultOptions:
				{
					// passed in by caller
					previousLink	 : null,

					"{submit}"		: "[data-registration-submit]",
					"{field}"		: "[data-registration-fields-item ]",
					"{previous}"	: "[data-registration-previous]",

					view :
					{
						formError 	: "site/registration/dialog.error"
					}
				}
			},
			function(self)
			{

				return{

					init: function()
					{
						self.field().addController('EasySocial.Controller.Field.Base', {
							mode: 'register'
						});
					},

					"{previous} click" : function( el , event )
					{
						event.preventDefault();


						window.location.href	= self.options.previousLink;

						return false;
					},

					"{submit} click" : function( el , event )
					{
						event.preventDefault();

						// Apply loading class on button
						$( el ).addClass( 'btn-loading' );

						$( self.element ).validate()
						.fail( function()
						{
							// Remove loading class
							$( el ).removeClass( 'btn-loading' );

							EasySocial.dialog(
							{
								"title"		: $.language( 'COM_EASYSOCIAL_REGISTRATION_ERROR_DIALOG_TITLE' ),
								"content"	: self.view.formError(true),
								"width"		: 400,
								"height"	: 150,
								"buttons"	:
								[
									{
										"name"	: $.language( 'COM_EASYSOCIAL_CLOSE_BUTTON' ),
										"classNames"	: "btn btn-es-primary",
										"click"	: function()
										{
											EasySocial.dialog().close();
										}
									}
								]

							});
						})
						.done( function()
						{
							self.element.submit();
						});

						return false;
					}
				}
			});

		module.resolve();
	});

});

EasySocial.module( 'site/search/advanced.criteria' , function(){
	var module	= this;

	EasySocial.require()
	.view( 'site/loading/small' )
	.script( 'site/search/map' )
	.language( 'COM_EASYSOCIAL_ADVANCED_SEARCH_ADDRESS_DISTANCE_NOTICE' )
	.done( function($){

		EasySocial.Controller(
		'Search.Advanced.Criteria',
		{
			defaultOptions:
			{

				"{addButton}" 		: "[data-criteria-add-button]",
				"{removeButton}" 	: "[data-criteria-remove-button]",

				"{itemConditionDiv}" : "[data-itemConditionDiv]",
				"{itemCriteria}" 	: "[data-itemCriteria]",
				"{itemDataKey}" 	: "[data-itemDataKey]",
				"{itemOperator}" 	: "[data-itemOperator]",
				"{itemCondition}" 	: "[data-itemCondition]",

				"{dateStart}" 		: "[data-start]",
				"{dateEnd}" 		: "[data-end]",
				"{dataCondition}" 	: "[data-condition]",

                '{frmDistance}' : '[data-distance]',
                '{frmAddress}' : '[data-address]',
                '{frmLatitude}' : '[data-latitude]',
                '{frmLongitude}' : '[data-longitude]',

				//used for notice message if there is any
				"{dataNotice}" : "[data-criteria-notice]",

				"{locationLabel}" : "[data-location-label]",
				"{textField}" : "[data-location-textfield]",

				// loading gif
				view :
				{
					loadingContent 	: "site/loading/small"
				}
			}
		},
		function( self ){
			return {

				init : function()
				{
					self.element.addController(EasySocial.Controller.Search.Map);

					if (self.frmAddress().val() != undefined && self.frmAddress().val() != '') {
                    	self.textField().val(self.frmAddress().val());
                    	self.locationLabel().removeClass('hide');
					}
				},

				"{itemOperator} change" : function()
				{
					criteria 	= self.itemCriteria().find( 'select' );
					datakey		= self.itemDataKey().find( 'select' );
					operator 	= self.itemOperator().find( 'select' );

					var data 	= criteria.val().split( '|' );

					var key 	= data[0];
					var type 	= data[1];

					var opValue     = operator.val();
					var datakey		= datakey.val();

					if( opValue == 'blank' || opValue == 'notblank' )
					{
						self.itemCondition().hide();
					}
					else
					{
						if( opValue == 'between' )
						{
							self.getConditions( type, opValue, datakey );
						}
						else
						{
							if( type == 'datetime' || type == 'birthday' )
							{
								if( self.dateStart().length > 0 )
								{
									self.getConditions( type, opValue, datakey );
								}
							}
						}

						if( self.itemCondition().is( ":hidden" ) )
						{
							self.itemCondition().show();
						}

					}

				},

				getConditions : function( type, opValue, datakey )
				{
						// lets call ajax to get the value.
						EasySocial.ajax(
							"site/controllers/search/getConditions",
							{
								"element"	: type,
								"operator" 	: opValue,
								"datakey" 	: datakey
							})
							.done(function( conditions ) {

								self.itemCondition().show();

								// adding new condtions
								self.itemCondition().remove();
								var contents = $.buildHTML( conditions );
								contents.insertAfter( self.itemOperator() );

							})
							.fail( function( messageObj ){
								return messageObj;
							})
							.always(function(){

							});
				},

				"{frmDistance} change" : function() {

                    var distance = self.frmDistance().val();
                    var address = self.frmAddress().val();
                    var lat = self.frmLatitude().val();
                    var lng = self.frmLongitude().val();

                    var computedVal = distance + '|' + lat + '|' + lng + '|' + address;
                    self.dataCondition().val(computedVal);
				},

				"{dateStart} change" : function( el )
				{
					start 	= self.dateStart().val();
					end 	= self.dateEnd().val();


					var data = start;

					if( end.length > 0 )
					{
						data = data + '|' + end;
					}

					// update value
					self.dataCondition().val( data );
				},

				"{dateEnd} change" : function()
				{
					start 	= self.dateStart().val();
					end 	= self.dateEnd().val();

					var data = start;
					data = data + '|' + end;

					// update value
					self.dataCondition().val( data );
				},

				"{itemCriteria} change" : function()
				{
					select = self.itemCriteria().find( 'select' );

					if( select.val() != '' )
					{
						var data = select.val().split( '|' );

						var key 	= data[0];
						var type 	= data[1];

						//lets hide the notice message.
						self.dataNotice().addClass('hide');

						// lets get the correct operators and condition.

						EasySocial.ajax(
							"site/controllers/search/getDataKeys",
							{
								"key"		: key,
								"element"	: type
							})
							.done(function( datakeys, operators, conditions ) {

								self.itemDataKey().remove();
								self.itemOperator().remove();
								self.itemCondition().remove();

								// adding new operators
								// self.itemOperator().remove();
								var contents = $.buildHTML( operators );
								contents.insertAfter( self.itemConditionDiv() );

								// adding new operators
								if (datakeys != '') {
									var contents = $.buildHTML( datakeys );
									contents.insertAfter( self.itemConditionDiv() );
								}

								// adding new condtions
								// self.itemCondition().remove();
								var contents = $.buildHTML( conditions );
								contents.insertAfter( self.itemOperator() );

							})
							.fail( function( messageObj ){
								return messageObj;
							})
							.always(function(){

							});
					}

					// console.log( select.val() );
				},

				"{itemDataKey} change" : function()
				{
					select = self.itemCriteria().find( 'select' );

					if( select.val() != '' )
					{
						var data = select.val().split( '|' );

						var key 	= data[0];
						var type 	= data[1];

						//attempt to get the selected datakey
						var datakeys = self.itemDataKey().find( 'select' );
						var datakey = datakeys.val();

						// lets get the correct operators and condition.
						EasySocial.ajax(
							"site/controllers/search/getOperators",
							{
								"key"		: key,
								"element"	: type,
								"datakey" 	: datakey
							})
							.done(function( operators, conditions ) {

								// adding new operators
								self.itemOperator().remove();
								var contents = $.buildHTML( operators );
								contents.insertAfter( self.itemDataKey() );

								// adding new condtions
								self.itemCondition().remove();
								var contents = $.buildHTML( conditions );
								contents.insertAfter( self.itemOperator() );

								if (datakey == 'distance') {
									self.locationLabel().removeClass('hide');
								} else {
									self.locationLabel().addClass('hide');
								}

							})
							.fail( function( messageObj ){
								return messageObj;
							})
							.always(function(){

							});


					}

					// console.log( select.val() );
				},




				"{removeButton} click" : function()
				{
					// If this is the last search item, do not allow removing
					self.element.remove();
				}




			} //return
		});

		module.resolve();

	});

});

EasySocial.module( 'site/search/map' , function($){
	var module	= this;

    // Create search template first
    $.template('easysocial/maps.suggestion', '<div class="es-story-location-suggestion" data-location-suggestion><span class="formatted_address">[%= location.formatted_address %]</span></div>');

	EasySocial.require()
	.library('gmaps')
	.done( function(){

        // Constants
        var KEYCODE = {
            BACKSPACE: 8,
            COMMA: 188,
            DELETE: 46,
            DOWN: 40,
            ENTER: 13,
            ESCAPE: 27,
            LEFT: 37,
            RIGHT: 39,
            SPACE: 32,
            TAB: 9,
            UP: 38
        };

		EasySocial.Controller(
		'Search.Map',
		{
			defaultOptions:
			{
                "{icon}" : "[data-loaction-icon]",
                "{locationLabel}" : "[data-location-label]",
                '{textField}'       : '[data-location-textfield]',

                "{detectButton}" : "[data-location-detect]",
                "{suggestions}"  : "[data-location-suggestions]",
                "{suggestion}"      : "[data-location-suggestion]",
                "{autocomplete}" : "[data-location-autocomplete]",

                // form elements
                "{dataCondition}" : "[data-condition]",
                "{frmDistance}" : "[data-distance]",
                "{frmAddress}" : "[data-address]",
                "{frmLatitude}" : "[data-latitude]",
                "{frmLongitude}" : "[data-longitude]",

                view: {
                    suggestion: 'maps.suggestion'
                }
			}
		},
		function( self ){
			return {

				init : function()
				{

				},

                locations: {},

                lastQueryAddress: null,

                results: [],

                result: null,

                "{detectButton} click": function() {

                    self.icon()
                            .removeClass('ies-power')
                            .addClass('btn-loading');

                    clearTimeout(self.detectTimer);

                    // self.detectTimer = setTimeout(function() {
                    //     self.base().removeClass("is-busy");
                    // }, 8000);

                    $.GMaps.geolocate({
                        success: function(position) {
                            $.GMaps.geocode({
                                lat: position.coords.latitude,
                                lng: position.coords.longitude,
                                callback: function(locations, status) {
                                    if (status=="OK") {
                                        self.suggest(locations);
                                    }
                                }
                            });
                        },
                        error: function(error) {
                            var message = "";

                            switch (error.code) {

                                case 1:
                                    message = $.language("COM_EASYSOCIAL_LOCATION_PERMISSION_ERROR");
                                    break;

                                case 2:
                                    message = $.language("COM_EASYSOCIAL_LOCATION_TIMEOUT_ERROR");
                                    break;

                                case 3:
                                default:
                                    message = $.language("COM_EASYSOCIAL_LOCATION_UNAVAILABLE_ERROR");
                                    break;
                            }

                            EasySocial.dialog({
                                content: message
                            });
                        },
                        always: function() {
                            clearTimeout(self.detectTimer);

                            self.icon()
                                    .removeClass('btn-loading')
                                    .addClass('ies-power');
                        }
                    });
                },

                lookup: $.debounce(function(address) {

                    // self.base().addClass("is-busy");

                    $.GMaps.geocode({
                        address: address,
                        callback: function(locations, status) {

                            // self.base().removeClass("is-busy");

                            if (status=="OK") {

                                // Store a copy of the results
                                self.locations[address] = locations;

                                // Suggestion locations
                                self.suggest(locations);

                                self.lastQueryAddress = address;
                            }
                        }
                    });

                }, 250),


                "{textField} keypress": function(textField, event) {

                    switch (event.keyCode)
                    {
                        case KEYCODE.UP:

                            var prevSuggestion = $(
                                self.suggestion(".active").prev(self.suggestion.selector)[0] ||
                                self.suggestion(":last")[0]
                            );

                            // Remove all active class
                            self.suggestion().removeClass("active");

                            prevSuggestion
                                .addClass("active")
                                .trigger("activate");

                            self.suggestions()
                                .scrollTo(prevSuggestion, {
                                    offset: prevSuggestion.height() * -1
                                });

                            event.preventDefault();

                            break;

                        case KEYCODE.DOWN:

                            var nextSuggestion = $(
                                self.suggestion(".active").next(self.suggestion.selector)[0] ||
                                self.suggestion(":first")[0]
                            );

                            // Remove all active class
                            self.suggestion().removeClass("active");

                            nextSuggestion
                                .addClass("active")
                                .trigger("activate");

                            self.suggestions()
                                .scrollTo(nextSuggestion, {
                                    offset: nextSuggestion.height() * -1
                                });

                            event.preventDefault();

                            break;

                        case KEYCODE.ENTER:

                            var activeSuggestion = self.suggestion(".active"),
                                location = activeSuggestion.data("location");
                                self.set(location);

                            self.hideSuggestions();

                            event.preventDefault();
                            break;

                        case KEYCODE.ESCAPE:
                            self.hideSuggestions();
                            event.preventDefault();
                            break;
                    }

                },

                "{textField} keyup": function(textField, event) {

                    switch (event.keyCode) {

                        case KEYCODE.UP:
                        case KEYCODE.DOWN:
                        case KEYCODE.LEFT:
                        case KEYCODE.RIGHT:
                        case KEYCODE.ENTER:
                        case KEYCODE.ESCAPE:
                            // Don't repopulate if these keys were pressed.
                            break;

                        default:
                            var address = $.trim(textField.val());

                            if (address==="") {
                                // self.base().removeClass("has-location");
                                self.hideSuggestions();
                            }

                            // if (address==self.lastQueryAddress) return;

                            var locations = self.locations[address];

                            // If this location has been searched before
                            if (locations) {

                                // And set our last queried address to this address
                                // so that it won't repopulate the suggestion again.
                                self.lastQueryAddress = address;

                                // Just use cached results
                                self.suggest(locations);

                            // Else ask google to find it out for us
                            } else {

                                self.lookup(address);
                            }
                            break;
                    }
                },

                set: function(location) {

                    var lat = location.geometry.location.lat(),
                        lng = location.geometry.location.lng(),
                        address = location.formatted_address,
                        distance = self.frmDistance().val();

                    self.frmAddress().val(address);
                    self.frmLatitude().val(lat);
                    self.frmLongitude().val(lng);

                    var computedVal = distance + '|' + lat + '|' + lng + '|' + address;
                    self.dataCondition().val(computedVal);

                    self.textField().val(address);
                    // self.locationLabel().removeClass('hide');

                    self.hideSuggestions();

                },

                "{suggestion} click": function(suggestion, event) {
                    var location = suggestion.data("location");
                    self.set(location);
                },

                suggest: function(locations) {

                    self.hideSuggestions();

                    var suggestions = self.suggestions();

                    if (locations.length < 0) return;

                    self.results = locations;

                    $.each(locations, function(i, location){
                        // Create suggestion and append to list
                        self.view.suggestion({
                                location: location
                            })
                            .data("location", location)
                            .appendTo(suggestions);
                    });

                    // self.autocomplete().addClass('active');
                    self.showSuggestions();
                },

                showSuggestions: function() {

                    self.focusSuggestion = true;

                    // self.element.find(".es-story-footer")
                    //     .addClass("swap-zindex");

                    setTimeout(function(){

                        self.autocomplete().addClass("active");

                        var doc = $(document),
                            hideOnClick = "click.es.advancedsearch.location";

                        doc
                            .off(hideOnClick)
                            .on(hideOnClick, function(event){

                                // Collect list of bubbled elements
                                var targets = $(event.target).parents().andSelf();

                                if (targets.filter(self.element).length > 0) return;

                                doc.off(hideOnClick);

                                self.hideSuggestions();
                            });

                    }, 500);
                },

                hideSuggestions: function() {

                    // Clear location suggestions
                    self.suggestions().empty();

                    self.focusSuggestion = false;

                    self.autocomplete().removeClass("active");

                    $(document).off("click.es.advancedsearch.location");

                }


			} //return
		});

		module.resolve();

	});

});

EasySocial.module( 'site/search/advanced' , function(){
	var module	= this;

	EasySocial.require()
	.script( 'site/search/advanced.criteria' )
	.view( 'site/loading/small')
	.language( 'COM_EASYSOCIAL_STREAM_LOAD_PREVIOUS_STREAM_ITEMS' )
	.done( function($){

		EasySocial.Controller(
		'Search.Advanced',
		{
			defaultOptions:
			{
				// Elements
				"{sidebar}"       	: "[data-advsearch-sidebar]",
				"{sidebarItem}"		: "[data-sidebar-item]",

				"{item}"			: "[data-adv-search-item]",
				"{list}" 			: "[data-advsearch-list]",

				"{searchForm}" 		: "[data-adv-search-form]",
				"{savefilterBtn}" 	: "[data-advsearch-savefilter]",

				"{deletefilterBtn}" : "[data-advsearch-deletefilter]",

				"{content}" 		: "[data-advsearch-content]",

				"{addCriteria}"		: "[data-adv-search-add-criteria]",

				"{criteriaTemplate}"	: "[data-adv-search-criteria-template]",

				"{resultlist}" 		: "[data-advsearch-result-list]",

				// loading gif
				view :
				{
					loadingContent 	: "site/loading/small"
				}
			}
		},
		function( self ){
			return {

				init : function()
				{
					// Implement sidebar item controller.
					self.sidebarController = self.sidebar().addController( EasySocial.Controller.Search.Advanced.Sidebar,
												{
													"{parent}" : self
												});

					// implement search criteria item controller.
					self.item()
						.addController( EasySocial.Controller.Search.Advanced.Criteria,
							{
								"{parent}" : self
							});

				},

				/**
				 * Add a loading icon on the content layer.
				 */
				updatingContents: function()
				{
					self.element.addClass("loading");
				},

				/**
				 * Responsible to update the content area in the dashboard.
				 */
				updateContents : function( contents )
				{
					self.element.removeClass("loading");

					// Hide the content first.
					self.content().html( contents );
				},


				"{deletefilterBtn} click": function( el ) {

					var id = $(el).data( "id" );

					EasySocial.dialog({
						content		: EasySocial.ajax( 'site/views/search/confirmFilterDelete', { "fid": id } ),
						bindings	:
						{
							"{deleteButton} click" : function()
							{
								EasySocial.ajax( 'site/controllers/search/deleteFilter',
								{
									"fid"		: id
								})
								.done(function()
								{
									// delete the sidebar item
									$('[data-search-filter-' + id + ']').remove();

									//set active to default filter.
									$('[data-search-filter-0]').addClass( 'active' );

									//reset content
									self.content().html("");
									self.updatingContents();

									EasySocial.ajax( 'site/controllers/search/getFilterResults' ,
									{
										"fid"	: '0',
									})
									.done(function( contents )
									{
										var contents = $.buildHTML(contents);

										contents
											.addController( "EasySocial.Controller.Search.Advanced.Criteria",
												{
													"{parent}" : self
												});

										self.updateContents( contents );

									})
									.fail( function( messageObj )
									{
										return messageObj;
									})


									EasySocial.dialog().close();
								});
							}
						}
					});

				},


				"{savefilterBtn} click" : function()
				{
					var data 		= self.searchForm().serializeJSON();

					EasySocial.dialog({
						content		: EasySocial.ajax( 'site/views/search/confirmSaveFilter' ),
						bindings	:
						{
							"{saveButton} click" : function()
							{
								this.inputWarning().hide();

								filterName = this.inputTitle().val();
								filterSitewide = this.inputSitewide().is(':checked') ? 1 : 0;

								if( filterName == '' )
								{
									this.inputWarning().show();
									return;
								}

								EasySocial.ajax( 'site/controllers/search/addFilter',
								{
									"title"		: filterName,
									"sitewide"	: filterSitewide,
									"data"		: data,
								})
								.done(function( html, msg )
								{
									var item = $.buildHTML( html );
									self.sidebarController.addFilterItem( item );

									// show message
									EasySocial.dialog( msg );

									// auto close the dialog
									setTimeout(function() {
										EasySocial.dialog().close();
									}, 2000);

								});
							}
						}
					});
				},

				"{addCriteria} click" : function( el , event )
				{
					// Duplicate the template
					var tmpl	= self.criteriaTemplate().clone();

					// Remove any unecessary attributes for the template
					$( tmpl )
						.removeClass( 'hide' )
						.removeAttr( 'data-adv-search-criteria-template' )
						.addController(
							EasySocial.Controller.Search.Advanced.Criteria ,
							{
								"{parent}" : self
							}
						);

					// Append the template to the list now.
					self.list().append( tmpl );
				}
			}
		});

		EasySocial.Controller(
		'Search.Advanced.Sidebar',
		{
			defaultOptions:
			{
				"{item}" : "[data-sidebar-item]",

				// loading gif
				view :
				{
					loadingContent 	: "site/loading/small"
				}
			}
		},
		function( self ){
			return {

				init : function()
				{
					// Implement each feed links.
					self.item().implement( EasySocial.Controller.Search.Advanced.Sidebar.Item ,
					{
						"{parent}"		: self,
						"{root}"		: self.parent
					});
				},


				"addFilterItem" : function( item )
				{

					//item.find('[data-sidebar-item]').implement( EasySocial.Controller.Search.Advanced.Sidebar.Item ,
					item.implement( EasySocial.Controller.Search.Advanced.Sidebar.Item ,
					{
						"{parent}"		: self,
						"{root}"		: self.parent
					});

					item.appendTo( $('[data-advsearch-sidebar-ul]') );

				},


			} //return
		});

		EasySocial.Controller(
		'Search.Advanced.Sidebar.Item',
		{
			defaultOptions:
			{
				"{filterDeleteBtn}" : "[data-search-filter-delete]",
				"{filterItem}" 		: "[data-search-filter-item]",

				"{item}"			: "[data-adv-search-item]",


				// loading gif
				view :
				{
					loadingContent 	: "site/loading/small"
				}
			}
		},
		function( self ){
			return {

				init : function()
				{

				},

				"{filterItem} click" : function( el , event )
				{
					// Prevent event bubbling
					event.preventDefault();

					$( '[data-sidebar-item]' ).removeClass( 'active loading' );
					self.element.addClass( 'active');

					var id		= self.element.data( 'id' ),
						url 	= self.element.data( 'url' ),
						title 	= self.element.data( 'title' );

					// Update browser's URL
					$( el ).route();

					// Notify the dashboard that it's starting to fetch the contents.
					self.root.content().html("");
					self.root.updatingContents();

					self.element.addClass( 'loading' );

					EasySocial.ajax( 'site/controllers/search/getFilterResults' ,
					{
						"fid"	: id,
					})
					.done(function( contents )
					{
						var contents = $.buildHTML(contents);

						contents
							.find( self.item.selector )
							.addController( "EasySocial.Controller.Search.Advanced.Criteria",
								{
									"{parent}" : self.root
								});

						self.root.updateContents( contents );

					})
					.fail( function( messageObj )
					{
						return messageObj;
					})
					.always(function()
					{
						self.element.removeClass( 'loading' );
					});


				}


			} //return
		});

		module.resolve();

	});

});

EasySocial.module( 'site/search/advanced.list' , function($){

	var module	= this;

	EasySocial.require()
	.view( 'site/loading/small', 'site/search/loadbutton' )
	.script('site/search/item')
	.language( 'COM_EASYSOCIAL_SEARCH_LOAD_MORE_ITEMS' )
	.done(function($){


		EasySocial.Controller(
			'Search.Advanced.List',
			{
				defaultOptions:
				{
					// Elements
					"{item}"			: "[data-search-item]",
					"{pagination}"  	: "[data-search-pagination]",
					"{loadmorebutton}" 	: "[data-search-loadmore-button]",

					"{searchForm}" 		: "[data-adv-search-form]",

					// loading gif
					view :
					{
						loadingContent 	: "site/loading/small",
						loadmoreContent : "site/search/loadbutton"
					}

				}
			},
			function( self ){
				return {

					init : function()
					{
						self.item().implement( EasySocial.Controller.Search.Item );

						self.on("scroll.advsearch", window, $._.debounce(function(){

							if (self.loading) return;

							if (self.pagination().visible()) {

								self.loadMore();
							}

						}, 250));
					},

					"{loadmorebutton} click": function(){
						self.loadMore();
					},


					loadMore: function() {

						var next_limit 	= self.pagination().data('last-limit');
						var data 		= self.searchForm().serializeJSON();

						// console.log( next_limit );
						// console.log( data );


						if( next_limit == '-1')
						{
							self.loadmorebutton().hide();
							return;
						}

						self.loading = true;

						EasySocial.ajax( 'site/controllers/search/loadmore' ,
						{
							"data" : data,
							"nextlimit" : next_limit
						},
						{
							beforeSend: function()
							{
								self.pagination().html( self.view.loadingContent() );
							}
						})
						.done(function( contents, next_limit )
						{
							// update next last-update
							self.pagination().data('last-limit', next_limit );

							// append stream into list.
							self.pagination().before( contents );

							//re-implement controller on new items
							self.item().implement( EasySocial.Controller.Search.Item );

							if ( next_limit == '-1') {
								self.pagination().html('');
							} else {
								//append the anchor link.
								self.pagination().html( self.view.loadmoreContent() );

							}


						})
						.fail( function( messageObj ){

							return messageObj;
						})
						.always(function(){

							self.loading = false;

						});
					}




				}
			});

		module.resolve();
	});

});

EasySocial.module( 'site/search/item' , function($){

	var module	= this;

	EasySocial.require()
	.view(
		'site/loading/small'
	)
	.language(
		'COM_EASYSOCIAL_FRIENDS_REQUEST_SENT_NOTICE'
	)
	.done(function($){

		EasySocial.Controller(
			'Search.Item',
			{
				defaultOptions:
				{
					// Elements
					"{toggle}"		: "[data-activity-toggle]",
					"{deleteBtn}"	: "[data-activity-delete]",

					"{addFriendButton}" : "[data-search-friend-button]",
					"{pendingFriendButton}" : "[data-search-friend-pending-button]",
					// Dropdown
					"{dropdown}"		: "[data-profileFriends-dropdown]",

					view :
					{
						loader 			: "site/loading/small"
					}
				}
			},
			function( self ){
				return {

					init : function()
					{
						// Implement sidebar controller.
						friendid 		: null
					},

					"{pendingFriendButton} click" : function( el )
					{
						self.dropdown().html(
							$.language( 'COM_EASYSOCIAL_FRIENDS_REQUEST_SENT_NOTICE' )
						);
					},

					/**
					 * Triggered when the add friend button is clicked
					 */
					"{addFriendButton} click" : function( el )
					{
						var id = self.element.data('friend-uid');

						$( el ).addClass( 'btn-loading' );

						// Implement controller on add friend.
						EasySocial.ajax( 'site/controllers/friends/request' ,
						{
							"viewCallback"	: "usersRequest",
							"id"	: id
						})
						.done( function( button )
						{
							// After the request is complete, set the correct friend id.
							// self.options.friendid 	= friendId;

							$( el ).replaceWith( button );

							self.dropdown().remove();

							// Remove the loading state from the button
							$( el ).removeClass( 'btn-loading' );

						})
						.fail(function( message )
						{
							EasySocial.dialog(
							{
								content 	: EasySocial.ajax( 'site/views/friends/exceeded' )
							});
							
							self.dropdown().html( message );
						});

					}

				}
			});

		module.resolve();
	});

});

EasySocial.module( 'site/search/dating' , function($){
	var module	= this;

	EasySocial.require()
	.script( 'site/search/map' )
	.done( function(){

		EasySocial.Controller(
		'Search.Dating',
		{
			defaultOptions:
			{
				"{itemCriteria}" 	: "[data-itemCriteria]",
				"{itemDataKey}" 	: "[data-itemDataKey]",
				"{itemOperator}" 	: "[data-itemOperator]",
				"{itemCondition}" 	: "[data-itemCondition]",

				"{dateStart}" 		: "[data-start]",
				"{dateEnd}" 		: "[data-end]",
				"{dataCondition}" 	: "[data-condition]",

				"{dataGender}" : "[data-gender-radio]",

                '{frmDistance}' : '[data-distance]',
                '{frmAddress}' : '[data-address]',
                '{frmLatitude}' : '[data-latitude]',
                '{frmLongitude}' : '[data-longitude]',

				"{locationLabel}" : "[data-location-label]",
				"{textField}" : "[data-location-textfield]"
			}
		},
		function( self ){
			return {

				init : function()
				{
					self.element.addController(EasySocial.Controller.Search.Map);

					if (self.frmAddress().val() != '') {
                    	self.textField().val(self.frmAddress().val());
					}
				},

				"{frmDistance} change" : function() {
                    var distance = self.frmDistance().val();
                    var address = self.frmAddress().val();
                    var lat = self.frmLatitude().val();
                    var lng = self.frmLongitude().val();

                    var computedVal = distance + '|' + lat + '|' + lng + '|' + address;
                    self.dataCondition().val(computedVal);
				},

				"{dataGender} click" : function(el) {
					self.dataCondition().val( el.val() );
				},

				"{dateStart} change" : function() {
					start 	= self.dateStart().val();
					end 	= self.dateEnd().val();

					var data = start;

					if( end.length > 0 )
					{
						data = data + '|' + end;
					}

					// update value
					self.dataCondition().val( data );
				},

				"{dateEnd} change" : function() {
					start 	= self.dateStart().val();
					end 	= self.dateEnd().val();

					var data = end;

					if( start.length > 0 )
					{
						data = start + '|' + data;
					}

					// update value
					self.dataCondition().val( data );
				}


			} //return
		});

		module.resolve();

	});

});

EasySocial.module( 'site/search/list' , function($){

	var module	= this;

	EasySocial.require()
	.view( 'site/loading/small', 'site/search/loadbutton' )
	.script('site/search/item')
	.language( 'COM_EASYSOCIAL_SEARCH_LOAD_MORE_ITEMS' )
	.done(function($){


		// TODO: Move this away from here
		// $.fn.visible = function(partial){

		// 	var $t	= $(this),
		// 		$w	= $(window),
		// 	viewTop	= $w.scrollTop(),
		// 	viewBottom	= viewTop + $w.height(),
		// 	_top		= $t.offset().top,
		// 	_bottom		= _top + $t.height(),
		// 	compareTop	= partial === true ? _bottom : _top,
		// 	compareBottom	= partial === true ? _top : _bottom;

		// 	return ((compareBottom <= viewBottom) && (compareTop >= viewTop));
	 //    };


		EasySocial.Controller(
			'Search.List',
			{
				defaultOptions:
				{
					// Elements
					"{item}"	: "[data-search-item]",


					"{pagination}"  : "[data-search-pagination]",
					"{loadmorebutton}" : "[data-search-loadmore-button]",

					// loading gif
					view :
					{
						loadingContent 	: "site/loading/small",
						loadmoreContent : "site/search/loadbutton"
					}

				}
			},
			function( self ){
				return {

					init : function()
					{
						self.item().implement( EasySocial.Controller.Search.Item );

						self.on("scroll.search", window, $._.debounce(function(){

							if (self.loading) return;

							if (self.pagination().visible()) {

								self.loadMore();
							}

						}, 250));
					},

					"{loadmorebutton} click": function(){
						self.loadMore();
					},


					loadMore: function() {

						var query 		= $("[data-search-query]").val();
						var type 		= $("[data-sidebar-menu].active").data( 'type' );
						var next_limit 	= self.pagination().data('last-limit');
						var last_type 	= self.pagination().data('last-type');

						if( next_limit == '-1')
						{
							self.loadmorebutton().hide();
							return;
						}

						self.loading = true;

						EasySocial.ajax( 'site/controllers/search/getItems' ,
						{
							"next_limit" : next_limit,
							"last_type" : last_type,
							"type" : type,
							"q" : query,
							"loadmore" : '1'
						},
						{
							beforeSend: function()
							{
								self.pagination().html( self.view.loadingContent() );
							}
						})
						.done(function( contents, next_type, next_limit )
						{
							// update next last-update and last-type
							self.pagination().data('last-limit', next_limit );
							self.pagination().data('last-type', next_type );


							// append stream into list.
							self.pagination().before( contents );

							//re-implement controller on new items
							self.item().implement( EasySocial.Controller.Search.Item );

							if ( next_limit == '-1') {
								self.pagination().html('');
							} else {
								//append the anchor link.
								self.pagination().html( self.view.loadmoreContent() );
							}


						})
						.fail( function( messageObj ){

							return messageObj;
						})
						.always(function(){

							self.loading = false;
							//self.pagination().html('');
						});
					}




				}
			});

		module.resolve();
	});

});

EasySocial.module( 'site/search/search' , function($){

	var module	= this;

	EasySocial.require()
	.library( 'history' )
	.script( 'site/search/sidebar', 'site/profile/friends' )
	.view( 'site/loading/small' )
	.done(function($){

		EasySocial.Controller(
		'Search',
		{
			defaultOptions:
			{
				// Properties
				items		: null,

				// Elements
				"{container}"	: "[data-search]",

				"{contentTitle}": "[data-search-content-title]",
				"{content}"		: "[data-search-content]",
				"{sidebar}"		: "[data-search-sidebar]",


				"{sidebarItem}"	: "[data-sidebar-item]",


				view :
				{
					loadingContent 	: "site/loading/small"
				}
			}
		},
		function( self ){
			return {

				init : function()
				{
					// Implement sidebar controller.
					self.sidebar().implement( EasySocial.Controller.Search.Sidebar ,
					{
						"{parent}"	: self
					});

					self.sidebarItem().implement( EasySocial.Controller.Search.Sidebar.Item ,
					{
						"{parent}"	: self
					});
				},


				/**
				 * Add a loading icon on the content layer.
				 */
				updatingContents: function()
				{
					self.content().html( self.view.loadingContent() );
				},

				updateContent: function( content )
				{
					self.content().html( content );
				}

			}
		});

		module.resolve();
	});

});

EasySocial.module( 'site/search/sidebar' , function($){

	var module	= this;

	EasySocial.require()
	.done(function($){

		EasySocial.Controller(
			'Search.Sidebar',
			{
				defaultOptions:
				{
					"{menuItem}"	: "[data-sidebar-menu]"
				}
			},
			function( self ){
				return {

					init: function()
					{
					},

					"{menuItem} click" : function( el , event )
					{
						// Remove all active class.
						self.menuItem().removeClass( 'active' );

						// Add active class on this item.
						$( el ).addClass( 'active' );
					}
				}
			});


		EasySocial.Controller(
			'Search.Sidebar.Item',
			{
				defaultOptions:
				{
				}
			},
			function( self ){
				return {

					init: function()
					{
					},

					"{self} click" : function( el , event )
					{

						var type 	= self.element.data( 'type' ),
							url 	= self.element.data( 'url' );

							
						var query = $("[data-search-query]").val();

		
						// If this is an embedded layout, we need to play around with the push state.
						History.pushState( {state:1} , '' , url );

						self.parent.updatingContents();

						// console.log( query );
						//return;

						//ajax call here.
						EasySocial.ajax( 'site/controllers/search/getItems',
						{
							"type"		: type,
							"q" 		: query
						})
						.done(function( html )
						{
							self.parent.updateContent( html );	
						})
						.fail(function( message ){
							console.log( message );
						});

						self.parent.updateContent();
					}
				}
			});		

		module.resolve();
	});

});
EasySocial.module("site/search/toolbar", function($){

	var module	= this;

	EasySocial.Controller("Search.Toolbar",
	{
		defaultOptions: {
			showadvancedlink : true,
			"{textfield}": "[data-nav-search-input]"
		}
	},
	function(self, opts, base) { return {

		init : function() {
			self.options.showadvancedlink = self.element.data('showadvancedlink') == 0 ? 0 : 1 ;
		},

		cache: {},

		search: $.debounce(function(keyword) {

			if (self.loading) {
				return;
			}

			if (!keyword || !(keyword=$.trim(keyword)) || keyword.length <= 2) {
				return;
			}

			var textfield = self.textfield();

			// Cheap fix
			textfield.popbox("widget").hide();
			textfield.popbox("widget").destroy();

			var task =
				// Take from cache if keyword has been searched before
				self.cache[keyword] ||
				// Else make and ajax call
				EasySocial.ajax("site/controllers/search/getItems", {
					"q": keyword,
					"mini": "1",
					"showadvancedlink": self.options.showadvancedlink
				})
				.done(function(){
					// Cache this search result
					self.cache[keyword] = task;
				});

			task
				.fail(function(message) {
					console.log(message);
				})
				.always(function(){
					self.loading = false;
				});

			self.hide();

			base.popbox({
				content: task,
				id: "fd",
				component: "es",
				type: "search",
				toggle: "click",
				cache: false,
				offset: 0
			});

			var popbox = base.popbox("widget");

			popbox.show();
			popbox.keyword = keyword;

		}, 250),

		hide: function() {

			var popbox = base.popbox("widget");

			if (popbox) {
				popbox.hide();
			}
		},

		"{textfield} keydown": function() {

			self.hide();
		},

		"{textfield} keyup": function(textfield, event) {

			// 27 == escape
			if (event.which===27) {
				return;
			}

			var keyword = textfield.val();
			self.search(keyword);
		},

		"{self} popboxLoading": function(el, event, popbox) {

			popbox.loader.width(base.width());

			popbox.loader
				.position(popbox.position);

			base.addClass("is-active");
		},

		"{self} popboxActivate": function(el, event, popbox) {

			popbox.tooltip.width(base.width());

			popbox.tooltip
				.position(popbox.position);

			base.addClass("is-active");
		},

		"{self} popboxDeactivate": function(el, event, popbox) {

			base.removeClass("is-active");
		}

	}});

	module.resolve();

});

EasySocial.module('site/stream/item', function() {

	var module	= this;

	EasySocial.require()
	.library("mentions", "placeholder", "dialog")
	.view(
		"site/friends/suggest.item",
		"site/friends/suggest.hint.search",
		"site/friends/suggest.hint.empty",
		"site/hashtags/suggest.item",
		"site/hashtags/suggest.hint.search",
		"site/hashtags/suggest.hint.empty"
	)
	.done(function($){

		EasySocial.Controller('Stream.Item', {
			defaultOptions: {
				view: {
					suggestItem: "site/friends/suggest.item",
					tagSuggestItem: "site/hashtags/suggest.item"
				},

				// Properties
				id: "",
				context: "",

				// Elements
				"{deleteFeed}"	: "[data-stream-delete]",
				"{editStream}"	: "[data-stream-edit]",
				"{updateStream}"	: "[data-stream-edit-update]",
				"{cancelEditStream}" : "[data-stream-edit-cancel]",
				"{publishItem}": "[data-stream-publish]",

				"{addBookmark}": "[data-stream-bookmark-add]",
				"{removeBookmark}": "[data-stream-bookmark-remove]",

				"{addSticky}": "[data-stream-sticky-add]",
				"{removeSticky}": "[data-stream-sticky-remove]",

				"{hideLink}"	: "[data-stream-hide]",
				"{unHideLink}"	: "[data-stream-show]",

				"{hideAppLink}"	: "[data-stream-hide-app]",
				"{unHideAppLink}"	: "[data-stream-show-app]",

				"{hideActorLink}" 	: "[data-stream-hide-actor]",
				"{unHideActorLink}" : "[data-stream-show-actor]",

				"{hideNotice}"	: "[data-stream-hide-notice]",

				"{actions}"		: "[data-streamItem-actions]",
				"{contents}"	: "[data-streamItem-contents]",


				"{streamContent}"	: "[data-stream-content]",
				"{streamEditor}"	: "[data-stream-editor]",

				"{streamData}"		: "[data-stream-item]",

				"{likes}"			: "[data-likes-action]",
				"{counterBar}"		: "[data-stream-counter]",
				"{likeContent}" 	: "[data-likes-content]",
				"{repostContent}" 	: "[data-repost-content]",

				"{share}"			: "[data-repost-action]",

				// for stream comment
				"{streamCommentLink}" 	: "[data-stream-action-comments]",
				"{streamCommentBlock}" 	: "[data-comments]"
			}
		}, function(self, opts, base) { 

			return {

				init: function() {
					// Set the stream's unique id.
					opts.id = base.data('id');
					opts.context = base.data('context');
					opts.ishidden = base.data('ishidden');
					opts.actor = base.data('actor');
				},

				plugins: {},

				"{addBookmark} click": function(el, event) {
					// Add the bookmark class
					self.element.addClass('is-bookmarked');

					EasySocial.ajax('site/controllers/stream/bookmark', {
						"id" : self.options.id
					})
					.done(function() {
						// Do nothing once the item is already bookmarked
					})
					.fail(function(message) {
						// If this is failed, we need to display the message object
						self.element.removeClass('is-bookmarked');

						self.setMessage(message);
					});
				},

				"{removeBookmark} click": function(el, event) {
					var filterType = window.streamFilter || false;

					// Remove the bookmarked class
					if (filterType != 'bookmarks') {
						self.element.removeClass('is-bookmarked');
					}

					EasySocial.ajax('site/controllers/stream/removeBookmark', {
						"id": self.options.id
					}).done(function(html) {
						if (filterType == 'bookmarks') {
							self.element.html(html);
						}
					});
				},


				"{addSticky} click": function(el, event) {
					EasySocial.ajax('site/controllers/stream/addSticky', {
						"id" : self.options.id
					})
					.done(function() {
						// add sticky icon
						self.element.addClass('is-sticky');
					})
					.fail(function(obj) {

						// If this is failed, we need to display the message object
						EasySocial.dialog({
							content: obj.message
						});

					});
				},

				"{removeSticky} click": function(el, event) {
					var filterType = window.streamFilter || false;

					if (filterType != 'sticky') {
						// Remove the bookmarked class
						self.element.removeClass('is-sticky');
					}

					EasySocial.ajax('site/controllers/stream/removeSticky', {
						"id": self.options.id
					})
					.done(function(html){

						if (filterType == 'sticky') {
							self.element.html(html);
						}
					});
				},

				"{publishItem} click": function(el, event) {
					var id = opts.id;

					EasySocial.ajax('site/controllers/stream/publish', {
						"id": id
					}).done(function() {
						// When the stream is published, we want to hide the item
						base.switchClass('is-published');
					});
				},

				"{likes} onLiked": function(el, event, data) {

					//need to make the data-stream-counter visible
					self.counterBar().removeClass('hide');

				},

				"{likes} onUnliked": function(el, event, data) {

					var isLikeHide 		= self.likeContent().hasClass('hide');
					var isRepostHide 	= self.repostContent().hasClass('h