<?php
/**
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2014 Ideal Extensions for Joomla. All rights reserved.
 * @license		GNU GPL2 or later; see LICENSE.txt
 */

// Make sure this file is called by Joomla
defined('JPATH_BASE') or die;

//pulling in the content of the file below.
require_once JPATH_ADMINISTRATOR .'/components/com_civicrm/civicrm.settings.php';

// The return variable, after validation set throw an exception and set it with the $exception
$return = true;

// If you want to integrate with another component, you might want to laod the language files
$lang = JFactory::getLanguage();
$lang->load('com_user');

// Get current user if needed
$user	= JFactory::getUser();

/**
 * @var Object
 */
//$db		= JFactory::getDBO();

/**
 * Database query object
 * @var Object
 */
//$query	= $db->getQuery(true);

/**
 * Application Object
 * @var Object
 */
$app		= JFactory::getApplication();

/**
 * where post data is saved, you ca also use the $data variable
 * @var Object
 */
$jinput		= $app->input;

/**
 * categories information
 * In order to know all  Object properties user var_dump($contact);
 * @var Array of objects
 */
//$categories;

try
{
	/**
	 * Feel free to use the following variables in your code:
	 * $categories
	 * $params => Component Options;
	 */

	if($jinput->getCmd('view', 'categories')){
	  foreach ( $categories as &$items ) {
		foreach ( $items as &$category ) {
		  foreach ( $category->contacts as $i => &$contact ) {
			$membershipStatus = _getContactMembershipStatus($contact,$user);
			if ( $membershipStatus ) {
			  if ( is_string($membershipStatus)) {
				$contact->params->show_extrafield_10 = 1;
				$contact->extra_field_10 = $membershipStatus;
			  } else {
				$contact->params->show_extrafield_10 = 0;
			  }
			} else {
			  unset($category->contacts[$i]); // Remove Contact
			}
		  }
		}
	  }
	}
	$return = true;
}
catch (Exception $e)
{
	$return = $e;
}

return $return;

  function _getContactMembershipStatus($item,$user) {
    try
    {
      // Get Joomla user related to displayed item
      $item_user_id = _getUserId($item);
      if ( !isset($item_user_id)) return null;

      // Get CiviCRM for the displayed item
      $contactID = _getCiviContact($item,$item_user_id);
      if (!isset($contactID)) return null;

      // Get latest membership from CiviCRM for this item
      $membership = _getContactMembership($contactID);
      if ( $membership['count'] == 0 ) return null;

      // If logged in and ( displaying self or current user authorized to see memberships )
      $allowed = $item_user_id > 0 && $user && ( $item_user_id == $user->id || $user->authorize('core.edit', 'com_users'));

      $values = reset($membership['values']);
      $status_id = $values['status_id'];

      if ( $allowed ) {
          // Compute current membership
          $membershipStatus = '<h6>'.Jtext::_(CE_PLUGIN_VIEW_CATEGORIES_MEMBERSHIP).' '._getMembershipStatuses( $status_id ).'<br>'
                            . JText::_(CE_PLUGIN_VIEW_CATEGORIES_JOIN).' '.$values['join_date'].'<br>'
                            . JText::_(CE_PLUGIN_VIEW_CATEGORIES_START).' '.$values['start_date'].'<br>'
                            . JText::_(CE_PLUGIN_VIEW_CATEGORIES_END).' '.$values['end_date'].'</h6>';
      } else {
         // Not allowed, restrict displayed to New, Current or Grace memberships
         $membershipStatus = ( $status_id <= 3 );
      }
      return $membershipStatus;
    }
    catch (Exception $e)
    {
      return $e;
    }
  }

  function _getCiviContact($ce_user,$item_user_id) {
    // We have now authenticated against the Joomla user table. From here we
    // need to find the CiviCRM user ID by using UFMatch
    // Initiate CiviCRM
    require_once 'CRM/Core/Config.php';
    $civiConfig =& CRM_Core_Config::singleton( );

    // Find the CiviCRM ContactID
    require_once 'CRM/Core/BAO/UFMatch.php';
    CRM_Core_BAO_UFMatch::synchronizeUFMatch( $ce_user->name, $item_user_id, $ce_user->email, 'Joomla' );
    return CRM_Core_BAO_UFMatch::getContactId( $item_user_id );
  }

    /**
     * Get Contact Id based on user id
     *
     * @return      int     The Contact id
     * @since       2.5
     */
    function _getUserId($contact) {
        $db = JFactory::getDBO();
        $query  = $db->getQuery(true);

        $query->select('user_id');
        $query->from('#__ce_details AS a');
        $query->where('a.id = ' . (int) $contact->id);

        $db->setQuery($query,0,1);
        return $db->loadResult() ?: null;
    }

  function _getContactMembership($contactID) {
    // Find the membership records for the ContactID
    require_once 'api/api.php';
    $params = array(
      'version' => 3,
      'contact_id' => $contactID,
      'sort' => 'start_date DESC'
    );
    $membership = civicrm_api('membership', 'get', $params);

    return $membership;
  }

  function  _getMembershipStatuses( $membership_status_id ) {
    require_once 'api/api.php';
    $params = array(
      'version' => 3,
      'id' => $membership_status_id
    );

    assert('$membership_status_id >= 0 && $membership_status_id <= 7');
    $statusDetails = civicrm_api('MembershipStatus', 'get', $params);
    $values = array_values ($statusDetails['values']);

    return $values[0]['label'];
  }
?>