<?php
/**
 * @package		ContactEnhanced
 * @author		Douglas Machado {@link http://idealextensions.com}
 * @author		Created on 24-Feb-2011
 * @copyright	Copyright (C) 2006 - 2014 IdealExtensions.com, Inc. All rights reserved.
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

jimport('joomla.plugin.plugin');

/**
 * Content Plugin
 *
 * @package		Joomla
 * @subpackage	Content
 * @since		1.5
 */
class plgContentContactenhanced extends JPlugin
{
	/**
	 * Changes the string {loadcontact id=|ID|} for the form by that ID
	 *
	 * Method is called by the view
	 *
	 * @param	string	The context of the content being passed to the plugin.
	 * @param	object	The content object.  Note $article->text is also available
	 * @param	object	The content params
	 * @param	int		The 'page' number
	 * @since	1.6
	 */
	public function onContentPrepare($context, &$row, &$params, $limitstart=0)
	{
		$app = JFactory::getApplication();
		if($app->isAdmin() OR !strpos($row->text, 'loadcontact ')){
			//--The tag is not found in content - abort..
			return;
		}
		if(!is_file(JPATH_ROOT.'/components/com_contactenhanced/controller.php')){
			return false; // Contact Enhanced is not installed;
		}
		$lang =JFactory::getLanguage();
		$lang->load('com_contactenhanced');
		$lang->load('com_contactenhanced',JPATH_ROOT.'/components/com_contactenhanced');
		$lang->load('plg_content_contactenhanced',JPATH_ROOT.'/plugins/content/contactenhanced');
		JHtml::_('jquery.framework');
		
		// If disabled, than it is a demo page, so we do not run the plugin and just remove the {loadcontact disabled} syntax
	 	$regex = '/{loadcontact disabled}/i';
		// find all instances of plugin and put in $matches
		preg_match_all( $regex, $row->text, $matches );
		if(count($matches[0])){
			$row->text = preg_replace( $regex, '', $row->text );
			return true;
		}
		
	 	// expression to search for
	 	$regex = '/{loadcontact\s*.*?}/i';
	 	$pluginParams = $this->params;
		// check whether plugin has been unpublished
		if ( !$pluginParams->get( 'enabled', 1 ) ) {
			$row->text = preg_replace( $regex, '', $row->text );
			return true;
		}
		
		
	 	// find all instances of plugin and put in $matches
		preg_match_all( $regex, $row->text, $matches );
		// Number of plugins
	 	$count = count( $matches[0] );
	 	// plugin only processes if there are any instances of the plugin in the text
	 	if ( $count ) {
	 		$this->processContacts( $row, $matches, $count, $regex, $params );
		}
	}//function

	function processContacts ( &$row, &$matches, $count, $regex,&$params )
	{
	 	require_once(JPATH_ROOT .'/components/com_contactenhanced/helpers/helper.php');

	 	$lang =JFactory::getLanguage();
		$lang->load('com_contactenhanced',JPATH_SITE);
		$jinput = JFactory::getApplication()->input;



		for ( $i=0; $i < $count; $i++ )
		{
			$pluginParams = $this->params;

	 		$inline_params = str_replace( 'loadcontact', '', $matches[0][$i] );
	 		$inline_params = str_replace( '{', '', $inline_params );
	 		$inline_params = str_replace( '}', '', $inline_params );
	 		$inline_params = trim( $inline_params );

	 		if(strpos($inline_params, ' ') === false AND is_numeric($inline_params)){
	 			$contactId = trim( $inline_params );
	 		}else{
	 		$fields	= array();
	 			$searchfrase_matches	= 'all';
	 			$search_operator_match	= '=';
	 			$search_matches	= array();
	 			preg_match( "#search=\|(.*?)\|#s", $inline_params, $search_matches );
	 			if (isset($search_matches[1])){
	 				$search_matches[1]	= str_replace( '&amp;', '&', $search_matches[1] );
	 				// Get all Fields
	 				parse_str($search_matches[1], $fields);
	 				// Get Search Operator option
	 				$search_operator_match = array();
	 				preg_match( "#search_operator=\|(.*?)\|#s", $inline_params, $search_operator_match );
	 				if (isset($search_operator_match[1])){
	 					$search_operator_match	= $search_operator_match[1];
	 				}else{
	 					$search_operator_match	= '=';
	 				}

	 				// Get Search Operator option
	 				$searchfrase_matches = array();
	 				preg_match( "#searchfrase=\|(.*?)\|#s", $inline_params, $searchfrase_matches );
	 				if (isset($searchfrase_matches[1])){
	 					$searchfrase_matches	= $searchfrase_matches[1];
	 				}else{
	 					$searchfrase_matches	= 'all';
	 				}
	 			}
	 			// get ID
				$id_matches = array();
				preg_match( "#id=\|(.*?)\|#s", $inline_params, $id_matches );
				if (isset($id_matches[1]) AND is_string($id_matches[1]) AND $id_matches[1] == 'sequential'){
					$contactId = $this->getNextContactID( $fields, $search_operator_match, $searchfrase_matches);
				}elseif (isset($id_matches[1])){
					$contactId = trim( ($id_matches[1]) );
				}else{
					$contactId	= explode(" ",$inline_params);
					if(!is_numeric($contactId)){
						$contactId = '';
					}
				}
	 			$detail_matches = array();
	 			preg_match( "#details=\|(.*?)\|#s", $inline_params, $detail_matches );
				if (isset($detail_matches[1]) ){
					$pluginParams->set('show_contact_details',$detail_matches[1]);
				}
	 			$recipient_matches = array();
	 			preg_match( "#recipient=\|(.*?)\|#s", $inline_params, $recipient_matches );
				if (isset($recipient_matches[1]) AND ceHelper::isEmailAddress($recipient_matches[1])){
					$session 	= JFactory::getSession(); // Get the session
					$session->set(JApplication::getHash($secret.$recipient_matches[1]), $recipient_matches[1]); // Store the emails in the session using a key
					$recipient	= JApplication::getHash($secret.$recipient_matches[1]);
					JRequest::setVar('encodedrecipient',$recipient);
				}
		 		$image_matches = array();
	 			preg_match( "#image=\|(.*?)\|#s", $inline_params, $image_matches );
				if (isset($image_matches[1])){
					$pluginParams->set('show_image',$image_matches[1]);
				}else{
					$image_matches = array();
					preg_match( "#show_contact_image=\|(.*?)\|#s", $inline_params, $image_matches );
					if (isset($image_matches[1])){
						$pluginParams->set('show_image',$image_matches[1]);
					}
				}
	 			$contact_name_matches = array();
	 			preg_match( "#show_contact_name=\|(.*?)\|#s", $inline_params, $contact_name_matches );
				if (isset($contact_name_matches[1]) AND $contact_name_matches[1] > 0){
					$pluginParams->set('show_contact_name',$contact_name_matches[1]);
				}else{
					$contact_name_matches = array();
					preg_match( "#show_name=\|(.*?)\|#s", $inline_params, $contact_name_matches );
					if (isset($contact_name_matches[1]) AND $contact_name_matches[1] > 0){
						$pluginParams->set('show_contact_name',$contact_name_matches[1]);
					}
				}
	 			$contact_position_matches = array();
	 			preg_match( "#show_contact_position=\|(.*?)\|#s", $inline_params, $contact_position_matches );
	 			if (isset($contact_position_matches[1]) AND (strtolower($contact_position_matches[1]) == 'yes' OR intval($contact_position_matches[1]) == 1) ){
					$pluginParams->set('show_contact_position',true);
				}else{
					$contact_position_matches = array();
					preg_match( "#show_position=\|(.*?)\|#s", $inline_params, $contact_position_matches );
					if (isset($contact_position_matches[1]) AND (strtolower($contact_position_matches[1]) == 'yes' OR intval($contact_position_matches[1]) == 1) ){
						$pluginParams->set('show_contact_position',true);
					}
				}

				$misc_matches = array();
				$misc_options = array('before_details','after_details');
				preg_match( "#show_misc_info=\|(.*?)\|#s", $inline_params, $misc_matches );
				if (!isset($misc_matches[1]) OR !in_array(strtolower($misc_matches[1]), $misc_options)){
					$misc_matches = array();
					preg_match( "#show_misc=\|(.*?)\|#s", $inline_params, $misc_matches );
				}
				
				if (isset($misc_matches[1]) AND in_array(strtolower($misc_matches[1]), $misc_options)){
					$pluginParams->set('plg_show_misc_info',strtolower($misc_matches[1]));
					$misc_tab_matches = array();
					$misc_tab__options = array('yes','1','0','no');
					preg_match( "#show_misc_in_tab=\|(.*?)\|#s", $inline_params, $misc_tab_matches );
					if (isset($misc_tab_matches[1]) AND in_array(strtolower($misc_tab_matches[1]), $misc_tab__options)){
						$pluginParams->set('plg_show_misc_in_tab',strtolower($misc_tab_matches[1]));
				
					}
				}

				$layout_matches = array();
				$layout_options = array('tab','tabs','slider','sliders');
				preg_match( "#presentation_style=\|(.*?)\|#s", $inline_params, $layout_matches );
				if (isset($layout_matches[1]) AND in_array(strtolower($layout_matches[1]), $layout_options)){
					$pluginParams->set('plg_presentation_style',strtolower($layout_matches[1]));
					$layoutActiveTab_matches = array();
					$layoutActiveTab_options = array('details','map','form');
					preg_match( "#active_tab=\|(.*?)\|#s", $inline_params, $layoutActiveTab_matches );
					if (isset($layoutActiveTab_matches[1]) AND in_array(strtolower($layoutActiveTab_matches[1]), $layoutActiveTab_options)){
						$pluginParams->set('plg_active_tab',strtolower($layoutActiveTab_matches[1]));

					}
				}
		 		// Get Type option
	 			$type_matches = array();
				preg_match( "#type=\|(.*?)\|#s", $inline_params, $type_matches );
				if (isset($type_matches[1]) AND $type_matches[1] == 'modal'){
					$pluginParams->set('plg_display_type','modal');
					// Get Text option
		 			$text_matches = array();
					preg_match( "#text=\|(.*?)\|#s", $inline_params, $text_matches );
					if (isset($text_matches[1])){
						$pluginParams->set('plg_display_text', trim($text_matches[1]));
					}
					$width_matches = array();
					preg_match( "#modal_width=\|(.*?)\|#s", $inline_params, $width_matches );
					if (isset($width_matches[1])){
						$this->params->set('window-size-width', trim($width_matches[1]));
					}
					$height_matches = array();
					preg_match( "#modal_height=\|(.*?)\|#s", $inline_params, $height_matches );
					if (isset($height_matches[1])){
						$this->params->set('window-size-height', trim($height_matches[1]));
					}
					$template_matches = array();
					preg_match( "#modal_template=\|(.*?)\|#s", $inline_params, $template_matches );
					if (isset($template_matches[1])){
						jimport('joomla.filesystem.folder');
						if (JFolder::exists(JPATH_ROOT.'/templates/'.$template_matches[1])) {
							$this->params->set('template', trim($template_matches[1]));
						}
					}
					$modal_title_matches = array();
					preg_match( "#modal_title=\|(.*?)\|#s", $inline_params, $modal_title_matches );
					if (isset($modal_title_matches[1])){
						$this->params->set('modal-title', trim($modal_title_matches[1]));
					}
					$modal_footer_matches = array();
					preg_match( "#modal_footer=\|(.*?)\|#s", $inline_params, $modal_footer_matches );
					if (isset($modal_footer_matches[1])){
						$this->params->set('modal-footer', trim($modal_footer_matches[1]));
					}
					$modal_button_class_matches = array();
					preg_match( "#modal_button_class=\|(.*?)\|#s", $inline_params, $modal_button_class_matches );
					if (isset($modal_button_class_matches[1])){
						$this->params->set('modal_button_class', trim($modal_button_class_matches[1]));
					}
				}
				// Get Map option
	 			$map_matches = array();
				preg_match( "#map=\|(.*?)\|#s", $inline_params, $map_matches );
				if (isset($map_matches[1])){
					$pluginParams->set('show_map',$map_matches[1]);
				}else{
					preg_match( "#show_map=\|(.*?)\|#s", $inline_params, $map_matches );
					if (isset($map_matches[1])){
						$pluginParams->set('show_map',$map_matches[1]);
					}
				}

	 			$form_matches = array();
				preg_match( "#form=\|(.*?)\|#s", $inline_params, $form_matches );
				if (isset($form_matches[1])){
					$pluginParams->set('show_form',$form_matches[1]);
				}else{
					preg_match( "#show_form=\|(.*?)\|#s", $inline_params, $form_matches );
					if (isset($form_matches[1])){
						$pluginParams->set('show_form',$form_matches[1]);
					}
				}
				$custom_fields	= '';
	 			$field_matches	= array();
				preg_match( "#fields=\|(.*?)\|#s", $inline_params, $field_matches );
				if (isset($field_matches[1])){
					$field_matches[1]	= str_replace( '&amp;', '&', $field_matches[1] );
					// Get all Fields
					$custom_fields	= array();
					parse_str($field_matches[1], $custom_fields);

					//Encode email field
					if(isset($custom_fields['recipient']) AND $custom_fields['recipient']){
						$session 	= JFactory::getSession(); // Get the session
						$session->set(JApplication::getHash($secret.$recipient_matches[1]), $recipient_matches[1]); // Store the emails in the session using a key
						$custom_fields['encodedrecipient']	= JApplication::getHash($secret.$recipient_matches[1]);
					}
					if($pluginParams->get('plg_display_type') == 'modal'){
						$pluginParams->set('plg_modal_fields', http_build_query($custom_fields));
					}else{
						foreach ($custom_fields as $key => $value) {
							$jinput->set($key, $value);
						}
					}
				}
	 			if (isset($search_matches[1]) AND (empty($contactId)) ){
					$contactId	= $this->getContactID( $fields, $search_operator_match, $searchfrase_matches);
				}
	 		}
			
	 		$pluginParams->set('contactid',$contactId);
 			$contact= $this->loadContact( $contactId,$pluginParams,$row );
 			$row->text 	= str_replace($matches[0][$i], $contact, $row->text );
	 	}
	  	// removes tags without matchings
		$row->text = preg_replace( $regex, '', $row->text );
	}
	function loadContact( &$contactId,&$pluginParams,&$row)
	{
		require_once(JPATH_ROOT .'/components/com_contactenhanced/defines.php');
		require_once(JPATH_ROOT .'/components/com_contactenhanced/models/contact.php');
		require_once(JPATH_ROOT .'/components/com_contactenhanced/customFields.class.php');

		$comParams 	= JComponentHelper::getParams('com_contactenhanced');
		$session 	= JFactory::getSession();
		$document		= JFactory::getDocument();
		$document->addStyleSheet(JURI::base(true).'/components/com_contactenhanced/assets/css/ce.css');

		$app = JFactory::getApplication();

		$ceObj			= new JObject();
		$ceObj->params	= $app->getParams('com_contactenhanced');
		$ceObj->user	= JFactory::getUser();

		if($pluginParams->get('contact_postion')){
			$style	= ' style="float:'.$pluginParams->get('contact_postion').'; '.$pluginParams->get('contact_layer_style').'" ';
		}else{
			$style	= '';
		}
		$model		= JModelLegacy::getInstance('Contact', 'ContactenhancedModel', array('ignore_request' => true));
		$model->setState('contact.id', $contactId);
		$model->setState('params', $ceObj->params);
		// query options
		$options['id']		= $contactId;
		$options['aid']		= $ceObj->user->get('aid', 0);
		$ceObj->contact		= $model->getItem( $contactId );
		$ceObj->item		= &$ceObj->contact;
		if(!is_object($ceObj->contact)){
			return JText::sprintf('CE_PLUGIN_THERE_IS_NO_CONTACT_ID',$contactId);
		}
		$ceObj->customfields= $model->getCustomFields( $ceObj->contact->catid);
		// Adds parameter handling
		$registry	= new JRegistry();
		$registry->loadString($ceObj->contact->params);
		$ceObj->contact->params = $registry;
		$ceObj->params->merge($ceObj->contact->params);
		$ceObj->params->merge($pluginParams);
		$ceObj->params->set('plugin_active',1);
		JRequest::setVar('plugin_load_method','embedded');
		$this->contact	= &$ceObj->contact;
		$this->params->merge($ceObj->params);
		if($pluginParams->get('plg_display_type' ) == 'modal'){
			$params = array();
			$params['title']  = $this->params->get('modal-title', $ceObj->contact->name);
			$params['height'] = $this->params->get('window-size-height',480);
			$params['width']  = $this->params->get('window-size-width',800);
			$selector	= 'modal-contact-' . $contactId;
			$link	= JURI::root().('index.php?option=com_contactenhanced&amp;view=contact&amp;id='
						.$contactId
						.( isset($row->title) ? '&amp;content_title='.ceHelper::encode($row->title,'base64') : '')
						.'&amp;content_url='.ceHelper::encode(ceHelper::getCurrentURL(),'base64')
						.( JRequest::getVar('encodedrecipient')	? '&amp;encodedrecipient='.JRequest::getVar('encodedrecipient')	: '')
						.($this->params->get('modal',1)		? '&amp;tmpl=component' : '')
						.($this->params->get('template')	? '&amp;template='.$this->params->get('template')	: '')
						.(is_string($pluginParams->get('plg_modal_fields')) ? '&amp;'.$pluginParams->get('plg_modal_fields') : '')
						.'&amp;plugin_load_method=modal'
					);
			$params['url']	= $link;
			$attributes	= array();
			$attributes['id']	= $selector."-button";
			$attributes['role']	= "button";
			$attributes['data-toggle']	= "modal";
			$attributes['data-target']	= $selector;
			if(strpos($pluginParams->get('plg_display_text'),'<') === false){
				$attributes['title']= ($ceObj->contact->name);
			}else{
				$attributes['title']= $pluginParams->get('plg_display_text',$ceObj->contact->name);
			}
			$attributes['class']= $this->params->get('modal_button_class', ' btn btn-primary ') ;
			$html = array();
			$html[] = JHtml::_('link',$link, ($pluginParams->get('plg_display_text',$ceObj->contact->name) ),$attributes );

			$footer = str_replace(array("\n","\r"), '', $this->params->get('modal-footer', '') );

			$html[] = JHtml::_('bootstrap.renderModal', $selector, $params, $footer);
			$document->addScriptDeclaration("
jQuery(document).ready(function(){
	jQuery('#{$selector}-button').on('click',function(){ jQuery('#{$selector}').modal('show'); });
});"
);
			$document->addStyleDeclaration("#{$selector} .modal-body{overflow-y:hidden;padding:3px}#{$selector} iframe{border:0}");
			// If an $onClose event is passed, add it to the modal JS object
			if (strlen($pluginParams->get('plg_modal_on_close','')) >= 1)
			{
				$html[] = '<script>'
						. 'jQuery(\'#' . $selector . '\').on(\'hide\', function () {' . $pluginParams->get('plg_modal_on_close','') . ';});'
								. '</script>';
			}
			return implode("\n", $html);
		}else{
			if (isset($row->title)) {
				JRequest::setVar('content_title',ceHelper::encode($row->title,'base64'));
			}else{
				JRequest::setVar('content_title',ceHelper::encode($document->getTitle(),'base64'));
			}
			JRequest::setVar('content_url',ceHelper::encode(ceHelper::getCurrentURL(),'base64'));

			$html 	= '<div class="ce-contact_email" '.$style.'>';

			if($pluginParams->get('show_contact_name')){
				$html	.= '<h'.$pluginParams->get('show_contact_name','3').' class="contact-name">'
							.$ceObj->contact->name
							.'</h'.$pluginParams->get('show_contact_name','3').'>';
			}

			if($pluginParams->get('show_contact_position') AND $ceObj->contact->con_position){
				$html	.= '<small class="contact-position">'.$ceObj->contact->con_position.'</small>';
			}

			// In case form is sent and plugin setup to show thank you message when submitted
			if($session->get('contactenhanced_form_submitted') == true AND $pluginParams->get('after_submit') == 'thankyoumessage'){
				$session->set('contactenhanced_form_submitted', false);
				$html 	.= '<div class="ce-plugin-message">'.JText::_('COM_CONTACTENHANCED_EMAIL_THANKS').'</div>';
	 			$html 	.= '</div>';
	 			return $html;
			}elseif($session->get('contactenhanced_form_submitted') == true
					AND $comParams->get('thankyoupageType') == 'alert'
					AND $pluginParams->get('after_submit')	== 'global'
			){
				$session->set('contactenhanced_form_submitted', false);
				$document->addScriptDeclaration("jQuery(document).ready(function($){alert('".JText::_('COM_CONTACTENHANCED_EMAIL_THANKS')."');});");
			}
			if($pluginParams->get('after_submit','global') != 'global' OR $comParams->get('thankyoupageType') == 'alert'){
				$router	= $app->getRouter();
				$vars	= $router->getVars();
				$vars['msgsent']	= 1;
				$ceObj->return = JRoute::_('index.php?'.JURI::buildQuery($vars));

				if($pluginParams->get('after_submit') == 'thankyoumessage'){
					$ceObj->params->set('after_submit-javascript-show_system_message',0);
				}
			}


			if($pluginParams->get('plg_presentation_style') == 'sliders'){
				$html	.= JHtml::_('bootstrap.startAccordion', 'plg_slide-contact', array('active' => $pluginParams->get('plg_active_tab','details')));
			}elseif($pluginParams->get('plg_presentation_style') == 'tabs'){
				$html	.= JHtml::_('bootstrap.startTabSet', 'plg_ceTab', array('active' => $pluginParams->get('plg_active_tab','details')));
			}

			if($pluginParams->get('show_map') == 'before_form'
				OR $pluginParams->get('show_map') == 'beforeform'
				OR $pluginParams->get('show_map') == '1'
			){
				if($pluginParams->get('show_contact_details') == 'before_map'
					OR $pluginParams->get('show_contact_details') == 'beforemap'
				){
					$html	.= $this->loadContactDetails($ceObj, $pluginParams);
				}
				// Load map
				$html	.= $this->loadMap($ceObj,$comParams, $pluginParams);

				if($pluginParams->get('show_contact_details') == 'after_map'
					OR $pluginParams->get('show_contact_details') == 'aftermap'
				){
					$html	.= $this->loadContactDetails($ceObj, $pluginParams);
				}
			}
			if(	$pluginParams->get('show_contact_details') == 'before_form'
				OR $pluginParams->get('show_contact_details') == 'beforeform'
				OR $pluginParams->get('show_contact_details') == '1'
			){
				$html	.= $this->loadContactDetails($ceObj, $pluginParams);
			}

			// FORM
			if($pluginParams->get('show_form') != '0' AND $pluginParams->get('show_form') != 'no'){
				$html	.= $this->loadForm($ceObj, $pluginParams);
			}
			if($pluginParams->get('show_contact_details') == 'after_form'
				OR $pluginParams->get('show_contact_details') == 'afterform'
				OR $pluginParams->get('show_contact_details') == '2'
			){
				$html	.= $this->loadContactDetails($ceObj, $pluginParams);
			}
			if($pluginParams->get('show_map') == 'after_form'
				OR $pluginParams->get('show_map') == 'afterform'
				OR $pluginParams->get('show_map') == '2'
			){
				if($pluginParams->get('show_contact_details') == 'before_map' OR $pluginParams->get('show_contact_details') == 'beforemap'){
					$html	.= $this->loadContactDetails($ceObj, $pluginParams);
				}
				// Load map
				$html	.= $this->loadMap($ceObj,$comParams, $pluginParams);

				if($pluginParams->get('show_contact_details') == 'after_map' OR $pluginParams->get('show_contact_details') == 'aftermap'){
					$html	.= $this->loadContactDetails($ceObj, $pluginParams);
				}
			}

			if($pluginParams->get('plg_presentation_style') == 'sliders'){
				$html	.= JHtml::_('bootstrap.endAccordion');
			}elseif($pluginParams->get('plg_presentation_style') == 'tabs'){
				$html	.= JHtml::_('bootstrap.endTabSet');
			}

			$html	.= '</div>';
		}
		return $html;
	}

	protected function loadMap($ceObj,$comParams, $pluginParams){
		$html = '';
		if($pluginParams->get('plg_presentation_style') == 'sliders'){
			$html	.= JHtml::_('bootstrap.addSlide', 'plg_slide-contact', JText::_('CE_MAP',true), 'map');
		}elseif($pluginParams->get('plg_presentation_style') == 'tabs'){
			$html	.= JHtml::_('bootstrap.addtab', 'plg_ceTab', 'map', JText::_('CE_MAP',true));
		}
		$map	= ceHelper::loadMap($ceObj,$comParams);
		$html	.=  $map->showMap();

		if($pluginParams->get('plg_presentation_style') == 'sliders'){
			$html	.= JHtml::_('bootstrap.endSlide');
		}elseif($pluginParams->get('plg_presentation_style') == 'tabs'){
			$html	.= JHtml::_('bootstrap.endTab');
		}
		return $html;
	}

	protected function loadContactDetails($ceObj, $pluginParams){
		$showTabForMisc = (
							($pluginParams->get('plg_show_misc_in_tab') == 1 OR strtolower($pluginParams->get('plg_show_misc_in_tab')) == 'yes')
							AND
							($pluginParams->get('plg_presentation_style') == 'sliders' OR $pluginParams->get('plg_presentation_style') == 'tabs')
						);

		$html = '';

		if($showTabForMisc AND $pluginParams->get('plg_show_misc_info') == 'before_details'){
			$html	.= $this->loadContactMisc($ceObj, $pluginParams);
		}

		if($pluginParams->get('plg_presentation_style') == 'sliders'){
			$html	.= JHtml::_('bootstrap.addSlide', 'plg_slide-contact', JText::_('COM_CONTACTENHANCED_DETAILS',true), 'details');
		}elseif($pluginParams->get('plg_presentation_style') == 'tabs'){
			$html	.= JHtml::_('bootstrap.addtab', 'plg_ceTab', 'details', JText::_('COM_CONTACTENHANCED_DETAILS',true));
		}

		if(!$showTabForMisc AND $pluginParams->get('plg_show_misc_info') == 'before_details'){
			$html	.= $this->loadContactMisc($ceObj, $pluginParams);
		}

		$html	.= ceHelper::loadDetails($ceObj);
		$html	.= $this->loadExtraFields($ceObj);


		if(!$showTabForMisc AND $pluginParams->get('plg_show_misc_info') == 'after_details'){
			$html	.= $this->loadContactMisc($ceObj, $pluginParams);
		}

		if($pluginParams->get('plg_presentation_style') == 'sliders'){
			$html	.= JHtml::_('bootstrap.endSlide');
		}elseif($pluginParams->get('plg_presentation_style') == 'tabs'){
			$html	.= JHtml::_('bootstrap.endTab');
		}
		if($showTabForMisc AND $pluginParams->get('plg_show_misc_info') == 'after_details'){
			$html	.= $this->loadContactMisc($ceObj, $pluginParams);
		}
		return $html;
	}

	protected function loadContactMisc($ceObj, $pluginParams){
		$html = '';
		$showTabForMisc = (
							($pluginParams->get('plg_show_misc_in_tab') == 1 OR strtolower($pluginParams->get('plg_show_misc_in_tab')) == 'yes')
							AND
							($pluginParams->get('plg_presentation_style') == 'sliders' OR $pluginParams->get('plg_presentation_style') == 'tabs')
						);

		if($showTabForMisc){
			if($pluginParams->get('plg_presentation_style') == 'sliders'){
				$html	.= JHtml::_('bootstrap.addSlide', 'plg_slide-contact', JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_MISC_LABEL',true), 'misc');
			}elseif($pluginParams->get('plg_presentation_style') == 'tabs'){
				$html	.= JHtml::_('bootstrap.addtab', 'plg_ceTab', 'misc', JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_MISC_LABEL',true));
			}
		}

		$html .= $ceObj->contact->misc;

		if($showTabForMisc){
			if($pluginParams->get('plg_presentation_style') == 'sliders'){
				$html	.= JHtml::_('bootstrap.endSlide');
			}elseif($pluginParams->get('plg_presentation_style') == 'tabs'){
				$html	.= JHtml::_('bootstrap.endTab');
			}
		}

		return $html;
	}

	protected function loadForm($ceObj, $pluginParams){
		$input = JFactory::getApplication()->input;
		$session 	= JFactory::getSession();
		
		$html = '';
		if ($input->getCmd('msgsent')){
			if($session->get('contactenhanced_form_submitted') == $pluginParams->get('contactid')){
				if($pluginParams->get('after_submit') == 'javascript'
				){
					$session->set('contactenhanced_form_submitted', 'javascript');
					JFactory::getDocument()->addScriptDeclaration("
jQuery(document).ready(function($){alert('".JText::_('COM_CONTACTENHANCED_EMAIL_THANKS')."');});
");
				}elseif(!$pluginParams->get('after_submit-javascript-show_system_message',1)
						AND $pluginParams->get('after_submit') == 'reload')
				{
					$html = '<h3  class="text-info"><i class="icon-ok glyphicon glyphicon-ok"> </i> '.JText::_('COM_CONTACTENHANCED_EMAIL_THANKS').'</h3>';
				}
				
			}
		}
		
		if($pluginParams->get('plg_presentation_style') == 'sliders'){
			$html	.= JHtml::_('bootstrap.addSlide', 'plg_slide-contact', JText::_('COM_CONTACTENHANCED_EMAIL_FORM',true), 'form');
		}elseif($pluginParams->get('plg_presentation_style') == 'tabs'){
			$html	.= JHtml::_('bootstrap.addtab', 'plg_ceTab', 'form', JText::_('COM_CONTACTENHANCED_EMAIL_FORM',true));
		}

		$html	.= ceHelper::loadForm($ceObj, 'plugin');

		if($pluginParams->get('plg_presentation_style') == 'sliders'){
			$html	.= JHtml::_('bootstrap.endSlide');
		}elseif($pluginParams->get('plg_presentation_style') == 'tabs'){
			$html	.= JHtml::_('bootstrap.endTab');
		}
		return $html;
	}

	/**
	 * Get Contact ID based on search fields
	 * @param array	 $fields
	 * @param string $search_operator =, <>, >, <
	 * @param string $searchphrase, all, any
	 */
	public function getContactID($fields, $search_operator = '=',$searchphrase= 'all'){
		// Create a new query object.
		$db		= JFactory::getDbo();
		$query	= $db->getQuery(true);
		$query->select('a.id');
		$query->from('`#__ce_details` AS a');
		$query->where('a.published = 1');

		$wildCard	= (strtoupper($search_operator) == 'LIKE' ? '%' : '');

		$wheres	= array();
		foreach ($fields as $key => $value) {
			$wheres[]	= $key.' '.$search_operator.' '.$db->Quote($wildCard.$value.$wildCard);
		}
		if (JLanguageMultilang::isEnabled()) {
			$query->where('a.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}

		$query->where( '(' . implode(($searchphrase == 'all' ? ') AND (' : ') OR ('), $wheres) . ')' );
		$query->order('a.ordering ASC');
		$db->setQuery($query);
		return $db->loadResult();
	}
	/**
	 * Get Contact ID based on search fields
	 * @param array	 $fields
	 * @param string $search_operator =, <>, >, <
	 * @param string $searchphrase, all, any
	 */
	public function getNextContactID($fields, $search_operator = '=',$searchphrase= 'all'){
		// Create a new query object.
		$db		= JFactory::getDbo();
		$query	= $db->getQuery(true);

		$subQuery = $db->getQuery(true)
		->select('contact_id')
		->from('#__ce_messages AS m')
		->order('id DESC');
		$db->setQuery($subQuery);
		// gets the last contact id
		if ($lastContactID = $db->loadResult()) {
			$query->where('a.id > '.$lastContactID);
		}else{
			return $this->getContactID( $fields, $search_operator, $searchphrase);
		}
		$query->select('a.id');
		$query->from('`#__ce_details` AS a');
		$query->where('a.published = 1');
		$wildCard	= (strtoupper($search_operator) == 'LIKE' ? '%' : '');
		$wheres	= array();
		foreach ($fields as $key => $value) {
			$wheres[]	= $key.' '.$search_operator.' '.$db->Quote($wildCard.$value.$wildCard);
		}
		$query->where( '(' . implode(($searchphrase == 'all' ? ') AND (' : ') OR ('), $wheres) . ')' );

		if (JLanguageMultilang::isEnabled()) {
			$query->where('a.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}
		$query->order('a.ordering ASC');
		$db->setQuery($query);

		if ($nextContactID = $db->loadResult()) {
			return $nextContactID;
		}else{
			return $this->getContactID( $fields, $search_operator, $searchphrase);
		}
	}
	private function loadExtraFields(&$obj){
		$html = '';
		if (	($obj->params->get('show_extrafield_1') AND $obj->contact->extra_field_1)
			|| ($obj->params->get('show_extrafield_2') AND $obj->contact->extra_field_2)
			|| ($obj->params->get('show_extrafield_3') AND $obj->contact->extra_field_3)
			|| ($obj->params->get('show_extrafield_4') AND $obj->contact->extra_field_4)
			|| ($obj->params->get('show_extrafield_5') AND $obj->contact->extra_field_5)
			|| ($obj->params->get('show_extrafield_6') AND $obj->contact->extra_field_6)
			|| ($obj->params->get('show_extrafield_7') AND $obj->contact->extra_field_7)
			|| ($obj->params->get('show_extrafield_8') AND $obj->contact->extra_field_8)
			|| ($obj->params->get('show_extrafield_9') AND $obj->contact->extra_field_9)
			|| ($obj->params->get('show_extrafield_10') AND $obj->contact->extra_field_10)
		){
			$html .= '<div class="contact-extrafields" id="contact-extrafields">';
			for($i=1;$i<=10;$i++) {
				$extra_field	= 'extra_field_'.$i;
				if ($obj->params->get('show_extrafield_'.$i) AND $obj->contact->$extra_field){
					$html .= '<p>';
					if ($obj->params->get('show_extrafield_'.$i) == '1'){
						$html .= '<span class="'.$obj->params->get('marker_class').'" >';
							$html .= $obj->params->get('marker_extra_field_'.$i);
						$html .= '</span>';
					}
						$html .= '<span class="contact-extrafield-'.$i.'" >';
							$html .=  $obj->contact->$extra_field;
						$html .= '</span>';
					$html .= '</p>';
				}
			}
			$html .= '</div>';
		}
		return $html;
	}
}