<?php
/**
 * @package		CEcRON
 * @author		Douglas Machado {@link http://idealextensions.com}
 * @author		Created on 22-Jan-2011
 * @license		GNU/GPL, see license.txt
 */
defined('_JEXEC') or die;
jimport('joomla.plugin.plugin');
/**
 * Example System Plugin
 *
 * @package		CEFeedback
 * @subpackage	Plugin
 */
class plgSystemCECron extends JPlugin
{
	/**
	 * Object Constructor.
	 *
	 * @access	public
	 * @param	object	The object to observe -- event dispatcher.
	 * @param	object	The configuration object for the plugin.
	 * @return	void
	 * @since	1.0
	 */
	function __construct(&$subject, $config)
	{
		$lang = JFactory::getLanguage();
		// Load backend language file
		//Load English always, useful if file is partially translated
		$lang->load('plg_system_cecron',		JPATH_ROOT.'/plugins/system/cecron', 'en-GB');
		$lang->load('plg_system_cecron',		JPATH_ROOT.'/plugins/system/cecron', null, true);
		parent::__construct($subject, $config);
	}
	public function onAfterInitialise(){
		$app = JFactory::getApplication();
		// for testing only
		//	$this->params->set('lastCron', 999);
		if (!$app->isAdmin()) {
			$lastCron	= $this->params->get('lastCron',1);
			$interval	= $this->params->get('interval',43200); // 900 seconds = 15 minutes
			if( !empty($lastCron) AND ($lastCron + $interval) < time()){
				//update LastCron
				$this->SetParams('lastCron',(time()) );
				if($app->input->getString('cecronkey') == $this->params->get('method-cron-keyword')
					AND $this->params->get('method') == 'cron'
				){
					$this->run();
				}elseif($this->params->get( 'method') == 'pageload'){
					$this->run();
				}
			}
		}elseif ($app->isAdmin() AND $app->input->get('option') == 'com_plugins'){
			// Check if curl is loaded
			if (!extension_loaded('curl')) {
				$app->enqueueMessage( JText::_('Social Auto Publish will not work because CURL extension is not loaded.'), 'error' );
			}
		}
		return '';
	}
	private function run(){
		$lang = JFactory::getLanguage();
		// Load backend language file
		//Load English always, useful if file is partially translated
		$lang->load('com_contactenhanced',		JPATH_ADMINISTRATOR.'/components/com_contactenhanced', 'en-GB');
		$lang->load('com_contactenhanced',		JPATH_ADMINISTRATOR.'/components/com_contactenhanced', null, true);
		//Load site language file
		$lang->load('com_contactenhanced',		JPATH_ROOT.'/components/com_contactenhanced', 'en-GB');
		$lang->load('com_contactenhanced',		JPATH_ROOT.'/components/com_contactenhanced', null, true);
		if ($this->params->get('send_report')) {
			$this->send_report();
		}
	}
	private function send_report(){
		$app			= JFactory::getApplication();
		$lastCron	= $this->params->get('lastCron',1);
		jimport('joomla.utilities.date');
		jimport('joomla.application.component.model');
		$com_path = JPATH_ADMINISTRATOR.'/components/com_contactenhanced/';
		JModelLegacy::addIncludePath($com_path . 'models', 'ContactenhancedModel');
		// Get an instance of the generic Messages model
		$model = JModelLegacy::getInstance('Messages', 'ContactenhancedModel', array('ignore_request' => true));
		$model->setState('list.ordering', 		'msg.id');
		$model->setState('list.direction',		'DESC');
		// get from selected date only:
		$model->setState('filter.date_filtering',	'range');
		$model->setState('filter.start_date_range',	date('Y-m-d H:i:s',$lastCron)); // No offset configuration
		$nowDate	= (JFactory::getDate()->toSql());
		$model->setState('filter.end_date_range',	$nowDate);
		$items = $model->getItems();
		$html	= '';
		$table	= '';

		if(count($items) > 0){
			$table='<table>
				<tr>
					<th>
					'.JText::_('CE_MSG_NAME').'
					</th>

					<th class="hidden-phone">
						'.JText::_('CE_MSG_EMAIL').'
					</th>
					<th>
						'.JText::_('CE_MSG_SUBJECT').'
					</th>

					<th class="hidden-phone">
						'.JText::_('JDATE').'
					</th>
					<th class="hidden-phone">
						'.JText::_('CE_MSG_CONTACT_NAME').'
					</th>
					<!-- th width="1%" class="hidden-phone">
						'.JText::_('JGRID_HEADING_ID').'
					</th -->
				</tr>
				';
			$n = count($items);
			foreach ($items as $i => $item){
				$style = ($i % 2 ? 'background-color:f9f9f9;' : '').'padding:5px;';
				$table .= '<tr style="'.$style.'">
							<td>'.$item->from_name.'</td>
							<td>'.$item->from_email.'</td>
							<td>'.$item->subject.'</td>
							<td>'.$item->date.'</td>
							<td>'.$item->contact_name.'</td>
							<!-- td>'.$item->id.'</td -->
						</tr>';
			}
			$table .= '</table>';
		}elseif($this->params->get('sendEmptyReport',0)){
			$table .= '<h3>'.JText::_('JGLOBAL_SELECT_NO_RESULTS_MATCH').'</h3>';
		}else{
			return '';
		}
		$html .= ''.JText::_('PLG_SYSTEM_CECRON_REPORT_INTRO').'';
		$html .= '<h3>'.JText::_('PLG_SYSTEM_CECRON_REPORT_TITLE').'</h3>';
		$html .= $table;
		$html = '<html><body style="margin:0">'.$html.'</body></html>';
		$mail		= JFactory::getMailer();
		$mail->setSubject( JText::_('PLG_SYSTEM_CECRON_REPORT_TITLE'));
		$mail->setSender(array($app->getCfg('mailfrom'), $app->getCfg('fromname') ));
		$mail->MsgHTML( $html);
		// Send to group only if it was correctly sent to teh default recipient
		if($this->params->get('link_usergroup') > 1 ){
			$link_usergroup	= $this->getUsersByGroup($this->params->get('link_usergroup'));
			if(is_array($link_usergroup)){
				foreach ($link_usergroup as $user){
					$mail->addRecipient($user->email );
					$sent = $mail->Send();
					$mail->ClearAddresses();
				}
			}
		}
		if($this->params->get('recipient') ){
			$mail->addRecipient($this->params->get('recipient') );
			$sent = $mail->Send();
		}
	}
	private function getUsersByGroup($groups) {
		jimport('joomla.application.component.model');
		JModelLegacy::addIncludePath(JPATH_SITE.'/administrator/components/com_users/models');
		// Get an instance of the generic users model
		$users = JModelLegacy::getInstance('Users', 'UsersModel', array('ignore_request' => true));
		// Set the filters based on the module params
		$users->setState('list.start', 0);
		$users->setState('list.limit', 9999999);
		$users->setState('filter.published', 1);
		if (isset($groups)){
			JArrayHelper::toInteger($groups);
		}
		$users->setState('filter.groups', $groups);
		$users	= $users->getItems();
		return $users;
	}
	private function SetParams($key,$value) {
		if(!function_exists('json_decode')) {
			function json_decode($json) {
				$comment = false;
				$out = '$x=';
				for ($i=0; $i<strlen($json); $i++){
					if (!$comment){
						if (($json[$i] == '{') || ($json[$i] == '['))
							$out .= ' array(';
						else if (($json[$i] == '}') || ($json[$i] == ']'))
							$out .= ')';
						else if ($json[$i] == ':')
							$out .= '=>';
						else
							$out .= $json[$i];
					}else
						$out .= $json[$i];
					if ($json[$i] == '"' && $json[($i-1)]!="\\")
						$comment = !$comment;
				}
				eval($out . ';');
				return $x;
			}
		}
		if(!function_exists('json_encode')){
			function json_encode($a=false)
			{
				// Some basic debugging to ensure we have something returned
				if (is_null($a)) return 'null';
				if ($a === false) return 'false';
				if ($a === true) return 'true';
				if (is_scalar($a)) {
					if (is_float($a)) {
						// Always use '.' for floats.
						return floatval(str_replace(',', '.', strval($a)));
					}
					if (is_string($a)) {
						static $jsonReplaces = array(array('\\', '/', "\n", "\t", "\r", "\b", "\f", '"'), array('\\\\', '\\/', '\\n', '\\t', '\\r', '\\b', '\\f', '\"'));
						return '"' . str_replace($jsonReplaces[0], $jsonReplaces[1], $a) . '"';
					}
					else
						return $a;
					}
					$isList = true;
					for ($i = 0, reset($a); true; $i++) {
						if (key($a) !== $i) {
							$isList = false;
							break;
						}
					}
					$result = array();
					if ($isList) {
						foreach ($a as $v) $result[] = json_encode($v);
						return '[' . join(',', $result) . ']';
					}else{
						foreach ($a as $k => $v) $result[] = json_encode($k).':'.json_encode($v);
							return '{' . join(',', $result) . '}';
					}
				}
			}
		$db=JFactory::getDBO();
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__extensions');
		$query->where(("element")."=".$db->Quote('cecron'));
		$db->setQuery($query);
		$contents = $db->loadObject();
		$params = json_decode($contents->params);
		$params->{$key}=$value;
		$params = json_encode($params);
		$query = $db->getQuery(true);
		$query->update('#__extensions');
		$query->where(("element")."=".$db->Quote('cecron'));
		$query->set(('params')."= ".$db->Quote($params));
		$db->setQuery($query);
		$result = $db->query();
		$db->freeResult($result);
	}
}