<?php
/**
 *
 * Contact Creator
 * A tool to automatically create and synchronise contacts with a user
 * @copyright	Copyright (C) 2005 - 2009 Open Source Matters, Inc. All rights reserved.
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
// No direct access.
defined('_JEXEC') or die;

/**
 * Class for Contact Creator
 * @package		Joomla.Plugin
 * @subpackage	User.contactcreator
 * @version		1.6
 */
class plgUserCe_ContactCreator extends JPlugin
{
	/**
	 * Constructor
	 *
	 * @access	  protected
	 * @param	   object  $subject The object to observe
	 * @param	   array   $config  An array that holds the plugin configuration
	 * @since	   1.5
	 */
	public function __construct(& $subject, $config)
	{
		parent::__construct($subject, $config);
		$this->loadLanguage();

		$lang =JFactory::getLanguage();
		$lang->load('com_contactenhanced',		JPATH_ADMINISTRATOR.'/components/com_contactenhanced', 'en-GB');
		$lang->load('com_contactenhanced',		JPATH_ADMINISTRATOR.'/components/com_contactenhanced');
		$lang->load('plg_user_ce_contactcreator',dirname(__FILE__), 'en-GB');
		$lang->load('plg_user_ce_contactcreator',dirname(__FILE__));
	}

	function onUserAfterSave($user, $isnew, $success, $msg)
	{
		if(!is_file(JPATH_ROOT.'/components/com_contactenhanced/controller.php')){
			return false; // Contact Enhanced is not installed;
		}

		if(!$success) {
			return false; // if the user wasn't stored we don't resync
		}



		// ensure the user id is really an int
		$user_id = (int)$user['id'];

		if (empty($user_id)) {
			die('invalid userid');
			return false; // if the user id appears invalid then bail out just in case
		}

		$category = $this->params->get('category', 0);
		if (empty($category)) {
			JError::raiseWarning(41, JText::_('PLG_CE_CONTACTCREATOR_ERR_NO_CATEGORY'));
			return false; // bail out if we don't have a category
		}

		$dbo = JFactory::getDBO();
		// grab the contact ID for this user; note $user_id is cleaned above
		$dbo->setQuery('SELECT id FROM #__ce_details WHERE user_id = '. $user_id );
		$id = $dbo->loadResult();

		require_once(JPATH_ROOT.'/components/com_contactenhanced/helpers/helper.php');
		JTable::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_contactenhanced/tables');
		$contact = JTable::getInstance('contact', 'ContactenhancedTable');

		if (!$contact) {
			return false;
		}

		// Sync only if user is new or updated but has no contact linked to user_id
		if(!$isnew && $id) { //if(!$isnew) { //isNotNew and has a Contact
			// if the user isn't new we only sync name and email address
			$this->syncContact($user);
			return false;
		}

		if ($id) {
			$contact->load($id);
		}elseif($this->params->get('autopublish', 0)) {
			$contact->published = 1;
		}elseif($this->params->get('autopublish', 0) == 0) {
			$contact->published = -3;
		}
		$lang = JFactory::getLanguage();

		$contact->name		= $user['name'];
		$contact->user_id	= $user_id;
		$contact->email_to	= $user['email'];
		$contact->catid		= $category;
		$contact->language	= $lang->getTag();
		$contact->access	= $this->params->get('access',1);

		$autowebpage = $this->params->get('autowebpage', '');

		if ($this->params->get('copyProfile')) {
			// Get user profile
			$defProfile = JUserHelper::getProfile($user_id)->profile;
			if(!empty($defProfile['address1'])){
				$contact->address	= $defProfile['address1'];
				if(!empty($defProfile['address2'])){
					$contact->address   .= "\n".$defProfile['address2'];
				}
			}elseif(!empty($defProfile['address2'])){
				$contact->address   = $defProfile['address2'];
			}
			if(!empty($defProfile['city'])){
				$contact->suburb	= $defProfile['city'];
			}
			if(!empty($defProfile['region'])){
				$contact->state	= $defProfile['region'];
			}
			if(!empty($defProfile['postal_code'])){
				$contact->postcode	= $defProfile['postal_code'];
			}
			if(!empty($defProfile['country'])){
				$contact->country	= $defProfile['country'];
			}
			if(!empty($defProfile['phone'])){
				$contact->telephone	= $defProfile['phone'];
			}
			if(!empty($defProfile['website'])){
				$contact->webpage	= $defProfile['website'];
			}
			if(!empty($defProfile['favoritebook'])){
				$contact->extra_field_5	= $defProfile['favoritebook'];
			}
			if(!empty($defProfile['aboutme'])){
				$contact->misc		= $defProfile['aboutme'];
			}
			if(!empty($defProfile['dob'])){
				$contact->birthdate	= $defProfile['dob'];
			}
		}


		if (!empty($autowebpage)) {
			// search terms
			$search_array = array('[name]', '[username]', '[userid]', '[email]');
			// replacement terms, urlencoded
			$replace_array = array_map('urlencode', array($user['name'], $user['username'], $user['id'], $user['email']));
			// now replace it in together
			$contact->webpage = str_replace($search_array, $replace_array, $autowebpage);
		}

		if ($contact->check()) {
			$result = $contact->store();
		}

		if (!(isset($result)) || !$result) {
			JError::raiseError(42, JText::sprintf('PLG_CE_CONTACTCREATOR_ERR_FAILED_UPDATE', $contact->getError()));
		}
	}

	private function syncContact($user){
		$db			= JFactory::getDbo();
		$query		= $db->getQuery(true);

		if(!($this->params->get('enable_sync')) AND in_array('email', $this->params->get('enable_sync'))){
			$query->update('#__ce_details')
				->set('email_to ='.$db->quote($user['email']))
				->where('user_id='.$db->quote($user['id']));
			$db->setQuery($query);
			$db->query();
		}
		if(!($this->params->get('enable_sync')) AND in_array('name', $this->params->get('enable_sync'))){
			$query->update('#__ce_details')
				->set('name ='.$db->quote($user['name']))
				->where('user_id='.$db->quote($user['id']));
			$db->setQuery($query);
			$db->query();
		}

	}
}
