<?php
/**
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.controllerform');

JTable::addIncludePath(JPATH_COMPONENT.'/tables');
JModelLegacy::addIncludePath(JPATH_COMPONENT.'models');

/**
 * @package		com_contactenhanced
* @since	1.6
 */
class ContactenhancedControllerCannedanswer extends JControllerForm
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since	1.6
	 */
	protected $text_prefix	= 'CE_MSG'; 
	/**
	 * Constructor.
	 *
	 * @param	array An optional associative array of configuration settings.
	 * @see		JController
	 */
	public function __construct($config = array())
	{
		parent::__construct($config);
		$this->registerTask('view',	'edit');

	}
	
	/**
	 * Returns a Table object, always creating it
	 *
	 * @param	type	The table type to instantiate
	 * @param	string	A prefix for the table class name. Optional.
	 * @param	array	Configuration array for model. Optional.
	 * @return	JTable	A database object
	 * @since	1.6
	 */
	public function getTable($type = 'Cannedanswer', $prefix = 'ContactenhancedTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}
	
	/**
	 * 
	 */
	public function add()
	{
		$app = JFactory::getApplication();
		$input = $app->input;
		JTable::addIncludePath(JPATH_COMPONENT.'/tables');
		$table = $this->getTable();
		
		$table->bind(array());
		$status = 0;
		$id = 0;
		$html = '';
		if(($table->store())){
			$status = 1;
			$id = $table->id;
			$html = '<div class="row-fluid" id="ca-'.$id.'" data-id="'.$id.'" data-title="'.$table->title.'"  data-text="'.htmlentities($table->text).'" >'
						.'<div class="span9 col-md-9"><a class="ca-copy" href="#ca" title="'.strip_tags($table->text).'">'.$table->title.'</a></div> '
						.'<div class="span1 col-md-1"><a class="ca-edit pull-right" href="#ca" title="'.JText::_('JTOOLBAR_EDIT').'"><i class="icon-pencil  glyphicon glyphicon-pencil"></i></a></div>'
						.'<div class="span1 col-md-1"><a class="ca-remove pull-right" href="#ca" title="'.JText::_('JTOOLBAR_DELETE').'"><i class="icon-remove  glyphicon glyphicon-remove"></i></a></div>'
					.'</div>';
		}
		
		$json	=array('status'=> $status, 'msg' => '', 'html' => $html, 'id' => $id );
		$this->jsonReturn($json);
		
	
	}
	
	public function remove()
	{
		$app	= JFactory::getApplication();
		$input	= $app->input;
		$model	= $this->getModel('cannedanswer');
		//echo ceHelper::print_r($model); exit;
		$id 	= (array)$input->getInt('id');
		$status	= $model->delete($id);
		$json	= array('status'=> $status, 'msg' => '', 'html' => '');
		$this->jsonReturn($json);
	}
	
	
	public function jsonReturn($json){
		header('Content-type: application/json; charset=UTF-8');
		echo json_encode( $json ); exit();
	}
}