<?php
/**
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.controllerform');

/**
 * @package		com_contactenhanced
* @since	1.6
 */
class ContactenhancedControllerContact extends JControllerForm
{
/**
	 * Method override to check if you can add a new record.
	 * @param	array	$data	An array of input data.
	 * @return	boolean
	 * @since	1.6
	 */
	protected function allowAdd($data = array()){
		// Initialise variables.
		$user		= JFactory::getUser();
		$categoryId	= JArrayHelper::getValue($data, 'catid', JRequest::getInt('filter_category_id'), 'int');
		$allow		= null;

		if($categoryId) {
			// If the category has been passed in the URL check it.
			$allow	= $user->authorise('core.create', $this->option.'.category.'.$categoryId);
		}

		if($allow === null) {
			// In the absense of better information, revert to the component permissions.
			return parent::allowAdd($data);
		}
		else{
			return $allow;
		}
	}
	/**
	 * Method override to check if you can edit an existing record.
	 * @param	array	$data	An array of input data.
	 * @param	string	$key	The name of the key for the primary key.
	 * @return	boolean
	 * @since	1.6
	 */
	protected function allowEdit($data = array(), $key = 'id'){
		// Initialise variables.
		$recordId	= (int) isset($data[$key]) ? $data[$key] : 0;
		$user		= JFactory::getUser();
		$userId		= $user->get('id');
		$categoryId	= (int) isset($data['catid']) ? $data['catid'] : 0;
		// Check general edit permission first.
		if($user->authorise('core.edit', $this->option.'.category.'.$categoryId)) {
			return true;
		}
		// Fallback on edit.own.
		// First test if the permission is available.
		if($user->authorise('core.edit.own', $this->option.'.category.'.$categoryId)) {
			// Now test the owner is the user.
			$ownerId	= (int) isset($data['created_by']) ? $data['created_by'] : 0;
			if (empty($ownerId) && $recordId) {
				// Need to do a lookup from the model.
				$record		= $this->getModel()->getItem($recordId);
				if(empty($record)){
					return false;
				}
				$ownerId = $record->created_by;
			}
			// If the owner matches 'me' then do the test.
			if($ownerId == $userId) {
				return true;
			}
		}
		// Since there is no asset tracking, revert to the component permissions.
		return parent::allowEdit($data, $key);
	}

	/**
	 * Method to run batch operations.
	 * @param   object  $model  The model.
	 * @return  boolean	 True if successful, false otherwise and internal error is set.
	 * @since   2.5
	 */
	public function batch($model = null)
	{
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
		// Set the model
		$model = $this->getModel('Contact', '', array());
		// Preset the redirect
		$this->setRedirect(JRoute::_('index.php?option=com_contactenhanced&view=contacts' . $this->getRedirectToListAppend(), false));
		return parent::batch($model);
	}

	public function save($key = null, $urlVar = null)
	{
		$data  = $this->input->post->get('jform', array(), 'array');
		$this->syncUser($data);
		if($this->input->post->get('createUser') == '1'){
			require_once JPATH_ROOT.'/components/com_contactenhanced/helpers/user.php';
			$userId			= ceUserHelper::createUser($data);
			$data['user_id']= $userId;
			$this->input->post->set('jform', $data);
		}
		return parent::save($key,$urlVar);
	}
	private function syncUser($data){
		$params		= JComponentHelper::getParams('com_contactenhanced');
		$db			= JFactory::getDbo();
		$query		= $db->getQuery(true);
		$user		= JFactory::getUser();

		if($params->get('show_email_edit') == 'sync'
			AND isset($data['email_to'])
			AND trim($data['email_to']) != ''
			AND isset($data['user_id'])
		){
			$query->update('#__users')
			->set('email ='.$db->quote($data['email_to']))
			->where('id='.$db->quote($data['user_id']));
			$db->setQuery($query);
			$db->query();
		}
		if($params->get('show_name_edit') == 'sync'
			AND isset($data['name'])
			AND trim($data['name']) != ''
			AND isset($data['user_id'])
		){
			$query->update('#__users')
			->set('name ='.$db->quote($data['name']))
			->where('id='.$db->quote($data['user_id']));
			$db->setQuery($query);
			$db->query();
		}
	}
}