<?php
/**
 * @package	 com_contactenhanced
 * @copyright   Copyright (C) 2006 - 2014 IdealExtensions.com. All rights reserved.reserved.
 * @license	 GNU GPL2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

// Include the component HTML helpers.
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('formbehavior.chosen', 'select');

$app 	= JFactory::getApplication();
$assoc 	= JLanguageAssociations::isEnabled();
$input 	= $app->input;
?>
<script type="text/javascript">
	Joomla.submitbutton = function(task)
	{
		if (task == 'contact.cancel' || document.formvalidator.isValid(document.id('contact-form'))) {
			<?php echo $this->form->getField('misc')->save(); ?>
			<?php echo $this->form->getField('sidebar')->save(); ?>
			<?php echo $this->form->getField('extra_field_1')->save(); ?>
			<?php echo $this->form->getField('extra_field_2')->save(); ?>
			<?php echo $this->form->getField('extra_field_3')->save(); ?>
			<?php echo $this->form->getField('extra_field_4')->save(); ?>
			<?php echo $this->form->getField('extra_field_4')->save(); ?>
			<?php // echo $this->form->getField('extra_field_5')->save(); ?>
			Joomla.submitform(task, document.getElementById('contact-form'));
		}
		else{
			alert('<?php echo $this->escape(JText::_('JGLOBAL_VALIDATION_FORM_FAILED'));?>');
		}
	}
</script>
<?php
JFactory::getDocument()->addScriptDeclaration("
jQuery(document).ready(function($){
	$('.createUser').on('change',function(){
 		if($(this).val() == 1){
 			$('#userControlGroup').css('display','none');
 		}else{
 			$('#userControlGroup').css('display','block');
 		}
	});
});
");
?>
<form action="<?php echo JRoute::_('index.php?option=com_contactenhanced&layout=edit&id='.(int) $this->item->id); ?>"
		method="post"
		name="adminForm"
		id="contact-form"
		class="form-validate form-horizontal">

		<?php echo JLayoutHelper::render('joomla.edit.title_alias', $this); ?>

		<?php ?>
		<div class="form-horizontal">
		<?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'details')); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'details', empty($this->item->id) ? JText::_('COM_CONTACTENHANCED_NEW_CONTACT', true) : JText::sprintf('COM_CONTACTENHANCED_EDIT_CONTACT', $this->item->id, true)); ?>
		<div class="row-fluid">
			<div class="span9">
				<div class="row-fluid form-horizontal-desktop">
					<div class="span6">
					<?php if (!$this->item->id): ?>
						<div class="control-group">
							<div class="control-label"><label><?php echo JText::_('COM_CONTACTENHANCED_FIELD_REGISTRATION_LABEL'); ?></label></div>
							<div class="controls">
								<label><input type="radio" value="0" name="createUser" class="createUser" checked="checked" />
									<?php echo JText::_('JNO'); ?>
								</label>
								<label><input type="radio" value="1" name="createUser" class="createUser" />
									<?php echo JText::_('JYES'); ?>
								</label>
							</div>
						</div>
						<?php endif; ?>
						<div id="userControlGroup">
						<?php echo $this->form->getControlGroup('user_id'); ?>
						</div>
						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('image'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('image'); ?></div>
						</div>
						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('category_image'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('category_image'); ?></div>
						</div>
						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('department'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('department'); ?></div>
						</div>
						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('con_position'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('con_position'); ?></div>
						</div>
						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('email_to'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('email_to'); ?></div>
						</div>
						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('address'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('address'); ?></div>
						</div>
						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('suburb'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('suburb'); ?></div>
						</div>
						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('state'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('state'); ?></div>
						</div>
						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('postcode'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('postcode'); ?></div>
						</div>
						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('country'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('country'); ?></div>
						</div>
					</div>
					<div class="span6">
						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('telephone'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('telephone'); ?></div>
						</div>
						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('mobile'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('mobile'); ?></div>
						</div>
						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('fax'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('fax'); ?></div>
						</div>
						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('skype'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('skype'); ?></div>
						</div>

						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('twitter'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('twitter'); ?></div>
						</div>

						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('facebook'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('facebook'); ?></div>
						</div>

						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('linkedin'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('linkedin'); ?></div>
						</div>

						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('webpage'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('webpage'); ?></div>
						</div>
							<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('birthdate'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('birthdate'); ?></div>
						</div>
						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('sortname1'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('sortname1'); ?></div>
						</div>
						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('sortname2'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('sortname2'); ?></div>
						</div>
						<div class="control-group">
							<div class="control-label"><?php echo $this->form->getLabel('sortname3'); ?></div>
							<div class="controls"><?php echo $this->form->getInput('sortname3'); ?></div>
						</div>
					</div>
				</div>
			</div>
			<div class="span3">
				<?php echo JLayoutHelper::render('joomla.edit.global', $this); ?>
			</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'maps', JText::_('CE_CONFIG_MAP', true)); ?>
		<?php echo $this->loadTemplate('map'); ?>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'misc', JText::_('COM_CONTACTENHANCED_CONTACT_MISC_INFO', true)); ?>
		<div class="row-fluid form-horizontal-desktop">
				<div class="form-vertical">
					<?php  echo $this->form->getControlGroup('misc'); ?>
				</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'sidebar', JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_SIDEBAR_LABEL', true)); ?>
		<div class="row-fluid form-horizontal-desktop">
				<div class="form-vertical">
				<?php echo $this->form->getControlGroup('sidebar'); ?>
				</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'extraFields', JText::_('CE_CONTACT_EF', true)); ?>
		<?php echo $this->loadTemplate('extrafields'); ?>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'publishing', JText::_('JGLOBAL_FIELDSET_PUBLISHING', true)); ?>
		<div class="row-fluid form-horizontal-desktop">
			<div class="span6">
				<?php echo JLayoutHelper::render('joomla.edit.publishingdata', $this); ?>
			</div>
			<div class="span6">
				<?php echo JLayoutHelper::render('joomla.edit.metadata', $this); ?>
			</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		<?php echo JLayoutHelper::render('joomla.edit.params', $this); ?>

		<?php if($assoc) : ?>
			<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'associations', JText::_('JGLOBAL_FIELDSET_ASSOCIATIONS', true)); ?>
			<?php echo $this->loadTemplate('associations'); ?>
			<?php echo JHtml::_('bootstrap.endTab'); ?>
		<?php endif; ?>

		<?php echo JHtml::_('bootstrap.endTabSet'); ?>
	</div>
	<input type="hidden" name="task" value="" />
	<?php echo JHtml::_('form.token'); ?>
</form>

