<?php
/**
 * @package		com_contactenhanced
* @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @author	 	Douglas Machado {@link http://idealextensions.com}
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
?>
<div class="tab-pane" id="maps">
<div class="control-group">

<?php
if($this->params->get('maps_show',1)){
	$params = &$this->params;
	$this->contact = &$this->item;
	$map	= ceHelper::loadMap($this, $params);
	$doc	= JFactory::getDocument();
	$config = JFactory::getConfig ();
	JHtml::_('jquery.framework');

	$http	= 'http' . (ceHelper::httpIsSecure () ? 's://' : '://');
	// Please keep in this order
	$doc->addScript ( '//google.com/jsapi' );
	$doc->addScript ( '//maps.google.com/maps/api/js?sensor=false');
	if($config->get ( 'config.debug' ) OR $config->get ( 'config.error_reporting' ) == 'development') {
		$doc->addScript ( JURI::root().'components/com_ enhanced/assets/js/jquery.ui.map/jquery.ui.map.full.js' );
	}else{
		$doc->addScript ( JURI::root().'components/com_contactenhanced/assets/js/jquery.ui.map/jquery.ui.map.full.min.js' );
	}

	$script	= "
function getAddress(){
	jQuery('#googleaddress').val(
	  	jQuery('#jform_address').val()
	  	+', '+ jQuery('#jform_suburb').val()
	  	+', '+ jQuery('#jform_state').val()
	  	+', '+ jQuery('#jform_postcode').val()
	  	+', '+ jQuery('#jform_country').val()
	  	);
	if(parseInt(jQuery('#jform_zoom').val()) == 0){
		jQuery('#jform_zoom').val(15);
	}
}
jQuery(document).ready(function($){
	$('#myTabTabs li').click( function(event){
		setTimeout(function(){ $('#map_canvas').gmap('refresh')});
	});
});

jQuery(document).ready(function($){
	function addMarker(latLng) {
		$('#map_canvas').gmap('addMarker', {
				'id': 		'm_1',
				'position':	latLng,
				'draggable':true,
				'bounds':	true
			}).dragend( function(event) {
				setFormLatLng(event.latLng);
			});
		setFormLatLng(latLng);
	}
	function findLocation(address) {
		jQuery('#map_canvas').gmap('search',
					{'address':address},
					function(results, status) {
						if ( status === 'OK' ) {
							var marker	= jQuery('#map_canvas').gmap('get', 'markers > m_1');
							var latLng	= results[0].geometry.location;
							if(marker == null ){
								addMarker(latLng);
								$('#map_canvas').gmap('option', 'zoom', 15);
							}else{
								marker.set('position',latLng);
								setFormLatLng(latLng);
							}
							var map		= jQuery('#map_canvas').gmap('get', 'map');
							map.panTo(latLng);
						}
					});

	}
	$('#map_canvas').gmap().bind('init', function(event, map) {
		google.maps.event.addListener(map, 'zoom_changed', function() {
			$('#jform_zoom').val(map.getZoom());
		});"
		.(
			($this->item->lat AND $this->item->lng) ? "
			var latLng = new google.maps.LatLng({$this->item->lat}, {$this->item->lng});
			addMarker(latLng);"
			: ""
		)
		."".(
			($this->item->zoom) ? "
			$('#map_canvas').gmap('option', 'zoom', {$this->item->zoom});"
			: ""
		)
		."
		var flag = false;
		$(map).mouseover( function(event){
			if(!flag){
				$('#map_canvas').gmap('refresh');
				flag = true;
			}
		});

	});
	function setFormLatLng(latLng) {
		$('#jform_lat').val(latLng.lat());
		$('#jform_lng').val(latLng.lng());
	}

	function mapLatLng() {
		var latLng	= new google.maps.LatLng($('#jform_lat').val(),$('#jform_lng').val());
		var marker	= $('#map_canvas').gmap('get', 'markers > m_1');
		if(marker == null ){
			addMarker(latLng);
			$('#map_canvas').gmap('option', 'zoom', 15);
		}else{
			marker.set('position',latLng);
		}
		var map		= $('#map_canvas').gmap('get', 'map');
		map.panTo(latLng);
	}
	$('input.address').blur( function(e) {
			getAddress();
	});
	$('#jform_lat').blur(function(e) {
		mapLatLng();
	});
	$('#jform_lng').blur( function(e) {
		mapLatLng();
	});
	getAddress();
	$('#locateinmap').click(function(e){
		$('#map_canvas').gmap('refresh');
		findLocation(document.getElementById('googleaddress').value);
	});

});
";
	$doc->addScriptDeclaration($script);

	$html 	= "\n<!-- DIV container for the map -->";
	$html 	.= '
				<div class="cemap_container">
					<div id="map_canvas"
						style="height:300px"
						class="cemap_canvas">
					</div>
				</div>
				';

		echo '<input 	type="button" 	value="'.JText::_('CE_CONTACT_LOCATE_IN_MAP').'" id="locateinmap"  /> ';
		echo ' <input 	type="text" 	value="" class="readonly" id="googleaddress" name="googleaddress" style="width:98%"/>';
		echo $html;
//		echo $map->showMap();
		?>
		<div class="control-group">
			<div class="control-label">
				<?php echo $this->form->getLabel('lat'); ?>
			</div>
			<div class="controls">
				<?php echo $this->form->getInput('lat'); ?>
			</div>
		</div>
		<div class="control-group">
			<div class="control-label">
				<?php echo $this->form->getLabel('lng'); ?>
			</div>
			<div class="controls">
				<?php echo $this->form->getInput('lng'); ?>
			</div>
		</div>
		<div class="control-group">
			<div class="control-label">
				<?php echo $this->form->getLabel('zoom'); ?>
			</div>
			<div class="controls">
				<?php echo $this->form->getInput('zoom'); ?>
			</div>
		</div>
		<?php

}else{
	echo '<div style="padding:10px">'.JText::_('CE_CONTACT_MAPS_DISABLED').'</div>';
}
?>
</div>
</div>