<?php
/**
 * @package		com_contactenhanced
* @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @author	 	Douglas Machado {@link http://idealextensions.com}
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
jimport('joomla.application.component.view');
/**
 * @since		1.5
 */
class ContactenhancedViewTools extends JViewLegacy
{
	/**
	 * Display the view
	 */
	function display($tpl = null)
	{
		$params			= JComponentHelper::getParams('com_contactenhanced');
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		$this->assignRef('params',	$params);
		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
		// Add submenu
		ContactEnhancedHelper::addSubmenu(JRequest::getVar('view'));
		
		$canDo	= ContactEnhancedHelper::getActions();

		JToolBarHelper::title( JText::_( 'COM_CONTACTENHANCED_TOOLS_MANAGER' ), 'ce-contact' );

		if($canDo->get('core.admin')) {
			JToolBarHelper::divider();
			JToolBarHelper::preferences('com_contactenhanced');
		}
	}
}