<?php
/**
 * @version		1.5.0
 * @package		Joomla
 * @subpackage	Doc Indexer
 * @author  Tuan Pham Ngoc
 * @copyright	Copyright (C) 2010 Ossolution Team
 * @license		GNU/GPL, see LICENSE.php
 */
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

/**
 * HTML View class for the DocIndexer component
 *
 * @static
 * @package		Joomla
 * @subpackage	
 * @since 1.0
 */
class DocIndexerViewDoc extends JViewLegacy
{

	function display($tpl = null)
	{
		$db = & JFactory::getDBO();
		$item = $this->get('Data');
		$lists['published'] = JHTML::_('select.booleanlist', 'published', ' class="inputbox" ', $item->published);
		$lists['re_index'] = JHTML::_('select.booleanlist', 're_index', ' class="inputbox" ', 0);
		if (version_compare(JVERSION, '1.6.0', 'ge'))
		{
			$lists['access'] = JHTML::_('access.level', 'access', $item->access, ' class="inputbox" ', false);
		}
		else
		{
			$sql = 'SELECT id, name FROM #__groups';
			$db->setQuery($sql);
			$rows = $db->loadObjectList();
			$lists['access'] = JHTML::_('select.genericlist', $rows, 'access', ' class="inputbox" ', 'id', 'name', $item->access);
		}
		$this->assignRef('item', $item);
		$this->assignRef('lists', $lists);
		parent::display($tpl);
	}
}