<?php
/**
* @package Redirect-On-Login (com_redirectonlogin)
* @version 3.4.0
* @copyright Copyright (C) 2008 - 2015 Carsten Engel. All rights reserved.
* @license GPL versions free/trial/pro
* @author http://www.pages-and-items.com
* @joomla Joomla is Free Software
*/

// No direct access
defined('_JEXEC') or die;

jimport('joomla.plugin.plugin');

class plgSystemRedirectonlogin extends JPlugin{	

	protected $rol_version_type = 'pro';

	//cant use onAfterIni because itemid is not readable
	function onAfterRender(){
	
		//check if trial version is expired
		if($this->rol_version_type=='trial'){
			if(!$this->rol_check_trial_version()){
				return true;
			}
		}		
		
		//get config
		$rol_config = $this->get_config();	
		
		if($rol_config['enable_redirection']=='no'){
			return true;
		}
	
		$app = JFactory::getApplication();	
		$database = JFactory::getDBO();	
		$Itemid = JRequest::getVar('Itemid', '');
		$session_id = session_id();
		$helper = $this->get_helper();		
		$buffer = JResponse::getBody();
		$ds = DIRECTORY_SEPARATOR;
		
		$option = JRequest::getVar('option', '');
		$view = JRequest::getVar('view', '');
		$task = JRequest::getVar('task', '');
		
		if(!$app->isAdmin()){
			//frontend	
			
			$uri = JFactory::getURI();
			$current_url = $uri->toString();
						
			//check if there is a silent redirect set			
			$database->setQuery("SELECT * "
			." FROM #__redirectonlogin_sessions "
			." WHERE session_id='$session_id' "	
			." LIMIT 1 "		
			);
			$rows = $database->loadObjectList();
			$url = 0;
			$silent = 0;
			$opening_site_home = 0;		
			$opening_site = 0;				
			foreach($rows as $row){				
				$url = $row->url;
				$silent = $row->silent;
				$opening_site_home = $row->opening_site_home;
				$opening_site = $row->opening_site;				
			}
			
			//the redirect is done here because in the user plugin the Itemid, needed to check for frontpage, can not be read yet			
			if($url && $silent){
				//reset
				$database->setQuery( "UPDATE #__redirectonlogin_sessions SET url='', silent='', opening_site_home='' WHERE session_id='$session_id' ");
				$database->query();	
				
				//process dyna redirect
				if(strpos($url, 'do_dynamic_redirect_all_users')){					
					if((!$this->get_user() && $rol_config['opening_site_type']!='loggedin') || ($this->get_user() && $rol_config['opening_site_type']!='notloggedin')){						
						$helper = $this->get_helper();	
						$dynamic_array = $helper->get_dynamic_link($rol_config['dynamic_open']);
						$url = $dynamic_array[0];
						$message = $dynamic_array[1];
						$message = addslashes($message);
						$logout = $dynamic_array[2];
						$message_type = $dynamic_array[3];	
						$database->setQuery( "UPDATE #__redirectonlogin_sessions SET message='$message', logout='$logout', message_type='$message_type', silent='1' WHERE session_id='$session_id' ");
						$database->query();					
					}else{
						$url = '';
					}							
				}
				
				//check if current page is frontpage		
				$frontpage = $this->check_if_frontpage($Itemid);				
				
				if($url && ($frontpage || (!$frontpage && !$opening_site_home))){									
					$app->redirect($url);
				}
				return;//don't take the message out before it has been displayed	
			}				
			
			//if jevents is installed, include lang file
			if(file_exists(JPATH_ROOT.$ds.'components'.$ds.'com_jevents'.$ds.'jevents.php')){
				$lang = JFactory::getLanguage();
				$lang->load('com_jevents', JPATH_ROOT, null, false);
			}
			
			//if no access to menu item, and config is set to redirect to page, set session
			if(($option=='com_users' && $view=='login') || ($option=='com_comprofiler' && $task=='login') || ($option=='com_community' && $task=='frontpage')){			
				if(($rol_config['after_no_access_page']=='page' || $rol_config['after_no_access_page']=='pagerolno') && strpos($buffer, JText::_('JGLOBAL_YOU_MUST_LOGIN_FIRST'))){
					$data = $app->getUserState('users.login.form.data', array());
					$return = $data['return'];					
					$app->setUserState("com_redirectonlogin.return_url_after_unauthorised_access", $return);
				}
			}			
				
			//if user activation page	
			$buffer_message = '';
			if($option=='com_users' && $view=='login'){
				//joomla
				$buffer_message = JText::_('COM_USERS_REGISTRATION_ACTIVATE_SUCCESS');
				$message_wrapper = '<dl id="system-message">';
			}		
			if($option=='com_comprofiler' && $task=='confirm'){// or just use confirmcode
				//index.php?option=com_comprofiler&task=confirm&confirmcode=reg448f7d145beea100ad349f247ab2dd3700eb3b3d 
				//community builder				
				$buffer_message = _UE_USER_CONFIRMED;
				$message_wrapper = '<div class="cbconfirmationinfo';			
			}					
			if($option=='com_community' && $view=='register' && $task=='registerSucess'){//unable to test this for real			
				//jom social			
				$buffer_message = JText::_('CC_REG_COMPLETE');
				$message_wrapper = '<dl id="system-message">';		
			}
			if($buffer_message){
				if(strpos($buffer, $buffer_message) && strpos($buffer, $message_wrapper) && $rol_config['type_registration']!='none'){
					$this->set_registration_redirect($rol_config, $helper, $session_id, $buffer_message);	
				}				
			}			
			
			//if no access to anything not-menu-item related page (joomla just shows message, no redirect to the login page)					
			if(
			(strpos($buffer, JText::_('JERROR_ALERTNOAUTHOR')) || strpos($buffer, JText::_('JEV_LOGIN_TO_VIEWEVENT')) || strpos($buffer, JText::_('K2_YOU_NEED_TO_LOGIN_FIRST'))) && 
			($rol_config['after_no_access_page']=='page' || ($rol_config['after_no_access_page']=='pagerolno' && strpos($current_url, 'rol=no') && $rol_config['rolno_frontend_login'])) && 
			(strpos($buffer, '<dd class="error message">') || strpos($buffer, '<dd class="message message">') || strpos($buffer, '<div id="system-message">')) && 
			(strpos($buffer, '<dl id="system-message">') || strpos($buffer, '<div id="system-message">'))
			){						
				$uri = JFactory::getURI();
				$return = $uri->toString();
				if(strpos($buffer, JText::_('JEV_LOGIN_TO_VIEWEVENT')) || strpos($buffer, JText::_('K2_YOU_NEED_TO_LOGIN_FIRST'))){
					$temp = JRequest::getVar('return', '');
					$return = base64_decode($temp).'&rol=no';
				}	
						
				$app->setUserState("com_redirectonlogin.return_url_after_unauthorised_access2", $return);
				$app->setUserState("com_redirectonlogin.return_url_after_unauthorised_access_pageloads", 3);				
			}
			
			$return_url2 = $app->getUserState("com_redirectonlogin.return_url_after_unauthorised_access2", '');			
			if($rol_config['after_no_access_page']=='page' || $rol_config['after_no_access_page']=='pagerolno'){
				$pageloads = $app->getUserState("com_redirectonlogin.return_url_after_unauthorised_access_pageloads", '');
				if($pageloads > 0 && ($option!='com_users' && $option!='com_comprofiler' && $option!='com_community')){
					$pageloads = $pageloads-1;
					$app->setUserState("com_redirectonlogin.return_url_after_unauthorised_access_pageloads", $pageloads);
				}
			}
			
		}else{
			//backend
			
			//updater
			if($option=='com_installer' && $this->rol_version_type=='pro' && $view=='update' && strpos($buffer, 'Redirect on Login     ||')){	
				
				//fix name
				$update_name_old = 'Redirect on Login     || download the update from www.pages-and-items.com/my-extensions ||';
				$update_name_new = '<table border="0" cellspacing="0" cellpadding="0" style="width: 100%; border-collapse: collapse;"><tr><td style="white-space: nowrap; padding: 0; border: 0;">Redirect on Login</td><td style="padding: 0 0 0 20px; border: 0;"><div style="text-align: right; font-size: 1em; min-width: 200px;">download the update from<br /><a style="font-size: 1em; white-space: nowrap;" href="http://www.pages-and-items.com/my-extensions" target="_blank">www.pages-and-items.com/my-extensions</a></div></td></tr></table>';					
				$buffer = str_replace($update_name_old, $update_name_new, $buffer);				
			}
		}				
					
		if(strpos($buffer, '<span class="com_redirectonlogin_message">')){			
			$database->setQuery( "UPDATE #__redirectonlogin_sessions SET message='', message_type='' WHERE session_id='$session_id' ");
			$database->query();				
		}		
		
		//if user came from the login page after getting no menu access, but browsed to another page, clear the cookie			
		$return_url = $app->getUserState("com_redirectonlogin.return_url_after_unauthorised_access", '');
		if($return_url && !($option=='com_users' && $task=='user.login') && !($option=='com_users' && $view=='login') && !($option=='com_comprofiler' && $task=='login') && !($option=='com_community' && $task=='frontpage')){			
			$app->setUserState("com_redirectonlogin.return_url_after_unauthorised_access", '');
		}	
		
	}	
	
	function onAfterInitialise(){		
		
		$app = JFactory::getApplication();
		$database = JFactory::getDBO();		
	
	
		//check if trial version is expired
		if($this->rol_version_type=='trial'){
			if(!$this->rol_check_trial_version()){
				return true;
			}
		}
		
		//get config
		$rol_config = $this->get_config();	
		
		if($rol_config['enable_redirection']=='no'){
			return true;
		}
		
		//get session id
		$session_id = session_id();
		if(empty($session_id)){
			session_start();
			$session_id = session_id();	
		}
		
		$time = time();			
		
		//check if session is in database yet
		$database->setQuery("SELECT * "
		." FROM #__redirectonlogin_sessions "
		." WHERE session_id='$session_id' "	
		." LIMIT 1 "	
		);
		$rows = $database->loadObjectList();
		$unixtime = 0;
		$opening_site = 0;	
		$url = 0;
		$message = 0;
		$message_type = '';
		$logout = 0;
		$silent = 0;			
		foreach($rows as $row){	
			$unixtime = $row->unixtime;
			$opening_site = $row->opening_site;	
			$url = $row->url;
			$message = $row->message;
			$message_type = $row->message_type;
			$logout = $row->logout;	
			$silent = $row->silent;									
		}		
		
		if(!$unixtime){
			//session is not in table, so get it in there
			
			//check if the user just logged out to adopt the session
			$ip = $_SERVER['REMOTE_ADDR'];
			$database->setQuery("SELECT * "
			." FROM #__redirectonlogin_sessions "
			." WHERE session_id='adopt_me' "
			." AND ip='$ip' "
			." LIMIT 1 "		
			);
			$rows = $database->loadObjectList();
			$adopt_id = 0;
			$url = 0;
			$message = 0;			
			$logout = 0;
			$silent = 0;			
			foreach($rows as $row){					
				$adopt_id = $row->id;
				$url = $row->url;
				$message = $row->message;
				$logout = $row->logout;		
				$silent = $row->silent;						
			}
			
			if($adopt_id){
				//there is a session up for adoption, lets update it
				$database->setQuery( "UPDATE #__redirectonlogin_sessions SET session_id='$session_id', unixtime='$time' WHERE session_id='adopt_me' ");
				$database->query();
			}else{
				//insert					
				$database->setQuery( "INSERT INTO #__redirectonlogin_sessions SET session_id='$session_id', unixtime='$time', opening_site='1' ");
				$database->query();	
				$this->opening_site($session_id, $rol_config);
			}	
		}else{
			//session is in table
			if($opening_site){
				//if loading page after opening site, reset opening site and update time
				$database->setQuery( "UPDATE #__redirectonlogin_sessions SET opening_site='0', unixtime='$time' WHERE session_id='$session_id' ");
				$database->query();		
			}else{
				//update time
				$database->setQuery( "UPDATE #__redirectonlogin_sessions SET unixtime='$time' WHERE session_id='$session_id' ");
				$database->query();	
			}		
		}	

		if($logout){				
			$ip = $_SERVER['REMOTE_ADDR'];
			$database->setQuery( "UPDATE #__redirectonlogin_sessions SET session_id='adopt_me', logout='', ip='$ip', unixtime='$time' WHERE session_id='$session_id' ");
			$database->query();	
				
			$session = JFactory::getSession();
			$session->destroy();
			
			$app->redirect($url);
			return;	
		}			
		
		if($message){		
			$message_wrapped = '<span class="com_redirectonlogin_message">'.$message.'</span>';
			//make sure there is only one message in the que
			$messages = $app->getMessageQueue();			
			$message_in_que = 0;
			foreach($messages as $mess){
				if($mess['message'] == $message_wrapped){
					$message_in_que = 1;
				}				
			}
			if(!$message_in_que){
				$helper = $this->get_helper();	
				if($helper->joomla_version >= '3.0'){	
					$app->enqueueMessage($message_wrapped, $message_type);										
				}else{
					//joomla 2.5
					if($message_type=='info'){
						$app->enqueueMessage($message_wrapped);
					}elseif($message_type=='notice'){
						JError::raiseNotice(403, $message_wrapped);
					}else{
						JError::raiseWarning(403, $message_wrapped);
					}
				}
			}	
		}
		
		if($url && !$silent){	
			$database->setQuery( "UPDATE #__redirectonlogin_sessions SET url='' WHERE session_id='$session_id' ");
			$database->query();				
			$app->redirect($url);				
		}
						
	}
	
	function get_user(){
		//userdata needs to be collected on the eventload as loading them in the constructor does not work with CB login module
		$user = JFactory::getUser();		
		return $user->get('id');			
	}	
	
	function get_config(){	
			
		$database = JFactory::getDBO();			
		
		$database->setQuery("SELECT config "
		."FROM #__redirectonlogin_config "
		."WHERE id='1' "
		."LIMIT 1"
		);		
		$raw = $database->loadResult();		
		
		$params = explode( "\n", $raw);
		
		for($n = 0; $n < count($params); $n++){		
			$temp = explode('=',$params[$n]);
			$var = $temp[0];
			$value = '';
			if(count($temp)==2){
				$value = trim($temp[1]);				
			}							
			$config[$var] = $value;	
		}	
		
		//reformat redirect url	
		$config['opening_site_url'] = str_replace('[equal]','=',$config['opening_site_url']);	
		$config['url_registration'] = str_replace('[equal]','=',$config['url_registration']);		
				
		return $config;			
	}
	
	function check_if_frontpage($Itemid){
	
		$database = JFactory::getDBO();	
		$database->setQuery("SELECT home "
		."FROM #__menu  "
		."WHERE id='$Itemid' "
		."LIMIT 1 "
		);
		$frontpage = $database->loadResult();
		return $frontpage;
	}
		
	function get_helper(){
		$ds = DIRECTORY_SEPARATOR;
		require_once(JPATH_ROOT.$ds.'administrator'.$ds.'components'.$ds.'com_redirectonlogin'.$ds.'helpers'.$ds.'redirectonlogin.php');
		$helper = new redirectonloginHelper();
		return $helper;
	}
	
	function rol_check_trial_version(){
		//config		
		$rol_trial_valid_until = 1309262132;						
		$rol_allow_localhost = true;
		//check trial time left		
		$rol_trial_seconds_left = $rol_trial_valid_until-time();
		//let class know demo time left			
		$this->rol_demo_seconds_left = $rol_trial_seconds_left;	
		//check the trialtime
		$rol_trial_still_valid = false;	
		if(
		//check localhost
		($rol_allow_localhost && ($_SERVER['SERVER_NAME']==='localhost' || $_SERVER['SERVER_NAME']==='127.0.0.1')) ||
		//check demo time 
		$rol_trial_seconds_left >= 0 ||
		//not a trial version
		$this->rol_version_type == 'free' || $this->rol_version_type == 'pro'
		){					
			$rol_trial_still_valid = true;								
		}
		return $rol_trial_still_valid;
	}

	function set_registration_redirect($rol_config, $helper, $session_id, $message=''){
	
		$db = JFactory::getDBO();	
		$app = JFactory::getApplication();
		
		//check if trial version is expired
		if($this->rol_version_type=='trial'){
			if(!$this->rol_check_trial_version()){
				return true;
			}
		}
		
		$redirect = '';		
		$logout = 0;
		$message = '';//maybe try to clear message in later version
		$message_type = 'info';
		if($rol_config['type_registration']=='menuitem'){						
			$redirect = $helper->get_link_from_menuitem($rol_config['menuitem_registration']);							
		}
		if($rol_config['type_registration']=='url'){
			$redirect = $rol_config['url_registration'];
		}		
		if($rol_config['type_registration']=='dynamic'){							
			$dynamic_array = $helper->get_dynamic_link($rol_config['dynamic_registration']);
			$redirect = $dynamic_array[0];
			$message = $dynamic_array[1];
			$logout = $dynamic_array[2];
			$message_type = $dynamic_array[3];
		}	
		
		if($redirect){
			//set redirect
			$message = addslashes($message);			
			$query = $db->getQuery(true);		
			$query->update('#__redirectonlogin_sessions');
			$query->set('url='.$db->q($redirect));
			$query->set('message='.$db->q($message));
			$query->set('message_type='.$db->q($message_type));
			$query->set('logout='.$db->q($logout));			
			$query->where('session_id='.$db->q($session_id));
			$db->setQuery((string)$query);
			$db->query();

			//do bogus redirect to trigger onafterinitiate again							
			$app->redirect('index.php');	
		}	
		
	}
	
	function opening_site($session_id, $rol_config){	
	
		$app = JFactory::getApplication();	
		
		
		if($app->isSite()){
			
			$uri = JFactory::getURI();
			$current_url = $uri->toString();
			$Itemid = JRequest::getVar('Itemid', '');
			$helper = $this->get_helper();			
			$database = JFactory::getDBO();
							
			if(!(strpos($current_url, 'rol=no') && $rol_config['rolno_frontend_open'])){	
			
				//check if current page is frontpage
				//$frontpage = $this->check_if_frontpage($Itemid);
				//can not read Itemid here, when empty assume frontpage			
				if($Itemid){
					$frontpage = 0;
				}else{
					$frontpage = 1;
				}				
				
				//check if redirect is enabled		
				if(
				$rol_config['enable_redirection']=='yes' &&
				$rol_config['opening_site']=='yes' &&									
				($frontpage || (!$frontpage && !$rol_config['opening_site_home']))
				){									
					if($rol_config['opening_site_type2']=='menuitem'){						
						$redirect_url_silent = $helper->get_link_from_menuitem($rol_config['menuitem_open']);							
					}
					if($rol_config['opening_site_type2']=='url'){
						$redirect_url_silent = $rol_config['opening_site_url'];
					}						
					if($rol_config['opening_site_type2']=='dynamic'){							
						$redirect_url_silent = '_do_dynamic_redirect_all_users';
					}	
					if($redirect_url_silent){
						//set redirect
						$database->setQuery( "UPDATE #__redirectonlogin_sessions SET url='$redirect_url_silent', silent='1' WHERE session_id='$session_id' ");
						$database->query();	
						//do bogus redirect to trigger onafterinitiate again							
						$app->redirect('index.php');						
					}							
				}		
			}
		}		
	}
	
	
}
?>