jQuery(document).ready(function($){
'use strict';
		//Append to the default processQueue.
		// taken from jquery.fileupload-validate.js
		$.blueimp.fileupload.prototype.options.processQueue.push(
			{
				action: 'validate',
				// Always trigger this action,
				// even if the previous action was rejected:
				always: true,
				// Options taken from the global options map:
				acceptFileTypes: '@',
				maxFileSize: '@',
				minFileSize: '@',
				maxNumberOfFiles: '@',
				disabled: '@disableValidation'
			}
		);
$.widget('blueimp.fileupload', $.blueimp.fileupload, {

	options: {
		type: 		'POST',
		dataType: 	'json',
		formData: 	[],
		fieldAlias:	'files',
		filesContainer:		undefined,
		filesLeftContainer: undefined,
		// fileValidator input was added in ordert to be compatible with jquery.validator
		fileValidator:		undefined,
		// The regular expression for allowed file types, matches
		// against either file type or file name:
		acceptFileTypes: /(\.|\/)(gif|jpe?g|png|doc|docx|ppt|xls|pdf|zip)$/i,
		// The maximum allowed file size in bytes:
		maxFileSize: 1000000, // 1 MB
		// The minimum allowed file size in bytes:
		minFileSize: undefined, // No minimal file size
		// The limit of files to be uploaded:
		maxNumberOfFiles: 10,
		required: false,

		// Error and info messages:
		messages: {
			uploadedBytes:	'Uploaded bytes exceed file size',
			removeFile: 	'Remove file',
			error:			'Error',
			fieldRequired:	'This field is required',
			maxNumberOfFiles: 'Maximum number of files exceeded',
			acceptFileTypes: 'File type not allowed',
			maxFileSize: 'File is too large',
			minFileSize: 'File is too small'
		},
		// Function returning the current number of files,
		// used by the maxNumberOfFiles validation:
		getNumberOfFiles: function () {
			return this.filesContainer.children('li.text-success').length;
		},

		// Callback for successful uploads:
		done: function (e, data) {

			 var that = $(this).data('blueimp-fileupload') ||
						 	$(this).data('fileupload'),
						 getFilesFromResponse = data.getFilesFromResponse ||
					 		that.options.getFilesFromResponse,
						 files = that.getFilesFromResponse(data);
			that.addNodes(files, that);
			$.each(files, function (index, file) {
				if(typeof(file.error) != 'string'){
					that.updateFilesLeft(-1, that);
				}
			});
		},
		processalways:function (e, data) {
			var that = $(this).data('blueimp-fileupload') ||
					 		$(this).data('fileupload'),
					 	index = data.index,
					 	file = data.files[index];

			if(file.error){
				that.addNode(file,that);
			}
		},
		add: function(e, data){
			if (e.isDefaultPrevented()) {
				return false;
			}
			var $this = $(this),
				that = $(this).data('blueimp-fileupload') || $(this).data('fileupload'),
				options = that.options;

			$.when(
				data.context = $('<li/>').appendTo(that.options.filesContainer),
				data.process(function () {
					return $this.fileupload('process', data);
				})
			).done(function () {

				 if ((that._trigger('added', e, data) !== false) &&
						 (options.autoUpload || data.autoUpload) &&
						 data.autoUpload !== false) {
					 data.submit();

				 }
			}).fail(function () {
				if (data.files.error) {
					data.context.each(function (index) {
						var error = data.files[index].error;
						if (error) {
							$(this).find('.error').text(error);
						}
					});
				}
			});
		},
		progressall: function (e, data) {
			var containerId = $(this).closest('div.ce-cf-container').attr('id');
			// Update the progress bar while files are being uploaded
			var progress = parseInt(data.loaded / data.total * 100, 10);
			$('#'+containerId+' .progress-bar').css('width',progress+'%');
		},
	 // Callback for file deletion:
		destroy: function (e, data) {
			if (e.isDefaultPrevented()) {
				return false;
			}
			var that = $(this).data('blueimp-fileupload') ||
					$(this).data('fileupload'),
				removeNode = function () {
					that._transition(data.context).done(
						function () {
							console.log($(this));
							$(this).remove();
							that.updateFilesLeft(1, that);
							that._trigger('destroyed', e, data);
						}
					);
				};
			if (data.url) {
				data.dataType = data.dataType || that.options.dataType;
				$.ajax(data).done(removeNode);
			} else {
				removeNode();
			}
		}

	}, // END OPTIONS

	// FOR VALIDATION: from jquery.fileupload-validate.js
	processActions: {

		validate: function (data, options) {
			if (options.disabled) {
				return data;
			}

			var dfd = $.Deferred(),
				settings = this.options,
				file = data.files[data.index];
			if(!file){
				var file = data.files;
			}
			if ($.type(options.maxNumberOfFiles) === 'number' &&
					(settings.getNumberOfFiles() || 0) + data.files.length >
						options.maxNumberOfFiles) {
				file.error = settings.i18n('maxNumberOfFiles');
			} else if (options.acceptFileTypes &&
					!(options.acceptFileTypes.test(file.type) ||
					options.acceptFileTypes.test(file.name))) {
				file.error = settings.i18n('acceptFileTypes');
			} else if (options.maxFileSize && file.size >
					options.maxFileSize) {
				file.error = settings.i18n('maxFileSize');
			} else if ($.type(file.size) === 'number' &&
					file.size < options.minFileSize) {
				file.error = settings.i18n('minFileSize');
			} else {
				delete file.error;
			}
			if (file.error || data.files.error) {
				data.files.error = true;
				dfd.rejectWith(this, [data]);
			} else {
				dfd.resolveWith(this, [data]);
			}
			return dfd.promise();
		}

	},
	// retrieve the list of files from the server response:
	getFilesFromResponse: function (data) {
		if (data.result && $.isArray(data.result[this.options.fieldAlias])) {
			return data.result[this.options.fieldAlias];
		}else if (data.result && $.isArray(data.result.upload_resume)){
			return data.result.upload_resume;
		}
		return [];
	},
	addNodes: function(files, that) {
		var self = this;
		// Add each uploaded file name to the #files list
		$.each(files, function (index, file) {
			self.addNode(file, that);
		});
	},
	addNode: function(file,that) {

		var newNode = $('<li class="fade"/>').appendTo(that.options.filesContainer),
			p	= $('<p/>').appendTo(newNode);
		if(file.error){
			newNode.addClass('text-error').html('<p><span class="icon-ban-circle .glyphicon .glyphicon-ban-circle"></span> '
					+ file.name + '. <small>'+that.options.i18n('error')+': '+file.error+'</small></p>');
		}else{
			// If file has been uploaded, but number of files is over the maxNumberOfFiles, then assign an error and delete the file
			var numFiles = (that.options.getNumberOfFiles());
			if ($.type(numFiles) === 'number' &&
					(numFiles || 0)	>=	that.options.maxNumberOfFiles) {
				file.error = that.options.i18n('maxNumberOfFiles');
				this.addNode(file,that);
				jQuery.ajax({url:that.options.url+'&_method=DELETE&file='+file.name});
			}else{
				newNode.addClass('text-success');
				p.html('<span class="icon-ok glyphicon glyphicon-ok"></span> '
					+ '<span class="file_name">' + file.name + '</span>');
				var deleteButton = $('<button title="' + that.options.i18n('removeFile')
							+ '" class="btn btn-danger btn-mini btn-xs delete" type="button" />')
						.html('<span class="icon-minus-sign glyphicon glyphicon-minus-sign"></span>')
						.appendTo(p)
						.attr('data-url',that.options.url+'&_method=DELETE&file='+file.name);
			}

		}
		that._transition(newNode);
	},

	updateFilesLeft: function(add, that){
		var filesLeft = that.options.filesLeftContainer.find('strong');
		//filesLeft.text(parseInt(filesLeft.text()) + parseInt(add));
		filesLeft.text(that.options.maxNumberOfFiles - that.options.getNumberOfFiles());
		if(filesLeft.text() <= 0){
			 that.element.attr('disabled',true);
		}else{
			 that.element.attr('disabled',false);
		}
		if(that.options.fileValidator != undefined){
			that.options.fileValidator.valid();
		}
		
	},
	_transition: function (node) {
		var dfd = $.Deferred();
		if ($.support.transition && node.hasClass('fade') && node.is(':visible')) {
			node.bind(
				$.support.transition.end,
				function (e) {
					// Make sure we don't respond to other transitions events
					// in the container element, e.g. from button elements:
					if (e.target === node[0]) {
						node.unbind($.support.transition.end);
						dfd.resolveWith(node);
					}
				}
			).toggleClass('in');
		} else {
			node.toggleClass('in');
			dfd.resolveWith(node);
		}
		return dfd;
	},

	_deleteHandler: function (e) {
		var button = $(e.currentTarget);

		this._trigger('destroy', e, $.extend({
			context: button.closest('li'),
			type: 'POST' // used to be	type:'DELETE', changed it to POST because it would not work under some servers.
		}, button.data()));

	},
	_initEventHandlers: function () {
		this._super();
		this._initjQueryValidator();
		this._on(this.options.filesContainer, {
			'click .delete': this._deleteHandler
		});
	},

	_initjQueryValidator: function(){
		var that = this;
		if(that.options.required){
			jQuery.validator.addMethod('jqueryfileupload', function(value, element, params) {
				var el = $(element).closest('div').find('.mf-number-files strong');
				return parseInt(el.text()) < that.options.maxNumberOfFiles;
			}, that.options.i18n('fieldRequired'));
		}
	}

	});
});