;
(function($, undefined) {
	$.widget("ce.formsteps", {

		//Options to be used as defaults
		options : {
			namespace : '', // is the form id attribute.	Always use the namepace in the slider div
			count : 0,
			progressbar : null,
			progressbarLabel: null
		},
		slider : null,
		progressbar:null,
		current : 0,
		// _create will automatically run the first time this widget is called.
		_create : function() {
			// Create Accordion Effect

			this.slider = this.element.accordion({
				heightStyle : "content"
			});
			var $this = (this);
			if (this.options.progressbar) {
				var val = 0;
				if(this.options.progressbarLabel == 'text' || this.options.progressbarLabel == '%'){
					val = 1;
				}
				this.progressbar 	= $(this.options.progressbar).progressbar({
											max:this.options.count
											, value:val
											, change: function(e, ui) {
												var $that = this;
												$this.getProgressbarText($that);
												}
											, create: function(e, ui) {
												var $that = this;
												$this.getProgressbarText($that);
												}
											});

			}
			this._on('#' + this.options.namespace + '-steps-buttons .step-next', {click: function(e){this.stepUp()}});
			this._on('#' + this.options.namespace + '-steps-buttons .step-prev', {click: function(e){this.stepDown()}});

		},
		getProgressbarText : function(progressbar) {
			max 	= this.options.count;
			value 	= this.current+1;
			label 	= $(progressbar).children(":first");

			if(this.options.progressbarLabel == '%'){
				label.text(Math.round( (value/max) * 100) +"%");
			}else if(this.options.progressbarLabel == 'text'){
				label.text(Joomla.JText._('COM_CONTACTENHANCED_PAGINATION_JS_STEP','Step')
						+' '+(value)+' '
						+Joomla.JText._('COM_CONTACTENHANCED_PAGINATION_JS_OF','of')
						+' ' +max);
			}
		},

		stepUp : function() {
			if (this.options.count > (this.current + 1)) {
				this._step( (this.current + 1), true )
			}
		},
		stepDown : function() {
			if (this.current > 0) {
				this._step( (this.current - 1), true )
			}
		},
		_step : function(page,validate) {
			var status		= true;
			var validate	= validate || false;
			if(validate == true){
				$('#'+this.options.namespace+'-page-'+page).find('input[required],textarea[required],select[required]').each(function() {
					if(!$(this).valid()) {
						status = false;
					}
				});
			}

			if(status){
				//$('#name').valid()
				this.current = page;
				this.slider.accordion("activate", page);
				if (this.options.progressbar) {
					var value = page;
					if(this.options.progressbarLabel == 'text' || this.options.progressbarLabel == '%'){
						value = page+1;
					}
					this.progressbar.progressbar('value', value);
				}
				this._updateButtons();
				$('html, body').animate({
					scrollTop: $('#ce-custom-fields-container').offset().top
				}, 1000);

				return true;
			}
			return false;
		},
		_updateButtons : function() {
			var button = $('#' + this.options.namespace + '-step-button-next');
			if (this.options.count > (this.current +1)) {
				button.css('display','');
				var data = $('#' + this.options.namespace + '-page-'+(this.current+1)).data('next-label');
				button.html(data);
			}else{
				button.css('display','none');
			}
			var button = $('#' + this.options.namespace + '-step-button-prev');
			if (this.current < 1) {
				button.css('display','none');
			}else{
				button.css('display','');
			}
		},
		goToPage : function(page) {
			this._step(page, false);
		}
	});

})(jQuery);