<?php
/**
 * @version		3.3.4
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

$app	= JFactory::getApplication();
$input	= $app->input;

$allowedFormat = array('html', 'csv', 'xml', 'csv', 'vcf');
// Make it ignore other formats
if($input->getCmd('format') AND !in_array($input->getCmd('format'), $allowedFormat)){
	$input->set('format','html');
}
$allowedTMPL = array('component','raw');
if($input->getCmd('tmpl') AND !in_array($input->getCmd('tmpl'),$allowedTMPL)){
	$input->set('tmpl', 'component');
}

// Fix SQL Injection issue on Format variable

$format = $app->input->getWord('format');
$allowedFormats 	= array('feed', 'html', 'xml','raw');
if (!in_array($format, $allowedFormats ))
{
	$input->set('format', '');
	JRequest::setVar('format', '', 'GET');
	JRequest::setVar('format', '', 'REQUEST');
}

jimport('joomla.application.component.controller');
JHTML::addIncludePath(JPATH_COMPONENT.'/helpers/html');
require_once JPATH_COMPONENT.'/controller.php';
require_once JPATH_COMPONENT.'/helpers/route.php';
require_once JPATH_COMPONENT.'/helpers/helper.php';

$lang = JFactory::getLanguage();

// Load backend language file
//Load English always, useful if file is partially translated
$lang->load('com_contactenhanced',		JPATH_ADMINISTRATOR.'/components/com_contactenhanced', 'en-GB');
$lang->load('com_contactenhanced',		JPATH_ADMINISTRATOR.'/components/com_contactenhanced', null, true);

//Load site language file
$lang->load('com_contactenhanced',		JPATH_ROOT.'/components/com_contactenhanced', 'en-GB');
$lang->load('com_contactenhanced',		JPATH_ROOT.'/components/com_contactenhanced', null, true);

$jversion = new JVersion();
if( version_compare( $jversion->getShortVersion(), '2.5.5', 'lt' ) ) {
	$controller = JController::getInstance('Contactenhanced');
}else{
	$controller = JControllerLegacy::getInstance('Contactenhanced');
}

$controller->execute($input->getCmd('task'));

$controller->redirect();
