<?php
/**
 * @copyright   Copyright (C) 2006 - 2014 IdealExtensions.com. All rights reserved.
 * @license	 GNU GPL2 or later; see LICENSE.txt
 */
class ceBotscout {
	var $apiKey = '';
	var $conn;
	public function __construct($apiKey)
	{
		$this->apiKey	= $apiKey;
	}
	public function getInfo($email, $ip='') {
		$result = true;
		$data = array();
		$this->ip			= ($ip ? $ip : ceHelper::getIP() );
		$this->email		= $email;

		if (!empty($this->ip) && $this->ip != '127.0.0.1') {
			$data['ip'] = $this->ip;
		}
		if (!empty($this->email)) {
			$data['mail'] = $this->email;
		}
		$result = $this->sendInfo($data);
		$result = $this->checkXML($result);
		if (is_resource($this->conn)) fclose($this->conn);
		return $result;
	}
	public function sendInfo($data) {
		if (!empty($this->apiKey)){
			$data['key'] =  $this->apiKey;
		}
		$data['format'] = 'xml';
		$data = str_replace('"', '', JArrayHelper::toString($data,'=','&') );
		$cookies		= array();
		$custom_headers	= array();
		$timeout		= 100;
		$apiquery = 'http://www.botscout.com/test/?'.$data;
		$ch = curl_init($apiquery);
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$result = curl_exec($ch);
		curl_close($ch);
		return $result;
	}
	public function checkXML($res) {
		if(!preg_match('#<response>.*</response>#Uis',$res,$results)){
			throw new Exception(JText::_('There is an error while trying to get the xml could not find "&lt;response&gt;"'));
			return false;
		}
		$xml = new SimpleXMLElement($results[0]);
		if($xml->matched == "Y" && $xml->test == 'IP'){
			// Check failed. Result indicates dangerous.
			throw new Exception(JText::sprintf('There is a problem with the IP: %s you used to do the registration ( Spam test positive )',$this->ip));
			return false;
		}
		if($xml->matched == "Y" && $xml->test == 'MAIL'){
			throw new Exception(JText::sprintf('There is a problem with the email: %s you entered in the form ( Spam test positive )', $this->email));
			return false;
		}
		return true;
	}
}