<?php
/** Class to access the administrator resources from the create send API.
 * This class includes functions to add and remove administrators,
 * along with getting details for a single administrator
 * @author pauld
 *
*/
require_once dirname(__FILE__).'/class/base_classes.php';
class CS_REST_Administrators extends CS_REST_Wrapper_Base {
var $_admins_base_route;
function CS_REST_Administrators ( 
$auth_details,
$protocol = 'https',
$debug_level = CS_REST_LOG_NONE,
$host = 'api.createsend.com',
$log = NULL,
$serialiser = NULL,
$transport = NULL){
$this->CS_REST_Wrapper_Base($auth_details, $protocol, $debug_level, $host, $log, $serialiser, $transport);
$this->_admins_base_route = $this->_base_route.'admins';
}
function add($admin){
return $this->post_request($this->_admins_base_route.'.json', $admin);
}
function update($email, $admin){
return $this->put_request($this->_admins_base_route.'.json?email='.urlencode($email), $admin);
}
function get($email){
return $this->get_request($this->_admins_base_route.'.json?email='.urlencode($email));
}
function delete($email){
return $this->delete_request($this->_admins_base_route.'.json?email='.urlencode($email));
}
}