<?php
/** Class to access the person resources from the create send API.
 * This class includes functions to add and remove people,
 * along with getting details for a single person
 * @author tobyb
 *
*/
require_once dirname(__FILE__).'/class/base_classes.php';
class CS_REST_People extends CS_REST_Wrapper_Base {
var $_people_base_route;
function CS_REST_People (
$client_id,
$auth_details,
$protocol = 'https',
$debug_level = CS_REST_LOG_NONE,
$host = 'api.createsend.com',
$log = NULL,
$serialiser = NULL,
$transport = NULL){
$this->CS_REST_Wrapper_Base($auth_details, $protocol, $debug_level, $host, $log, $serialiser, $transport);
$this->set_client_id($client_id);
}
function set_client_id($client_id){
$this->_people_base_route = $this->_base_route.'clients/'.$client_id . '/people';
}
function add($person){
return $this->post_request($this->_people_base_route.'.json', $person);
}
function update($email, $person){
return $this->put_request($this->_people_base_route.'.json?email='.urlencode($email), $person);
}
function get($email){
return $this->get_request($this->_people_base_route.'.json?email='.urlencode($email));
}
function delete($email){
return $this->delete_request($this->_people_base_route.'.json?email='.urlencode($email));
}
}