<?php
/** Class to access a subscribers resources from the create send API.
 * This class includes functions to add and remove subscribers ,
 * along with accessing statistics for a single subscriber
 * @author tobyb
 *
*/
require_once dirname(__FILE__).'/class/base_classes.php';
class CS_REST_Subscribers extends CS_REST_Wrapper_Base {
var $_subscribers_base_route;
function CS_REST_Subscribers (
$list_id,
$auth_details,
$protocol = 'https',
$debug_level = CS_REST_LOG_NONE,
$host = 'api.createsend.com',
$log = NULL,
$serialiser = NULL,
$transport = NULL){
$this->CS_REST_Wrapper_Base($auth_details, $protocol, $debug_level, $host, $log, $serialiser, $transport);
$this->set_list_id($list_id);
}
function set_list_id($list_id){
$this->_subscribers_base_route = $this->_base_route.'subscribers/'.$list_id;
}
function add($subscriber){
return $this->post_request($this->_subscribers_base_route.'.json', $subscriber);
}
function update($email, $subscriber){
return $this->put_request($this->_subscribers_base_route.'.json?email='.urlencode($email), $subscriber);
}
function import($subscribers, $resubscribe, $queueSubscriptionBasedAutoResponders = false, $restartSubscriptionBasedAutoResponders = false){
$subscribers = array(
'Resubscribe' => $resubscribe,
'QueueSubscriptionBasedAutoResponders' => $queueSubscriptionBasedAutoResponders,
'Subscribers' => $subscribers,
'RestartSubscriptionBasedAutoresponders' => $restartSubscriptionBasedAutoResponders
);
return $this->post_request($this->_subscribers_base_route.'/import.json', $subscribers);
}
function get($email){
return $this->get_request($this->_subscribers_base_route.'.json?email='.urlencode($email));
}
function get_history($email){
return $this->get_request($this->_subscribers_base_route.'/history.json?email='.urlencode($email));
}
function unsubscribe($email){
 $email = array(
'EmailAddress' => $email 
);
return $this->post_request($this->_subscribers_base_route.'/unsubscribe.json', $email);
}
function delete($email){
return $this->delete_request($this->_subscribers_base_route.'.json?email='.urlencode($email));
}
}