<?php
/** Class to access a templates resources from the create send API.
 * This class includes functions to create update and delete templates
 * @author tobyb
 *
*/
require_once dirname(__FILE__).'/class/base_classes.php';
class CS_REST_Templates extends CS_REST_Wrapper_Base {
var $_templates_base_route;
function CS_REST_Templates (
$template_id,
$auth_details,
$protocol = 'https',
$debug_level = CS_REST_LOG_NONE,
$host = 'api.createsend.com',
$log = NULL,
$serialiser = NULL,
$transport = NULL){
$this->CS_REST_Wrapper_Base($auth_details, $protocol, $debug_level, $host, $log, $serialiser, $transport);
$this->set_template_id($template_id);
}
function set_template_id($template_id){
$this->_templates_base_route = $this->_base_route.'templates/'.$template_id.'.json'; 
}
function create($client_id, $template_details){
return $this->post_request($this->_base_route.'templates/'.$client_id.'.json', $template_details);
}
function update($template_details){
return $this->put_request($this->_templates_base_route, $template_details);
}
function delete(){
return $this->delete_request($this->_templates_base_route);
}
function get(){
return $this->get_request($this->_templates_base_route);
}
}