<?php
/** Example implementation of the CTCTDataStore interface that uses session for access token storage
 *
 * @package	 Auth
 * @author		 Constant Contact
*/
namespace Ctct\Auth;
use Ctct\Auth\CtctDataStore;
class SessionDataStore implements CtctDataStore
{
public function __construct()
{
session_start();
if (!isset($_SESSION['datastore'])){
$_SESSION['datastore'] = array();
}
}
public function addUser($username, array $params)
{
$_SESSION['datastore'][$username] = $params;
}
public function getUser($username)
{
if (array_key_exists($username, $_SESSION['datastore'])){
return $_SESSION['datastore'][$username];
}else{
return false;
}
}
public function updateUser($username, array $params)
{
if (array_key_exists($username, $_SESSION['datastore'])){
$_SESSION['datastore'][$username] = $params;
}
}
public function deleteUser($username)
{
unset($_SESSION['datastore'][$username]);
}
}
