<?php
/** Performs all actions pertaining to Constant Contact Contacts
 *
 * @package Services
 * @author ContactContact
*/
namespace Ctct\Services;
use Ctct\Util\Config;
use Ctct\Util\RestClient;
use Ctct\Components\Contacts\Contact;
use Ctct\Components\ResultSet;
class ContactService extends BaseService
{
public function getContacts($accessToken, array $params = array())
{
$baseUrl = Config::get('endpoints.base_url') . Config::get('endpoints.contacts');
$url = $this->buildUrl($baseUrl, $params);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
$body = json_decode($response->body, true);
$contacts = array();
foreach ($body['results'] as $contact){
$contacts[] = Contact::create($contact);
}
return new ResultSet($contacts, $body['meta']);
}
public function getContact($accessToken, $contactId)
{
$baseUrl = Config::get('endpoints.base_url') . sprintf(Config::get('endpoints.contact'), $contactId);
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
return Contact::create(json_decode($response->body, true));
}
public function addContact($accessToken, Contact $contact, array $params = array())
{
$baseUrl = Config::get('endpoints.base_url') . Config::get('endpoints.contacts');
$url = $this->buildUrl($baseUrl, $params);
$response = parent::getRestClient()->post($url, parent::getHeaders($accessToken), $contact->toJson());
return Contact::create(json_decode($response->body, true));
}
public function deleteContact($accessToken, $contactId)
{
$baseUrl = Config::get('endpoints.base_url') . sprintf(Config::get('endpoints.contact'), $contactId);
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->delete($url, parent::getHeaders($accessToken));
return ($response->info['http_code'] == 204) ? true : false;
}
public function deleteContactFromLists($accessToken, $contactId)
{
$baseUrl = Config::get('endpoints.base_url') . sprintf(Config::get('endpoints.contact_lists'), $contactId);
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->delete($url, parent::getHeaders($accessToken));
return ($response->info['http_code'] == 204) ? true : false;
}
public function deleteContactFromList($accessToken, $contactId, $listId)
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.contact_list'), $contactId, $listId);
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->delete($url, parent::getHeaders($accessToken));
return ($response->info['http_code'] == 204) ? true : false;
}
public function updateContact($accessToken, Contact $contact, array $params = array())
{
$baseUrl = Config::get('endpoints.base_url') . sprintf(Config::get('endpoints.contact'), $contact->id);
$url = $this->buildUrl($baseUrl, $params);
$response = parent::getRestClient()->put($url, parent::getHeaders($accessToken), $contact->toJson());
return Contact::create(json_decode($response->body, true));
}
}
