<?php
/** Wrapper for curl HTTP request
 *
 * @package	 Util
 * @author		 Constant Contact
*/
namespace Ctct\Util;
use Ctct\Exceptions\CTCTException;
use Ctct\Util\RestClientInterface;
use Ctct\Util\CurlResponse;
class RestClient implements RestClientInterface
{
public function get($url, array $headers)
{
return self::httpRequest($url, "GET", $headers);
}
public function post($url, array $headers = array(), $data = null)
{
return self::httpRequest($url, "POST", $headers, $data);
}
public function put($url, array $headers = array(), $data = null)
{
return self::httpRequest($url, "PUT", $headers, $data);
}
public function delete($url, array $headers = array())
{
return self::httpRequest($url, "DELETE", $headers);
}
private static function httpRequest($url, $method, array $headers = array(), $data = null)
{
$curl = curl_init();
curl_setopt($curl, CURLOPT_URL, $url);
curl_setopt($curl, CURLOPT_HEADER, 0);
curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($curl, CURLOPT_USERAGENT, "ConstantContact Appconnect PHP Library v1.0");
curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
 if($data){
curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
}
$response = CurlResponse::create(curl_exec($curl), curl_getinfo($curl), curl_error($curl));
curl_close($curl);
 $body = json_decode($response->body, true);
if (isset($body[0]) && array_key_exists('error_key', $body[0])){
$ex = new CtctException($response->body);
$ex->setCurlInfo($response->info);
$ex->setErrors($body);
throw $ex;
}
return $response;
}
}
