<?php
/**
 * @package	com_contactenhanced
 * @author	Douglas Machado {@link http://idealextensions.com}
 * @author	Created on 26-Nov-2014
 * @license	GNU/GPL, see license.txt
 */

defined( '_JEXEC' ) or die( 'Restricted access' );

class ceFileHelper extends JObject {

	public static $mime_types = array
	(
		'123'	=>	'application/vnd.lotus-1-2-3',
		'3dm'	=>	'x-world/x-3dmf',
		'3dmf'	=>	'x-world/x-3dmf',
		'3dml'	=>	'text/vnd.in3d.3dml',
		'3ds'	=>	'image/x-3ds',
		'3g2'	=>	'video/3gpp2',
		'3gp'	=>	'video/3gpp',
		'7z'	=>	'application/x-7z-compressed',
		'a'	=>	'application/octet-stream',
		'aab'	=>	'application/x-authorware-bin',
		'aac'	=>	'audio/x-aac',
		'aam'	=>	'application/x-authorware-map',
		'aas'	=>	'application/x-authorware-seg',
		'abc'	=>	'text/vnd.abc',
		'abw'	=>	'application/x-abiword',
		'ac'	=>	'application/pkix-attr-cert',
		'acc'	=>	'application/vnd.americandynamics.acc',
		'ace'	=>	'application/x-ace-compressed',
		'acgi'	=>	'text/html',
		'acu'	=>	'application/vnd.acucobol',
		'acutc'	=>	'application/vnd.acucorp',
		'adp'	=>	'audio/adpcm',
		'aep'	=>	'application/vnd.audiograph',
		'afl'	=>	'video/animaflex',
		'afm'	=>	'application/x-font-type1',
		'afp'	=>	'application/vnd.ibm.modcap',
		'ahead'	=>	'application/vnd.ahead.space',
		'ai'	=>	'application/postscript',
		'aif'	=>	array
			(
				'0'	=>	'audio/aiff',
				'1'	=>	'audio/x-aiff'
			),

		'aifc'	=>	array
			(
				'0'	=>	'audio/aiff',
				'1'	=>	'audio/x-aiff'
			),

		'aiff'	=>	array
			(
				'0'	=>	'audio/aiff',
				'1'	=>	'audio/x-aiff'
			),

		'aim'	=>	'application/x-aim',
		'aip'	=>	'text/x-audiosoft-intra',
		'air'	=>	'application/vnd.adobe.air-application-installer-package+zip',
		'ait'	=>	'application/vnd.dvb.ait',
		'ami'	=>	'application/vnd.amiga.ami',
		'ani'	=>	'application/x-navi-animation',
		'aos'	=>	'application/x-nokia-9000-communicator-add-on-software',
		'apk'	=>	'application/vnd.android.package-archive',
		'appcache'	=>	'text/cache-manifest',
		'application'	=>	'application/x-ms-application',
		'apr'	=>	'application/vnd.lotus-approach',
		'aps'	=>	'application/mime',
		'arc'	=>	'application/octet-stream',
		'arj'	=>	array
			(
				'0'	=>	'application/arj',
				'1'	=>	'application/octet-stream'
			),

		'art'	=>	'image/x-jg',
		'asc'	=>	'application/pgp-signature',
		'asf'	=>	'video/x-ms-asf',
		'asm'	=>	'text/x-asm',
		'aso'	=>	'application/vnd.accpac.simply.aso',
		'asp'	=>	'text/asp',
		'asx'	=>	array
			(
				'0'	=>	'application/x-mplayer2',
				'1'	=>	'video/x-ms-asf',
				'2'	=>	'video/x-ms-asf-plugin'
			),

		'atc'	=>	'application/vnd.acucorp',
		'atom'	=>	'application/atom+xml',
		'atomcat'	=>	'application/atomcat+xml',
		'atomsvc'	=>	'application/atomsvc+xml',
		'atx'	=>	'application/vnd.antix.game-component',
		'au'	=>	array
			(
				'0'	=>	'audio/basic',
				'1'	=>	'audio/x-au'
			),

		'avi'	=>	array
			(
				'0'	=>	'application/x-troff-msvideo',
				'1'	=>	'video/avi',
				'2'	=>	'video/msvideo',
				'3'	=>	'video/x-msvideo'
			),

		'avs'	=>	'video/avs-video',
		'aw'	=>	'application/applixware',
		'azf'	=>	'application/vnd.airzip.filesecure.azf',
		'azs'	=>	'application/vnd.airzip.filesecure.azs',
		'azw'	=>	'application/vnd.amazon.ebook',
		'bat'	=>	'application/x-msdownload',
		'bcpio'	=>	'application/x-bcpio',
		'bdf'	=>	'application/x-font-bdf',
		'bdm'	=>	'application/vnd.syncml.dm+wbxml',
		'bed'	=>	'application/vnd.realvnc.bed',
		'bh2'	=>	'application/vnd.fujitsu.oasysprs',
		'bin'	=>	array
			(
				'0'	=>	'application/mac-binary',
				'1'	=>	'application/macbinary',
				'2'	=>	'application/octet-stream',
				'3'	=>	'application/x-binary',
				'4'	=>	'application/x-macbinary'
			),

		'blb'	=>	'application/x-blorb',
		'blorb'	=>	'application/x-blorb',
		'bm'	=>	'image/bmp',
		'bmi'	=>	'application/vnd.bmi',
		'bmp'	=>	array
			(
				'0'	=>	'image/bmp',
				'1'	=>	'image/x-windows-bmp'
			),

		'boo'	=>	'application/book',
		'book'	=>	'application/book',
		'box'	=>	'application/vnd.previewsystems.box',
		'boz'	=>	'application/x-bzip2',
		'bpk'	=>	'application/octet-stream',
		'bsh'	=>	'application/x-bsh',
		'btif'	=>	'image/prs.btif',
		'bz'	=>	'application/x-bzip',
		'bz2'	=>	'application/x-bzip2',
		'c'	=>	array
			(
				'0'	=>	'text/plain',
				'1'	=>	'text/x-c'
			),

		'c++'	=>	'text/plain',
		'c11amc'	=>	'application/vnd.cluetrust.cartomobile-config',
		'c11amz'	=>	'application/vnd.cluetrust.cartomobile-config-pkg',
		'c4d'	=>	'application/vnd.clonk.c4group',
		'c4f'	=>	'application/vnd.clonk.c4group',
		'c4g'	=>	'application/vnd.clonk.c4group',
		'c4p'	=>	'application/vnd.clonk.c4group',
		'c4u'	=>	'application/vnd.clonk.c4group',
		'cab'	=>	'application/vnd.ms-cab-compressed',
		'caf'	=>	'audio/x-caf',
		'cap'	=>	'application/vnd.tcpdump.pcap',
		'car'	=>	'application/vnd.curl.car',
		'cat'	=>	'application/vnd.ms-pki.seccat',
		'cb7'	=>	'application/x-cbr',
		'cba'	=>	'application/x-cbr',
		'cbr'	=>	'application/x-cbr',
		'cbt'	=>	'application/x-cbr',
		'cbz'	=>	'application/x-cbr',
		'cc'	=>	array
			(
				'0'	=>	'text/plain',
				'1'	=>	'text/x-c'
			),

		'ccad'	=>	'application/clariscad',
		'cco'	=>	'application/x-cocoa',
		'cct'	=>	'application/x-director',
		'ccxml'	=>	'application/ccxml+xml',
		'cdbcmsg'	=>	'application/vnd.contact.cmsg',
		'cdf'	=>	array
			(
				'0'	=>	'application/cdf',
				'1'	=>	'application/x-cdf',
				'2'	=>	'application/x-netcdf'
			),

		'cdkey'	=>	'application/vnd.mediastation.cdkey',
		'cdmia'	=>	'application/cdmi-capability',
		'cdmic'	=>	'application/cdmi-container',
		'cdmid'	=>	'application/cdmi-domain',
		'cdmio'	=>	'application/cdmi-object',
		'cdmiq'	=>	'application/cdmi-queue',
		'cdx'	=>	'chemical/x-cdx',
		'cdxml'	=>	'application/vnd.chemdraw+xml',
		'cdy'	=>	'application/vnd.cinderella',
		'cer'	=>	array
			(
				'0'	=>	'application/pkix-cert',
				'1'	=>	'application/x-x509-ca-cert'
			),

		'cfs'	=>	'application/x-cfs-compressed',
		'cgm'	=>	'image/cgm',
		'cha'	=>	'application/x-chat',
		'chat'	=>	'application/x-chat',
		'chm'	=>	'application/vnd.ms-htmlhelp',
		'chrt'	=>	'application/vnd.kde.kchart',
		'cif'	=>	'chemical/x-cif',
		'cii'	=>	'application/vnd.anser-web-certificate-issue-initiation',
		'cil'	=>	'application/vnd.ms-artgalry',
		'cla'	=>	'application/vnd.claymore',
		'class'	=>	array
			(
				'0'	=>	'application/java',
				'1'	=>	'application/java-byte-code',
				'2'	=>	'application/x-java-class'
			),

		'clkk'	=>	'application/vnd.crick.clicker.keyboard',
		'clkp'	=>	'application/vnd.crick.clicker.palette',
		'clkt'	=>	'application/vnd.crick.clicker.template',
		'clkw'	=>	'application/vnd.crick.clicker.wordbank',
		'clkx'	=>	'application/vnd.crick.clicker',
		'clp'	=>	'application/x-msclip',
		'cmc'	=>	'application/vnd.cosmocaller',
		'cmdf'	=>	'chemical/x-cmdf',
		'cml'	=>	'chemical/x-cml',
		'cmp'	=>	'application/vnd.yellowriver-custom-menu',
		'cmx'	=>	'image/x-cmx',
		'cod'	=>	'application/vnd.rim.cod',
		'com'	=>	array
			(
				'0'	=>	'application/octet-stream',
				'1'	=>	'text/plain'
			),

		'conf'	=>	'text/plain',
		'cpio'	=>	'application/x-cpio',
		'cpp'	=>	'text/x-c',
		'cpt'	=>	array
			(
				'0'	=>	'application/mac-compactpro',
				'1'	=>	'application/x-compactpro',
				'2'	=>	'application/x-cpt'
			),

		'crd'	=>	'application/x-mscardfile',
		'crl'	=>	array
			(
				'0'	=>	'application/pkcs-crl',
				'1'	=>	'application/pkix-crl'
			),

		'crt'	=>	array
			(
				'0'	=>	'application/pkix-cert',
				'1'	=>	'application/x-x509-ca-cert',
				'2'	=>	'application/x-x509-user-cert'
			),

		'cryptonote'	=>	'application/vnd.rig.cryptonote',
		'csh'	=>	array
			(
				'0'	=>	'application/x-csh',
				'1'	=>	'text/x-script.csh'
			),

		'csml'	=>	'chemical/x-csml',
		'csp'	=>	'application/vnd.commonspace',
		'css'	=>	array
			(
				'0'	=>	'application/x-pointplus',
				'1'	=>	'text/css'
			),

		'cst'	=>	'application/x-director',
		'csv'	=>	'text/csv',
		'cu'	=>	'application/cu-seeme',
		'curl'	=>	'text/vnd.curl',
		'cww'	=>	'application/prs.cww',
		'cxt'	=>	'application/x-director',
		'cxx'	=>	'text/plain',
		'dae'	=>	'model/vnd.collada+xml',
		'daf'	=>	'application/vnd.mobius.daf',
		'dart'	=>	'application/vnd.dart',
		'dataless'	=>	'application/vnd.fdsn.seed',
		'davmount'	=>	'application/davmount+xml',
		'dbk'	=>	'application/docbook+xml',
		'dcr'	=>	'application/x-director',
		'dcurl'	=>	'text/vnd.curl.dcurl',
		'dd2'	=>	'application/vnd.oma.dd2+xml',
		'ddd'	=>	'application/vnd.fujixerox.ddd',
		'deb'	=>	'application/x-debian-package',
		'deepv'	=>	'application/x-deepv',
		'def'	=>	'text/plain',
		'deploy'	=>	'application/octet-stream',
		'der'	=>	'application/x-x509-ca-cert',
		'dfac'	=>	'application/vnd.dreamfactory',
		'dgc'	=>	'application/x-dgc-compressed',
		'dic'	=>	'text/x-c',
		'dif'	=>	'video/x-dv',
		'dir'	=>	'application/x-director',
		'dis'	=>	'application/vnd.mobius.dis',
		'dist'	=>	'application/octet-stream',
		'distz'	=>	'application/octet-stream',
		'djv'	=>	'image/vnd.djvu',
		'djvu'	=>	'image/vnd.djvu',
		'dl'	=>	array
			(
				'0'	=>	'video/dl',
				'1'	=>	'video/x-dl'
			),

		'dll'	=>	'application/x-msdownload',
		'dmg'	=>	'application/x-apple-diskimage',
		'dmp'	=>	'application/vnd.tcpdump.pcap',
		'dms'	=>	'application/octet-stream',
		'dna'	=>	'application/vnd.dna',
		'doc'	=>	'application/msword',
		'docm'	=>	'application/vnd.ms-word.document.macroenabled.12',
		'docx'	=>	'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
		'dot'	=>	'application/msword',
		'dotm'	=>	'application/vnd.ms-word.template.macroenabled.12',
		'dotx'	=>	'application/vnd.openxmlformats-officedocument.wordprocessingml.template',
		'dp'	=>	'application/commonground',
		'dpg'	=>	'application/vnd.dpgraph',
		'dra'	=>	'audio/vnd.dra',
		'drw'	=>	'application/drafting',
		'dsc'	=>	'text/prs.lines.tag',
		'dssc'	=>	'application/dssc+der',
		'dtb'	=>	'application/x-dtbook+xml',
		'dtd'	=>	'application/xml-dtd',
		'dts'	=>	'audio/vnd.dts',
		'dtshd'	=>	'audio/vnd.dts.hd',
		'dump'	=>	'application/octet-stream',
		'dv'	=>	'video/x-dv',
		'dvb'	=>	'video/vnd.dvb.file',
		'dvi'	=>	'application/x-dvi',
		'dwf'	=>	array
			(
				'0'	=>	'drawing/x-dwf',
				'1'	=>	'model/vnd.dwf'
			),

		'dwg'	=>	array
			(
				'0'	=>	'application/acad',
				'1'	=>	'image/vnd.dwg',
				'2'	=>	'image/vnd.dwg'
			),

		'dxf'	=>	array
			(
				'0'	=>	'application/dxf',
				'1'	=>	'image/vnd.dwg',
				'2'	=>	'image/x-dwg'
			),

		'dxp'	=>	'application/vnd.spotfire.dxp',
		'dxr'	=>	'application/x-director',
		'ecelp4800'	=>	'audio/vnd.nuera.ecelp4800',
		'ecelp7470'	=>	'audio/vnd.nuera.ecelp7470',
		'ecelp9600'	=>	'audio/vnd.nuera.ecelp9600',
		'ecma'	=>	'application/ecmascript',
		'edm'	=>	'application/vnd.novadigm.edm',
		'edx'	=>	'application/vnd.novadigm.edx',
		'efif'	=>	'application/vnd.picsel',
		'ei6'	=>	'application/vnd.pg.osasli',
		'el'	=>	'text/x-script.elisp',
		'elc'	=>	array
			(
				'0'	=>	'application/x-bytecode.elisp',
				'1'	=>	'application/x-elc'
			),

		'emf'	=>	'application/x-msmetafile',
		'eml'	=>	'message/rfc822',
		'emma'	=>	'application/emma+xml',
		'emz'	=>	'application/x-msmetafile',
		'env'	=>	'application/x-envoy',
		'eol'	=>	'audio/vnd.digital-winds',
		'eot'	=>	'application/vnd.ms-fontobject',
		'eps'	=>	'application/postscript',
		'epub'	=>	'application/epub+zip',
		'es'	=>	'application/x-esrehber',
		'es3'	=>	'application/vnd.eszigno3+xml',
		'esa'	=>	'application/vnd.osgi.subsystem',
		'esf'	=>	'application/vnd.epson.esf',
		'et3'	=>	'application/vnd.eszigno3+xml',
		'etx'	=>	'text/x-setext',
		'eva'	=>	'application/x-eva',
		'evy'	=>	array
			(
				'0'	=>	'application/envoy',
				'1'	=>	'application/x-envoy'
			),

		'exe'	=>	'application/octet-stream',
		'exi'	=>	'application/exi',
		'ext'	=>	'application/vnd.novadigm.ext',
		'ez'	=>	'application/andrew-inset',
		'ez2'	=>	'application/vnd.ezpix-album',
		'ez3'	=>	'application/vnd.ezpix-package',
		'f'	=>	array
			(
				'0'	=>	'text/plain',
				'1'	=>	'text/x-fortran'
			),

		'f4v'	=>	'video/x-f4v',
		'f77'	=>	'text/x-fortran',
		'f90'	=>	array
			(
				'0'	=>	'text/plain',
				'1'	=>	'text/x-fortran'
			),

		'fbs'	=>	'image/vnd.fastbidsheet',
		'fcdt'	=>	'application/vnd.adobe.formscentral.fcdt',
		'fcs'	=>	'application/vnd.isac.fcs',
		'fdf'	=>	'application/vnd.fdf',
		'fe_launch'	=>	'application/vnd.denovo.fcselayout-link',
		'fg5'	=>	'application/vnd.fujitsu.oasysgp',
		'fgd'	=>	'application/x-director',
		'fh'	=>	'image/x-freehand',
		'fh4'	=>	'image/x-freehand',
		'fh5'	=>	'image/x-freehand',
		'fh7'	=>	'image/x-freehand',
		'fhc'	=>	'image/x-freehand',
		'fif'	=>	array
			(
				'0'	=>	'application/fractals',
				'1'	=>	'image/fif'
			),

		'fig'	=>	'application/x-xfig',
		'flac'	=>	'audio/x-flac',
		'fli'	=>	array
			(
				'0'	=>	'video/fli',
				'1'	=>	'video/x-fli'
			),

		'flo'	=>	'image/florian',
		'flv'	=>	'video/x-flv',
		'flw'	=>	'application/vnd.kde.kivio',
		'flx'	=>	'text/vnd.fmi.flexstor',
		'fly'	=>	'text/vnd.fly',
		'fm'	=>	'application/vnd.framemaker',
		'fmf'	=>	'video/x-atomic3d-feature',
		'fnc'	=>	'application/vnd.frogans.fnc',
		'for'	=>	array
			(
				'0'	=>	'text/plain',
				'1'	=>	'text/x-fortran'
			),

		'fpx'	=>	array
			(
				'0'	=>	'image/vnd.fpx',
				'1'	=>	'image/vnd.net-fpx'
			),

		'frame'	=>	'application/vnd.framemaker',
		'frl'	=>	'application/freeloader',
		'fsc'	=>	'application/vnd.fsc.weblaunch',
		'fst'	=>	'image/vnd.fst',
		'ftc'	=>	'application/vnd.fluxtime.clip',
		'fti'	=>	'application/vnd.anser-web-funds-transfer-initiation',
		'funk'	=>	'audio/make',
		'fvt'	=>	'video/vnd.fvt',
		'fxp'	=>	'application/vnd.adobe.fxp',
		'fxpl'	=>	'application/vnd.adobe.fxp',
		'fzs'	=>	'application/vnd.fuzzysheet',
		'g'	=>	'text/plain',
		'g2w'	=>	'application/vnd.geoplan',
		'g3'	=>	'image/g3fax',
		'g3w'	=>	'application/vnd.geospace',
		'gac'	=>	'application/vnd.groove-account',
		'gam'	=>	'application/x-tads',
		'gbr'	=>	'application/rpki-ghostbusters',
		'gca'	=>	'application/x-gca-compressed',
		'gdl'	=>	'model/vnd.gdl',
		'geo'	=>	'application/vnd.dynageo',
		'gex'	=>	'application/vnd.geometry-explorer',
		'ggb'	=>	'application/vnd.geogebra.file',
		'ggt'	=>	'application/vnd.geogebra.tool',
		'ghf'	=>	'application/vnd.groove-help',
		'gif'	=>	'image/gif',
		'gim'	=>	'application/vnd.groove-identity-message',
		'gl'	=>	array
			(
				'0'	=>	'video/gl',
				'1'	=>	'video/x-gl'
			),

		'gml'	=>	'application/gml+xml',
		'gmx'	=>	'application/vnd.gmx',
		'gnumeric'	=>	'application/x-gnumeric',
		'gph'	=>	'application/vnd.flographit',
		'gpx'	=>	'application/gpx+xml',
		'gqf'	=>	'application/vnd.grafeq',
		'gqs'	=>	'application/vnd.grafeq',
		'gram'	=>	'application/srgs',
		'gramps'	=>	'application/x-gramps-xml',
		'gre'	=>	'application/vnd.geometry-explorer',
		'grv'	=>	'application/vnd.groove-injector',
		'grxml'	=>	'application/srgs+xml',
		'gsd'	=>	'audio/x-gsm',
		'gsf'	=>	'application/x-font-ghostscript',
		'gsm'	=>	'audio/x-gsm',
		'gsp'	=>	'application/x-gsp',
		'gss'	=>	'application/x-gss',
		'gtar'	=>	'application/x-gtar',
		'gtm'	=>	'application/vnd.groove-tool-message',
		'gtw'	=>	'model/vnd.gtw',
		'gv'	=>	'text/vnd.graphviz',
		'gxf'	=>	'application/gxf',
		'gxt'	=>	'application/vnd.geonext',
		'gz'	=>	array
			(
				'0'	=>	'application/x-compressed',
				'1'	=>	'application/x-gzip'
			),

		'gzip'	=>	array
			(
				'0'	=>	'application/x-gzip',
				'1'	=>	'multipart/x-gzip'
			),

		'h'	=>	array
			(
				'0'	=>	'text/plain',
				'1'	=>	'text/x-h'
			),

		'h261'	=>	'video/h261',
		'h263'	=>	'video/h263',
		'h264'	=>	'video/h264',
		'hal'	=>	'application/vnd.hal+xml',
		'hbci'	=>	'application/vnd.hbci',
		'hdf'	=>	'application/x-hdf',
		'help'	=>	'application/x-helpfile',
		'hgl'	=>	'application/vnd.hp-hpgl',
		'hh'	=>	array
			(
				'0'	=>	'text/plain',
				'1'	=>	'text/x-h'
			),

		'hlb'	=>	'text/x-script',
		'hlp'	=>	array
			(
				'0'	=>	'application/hlp',
				'1'	=>	'application/x-helpfile',
				'2'	=>	'application/x-winhelp'
			),

		'hpg'	=>	'application/vnd.hp-hpgl',
		'hpgl'	=>	'application/vnd.hp-hpgl',
		'hpid'	=>	'application/vnd.hp-hpid',
		'hps'	=>	'application/vnd.hp-hps',
		'hqx'	=>	array
			(
				'0'	=>	'application/binhex',
				'1'	=>	'application/binhex4',
				'2'	=>	'application/mac-binhex',
				'3'	=>	'application/mac-binhex40',
				'4'	=>	'application/x-binhex40',
				'5'	=>	'application/x-mac-binhex40'
			),

		'hta'	=>	'application/hta',
		'htc'	=>	'text/x-component',
		'htke'	=>	'application/vnd.kenameaapp',
		'htm'	=>	'text/html',
		'html'	=>	'text/html',
		'htmls'	=>	'text/html',
		'htt'	=>	'text/webviewhtml',
		'htx'	=>	'text/html',
		'hvd'	=>	'application/vnd.yamaha.hv-dic',
		'hvp'	=>	'application/vnd.yamaha.hv-voice',
		'hvs'	=>	'application/vnd.yamaha.hv-script',
		'i2g'	=>	'application/vnd.intergeo',
		'icc'	=>	'application/vnd.iccprofile',
		'ice'	=>	'x-conference/x-cooltalk',
		'icm'	=>	'application/vnd.iccprofile',
		'ico'	=>	'image/x-icon',
		'ics'	=>	'text/calendar',
		'idc'	=>	'text/plain',
		'ief'	=>	'image/ief',
		'iefs'	=>	'image/ief',
		'ifb'	=>	'text/calendar',
		'ifm'	=>	'application/vnd.shana.informed.formdata',
		'iges'	=>	'model/iges',
		'igl'	=>	'application/vnd.igloader',
		'igm'	=>	'application/vnd.insors.igm',
		'igs'	=>	'model/iges',
		'igx'	=>	'application/vnd.micrografx.igx',
		'iif'	=>	'application/vnd.shana.informed.interchange',
		'ima'	=>	'application/x-ima',
		'imap'	=>	'application/x-httpd-imap',
		'imp'	=>	'application/vnd.accpac.simply.imp',
		'ims'	=>	'application/vnd.ms-ims',
		'in'	=>	'text/plain',
		'inf'	=>	'application/inf',
		'ink'	=>	'application/inkml+xml',
		'inkml'	=>	'application/inkml+xml',
		'ins'	=>	'application/x-internett-signup',
		'install'	=>	'application/x-install-instructions',
		'iota'	=>	'application/vnd.astraea-software.iota',
		'ip'	=>	'application/x-ip2',
		'ipfix'	=>	'application/ipfix',
		'ipk'	=>	'application/vnd.shana.informed.package',
		'irm'	=>	'application/vnd.ibm.rights-management',
		'irp'	=>	'application/vnd.irepository.package+xml',
		'iso'	=>	'application/x-iso9660-image',
		'isu'	=>	'video/x-isvideo',
		'it'	=>	'audio/it',
		'itp'	=>	'application/vnd.shana.informed.formtemplate',
		'iv'	=>	'application/x-inventor',
		'ivp'	=>	'application/vnd.immervision-ivp',
		'ivr'	=>	'i-world/i-vrml',
		'ivu'	=>	'application/vnd.immervision-ivu',
		'ivy'	=>	'application/x-livescreen',
		'jad'	=>	'text/vnd.sun.j2me.app-descriptor',
		'jam'	=>	'audio/x-jam',
		'jar'	=>	'application/java-archive',
		'jav'	=>	array
			(
				'0'	=>	'text/plain',
				'1'	=>	'text/x-java-source'
			),

		'java'	=>	array
			(
				'0'	=>	'text/plain',
				'1'	=>	'text/x-java-source'
			),

		'jcm'	=>	'application/x-java-commerce',
		'jfif'	=>	array
			(
				'0'	=>	'image/jpeg',
				'1'	=>	'image/pjpeg'
			),

		'jfif-tbnl'	=>	'image/jpeg',
		'jisp'	=>	'application/vnd.jisp',
		'jlt'	=>	'application/vnd.hp-jlyt',
		'jnlp'	=>	'application/x-java-jnlp-file',
		'joda'	=>	'application/vnd.joost.joda-archive',
		'jpe'	=>	array
			(
				'0'	=>	'image/jpeg',
				'1'	=>	'image/pjpeg'
			),

		'jpeg'	=>	array
			(
				'0'	=>	'image/jpeg',
				'1'	=>	'image/pjpeg'
			),

		'jpg'	=>	array
			(
				'0'	=>	'image/jpeg',
				'1'	=>	'image/pjpeg'
			),

		'jpgm'	=>	'video/jpm',
		'jpgv'	=>	'video/jpeg',
		'jpm'	=>	'video/jpm',
		'jps'	=>	'image/x-jps',
		'js'	=>	array
			(
				'0'	=>	'application/x-javascript',
				'1'	=>	'application/javascript',
				'2'	=>	'application/ecmascript',
				'3'	=>	'text/javascript',
				'4'	=>	'text/ecmascript'
			),

		'json'	=>	'application/json',
		'jsonml'	=>	'application/jsonml+json',
		'jut'	=>	'image/jutvision',
		'kar'	=>	array
			(
				'0'	=>	'audio/midi',
				'1'	=>	'music/x-karaoke'
			),

		'karbon'	=>	'application/vnd.kde.karbon',
		'kfo'	=>	'application/vnd.kde.kformula',
		'kia'	=>	'application/vnd.kidspiration',
		'kml'	=>	'application/vnd.google-earth.kml+xml',
		'kmz'	=>	'application/vnd.google-earth.kmz',
		'kne'	=>	'application/vnd.kinar',
		'knp'	=>	'application/vnd.kinar',
		'kon'	=>	'application/vnd.kde.kontour',
		'kpr'	=>	'application/vnd.kde.kpresenter',
		'kpt'	=>	'application/vnd.kde.kpresenter',
		'kpxx'	=>	'application/vnd.ds-keypoint',
		'ksh'	=>	array
			(
				'0'	=>	'application/x-ksh',
				'1'	=>	'text/x-script.ksh'
			),

		'ksp'	=>	'application/vnd.kde.kspread',
		'ktr'	=>	'application/vnd.kahootz',
		'ktx'	=>	'image/ktx',
		'ktz'	=>	'application/vnd.kahootz',
		'kwd'	=>	'application/vnd.kde.kword',
		'kwt'	=>	'application/vnd.kde.kword',
		'la'	=>	array
			(
				'0'	=>	'audio/nspaudio',
				'1'	=>	'audio/x-nspaudio'
			),

		'lam'	=>	'audio/x-liveaudio',
		'lasxml'	=>	'application/vnd.las.las+xml',
		'latex'	=>	'application/x-latex',
		'lbd'	=>	'application/vnd.llamagraphics.life-balance.desktop',
		'lbe'	=>	'application/vnd.llamagraphics.life-balance.exchange+xml',
		'les'	=>	'application/vnd.hhe.lesson-player',
		'lha'	=>	array
			(
				'0'	=>	'application/lha',
				'1'	=>	'application/octet-stream',
				'2'	=>	'application/x-lha'
			),

		'lhx'	=>	'application/octet-stream',
		'link66'	=>	'application/vnd.route66.link66+xml',
		'list'	=>	'text/plain',
		'list3820'	=>	'application/vnd.ibm.modcap',
		'listafp'	=>	'application/vnd.ibm.modcap',
		'lma'	=>	array
			(
				'0'	=>	'audio/nspaudio',
				'1'	=>	'audio/x-nspaudio'
			),

		'lnk'	=>	'application/x-ms-shortcut',
		'log'	=>	'text/plain',
		'lostxml'	=>	'application/lost+xml',
		'lrf'	=>	'application/octet-stream',
		'lrm'	=>	'application/vnd.ms-lrm',
		'lsp'	=>	array
			(
				'0'	=>	'application/x-lisp',
				'1'	=>	'text/x-script.lisp'
			),

		'lst'	=>	'text/plain',
		'lsx'	=>	'text/x-la-asf',
		'ltf'	=>	'application/vnd.frogans.ltf',
		'ltx'	=>	'application/x-latex',
		'lvp'	=>	'audio/vnd.lucent.voice',
		'lwp'	=>	'application/vnd.lotus-wordpro',
		'lzh'	=>	array
			(
				'0'	=>	'application/octet-stream',
				'1'	=>	'application/x-lzh'
			),

		'lzx'	=>	array
			(
				'0'	=>	'application/lzx',
				'1'	=>	'application/octet-stream',
				'2'	=>	'application/x-lzx'
			),

		'm'	=>	array
			(
				'0'	=>	'text/plain',
				'1'	=>	'text/x-m'
			),

		'm13'	=>	'application/x-msmediaview',
		'm14'	=>	'application/x-msmediaview',
		'm1v'	=>	'video/mpeg',
		'm21'	=>	'application/mp21',
		'm2a'	=>	'audio/mpeg',
		'm2v'	=>	'video/mpeg',
		'm3a'	=>	'audio/mpeg',
		'm3u'	=>	'audio/x-mpequrl',
		'm3u8'	=>	'application/vnd.apple.mpegurl',
		'm4u'	=>	'video/vnd.mpegurl',
		'm4v'	=>	'video/x-m4v',
		'ma'	=>	'application/mathematica',
		'mads'	=>	'application/mads+xml',
		'mag'	=>	'application/vnd.ecowin.chart',
		'maker'	=>	'application/vnd.framemaker',
		'man'	=>	'application/x-troff-man',
		'map'	=>	'application/x-navimap',
		'mar'	=>	'text/plain',
		'mathml'	=>	'application/mathml+xml',
		'mb'	=>	'application/mathematica',
		'mbd'	=>	'application/mbedlet',
		'mbk'	=>	'application/vnd.mobius.mbk',
		'mbox'	=>	'application/mbox',
		'mc$'	=>	'application/x-magic-cap-package-1.0',
		'mc1'	=>	'application/vnd.medcalcdata',
		'mcd'	=>	array
			(
				'0'	=>	'application/mcad',
				'1'	=>	'application/x-mathcad'
			),

		'mcf'	=>	array
			(
				'0'	=>	'image/vasa',
				'1'	=>	'text/mcf'
			),

		'mcp'	=>	'application/netmc',
		'mcurl'	=>	'text/vnd.curl.mcurl',
		'mdb'	=>	'application/x-msaccess',
		'mdi'	=>	'image/vnd.ms-modi',
		'me'	=>	'application/x-troff-me',
		'mesh'	=>	'model/mesh',
		'meta4'	=>	'application/metalink4+xml',
		'metalink'	=>	'application/metalink+xml',
		'mets'	=>	'application/mets+xml',
		'mfm'	=>	'application/vnd.mfmp',
		'mft'	=>	'application/rpki-manifest',
		'mgp'	=>	'application/vnd.osgeo.mapguide.package',
		'mgz'	=>	'application/vnd.proteus.magazine',
		'mht'	=>	'message/rfc822',
		'mhtml'	=>	'message/rfc822',
		'mid'	=>	array
			(
				'0'	=>	'application/x-midi',
				'1'	=>	'audio/midi',
				'2'	=>	'audio/x-mid',
				'3'	=>	'audio/x-midi',
				'4'	=>	'x-music/x-midi',
				'5'	=>	'music/crescendo'
			),

		'midi'	=>	array
			(
				'0'	=>	'application/x-midi',
				'1'	=>	'audio/midi',
				'2'	=>	'audio/x-mid',
				'3'	=>	'audio/x-midi',
				'4'	=>	'music/crescendo',
				'5'	=>	'x-music/x-midi'
			),

		'mie'	=>	'application/x-mie',
		'mif'	=>	array
			(
				'0'	=>	'application/x-frame',
				'1'	=>	'application/x-mif'
			),

		'mime'	=>	array
			(
				'0'	=>	'message/rfc822',
				'1'	=>	'www/mime'
			),

		'mj2'	=>	'video/mj2',
		'mjf'	=>	'audio/x-vnd.audioexplosion.mjuicemediafile',
		'mjp2'	=>	'video/mj2',
		'mjpg'	=>	'video/x-motion-jpeg',
		'mk3d'	=>	'video/x-matroska',
		'mka'	=>	'audio/x-matroska',
		'mks'	=>	'video/x-matroska',
		'mkv'	=>	'video/x-matroska',
		'mlp'	=>	'application/vnd.dolby.mlp',
		'mm'	=>	array
			(
				'0'	=>	'application/base64',
				'1'	=>	'application/x-meme'
			),

		'mmd'	=>	'application/vnd.chipnuts.karaoke-mmd',
		'mme'	=>	'application/base64',
		'mmf'	=>	'application/vnd.smaf',
		'mmr'	=>	'image/vnd.fujixerox.edmics-mmr',
		'mng'	=>	'video/x-mng',
		'mny'	=>	'application/x-msmoney',
		'mobi'	=>	'application/x-mobipocket-ebook',
		'mod'	=>	array
			(
				'0'	=>	'audio/mod',
				'1'	=>	'audio/x-mod'
			),

		'mods'	=>	'application/mods+xml',
		'moov'	=>	'video/quicktime',
		'mov'	=>	'video/quicktime',
		'movie'	=>	'video/x-sgi-movie',
		'mp2'	=>	array
			(
				'0'	=>	'audio/mpeg',
				'1'	=>	'audio/x-mpeg',
				'2'	=>	'video/mpeg',
				'3'	=>	'video/x-mpeg',
				'4'	=>	'video/x-mpeq2a'
			),

		'mp21'	=>	'application/mp21',
		'mp2a'	=>	'audio/mpeg',
		'mp3'	=>	array
			(
				'0'	=>	'audio/mpeg3',
				'1'	=>	'audio/x-mpeg-3',
				'2'	=>	'video/mpeg',
				'3'	=>	'video/x-mpeg'
			),

		'mp4'	=>	'video/mp4',
		'mp4a'	=>	'audio/mp4',
		'mp4s'	=>	'application/mp4',
		'mp4v'	=>	'video/mp4',
		'mpa'	=>	array
			(
				'0'	=>	'audio/mpeg',
				'1'	=>	'video/mpeg'
			),

		'mpc'	=>	'application/x-project',
		'mpe'	=>	'video/mpeg',
		'mpeg'	=>	'video/mpeg',
		'mpg'	=>	array
			(
				'0'	=>	'audio/mpeg',
				'1'	=>	'video/mpeg'
			),

		'mpg4'	=>	'video/mp4',
		'mpga'	=>	'audio/mpeg',
		'mpkg'	=>	'application/vnd.apple.installer+xml',
		'mpm'	=>	'application/vnd.blueice.multipass',
		'mpn'	=>	'application/vnd.mophun.application',
		'mpp'	=>	'application/vnd.ms-project',
		'mpt'	=>	'application/x-project',
		'mpv'	=>	'application/x-project',
		'mpx'	=>	'application/x-project',
		'mpy'	=>	'application/vnd.ibm.minipay',
		'mqy'	=>	'application/vnd.mobius.mqy',
		'mrc'	=>	'application/marc',
		'mrcx'	=>	'application/marcxml+xml',
		'ms'	=>	'application/x-troff-ms',
		'mscml'	=>	'application/mediaservercontrol+xml',
		'mseed'	=>	'application/vnd.fdsn.mseed',
		'mseq'	=>	'application/vnd.mseq',
		'msf'	=>	'application/vnd.epson.msf',
		'msh'	=>	'model/mesh',
		'msi'	=>	'application/x-msdownload',
		'msl'	=>	'application/vnd.mobius.msl',
		'msty'	=>	'application/vnd.muvee.style',
		'mts'	=>	'model/vnd.mts',
		'mus'	=>	'application/vnd.musician',
		'musicxml'	=>	'application/vnd.recordare.musicxml+xml',
		'mv'	=>	'video/x-sgi-movie',
		'mvb'	=>	'application/x-msmediaview',
		'mwf'	=>	'application/vnd.mfer',
		'mxf'	=>	'application/mxf',
		'mxl'	=>	'application/vnd.recordare.musicxml',
		'mxml'	=>	'application/xv+xml',
		'mxs'	=>	'application/vnd.triscape.mxs',
		'mxu'	=>	'video/vnd.mpegurl',
		'my'	=>	'audio/make',
		'mzz'	=>	'application/x-vnd.audioexplosion.mzz',
		'n-gage'	=>	'application/vnd.nokia.n-gage.symbian.install',
		'n3'	=>	'text/n3',
		'nap'	=>	'image/naplps',
		'naplps'	=>	'image/naplps',
		'nb'	=>	'application/mathematica',
		'nbp'	=>	'application/vnd.wolfram.player',
		'nc'	=>	'application/x-netcdf',
		'ncm'	=>	'application/vnd.nokia.configuration-message',
		'ncx'	=>	'application/x-dtbncx+xml',
		'nfo'	=>	'text/x-nfo',
		'ngdat'	=>	'application/vnd.nokia.n-gage.data',
		'nif'	=>	'image/x-niff',
		'niff'	=>	'image/x-niff',
		'nitf'	=>	'application/vnd.nitf',
		'nix'	=>	'application/x-mix-transfer',
		'nlu'	=>	'application/vnd.neurolanguage.nlu',
		'nml'	=>	'application/vnd.enliven',
		'nnd'	=>	'application/vnd.noblenet-directory',
		'nns'	=>	'application/vnd.noblenet-sealer',
		'nnw'	=>	'application/vnd.noblenet-web',
		'npx'	=>	'image/vnd.net-fpx',
		'nsc'	=>	'application/x-conference',
		'nsf'	=>	'application/vnd.lotus-notes',
		'ntf'	=>	'application/vnd.nitf',
		'nvd'	=>	'application/x-navidoc',
		'nzb'	=>	'application/x-nzb',
		'o'	=>	'application/octet-stream',
		'oa2'	=>	'application/vnd.fujitsu.oasys2',
		'oa3'	=>	'application/vnd.fujitsu.oasys3',
		'oas'	=>	'application/vnd.fujitsu.oasys',
		'obd'	=>	'application/x-msbinder',
		'obj'	=>	'application/x-tgif',
		'oda'	=>	'application/oda',
		'odb'	=>	'application/vnd.oasis.opendocument.database',
		'odc'	=>	'application/vnd.oasis.opendocument.chart',
		'odf'	=>	'application/vnd.oasis.opendocument.formula',
		'odft'	=>	'application/vnd.oasis.opendocument.formula-template',
		'odg'	=>	'application/vnd.oasis.opendocument.graphics',
		'odi'	=>	'application/vnd.oasis.opendocument.image',
		'odm'	=>	'application/vnd.oasis.opendocument.text-master',
		'odp'	=>	'application/vnd.oasis.opendocument.presentation',
		'ods'	=>	'application/vnd.oasis.opendocument.spreadsheet',
		'odt'	=>	'application/vnd.oasis.opendocument.text',
		'oga'	=>	'audio/ogg',
		'ogg'	=>	'audio/ogg',
		'ogv'	=>	'video/ogg',
		'ogx'	=>	'application/ogg',
		'omc'	=>	'application/x-omc',
		'omcd'	=>	'application/x-omcdatamaker',
		'omcr'	=>	'application/x-omcregerator',
		'omdoc'	=>	'application/omdoc+xml',
		'onepkg'	=>	'application/onenote',
		'onetmp'	=>	'application/onenote',
		'onetoc'	=>	'application/onenote',
		'onetoc2'	=>	'application/onenote',
		'opf'	=>	'application/oebps-package+xml',
		'opml'	=>	'text/x-opml',
		'oprc'	=>	'application/vnd.palm',
		'org'	=>	'application/vnd.lotus-organizer',
		'osf'	=>	'application/vnd.yamaha.openscoreformat',
		'osfpvg'	=>	'application/vnd.yamaha.openscoreformat.osfpvg+xml',
		'otc'	=>	'application/vnd.oasis.opendocument.chart-template',
		'otf'	=>	'application/x-font-otf',
		'otg'	=>	'application/vnd.oasis.opendocument.graphics-template',
		'oth'	=>	'application/vnd.oasis.opendocument.text-web',
		'oti'	=>	'application/vnd.oasis.opendocument.image-template',
		'otp'	=>	'application/vnd.oasis.opendocument.presentation-template',
		'ots'	=>	'application/vnd.oasis.opendocument.spreadsheet-template',
		'ott'	=>	'application/vnd.oasis.opendocument.text-template',
		'oxps'	=>	'application/oxps',
		'oxt'	=>	'application/vnd.openofficeorg.extension',
		'p'	=>	'text/x-pascal',
		'p10'	=>	array
			(
				'0'	=>	'application/pkcs10',
				'1'	=>	'application/x-pkcs10'
			),

		'p12'	=>	array
			(
				'0'	=>	'application/pkcs-12',
				'1'	=>	'application/x-pkcs12'
			),

		'p7a'	=>	'application/x-pkcs7-signature',
		'p7b'	=>	'application/x-pkcs7-certificates',
		'p7c'	=>	array
			(
				'0'	=>	'application/pkcs7-mime',
				'1'	=>	'application/x-pkcs7-mime'
			),

		'p7m'	=>	array
			(
				'0'	=>	'application/pkcs7-mime',
				'1'	=>	'application/x-pkcs7-mime'
			),

		'p7r'	=>	'application/x-pkcs7-certreqresp',
		'p7s'	=>	'application/pkcs7-signature',
		'p8'	=>	'application/pkcs8',
		'part'	=>	'application/pro_eng',
		'pas'	=>	'text/pascal',
		'paw'	=>	'application/vnd.pawaafile',
		'pbd'	=>	'application/vnd.powerbuilder6',
		'pbm'	=>	'image/x-portable-bitmap',
		'pcap'	=>	'application/vnd.tcpdump.pcap',
		'pcf'	=>	'application/x-font-pcf',
		'pcl'	=>	array
			(
				'0'	=>	'application/vnd.hp-pcl',
				'1'	=>	'application/x-pcl'
			),

		'pclxl'	=>	'application/vnd.hp-pclxl',
		'pct'	=>	'image/x-pict',
		'pcurl'	=>	'application/vnd.curl.pcurl',
		'pcx'	=>	'image/x-pcx',
		'pdb'	=>	'chemical/x-pdb',
		'pdf'	=>	'application/pdf',
		'pfa'	=>	'application/x-font-type1',
		'pfb'	=>	'application/x-font-type1',
		'pfm'	=>	'application/x-font-type1',
		'pfr'	=>	'application/font-tdpfr',
		'pfunk'	=>	array
			(
				'0'	=>	'audio/make',
				'1'	=>	'audio/make.my.funk'
			),

		'pfx'	=>	'application/x-pkcs12',
		'pgm'	=>	array
			(
				'0'	=>	'image/x-portable-graymap',
				'1'	=>	'image/x-portable-greymap'
			),

		'pgn'	=>	'application/x-chess-pgn',
		'pgp'	=>	'application/pgp-encrypted',
		'pic'	=>	'image/pict',
		'pict'	=>	'image/pict',
		'pkg'	=>	'application/x-newton-compatible-pkg',
		'pki'	=>	'application/pkixcmp',
		'pkipath'	=>	'application/pkix-pkipath',
		'pko'	=>	'application/vnd.ms-pki.pko',
		'pl'	=>	array
			(
				'0'	=>	'text/plain',
				'1'	=>	'text/x-script.perl'
			),

		'plb'	=>	'application/vnd.3gpp.pic-bw-large',
		'plc'	=>	'application/vnd.mobius.plc',
		'plf'	=>	'application/vnd.pocketlearn',
		'pls'	=>	'application/pls+xml',
		'plx'	=>	'application/x-pixclscript',
		'pm'	=>	array
			(
				'0'	=>	'image/x-xpixmap',
				'1'	=>	'text/x-script.perl-module'
			),

		'pm4'	=>	'application/x-pagemaker',
		'pm5'	=>	'application/x-pagemaker',
		'pml'	=>	'application/vnd.ctc-posml',
		'png'	=>	'image/png',
		'pnm'	=>	'image/x-portable-anymap',
		'portpkg'	=>	'application/vnd.macports.portpkg',
		'pot'	=>	array
			(
				'0'	=>	'application/mspowerpoint',
				'1'	=>	'application/vnd.ms-powerpoint'
			),

		'potm'	=>	'application/vnd.ms-powerpoint.template.macroenabled.12',
		'potx'	=>	'application/vnd.openxmlformats-officedocument.presentationml.template',
		'pov'	=>	'model/x-pov',
		'ppa'	=>	'application/vnd.ms-powerpoint',
		'ppam'	=>	'application/vnd.ms-powerpoint.addin.macroenabled.12',
		'ppd'	=>	'application/vnd.cups-ppd',
		'ppm'	=>	'image/x-portable-pixmap',
		'pps'	=>	array
			(
				'0'	=>	'application/mspowerpoint',
				'1'	=>	'application/vnd.ms-powerpoint'
			),

		'ppsm'	=>	'application/vnd.ms-powerpoint.slideshow.macroenabled.12',
		'ppsx'	=>	'application/vnd.openxmlformats-officedocument.presentationml.slideshow',
		'ppt'	=>	array
			(
				'0'	=>	'application/mspowerpoint',
				'1'	=>	'application/powerpoint',
				'2'	=>	'application/vnd.ms-powerpoint',
				'3'	=>	'application/x-mspowerpoint'
			),

		'pptm'	=>	'application/vnd.ms-powerpoint.presentation.macroenabled.12',
		'pptx'	=>	'application/vnd.openxmlformats-officedocument.presentationml.presentation',
		'ppz'	=>	'application/mspowerpoint',
		'pqa'	=>	'application/vnd.palm',
		'prc'	=>	'application/x-mobipocket-ebook',
		'pre'	=>	'application/x-freelance',
		'prf'	=>	'application/pics-rules',
		'prt'	=>	'application/pro_eng',
		'ps'	=>	'application/postscript',
		'psb'	=>	'application/vnd.3gpp.pic-bw-small',
		'psd'	=>	'application/octet-stream',
		'psf'	=>	'application/x-font-linux-psf',
		'pskcxml'	=>	'application/pskc+xml',
		'ptid'	=>	'application/vnd.pvi.ptid1',
		'pub'	=>	'application/x-mspublisher',
		'pvb'	=>	'application/vnd.3gpp.pic-bw-var',
		'pvu'	=>	'paleovu/x-pv',
		'pwn'	=>	'application/vnd.3m.post-it-notes',
		'pwz'	=>	'application/vnd.ms-powerpoint',
		'py'	=>	'text/x-script.phyton',
		'pya'	=>	'audio/vnd.ms-playready.media.pya',
		'pyc'	=>	'application/x-bytecode.python',
		'pyv'	=>	'video/vnd.ms-playready.media.pyv',
		'qam'	=>	'application/vnd.epson.quickanime',
		'qbo'	=>	'application/vnd.intu.qbo',
		'qcp'	=>	'audio/vnd.qcelp',
		'qd3'	=>	'x-world/x-3dmf',
		'qd3d'	=>	'x-world/x-3dmf',
		'qfx'	=>	'application/vnd.intu.qfx',
		'qif'	=>	'image/x-quicktime',
		'qps'	=>	'application/vnd.publishare-delta-tree',
		'qt'	=>	'video/quicktime',
		'qtc'	=>	'video/x-qtc',
		'qti'	=>	'image/x-quicktime',
		'qtif'	=>	'image/x-quicktime',
		'qwd'	=>	'application/vnd.quark.quarkxpress',
		'qwt'	=>	'application/vnd.quark.quarkxpress',
		'qxb'	=>	'application/vnd.quark.quarkxpress',
		'qxd'	=>	'application/vnd.quark.quarkxpress',
		'qxl'	=>	'application/vnd.quark.quarkxpress',
		'qxt'	=>	'application/vnd.quark.quarkxpress',
		'ra'	=>	array
			(
				'0'	=>	'audio/x-pn-realaudio',
				'1'	=>	'audio/x-pn-realaudio-plugin',
				'2'	=>	'audio/x-realaudio'
			),

		'ram'	=>	'audio/x-pn-realaudio',
		'rar'	=>	'application/x-rar-compressed',
		'ras'	=>	array
			(
				'0'	=>	'application/x-cmu-raster',
				'1'	=>	'image/cmu-raster',
				'2'	=>	'image/x-cmu-raster'
			),

		'rast'	=>	'image/cmu-raster',
		'rcprofile'	=>	'application/vnd.ipunplugged.rcprofile',
		'rdf'	=>	'application/rdf+xml',
		'rdz'	=>	'application/vnd.data-vision.rdz',
		'rep'	=>	'application/vnd.businessobjects',
		'res'	=>	'application/x-dtbresource+xml',
		'rexx'	=>	'text/x-script.rexx',
		'rf'	=>	'image/vnd.rn-realflash',
		'rgb'	=>	'image/x-rgb',
		'rif'	=>	'application/reginfo+xml',
		'rip'	=>	'audio/vnd.rip',
		'ris'	=>	'application/x-research-info-systems',
		'rl'	=>	'application/resource-lists+xml',
		'rlc'	=>	'image/vnd.fujixerox.edmics-rlc',
		'rld'	=>	'application/resource-lists-diff+xml',
		'rm'	=>	array
			(
				'0'	=>	'application/vnd.rn-realmedia',
				'1'	=>	'audio/x-pn-realaudio'
			),

		'rmi'	=>	'audio/mid',
		'rmm'	=>	'audio/x-pn-realaudio',
		'rmp'	=>	array
			(
				'0'	=>	'audio/x-pn-realaudio',
				'1'	=>	'audio/x-pn-realaudio-plugin'
			),

		'rms'	=>	'application/vnd.jcp.javame.midlet-rms',
		'rmvb'	=>	'application/vnd.rn-realmedia-vbr',
		'rnc'	=>	'application/relax-ng-compact-syntax',
		'rng'	=>	array
			(
				'0'	=>	'application/ringing-tones',
				'1'	=>	'application/vnd.nokia.ringing-tone'
			),

		'rnx'	=>	'application/vnd.rn-realplayer',
		'roa'	=>	'application/rpki-roa',
		'roff'	=>	'application/x-troff',
		'rp'	=>	'image/vnd.rn-realpix',
		'rp9'	=>	'application/vnd.cloanto.rp9',
		'rpm'	=>	'audio/x-pn-realaudio-plugin',
		'rpss'	=>	'application/vnd.nokia.radio-presets',
		'rpst'	=>	'application/vnd.nokia.radio-preset',
		'rq'	=>	'application/sparql-query',
		'rs'	=>	'application/rls-services+xml',
		'rsd'	=>	'application/rsd+xml',
		'rss'	=>	'application/rss+xml',
		'rt'	=>	array
			(
				'0'	=>	'text/richtext',
				'1'	=>	'text/vnd.rn-realtext'
			),

		'rtf'	=>	array
			(
				'0'	=>	'application/rtf',
				'1'	=>	'application/x-rtf',
				'2'	=>	'text/richtext'
			),

		'rtx'	=>	array
			(
				'0'	=>	'application/rtf',
				'1'	=>	'text/richtext'
			),

		'rv'	=>	'video/vnd.rn-realvideo',
		's'	=>	'text/x-asm',
		's3m'	=>	'audio/s3m',
		'saf'	=>	'application/vnd.yamaha.smaf-audio',
		'saveme'	=>	'application/octet-stream',
		'sbk'	=>	'application/x-tbook',
		'sbml'	=>	'application/sbml+xml',
		'sc'	=>	'application/vnd.ibm.secure-container',
		'scd'	=>	'application/x-msschedule',
		'scm'	=>	array
			(
				'0'	=>	'application/x-lotusscreencam',
				'1'	=>	'text/x-script.guile',
				'2'	=>	'text/x-script.scheme',
				'3'	=>	'video/x-scm'
			),

		'scq'	=>	'application/scvp-cv-request',
		'scs'	=>	'application/scvp-cv-response',
		'scurl'	=>	'text/vnd.curl.scurl',
		'sda'	=>	'application/vnd.stardivision.draw',
		'sdc'	=>	'application/vnd.stardivision.calc',
		'sdd'	=>	'application/vnd.stardivision.impress',
		'sdkd'	=>	'application/vnd.solent.sdkm+xml',
		'sdkm'	=>	'application/vnd.solent.sdkm+xml',
		'sdml'	=>	'text/plain',
		'sdp'	=>	array
			(
				'0'	=>	'application/sdp',
				'1'	=>	'application/x-sdp'
			),

		'sdr'	=>	'application/sounder',
		'sdw'	=>	'application/vnd.stardivision.writer',
		'sea'	=>	array
			(
				'0'	=>	'application/sea',
				'1'	=>	'application/x-sea'
			),

		'see'	=>	'application/vnd.seemail',
		'seed'	=>	'application/vnd.fdsn.seed',
		'sema'	=>	'application/vnd.sema',
		'semd'	=>	'application/vnd.semd',
		'semf'	=>	'application/vnd.semf',
		'ser'	=>	'application/java-serialized-object',
		'set'	=>	'application/set',
		'setpay'	=>	'application/set-payment-initiation',
		'setreg'	=>	'application/set-registration-initiation',
		'sfd-hdstx'	=>	'application/vnd.hydrostatix.sof-data',
		'sfs'	=>	'application/vnd.spotfire.sfs',
		'sfv'	=>	'text/x-sfv',
		'sgi'	=>	'image/sgi',
		'sgl'	=>	'application/vnd.stardivision.writer-global',
		'sgm'	=>	array
			(
				'0'	=>	'text/sgml',
				'1'	=>	'text/x-sgml'
			),

		'sgml'	=>	array
			(
				'0'	=>	'text/sgml',
				'1'	=>	'text/x-sgml'
			),

		'sh'	=>	array
			(
				'0'	=>	'application/x-bsh',
				'1'	=>	'application/x-sh',
				'2'	=>	'application/x-shar',
				'3'	=>	'text/x-script.sh'
			),

		'shar'	=>	array
			(
				'0'	=>	'application/x-bsh',
				'1'	=>	'application/x-shar'
			),

		'shf'	=>	'application/shf+xml',
		'shtml'	=>	array
			(
				'0'	=>	'text/html',
				'1'	=>	'text/x-server-parsed-html'
			),

		'sid'	=>	'audio/x-psid',
		'sig'	=>	'application/pgp-signature',
		'sil'	=>	'audio/silk',
		'silo'	=>	'model/mesh',
		'sis'	=>	'application/vnd.symbian.install',
		'sisx'	=>	'application/vnd.symbian.install',
		'sit'	=>	array
			(
				'0'	=>	'application/x-sit',
				'1'	=>	'application/x-stuffit'
			),

		'sitx'	=>	'application/x-stuffitx',
		'skd'	=>	'application/x-koan',
		'skm'	=>	'application/x-koan',
		'skp'	=>	'application/x-koan',
		'skt'	=>	'application/x-koan',
		'sl'	=>	'application/x-seelogo',
		'sldm'	=>	'application/vnd.ms-powerpoint.slide.macroenabled.12',
		'sldx'	=>	'application/vnd.openxmlformats-officedocument.presentationml.slide',
		'slt'	=>	'application/vnd.epson.salt',
		'sm'	=>	'application/vnd.stepmania.stepchart',
		'smf'	=>	'application/vnd.stardivision.math',
		'smi'	=>	'application/smil',
		'smil'	=>	'application/smil',
		'smv'	=>	'video/x-smv',
		'smzip'	=>	'application/vnd.stepmania.package',
		'snd'	=>	'audio/x-adpcm',
		'snf'	=>	'application/x-font-snf',
		'so'	=>	'application/octet-stream',
		'sol'	=>	'application/solids',
		'spc'	=>	array
			(
				'0'	=>	'application/x-pkcs7-certificates',
				'1'	=>	'text/x-speech'
			),

		'spf'	=>	'application/vnd.yamaha.smaf-phrase',
		'spl'	=>	'application/futuresplash',
		'spot'	=>	'text/vnd.in3d.spot',
		'spp'	=>	'application/scvp-vp-response',
		'spq'	=>	'application/scvp-vp-request',
		'spr'	=>	'application/x-sprite',
		'sprite'	=>	'application/x-sprite',
		'spx'	=>	'audio/ogg',
		'sql'	=>	'application/x-sql',
		'src'	=>	'application/x-wais-source',
		'srt'	=>	'application/x-subrip',
		'sru'	=>	'application/sru+xml',
		'srx'	=>	'application/sparql-results+xml',
		'ssdl'	=>	'application/ssdl+xml',
		'sse'	=>	'application/vnd.kodak-descriptor',
		'ssf'	=>	'application/vnd.epson.ssf',
		'ssi'	=>	'text/x-server-parsed-html',
		'ssm'	=>	'application/streamingmedia',
		'ssml'	=>	'application/ssml+xml',
		'sst'	=>	'application/vnd.ms-pki.certstore',
		'st'	=>	'application/vnd.sailingtracker.track',
		'stc'	=>	'application/vnd.sun.xml.calc.template',
		'std'	=>	'application/vnd.sun.xml.draw.template',
		'step'	=>	'application/step',
		'stf'	=>	'application/vnd.wt.stf',
		'sti'	=>	'application/vnd.sun.xml.impress.template',
		'stk'	=>	'application/hyperstudio',
		'stl'	=>	array
			(
				'0'	=>	'application/sla',
				'1'	=>	'application/vnd.ms-pki.stl',
				'2'	=>	'application/x-navistyle'
			),

		'stp'	=>	'application/step',
		'str'	=>	'application/vnd.pg.format',
		'stw'	=>	'application/vnd.sun.xml.writer.template',
		'sub'	=>	'text/vnd.dvb.subtitle',
		'sus'	=>	'application/vnd.sus-calendar',
		'susp'	=>	'application/vnd.sus-calendar',
		'sv4cpio'	=>	'application/x-sv4cpio',
		'sv4crc'	=>	'application/x-sv4crc',
		'svc'	=>	'application/vnd.dvb.service',
		'svd'	=>	'application/vnd.svd',
		'svf'	=>	array
			(
				'0'	=>	'image/vnd.dwg',
				'1'	=>	'image/x-dwg'
			),

		'svg'	=>	'image/svg+xml',
		'svgz'	=>	'image/svg+xml',
		'svr'	=>	array
			(
				'0'	=>	'application/x-world',
				'1'	=>	'x-world/x-svr'
			),

		'swa'	=>	'application/x-director',
		'swf'	=>	'application/x-shockwave-flash',
		'swi'	=>	'application/vnd.aristanetworks.swi',
		'sxc'	=>	'application/vnd.sun.xml.calc',
		'sxd'	=>	'application/vnd.sun.xml.draw',
		'sxg'	=>	'application/vnd.sun.xml.writer.global',
		'sxi'	=>	'application/vnd.sun.xml.impress',
		'sxm'	=>	'application/vnd.sun.xml.math',
		'sxw'	=>	'application/vnd.sun.xml.writer',
		't'	=>	'application/x-troff',
		't3'	=>	'application/x-t3vm-image',
		'taglet'	=>	'application/vnd.mynfc',
		'talk'	=>	'text/x-speech',
		'tao'	=>	'application/vnd.tao.intent-module-archive',
		'tar'	=>	'application/x-tar',
		'tbk'	=>	'application/x-tbook',
		'tcap'	=>	'application/vnd.3gpp2.tcap',
		'tcl'	=>	array
			(
				'0'	=>	'application/x-tcl',
				'1'	=>	'text/x-script.tcl'
			),

		'tcsh'	=>	'text/x-script.tcsh',
		'teacher'	=>	'application/vnd.smart.teacher',
		'tei'	=>	'application/tei+xml',
		'teicorpus'	=>	'application/tei+xml',
		'tex'	=>	'application/x-tex',
		'texi'	=>	'application/x-texinfo',
		'texinfo'	=>	'application/x-texinfo',
		'text'	=>	array
			(
				'0'	=>	'text/plain'
			),

		'tfi'	=>	'application/thraud+xml',
		'tfm'	=>	'application/x-tex-tfm',
		'tga'	=>	'image/x-tga',
		'tgz'	=>	array
			(
				'0'	=>	'application/gnutar',
				'1'	=>	'application/x-compressed'
			),

		'thmx'	=>	'application/vnd.ms-officetheme',
		'tif'	=>	array
			(
				'0'	=>	'image/tiff',
				'1'	=>	'image/x-tiff'
			),

		'tiff'	=>	array
			(
				'0'	=>	'image/tiff',
				'1'	=>	'image/x-tiff'
			),

		'tmo'	=>	'application/vnd.tmobile-livetv',
		'torrent'	=>	'application/x-bittorrent',
		'tpl'	=>	'application/vnd.groove-tool-template',
		'tpt'	=>	'application/vnd.trid.tpt',
		'tr'	=>	'application/x-troff',
		'tra'	=>	'application/vnd.trueapp',
		'trm'	=>	'application/x-msterminal',
		'tsd'	=>	'application/timestamped-data',
		'tsi'	=>	'audio/tsp-audio',
		'tsp'	=>	array
			(
				'0'	=>	'application/dsptype',
				'1'	=>	'audio/tsplayer'
			),

		'tsv'	=>	'text/tab-separated-values',
		'ttc'	=>	'application/x-font-ttf',
		'ttf'	=>	'application/x-font-ttf',
		'ttl'	=>	'text/turtle',
		'turbot'	=>	'image/florian',
		'twd'	=>	'application/vnd.simtech-mindmapper',
		'twds'	=>	'application/vnd.simtech-mindmapper',
		'txd'	=>	'application/vnd.genomatix.tuxedo',
		'txf'	=>	'application/vnd.mobius.txf',
		'txt'	=>	'text/plain',
		'u32'	=>	'application/x-authorware-bin',
		'udeb'	=>	'application/x-debian-package',
		'ufd'	=>	'application/vnd.ufdl',
		'ufdl'	=>	'application/vnd.ufdl',
		'uil'	=>	'text/x-uil',
		'ulx'	=>	'application/x-glulx',
		'umj'	=>	'application/vnd.umajin',
		'uni'	=>	'text/uri-list',
		'unis'	=>	'text/uri-list',
		'unityweb'	=>	'application/vnd.unity',
		'unv'	=>	'application/i-deas',
		'uoml'	=>	'application/vnd.uoml+xml',
		'uri'	=>	'text/uri-list',
		'uris'	=>	'text/uri-list',
		'urls'	=>	'text/uri-list',
		'ustar'	=>	array
			(
				'0'	=>	'application/x-ustar',
				'1'	=>	'multipart/x-ustar'
			),

		'utz'	=>	'application/vnd.uiq.theme',
		'uu'	=>	array
			(
				'0'	=>	'application/octet-stream',
				'1'	=>	'text/x-uuencode'
			),

		'uue'	=>	'text/x-uuencode',
		'uva'	=>	'audio/vnd.dece.audio',
		'uvd'	=>	'application/vnd.dece.data',
		'uvf'	=>	'application/vnd.dece.data',
		'uvg'	=>	'image/vnd.dece.graphic',
		'uvh'	=>	'video/vnd.dece.hd',
		'uvi'	=>	'image/vnd.dece.graphic',
		'uvm'	=>	'video/vnd.dece.mobile',
		'uvp'	=>	'video/vnd.dece.pd',
		'uvs'	=>	'video/vnd.dece.sd',
		'uvt'	=>	'application/vnd.dece.ttml+xml',
		'uvu'	=>	'video/vnd.uvvu.mp4',
		'uvv'	=>	'video/vnd.dece.video',
		'uvva'	=>	'audio/vnd.dece.audio',
		'uvvd'	=>	'application/vnd.dece.data',
		'uvvf'	=>	'application/vnd.dece.data',
		'uvvg'	=>	'image/vnd.dece.graphic',
		'uvvh'	=>	'video/vnd.dece.hd',
		'uvvi'	=>	'image/vnd.dece.graphic',
		'uvvm'	=>	'video/vnd.dece.mobile',
		'uvvp'	=>	'video/vnd.dece.pd',
		'uvvs'	=>	'video/vnd.dece.sd',
		'uvvt'	=>	'application/vnd.dece.ttml+xml',
		'uvvu'	=>	'video/vnd.uvvu.mp4',
		'uvvv'	=>	'video/vnd.dece.video',
		'uvvx'	=>	'application/vnd.dece.unspecified',
		'uvvz'	=>	'application/vnd.dece.zip',
		'uvx'	=>	'application/vnd.dece.unspecified',
		'uvz'	=>	'application/vnd.dece.zip',
		'vcard'	=>	'text/vcard',
		'vcd'	=>	'application/x-cdlink',
		'vcf'	=>	'text/x-vcard',
		'vcg'	=>	'application/vnd.groove-vcard',
		'vcs'	=>	'text/x-vcalendar',
		'vcx'	=>	'application/vnd.vcx',
		'vda'	=>	'application/vda',
		'vdo'	=>	'video/vdo',
		'vew'	=>	'application/groupwise',
		'vis'	=>	'application/vnd.visionary',
		'viv'	=>	array
			(
				'0'	=>	'video/vivo',
				'1'	=>	'video/vnd.vivo'
			),

		'vivo'	=>	array
			(
				'0'	=>	'video/vivo',
				'1'	=>	'video/vnd.vivo'
			),

		'vmd'	=>	'application/vocaltec-media-desc',
		'vmf'	=>	'application/vocaltec-media-file',
		'vob'	=>	'video/x-ms-vob',
		'voc'	=>	array
			(
				'0'	=>	'audio/voc',
				'1'	=>	'audio/x-voc'
			),

		'vor'	=>	'application/vnd.stardivision.writer',
		'vos'	=>	'video/vosaic',
		'vox'	=>	'audio/voxware',
		'vqe'	=>	'audio/x-twinvq-plugin',
		'vqf'	=>	'audio/x-twinvq',
		'vql'	=>	'audio/x-twinvq-plugin',
		'vrml'	=>	array
			(
				'0'	=>	'application/x-vrml',
				'1'	=>	'model/vrml',
				'2'	=>	'x-world/x-vrml'
			),

		'vrt'	=>	'x-world/x-vrt',
		'vsd'	=>	'application/x-visio',
		'vsf'	=>	'application/vnd.vsf',
		'vss'	=>	'application/vnd.visio',
		'vst'	=>	'application/x-visio',
		'vsw'	=>	'application/x-visio',
		'vtu'	=>	'model/vnd.vtu',
		'vxml'	=>	'application/voicexml+xml',
		'w3d'	=>	'application/x-director',
		'w60'	=>	'application/wordperfect6.0',
		'w61'	=>	'application/wordperfect6.1',
		'w6w'	=>	'application/msword',
		'wad'	=>	'application/x-doom',
		'wav'	=>	array
			(
				'0'	=>	'audio/wav',
				'1'	=>	'audio/x-wav'
			),

		'wax'	=>	'audio/x-ms-wax',
		'wb1'	=>	'application/x-qpro',
		'wbmp'	=>	'image/vnd.wap.wbmp',
		'wbs'	=>	'application/vnd.criticaltools.wbs+xml',
		'wbxml'	=>	'application/vnd.wap.wbxml',
		'wcm'	=>	'application/vnd.ms-works',
		'wdb'	=>	'application/vnd.ms-works',
		'wdp'	=>	'image/vnd.ms-photo',
		'web'	=>	'application/vnd.xara',
		'weba'	=>	'audio/webm',
		'webm'	=>	'video/webm',
		'webp'	=>	'image/webp',
		'wg'	=>	'application/vnd.pmi.widget',
		'wgt'	=>	'application/widget',
		'wiz'	=>	'application/msword',
		'wk1'	=>	'application/x-123',
		'wks'	=>	'application/vnd.ms-works',
		'wm'	=>	'video/x-ms-wm',
		'wma'	=>	'audio/x-ms-wma',
		'wmd'	=>	'application/x-ms-wmd',
		'wmf'	=>	'windows/metafile',
		'wml'	=>	'text/vnd.wap.wml',
		'wmlc'	=>	'application/vnd.wap.wmlc',
		'wmls'	=>	'text/vnd.wap.wmlscript',
		'wmlsc'	=>	'application/vnd.wap.wmlscriptc',
		'wmv'	=>	'video/x-ms-wmv',
		'wmx'	=>	'video/x-ms-wmx',
		'wmz'	=>	'application/x-msmetafile',
		'woff'	=>	'application/font-woff',
		'word'	=>	'application/msword',
		'wp'	=>	'application/wordperfect',
		'wp5'	=>	array
			(
				'0'	=>	'application/wordperfect',
				'1'	=>	'application/wordperfect6.0'
			),

		'wp6'	=>	'application/wordperfect',
		'wpd'	=>	array
			(
				'0'	=>	'application/wordperfect',
				'1'	=>	'application/x-wpwin'
			),

		'wpl'	=>	'application/vnd.ms-wpl',
		'wps'	=>	'application/vnd.ms-works',
		'wq1'	=>	'application/x-lotus',
		'wqd'	=>	'application/vnd.wqd',
		'wri'	=>	array
			(
				'0'	=>	'application/mswrite',
				'1'	=>	'application/x-wri'
			),

		'wrl'	=>	array
			(
				'0'	=>	'application/x-world',
				'1'	=>	'model/vrml',
				'2'	=>	'x-world/x-vrml'
			),

		'wrz'	=>	array
			(
				'0'	=>	'model/vrml',
				'1'	=>	'x-world/x-vrml'
			),

		'wsc'	=>	'text/scriplet',
		'wsdl'	=>	'application/wsdl+xml',
		'wspolicy'	=>	'application/wspolicy+xml',
		'wsrc'	=>	'application/x-wais-source',
		'wtb'	=>	'application/vnd.webturbo',
		'wtk'	=>	'application/x-wintalk',
		'wvx'	=>	'video/x-ms-wvx',
		'x-png'	=>	'image/png',
		'x32'	=>	'application/x-authorware-bin',
		'x3d'	=>	'model/x3d+xml',
		'x3db'	=>	'model/x3d+binary',
		'x3dbz'	=>	'model/x3d+binary',
		'x3dv'	=>	'model/x3d+vrml',
		'x3dvz'	=>	'model/x3d+vrml',
		'x3dz'	=>	'model/x3d+xml',
		'xaml'	=>	'application/xaml+xml',
		'xap'	=>	'application/x-silverlight-app',
		'xar'	=>	'application/vnd.xara',
		'xbap'	=>	'application/x-ms-xbap',
		'xbd'	=>	'application/vnd.fujixerox.docuworks.binder',
		'xbm'	=>	'image/xbm',
		'xdf'	=>	'application/xcap-diff+xml',
		'xdm'	=>	'application/vnd.syncml.dm+xml',
		'xdp'	=>	'application/vnd.adobe.xdp+xml',
		'xdr'	=>	'video/x-amt-demorun',
		'xdssc'	=>	'application/dssc+xml',
		'xdw'	=>	'application/vnd.fujixerox.docuworks',
		'xenc'	=>	'application/xenc+xml',
		'xer'	=>	'application/patch-ops-error+xml',
		'xfdf'	=>	'application/vnd.adobe.xfdf',
		'xfdl'	=>	'application/vnd.xfdl',
		'xgz'	=>	'xgl/drawing',
		'xht'	=>	'application/xhtml+xml',
		'xhtml'	=>	'application/xhtml+xml',
		'xhvml'	=>	'application/xv+xml',
		'xif'	=>	'image/vnd.xiff',
		'xl'	=>	'application/excel',
		'xla'	=>	array
			(
				'0'	=>	'application/excel',
				'1'	=>	'application/x-excel',
				'2'	=>	'application/x-msexcel'
			),

		'xlam'	=>	'application/vnd.ms-excel.addin.macroenabled.12',
		'xlb'	=>	array
			(
				'0'	=>	'application/excel',
				'1'	=>	'application/vnd.ms-excel',
				'2'	=>	'application/x-excel'
			),

		'xlc'	=>	array
			(
				'0'	=>	'application/excel',
				'1'	=>	'application/vnd.ms-excel',
				'2'	=>	'application/x-excel'
			),

		'xld'	=>	array
			(
				'0'	=>	'application/excel',
				'1'	=>	'application/x-excel'
			),

		'xlf'	=>	'application/x-xliff+xml',
		'xlk'	=>	array
			(
				'0'	=>	'application/excel',
				'1'	=>	'application/x-excel'
			),

		'xll'	=>	array
			(
				'0'	=>	'application/excel',
				'1'	=>	'application/vnd.ms-excel',
				'2'	=>	'application/x-excel'
			),

		'xlm'	=>	array
			(
				'0'	=>	'application/excel',
				'1'	=>	'application/vnd.ms-excel',
				'2'	=>	'application/x-excel'
			),

		'xls'	=>	array
			(
				'0'	=>	'application/excel',
				'1'	=>	'application/vnd.ms-excel',
				'2'	=>	'application/x-excel',
				'3'	=>	'application/x-msexcel'
			),

		'xlsb'	=>	'application/vnd.ms-excel.sheet.binary.macroenabled.12',
		'xlsm'	=>	'application/vnd.ms-excel.sheet.macroenabled.12',
		'xlsx'	=>	'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
		'xlt'	=>	array
			(
				'0'	=>	'application/excel',
				'1'	=>	'application/x-excel'
			),

		'xltm'	=>	'application/vnd.ms-excel.template.macroenabled.12',
		'xltx'	=>	'application/vnd.openxmlformats-officedocument.spreadsheetml.template',
		'xlv'	=>	array
			(
				'0'	=>	'application/excel',
				'1'	=>	'application/x-excel'
			),

		'xlw'	=>	array
			(
				'0'	=>	'application/excel',
				'1'	=>	'application/vnd.ms-excel',
				'2'	=>	'application/x-excel',
				'3'	=>	'application/x-msexcel'
			),

		'xm'	=>	'audio/xm',
		'xml'	=>	array
			(
				'0'	=>	'application/xml',
				'1'	=>	'text/xml'
			),

		'xmz'	=>	'xgl/movie',
		'xo'	=>	'application/vnd.olpc-sugar',
		'xop'	=>	'application/xop+xml',
		'xpi'	=>	'application/x-xpinstall',
		'xpix'	=>	'application/x-vnd.ls-xpix',
		'xpl'	=>	'application/xproc+xml',
		'xpm'	=>	array
			(
				'0'	=>	'image/x-xpixmap',
				'1'	=>	'image/xpm'
			),

		'xpr'	=>	'application/vnd.is-xpr',
		'xps'	=>	'application/vnd.ms-xpsdocument',
		'xpw'	=>	'application/vnd.intercon.formnet',
		'xpx'	=>	'application/vnd.intercon.formnet',
		'xsl'	=>	'application/xml',
		'xslt'	=>	'application/xslt+xml',
		'xsm'	=>	'application/vnd.syncml+xml',
		'xspf'	=>	'application/xspf+xml',
		'xsr'	=>	'video/x-amt-showrun',
		'xul'	=>	'application/vnd.mozilla.xul+xml',
		'xvm'	=>	'application/xv+xml',
		'xvml'	=>	'application/xv+xml',
		'xwd'	=>	'image/x-xwindowdump',
		'xyz'	=>	'chemical/x-pdb',
		'xz'	=>	'application/x-xz',
		'yang'	=>	'application/yang',
		'yin'	=>	'application/yin+xml',
		'z'	=>	array
			(
				'0'	=>	'application/x-compress',
				'1'	=>	'application/x-compressed'
			),

		'z1'	=>	'application/x-zmachine',
		'z2'	=>	'application/x-zmachine',
		'z3'	=>	'application/x-zmachine',
		'z4'	=>	'application/x-zmachine',
		'z5'	=>	'application/x-zmachine',
		'z6'	=>	'application/x-zmachine',
		'z7'	=>	'application/x-zmachine',
		'z8'	=>	'application/x-zmachine',
		'zaz'	=>	'application/vnd.zzazz.deck+xml',
		'zip'	=>	array
			(
				'0'	=>	'application/x-compressed',
				'1'	=>	'application/x-zip-compressed',
				'2'	=>	'application/zip',
				'3'	=>	'multipart/x-zip'
			),

		'zir'	=>	'application/vnd.zul',
		'zirz'	=>	'application/vnd.zul',
		'zmm'	=>	'application/vnd.handheld-entertainment+xml',
		'zoo'	=>	'application/octet-stream',
		'zsh'	=>	'text/x-script.zsh'
	);

	public static function getMimeFromExtension($ext, $format = 'string', $delimiter = ',') {
		$mime = false;
		if(array_key_exists(strtolower(str_replace('.', '', $ext)), self::$mime_types)){
			$mime = self::$mime_types[$ext];
			if($format == 'string' AND is_array($mime)){
				$mime = implode($delimiter, $mime);
			}
		}
		
		return $mime;
	}
	public static function getMimeFromExtensions($extentions, $format = 'string', $delimiter = ',') {
		$mimes = array();
		if (is_string($extentions)){
			$extentions = explode(',', $extentions);
		}
		foreach ($extentions as $ext){
			$mimes[] = self::getMimeFromExtension($ext, $format = 'string', $delimiter = ',');
		}
		if($format == 'string' AND is_array($mimes)){
			$mimes = implode($delimiter, $mimes);
		}
		return $mimes;
	}
	
	public static function reArrayFiles($file_post) {
	
		$file_ary = array();
		$file_count = count($file_post['name']);
		$file_keys = array_keys($file_post);
	
		for ($i=0; $i<$file_count; $i++) {
			foreach ($file_keys as $key) {
				$file_ary[$i][$key] = $file_post[$key][$i];
			}
		}
	
		return $file_ary;
	}

	public static function file_upload_error_message($error_code) {
		switch ($error_code) {
			case UPLOAD_ERR_INI_SIZE:
				return JText::_('FILEUPLOAD_ERROR_INI_SIZE'); // in php.ini
			case UPLOAD_ERR_FORM_SIZE:
				return JText::_('FILEUPLOAD_ERROR_FORM_SIZE'); // that was specified in the HTML form
			case UPLOAD_ERR_PARTIAL:
				return JText::_('FILEUPLOAD_ERROR_PARTIAL');
			case UPLOAD_ERR_NO_FILE:
				return JText::_('FILEUPLOAD_ERROR_NO_FILE');
			case UPLOAD_ERR_NO_TMP_DIR:
				return JText::_('FILEUPLOAD_ERROR_NO_TMP_DIR');
			case UPLOAD_ERR_CANT_WRITE:
				return JText::_('FILEUPLOAD_ERROR_CANT_WRITE');
			case UPLOAD_ERR_EXTENSION:
				return JText::_('FILEUPLOAD_ERROR_EXTENSION');
			default:
				return JText::_('Unknown upload error');
		}
	}
}
