<?php
/**
 * @package	 com_contactenhanced
 * @author	 Douglas Machado {@link http://idealextensions.com}
 * @author	 Created on 28-Jul-09
 * @license		GNU/GPL, see license.txt
 */

defined( '_JEXEC' ) or die( 'Restricted access' );
require_once JPATH_ROOT.'/components/com_contactenhanced/defines.php';
require_once JPATH_ROOT.'/components/com_contactenhanced/helpers/file.php';

/**
 *
 * helper class.
 *
 */
class ceHelper extends JObject {

	/**
	 * @var array	Array of database objectLists. One for each category
	 */
	public static $cf				= array();

	/**
	 * @var array	Array of customFields objects
	 */
	public static $submittedfields	= null;

	/**
	 * @var array	Array of customFields objects
	 */
	public static $contactModel	= null;
	

	/**
	 * @var array	Array of Fields labels
	 */
	public static $fieldLabels	= array();
	
	/**
	 * Determine if the request was over SSL (HTTPS).
	 * @return bool
	 */
	public static function httpIsSecure() {
		if (isset($_SERVER['HTTPS']) && !empty($_SERVER['HTTPS']) && (strtolower($_SERVER['HTTPS']) != 'off')) {
			return true;
		}
		else{
			return false;
		}
	}

	public static function loadJqueryUI(){
		JHtml::_('jquery.framework');
		$doc = JFactory::getDocument();

		$params = JComponentHelper::getParams('com_contactenhanced');
		if($params->get('load_jqueryUI',1)){
			// jQuery UI JS file was already load by another extension?
			foreach ($doc->_scripts as $key => $file) {
				// $doc->_scripts is a public variable. If problem arise check to see if it has not become private or protected.
				if(strpos($key, 'jquery-ui.min.js') AND !defined('JQUERY_UI_JS_LOADED')){
					define('JQUERY_UI_JS_LOADED',1);
					break;
				}
			}

			if (!defined('JQUERY_UI_JS_LOADED') 
				AND $params->get('load_jqueryUI') == 1
				AND is_readable(JPATH_ROOT.'/components/com_contactenhanced/assets/js/jquery-ui.min.js')
			){
				define('JQUERY_UI_JS_LOADED',1);
				$doc->addScript(JURI::root(true).'/components/com_contactenhanced/assets/js/jquery-ui.min.js');
			}elseif (!defined('JQUERY_UI_JS_LOADED') AND $params->get('load_jqueryUI','cloud') == 'cloud') {
				define('JQUERY_UI_JS_LOADED',1);
				$doc->addScript('//ajax.googleapis.com/ajax/libs/jqueryui/1/jquery-ui.min.js');
			}
		}
		if($params->get('load_jqueryUI_theme','smoothness')){
			// jQuery UI CSS file was already load by another extension?
			foreach ($doc->_styleSheets as $key => $file) {
				if(strpos($key, 'jquery-ui.min.css') AND !defined('JQUERY_UI_CSS_LOADED')){
					define('JQUERY_UI_CSS_LOADED',1);
					break;
				}
			}

			if (!defined('JQUERY_UI_CSS_LOADED') AND $params->get('load_jqueryUI') == 1) {
				define('JQUERY_UI_CSS_LOADED',1);
				if(is_readable(JPATH_ROOT.'/components/com_contactenhanced/assets/css/themes/'.$params->get('load_jqueryUI_theme','smoothness').'/jquery-ui.min.css')){
					$doc->addStylesheet(JURI::root(true).'/components/com_contactenhanced/assets/css/themes/'.$params->get('load_jqueryUI_theme','smoothness').'/jquery-ui.min.css');
				}elseif(is_readable(JPATH_ROOT.'/components/com_contactenhanced/assets/css/themes/smoothness/jquery-ui.min.css')){
					$doc->addStylesheet(JURI::root(true).'/components/com_contactenhanced/assets/css/themes/smoothness/jquery-ui.min.css');
				}else{
					$doc->addStylesheet('https://ajax.googleapis.com/ajax/libs/jqueryui/1.11.3/themes/'.$params->get('load_jqueryUI_theme','smoothness').'/jquery-ui.min.css');
				}
			}elseif (!defined('JQUERY_UI_CSS_LOADED') AND $params->get('load_jqueryUI','cloud') == 'cloud') {
				define('JQUERY_UI_CSS_LOADED',1);
				$doc->addStylesheet('https://ajax.googleapis.com/ajax/libs/jqueryui/1.11.3/themes/'.$params->get('load_jqueryUI_theme','smoothness').'/jquery-ui.min.css');
			}
		}
	}

	public static function loadJavascriptFiles() {
		if(!defined('CONTACT_ENHANCED_JS_LOADED')){
			define('CONTACT_ENHANCED_JS_LOADED',1);
			$doc = JFactory::getDocument();

			self::loadJqueryUI();

			// In case We have Ajax Contact, Ajax Recommend OR Ajax Attachment Mailer in the same page
			define('CE_SHARED_JQUERY_VALIDATION_SCRIPT_LOADED',1);
			$doc->addScript(JURI::root(true).'/components/com_contactenhanced/assets/js/jquery.validate.min.js');

			$params = JComponentHelper::getParams('com_contactenhanced');
			if($params->get('load_bootstrap')){
				// Bootstrap has to load last in order to avoid incompatibility with jQuery UI
				JHtml::_('bootstrap.framework');
				JHtml::_('bootstrap.loadCss');
			}
			
			if (is_readable(JPATH_SITE.'/components/com_contactenhanced/assets/css/custom.css')){
				$doc->addStyleSheet(JURI::root(true).'/components/com_contactenhanced/assets/css/custom.css');
			}
			if (is_readable(JPATH_SITE.'/components/com_contactenhanced/assets/js/custom.js')){
				$doc->addStyleSheet(JURI::root(true).'/components/com_contactenhanced/assets/js/custom.js');
			}
		}
	}

	public static function loadJavascript(&$script,&$obj, $suffix='') {

		$doc 	=JFactory::getDocument();
		$javascript = '';
		$rules 	= '';
		if(count($script['rules'])){
			$rules = "
	rules:{
		".implode(",\n\t", $script['rules'])."
	},";
		}
		$validation = "\n $('#ceForm{$obj->item->id}').validate({{$rules}
	submitHandler: function(form) {
		$('#ceForm{$obj->item->id} button[type=\"submit\"]').attr('disabled', 'disabled').html('".JText::_('COM_CONTACTENHANCED_SUBMITTING_FORM',true)."');
		form.submit();
	}
});";

		$javascript	= "
jQuery(document).ready(function($) {
	setTimeout(function(){var loadingImg=new Image();loadingImg.src = '".JURI::root()."components/com_contactenhanced/assets/images/loading-white.gif';},2000);
	$.validator.setDefaults({
		showTooltips: ".($obj->params->get('error_message_location') == 'tooltip' ? 'true' : 'false')."
	});
	$.extend($.validator.messages, {
		required:	'".JText::_('COM_CONTACTENHANCED_VALIDATION_ERROR_REQUIRED',true)."',
		remote:		'".JText::_('COM_CONTACTENHANCED_VALIDATION_ERROR_REMOTE',	true)."',
		email:		'".JText::_('COM_CONTACTENHANCED_VALIDATION_ERROR_EMAIL',	true)."',
		url:		'".JText::_('COM_CONTACTENHANCED_VALIDATION_ERROR_URL',		true)."',
		date:		'".JText::_('COM_CONTACTENHANCED_VALIDATION_ERROR_DATE',	true)."',
		dateISO:	'".JText::_('COM_CONTACTENHANCED_VALIDATION_ERROR_DATEISO',	true)."',
		number:		'".JText::_('COM_CONTACTENHANCED_VALIDATION_ERROR_NUMBER',	true)."',
		digits:		'".JText::_('COM_CONTACTENHANCED_VALIDATION_ERROR_DIGITS',	true)."',
		equalTo:	'".JText::_('COM_CONTACTENHANCED_VALIDATION_ERROR_EQUALTO',	true)."',
		maxlength:	$.validator.format('".JText::_('COM_CONTACTENHANCED_VALIDATION_ERROR_MAXLENGTH',	true)."'),
		minlength:	$.validator.format('".JText::_('COM_CONTACTENHANCED_VALIDATION_ERROR_MINLENGTH',	true)."'),
		rangelength:$.validator.format('".JText::_('COM_CONTACTENHANCED_VALIDATION_ERROR_RANGELENGTH',	true)."'),
		range:		$.validator.format('".JText::_('COM_CONTACTENHANCED_VALIDATION_ERROR_RANGE',		true)."'),
		max:		$.validator.format('".JText::_('COM_CONTACTENHANCED_VALIDATION_ERROR_MAX',			true)."'),
		min:		$.validator.format('".JText::_('COM_CONTACTENHANCED_VALIDATION_ERROR_MIN',			true)."')
	});

	var ceURI	= '".JURI::root()."';
	".$validation
	// PrepareCEForm function added to jquery.validate.js in order to save on request
	// if a new file was added
	."
	{$script['validation']}
	{$script['other']}
	$('#ceForm{$obj->item->id}').prepareCEForm({'tooltip':true});
});
";
		$doc->addScriptDeclaration( $javascript );
	}

	public static function loadForm(&$obj,$formType='component') {

		self::loadJavascriptFiles();

		$html	= '';
		$user		= JFactory::getUser();
		$suffix		= $obj->item->id .md5($user->get('id', 0).microtime());
		$document	= JFactory::getDocument();
		$app 		= JFactory::getApplication();
		$jinput 	= $app->input;

		if($obj->params->get('show_email_form') == 'modal' AND $jinput->getCmd('tmpl') != 'component'){
			$doc	= JFactory::getDocument();
			$selector = 'ce-modal-id-'.$obj->contact->id;
			$params = array();
			$params['title']  = JText::_('COM_CONTACTENHANCED_EMAIL_FORM');
			$params['height'] = $obj->params->get('window-size-height',480);
			$params['width']  = $obj->params->get('window-size-width',600);
			//$params['rel']  = 'nofollow';

			$params['url'] 	= JURI::root().('index.php?option=com_contactenhanced&amp;view=contact&amp;id='
					. $obj->contact->id.':'.$obj->contact->alias
					. '&amp;tmpl=component&loadModalForm=1'
			);

			$attributes	= array();
			$attributes['id']	= $selector."-button";
			$attributes['role']	= "button";
			$attributes['data-toggle']	= "modal";
			$attributes['data-target']	= $selector;
			$attributes['class']= $obj->params->get('modal_button_class', ' btn btn-default ') ;

			$html = array();
			$html[] = JHtml::_('link',$params['url'], JText::_('COM_CONTACTENHANCED_EMAIL_FORM'),$attributes );

			$html[] = JHtml::_('bootstrap.renderModal', $selector, $params);
			$doc->addScriptDeclaration("
					jQuery(document).ready(function(){
					jQuery('#{$selector}-button').on('click',function(){ jQuery('#{$selector}').modal('show'); });
			});"
			);
			$doc->addStyleDeclaration("#{$selector} .modal-body{overflow-y:hidden;padding:3px}#{$selector} iframe{border:0}");

			$html = '<div class="ce-form-modal-container" id="ce-modal-form">'
				. implode("\n",$html)
							.'</div>';
		}else{
			$obj->params->set('contactId',(int)$obj->item->id);
			$obj->params->set('suffix',$suffix);
			$obj->params->set('form_id',$obj->item->id);
			// Load Custom Fields
			$cf		= ceHelper::loadCustomFields($obj->customfields,$obj->params);
			ceHelper::loadJavascript($cf['script'],$obj,$suffix);

			$mitemid	= ($obj->params->get('set_itemid') ? '&itemid='.$obj->params->get('set_itemid') : '');

			$html	.= '<form  enctype="multipart/form-data"
						action="'
					.($obj->item->params->get(
							'integration-formaction-url'
							,JRoute::_( 'index.php?option=com_contactenhanced&view=contact&id='.$obj->item->id.$mitemid ) )
					).'"
						method="post"
						name="emailForm"
						id="ceForm'.$obj->item->id.'"
						class="form-validate ce-form">';
			$html	.= '<div class="contactenhanced_email'.$obj->params->get( 'pageclass_sfx' ).'" id="form">';
			$html	.= '<div class="requiredsign"><small>'.JText::sprintf('CE_FORM_REQUIRED_SIGN_LABEL','<span>'.JText::_('CE_FORM_REQUIRED_SIGN').'</span>').'</small></div>';
			// Load Custom Fields
			$html	.= $cf['html'];
			$html	.= ceHelper::getHoneypot();
			//$html	.= '<small id="requiredsign" >'.JText::sprintf('CE_FORM_REQUIRED_SIGN_LABEL',JText::_('CE_FORM_REQUIRED_SIGN')).'</small><br />';

			$html	.= '</div>';

			$html	.= '<input type="hidden" name="option" value="com_contactenhanced" />';
			$html	.= '<input type="hidden" name="task" value="contact.submit" />';
			if($obj->params->get('validate_session', 0)){
				$html	.= JHtml::_('form.token');
			}
			$html	.= '<input type="hidden" name="view" value="contact" />';
			$html	.= '<input type="hidden" name="id" value="'.$obj->item->id.'" />';
			$html	.= '<input type="hidden" name="category" value="'.$obj->item->catid.'" />';
			$html	.= '<input type="hidden" name="screen_resolution" value="" />';
			$html	.= '<input type="hidden" name="formType" value="'.$formType.'" />';

			$html	.= '<input type="hidden" name="reply_id" value="'.$jinput->getInt('reply').'" />';

			if(!empty($obj->return)  OR $obj->params->get('redirect') ){
				$html	.= '<input type="hidden" name="return" value="'.ceHelper::encode( trim( $obj->params->get('redirect',(isset($obj->return) ? $obj->return : null ))) , 'base64').'" />';
			}
			
			if($obj->params->get('after_submit')){
				$html	.= '<input type="hidden" name="after_submit" value="'.$obj->params->get('after_submit').'" />';
			}

			$html	.= '<input type="hidden" name="show_system_message" value="'.($obj->params->get('after_submit-javascript-show_system_message',1)).'" />';

			if(isset($_SERVER['HTTP_REFERER'])){
				$html	.= '<input type="hidden" name="referrer"  value="'.$_SERVER['HTTP_REFERER'].'" />';
			}

			// In case weare loading the author layout
			if(isset($obj->author->id)){
				$html	.= '<input type="hidden" name="author_id" value="'.$obj->author->id.'" />';
			}

			if(JRequest::getVar('encodedrecipient')){
				$html	.= '<input type="hidden" name="encodedrecipient" value="'.JRequest::getVar('encodedrecipient').'" />';
			}elseif($jinput->get('encodedauthor')){
				$session	= JFactory::getSession(); // Get the session
				$authorId = $session->get($jinput->get('encodedauthor'));
				$author = JFactory::getUser($authorId);
				$session->set($jinput->get('encodedauthor').'_email',$author->get('email'));
				$html	.= '<input type="hidden" name="encodedrecipient" value="'.$jinput->get('encodedauthor').'_email'.'" />';
			}

			if(JRequest::getVar('plugin_load_method')){
				$html	.= '<input type="hidden" name="plugin_load_method" value="'.JRequest::getVar('plugin_load_method').'" />';
			}

			// Get template var if set. It is usually "component"
			if(JRequest::getVar('tmpl')){
				$html	.= '<input type="hidden" name="tmpl" value="'.JRequest::getVar('tmpl').'" />';
			}
			if(JRequest::getVar('template')){
				$html	.= '<input type="hidden" name="template" value="'.JRequest::getVar('template').'" />';
			}

			// Used in all plugins
			if(ceHelper::getSavedSessionData('content_title',JRequest::getVar('content_title'))){
				$html	.= '<input type="hidden" name="content_title" 
						value="'.ceHelper::getSavedSessionData('content_title',(JRequest::getVar('content_title'))).'" />';
			}else{
				$html	.= '<input type="hidden" name="content_title" value="'.ceHelper::encode($document->getTitle(), 'base64').'" />';
			}
			if(ceHelper::getSavedSessionData('content_url',JRequest::getVar('content_url'))){
				$html	.= '<input type="hidden" name="content_url" 
						value="'.ceHelper::getSavedSessionData('content_url',(JRequest::getVar('content_url'))).'" />';
			}else{
				$html	.= '<input type="hidden" name="content_url" value="'.ceHelper::encode(JURI::current(), 'base64').'" />';
			}

			$ipBasedLocation	= "";
			// Load
			if($obj->params->get('showuserinfo',1) AND $obj->params->get('showuserinfo-ipBasedLocation')){
				require_once(JPATH_ROOT.'/components/com_contactenhanced/helpers/geoplugin.class.php');
				$geoplugin = new geoPlugin(self::getIP());
				//locate the IP
				$geoplugin->locate();
				if($geoplugin->city OR $geoplugin->region){
					$ipBasedLocation = "{$geoplugin->city}, {$geoplugin->region}, {$geoplugin->countryName}";
					$html	.= '<input type="hidden" name="ipBasedLocation" id="ipBasedLocation"
									value="'.$ipBasedLocation.'" />';
				}else{
					if( (!$obj->params->get('show_map',1)
							OR $obj->params->get('gmaps_display_type','inline') != 'inline'
					)
					){

						$http = 'http' . (ceHelper::httpIsSecure () ? 's://' : '://');
						//Please keep in this order
						$document->addScript($http.'google.com/jsapi');
					}

					$document->addScriptDeclaration('
jQuery(document).ready(function($) {
	var neighborhood= "";
	var ipLocation	= $("#ipBasedLocation");
	if(typeof(google) != "undefined" && google.loader.ClientLocation){
		if(google.loader.ClientLocation.address.neighborhood){
			var neighborhood	= google.loader.ClientLocation.address.neighborhood +", ";
		}
		if (google.loader.ClientLocation.address.region) {
			ipLocation.val(neighborhood + " " + google.loader.ClientLocation.address.city + ", "
				+ google.loader.ClientLocation.address.region.toUpperCase() + ", "
				+ google.loader.ClientLocation.address.country);
		}else{
			ipLocation.val( neighborhood + google.loader.ClientLocation.address.city + ", "
				+ google.loader.ClientLocation.address.country);
		}
	}else if(window.location.protocol != "https:"){
		jQuery.getScript("//www.geoplugin.net/javascript.gp", function()
		{
			ipLocation.val(geoplugin_city()
				+", "+geoplugin_region()
				+ ", " +geoplugin_countryName()
				);
		});
	}
});
');
				}
			}
			$html	.= '<input type="hidden" name="ipBasedLocation" id="ipBasedLocation" value="'.$ipBasedLocation.'" />';
			$html	.= '</form>';
		}
		return $html;
	}

	public static function loadCustomFields(&$customfields, $params, $isAdmin=false){
		require_once( JPATH_ROOT.'/components/com_contactenhanced/customFields.class.php' );
		$lang	= JFactory::getLanguage();
		$ret	= array('html'=>'','script'=>array('validation'=>'','rules' =>array(), 'other' =>''));

		// Multiple Pages variables
		$cfPerPage		= array();
		$pageInfo 		= array();
		$pageNumber		= 0;
		$cfPerPage[$pageNumber]	= '';

		//button
		$submitButton	= null;

		if(is_array($customfields)){
			$componentParams	= clone($params);
			foreach($customfields as $customfield){
				//@todo: I know I gotta do something cleverer here. This "if" is ugly
				if( ($isAdmin AND $customfield->type != 'multiplefiles')
					OR (!$isAdmin)
				){
					$field = "ceFieldType_".$customfield->type;
					$registry = new JRegistry;
					$registry->loadString($customfield->params);
					$customfield->params	=	&$registry;
					$customfield->params->set('isAdmin',$isAdmin);
					$customfield->params->set('form_id',$params->get('form_id'));
				//	$componentParams->merge($customfield->params);
				//	$customfield->params	= $componentParams;
					$cf = new $field($customfield, $customfield->params);
					// Sanity check for buttons

					if($customfield->type == 'button' AND $customfield->params->get('buttonType', 'submit') == 'submit' ){
						if(empty($submitButton)){ // Only the first submit button will be displayed
							$submitButton= $cf->getFieldHTML();
						}
					}elseif($customfield->type != 'pagination'){
						$cfPerPage[$pageNumber]	.= $cf->getFieldHTML();
						$ret['script']['validation'].=	$cf->getValidationScript();
						if(($rule = $cf->getValidationRule())){
							$ret['script']['rules'][]	=	$rule;
						}
					}else{ // is pagination custom field
						$pageNumber++;
						$pageInfo[$pageNumber] = $cf;
						$cfPerPage[$pageNumber] = '';
					}
				}
			}

			if($params->get( 'show_email_copy',1 ) == 1){
				$cfPerPage[$pageNumber]	.= '<div class="ce-contact-email-copy-container">';

					$cfPerPage[$pageNumber]	.= ' <label for="email_copy"> ';
					$cfPerPage[$pageNumber]	.= '<input type="checkbox" name="email_copy" id="email_copy" value="1" checked="checked" />';
						$cfPerPage[$pageNumber]	.= JText::_( 'CE_FORM_EMAIL_A_COPY' );
					$cfPerPage[$pageNumber]	.= '</label>';
				$cfPerPage[$pageNumber]	.= '</div>';
			}elseif($params->get( 'show_email_copy',1 ) == 2){
				$cfPerPage[$pageNumber]	.= '<input type="hidden" name="email_copy" id="email_copy" value="1"  />';
			}

			if (!class_exists('iDealCaptcha')) {
				require_once (JPATH_ROOT.'/components/com_contactenhanced/helpers/captcha.php');
			}
			$cfPerPage[$pageNumber]	.= iDealCaptcha::display($params,'com_contactenhanced');

			// Add Submit button
			if(!$submitButton){
				$registry = new JRegistry;
				// Add the buttons in case none were added by the user
				$button	= new ceFieldType_button(null, $registry); // use
				$submitButton	= $button->getFieldHTML();
			}
			$cfPerPage[$pageNumber]	.= $submitButton;

			self::getCustomFieldPagination($cfPerPage, $pageInfo, $ret, $params);

			$ret['html']	.= '<div class="ce-message-container"><div class="ce-message"
						id="ce-log'.$params->get('form_id').'" ></div></div>';

		}else{
			$ret['html'] .= '<h3>'.JText::_('COM_CONTACTENHANCED_NO_CUSTOMFIELD').'</h3>';
		}
		$ret['html']	= '<div id="ce-custom-fields-container" class="row-fluid row ce-flt'.($lang->isRTL() ? 'rtl' : 'ltr').'">'
							.$ret['html']
							. '</div>';
		return $ret;
	}

	protected static function getCustomFieldPagination(&$cfPerPage, &$pageInfo, &$ret, &$params){
		if(!class_exists('iBrowser')){
			require_once(JPATH_ROOT.'/components/com_contactenhanced/helpers/browser.php');
		}
		$browser = new iBrowser();

		if(count($pageInfo) == 0 AND count($cfPerPage)
			OR ($browser->getBrowser() == 'Android'
					AND version_compare($browser->getVersion(), '2.3.3') <= 0
				)
		){ // There's no pagination OR Do nothing for Android 2.3.3 and older
		 	$ret['html'] 	.= implode(' ',$cfPerPage);
		}
		else
		{
			$namespace = "ceForm{$params->get('form_id')}";

			$doc = JFactory::getDocument();
			$doc->addScript(JURI::root(true).'/components/com_contactenhanced/assets/js/jquery.ce.accordion.min.js');
			$doc->addScript(JURI::root(true).'/components/com_contactenhanced/assets/js/jquery.ui.progressbar.min.js');
			$doc->addScript(JURI::root(true).'/components/com_contactenhanced/assets/js/jquery.ce.formsteps.js');

			$config = $pageInfo[1]->params;
			$progressbar = "\n".'<div id="'.$namespace.'-progressbar" data-label="'.$config->get('pageProgressLabel').'"><div class="progress-label"></div></div>'."\n";
			if($config->get('pageProgress') == 'beforeform'){
				$ret['html'] .= $progressbar."<br /><br />";
			}

			$paginationId 	= $namespace.'-steps';
			$ret['html'] 	.= '<div id="'.$paginationId.'" class="ce-pagination">';
			$tmpPageInfo 	= array();
			foreach($pageInfo as $key => &$page){
				$pageId 	= "{$namespace}-page-$key";
				$ret['html'] 	.= '<h3 id="ce-page-'.$key.'">'.$page->getName().'</h3>';
				$ret['html'] 	.= '<div
										id="'.$pageId.'"
										data-next-label="'.$page->params->get('button_text', JText::_('COM_CONTACTENHANCED_PAGINATION_BUTTON_NEXT')).'">'
								 		.$cfPerPage[$key]
									.'</div>';
			}
			$ret['html'] 	.= '</div>';
			$ret['html']	.= '<div id="'.$namespace.'-steps-buttons" class="ceStepButtons">'
									.' <button id="'.$namespace.'-step-button-prev" type="button" class="inputbox button step-prev" style="display:none">'.JText::_('COM_CONTACTENHANCED_PAGINATION_BUTTON_BACK').'</button>'
									.' <button id="'.$namespace.'-step-button-next" type="button" class="inputbox button step-next">'.$config->get('button_text',JText::_('COM_CONTACTENHANCED_PAGINATION_BUTTON_NEXT')).'</button>'
								.'</div>';

			if($config->get('pageProgress') == 'afterform'){
				$ret['html'] .= "<br /><br />".$progressbar;
			}
			JText::script('COM_CONTACTENHANCED_PAGINATION_JS_STEP');
			JText::script('COM_CONTACTENHANCED_PAGINATION_JS_OF');
			$ret['script']['other'] 	.= '
$("#'.$paginationId.'").formsteps({
	namespace: "'.$namespace.'",
	count: 		'.count($pageInfo).',
	progressbar:'.($config->get('pageProgress') ? '"#'.$namespace.'-progressbar"' : 'null').',
	progressbarLabel:'.($config->get('pageProgressLabel') ? "'{$config->get('pageProgressLabel')}'" : 'false').',
});
';
			if(self::getSession('captcha_passed',0) === false){
				$ret['script']['other'] 	.= '$("#'.$paginationId.'").formsteps("goToPage",'.(count($pageInfo)-1).');';
			}
		}
	}

	public static function getSubmitedFields(&$customFields, &$pparams){
		$app	= JFactory::getApplication();
		$jinput	= $app->input;
		if(isset(ceHelper::$submittedfields)){
			return ceHelper::$submittedfields;
		}

		require_once( JPATH_ROOT.'/components/com_contactenhanced/customFields.class.php' );

		$fields = array();
		
		// $customFields is a database objectList
		foreach($customFields as $cf){
			$fieldClass		= "ceFieldType_".$cf->type;
			$registry = new JRegistry;
			$registry->loadString($cf->params);
			
			$cf->params		= $registry;
			$fieldObject	= new $fieldClass($cf, $cf->params);

			if($cf->type == "wysiwyg"){
				//If it is a wysiwyg field, then allow HTML
				$submittedField	= JRequest::getVar( $fieldObject->getInputName(), null, 'post', 'none',JREQUEST_ALLOWHTML );
				// Set email to HTML
				$pparams->set('emailOutputType', 'html');
			}elseif($cf->type == "checkbox"
					OR $cf->type == "numberrange"
					OR $cf->type == "mailchimp"
					OR $cf->type == "campaignmonitor"
					OR $cf->type == "constantcontact"
					OR $cf->type == "sql"
					OR $cf->type == "acymailing"
					OR $cf->type == "autocomplete"
			){
				$submittedField	= $jinput->post->get( $fieldObject->getInputName('submission'), '', 'array');

			}else{
				$submittedField	= $jinput->post->getString( $fieldObject->getInputName('submission'));
			}

			if(($submittedField)){
				if(is_array($submittedField) AND isset($submittedField['value'][0])){
					if(empty($submittedField['value'][0])){
						continue;
					}
				}

				if($cf->type == 'recipient'){
					if (!isset($fields['recipient'])){
						$fields['recipient']	= array();
					}
					if( (is_string($submittedField) AND !strpos($submittedField,'@'))
						OR (is_array($submittedField))
					){
						$fields['recipient'][]	= $fieldObject->getSelectedValue($submittedField);
					}
				}

				$fields[$cf->id]			= $fieldObject;
				$fields[$cf->id]->uservalue	= $submittedField;
			//	$cf->uservalue				= $submittedField;
				if($cf->type == 'text' OR $cf->type == 'multitext'){
					$fields[$cf->id]->uservalue	= stripslashes($fields[$cf->id]->uservalue);
				}elseif($cf->type == 'subject'){
					$fields['subject'] = &$fields[$cf->id];
					unset($fields[$cf->id]);
				}
			}elseif( $cf->type == 'multiplefiles'){
				$fields[$cf->id]			= $fieldObject;
			}
			if(!$fieldObject->validateField()){

				$errors	= self::getSession('errors', array());
				$errors[]	= $fieldObject->getInputName();
				self::setSession('errors', $errors, false);
			}

		}// END foreach

		ceHelper::$submittedfields	= $fields;
		return ceHelper::$submittedfields;
	}

	public static function getCustomFields($catid){
		if(isset(ceHelper::$cf[$catid])){
			return ceHelper::$cf[$catid];
		}
		require_once (CE_SITE_COMPONENT.'/models/customfields.php');
		$customFields = JModelLegacy::getInstance('Customfields', 'ContactenhancedModel', array('ignore_request' => true));

		ceHelper::$cf[$catid]	= $customFields->getItems($catid);
		ceHelper::$cf['last']	= ceHelper::$cf[$catid];
		return ceHelper::$cf[$catid];

	}
	/**
	 * Load the map
	 * @param object $obj Contact object
	 * @param  $params  this parameter has been deprecated
	 */
	public static function loadMap(&$obj, $params = null) {

		require_once(JPATH_ROOT .'/components/com_contactenhanced/helpers/gmaps.php');
		// Map object
		// using random number, so we can load more than one map per page if necessary
		if (empty($params)) {
			$params = new JRegistry();
		}
		$map_id = 'cegmaps_'.rand();
		$map	= new CEGMaps($map_id);
		$map->set('editMode', 			$params->get('gmaps_editMode', false));
		$map->set('useDirections',		$params->get('gmaps_useDirections','after_map'));
		$map->set('showCoordinates',	$params->get('gmaps_showCoordinates',true));
		$map->set('scrollwheelZoom',	$params->get('gmap_scrollWheel','true'));
		$map->set('mapTypeControl',		$params->get('gmap_mapTypeControl',1));
		$map->set('navigationControl',	$params->get('gmap_navigationControl','true'));
		$map->set('panControl',			$params->get('panControl','true'));
		$map->set('zoomControl',		$params->get('zoomControl','true'));
		$map->set('streetViewControl',	$params->get('streetViewControl','true'));
		$map->set('travelMode',			$params->get('gmaps_DirectionsTravelMode','DRIVING'));
		$map->set('showAvoidTolls',		$params->get('gmaps_showAvoidTolls',	true));
		$map->set('showAvoidHighways',	$params->get('gmaps_showAvoidHighways',	true));
		$map->set('infoWindowTrigger',	$params->get('gmap_infoWindowDisplay','click'));
		$map->set('linkToGoogleMaps',	$params->get('linkToGoogleMaps',true));
		$map->set('mapStyles',			$params->get('gmaps_custom_style','[]'));

		$map->set('scaleControl',		'true');
		$map->setHeight($params->get('gmaps_map_height',350));

		$map->setMapType($params->get('gmaps_MapTypeId','ROADMAP'));
		if($params->get('presentation_style') != 'plain'){
			JFactory::getDocument()->addScriptDeclaration("
jQuery(document).ready(function($){
	$('#ceTabTabs li').click( function(event){
		setTimeout(function(){ $('#{$map_id}').gmap('refresh')});
	});
});");
		}

		if (isset($obj->contact)) {
			$infoWindowContent 	= '';
			if($obj->params->get('gmaps_icon') != 'hide') {
				$infoWindowContent 	= $map->getInfoWindowContentFromContact($obj->contact, $params->get('gmap_infoWindowContent') );
			}
			$tags = $obj->contact->con_position;
			$map->addMarker(	$obj->contact->lat
							,	$obj->contact->lng
							,	'm_'.$obj->contact->id
							,	$infoWindowContent
							,	$obj->contact->name
							,	$tags
							,	($obj->params->get('gmaps_icon') ? JUri::root().''.$obj->params->get('gmaps_icon') : '')
							,	true
							, 	false
							,	$obj->contact->address.', '.$obj->contact->suburb.', '.$obj->contact->state.', '.$obj->contact->country.', '.$obj->contact->postcode
							);
			$map->set('zoomLevel',			$obj->contact->zoom);
			$map->set('mapTitle',			$obj->contact->name);

		}elseif (isset($obj->contacts)) {

		}
		return $map;
	}

	public static function getFormattedContactAddress(&$contact,&$pparams) {

		$microdataHTML = '';
		if(!empty($contact->address)
				OR !empty($contact->suburb)
				OR !empty($contact->state)
				OR !empty($contact->country)
				OR !empty($contact->postcode)
		){
			$userID		= JFactory::getUser()->id;
			jimport('joomla.microdata.microdata');
			$mdAddress = new JMicrodata('PostalAddress');
			$microdataHTML .= '<address  itemprop="address" '.$mdAddress->displayScope().'>';
			
			$addressFormat	= explode(',', $pparams->get('address_format','street_address,suburb,state,postcode,country'));
			$addressSchema	= array('street_address'	=> 'streetAddress'
					,'suburb'		=> 'addressLocality'
					,'state'		=> 'addressRegion'
					,'postcode'		=> 'postalCode'
					,'country'		=> 'addressCountry'
			);
			$contact->street_address= &$contact->address;
			foreach ($addressFormat as $key){
				if($contact->$key && ($pparams->get('show_'.$key,1) == 1 OR ($pparams->get('show_'.$key) == 'registered' AND $userID) ) ){
					$microdataHTML .= "\n\t".'<span class="contact-'.$key.'">'.$mdAddress->content(nl2br($contact->$key))->property($addressSchema[$key])->display('span').' </span>';
				}
			}
			$microdataHTML .= '</address>';
		}
		
		return $microdataHTML;
	}
	public static function loadDetails(&$obj) {
		$html		= '';
		$userID		= JFactory::getUser()->id;
		$model		= JModelLegacy::getInstance('Contact', 'ContactenhancedModel', array('ignore_request' => true));
		$model->setState('contact.id', $obj->contact->id);
		$model->setState('params', $obj->params);

		$fieldLabels= ceHelper::getFieldLabels($obj->params);
		
		if(!class_exists('iBrowser')){
			require_once(JPATH_ROOT.'/components/com_contactenhanced/helpers/browser.php');
		}
		$browser = new iBrowser();

		$model->displayParamters($obj->params,$obj->contact);

		if($obj->params->get('show_image') == 'before_details'){
			$html	.= '<div class="contact-image img-polaroid img-thumbnail">'.
						JHTML::_('image',$obj->contact->image, JText::_('COM_CONTACTENHANCED_IMAGE_DETAILS'), array('align' => 'middle')).'
					</div>';
		}

		$fieldLabels = ceHelper::getFieldLabels($obj->params);

		if (($obj->contact->department && $obj->params->get('show_department'))
			OR
			($obj->contact->con_position && $obj->params->get('show_position'))
		){
			$positionClass = '';
			$html	.= '<div class="contact-dept-position">';
			if($obj->contact->department && $obj->params->get('show_department',1)){
				$html	.= '<span 	itemprop="department" class="contact-department"
					title="'.$fieldLabels['department'].'">'.$obj->contact->department.'</span>';
					if($obj->contact->con_position && $obj->params->get('show_position',1)){
						$positionClass = 'ce-right-arrow';
					}
			}
			if($obj->contact->con_position && $obj->params->get('show_position',1)){
				$html	.= '<span 	itemprop="jobTitle" class="contact-position '.$positionClass.'"
					title="'.$fieldLabels['position'].'">'. $obj->contact->con_position.'</span>';
			}
			$html	.= '</div>';
		}

		if(	($obj->contact->address AND $obj->params->get('show_street_address',1) )
			|| ($obj->contact->suburb AND $obj->params->get('show_suburb',1))
			|| ($obj->contact->state AND $obj->params->get('show_state',1))
			|| ($obj->contact->country AND $obj->params->get('show_country',1))
			|| ($obj->contact->postcode AND $obj->params->get('show_postcode',1))
		) :
			$html	.= "\n".'<div class="contact-address">';
				$html .= '<span class="'. $obj->params->get('marker_class').'" >';
					 $html .= $obj->params->get('marker_address');
				$html .= '</span>';
				$html .= "\n".self::getFormattedContactAddress($obj->contact, $obj->params);
			$html .= "\n".'</div>';
		endif;

		 if($obj->params->get('show_email',1) || $obj->params->get('show_telephone',1)||$obj->params->get('show_fax',1)||$obj->params->get('show_mobile',1)|| $obj->params->get('show_webpage',1) ) :
			$html .= "\n".'<div class="contact-contactinfo">';
		 endif;
		 if($obj->contact->email_to && ($obj->params->get('show_email') == 1 OR ($obj->params->get('show_email') == 'registered' AND $userID))) :
			$html .= '<p>';
				$html .= '<span class="'.$obj->params->get('marker_class').'" >';
					 $html .= $obj->params->get('marker_email');
				$html .= '</span>';
				$html .= '<span class="contact-emailto">';
					if($obj->params->get('show_email') == 'link' AND !JPluginHelper::isEnabled('system','mailto2ce')) {
						$html .= JHtml::_('email.cloak', $obj->contact->email_to, true);
					}else{
						$html .= $obj->contact->email_to;
					}
				$html .= '</span>';
			$html .= '</p>';
		 endif;

		 if($obj->contact->telephone && $obj->params->get('show_telephone',1)) :
			$html .= '<p>';
				$html .= '<span class="'.$obj->params->get('marker_class').'" >';
					 $html .= $obj->params->get('marker_telephone');
				$html .= '</span>';
				$html .= '<span class="contact-telephone" itemprop="telephone">';

					$tel	= nl2br($obj->contact->telephone);

					if($browser->isMobile()){
						$telLink= 'tel:'.preg_replace('[(?!\+\b)\D]', '', $tel);
						$tel	= JHtml::_('link'
											,$telLink
											,$tel
											, array('title' => JText::sprintf('COM_CONTACTENHANCED_CALL_USING_YOUR_PHONE',$tel), 'itemprop'=>"telephone")
											);
					}
					$html .= ($tel);
				$html .= '</span>';
			$html .= '</p>';
		 endif;
		 if($obj->contact->fax && $obj->params->get('show_fax',1)) :
			$html .= '<p>';
				$html .= '<span class="'.$obj->params->get('marker_class').'" >';
					 $html .= $obj->params->get('marker_fax');
				$html .= '</span>';
				$html .= '<span class="contact-fax"  itemprop="faxNumber">';
				 $html .= nl2br($obj->contact->fax);
				$html .= '</span>';
			$html .= '</p>';
		 endif;
		 if($obj->contact->mobile && $obj->params->get('show_mobile',1)) :
			$html .= '<p>';
				$html .= '<span class="'.$obj->params->get('marker_class').'">';
					 $html .= $obj->params->get('marker_mobile');
				$html .= '</span>';
				$html .= '<span class="contact-mobile" itemprop="telephone">';
				$tel	= nl2br($obj->contact->mobile);
					if($browser->isMobile()){
						$telLink= 'tel:'.preg_replace('[(?!\+\b)\D]', '', $tel);
						$tel	= JHtml::_('link'
											,$telLink
											,$tel
											, array('title' => JText::sprintf('COM_CONTACTENHANCED_CALL_USING_YOUR_PHONE',$tel), 'itemprop'=>"telephone")
											);
					}
					$html .= ($tel);
				$html .= '</span>';
			$html .= '</p>';
		 endif;
		 if($obj->contact->skype && $obj->params->get('show_skype',1)) :
			$html .= '<p>';
				$html .= '<span class="'.$obj->params->get('marker_class').'" >';
					 $html .= $obj->params->get('marker_skype');
				$html .= '</span>';
				$html .= '<span class="contact-skype">
					<a href="skype:'.$obj->contact->skype.'?call"
						title="'.JText::_('COM_CONTACTENHANCED_SKYPE_MAKE_A_CALL').'"
						target="_blank" rel="nofollow">';
					 $html .= $obj->contact->skype.'</a>';
				$html .= '</span>';
			$html .= '</p>';
		 endif;

		 if($obj->contact->twitter && $obj->params->get('show_twitter',1)) :
			$html .= '<p>';
				$html .= '<span class="'.$obj->params->get('marker_class').'" >';
					 $html .= $obj->params->get('marker_twitter');
				$html .= '</span>';
				$html .= '<span class="contact-twitter">
					<a href="http://twitter.com/#!/'.$obj->contact->twitter.'"
						title="'.$fieldLabels['twitter'].'"
						target="_blank" rel="nofollow">@'.$obj->contact->twitter.'</a>';
				$html .= '</span>';
			$html .= '</p>';
		 endif;

		 if($obj->contact->facebook && $obj->params->get('show_facebook',1)) :
			$html .= '<p>';
				$html .= '<span class="'.$obj->params->get('marker_class').'" >';
					 $html .= $obj->params->get('marker_facebook');
				$html .= '</span>';
				$html .= '<span class="contact-facebook">
					<a href="'.(substr($obj->contact->facebook,0,4) == 'http'
										? $obj->contact->facebook
										: 'https://facebook.com/'.$obj->contact->facebook).' "
						title="'.$fieldLabels['facebook'].'"
						target="_blank" rel="nofollow">';
					 $html .= $obj->contact->facebook.'</a>';
				$html .= '</span>';
			$html .= '</p>';
		 endif;

		 if($obj->contact->linkedin && $obj->params->get('show_linkedin',1)) :
			$html .= '<p>';
				$html .= '<span class="'.$obj->params->get('marker_class').'" >';
					 $html .= $obj->params->get('marker_linkedin');
				$html .= '</span>';
				$html .= '<span class="contact-linkedin">';
				$html .= '<a href="'.(substr($obj->contact->linkedin,0,4) == 'http'
						? $obj->contact->linkedin
						: 'https://linkedin.com/in/'.$obj->contact->linkedin).'"
				title="'.$fieldLabels['linkedin'].'"
				target="_blank" rel="nofollow">'.$obj->contact->linkedin.'</a>';
				$html .= '</span>';
			$html .= '</p>';
		 endif;

		 if($obj->contact->webpage && $obj->params->get('show_webpage',1)) :
			$html .= '<p>';
				$html .= '<span class="'.$obj->params->get('marker_class').'" >';
					 $html .= $obj->params->get('marker_website');
				$html .= '</span>';
				$html .= '<span class="contact-webpage">';
					$html .= '<a href="'.$obj->contact->webpage.'" title="'.$obj->contact->webpage.'" target="_blank"  itemprop="url">';
					if($obj->params->get('show_webpage_headings') == 'trim'){
						 $html .=  ceHelper::trimURL(JStringPunycode::urlToUTF8($obj->contact->webpage));
					}elseif($obj->params->get('show_webpage_headings') == 'label'){
						 $html .=  $fieldLabels['webpage'];
					}else{
						$html .=  JStringPunycode::urlToUTF8($obj->contact->webpage);
					}
					$html .= ' </a>';
				$html .= '</span>';
			$html .= '</p>';
		 endif;
		 if($obj->params->get('show_email',1) || $obj->params->get('show_telephone',1)||$obj->params->get('show_fax',1)||$obj->params->get('show_mobile',1)|| $obj->params->get('show_webpage',1) ) :
			$html .= '</div>';
		 endif;

		 if($obj->contact->birthdate && $obj->params->get('show_birthdate',0)
		 		AND $obj->contact->birthdate != '0000-00-00'
		 		AND $obj->contact->birthdate != '1900-01-01') :
		 		jimport('joomla.utilities.date');
			 $date = new JDate(strtotime($obj->contact->birthdate));
			 if($obj->params->get('show_birthdate') == 1){
			 	$obj->params->set('show_birthdate','DATE_FORMAT_LC4');
			 }
			 $html .= '<div class="contact-birthday">';
			 $html .= '<span class="'.$obj->params->get('marker_class').'" >';
			 $html .= $obj->params->get('marker_birthdate');
			 $html .= '</span>';
			 $html .= '<span class="contact-birthdate"  itemprop="birthDate">';
			 $html .=  $date->format(JText::_($obj->params->get('show_birthdate','DATE_FORMAT_LC4')));
			 $html .= '</span>';
			 $html .= '</div>';
		 endif;

		if($obj->params->get('allow_vcard')){
			$html .= JText::_('COM_CONTACTENHANCED_DOWNLOAD_INFORMATION_AS');
	 		$html .= '	<a href="'.JURI::base().'index.php?option=com_contactenhanced&amp;view=contact&amp;id='.$obj->contact->id.'&amp;format=vcf">'
	 				.JText::_('COM_CONTACTENHANCED_VCARD').'</a>';
		}
		if($obj->params->get('show_image') == 'after_details'){
			$html	.= '<div class="contact-image img-polaroid img-thumbnail">'.
						JHTML::_('image',$obj->contact->image, JText::_('COM_CONTACTENHANCED_IMAGE_DETAILS'), array('align' => 'middle', 'itemprop'=>"image")).'
					</div>';
		}
		return $html;
	}

	public static function getFieldLabels(&$params){
		if(empty(self::$fieldLabels)){
			$fieldLabels	= array();
			$fieldLabels['name']		= JText::_($params->get('lang_override_name',		'COM_CONTACTENHANCED_CONTACT_EMAIL_NAME'));
			$fieldLabels['department']	= JText::_($params->get('lang_override_department',	'COM_CONTACTENHANCED_DEPARTMENT'));
			$fieldLabels['position']	= JText::_($params->get('lang_override_position',	'COM_CONTACTENHANCED_POSITION'));
			$fieldLabels['address']		= JText::_($params->get('lang_override_address',	'COM_CONTACTENHANCED_ADDRESS'));
			$fieldLabels['suburb']		= JText::_($params->get('lang_override_suburb',		'COM_CONTACTENHANCED_SUBURB'));
			$fieldLabels['state']		= JText::_($params->get('lang_override_state',		'COM_CONTACTENHANCED_STATE'));
			$fieldLabels['postcode']	= JText::_($params->get('lang_override_postcode',	'COM_CONTACTENHANCED_POSTCODE'));
			$fieldLabels['country']		= JText::_($params->get('lang_override_country',	'COM_CONTACTENHANCED_COUNTRY'));
			$fieldLabels['suburb']		= JText::_($params->get('lang_override_suburb',		'COM_CONTACTENHANCED_SUBURB'));
			$fieldLabels['email']		= JText::_($params->get('lang_override_email',		'JGLOBAL_EMAIL'));
			$fieldLabels['telephone']	= JText::_($params->get('lang_override_telephone',	'COM_CONTACTENHANCED_TELEPHONE'));
			$fieldLabels['fax']			= JText::_($params->get('lang_override_fax',		'COM_CONTACTENHANCED_FAX'));
			$fieldLabels['mobile']		= JText::_($params->get('lang_override_mobile',		'COM_CONTACTENHANCED_MOBILE'));
			$fieldLabels['skype']		= JText::_($params->get('lang_override_skype',		'COM_CONTACTENHANCED_SKYPE'));
			$fieldLabels['twitter']		= JText::_($params->get('lang_override_twitter',	'COM_CONTACTENHANCED_FIELD_INFORMATION_TWITTER_LABEL'));
			$fieldLabels['facebook']	= JText::_($params->get('lang_override_facebook',	'COM_CONTACTENHANCED_FIELD_INFORMATION_FACEBOOK_LABEL'));
			$fieldLabels['linkedin']	= JText::_($params->get('lang_override_linkedin',	'COM_CONTACTENHANCED_FIELD_INFORMATION_LINKEDIN_LABEL'));
			$fieldLabels['website']		= JText::_($params->get('lang_override_website',	'COM_CONTACTENHANCED_WEBSITE'));
			$fieldLabels['webpage']		= &$fieldLabels['website'];
			$fieldLabels['birthdate']	= JText::_($params->get('lang_override_birthdate',	'COM_CONTACTENHANCED_BIRTHDATE'));
			$fieldLabels['misc']		= JText::_($params->get('lang_override_misc',		'COM_CONTACTENHANCED_OTHER_INFORMATION'));
			
			for($i=1;$i<=10;$i++){
				$fieldLabels['extra_field_'.$i] = JText::_($params->get('lang_override_extrafield_'.$i,'COM_CONTACTENHANCED_FIELD_INFORMATION_EXTRA_FIELD_'.$i.'_LABEL'));
			}
			
			self::$fieldLabels = $fieldLabels;
		}
		
		
		return self::$fieldLabels; 
	}

	public static function timeDifference($date,$format = 'full')
	{
		if(empty($date)) {
			return JText::_("CE_TIME_NO_DATE_PROVIDED");
		}
		$firstDate = $date;
		$lang	= JFactory::getLanguage();
		$lang->load('com_contactenhanced',JPATH_ADMINISTRATOR.'/components/com_contactenhanced');
		$lang->load('com_contactenhanced',JPATH_ADMINISTRATOR);


		$date			=JFactory::getDate($date);
		$now			=JFactory::getDate();

		$periods_singular		= array(JText::_("CE_TIME_SECOND")
								, JText::_("CE_TIME_MINUTE")
								, JText::_("CE_TIME_HOUR")
								, JText::_("CE_TIME_DAY")
								, JText::_("CE_TIME_WEEK")
								, JText::_("CE_TIME_MONTH")
								, JText::_("CE_TIME_YEAR")
								, JText::_("CE_TIME_DECADE") );

		$periods_plural			= array(JText::_("CE_TIME_SECONDS")
								, JText::_("CE_TIME_MINUTES")
								, JText::_("CE_TIME_HOURS")
								, JText::_("CE_TIME_DAYS")
								, JText::_("CE_TIME_WEEKS")
								, JText::_("CE_TIME_MONTHS")
								, JText::_("CE_TIME_YEARS")
								, JText::_("CE_TIME_DECADES") );

		$lengths		= array("60","60","24","7","4.35","12","10");

		$now			= $now->toUnix();
		$unix_date		= $date->toUnix();

		   // check validity of date
		if(empty($unix_date)) {
			return JText::_("CE_TIME_BAD_DATE");
		}

		// is it future date or past date
		if($now > $unix_date) {
			$difference	= $now - $unix_date;
			$tense		= JText::_("CE_TIME_AGO");

		}else{
			$difference	= $unix_date - $now;
			$tense		= JText::_("CE_TIME_FROM_NOW");
		}

		for($j = 0; $difference >= $lengths[$j] && $j < count($lengths)-1; $j++) {
			$difference /= $lengths[$j];
		}

		$difference = round($difference);

		if($difference != 1) {
			$periods = $periods_plural[$j];
		}else{
			$periods = $periods_singular[$j];
		}

		if($format == 'full'){
			if($j<3){
				return JHtml::_('date', $firstDate, JText::_('CE_MSG_HOUR_FORMAT')) . " ($difference $periods {$tense})";
			}else{
				return $date->format(JText::_('CE_MSG_MONTH_DAY_FORMAT'))." ($difference $periods {$tense})";
			}

		}elseif($format == 'none'){
			//@todo: Add an option to show the difference in unix time format
		}else{
			return "$difference $periods {$tense}";
		}

	}

	public static function formatAttachmentList(&$attachmentsArray,$message_id){
		jimport('joomla.filesystem.file');

		$html 			= '';

		foreach($attachmentsArray as $attachments){
			$attachments	= explode('|',$attachments->value);
			foreach($attachments as $attachment){
				$html	.= ceHelper::formatAttachment($attachment,$message_id);
			}
		}

		return $html;
	}

	public static function formatAttachment($attachment,$message_id, $format="html"){
		jimport('joomla.filesystem.file');
		$viewableExt	= ceHelper::getViewableFileExtensions();
		$html	= '';
		$attachment	= trim($attachment);

		if(!file_exists(CE_UPLOADED_FILE_PATH.$message_id.'_'.$attachment)){
			$attachment	= ceHelper::removePrefix($attachment,$message_id.'_');
		}


		if(file_exists(CE_UPLOADED_FILE_PATH.$message_id.'_'.$attachment)){
			$link	= ceHelper::getAttachmentLink($message_id.'_'.$attachment,'download');

			if($format == 'html'){
				$filesize	= filesize(CE_UPLOADED_FILE_PATH.$message_id.'_'.$attachment);
				$fileExt	= strtolower(JFile::getExt($attachment));
				if(JFile::exists(CE_ICONSET_FOLDER_PATH.$fileExt.'.png')){
					$image = $fileExt.'.png';
				}else{
					$image = 'default.png';
				}
				$image	= JURI::root().'components/com_contactenhanced/assets/images/file_ext/'.$image;
				$html	.= '<table class="attachment-container" id="message-attachments-'.$message_id.'" width="99%">';
					$html	.= '<tr>';
					$html	.= '<td background="'.$image.'" width="32" height="32" rowspan="2"> </td>';
					$html	.= '<td style="font-weight:bolder;" class="">'.$attachment.'</td>';
					$html	.= '</tr>';
					$html	.= '<tr>';
					$html	.= '<td>';
						$html	.= ' <span class="attachment-filesize muted text-muted">'.ceHelper::formatBytes($filesize,0).'</span>';
						$html	.= ' <span class="attachment-download">'.JHTML::_('link',$link,JText::_('COM_CONTACTENHANCED_ATTACHMENT_DOWNLOAD')).'</span>';
						if(in_array($fileExt, $viewableExt)){
							$link	=  ceHelper::getAttachmentLink($message_id.'_'.$attachment,'view');
							$html	.= '<span class="attachment-view"  style="margin:0 5px 0 5px">'.JHTML::_('link',$link,JText::_('COM_CONTACTENHANCED_ATTACHMENT_VIEW'),' target="_blank" ').'</span>';
						}
					$html	.= '</td>';
					$html	.= '</tr>';

				$html	.= '</table>';
			}else{
				$html	.= "\n\t".$attachment.' < '.$link.' >';
			}
		}

		return $html;
	}

	public static function getAttachmentLink($filename,$task='download'){
		return JURI::root().'index.php?option=com_contactenhanced&task='.$task.'Attachment&file='.ceHelper::encode($filename);
	}

	public static function formatBytes($bytes, $precision = 2) {
		$units = array(	  'COM_CONTACTENHANCED_FILESIZE_ABBREVIATED_FORMAT_BYTE'
						, 'COM_CONTACTENHANCED_FILESIZE_ABBREVIATED_FORMAT_KILOBYTE'
						, 'COM_CONTACTENHANCED_FILESIZE_ABBREVIATED_FORMAT_MEGABYTE'
						, 'COM_CONTACTENHANCED_FILESIZE_ABBREVIATED_FORMAT_GIGABYTE'
						, 'COM_CONTACTENHANCED_FILESIZE_ABBREVIATED_FORMAT_TERABYTE');

		$bytes = max($bytes, 0);
		$pow = floor(($bytes ? log($bytes) : 0) / log(1024));
		$pow = min($pow, count($units) - 1);
		$bytes /= pow(1024, $pow);

		return round($bytes, $precision) . ' ' . JText::_($units[$pow]);
	}

	public static function getViewableFileExtensions(){
		$params = JComponentHelper::getParams('com_contactenhanced');

		// Get the other info about the attachment
		$viewableFileExtensions = $params->get('viewable_file_extensions', 'jpg,jpeg,gif,png,bmp,css,js,html,htm,xml,txt');
		return explode(',',$viewableFileExtensions);
	}
	/**
  	 * Provides an encoded string
 	 *
 	 * @param string Seed string
 	 * @return string
 	 */
	public static function encode( $string, $method= 'mcrypt' )
	{
		$secret = JFactory::getApplication()->getCfg('secret');
		$secret = JApplication::getHash($secret);
	
		if($method == 'mcrypt' AND function_exists('mcrypt_get_iv_size')){ //AND function_exists('mcrypt_get_iv_size')
			$secret = pack('H*', $secret);
			// create a random IV to use with CBC encoding
			$iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_CBC);
			$iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
			$string = mcrypt_encrypt(MCRYPT_RIJNDAEL_128, $secret, $string, MCRYPT_MODE_CBC, $iv);
			// prepend the IV for it to be available for decryption
			$string = $iv . $string;
			// encode the resulting cipher text so it can be represented by a string
		}else{
			$string = $secret.base64_encode( $string  );
		}
	
		return base64_encode($string);
	}
	
	public static function decode( $string, $method= 'mcrypt'  )
	{
		$secret = JFactory::getApplication()->getCfg('secret');
		$secret = JApplication::getHash($secret);
	
		// Joomla's JFactory::getApplication()->input->getBase64() function replaces + for a space
		// so we have to get the + sign back before decoding
		// We could use JFactory::getApplication()->input->getRaw() however we want the filtering in order to avoid XSS attacks
		$string = base64_decode(str_replace(' ', '+', $string));
		if($method == 'mcrypt' AND function_exists('mcrypt_get_iv_size')){ //AND function_exists('mcrypt_get_iv_size')
			$secret = pack('H*', $secret);
			$iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_CBC);
			# retrieves the IV, iv_size should be created using mcrypt_get_iv_size()
			$iv_dec = substr($string, 0, $iv_size);
			# retrieves the cipher text (everything except the $iv_size in the front)
			$string = substr($string, $iv_size);
			# may remove 00h valued characters from end of plain text
			$string = mcrypt_decrypt(MCRYPT_RIJNDAEL_128, $secret, $string, MCRYPT_MODE_CBC, $iv_dec);
		}else{
			$string	= self::removePrefix($string,$secret);
			$string = base64_decode( $string );
		}
		return trim($string);
	}
	
	public static function encode_OLD( $string )
	{
		$secret = JFactory::getApplication()->getCfg('secret');
		$secret = MD5($secret);
		$string = base64_encode($secret.base64_encode( $string  ));
		return $string;
	}
	
	public static function decode_OLD( $string )
	{
		$string = base64_decode( $string );
		$secret = JFactory::getApplication()->getCfg('secret');
		$secret = MD5($secret);
		$string	= ceHelper::removePrefix($string,$secret);
		return base64_decode( $string );
	}

	public static function removePrefix($string,$prefix){
		if(!is_numeric($prefix)){
			$prefix	= strlen($prefix);
		}
		return substr($string,$prefix );
	}

	public static function download($file, $download_mode='attachment')
	{
		jimport('joomla.filesystem.file');
		$filename_sys = CE_UPLOADED_FILE_PATH.$file;

		$filename = trim($file);
		//$download_mode = $params->get('download_mode', 'attachment');

		// Make sure the file exists
		if ( !JFile::exists($filename_sys) ) {
			 $errmsg = JText::_('ERROR FILE NOT FOUND ON SERVER') . " ($filename)";
			 JError::raiseError(500, $errmsg);
			 }
		$len = filesize($filename_sys);

		// Begin writing headers
		ob_clean(); // Clear any previously written headers in the output buffer
		header("Pragma: public");
		header('Cache-Control: no-store, no-cache, must-revalidate');
		header('Cache-Control: pre-check=0, post-check=0, max-age=0');
		header('Pragma: no-cache');
		header('Expires: 0');

		// Use the desired Content-Type
		$content_type = ceHelper::getMimeType(strtolower(JFile::getExt($file)));
		header("Content-Type: $content_type");

		if($download_mode != 'attachment' AND !in_array(strtolower(JFile::getExt($file)),ceHelper::getViewableFileExtensions()) ){
			$download_mode = 'attachment';
		}
		
		// Force the download
		header("Content-Disposition: $download_mode; filename=\"".ceHelper::removePrefix($filename,(strpos($filename,'_')+1))."\"");
		header("Content-Transfer-Encoding: binary");
		header("Content-Length: ".$len);

		@readfile($filename_sys);

		exit;
	}

	/**
	 * Mapping of file extensions to their expected mime-type
	 *
	 * This mapping does not claim to be exhaustive, but is a good listing for a large amount
	 * of file types.
	 *
	 * Last updated: 2006-08-31
	 *
	 * @link 	http://www.duke.edu/websrv/file-extensions.html
	 * @param	array	$mime_map	key = file extension, value = mime-type
	 */
	public static  function getMimeType($fileExtension){

		$mime_map = array(
			'ai'	=>	'application/postscript',
			'aif'	=>	'audio/x-aiff',
			'aifc'	=>	'audio/x-aiff',
			'aiff'	=>	'audio/x-aiff',
			'asc'	=>	'text/plain',
			'au'	=>	'audio/basic',
			'avi'	=>	'video/x-msvideo',
			'bcpio'	=>	'application/x-bcpio',
			'bin'	=>	'application/octet-stream',
			'c'		=>	'text/plain',
			'cc'	=>	'text/plain',
			'ccad'	=>	'application/clariscad',
			'cdf'	=>	'application/x-netcdf',
			'class'	=>	'application/octet-stream',
			'cpio'	=>	'application/x-cpio',
			'cpt'	=>	'application/mac-compactpro',
			'csh'	=>	'application/x-csh',
			'css'	=>	'text/css',
			'dcr'	=>	'application/x-director',
			'dir'	=>	'application/x-director',
			'dms'	=>	'application/octet-stream',
			'doc'	=>	'application/msword',
			'drw'	=>	'application/drafting',
			'dvi'	=>	'application/x-dvi',
			'dwg'	=>	'application/acad',
			'dxf'	=>	'application/dxf',
			'dxr'	=>	'application/x-director',
			'eps'	=>	'application/postscript',
			'etx'	=>	'text/x-setext',
			'exe'	=>	'application/octet-stream',
			'ez'	=>	'application/andrew-inset',
			'f'		=>	'text/plain',
			'f90'	=>	'text/plain',
			'fli'	=>	'video/x-fli',
			'gif'	=>	'image/gif',
			'gtar'	=>	'application/x-gtar',
			'gz'	=>	'application/x-gzip',
			'h'		=>	'text/plain',
			'hdf'	=>	'application/x-hdf',
			'hh'	=>	'text/plain',
			'hqx'	=>	'application/mac-binhex40',
			'htm'	=>	'text/html',
			'html'	=>	'text/html',
			'ice'	=>	'x-conference/x-cooltalk',
			'ief'	=>	'image/ief',
			'iges'	=>	'model/iges',
			'igs'	=>	'model/iges',
			'ips'	=>	'application/x-ipscript',
			'ipx'	=>	'application/x-ipix',
			'jpe'	=>	'image/jpeg',
			'jpeg'	=>	'image/jpeg',
			'jpg'	=>	'image/jpeg',
			'js'	=>	'application/x-javascript',
			'kar'	=>	'audio/midi',
			'latex'	=>	'application/x-latex',
			'lha'	=>	'application/octet-stream',
			'lsp'	=>	'application/x-lisp',
			'lzh'	=>	'application/octet-stream',
			'm'		=>	'text/plain',
			'man'	=>	'application/x-troff-man',
			'me'	=>	'application/x-troff-me',
			'mesh'	=>	'model/mesh',
			'mid'	=>	'audio/midi',
			'midi'	=>	'audio/midi',
			'mif'	=>	'application/vnd.mif',
			'mime'	=>	'www/mime',
			'mov'	=>	'video/quicktime',
			'movie'	=>	'video/x-sgi-movie',
			'mp2'	=>	'audio/mpeg',
			'mp3'	=>	'audio/mpeg',
			'mpe'	=>	'video/mpeg',
			'mpeg'	=>	'video/mpeg',
			'mpg'	=>	'video/mpeg',
			'mpga'	=>	'audio/mpeg',
			'ms'	=>	'application/x-troff-ms',
			'msh'	=>	'model/mesh',
			'nc'	=>	'application/x-netcdf',
			'oda'	=>	'application/oda',
			'pbm'	=>	'image/x-portable-bitmap',
			'pdb'	=>	'chemical/x-pdb',
			'pdf'	=>	'application/pdf',
			'pgm'	=>	'image/x-portable-graymap',
			'pgn'	=>	'application/x-chess-pgn',
			'php'	=>	'text/plain',
			'php3'	=>	'text/plain',
			'png'	=>	'image/png',
			'pnm'	=>	'image/x-portable-anymap',
			'pot'	=>	'application/mspowerpoint',
			'ppm'	=>	'image/x-portable-pixmap',
			'pps'	=>	'application/mspowerpoint',
			'ppt'	=>	'application/mspowerpoint',
			'ppz'	=>	'application/mspowerpoint',
			'pre'	=>	'application/x-freelance',
			'prt'	=>	'application/pro_eng',
			'ps'	=>	'application/postscript',
			'qt'	=>	'video/quicktime',
			'ra'	=>	'audio/x-realaudio',
			'ram'	=>	'audio/x-pn-realaudio',
			'ras'	=>	'image/cmu-raster',
			'rgb'	=>	'image/x-rgb',
			'rm'	=>	'audio/x-pn-realaudio',
			'roff'	=>	'application/x-troff',
			'rpm'	=>	'audio/x-pn-realaudio-plugin',
			'rtf'	=>	'text/rtf',
			'rtx'	=>	'text/richtext',
			'scm'	=>	'application/x-lotusscreencam',
			'set'	=>	'application/set',
			'sgm'	=>	'text/sgml',
			'sgml'	=>	'text/sgml',
			'sh'	=>	'application/x-sh',
			'shar'	=>	'application/x-shar',
			'silo'	=>	'model/mesh',
			'sit'	=>	'application/x-stuffit',
			'skd'	=>	'application/x-koan',
			'skm'	=>	'application/x-koan',
			'skp'	=>	'application/x-koan',
			'skt'	=>	'application/x-koan',
			'smi'	=>	'application/smil',
			'smil'	=>	'application/smil',
			'snd'	=>	'audio/basic',
			'sol'	=>	'application/solids',
			'spl'	=>	'application/x-futuresplash',
			'src'	=>	'application/x-wais-source',
			'step'	=>	'application/STEP',
			'stl'	=>	'application/SLA',
			'stp'	=>	'application/STEP',
			'sv4cpio'	=>	'application/x-sv4cpio',
			'sv4crc'	=>	'application/x-sv4crc',
			'swf'	=>	'application/x-shockwave-flash',
			't'		=>	'application/x-troff',
			'tar'	=>	'application/x-tar',
			'tcl'	=>	'application/x-tcl',
			'tex'	=>	'application/x-tex',
			'texi'	=>	'application/x-texinfo',
			'texinfo'	=>	'application/x-texinfo',
			'tif'	=>	'image/tiff',
			'tiff'	=>	'image/tiff',
			'tr'	=>	'application/x-troff',
			'tsi'	=>	'audio/TSP-audio',
			'tsp'	=>	'application/dsptype',
			'tsv'	=>	'text/tab-separated-values',
			'txt'	=>	'text/plain',
			'unv'	=>	'application/i-deas',
			'ustar'	=>	'application/x-ustar',
			'vcd'	=>	'application/x-cdlink',
			'vda'	=>	'application/vda',
			'viv'	=>	'video/vnd.vivo',
			'vivo'	=>	'video/vnd.vivo',
			'vrml'	=>	'model/vrml',
			'wav'	=>	'audio/x-wav',
			'wrl'	=>	'model/vrml',
			'xbm'	=>	'image/x-xbitmap',
			'xlc'	=>	'application/vnd.ms-excel',
			'xll'	=>	'application/vnd.ms-excel',
			'xlm'	=>	'application/vnd.ms-excel',
			'xls'	=>	'application/vnd.ms-excel',
			'xlw'	=>	'application/vnd.ms-excel',
			'xml'	=>	'text/xml',
			'xpm'	=>	'image/x-xpixmap',
			'xwd'	=>	'image/x-xwindowdump',
			'xyz'	=>	'chemical/x-pdb',
			'zip'	=>	'application/zip'
		);

		if(array_key_exists($fileExtension,$mime_map)){
			return $mime_map[$fileExtension];
		}else{
			return 'application/octet-stream';
		}
	}

	public static function objectToArray($obj, $recursive=true) {
		$_arr = is_object($obj) ? get_object_vars($obj) : $obj;
		foreach ($_arr as $key => $val) {
			$val = (is_array($val) OR is_object($val) AND $recursive) ? ceHelper::objectToArray($val) : $val;
			$arr[$key] = $val;
		}
		return $_arr;
	}
	/**
	 * replace tags from
	 */
	public static function replaceTags($content, $object,$prefix='', $startTag='{', $endTag='}', $ignore = array()){
		foreach(get_object_vars($object) as $key => $value){

			if(is_array($value)){
				continue;
			}
			if(is_object($value)){
				if($key!='contact') continue;
				$content = ceHelper::replaceTags($content,$value, $key.'_');
			}elseif(!in_array($key, $ignore)){
				$content = str_ireplace( $startTag.$prefix.$key.$endTag, $value, $content );
			}
		}
		return $content;
	}

	public static function getLastURL(){
		$html	= '';
		if(JRequest::getVar( 'content_title',false,		'post' )){
			$html.= '<div class="last-visited-page">';
			$html.= "\n\n<h4>".JText::_('CE_USER_INFO_LAST_PAGE').'</h4>';
			$html.= "\n\t<div><label>".JText::_('CE_USER_INFO_PAGE_TITLE').":</label>\t". 	ceHelper::decode(JRequest::getVar( 'content_title'),'base64').'</span></div>' ;
			$html.= "\n\t<div><label>".JText::_('CE_USER_INFO_PAGE_URL').":</label>\t". 	ceHelper::decode(JRequest::getVar( 'content_url',$_SERVER['HTTP_REFERER'],'post' ),'base64').'</span></div>' ;
			$html.= '</div>';
		}
		return $html;
	}

	public static function getSystemInfo($param){
		$content_title	= JRequest::getVar( 'content_title',false,		'post' ); // This input is in CE plugin
		$session 		=JFactory::getSession();
		$ceSession		= $session->get('com_contactenhanced');
		if(!class_exists('iBrowser')){
			require_once(JPATH_ROOT.'/components/com_contactenhanced/helpers/browser.php');
		}
		$browser = new iBrowser();

		$suffix	= '';
		$suffix.= '<div class="userinfo">';
		$suffix.= "\n\n<h4>".JText::_('CE_USER_INFO').'</h4>';
		$suffix.= "\n\t<div><label>".JText::_('CE_USER_INFO_IP_ADDRESS').":</label>\t<span>". self::getIP().'</span></div>';
		if(JRequest::getVar( 'ipBasedLocation', false, 'post')){
			$suffix.= "\n\t<div><label>".JText::_('CE_USER_INFO_BROWSER_LOCATION').":</label>\t	<span>". JRequest::getVar( 'ipBasedLocation','','post') .'</span></div>';
		}
		$suffix.= "\n\t<div><label>".JText::_('CE_USER_INFO_BROWSER').":</label>\t<span>". $browser->getBrowser().' '.$browser->getVersion().'</span></div>';
		$suffix.= "\n\t<div><label>".JText::_('CE_USER_INFO_OPERATING_SYSTEM').":</label>\t<span>". $browser->getPlatform().'</span></div>';
		$suffix.= "\n\t<div><label>".JText::_('CE_USER_INFO_SCREEN_RESOLUTION').":</label>\t	<span>". JRequest::getVar( 'screen_resolution','','post') .'</span></div>';

		$suffix.= '</div>';

		if($content_title){
			$suffix.= CEHelper::getLastURL();
		}

		if( (is_array($ceSession) AND isset($ceSession['isekeywords'])) ){ //AND $param->get('useUserTracker',0)
			$suffix.= '<div class="user-tracker">';
			$suffix.= "\n\n<h4>".JText::_('CE_USER_INFO_PAGE_REFERER')."</h4>";

			$suffix.= "\n"
						."\t<div><label>". JText::_('CE_USER_INFO_PAGE_REFERER_WEBSITE')."</label>\t => \t <span>".$ceSession['isekeywords']['referer'].'</span></div>';
			if($ceSession['isekeywords']['queryString']){
				$suffix.= "\n\t<div><label>". JText::_('CE_USER_INFO_PAGE_REFERER_KEYWORDS')."</label>\t => \t <span>".$ceSession['isekeywords']['queryString'].'</span></div>' ;
			}
		}

		//Get Referer from getReferer Plugin

		if( ($sitetracker = $session->get( 'sitetracker', null )) ){ //AND $param->get('useUserTracker',0)
			$suffix.= '<div class="user-tracker">';
			$suffix.= "\n\n<h4>".JText::_('Page Referers')."</h4>";
			foreach($sitetracker as $stKey => $stValue){
				$suffix.= "\n<br />".$stKey
						.":\n\t<div><label>". JText::_('Referer')."</label>\t => \t <span>".$stValue['referer'].'</span></div>'
						.":\n\t<div><label>". JText::_('Landing Page')	."</label>\t => \t <span>".$stValue['landingPage'].'</span></div>' ;
			}
			$suffix.= '</div>';
		}
		return $suffix;
	}

	public static function array2string($myarray,&$output,&$parentkey){
		foreach($myarray as $key=>$value){
			if (is_array($value)) {
				$parentkey .= $key."^";
				ceHelper::array2string($value,$output,$parentkey);
				$parentkey = "";
			}else if(is_object($value)){
				$value	= ceHelper::objectToArray($value);
				ceHelper::array2string($value,$output,$parentkey);
			}else{
			   $output .= $parentkey.$key."^".$value."\n";
			}
		}
   }

	public static function implodeRecursive($glue, $pieces){
		$return = "";

		if(!is_array($glue)){
			$glue = array($glue);
		}

		$thisLevelGlue = array_shift($glue);

		if(!count($glue)) $glue = array($thisLevelGlue);

		if(!is_array($pieces)){
			return (string) $pieces;
		}

		foreach($pieces as $sub){
			$return .= ceHelper::implodeRecursive($glue, $sub) . $thisLevelGlue;
		}

		if(count($pieces)) $return = substr($return, 0, strlen($return) -strlen($thisLevelGlue));

		return $return;
	}

	public static function getCurrentURL() {
		$uri = JFactory::getURI();
		return JURI::current().'?'.$uri->getQuery().$uri->getFragment();
	}

	public static function processContentPlugin(&$param,&$item) {

		// Simulate an article
		$article				= new stdClass();
		$article->id			=	 '';
		$article->asset_id		=	 '';
		$article->title			=	 '';
		$article->alias			=	 '';
		$article->title_alias	=	 '';
		$article->introtext		=	 '';
		$article->fulltext		=	 '';
		$article->state			=	 '';
		$article->mask			=	 '';
		$article->catid			=	 '';
		$article->created		=	 '';
		$article->created_by	=	 0;
		$article->created_by_alias	=	 '';
		$article->modified		=	 '';
		$article->modified_by	=	 0;
		$article->checked_out	=	 '';
		$article->checked_out_time	=	 '';
		$article->publish_up	=	 '';
		$article->publish_down	=	 '';
		$article->images		=	 '';
		$article->urls			=	 '';
		$article->attribs	=	 '';
		$article->version	=	 '';
		$article->parentid	=	 '';
		$article->ordering	=	 '';
		$article->metakey	=	 '';
		$article->metadesc	=	 '';
		$article->access	=	 '';
		$article->hits		=	 0;
		$article->metadata	=	 '';
		$article->xreference=	 '';
		$article->featured	=	 '';
		$article->language	=	 '';
		$article->author	=	 '';
		$article->usertype	=	 '';
		$article->category	=	 '';
		$article->section	=	 '';
		$article->slug		=	 '';
		$article->catslug	=	 '';
		$article->groups	=	 '';
		$article->sec_pub	=	 '';
		$article->cat_pub	=	 '';
		$article->sec_access	=	 '';
		$article->cat_access	=	 '';
		$article->rating_count	=	 '';
		$article->rating	=	 '';
		$article->text		=	 '';

		// Merge two objects
		$article = (object) array_merge((array) $article, (array) $item);

		/*
		 * Process the prepare content plugins
		 */
		JPluginHelper::importPlugin('content');
		$dispatcher	= JDispatcher::getInstance();
		$results = $dispatcher->trigger('onContentPrepare', array ('com_content.article', &$article, &$params, 0));
		$item	= $article;
	}

	/**
	 * Method to check whether the email provided is valid or not
	 */
	public static function checkEmail($email, $botScoutAPIKey=false){
		jimport('joomla.mail.helper');
		$action = 'success';
		$msg	= JText::sprintf('COM_CONTACTENHANCED_EMAIL_IS_VALID',$email);

		if(JMailHelper::isEmailAddress($email)){
			// Split the email into a local and domain
			$domain	= substr($email, strrpos($email, "@")+1);
			$app	= JFactory::getApplication();
			$input	= $app->input;

			if(!ceHelper::validateEmail($email, $botScoutAPIKey)) {
				$action	= 'error';
				$msg	= JText::sprintf('COM_CONTACTENHANCED_EMAIL_INCORRECT_DOMAIN',$domain);
			}elseif ($input->getBool('registration')){
				$db =JFactory::getDBO();
				$query	= $db->getQuery(true);
				$query->select('id');
				$query->from('#__users');
				$query->where("email=".$db->Quote($email));

				$db->setQuery($query);
				if($db->loadResult()){
					$action = 'error';
					$msg	= JText::sprintf('COM_CONTACTENHANCED_EMAIL_IS_ALREADY_IN_USE',$email);
				}
			}
		}else{
			$action = 'error';
			$msg	= JText::sprintf('COM_CONTACTENHANCED_EMAIL_IS_NOT_VALID',$email);
		}

		return array('action'=> $action, 'msg' => $msg );
	}

	/**
	 * Verifies that the string is in a proper email address format.
	 *
	 * @static
	 * @param	string|array	$email	String to be verified.
	 * @return	boolean	True if string has the correct format; false otherwise.
	 * @since	1.6
	 */
	public static function isEmailAddress($email) {
		if (is_array($email)) {
			foreach ($email as $e){
				if(!ceHelper::validateEmail($e)){
					return false;
				}
			}
			return true;
		}elseif(strstr($email,',')){
			$email	= explode(',', $email);
			foreach ($email as $e){
				if(!ceHelper::validateEmail($e)){
					return false;
				}
			}
			return true;
		}else{
			return ceHelper::validateEmail($email);
		}
	}

	/**
	 * Validate an email address.
	 * @param string Provide email address (raw input)
	 * @returns true if the email address has the email	address format and the domain exists.
	 * @author Douglas Lowell <http://www.linuxjournal.com/article/9585?page=0,3>
	*/
	public static function validateEmail($email, $botScoutAPIKey=false)
	{
		$params	= JComponentHelper::getParams( 'com_contactenhanced' );
		$isValid = true;
		$email	= trim($email);
		$atIndex = strrpos($email, "@");
		if (is_bool($atIndex) && !$atIndex)
		{
			$isValid = false;
		}
		else
		{
			$domain = substr($email, $atIndex+1);
			$local = substr($email, 0, $atIndex);
			$localLen = strlen($local);
			$domainLen = strlen($domain);
			if($localLen < 1 || $localLen > 64)
			{
			  // local part length exceeded
			  $isValid = false;
			}
			else if($domainLen < 1 || $domainLen > 255)
			{
			  // domain part length exceeded
			  $isValid = false;
			}
			else if($local[0] == '.' || $local[$localLen-1] == '.')
			{
			  // local part starts or ends with '.'
			  $isValid = false;
			}
			else if (preg_match('/\\.\\./', $local))
			{
			  // local part has two consecutive dots
			  $isValid = false;
			}
			else if (!preg_match('/^[A-Za-z0-9\\-\\.]+$/', $domain))
			{
			  // character not valid in domain part
			  $isValid = false;
			}
			else if (preg_match('/\\.\\./', $domain))
			{
			  // domain part has two consecutive dots
			  $isValid = false;
			}
			else if(!preg_match('/^(\\\\.|[A-Za-z0-9!#%&`_=\\/$\'*+?^{}|~.-])+$/',
					  str_replace("\\\\","",$local)))
			{
			  // character not valid in local part unless
			  // local part is quoted
			  if (!preg_match('/^"(\\\\"|[^"])+"$/',
				  str_replace("\\\\","",$local)))
			  {
				 $isValid = false;
			  }
			}
			if (!defined('PHP_VERSION_ID')) {
				$version = explode('.', PHP_VERSION);
				define('PHP_VERSION_ID', ($version[0] * 10000 + $version[1] * 100 + $version[2]));
			}
			if($isValid AND $params->get('email_dns_check') AND (strtoupper(substr(PHP_OS, 0, 3)) !== 'WIN' OR PHP_VERSION_ID >50300 ) ){
				if(!(checkdnsrr($domain,"MX") || checkdnsrr($domain,"A")))
				{
				  // domain not found in DNS
				  $isValid = false;
				}
			}
			if($isValid AND $botScoutAPIKey){ // If it is not valid, doesn't need to test with BotScout yet.
				require_once (JPATH_COMPONENT.'/helpers/botscout.php');
				$botscout = new ceBotscout($botScoutAPIKey);
				if(!$botscout->getInfo($email)){
					return false;
				}
			}
		}
		return $isValid;
	}

/**
	 * Configure the Linkbar.
	 *
	 * @param	string	The name of the active view.
	 */
	public static function addSubmenu($vName)
	{

		JSubMenuHelper::addEntry(
			JText::_('COM_CONTACTENHANCED_SUBMENU_MESSAGES'),
			'index.php?option=com_contactenhanced&view=messages',
			$vName == 'messages'
		);
		JSubMenuHelper::addEntry(
			JText::_('COM_CONTACTENHANCED_SUBMENU_CUSTOMFIELDS'),
			'index.php?option=com_contactenhanced&view=customfields',
			$vName == 'customfields'
		);
		JSubMenuHelper::addEntry(
			JText::_('COM_CONTACTENHANCED_SUBMENU_CONTACTS'),
			'index.php?option=com_contactenhanced&view=contacts',
			$vName == 'contacts'
		);
		JSubMenuHelper::addEntry(
			JText::_('COM_CONTACTENHANCED_SUBMENU_TEMPLATES'),
			'index.php?option=com_contactenhanced&view=templates',
			$vName == 'templates'
		);
		JSubMenuHelper::addEntry(
			JText::_('COM_CONTACTENHANCED_SUBMENU_CUSTOMVALUES'),
			'index.php?option=com_contactenhanced&view=customvalues',
			$vName == 'customvalues'
		);
		JSubMenuHelper::addEntry(
			JText::_('COM_CONTACTENHANCED_SUBMENU_CATEGORIES'),
			'index.php?option=com_categories&extension=com_contactenhanced',
			$vName == 'categories'
		);

		$canDo	= CEHelper::getActions();
		if($canDo->get('core.admin')) {
			JSubMenuHelper::addEntry(
				JText::_('CE_TITLE_TOOLS'),
				'index.php?option=com_contactenhanced&view=tools',
				$vName == 'tools'
			);
		}

		if($vName=='categories') {
			JToolBarHelper::title(
				JText::sprintf('COM_CATEGORIES_CATEGORIES_TITLE',JText::_('com_contactenhanced')),
				'contact-categories');
		}
	}
	/**
	 * Gets a list of the actions that can be performed.
	 *
	 * @param	int		The category ID.
	 * @param	int		The article ID.
	 *
	 * @return	JObject
	 */
	public static function getActions($categoryId = 0, $contactId = 0)
	{
		$user	= JFactory::getUser();
		$result	= new JObject;

		if (empty($contactId) && empty($categoryId)) {
			$assetName = 'com_contactenhanced';
		}
		else if (empty($contactId)) {
			$assetName = 'com_contactenhanced.category.'.(int) $categoryId;
		}
		else{
			$assetName = 'com_contactenhanced.contact.'.(int) $contactId;
		}

		$actions = array(
			'core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.state', 'core.edit.own', 'core.delete'
		);

		foreach ($actions as $action) {
			$result->set($action,	$user->authorise($action, $assetName));
		}

		return $result;
	}

	/**
	 * Adds a title to the <title> tag
	 * @param string $title
	 */
	public static function addTitle($title){
		$document	= JFactory::getDocument();
		$document->setTitle($title.' - '.$document->getTitle());
	}

	/**
	 * print_r()
	 * Does a var_export of the array and returns it between <pre> tags
	 *
	 * @param mixed $var any input you can think of
	 * @return string HTML
	 */
	public static function print_r($var, $exit= false)
	{
		$input =var_export($var,true);
		$input = preg_replace("! => \n\W+ array \(!Uims", " => Array ( ", $input);
		$input = preg_replace("!array \(\W+\),!Uims", "Array ( ),", $input);

		$input = ("<pre>".str_replace('><?', '>', highlight_string('<'.'?'.$input, true))."</pre>");
		if($exit){
			echo $input; exit;
		}else{
			return $input;
		}
	}
	/**
	 * Displays a hidden token field to reduce the risk of CSRF exploits
	 *
	 * Use in conjuction with JRequest::checkToken
	 *
	 * @static
	 * @return	void
	 * @since	1.5
	 */
	public static function getHoneypot()
	{
		$token	= ceHelper::getToken(false,'honeypot');
		return '<div class="cf_token">
					<input type="text" name="cf_'.$token.'" value="" 			tabindex="999999" />
					<input type="text" name="cf_check"		value="'.$token.'" 	tabindex="999998"  />
				</div>'
				;
	}

	/**
	 * Get a session token, if a token isn't set yet one will be generated.
	 *
	 * Tokens are used to secure forms from spamming attacks. Once a token
	 * has been generated the system will check the post request to see if
	 * it is present, if not it will invalidate the session.
	 *
	 * @param	boolean  If true, force a new token to be created
	 * @return  string	The session token
	 */
	public static function getToken($forceNew = false, $varName='ceToken')
	{
		$session = JFactory::getSession();
		$token = $session->get('session.'.$varName);

		//create a token
		if($token === null || $forceNew) {
			$token	=	JApplication::getHash(ceHelper::generateToken());
			$session->set('session.'.$varName, $token);
		}

		return $token;
	}

	/**
	 * Method to determine if a token exists in the session.
	 *
	 * @param  string	Hashed token to be verified
	 * @param  boolean  If true, expires the session
	 * @since  1.5
	 */
	public static function checkHoneypot()
	{
		$session = JFactory::getSession();

		// check if a token exists in the session
		$token = $session->get('session.honeypot');

		//clear session
		$session->set('session.honneypot','');
		//check token
		if (JRequest::getVar('cf_'.$token) != '' || JRequest::getVar('cf_check') != $token) {

			//Caught Spammer, return false
			return false;
		}
		return true;
	}

	public static function generateToken($length=6,$level=2){

		list($usec, $sec) = explode(' ', microtime());
		srand((float) $sec + ((float) $usec * 100000));
		$validchars		= array();
		$validchars[1]	= "0123456789abcdfghjkmnpqrstvwxyz";
		$validchars[2]	= "0123456789abcdfghjkmnpqrstvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		$validchars[3]	= "0123456789_!@#$%&*()-=+/abcdfghjkmnpqrstvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ{}[]<>";

		$token  = "";
		$counter	= 0;

		while ($counter < $length) {
			$actChar = substr($validchars[$level], rand(0, strlen($validchars[$level])-1), 1);
			// All character must be different
			if (!strstr($token, $actChar)) {
				$token .= $actChar;
				$counter++;
			}
		}

		return $token;
	}
	/**
	 * based on http://www.php.net/manual/en/function.fsockopen.php#101872
	 * fsockopen-based HTTP request function (GET and POST)
	 * @param string $verb			HTTP Request Method (GET and POST supported)
	 * @param string $ip			Target IP/Hostname
	 * @param int	$port			Target TCP port
	 * @param string $uri			Target URI
	 * @param array	$getdata		HTTP GET Data ie. array('var1' => 'val1', 'var2' => 'val2')
	 * @param array	$postdata		HTTP POST Data ie. array('var1' => 'val1', 'var2' => 'val2')
	 * @param array	$cookie			HTTP Cookie Data ie. array('var1' => 'val1', 'var2' => 'val2')
	 * @param array	$custom_headers	Custom HTTP headers ie. array('Referer: http://localhost/
	 * @param int	$timeout		Socket timeout in milliseconds
	 * @param bool	$req_hdr		Include HTTP request headers
	 * @param bool	$res_hdr		Include HTTP response headers
	 */
	public static function http_request(
								$verb = 'GET',
								$ip,
								$port = 80,
								$uri = '/',
								$getdata	= array(),
								$postdata	= array(),
								$cookie		= array(),
								$custom_headers = array(),
								$timeout = 300,
								$req_hdr = false,
								$res_hdr = false
								)
	{
		$url = parse_url($ip);

		$ret = '';
		$verb = strtoupper($verb);
		$cookie_str = '';
		$getdata_str = count($getdata) ? '?' : '';
		$postdata_str = '';

		foreach ($getdata as $k => $v)
					$getdata_str .= urlencode($k) .'='. urlencode($v) . '&';

		foreach ($postdata as $k => $v)
			$postdata_str .= urlencode($k) .'='. urlencode($v) .'&';

		foreach ($cookie as $k => $v)
			$cookie_str .= urlencode($k) .'='. urlencode($v) .'; ';

		$crlf = "\r\n";
		$req = $verb .' '. $uri . $getdata_str .' HTTP/1.1' . $crlf;
		$req .= 'Host: '. $url['host'] . $crlf;
		$req .= 'User-Agent: Mozilla/5.0 Firefox/3.6.12' . $crlf;
		$req .= 'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8' . $crlf;
		$req .= 'Accept-Language: en-us,en;q=0.5' . $crlf;
		$req .= 'Accept-Encoding: deflate' . $crlf;
		$req .= 'Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7' . $crlf;
		$req .= 'Connection: keep-alive' . $crlf;

		foreach ($custom_headers as $k => $v)
			$req .= $k .': '. $v . $crlf;

		if (!empty($cookie_str))
			$req .= 'Cookie: '. substr($cookie_str, 0, -2) . $crlf;

		if($verb == 'POST' && !empty($postdata_str))
		{
			$postdata_str = substr($postdata_str, 0, -1);
			$req .= 'Content-Type: application/x-www-form-urlencoded' . $crlf;
			$req .= 'Content-Length: '. strlen($postdata_str) . $crlf . $crlf;
			$req .= $postdata_str;
		}
		else $req .= $crlf;

		if($req_hdr)
			$ret .= $req;

		if (($fp = @fsockopen($url['host'], $port, $errno, $errstr)) == false)
			return "Error $errno: $errstr\n";

		stream_set_timeout($fp, 0, $timeout * 1000);

		fputs($fp, $req);
		//while ($line = fgets($fp,2048)) $ret .= $line;
		while (!feof($fp))
		{
			$ret .= fgets ($fp,2048);
		}
		fclose($fp);
		if (!$res_hdr)
			$ret = substr($ret, strpos($ret, "\r\n\r\n") + 4);

		if($ret==''){
			return true;
		}
		return $ret;
	}

	public static function trimURL($url,$size=40) {
		$parts	= parse_url($url);
		$newURL	= '';
		if(is_array($parts)){
			if (!empty($parts['host'])) {
				$newURL	.= $parts['host'];
			}
			if (!empty($parts['path'])) {
				$newURL	.= ''.$parts['path'];
			}
			if (!empty($parts['query'])) {
				$newURL	.= '?'.$parts['query'];
			}
			if (!empty($parts['fragment'])) {
				$newURL	.= '#'.$parts['fragment'];
			}
			if (strlen($newURL) > $size) {
				$newURL	= substr($newURL, 0, ($size-3)).'...';
			}
			return $newURL;
		}else{
			return $url;
		}
	}
	/**
	 * Converts a multi-dimensional array to an object. This is accomplished through recursion.
	 * @param array $array
	 */
	public static function arrayToObject($array) {
		if(!is_array($array)) {
			return $array;
		}

		$object = new stdClass();
		if (is_array($array) && count($array) > 0) {
		  foreach ($array as $name=>$value) {
			 $name = strtolower(trim($name));
			 if (!empty($name)) {
				$object->$name = ceHelper::arrayToObject($value);
			 }
		  }
		  return $object;
		}
		else{
		  return FALSE;
		}
	}

	public static function setSession($var, $value=null) {
		$session 	=JFactory::getSession();
	//	$session->set('com_contactenhanced', null);
		$ce_session	= $session->get('com_contactenhanced');

		if(!is_array($ce_session)){
			$ce_session	= array();
		}
		$ce_session[$var]	= $value;
		$session->set('com_contactenhanced',$ce_session);
	}
	
	
	public static function getSession($var, $default=null) {
		$session 	=JFactory::getSession();
		$ce_session	= $session->get('com_contactenhanced');
		return (isset($ce_session[$var]) ? $ce_session[$var] : $default);
	}

	public static function getContactDetails($ceObj=null,$return='json'){

		$app = JFactory::getApplication();
		$contactId		= JRequest::getVar('contactId');
		$action			= 'success';

		if(!$ceObj){
			$ceObj			= new JObject();
			$ceObj->params	= $app->getParams('com_contactenhanced');

			$model			= JModelLegacy::getInstance('Contact', 'ContactenhancedModel', array('ignore_request' => true));
			$model->setState('contact.id', $contactId);
			$model->setState('params', $ceObj->params);
			$ceObj->contact	= $model->getItem( $contactId );
			$ceObj->item	= &$ceObj->contact;
		}
		$ceObj->user	= JFactory::getUser();


		if(!is_object($ceObj->contact)){
			$text	= JText::sprintf('COM_CONTACTENHANCED_ERROR_CONTACT_NOT_FOUND',$contactId);
			$action	= 'failed';
		}else{
			$menuItem	= $app->getMenu()->getActive();

			if(is_object($menuItem)){
				$ceObj->params->merge($menuItem->params);

				$ceObj->params->set('show_name',		$ceObj->params->get('show_name_headings',1));
				$ceObj->params->set('show_image',		$ceObj->params->get('show_image_headings','before_details'));
				$ceObj->params->set('show_email',		$ceObj->params->get('show_email_headings',0));
				$ceObj->params->set('show_department',	$ceObj->params->get('show_department_headings'));
				$ceObj->params->set('show_position',	$ceObj->params->get('show_position_headings'));
				$ceObj->params->set('show_telephone',	$ceObj->params->get('show_telephone_headings'));
				$ceObj->params->set('show_mobile',		$ceObj->params->get('show_mobile_headings'));
				$ceObj->params->set('show_fax',			$ceObj->params->get('show_fax_headings'));
				$ceObj->params->set('show_suburb',		$ceObj->params->get('show_suburb_headings'));
				$ceObj->params->set('show_state',		$ceObj->params->get('show_state_headings'));
				$ceObj->params->set('show_country',		$ceObj->params->get('show_country_headings'));
				$ceObj->params->set('show_skype',		$ceObj->params->get('show_skype_headings'));
				$ceObj->params->set('show_twitter',		$ceObj->params->get('show_twitter_headings'));
				$ceObj->params->set('show_facebook',	$ceObj->params->get('show_facebook_headings'));
				$ceObj->params->set('show_linkedin',	$ceObj->params->get('show_linkedin_headings'));
				$ceObj->params->set('show_webpage',		$ceObj->params->get('show_webpage_headings'));
				$ceObj->params->set('show_misc',		$ceObj->params->get('show_misc_headings'));
				$ceObj->params->set('show_street_address',$ceObj->params->get('show_street_address_headings'));
				$ceObj->params->set('show_postcode',	$ceObj->params->get('show_postcode_headings'));
				$ceObj->params->set('allow_vcard',		$ceObj->params->get('allow_vcard_headings'));

			}

			if (!$ceObj->contact->image){
				$ceObj->contact->image	= 'components/com_contactenhanced/assets/images/no-contact-image.png';
			}
			$text = '';
			if($ceObj->params->get('show_name_heading') == 'show_with_link' AND $ceObj->contact->link){
				echo '<h5  itemprop="name">'.JHtml::_('link',$ceObj->contact->link,$ceObj->contact->name,'title="'.$ceObj->contact->name.'"').'</h5>';
			}else if($ceObj->params->get('show_name_heading')){
				echo '<h5  itemprop="name">'.$ceObj->contact->name.'</h5>';
			}

			$text	.= ceHelper::loadDetails($ceObj);


			if($ceObj->params->get('show_misc') AND  $ceObj->contact->misc){
				$text	.= '<span class="contact-misc" >'.$ceObj->contact->misc.'</span>';
			}

			if($ceObj->params->get('show_extrafield_1_headings') AND  $ceObj->contact->extra_field_1){
				$text	.= '<span class="contact-extrafield-1" >'.$ceObj->contact->extra_field_1.'</span>';
			}
			if($ceObj->params->get('show_extrafield_2_headings') AND  $ceObj->contact->extra_field_2){
				$text	.= '<span class="contact-extrafield-2" >'.$ceObj->contact->extra_field_2.'</span>';
			}
			if($ceObj->params->get('show_extrafield_3_headings') AND  $ceObj->contact->extra_field_3){
				$text	.= '<span class="contact-extrafield-3" >'.$ceObj->contact->extra_field_3.'</span>';
			}
			if($ceObj->params->get('show_extrafield_4_headings') AND  $ceObj->contact->extra_field_4){
				$text	.= '<span class="contact-extrafield-4" >'.$ceObj->contact->extra_field_4.'</span>';
			}
			if($ceObj->params->get('show_extrafield_5_headings') AND  $ceObj->contact->extra_field_5){
				$text	.= '<span class="contact-extrafield-5" >'.$ceObj->contact->extra_field_5.'</span>';
			}
			if($ceObj->params->get('show_extrafield_6_headings') AND  $ceObj->contact->extra_field_6){
				$text	.= '<span class="contact-extrafield-6" >'.$ceObj->contact->extra_field_6.'</span>';
			}
			if($ceObj->params->get('show_extrafield_7_headings') AND  $ceObj->contact->extra_field_7){
				$text	.= '<span class="contact-extrafield-7" >'.$ceObj->contact->extra_field_7.'</span>';
			}
			if($ceObj->params->get('show_extrafield_8_headings') AND  $ceObj->contact->extra_field_8){
				$text	.= '<span class="contact-extrafield-8" >'.$ceObj->contact->extra_field_8.'</span>';
			}
			if($ceObj->params->get('show_extrafield_9_headings') AND  $ceObj->contact->extra_field_9){
				$text	.= '<span class="contact-extrafield-9" >'.$ceObj->contact->extra_field_9.'</span>';
			}
			if($ceObj->params->get('show_extrafield_10_headings') AND  $ceObj->contact->extra_field_10){
				$text	.= '<span class="contact-extrafield-10" >'.$ceObj->contact->extra_field_10.'</span>';
			}
			$links	= "";

			if($ceObj->params->get('show_readmore')){
				require_once (JPATH_COMPONENT.'/helpers/route.php');
				$links	.= ' <a class="btn btn-block  btn-default btn-icon ce-contact-readmore" href="'.JRoute::_(ContactenchancedHelperRoute::getContactRoute($ceObj->contact->slug, $ceObj->contact->catid)).'">'
							.'<span>'.JText::sprintf($ceObj->params->get('alternative_readmore','COM_CONTACTENHANCED_READMORE_ABOUT'),$ceObj->contact->name).'</span>
									<i class="fa fa-long-arrow-right glyphicon glyphicon-arrow-right icon-arrow-right"></i></a>';
			}

			foreach(range('a', 'e') as $char){ // letters 'a' to 'e'
				$link = $ceObj->contact->params->get('link'.$char);
				$label = $ceObj->contact->params->get('link'.$char.'_name');

				if(!$link OR $ceObj->params->get('link'.$char)) :
					continue;
				endif;

				// Add 'http://' if not present
				$link = (0 === strpos($link, 'http')) ? $link : 'http://'.$link;

				// If no label is present, take the link
				$label = ($label) ? $label : $link;
				$links	.= ' <a class="ce-contact-link'.$char.'" href="'.$link.'"><span>'.$label.'</span></a>';
			}
			if($links) {
				$text	.=	'<div class="contact-links">'.$links.'</div>';
			}
		}


		if($return!='json'){
			return $text;
		}else{
			$json	=array('action'=> $action, 'text' => $text );
			return $json;
		}

	}

	public static function getSavedSessionData($name, $default = null) {
		$session 	=JFactory::getSession();
		$data_session	= $session->get('com_contactenhanced');
		if(isset($data_session['fieldValues'])){
			$data_session	= $data_session['fieldValues'];
			if (isset($data_session[$name])) {
				return $data_session[$name];
			}
		}
		return $default;
	}

	/**
	 * Merge two objects into one
	 *
	 * @param   Object  &$source  		Source object to merge.
	 * @param   Object  &$destinaton  	Destination object to merge.
	 *
	 * @return  boolean  True on success
	 *
	 * @since   11.1
	 */
	public static function mergeObjects(&$source,&$destinaton, $override=false)
	{
		if ( (is_object($source) OR is_array($source)) AND is_object($destinaton))
		{
			$source	= (array)$source;
			// Load the variables into the registry's default namespace.
			foreach ($source as $k => $v)
			{
				if (($v !== null) && ($v !== '') AND (strpos($k, "\0") === false) )
				{
					if($override OR (!isset($destinaton->$k) OR $destinaton->$k != '' ) ){
						$destinaton->$k = $v;
					}
				}
			}
			return true;
		}
		return false;
	}

	public static function getIP(){
		$ip = '';
		if( !empty($_SERVER['HTTP_CLIENT_IP']) AND strlen($_SERVER['HTTP_CLIENT_IP'])>6 ){
			$ip = strip_tags($_SERVER['HTTP_CLIENT_IP']);
		}elseif(!empty($_SERVER['REMOTE_ADDR']) AND strlen($_SERVER['REMOTE_ADDR'])>6){
			$ip = strip_tags($_SERVER['REMOTE_ADDR']);
		}elseif( !empty($_SERVER['HTTP_X_FORWARDED_FOR']) AND strlen($_SERVER['HTTP_X_FORWARDED_FOR'])>6 ){
			$ip = strip_tags($_SERVER['HTTP_X_FORWARDED_FOR']);
		}//endif
		return strip_tags($ip);
	}

	public static  function loadModulePosition($position, $style = 'none')
	{
		$html 		= '';
		$document	= JFactory::getDocument();
		$renderer	= $document->loadRenderer('module');
		$modules	= JModuleHelper::getModules($position);
		$params		= array('style' => $style);
		ob_start();

		foreach ($modules as $module)
		{
			echo $renderer->render($module, $params);
		}

		$html 	= ob_get_clean();
		return $html;
	}

	/**
	 * Checks if a XML file's structure is valid.
	 * @param $xml	XML string
	 * @return bool
	 */
	public static function isXmlValid($xml) {
		$prev = libxml_use_internal_errors(true);
		$ret = true;
		try {
			$xml = new SimpleXMLElement("<element $xml />");
		} catch(Exception $e) {
			$ret = false;
		}
		if(count(libxml_get_errors()) > 0) {
			// There has been XML errors
			$ret = false;
		}
		// Tidy up.
		libxml_clear_errors();
		libxml_use_internal_errors($prev);
		return $ret;
	}
}
