<?php
/**
 * @package		com_contactenhanced
 * @author		Douglas Machado {@link http://idealextensions.com}
 * @author		Created on 4-Aug-2011
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved.reserved.
 * @license		GNU/GPL, see license.txt
 */
defined('_JEXEC') or die;

/**
 * Utility class for multi-step forms
 *
 * @package	 com_contactenhanced
 * @since	   1.6.4
 */
abstract class CEHtmlSteps
{

	public static $_loaded	= array();
	public static $_opened = false;
	/**
	 * Creates a panes and loads the javascript behavior for it.
	 *
	 * @param   string  The pane identifier.
	 * @param   array   An array of options.
	 * @return  string
	 * @since   1.6.4
	 */
	public static function start($group = 'steps', $params = null)
	{
		self::_loadBehavior($group,$params);
		return '
<!-- CE: Start Form Pagination -->
<div id="'.$group.'" class="step-sliders">
		';
	}

	/**
	 * Close the current pane.
	 *
	 * @return  string
	 * @since   1.6.4
	 */
	public static function end()
	{
		$html = '';
		if (self::$_opened) {
			$html = "		</div>\n"; // close last div
		}
		return $html.'
</div>
<!-- CE: End Pagination -->
';
	}

	/**
	 * Begins the display of a new step.
	 *
	 * @param   string  Text to display.
	 * @param   string  Identifier of the step.
	 * @return  string
	 * @since   1.6.4
	 */
	public static function step($text, $id, $group = 'steps')
	{
		$html =  '
	<!-- CE: START NEW STEP -->
		<h3 class="step-toggler title" id="ce-step-'.$id.'">'.$text.'</h3>
		<div class="step-slider content">
		';
		if (self::$_opened) {
			$html = "		</div>\n".$html; // close last div before opening a new one;
		}
		self::$_opened = true;
		return $html;
	}

	/**
	 * Displays the buttons (next and back).
	 *
	 * @param   string  Text to display.
	 * @param   string  Identifier of the step.
	 * @return  string
	 * @since   1.6.4
	 */
	public static function buttons($group = 'steps', $params)
	{
		$html	= '
			<div id="buttonContainer-'.$group.'" class="ceStepButtonContainer ceStepButtonTheme'.$params->get('theme','Red').'">
		';
			$html	.= '
				<div>
			';
		if($params->get('back-button','button') == 'button'){
			$html	.='
					<button type="button" class="button readon stepButton stepBackButton"  id="step-back-'.$group.'"
						onclick="stepBack(stepGroup'.$group.',ceForm'.$params->get('contactId').'Validator);"
						style="display:none">'
						.'<span class="buttonspan">'
							.JText::_('COM_CONTACTENHANCED_PAGINATION_BUTTON_BACK')
						.'</span></button>
						';
		}elseif($params->get('back-button') == 'link'){

			$html	.= "\n\t".JHtml::_('link'
								, 'javascript:void(0);'
								, '<span>'.(JText::_('COM_CONTACTENHANCED_PAGINATION_BUTTON_BACK')).'</span>'
								, ' id="step-back-'.$group.'" onclick="stepBack(stepGroup'.$group.',ceForm'.$params->get('contactId').'Validator);" style="display:none"');
		}

		$html	.='
					<button type="button" class="button readon stepButton stepNextButton"  id="step-next-'.$group.'">'
						.'<span class="buttonspan" id="step-next-span-'.$group.'">'
							.$params->get('button_text',JText::_('COM_CONTACTENHANCED_PAGINATION_BUTTON_NEXT'))
						.'</span></button>
						';
			$html	.= '
				</div>
			';
		$html	.='</div>
				';

		return $html;
	}

	public static function status($group = 'steps', $numberSteps,$params)
	{
		$html	= '
		<div id="step-progressBar-'.$group.'"
			class="step-progressbar-container ceStepProgressBarTheme'.$params->get('theme','Red').'"
			style="display:none" >
			<div id="step-progress-'.$group.'" class="step-progressbar-progress"></div>
	   		<div id="step-text-'.$group.'" class="step-progressbar-text">'
			.($params->get('pageProgress-bar-text') ? JText::sprintf('COM_CONTACTENHANCED_PAGINATION_STEP_X_OF_X',1,($numberSteps+1)) : '')
			.'</div>
		</div>
		';

		return $html;
	}

	/**
	 * Load the JavaScript behavior.
	 *
	 * @param   string  The pane identifier.
	 * @param   array   Array of options.
	 * @return  void
	 * @since   1.6.4
	 */
	public  static function _loadBehavior($group, $params = array())
	{
		static $loaded=array();
		if (!array_key_exists($group,$loaded))
		{
			$loaded[$group] = true;

			$document = JFactory::getDocument();

			//Language strings used in the Javascript
			JText::script('COM_CONTACTENHANCED_PAGINATION_JS_STEP');
			JText::script('COM_CONTACTENHANCED_PAGINATION_JS_OF');
			$js = "
jQuery(document).ready(function($){
	var {$group}Slider = $( '#{$group}' ).accordion({ header: 'h3' });
});
";

			$document->addScriptDeclaration($js);
		}
	}
}
/*
JS



*/