<?php
/**
 * @version		3.3
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modelitem');

/**
 * @package		com_contactenhanced
* @since 1.5
 */
class ContactenhancedModelContact extends JModelItem
{
	/**
	 * Model context string.
	 *
	 * @var		string
	 */
	protected $_context = 'com_contactenhanced.contact';

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @since	1.6
	 */
	protected function populateState()
	{
		$app = JFactory::getApplication('site');

		// Load state from the request.
		$pk = JRequest::getInt('id');
		$this->setState('contact.id', $pk);

		// Load the parameters.
		$params = $app->getParams();
		$this->setState('params', $params);

		$user = JFactory::getUser();
		if ((!$user->authorise('core.edit.state', 'com_contactenhanced')) &&  (!$user->authorise('core.edit', 'com_contactenhanced'))){
			$this->setState('filter.published', 1);
			$this->setState('filter.archived', 2);
		}
	}

	/**
	 * Gets a list of contacts
	 * @param array
	 * @return mixed Object or null
	 */
	public function &getItem($pk = null)
	{
		// Initialise variables.
		$pk = (!empty($pk)) ? $pk : (int) $this->getState('contact.id');

		if($this->_item === null) {
			$this->_item = array();
		}

		if (!isset($this->_item[$pk])) {
			try
			{
				$db = $this->getDbo();
				$query = $db->getQuery(true);
				//sqlsrv changes
				$case_when = ' CASE WHEN ';
				$case_when .= $query->charLength('a.alias');
				$case_when .= ' THEN ';
				$a_id = $query->castAsChar('a.id');
				$case_when .= $query->concatenate(array($a_id, 'a.alias'), ':');
				$case_when .= ' ELSE ';
				$case_when .= $a_id.' END as slug';

				$case_when1 = ' CASE WHEN ';
				$case_when1 .= $query->charLength('c.alias');
				$case_when1 .= ' THEN ';
				$c_id = $query->castAsChar('c.id');
				$case_when1 .= $query->concatenate(array($c_id, 'c.alias'), ':');
				$case_when1 .= ' ELSE ';
				$case_when1 .= $c_id.' END as catslug';
				$query->select($this->getState('list.select', 'a.*') . ','.$case_when.','.$case_when1);
				//. ' CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(\':\', a.id, a.alias) ELSE a.id END as slug, '
				//. ' CASE WHEN CHAR_LENGTH(c.alias) THEN CONCAT_WS(\':\', c.id, c.alias) ELSE c.id END AS catslug ');
				$query->from('#__ce_details AS a');

				// Join on category table.
				$query->select('c.title AS category_title, c.alias AS category_alias, c.access AS category_access');
				$query->join('LEFT', '#__categories AS c on c.id = a.catid');

				// Join over the categories to get parent category titles
				$query->select('parent.title as parent_title, parent.id as parent_id, parent.path as parent_route, parent.alias as parent_alias');
				$query->join('LEFT', '#__categories as parent ON parent.id = c.parent_id');

				$query->where('a.id = ' . (int) $pk);

				// Filter by start and end dates.
				$nullDate = $db->Quote($db->getNullDate());
				$nowDate = $db->Quote(JFactory::getDate()->toSQL());

				// Filter by published state.
				$published = $this->getState('filter.published');
				$archived = $this->getState('filter.archived');
				if (is_numeric($published)) {
					$query->where('(a.published = ' . (int) $published . ' OR a.published =' . (int) $archived . ')');
					$query->where('(a.publish_up = ' . $nullDate . ' OR a.publish_up <= ' . $nowDate . ')');
					$query->where('(a.publish_down = ' . $nullDate . ' OR a.publish_down >= ' . $nowDate . ')');
				}

				$db->setQuery($query);

				$data = $db->loadObject();

				if($error = $db->getErrorMsg()) {
					throw new Exception($error);
				}

				if (empty($data)) {
					JError::raiseError(404, JText::sprintf('COM_CONTACTENHANCED_ERROR_CONTACT_NOT_FOUND',$pk));
				}

				// Check for published state if filter set.
				if (((is_numeric($published)) || (is_numeric($archived))) && (($data->published != $published) && ($data->published != $archived)))
				{
					JError::raiseError(404, JText::sprintf('COM_CONTACTENHANCED_ERROR_CONTACT_NOT_FOUND',$pk));
				}

				// Convert parameter fields to objects.
				$registry = new JRegistry;
				$registry->loadString($data->params);
				$data->params = clone $this->getState('params');
				$data->params->merge($registry);

				$registry = new JRegistry;
				$registry->loadString($data->metadata);
				$data->metadata = $registry;

				$jversion = new JVersion();
				if(version_compare( $jversion->getShortVersion(), '3.1') >= 0){
					$data->tags = new JHelperTags;
					$data->tags->getTagIds($data->id, 'com_contactenhanced.contact');
				}

				// Compute access permissions.
				if($access = $this->getState('filter.access')) {
					// If the access filter has been set, we already know this user can view.
					$data->params->set('access-view', true);
				}
				else{
					// If no access filter is set, the layout takes some responsibility for display of limited information.
					$user = JFactory::getUser();
					$groups = $user->getAuthorisedViewLevels();

					if($data->catid == 0 || $data->category_access === null) {
						$data->params->set('access-view', in_array($data->access, $groups));
					}
					else{
						$data->params->set('access-view', in_array($data->access, $groups) && in_array($data->category_access, $groups));
					}
				}

				$this->_item[$pk] = $data;
			}
			catch (RuntimeException $e)
			{
				$this->setError($e->getMessage());
				$this->_item[$pk] = false;
			}

		}
		if($this->_item[$pk])
		{
			if($extendedData = $this->getContactQuery($pk)) {
				$this->_item[$pk]->articles = $extendedData->articles;
				$this->_item[$pk]->profile = $extendedData->profile;
			}
		}
  		return $this->_item[$pk];

	}

	public function getCustomFields($catid){
		return CEHelper::getCustomFields($catid);
	}

	protected function  getContactQuery($pk = null)
	{
		// TODO: Cache on the fingerprint of the arguments
		$db		= $this->getDbo();
		$user	= JFactory::getUser();
		$pk = (!empty($pk)) ? $pk : (int) $this->getState('contact.id');

		$query	= $db->getQuery(true);
		if($pk)
		{
			//sqlsrv changes
			$case_when = ' CASE WHEN ';
			$case_when .= $query->charLength('a.alias', '!=', '0');
			$case_when .= ' THEN ';
			$a_id = $query->castAsChar('a.id');
			$case_when .= $query->concatenate(array($a_id, 'a.alias'), ':');
			$case_when .= ' ELSE ';
			$case_when .= $a_id.' END as slug';

			$case_when1 = ' CASE WHEN ';
			$case_when1 .= $query->charLength('cc.alias', '!=', '0');
			$case_when1 .= ' THEN ';
			$c_id = $query->castAsChar('cc.id');
			$case_when1 .= $query->concatenate(array($c_id, 'cc.alias'), ':');
			$case_when1 .= ' ELSE ';
			$case_when1 .= $c_id.' END as catslug';
			$query->select(
				'a.*, cc.access as category_access, cc.title as category_name, '
				. $case_when . ',' . $case_when1
			)

				->from('#__ce_details AS a')

				->join('INNER', '#__categories AS cc on cc.id = a.catid')

				->where('a.id = ' . (int) $pk);
			$published = $this->getState('filter.published');
			$archived = $this->getState('filter.archived');
			if (is_numeric($published))
			{
				$query->where('a.published IN (1,2)')
					->where('cc.published IN (1,2)');
			}
			$groups = implode(',', $user->getAuthorisedViewLevels());
			$query->where('a.access IN ('.$groups.')');

			try
			{
				$db->setQuery($query);
				$result = $db->loadObject();



				if (empty($result))
				{
					throw new Exception(JText::_('COM_CONTACTENHANCED_ERROR_CONTACT_NOT_FOUND'), 404);
				}

				// If we are showing a contact list, then the contact parameters take priority
				// So merge the contact parameters with the merged parameters
				if($this->getState('params')->get('show_contact_list'))
				{
					$registry = new JRegistry;
					$registry->loadString($result->params);
					$this->getState('params')->merge($registry);
				}
			}
			catch (RuntimeException $e)
			{
				$this->setError($e->getMessage());
				return false;
			}
			if($result)
			{
				$user	= JFactory::getUser();
				$groups	= implode(',', $user->getAuthorisedViewLevels());

				//get the content by the linked user
				$query	= $db->getQuery(true)
					->select('a.id')
					->select('a.title')
					->select('a.state')
					->select('a.access')
					->select('a.created');

				// SQL Server changes
				$case_when = ' CASE WHEN ';
				$case_when .= $query->charLength('a.alias', '!=', '0');
				$case_when .= ' THEN ';
				$a_id = $query->castAsChar('a.id');
				$case_when .= $query->concatenate(array($a_id, 'a.alias'), ':');
				$case_when .= ' ELSE ';
				$case_when .= $a_id.' END as slug';
				$case_when1 = ' CASE WHEN ';
				$case_when1 .= $query->charLength('c.alias', '!=', '0');
				$case_when1 .= ' THEN ';
				$c_id = $query->castAsChar('c.id');
				$case_when1 .= $query->concatenate(array($c_id, 'c.alias'), ':');
				$case_when1 .= ' ELSE ';
				$case_when1 .= $c_id.' END as catslug';
				$query->select($case_when1 . ',' . $case_when)
					->from('#__content as a')
					->join('LEFT', '#__categories as c on a.catid=c.id')
					->where('a.created_by = ' . (int) $result->user_id)
					->where('a.access IN ('. $groups.')')
					->order('a.state DESC, a.created DESC');
				// filter per language if plugin published
				if (JLanguageMultilang::isEnabled())
				{
					$query->where(('a.created_by = ' . (int) $result->user_id) AND ('a.language=' . $db->quote(JFactory::getLanguage()->getTag()) . ' OR a.language=' . $db->quote('*')));
				}
				if (is_numeric($published))
				{
					$query->where('a.state IN (1,2)');
				}
				$db->setQuery($query, 0, 10);
				$articles = $db->loadObjectList();
				$result->articles = $articles;

				//get the profile information for the linked user
				require_once JPATH_ADMINISTRATOR.'/components/com_users/models/user.php';
				$userModel = JModelLegacy::getInstance('User', 'UsersModel', array('ignore_request' => true));
				$data = $userModel->getItem((int) $result->user_id);

				JPluginHelper::importPlugin('user');
				$form = new JForm('com_users.profile');
				// Get the dispatcher.
				$dispatcher	= JEventDispatcher::getInstance();

				// Trigger the form preparation event.
				$dispatcher->trigger('onContentPrepareForm', array($form, $data));
				// Trigger the data preparation event.
				$dispatcher->trigger('onContentPrepareData', array('com_users.profile', $data));

				// Load the data into the form after the plugins have operated.
				$form->bind($data);
				$result->profile = $form;

				$this->contact = $result;
				return $result;
			}
		}
	}
	/**
	 * Manage the display mode for contact detail groups
	 * @param object $params
	 */
	function displayParamters(&$params, &$item) {

		if($params->get('show_street_address',1) || $params->get('show_suburb') || $params->get('show_state') || $params->get('show_postcode') || $params->get('show_country')) {
			if (!empty ($item->address) || !empty ($item->suburb) || !empty ($item->state) || !empty ($item->country) || !empty ($item->postcode)) {
				$params->set('address_check', 1);
			}
		}
		else{
			$params->set('address_check', 0);
		}

		$fieldLabels	= ceHelper::getFieldLabels($params);
		
		switch ($params->get('contact_icons'))
			{
				case 1 :
					// text
					foreach ($fieldLabels as $key => $label) {
						$params->set('marker_'.$key,	$label.": ");
					}

					$params->set('marker_class',	'jicons-text');
					break;

				case 2 :
					// none
					foreach ($fieldLabels as $key => $label) {
						$params->set('marker_'.$key,	'');
					}
					$params->set('marker_class',		'jicons-none');
					break;

				default :
					//using Joomla core contact images
					$imageDefaultPath	= 'media/contacts/images/';
					$imageCEPath		= 'components/com_contactenhanced/assets/images/';
					$juri	=	'';
					
					$fieldLabels['address']		= JHTML::_('image',$juri.$params->get('icon_address',	$imageDefaultPath.'con_address.png'), 		$fieldLabels['address'].": ", 	array('title' => $fieldLabels['address']),	false); // had to Set relative to False in order to make it work with SSL
					$fieldLabels['email']		= JHTML::_('image',$juri.$params->get('icon_email',		$imageDefaultPath.'emailButton.png'), 		$fieldLabels['email'].": ", 	array('title' => $fieldLabels['email']),	false);
					$fieldLabels['telephone']	= JHTML::_('image',$juri.$params->get('icon_telephone',	$imageDefaultPath.'con_tel.png'), 			$fieldLabels['telephone'].": ", array('title' => $fieldLabels['telephone']),false);
					$fieldLabels['fax']			= JHTML::_('image',$juri.$params->get('icon_fax',		$imageDefaultPath.'con_fax.png'), 			$fieldLabels['fax']	.": ", 		array('title' => $fieldLabels['fax']),		false);
					$fieldLabels['mobile']		= JHTML::_('image',$juri.$params->get('icon_mobile',	$imageDefaultPath.'con_mobile.png'), 		$fieldLabels['mobile'].": ", 	array('title' => $fieldLabels['mobile']),	false);
					$fieldLabels['skype']		= JHTML::_('image',$juri.$params->get('icon_skype',		$imageCEPath.'skype.png'), 					$fieldLabels['skype'].": ", 	array('title' => $fieldLabels['skype']),	false);
					$fieldLabels['twitter']		= JHTML::_('image',$juri.$params->get('icon_twitter',	$imageCEPath.'twitter.png'),				$fieldLabels['twitter'].": ",	array('title' => $fieldLabels['twitter']),	false);
					$fieldLabels['facebook']	= JHTML::_('image',$juri.$params->get('icon_facebook',	$imageCEPath.'facebook.png'),				$fieldLabels['facebook'].": ",	array('title' => $fieldLabels['facebook']),	false);
					$fieldLabels['linkedin']	= JHTML::_('image',$juri.$params->get('icon_linkedin',	$imageCEPath.'linkedin.png'),				$fieldLabels['linkedin'].": ",	array('title' => $fieldLabels['linkedin']),	false);
					$fieldLabels['website']		= JHTML::_('image',$juri.$params->get('icon_website',	$imageCEPath.'website.png'), 				$fieldLabels['website'].": ",	array('title' => $fieldLabels['website']),	false);
					$fieldLabels['birthdate']	= JHTML::_('image',$juri.$params->get('icon_birthdate',$imageCEPath.'birthdate.png'), 				$fieldLabels['birthdate'].": ", array('title' => $fieldLabels['birthdate']),false);
					$fieldLabels['misc']		= JHTML::_('image',$juri.$params->get('icon_misc',		$imageDefaultPath.'con_info.png'), 			$fieldLabels['misc'].": ",		array('title' => $fieldLabels['misc']),		false);
					
					for($i=1;$i<=10;$i++){
						$fieldLabels['extra_field_'.$i] = JHTML::_('image',$juri.$params->get('icon_extra_field_1',	$imageCEPath.'extra_field.png'),	$fieldLabels['extra_field_'.$i].": ",	array('title' => $fieldLabels['extra_field_'.$i]),	false);
					}
					
					foreach ($fieldLabels as $key => $label) {
						$params->set('marker_'.$key,	$label);
					}
					
					$params->set('marker_class',	'jicons-icons');
					break;
			}
	}

	/**
	 * Gets the URL arguments to append to an item redirect.
	 *
	 * @param	int		$recordId	The primary key id for the item.
	 * @param	string	$urlVar		The name of the URL variable for the id.
	 *
	 * @return	string	The arguments to append to the redirect URL.
	 * @since	1.6
	 */
	protected function getRedirectToItemAppend($recordId = null, $urlVar = 'a_id')
	{
		// Need to override the parent method completely.
		$tmpl		= JRequest::getCmd('tmpl');
		$template	= JRequest::getCmd('template');
		$append		= '';

		// Setup redirect info.
		if($tmpl) {
			$append .= '&tmpl='.$tmpl;
		}
		if($template) {
			$append .= '&template='.$template;
		}

		// TODO This is a bandaid, not a long term solution.
//		if($layout) {
//			$append .= '&layout='.$layout;
//		}
		$append .= '&layout=edit';

		if($recordId) {
			$append .= '&'.$urlVar.'='.$recordId;
		}

		$itemId	= JRequest::getInt('Itemid');
		$return	= $this->getReturnPage();

		if($itemId) {
			$append .= '&Itemid='.$itemId;
		}

		if($return) {
			$append .= '&return='.base64_encode($return);
		}

		return $append;
	}

	/**
	 * Get the return URL.
	 *
	 * If a "return" variable has been passed in the request
	 *
	 * @return	string	The return URL.
	 * @since	1.6
	 */
	protected function getReturnPage()
	{
		$return = JRequest::getVar('return', null, 'default', 'base64');

		if (empty($return) || !JUri::isInternal(base64_decode($return))) {
			return JURI::base();
		}
		else{
			return base64_decode($return);
		}
	}

}

