<?php
/**
 * @version		3.3
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

JHTML::_('behavior.framework');
JHTML::_('behavior.tooltip');

$listOrder	= $this->state->get('list.ordering');
$listDirn	= $this->state->get('list.direction');
$app		= JFactory::getApplication();

?>
<?php if (empty($this->items)) : ?>
	<?php if (empty($this->children[$this->category->id]) OR $this->maxLevel == 0) : ?>
		<p> <?php echo JText::_('COM_CONTACTENHANCED_NO_CONTACTS'); ?>	 </p>
	<?php endif; ?>

<?php else : ?>

<form action="<?php echo htmlspecialchars(JFactory::getURI()->toString()); ?>" method="post" name="adminForm" id="adminForm">
<?php if($this->params->get('show_pagination_limit')  OR $this->params->get('filter_field')) : ?>
	<fieldset class="filters">
	<?php if($this->params->get('filter_field')) :?>
			<div class="btn-group">
			<?php if($this->params->get('filter_field') ==2): ?>
				<select name="search-field" id="search_field" class="input-medium">
					<option value=""><?php echo JText::_('JGLOBAL_FILTER_LABEL');?></option>
					<?php echo JHtml::_('select.options', $this->search_fields, 'value', 'text', $listOrder);?>
				</select>

			<?php else: ?>
				<label	class="filter-search-lbl element-invisible"
						for="filter-search"><?php  echo JText::_('JGLOBAL_FILTER_LABEL').'&#160;'; ?></label>
			<?php endif; ?>
				<input type="search"
					name="filter-search"
					id="filter-search"
					value="<?php echo $this->escape($this->state->get('list.filter')); ?>"
					class="inputbox"
					onchange="document.adminForm.submit();"
					title="<?php echo JText::_('COM_CONTACTENHANCED_FILTER_SEARCH_DESC'); ?>"
					placeholder="<?php echo JText::_('COM_CONTACTENHANCED_FILTER_SEARCH_DESC'); ?>" />
			</div>
		<?php endif; ?>

		<?php if($this->params->get('show_pagination_limit')) : ?>
			<div class="display-limit">
				<?php echo JText::_('JGLOBAL_DISPLAY_NUM'); ?>&#160;
				<?php echo $this->pagination->getLimitBox(); ?>
			</div>
		<?php endif; ?>
	</fieldset>
<?php endif; ?>
	<table class="category table table-bordered table-striped">
		<?php if($this->params->get('show_headings')) :
		$allowOrdering = ($this->params->get('show_headings') == 'ordering' ? true : false);
		?>
		<thead><tr>

		<?php if($this->params->get('show_name_headings',1) OR $this->params->get( 'show_contact_image')) : ?>
			<th class="item-title">
				<?php
				if($allowOrdering){
					echo JHtml::_('grid.sort', $this->fieldLabels['name'], 'a.name', $listDirn, $listOrder);
				}else{
					echo $this->fieldLabels['name'];
				}
				?>
			</th>
		<?php endif; ?>
			<?php if($this->params->get('show_department_headings')) : ?>
			<th class="item-department hidden-phone hidden-xs">
				<?php
				if($allowOrdering){
					echo JHtml::_('grid.sort', $this->fieldLabels['department'], 'a.department', $listDirn, $listOrder);
				}else{
					echo $this->fieldLabels['department'];
				}
				?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_position_headings')) : ?>
			<th class="item-position">
				<?php
				if($allowOrdering){
					echo JHtml::_('grid.sort', $this->fieldLabels['position'], 'a.con_position', $listDirn, $listOrder);
				}else{
					echo $this->fieldLabels['position'];
				}
				?>
			</th>
			<?php endif; ?>


			<?php if($this->params->get('show_email_headings')) : ?>
			<th class="item-email hidden-phone hidden-xs">
				<?php echo $this->fieldLabels['email']; ?>
			</th>
			<?php endif; ?>
			<?php if($this->params->get('show_telephone_headings')) : ?>
			<th class="item-phone">
				<?php echo $this->fieldLabels['telephone']; ?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_mobile_headings')) : ?>
			<th class="item-phone hidden-phone hidden-xs">
				<?php echo $this->fieldLabels['mobile']; ?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_fax_headings')) : ?>
			<th class="item-phone hidden-phone hidden-xs">
				<?php echo $this->fieldLabels['fax']; ?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_street_address_headings')) : ?>
			<th class="item-street-address hidden-phone hidden-xs">
				<?php
				if($allowOrdering){
					echo JHtml::_('grid.sort', $this->fieldLabels['address'], 'a.address', $listDirn, $listOrder);
				}else{
					echo $this->fieldLabels['address'];
				}
				?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_suburb_headings')) : ?>
			<th class="item-suburb hidden-phone hidden-xs">
				<?php
				if($allowOrdering){
					echo JHtml::_('grid.sort', $this->fieldLabels['suburb'], 'a.suburb', $listDirn, $listOrder);
				}else{
					echo $this->fieldLabels['suburb'];
				}
				?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_state_headings')) : ?>
			<th class="item-state hidden-phone hidden-xs">
				<?php
				if($allowOrdering){
					echo JHtml::_('grid.sort', $this->fieldLabels['state'], 'a.state', $listDirn, $listOrder);
				}else{
					echo $this->fieldLabels['state'];
				}
				?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_postcode_headings')) : ?>
			<th class="item-postcode  hidden-phone hidden-xs">
				<?php
				if($allowOrdering){
					echo JHtml::_('grid.sort', $this->fieldLabels['postcode'], 'a.postcode', $listDirn, $listOrder);
				}else{
					echo $this->fieldLabels['postcode'];
				}
				?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_country_headings')) : ?>
			<th class="item-country  hidden-phone hidden-xs">
				<?php
				if($allowOrdering){
					echo JHtml::_('grid.sort', $this->fieldLabels['country'], 'a.country', $listDirn, $listOrder);
				}else{
					echo $this->fieldLabels['country'];
				}
				?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_webpage_headings')) : ?>
			<th class="item-webpage  hidden-phone hidden-xs">
				<?php echo JText::_('COM_CONTACTENHANCED_WEBPAGE'); ?>
			</th>
			<?php endif; ?>
			<?php for ($i = 1; $i <= 10; $i++): ?>
				<?php if($this->params->get('show_extrafield_'.$i.'_headings')) : ?>
				<th class="item-extra_field_<?php echo $i; ?>">
					<?php
					if($allowOrdering){
						echo JHtml::_('grid.sort', $this->fieldLabels['extra_field_'.$i], 'a.extra_field_'.$i, $listDirn, $listOrder);
					}else{
						echo $this->fieldLabels['extra_field_'.$i];
					}
					?>
				</th>
				<?php endif; ?>
			<?php endfor; ?>

			</tr>
		</thead>
		<?php endif; ?>

		<tbody>
			<?php foreach($this->items as $i => $item) : ?>
				<?php
				 if($this->items[$i]->published_state < 1) : ?>
					<tr class="system-unpublished info cat-list-row<?php echo $i % 2; ?>">
				<?php else: ?>
					<tr class="cat-list-row<?php echo $i % 2; ?>" >
				<?php endif; ?>

				<?php if($this->params->get('show_name_headings',1) OR $this->params->get( 'show_contact_image' )) : ?>
					<td class="item-title">
						<?php
						$item->link = JRoute::_(ContactenchancedHelperRoute::getContactRoute($item->slug, $item->catid));
						if($this->params->get( 'show_contact_image' ) == '1' AND $item->image )
						{
							$image = JHTML::_('image',  JURI::base(). $item->image, JText::sprintf('COM_CONTACTENHANCED_CONTACT_IMAGE_ALT',$item->name ), array('align' => 'middle', 'class'=> 'ce-contact-img-cat'));
							echo JHTML::_('link',$item->link,$image, array('class'=>'category'.$this->params->get( 'pageclass_sfx' )) );
							
							if($this->params->get( 'show_name_headings',1 ))
							{
								echo JHTML::_('link',$item->link,$item->name, array('class'=>'category'.$this->params->get( 'pageclass_sfx' )) );
							}
						}
						elseif($this->params->get( 'show_contact_image','tooltip' ) == 'tooltip' AND $item->image)
						{
							$image = JHTML::_('image',  JURI::base(). $item->image, JText::sprintf('COM_CONTACTENHANCED_CONTACT_IMAGE_ALT',$item->name ), array('align' => 'middle', 'class'=> 'ce-contact-img-cat'));
							$image	= JHTML::tooltip($image,$item->name,'',$item->name);
							echo JHTML::_('link',$item->link,$image, array('class'=>'category'.$this->params->get( 'pageclass_sfx' )) );
						}
						elseif ($this->params->get( 'show_name_headings',1 ))
						{
							echo JHTML::_('link',$item->link,$item->name, array('class'=>'category'.$this->params->get( 'pageclass_sfx' )) );
						}
					?>
					</td>
				<?php endif; ?>
					<?php if($this->params->get('show_department_headings')) : ?>
						<td class="item-department hidden-phone hidden-xs">
							<?php echo $item->department; ?>
						</td>
					<?php endif; ?>

					<?php if($this->params->get('show_position_headings')) : ?>
						<td class="item-position">
							<?php echo $item->con_position; ?>
						</td>
					<?php endif; ?>

					<?php if($this->params->get('show_email_headings')) : ?>
						<td class="item-email hidden-phone hidden-xs">
							<?php echo $item->email_to; ?>
						</td>
					<?php endif; ?>

					<?php if($this->params->get('show_telephone_headings')) : ?>
						<td class="item-phone">
							<?php
								$tel	= nl2br($item->telephone);
								if($this->browser->isMobile()){
									$telLink= 'tel:'.preg_replace('[(?!\+\b)\D]', '', $tel);
									$tel	= JHtml::_('link'
														,$telLink
														,$tel
														, array('title' => JText::sprintf('COM_CONTACTENHANCED_CALL_USING_YOUR_PHONE',$tel))
														);
								}
								echo ($tel);
							?>

						</td>
					<?php endif; ?>

					<?php if($this->params->get('show_mobile_headings')) : ?>
						<td class="item-phone   hidden-phone hidden-xs">
							<?php
								$tel	= nl2br($item->mobile);
								if($this->browser->isMobile()){
									$telLink= 'tel:'.preg_replace('[(?!\+\b)\D]', '', $tel);
									$tel	= JHtml::_('link'
														,$telLink
														,$tel
														, array('title' => JText::sprintf('COM_CONTACTENHANCED_CALL_USING_YOUR_PHONE',$tel))
														);
								}
								echo ($tel);
							?>
						</td>
					<?php endif; ?>

					<?php if($this->params->get('show_fax_headings')) : ?>
					<td class="item-phone   hidden-phone hidden-xs">
						<?php echo $item->fax; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_street_address_headings')) : ?>
					<td class="item-street-address">
						<?php echo $item->address; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_suburb_headings')) : ?>
					<td class="item-suburb hidden-phone hidden-xs">
						<?php echo $item->suburb; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_state_headings')) : ?>
					<td class="item-state hidden-phone hidden-xs">
						<?php echo $item->state; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_postcode_headings')) : ?>
					<td class="item-postcode    hidden-phone hidden-xs">
						<?php echo $item->postcode; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_country_headings')) : ?>
					<td class="item-country   hidden-phone hidden-xs">
						<?php echo $item->country; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_webpage_headings')) : ?>
					<td class="item-webpage hidden-phone hidden-xs">
						<?php if($item->webpage): ?>
							<a href="<?php echo $item->webpage; ?>" title="<?php echo $item->webpage; ?>" target="_blank">
							<?php
								if($this->params->get('show_webpage_headings') == 'trim'){
									 echo ceHelper::trimURL(JStringPunycode::urlToUTF8($item->webpage));
								}elseif($this->params->get('show_webpage_headings') == 'label'){
									 echo $this->fieldLabels['webpage'];
								}else{
									echo JStringPunycode::urlToUTF8($item->webpage);
								}
							?></a>
						<?php endif;  ?>
					</td>
					<?php endif; ?>

					<?php for ($i = 1; $i <= 10; $i++): ?>
						<?php if($this->params->get('show_extrafield_'.$i.'_headings')) : ?>
						<td class="item-extra_field_<?php echo $i; ?>">
							<?php
							$field	= "extra_field_".$i;
							 echo $item->$field; ?>
						</td>
						<?php endif; ?>
					<?php endfor; ?>

				</tr>
			<?php endforeach; ?>

		</tbody>
	</table>

	<?php if($this->params->get('show_pagination')) : ?>
	<div class="pagination">
		<?php if($this->params->def('show_pagination_results', 1)) : ?>
		<p class="counter">
			<?php echo $this->pagination->getPagesCounter(); ?>
		</p>
		<?php endif; ?>
		<?php echo $this->pagination->getPagesLinks(); ?>
	</div>
	<?php endif; ?>
	<div>
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
		<input type="hidden" name="state"	value="<?php echo $this->filter_state; ?>" />
		<input type="hidden" name="country" value="<?php echo $this->filter_country; ?>" />
		<input type="hidden" name="suburb"	value="<?php echo $this->filter_suburb; ?>" />
		
		<?php if($app->input->get('template')):?>
			<input type="hidden" name="template"	value="<?php echo $app->input->get('template'); ?>" />
		<?php endif; ?>
		<?php if($app->input->get('tmpl')):?>
			<input type="hidden" name="tmpl"		value="<?php echo $app->input->get('tmpl'); ?>" />
		<?php endif; ?>
		<?php if($app->input->get('catids')):?>
			<input type="hidden" name="catids"		value="<?php echo $app->input->get('catids'); ?>" />
		<?php endif; ?>
	</div>
</form>
<?php endif; ?>
