<?php
 /**
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @license		GNU GPL2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

$canDo		= CEHelper::getActions();
$jversion	= new JVersion();
$user		= JFactory::getUser();
$session 	= JFactory::getSession();
$cparams 	= JComponentHelper::getParams ('com_media');
jimport('joomla.html.html.bootstrap');

if($session->get('contactenhanced_form_submitted') == true) {
	$session->set('contactenhanced_form_submitted', false);
	$doc	= JFactory::getDocument();
	$script	= '';
	$script	.= "
		if(typeof(pageTracker) != 'undefined'){
			pageTracker._trackPageview('/".JText::_("CE_FORM_GA_CONTACT_FORM")."/".$this->contact->alias."');
			console.log('pageTracker :: Google Analytics Page tracked');
		}else if(typeof(_gaq) != 'undefined'){
			_gaq.push(['_trackPageview','/".JText::_("CE_FORM_GA_CONTACT_FORM")."/".$this->contact->alias."']);
			console.log('_gaq.push :: Google Analytics Page tracked');
		}
	";

	if ( $this->params->get( 'thankyoupageType' ) == 'alert' ) {
		$script	.= "alert('".JText::_('COM_CONTACTENHANCED_EMAIL_THANKS')."');";
	}

	$doc->addScriptDeclaration("
jQuery(document).ready(function($){
	{$script}
});
");

}
$containerClass	= '';
if(JRequest::getVar('tmpl') == 'component'){
	$containerClass	= 'ce-contact-modal';
	$this->document->setMetaData('robots', 'noindex, nofollow');
}
?>
<div itemscope itemtype="http://schema.org/Person"
	id="ce-contact-<?php echo $this->contact->id; ?>"
	class="ce-container contact<?php echo $this->params->get('pageclass_sfx'). ' '.$containerClass; ?>">
<?php echo ceHelper::loadModulePosition('ce-before-title');  ?>
<?php if($this->params->get('show_page_heading', 0)) : ?>
<?php // class="title" was added in order to try add compaibility with Gantry based templates?>
<h1 class="title ">
	<?php echo $this->escape($this->params->get('page_heading')); ?>
</h1>
<?php endif; ?>
	<?php if($this->contact->name && $this->params->get('show_name',1)) : ?>
	<div class="page-header">
		<h2>
			<span itemprop="name" class="contact-name"><?php echo $this->contact->name; ?></span>
		</h2>
	</div>
	<?php endif; ?>

	<?php echo ceHelper::loadModulePosition('ce-after-title');  ?>

	<?php if($this->params->get('show_contact_category','hide') == 'show_no_link') : ?>
		<h3>
			<span class="contact-category"><?php echo $this->contact->category_title; ?></span>
		</h3>
	<?php endif; ?>
	<?php if($this->params->get('show_contact_category','hide') == 'show_with_link') : ?>
		<?php $contactLink = ContactenchancedHelperRoute::getCategoryRoute($this->contact->catid);?>
		<h3>
			<span class="contact-category"><a href="<?php echo $contactLink; ?>">
				<?php echo $this->escape($this->contact->category_title); ?></a>
			</span>
		</h3>
	<?php endif; ?>

	<?php
	if(version_compare( $jversion->getShortVersion(), '3.1') >= 0):
		if($this->params->get('show_tags', 1) && !empty($this->item->tags)) :
	?>
		<?php $this->item->tagLayout = new JLayoutFile('joomla.content.tags'); ?>
	<?php
		endif;
	endif; ?>

	<?php
	if (
		($canDo->get('core.edit') OR ($canDo->get('core.edit.own')
			AND $this->contact->user_id == $this->user->get('id'))
			AND $this->contact->user_id > 0
			AND $this->user->get('id') > 1
		)
	):
	?>
		<div class="btn-group pull-right">
			<a class="btn dropdown-toggle" data-toggle="dropdown" href="#"> <span class="glyphicon glyphicon-cog icon icon-cog"></span> <span class="caret"></span> </a>
			<?php // Note the actions class is deprecated. Use dropdown-menu instead. ?>
			<ul class="dropdown-menu actions">
				<li class="edit-icon">
				<?php echo JHtml::_('ceicon.edit', $this->contact, $this->params); ?>
				</li>
			</ul>
		</div>
	<?php
	endif;?>

	<?php echo $this->loadTemplate('introtext'); ?>

	<?php if($this->params->get('show_contact_list') && count($this->contacts) > 1) : ?>
		<form action="#" method="get" name="selectForm" id="selectForm">
			<?php echo JText::_('COM_CONTACTENHANCED_SELECT_CONTACT'); ?>:
			<?php echo JHtml::_('select.genericlist',  $this->contacts, 'id', 'class="inputbox" onchange="document.location.href = this.value"', 'link', 'name', $this->contact->link);?>
		</form>
	<?php endif; ?>

	<?php if($this->params->get('presentation_style') == 'sliders') : ?>
		<?php echo JHtml::_('bootstrap.startAccordion', 'slide-contact', array('active' => 'basic-details')); ?>
	<?php endif; ?>
	<?php if($this->params->get('presentation_style') == 'tabs') : ?>
		<?php echo JHtml::_('bootstrap.startTabSet', 'ceTab', array('active' => 'basic-details')); ?>
	<?php endif; ?>

	<?php
	if($this->params->get('show_contact_details','beforeform') == 'beforeform'){
		echo $this->loadTemplate('details');
	}

	?>

	<?php

		/**
		 * MAP: Before Form
		 */
		if($this->params->get('show_map','beforeform') == 'beforeform') : ?>
		<?php  echo $this->loadTemplate('map');  ?>
	<?php endif; ?>

	<?php

	/**
	 * MISC: Before Form
	 */

	if($this->params->get('show_misc') == 'before_form'){
		echo $this->loadTemplate('misc');
	}
	?>

	<?php if($this->params->get('show_links') == 'before_form') : ?>
		<?php echo $this->loadTemplate('links'); ?>
	<?php endif; ?>

	<?php
		/**
		 * FORM
		 */
	?>
	<?php if($this->params->get('show_email_form',1) && ($this->contact->email_to || $this->contact->user_id)) : ?>
		<?php if($this->params->get('presentation_style') == 'sliders') : ?>
			<?php echo JHtml::_('bootstrap.addSlide', 'slide-contact', JText::_('COM_CONTACTENHANCED_EMAIL_FORM'), 'display-form'); ?>
		<?php endif; ?>
		<?php if($this->params->get('presentation_style') == 'tabs') : ?>
			<?php echo JHtml::_('bootstrap.addTab', 'ceTab', 'display-form', JText::_('COM_CONTACTENHANCED_EMAIL_FORM', true)); ?>
		<?php endif; ?>

		<?php  echo $this->loadTemplate('form');  ?>

		<?php if($this->params->get('presentation_style') == 'sliders') : ?>
			<?php echo JHtml::_('bootstrap.endSlide'); ?>
		<?php endif; ?>
		<?php if($this->params->get('presentation_style') == 'tabs') : ?>
			<?php echo JHtml::_('bootstrap.endTab'); ?>
		<?php endif; ?>

	<?php endif; ?>

	<?php
		/**
		 * MAP: After Form
		 */
	?>
	<?php if($this->params->get('show_map','beforeform') == 'afterform') : ?>
		<?php  echo $this->loadTemplate('map');  ?>
	<?php endif; ?>

	<?php
	if($this->params->get('show_contact_details','beforeform') == 'afterform'){
		echo $this->loadTemplate('details');
	}
	?>

	<?php if($this->params->get('show_articles',0) && $this->contact->user_id && $this->contact->articles) : ?>
		<?php if($this->params->get('presentation_style') == 'sliders') : ?>
			<?php echo JHtml::_('bootstrap.addSlide', 'slide-contact', JText::_('JGLOBAL_ARTICLES'), 'display-articles'); ?>
		<?php endif; ?>
		<?php if($this->params->get('presentation_style') == 'tabs') : ?>
			<?php echo JHtml::_('bootstrap.addTab', 'ceTab', 'display-articles', JText::_('JGLOBAL_ARTICLES', true)); ?>
		<?php endif; ?>
		<?php if($this->params->get('presentation_style') == 'plain'):?>
			<?php echo '<h3>'. JText::_('JGLOBAL_ARTICLES').'</h3>';  ?>
		<?php endif; ?>

			<?php echo $this->loadTemplate('articles'); ?>

		<?php if($this->params->get('presentation_style') == 'sliders') : ?>
			<?php echo JHtml::_('bootstrap.endSlide'); ?>
		<?php endif; ?>
		<?php if($this->params->get('presentation_style') == 'tabs') : ?>
			<?php echo JHtml::_('bootstrap.endTab'); ?>
		<?php endif; ?>

	<?php endif; ?>


	<?php if($this->params->get('show_profile') && $this->contact->user_id && JPluginHelper::isEnabled('user', 'profile')) : ?>
		<?php if($this->params->get('presentation_style') == 'sliders') : ?>
			<?php echo JHtml::_('bootstrap.addSlide', 'slide-contact', JText::_('COM_CONTACTENHANCED_PROFILE'), 'display-profile'); ?>
		<?php endif; ?>
		<?php if($this->params->get('presentation_style') == 'tabs') : ?>
			<?php echo JHtml::_('bootstrap.addTab', 'ceTab', 'display-profile', JText::_('COM_CONTACTENHANCED_PROFILE', true)); ?>
		<?php endif; ?>
		<?php if($this->params->get('presentation_style') == 'plain'):?>
			<?php echo '<h3>'. JText::_('COM_CONTACTENHANCED_PROFILE').'</h3>';  ?>
		<?php endif; ?>

		<?php echo $this->loadTemplate('profile'); ?>

		<?php if($this->params->get('presentation_style') == 'sliders') : ?>
			<?php echo JHtml::_('bootstrap.endSlide'); ?>
		<?php endif; ?>
		<?php if($this->params->get('presentation_style') == 'tabs') : ?>
			<?php echo JHtml::_('bootstrap.endTab'); ?>
		<?php endif; ?>

	<?php endif; ?>

	<?php if($this->params->get('show_links') == 'afterform') : ?>
		<?php echo $this->loadTemplate('links'); ?>
	<?php endif; ?>
	<?php
		// @todo:  added the option in the xml
		if($this->params->get('show_misc') == 'end' OR $this->params->get('show_misc',1) == 1){
			echo $this->loadTemplate('misc');
		}
	?>

	<?php if($this->params->get('presentation_style') == 'sliders') : ?>
		<?php echo JHtml::_('bootstrap.endAccordion'); ?>
	<?php endif; ?>
	<?php if($this->params->get('presentation_style') == 'tabs') : ?>
		<?php echo JHtml::_('bootstrap.endTabSet'); ?>
	<?php endif; ?>
</div>
