<?php
/**
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @author		Douglas Machado {@link http://idealextensions.com}
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

if($this->contact->params->get('qr',0)){
	$app		= JFactory::getApplication();
	$config 	= JFactory::getConfig();
	$doc		= JFactory::getDocument();

	if($config->get('config.debug') ){
		$doc->addScript(JURI::root().'components/com_contactenhanced/assets/js/ce-qrcode-uncompressed.js') ;
	}else{
		$doc->addScript(JURI::root().'components/com_contactenhanced/assets/js/ce-qrcode.js') ;
	}

	$size		= $this->contact->params->get('qr-enabled-size',	'150');		// graphic dimensions pixels
	$ecc		= $this->contact->params->get('qr-enabled-ecc',		'L');		// ecc mode L,M,Q,H (L is lowest/H is highest)
	$type		= $this->contact->params->get('qr-enabled-type',	'vcard');	// ecc mode L,M,Q,H (L is lowest/H is highest)
	$contactId	= $this->contact->id;
	$imageContainer	= "ce-qrcode-contact-{$contactId}";
	$url		= JURI::root();

	$script	= "
(function($){
	ceQRCode.getInfo('{$imageContainer}','{$size}','{$ecc}','{$url}','{$contactId}','{$type}');
})(jQuery);
";

	$doc->addScriptDeclaration($script);
	$style= "width:{$size}px;";

	$html	= '<div class="ce-qrcode-container" style="'.$style.'">';
		$html	.= '<div id="'.$imageContainer.'" class="ce-qrcode" id="ce-qrcode"></div>';
	$html	.= '</div>';

	echo $html;
}
