<?php
/**
 * @version		3.3
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

$listOrder	= $this->state->get('list.ordering');
$listDirn	= $this->state->get('list.direction');

// Create a shortcut for params.
$params = $this->params;
?>

<?php if (empty($this->items)) : ?>
	<p> <?php echo JText::_('COM_CONTACTENHANCED_NO_CONTACTS'); ?>	 </p>
<?php else : ?>

<form action="<?php echo htmlspecialchars(JFilterOutput::ampReplace(JFactory::getURI()->toString())); ?>"
		method="post" name="adminForm" id="adminForm">
	<fieldset class="filters">
	<?php if($this->params->get('show_pagination_limit')) : ?>
		<div class="display-limit">
			<?php echo JText::_('JGLOBAL_DISPLAY_NUM'); ?>&#160;
			<?php echo $this->pagination->getLimitBox(); ?>
		</div>
	<?php endif; ?>
	</fieldset>

	<table  class="category table table-bordered table-striped">
		<?php if($this->params->get('show_headings')) : ?>
		<thead><tr>
			<?php if($this->params->get('show_id_headings')) : ?>
			<th class="item-num">
				<?php echo JText::_('JGLOBAL_NUM'); ?>
			</th>
			<?php endif; ?>

			<th class="item-title">
				<?php //echo JHtml::_('grid.sort', 'COM_CONTACTENHANCED_CONTACT_EMAIL_NAME', 'a.name', $listDirn, $listOrder); ?>
				<?php echo JText::_('COM_CONTACTENHANCED_CONTACT_EMAIL_NAME'); ?>

			</th>
			<?php if($this->params->get('show_department_headings')) : ?>
			<th class="item-department">
				<?php //echo JHtml::_('grid.sort',  'COM_CONTACTENHANCED_POSITION', 'a.con_position', $listDirn, $listOrder); ?>
				<?php echo JText::_('COM_CONTACTENHANCED_DEPARTMENT'); ?>
			</th>
			<?php endif; ?>
			<?php if($this->params->get('show_position_headings')) : ?>
			<th class="item-position">
				<?php //echo JHtml::_('grid.sort',  'COM_CONTACTENHANCED_POSITION', 'a.con_position', $listDirn, $listOrder); ?>
				<?php echo JText::_('COM_CONTACTENHANCED_POSITION'); ?>
			</th>
			<?php endif; ?>
			<?php if($this->params->get('show_email_headings')) : ?>
			<th class="item-email">
				<?php echo JText::_('JGLOBAL_EMAIL'); ?>
			</th>
			<?php endif; ?>
			<?php if($this->params->get('show_telephone_headings')) : ?>
			<th class="item-phone">
				<?php echo JText::_('COM_CONTACTENHANCED_TELEPHONE'); ?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_mobile_headings')) : ?>
			<th class="item-phone">
				<?php echo JText::_('COM_CONTACTENHANCED_MOBILE'); ?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_fax_headings')) : ?>
			<th class="item-phone">
				<?php echo JText::_('COM_CONTACTENHANCED_FAX'); ?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_suburb_headings')) : ?>
			<th class="item-suburb">
				<?php //echo JHtml::_('grid.sort', 'COM_CONTACTENHANCED_SUBURB', 'a.suburb', $listDirn, $listOrder); ?>
				<?php echo JText::_('COM_CONTACTENHANCED_SUBURB'); ?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_state_headings')) : ?>
			<th class="item-state">
				<?php //echo JHtml::_('grid.sort', 'COM_CONTACTENHANCED_STATE', 'a.state', $listDirn, $listOrder); ?>
				<?php echo JText::_('COM_CONTACTENHANCED_STATE'); ?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_country_headings')) : ?>
			<th class="item-state">
				<?php //echo JHtml::_('grid.sort', 'COM_CONTACTENHANCED_COUNTRY', 'a.country', $listDirn, $listOrder); ?>
				<?php echo JText::_('COM_CONTACTENHANCED_COUNTRY'); ?>
			</th>
			<?php endif; ?>

			</tr>
		</thead>
		<?php endif; ?>

		<tbody>
			<?php foreach($this->items as $i => $item) : ?>
				<tr class="<?php echo ($i % 2) ? "odd" : "even"; ?>">
					<?php if($this->params->get('show_id_headings')) : ?>
					<td class="item-num">
						<?php echo $i; ?>
					</td>
					<?php endif; ?>
					<td class="item-title">
						<a href="<?php echo JRoute::_(ContactenchancedHelperRoute::getContactRoute($item->slug, $item->catid)); ?>">
							<?php echo $item->name; ?></a>
					</td>

					<?php if($this->params->get('show_department_headings')) : ?>
						<td class="item-department">
							<?php echo $item->department; ?>
						</td>
					<?php endif; ?>

					<?php if($this->params->get('show_position_headings')) : ?>
						<td class="item-position">
							<?php echo $item->con_position; ?>
						</td>
					<?php endif; ?>

					<?php if($this->params->get('show_email_headings')) : ?>
						<td class="item-email">
							<?php echo $item->email_to; ?>
						</td>
					<?php endif; ?>

					<?php if($this->params->get('show_telephone_headings')) : ?>
						<td class="item-phone">
							<?php echo $item->telephone; ?>
						</td>
					<?php endif; ?>

					<?php if($this->params->get('show_mobile_headings')) : ?>
						<td class="item-phone">
							<?php echo $item->mobile; ?>
						</td>
					<?php endif; ?>

					<?php if($this->params->get('show_fax_headings')) : ?>
					<td class="item-phone">
						<?php echo $item->fax; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_suburb_headings')) : ?>
					<td class="item-suburb">
						<?php echo $item->suburb; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_state_headings')) : ?>
					<td class="item-state">
						<?php echo $item->state; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_country_headings')) : ?>
					<td class="item-state">
						<?php echo $item->country; ?>
					</td>
					<?php endif; ?>
				</tr>
			<?php endforeach; ?>

		</tbody>
	</table>

	<?php if($this->params->def('show_pagination', 2) == 1  || ($this->params->get('show_pagination') == 2 && $this->pagination->get('pages.total') > 1)) : ?>
	<div class="pagination">
		<?php if($this->params->def('show_pagination_results', 1)) : ?>
		<p class="counter">
			<?php echo $this->pagination->getPagesCounter(); ?>
		</p>
		<?php endif; ?>
		<?php echo $this->pagination->getPagesLinks(); ?>
	</div>
	<?php endif; ?>
	<div>
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
	</div>
</form>
<?php endif; ?>

<div class="item-separator"></div>
