<?php

 /**
 * @version		/** $Id: default_form.php 11845 2009-05-27 23:28:59Z robs
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
JHtml::_('bootstrap.tooltip');
$item = &$this->reply;

// Get Contact Name
if(!isset($this->item->contact_link)){
	$this->item->contact_slug = $item->contact_id.':'.$item->contact_alias;
	$item->contact_link = JRoute::_(ContactenchancedHelperRoute::getContactRoute($this->item->contact_slug, $item->catid));
	$this->item->contact_link = $item->contact_link ;
	$this->item->contact_name_link = '';
	$this->item->contact_name_link ='';
	if($this->params->get( 'show_contact_image_message' ) == '1' AND $item->contact_image ){
		$image = JHTML::_('image',  JURI::base(). $item->contact_image, JText::sprintf('COM_CONTACTENHANCED_CONTACT_IMAGE_ALT',$item->contact_name ), array('align' => 'middle', 'class'=> 'ce-contact-img-cat'));
		$this->item->contact_name_link	=  JHTML::_('link',$item->contact_link,$image, array('class'=>'category'.$this->params->get( 'pageclass_sfx' )) );
		$this->item->contact_name_link	.=  JHTML::_('link',$item->contact_link,$item->contact_name, array('class'=>'category'.$this->params->get( 'pageclass_sfx' )) );
	}elseif($this->params->get( 'show_contact_image_message','tooltip' ) == 'tooltip' AND $item->contact_image){
		$image = JHTML::_('image',  JURI::base(). $item->contact_image, JText::sprintf('COM_CONTACTENHANCED_CONTACT_IMAGE_ALT',$item->contact_name ), array('align' => 'middle', 'class'=> 'ce-contact-img-cat'));
		$image	= JHTML::tooltip($image,$item->contact_name,'',$item->contact_name);
		$this->item->contact_name_link	= JHTML::_('link',$item->contact_link,$image, array('class'=>'category'.$this->params->get( 'pageclass_sfx' )) );
	}else{
		$this->item->contact_name_link	= JHTML::_('link',$item->contact_link,$item->contact_name, array('class'=>'category'.$this->params->get( 'pageclass_sfx' )) );
	}
}

// From name and email
$from_info = '<span class="message-name text-success">'. $item->from_name.'</span> '
		.'<span class="message-email text-muted muted"><small> &laquo;'.$item->from_email.'&raquo; </small></span>';
?>

<div class="row-fluid row">
<div class="message-header" id="message-<?php echo $item->id; ?>">

	<?php
		// Email from logged in user or configured to display Admin user email address
		if($this->user->get('id') == $item->from_id
				OR $this->user->get('email') == $item->from_email
				OR $this->params->get('show_contact_name') == 'email'
		){
			echo $from_info;
			$to_info = $this->item->contact_name_link;
		}else{
			echo '<div class="ce-message-from"><span>'.JText::_('CE_MESSAGE_FROM').': </span> '.$this->item->contact_name_link.'</div>';
			$to_info = $item->email_to;
		}
?>

		<?php if(count($item->attachments) > 0):
			$fileList = '';
			foreach($item->attachments as $attachments){
				$attachments	= explode('|',$attachments->value);
				foreach($attachments as $attachment){
					$attachment	= trim($attachment);
					$fileList .= ''.ceHelper::removePrefix($attachment,$item->id.'_')."\n ";
				}
			}
			$attachments	= JHTML::_('link','#message-attachments-'.$item->id, '<i class="icon-paperclip glyphicon glyphicon-paperclip"> </i>');

		?>
			<span class="message-attachment hasTooltip" title="<?php  echo $fileList; ?>">
				<?php echo $attachments; ?>
			</span>
		<?php  endif; ?>
		<?php
			$offset			= JFactory::getConfig()->get('offset');
			$date			= JFactory::getDate($item->date,$offset);
		?>
			<span class="ce-message-date hasTooltip muted text-muted" title="<?php  echo $date->format(JText::_('DATE_FORMAT_LC2')); ?>">
				<i class="icon-calendar glyphicon glyphicon-calendar"> </i> <span> <?php echo ceHelper::timeDifference($item->date,'short'); ?></span>
			</span>
		<div class="ce-message-to"><span><?php echo JText::_('CE_MESSAGE_TO')?>: </span> <?php echo $to_info; ?></div>

	</div>
		<?php if($this->params->get('emailTemplate','plaintext') == 'plaintext' OR empty($item->message_html)):?>
			<pre class="recorded-message-plaintext"><?php echo $item->message; ?></pre>
		<?php else: ?>
			<div class="recorded-message-html"><?php echo $item->message_html; ?></div>
		<?php endif; ?>
		<?php echo ceHelper::formatAttachmentList($item->attachments,$item->id); ?>
</div>
<br style="clear:both" />