<?php
/**
 * @version		3.3
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.view');
require_once JPATH_COMPONENT.'/models/category.php';

/**
 * HTML Contact View class for the Contact component
 *
 * @package		com_contactenhanced
* @since 		1.5
 */
class ContactenhancedViewMessage extends JViewLegacy
{
	protected	$state;
	public		$item;

	function display($tpl = null)
	{

		// Initialise variables.
		$app		= JFactory::getApplication();
		$user		= JFactory::getUser();
		$dispatcher = JDispatcher::getInstance();
		$state		= $this->get('State');
		$item		= $this->get('Item');

		$model		= $this->getModel();

		$jinput 	= $app->input;
		$item->attachments	= $model->getAttachments($jinput->getInt('id'));
		$replies 	= $model->getReplies($jinput->getInt('id'));

		/**
		 * Get reply attachments
		 */
		foreach ($replies as $reply) {
			$reply->attachments		= $model->getAttachments($reply->id);
			$reply->contact_name	= $item->contact_name;
			$reply->contact_image	= $item->contact_image;
			$reply->contact_alias	= $item->contact_alias;
			$reply->contact_id 		= $item->contact_id;
		}

		// Get the parameters of the active menu item
		$menus	= $app->getMenu();
		$menu	= $menus->getActive();
		$params = JComponentHelper::getParams('com_contactenhanced');

		if(is_object($menu) AND isset($menu->params) ){
			$params->merge($menu->params);
		}

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}

		if($user->get('email') != $item->from_email AND $user->get('id') != $item->from_id) {
			JError::raiseWarning(403, JText::_('JERROR_ALERTNOAUTHOR'));
			return;
		}

		$this->assignRef('params',		$params);
		$this->assignRef('state', 		$state);
		$this->assignRef('item', 		$item);
		$this->assignRef('user', 		$user);
		$this->assignRef('replies', 	$replies);

		$this->_prepareDocument();
		parent::display($tpl);
	}

/**
	 * Prepares the document
	 */
	protected function _prepareDocument()
	{
		$app		= JFactory::getApplication();
		$menus		= $app->getMenu();
		$pathway	= $app->getPathway();
		$title 		= null;

		// Because the application sets a default page title,
		// we need to get it from the menu item itself
		$menu = $menus->getActive();

		if($menu) {
			$this->params->def('page_heading', $menu->title ? $menu->title : $this->params->get('page_title'));
			if (!$this->params->def('show_page_heading')) {
				$this->params->set('page_heading', $menu->title ? $menu->title : $this->params->get('page_title'));
			}
		}
		else{
			$this->params->def('page_heading', JText::_('COM_CONTACTENHANCED_DEFAULT_PAGE_TITLE'));
		}

		$title = $this->params->get('page_title', '');

		if (empty($title)) {
			$title = htmlspecialchars_decode($app->getCfg('sitename'));
		}
		elseif($app->getCfg('sitename_pagetitles', 0)) {
			$title = JText::sprintf('JPAGETITLE', htmlspecialchars_decode($app->getCfg('sitename')), $title);
		}

		$this->document->setTitle($title);

	}
}
