<?php
/**
 * @version		1.5.0
 * @package		Joomla
 * @subpackage	Doc Indexer
 * @author  Tuan Pham Ngoc
 * @copyright	Copyright (C) 2010 Ossolution Team
 * @license		GNU/GPL, see LICENSE.php
 */
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );
/**
 * DocIndexer controller
 * @package		Joomla
 * @subpackage	Doc Indexer
 * @since 1.5
 */
class DocIndexerController extends JControllerLegacy
{
	/**
	 * Constructor function
	 *
	 * @param array $config
	 */
	function __construct($config = array())
	{
		parent::__construct($config);	
	}
	/**
	 * Display information
	 *
	 */
	function display( )
	{						
		parent::display();
	}
	/**
	 * Download the selected document
	 *
	 */
	function download() {
		jimport('joomla.filesystem.file') ;
		$db = & JFactory::getDBO() ;
		$id = JRequest::getInt('id', 0) ;
		$sql = "SELECT * FROM #__dix_docs WHERE id=".$id;
		$db->setQuery($sql) ;
		$rowDoc = $db->loadObject();
		if (!$rowDoc) {
			echo 'Invalid document' ;				
		}
		$path = DocIndexerHelper::getConfigValue('documents_path').'/';
		while (@ob_end_clean());
		$filename = $rowDoc->filename ;
		if (!JFile::exists($path.$filename)) {
			global $mainframe ;
			$mainframe->redirect(JRoute::_('index.php'), JText::_('Document is not existed')) ;			
		}
		$sql = 'UPDATE #__dix_docs SET hits = hits + 1 WHERE id='.$id;
		$db->setQuery($sql) ;
		$db->query();
		$fsize = @filesize($path.$filename);
		$mod_date = date('r', filemtime( $path.$filename) );		
		$cont_dis ='attachment';
		$ext = JFile::getExt($filename) ;
		$mime = $this->_getMimeType($ext);
		// required for IE, otherwise Content-disposition is ignored
		if(ini_get('zlib.output_compression'))  {
			ini_set('zlib.output_compression', 'Off');
		}
	    header("Pragma: public");
	    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	    header("Expires: 0");
	
	    header("Content-Transfer-Encoding: binary");
		header('Content-Disposition:' . $cont_dis .';'
			. ' filename="' . JFile::getName($filename) . '";'
			. ' modification-date="' . $mod_date . '";'
			. ' size=' . $fsize .';'
			); //RFC2183
	    header("Content-Type: "    . $mime );			// MIME type
	    header("Content-Length: "  . $fsize);
	
	    if( ! ini_get('safe_mode') ) { // set_time_limit doesn't work in safe mode
		    @set_time_limit(0);
	    }
	    $this->_readfile_chunked($path.$filename);
	}
	/**
	 * Read the file contents
	 *
	 * @param string $filename
	 * @param int $retbytes
	 * @return void
	 */
	function _readfile_chunked($filename,$retbytes=true)
    {
   		$chunksize = 1*(1024*1024); // how many bytes per chunk
   		$buffer = '';
   		$cnt =0;
   		$handle = fopen($filename, 'rb');
   		if ($handle === false) {
       		return false;
   		}
   		while (!feof($handle)) {
       		$buffer = fread($handle, $chunksize);
       		echo $buffer;
			@ob_flush();
			flush();
       		if ($retbytes) {
           		$cnt += strlen($buffer);
       		}
   		}
       $status = fclose($handle);
   	   if ($retbytes && $status) {
       		return $cnt; // return num. bytes delivered like readfile() does.
   		}
   		return $status;
	}
	/**
	 * Get mime type for a file
	 *
	 * @param string $ext
	 * @return string
	 */	
	function _getMimeType($ext)
	{		
		require_once JPATH_ROOT."/components/com_docindexer/helper/mime.mapping.php";
		foreach ($mime_extension_map as $key=>$value)
		{
			if($key==$ext)
			{
				return $value;
			}
		}
		return "";
	}		
}