<?php
/**
 * @package		ContactEnhanced
 * @author		Douglas Machado {@link http://idealextensions.com}
 * @author		Created on 24-Feb-2011
 * @copyright	Copyright (C) 2006 - 2014 iDealExtensions.com, Inc. All rights reserved.
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
class modCEFormHelper{
	static function loadContact(&$pluginParams){
		$app 	= JFactory::getApplication();
		$input	= $app->input;
		$doc	= JFactory::getDocument();
		$session= JFactory::getSession();
		$lang	= JFactory::getLanguage();
		$lang->load('com_contactenhanced',JPATH_ROOT.'/components/com_contactenhanced');
		$lang->load('com_contactenhanced');
		
		require_once(JPATH_BASE .'/components/com_contactenhanced/defines.php');
		require_once(JPATH_BASE .'/components/com_contactenhanced/models/contact.php');
		require_once(JPATH_BASE .'/components/com_contactenhanced/customFields.class.php');
		require_once(JPATH_BASE .'/components/com_contactenhanced/helpers/helper.php');
		require_once(JPATH_BASE .'/components/com_contactenhanced/helpers/route.php');
		
		$html	= '';
		if ($input->getCmd('msgsent')){
//			echo  ceHelper::print_r($session->get('contactenhanced_form_submitted') ); exit;
			if($session->get('contactenhanced_form_submitted') == $pluginParams->get('contactid')){
				if($pluginParams->get('after_submit') == 'javascript'
				){
					$session->set('contactenhanced_form_submitted', 'javascript');
					$doc->addScriptDeclaration("
jQuery(document).ready(function($){alert('".JText::_('COM_CONTACTENHANCED_EMAIL_THANKS')."');});
");
				}elseif(!$pluginParams->get('after_submit-javascript-show_system_message',1)
						AND $pluginParams->get('after_submit') == 'reload')
				{
					$html = '<h3  class="text-info"><i class="icon-ok glyphicon glyphicon-ok"> </i> '.JText::_('COM_CONTACTENHANCED_EMAIL_THANKS').'</h3>';
				}
				if(!$pluginParams->get('after_submit-javascript-show_form')){
					return $html;
				}
			}
		}
		
		//get database
		
		$doc->addStyleSheet(JURI::base(true).'/components/com_contactenhanced/assets/css/ce.css');
		$ceObj			= new JObject();
		$ceObj->params	= $app->getParams('com_contactenhanced');
		$ceObj->user	= JFactory::getUser();
		$style		= '';
		$contactId	= (int) $pluginParams->get('contactid');
		$model		= JModelLegacy::getInstance('Contact', 'ContactenhancedModel', array('ignore_request' => true));
		$model->setState('contact.id', $contactId);
		$model->setState('params', $ceObj->params);

		// query options
		$options['id']		= $contactId;
		$options['aid']		= $ceObj->user->get('aid', 0);

		$ceObj->contact		= $model->getItem( $contactId );

		$ceObj->item		= $ceObj->contact;
		if(!is_object($ceObj->contact)){
			return JText::sprintf('MOD_CE_FORM_THERE_IS_NO_CONTACT_ID',$contactId);
		}
		$ceObj->customfields= $model->getCustomFields( $ceObj->contact->catid);
		// Adds parameter handling
		$registry	= new JRegistry();
		$registry->loadString($ceObj->contact->params);

		$ceObj->contact->params = $registry;

		$ceObj->params->merge($ceObj->contact->params);
		$ceObj->params->merge($pluginParams);
		$ceObj->params->set('plugin_active',1);

		JRequest::setVar( 'content_title',	ceHelper::encode($doc->getTitle() , 'base64') );
		JRequest::setVar( 'content_url',	ceHelper::encode(ceHelper::getCurrentURL(), 'base64'));

		$html 	= '<div class="ce-contact_email ce-module" '.$style.' id="ce-module-contact-'.$contactId.'">';

		$html .= '<div class="row-fluid row">';
		
		$formWidth	= 12;
		if($pluginParams->get('show_sidebar')){
			// sidebar cannot be greater than span9, which in bootstrap is about 75%
			($pluginParams->get('sidebar_width') > 9) ? $sidebar_width = 6 : $sidebar_width = $pluginParams->get('sidebar_width',6);
			$formWidth	= $formWidth - $sidebar_width;
		}
		
		if($pluginParams->get('link-module-title') AND FALSE){
			$contactLink	= ContactenchancedHelperRoute::getContactRoute($contactId,$ceObj->contact->catid );
			$doc->addScriptDeclaration("
window.addEvent('domready', function(){
	var modFormDiv	= document.id('ce-module-contact-".$contactId."');
	var modFormHeading = modFormDiv.getPrevious();
	modFormHeading.set('html','<a href=\"".$contactLink."\" title=\"".$ceObj->contact->name."\">'+modFormHeading.get('html')+'</a>');
});
");
		}
		if($pluginParams->get('introtext')){
				$html 	.= '<div class="ce-introtext">'.$pluginParams->get('introtext').'</div>';
		}
		if($pluginParams->get('after_submit','global') != 'global'){
			$router	= $app->getRouter();
			$vars	= $router->getVars();
			$vars['msgsent']	= 1;
			$ceObj->return = JRoute::_('index.php?'.JURI::buildQuery($vars));
		}
		
		
		if($pluginParams->get('show_map') == 'before_form' OR $pluginParams->get('show_map') == '1'){
			$html	.= self::loadMap($pluginParams, $ceObj);
		}
		if($pluginParams->get('show_contact_details') == 'before_form' OR $pluginParams->get('show_contact_details') == '1'){
			$html	.= modCEFormHelper::loadDetails($pluginParams,$ceObj);

		}
		
		
		if($pluginParams->get('show_misc') == 'before_form'){
			$html	.= $ceObj->contact->misc;
		}
		
		
		if( $pluginParams->get('show_form',1) ){
			if($pluginParams->get('show_sidebar') == 'left') {
				$html	.= '<div class="contact-sidebar span'.$sidebar_width.' col-md-'.$sidebar_width.'"  id="contact-sidebar">
					'.self::loadSidebar($pluginParams,$ceObj).'
				</div>';
			}
			
			$html	.= '<div class="span'.$formWidth.' col-md-'.$formWidth.'" >
				<div class="contact-form" id="contact-form">
					'.ceHelper::loadForm($ceObj, 'plugin').'
				</div>
			</div>';
			
			if($pluginParams->get('show_sidebar') == 'right') {
				$html	.= '<div class="contact-sidebar span'.$sidebar_width.' col-md-'.$sidebar_width.'"  id="contact-sidebar">
					'.self::loadSidebar($pluginParams,$ceObj).'
				</div>';
			}
		}
		
		
		if($pluginParams->get('show_contact_details') == 'after_form' OR $pluginParams->get('show_contact_details') == '2'){
			$html	.= modCEFormHelper::loadDetails($pluginParams,$ceObj);
		}
		if($pluginParams->get('show_map') == 'after_form' OR $pluginParams->get('show_map') == '2'){
			$html	.= self::loadMap($pluginParams, $ceObj);
		}
		if($pluginParams->get('show_misc') == 'end'){
			$html	.= $ceObj->contact->misc;
		}
		if($pluginParams->get('show_map') == 'end'){
			$html	.= self::loadMap($pluginParams, $ceObj);
		}

		if($pluginParams->get('posttext')){
				$html 	.= '<div class="ce-posttext">'.$pluginParams->get('posttext').'</div>';
		}
		$html	.= '</div></div>';
	
		return $html;
	}
	
	static function loadSidebar(&$pluginParams, &$ceObj){
		JFactory::getDocument()->addStyleDeclaration('.ce-module .row-fluid [class*="span"]{margin-left:1%}');
		$html	= '';
		$html	.= $ceObj->contact->sidebar;
		
		if($pluginParams->get('show_map') == 'sidebar'){
			$html	.= self::loadMap($pluginParams, $ceObj);
		}
		
		return $html;
	}
	
	static function loadMap(&$pluginParams, &$ceObj){
		$html	= '';
		if($pluginParams->get('show_contact_details') == 'before_map'){
			$html	.= modCEFormHelper::loadDetails($pluginParams,$ceObj);
		}
		// Load map
		$map 	= ceHelper::loadMap($ceObj,$ceObj->params);
		$html	.= $map->showMap();

		if($pluginParams->get('show_contact_details') == 'after_map'){
			$html	.= ceHelper::loadDetails($ceObj);
		}
		return $html;
	}
	
	static function loadDetails(&$pluginParams, &$ceObj){
		$html	= '';
		$html	.= ceHelper::loadDetails($ceObj);
		$html	.= self::loadExtraFields($ceObj);
		if($pluginParams->get('show_misc') == 'after_details'){
			$html	.= $ceObj->contact->misc;
		}
		return $html;
	}

	private static function loadExtraFields(&$obj){
		$html = '';
		if (	($obj->params->get('show_extrafield_1') AND $obj->contact->extra_field_1)
		|| ($obj->params->get('show_extrafield_2') AND $obj->contact->extra_field_2)
		|| ($obj->params->get('show_extrafield_3') AND $obj->contact->extra_field_3)
		|| ($obj->params->get('show_extrafield_4') AND $obj->contact->extra_field_4)
		|| ($obj->params->get('show_extrafield_5') AND $obj->contact->extra_field_5)
		|| ($obj->params->get('show_extrafield_6') AND $obj->contact->extra_field_6)
		|| ($obj->params->get('show_extrafield_7') AND $obj->contact->extra_field_7)
		|| ($obj->params->get('show_extrafield_8') AND $obj->contact->extra_field_8)
		|| ($obj->params->get('show_extrafield_9') AND $obj->contact->extra_field_9)
		|| ($obj->params->get('show_extrafield_10') AND $obj->contact->extra_field_10)
		){
			$html .= '<div class="contact-extrafields" id="contact-extrafields">';
			for($i=1;$i<=10;$i++) {
				$extra_field	= 'extra_field_'.$i;
				if ($obj->params->get('show_extrafield_'.$i) AND $obj->contact->$extra_field){
					$html .= '<p>';
					if ($obj->params->get('show_extrafield_'.$i) == '1'){
						$html .= '<span class="'.$obj->params->get('marker_class').'" >';
						$html .= $obj->params->get('marker_extra_field_'.$i);
						$html .= '</span>';
					}
					$html .= '<span class="contact-extrafield-'.$i.'" >';
					$html .=  $obj->contact->$extra_field;
					$html .= '</span>';
					$html .= '</p>';
				}
			}
			$html .= '</div>';
		}
		return $html;
	}

}