<?php
/**
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2013 Ideal Extensions for Joomla. All rights reserved.
 * @license		GNU GPL2 or later; see LICENSE.txt
 */

// Make sure this file is called by Joomla
defined('JPATH_BASE') or die;


/**
 * INSTRUCTIONS:
 *
 * This script will change the redirection based on user input (custom field).
 * In this specific case the Custom Field will be a checkbox;
 * The content of the Custom Field will be a pair of value and text like this:
 * Value1::Text 1 | Value2::Text 2
 * Each option is separated by a pipe (|) and the value is separated by two colons (::)
 *
 * In this case the form is to sell online courses and the checkbox value will
 * have also the price for the selected options, so the content will be like this:
 * Course X -- 160.00::Course X | Course Y -- 280.00::Course Y
 */

/**
 * CONFIGURATION:
 */

/**
 * @var int The contact id. The script will only run for the selected contact;
 */
$contactId 	= 31;

/**
 * @var the Form Field's Alias.
 */
$cf_alias 	= 'checkbox';

/**
 * @var string The Redirect URL
 */
$return_url = 'http://google.com/search?q=';

/**
 * @var string A pattern that separates the field's value from the course price
 */
$pattern 	= ' -- ';



/**
 *
 * END OF CONFIGURATION
 *
 *
 */

// The return variable, after validation set throw an exception and set it with the $exception
$return = true;

// If you want to integrate with another component, you might want to load the language files
//$lang = JFactory::getLanguage();
//$lang->load('com_user');


// Get current user if needed
//$user	= JFactory::getUser();

/**
 * @var Object
 */
$db		= JFactory::getDBO();

/**
 * Database query object
 * @var Object
 */
$query	= $db->getQuery(true);

/**
 * Application Object
 * @var Object
 */
$app		= JFactory::getApplication();

/**
 * where post data is saved, you ca also use the $data variable
 * @var Object
 */
$jinput		= $app->input;
/**
 * Contains the Submitted Custom Field's values in the format $data['alias'];
 * In order to know all  Object properties user var_dump($data);
 * @var Array of Objects
 */
$data;
/**
 * Contact information
 * In order to know all  Object properties user var_dump($contact);
 * @var Object
 */
$contact;



/**
 * SCRIPT STARTS
 */

// Only change the redirection for the selected contact id
if($contactId == $contact->id){
	$checkbox 	= $jinput->get($cf_alias, array(), 'ARRAY');
	$total 	= 0;

	foreach ($checkbox as $option){
		$position 	= strpos($option, $pattern) + strlen($pattern);
		$option = intval( substr($option, $position, strlen($option)) );
		$total 	+= $option;
	}
	if($total > 0){
		$emailInfo->return_url 	= $return_url.$total;
	}
}



